/* Based on the stubs from gdb-6.4:
   Remote utility routines for the remote server for GDB.
   Copyright (C) 1986, 1989, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
   2002, 2003, 2004, 2005
   Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

#include <sys/ioctl.h>
#include <netinet/tcp.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/time.h>
#include <unistd.h>
#include <arpa/inet.h>

#include "fireproxy.h"

static struct sockaddr_in sockaddr;
//static
int remote_desc;
int listenfd;

void
remote_open (int port)
{
 //     struct sockaddr_in sockaddr;
      socklen_t tmp;

      listenfd = socket (PF_INET, SOCK_STREAM, 0);
      if (listenfd < 0)
	perror("Can't open socket");

      /* Allow rapid reuse of this port. */
      tmp = 1;
      setsockopt (listenfd, SOL_SOCKET, SO_REUSEADDR, (char *) &tmp,
		  sizeof (tmp));

      sockaddr.sin_family = PF_INET;
      sockaddr.sin_port = htons (port);
      sockaddr.sin_addr.s_addr = INADDR_ANY;

      if (bind (listenfd, (struct sockaddr *) &sockaddr, sizeof (sockaddr))
	  || listen (listenfd, 1))
	perror("Can't bind address");

      fprintf (stderr, "Ready to accept on port %d\n", port);

}

void
remote_accept ()
{
      socklen_t tmp;

      tmp = sizeof (sockaddr);
      remote_desc = accept (listenfd, (struct sockaddr *) &sockaddr, &tmp);
      if (remote_desc == -1)
	perror("Accept failed");

      /* Enable TCP keep alive process. */
      tmp = 1;
      setsockopt (listenfd, SOL_SOCKET, SO_KEEPALIVE, (char *) &tmp, sizeof (tmp));

      /* Tell TCP not to delay small packets.  This greatly speeds up
         interactive response. */
      tmp = 1;
      setsockopt (remote_desc, IPPROTO_TCP, TCP_NODELAY,
		  (char *) &tmp, sizeof (tmp));

      close (listenfd);		/* No longer need this */

      signal (SIGPIPE, SIG_IGN);	/* If we don't do this, then gdbserver simply
					   exits when the remote side dies.  */

      /* Convert IP address to string.  */
      fprintf (stderr, "Remote debugging from host %s\n", 
         inet_ntoa (sockaddr.sin_addr));

  fcntl (remote_desc, F_SETOWN, getpid ());
}

void
remote_close (void)
{
  close (remote_desc);
}
