/* Generated by re2c 0.14.3 */
#line 1 "Zend/zend_ini_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2016 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6
#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

#define ZEND_SYSTEM_INI CG(ini_parser_unbuffered_errors)

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yyleng) {                                 \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng && (                              \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, ZEND_SYSTEM_INI))


#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
ZEND_COLD int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
ZEND_COLD char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

#line 387 "Zend/zend_ini_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 4) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_INITIAL;
			} else {
				goto yyc_ST_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_SECTION_VALUE;
			} else {
				goto yyc_ST_VALUE;
			}
		}
	} else {
		if (YYGETCONDITION() < 6) {
			if (YYGETCONDITION() < 5) {
				goto yyc_ST_SECTION_RAW;
			} else {
				goto yyc_ST_DOUBLE_QUOTES;
			}
		} else {
			if (YYGETCONDITION() < 7) {
				goto yyc_ST_VARNAME;
			} else {
				goto yyc_ST_RAW;
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case '\t':	goto yy5;
		case '\n':	goto yy7;
		case '\r':	goto yy9;
		case ' ':	goto yy10;
		case '!':
		case '"':
		case '$':
		case '&':
		case '(':
		case ')':
		case '^':
		case '{':
		case '|':
		case '}':
		case '~':	goto yy11;
		case '%':
		case '\'':
		case '*':
		case '+':
		case ',':
		case '-':
		case '.':
		case '/':
		case ':':
		case '<':
		case '>':
		case '?':
		case '@':
		case ']':	goto yy13;
		case ';':	goto yy14;
		case '=':	goto yy16;
		case 'F':
		case 'f':	goto yy18;
		case 'N':
		case 'n':	goto yy19;
		case 'O':
		case 'o':	goto yy20;
		case 'T':
		case 't':	goto yy21;
		case 'Y':
		case 'y':	goto yy22;
		case '[':	goto yy23;
		default:	goto yy3;
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy26;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 483 "Zend/zend_ini_scanner.l"
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
#line 524 "Zend/zend_ini_scanner.c"
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy64;
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 629 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 538 "Zend/zend_ini_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 634 "Zend/zend_ini_scanner.l"
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 550 "Zend/zend_ini_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy67;
		goto yy8;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy26;
				if (yych <= '\t') goto yy63;
				goto yy67;
			} else {
				if (yych == '\r') goto yy68;
				goto yy26;
			}
		} else {
			if (yych <= ';') {
				if (yych <= ' ') goto yy65;
				if (yych <= ':') goto yy26;
				goto yy58;
			} else {
				if (yych == '=') goto yy56;
				goto yy26;
			}
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(12, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 557 "Zend/zend_ini_scanner.l"
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
#line 588 "Zend/zend_ini_scanner.c"
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy26;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy59;
		YYDEBUG(15, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 650 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 604 "Zend/zend_ini_scanner.c"
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy57;
yy17:
		YYDEBUG(17, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 493 "Zend/zend_ini_scanner.l"
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW);
	} else {
		yy_push_state(ST_VALUE);
	}
	return '=';
}
#line 622 "Zend/zend_ini_scanner.c"
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy53;
		if (yych == 'a') goto yy53;
		goto yy26;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'O') goto yy44;
			if (yych <= 'T') goto yy26;
			goto yy45;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy26;
				goto yy44;
			} else {
				if (yych == 'u') goto yy45;
				goto yy26;
			}
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'N') {
			if (yych == 'F') goto yy38;
			if (yych <= 'M') goto yy26;
			goto yy31;
		} else {
			if (yych <= 'f') {
				if (yych <= 'e') goto yy26;
				goto yy38;
			} else {
				if (yych == 'n') goto yy31;
				goto yy26;
			}
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy36;
		if (yych == 'r') goto yy36;
		goto yy26;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy27;
		if (yych == 'e') goto yy27;
		goto yy26;
yy23:
		YYDEBUG(23, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(24, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 408 "Zend/zend_ini_scanner.l"
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW);
	} else {
		yy_push_state(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
#line 688 "Zend/zend_ini_scanner.c"
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy26:
		YYDEBUG(26, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy25;
		}
		if (yych <= '=') goto yy4;
		if (yych <= '[') goto yy28;
		goto yy4;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy31;
		if (yych == 's') goto yy31;
		goto yy26;
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy28;
		}
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 433 "Zend/zend_ini_scanner.l"
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
#line 732 "Zend/zend_ini_scanner.c"
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(32, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy31;
		}
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy34;
				} else {
					if (yych != '\r') goto yy25;
				}
			} else {
				if (yych <= '$') {
					if (yych == '#') goto yy25;
				} else {
					if (yych != '&') goto yy25;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= ';') {
					if (yych <= ')') goto yy33;
					if (yych <= ':') goto yy25;
				} else {
					if (yych != '=') goto yy25;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy28;
					if (yych <= ']') goto yy25;
				} else {
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 471 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 782 "Zend/zend_ini_scanner.c"
yy34:
		YYDEBUG(34, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(35, *YYCURSOR);
		if (yych == '\t') goto yy34;
		if (yych == ' ') goto yy34;
		goto yy33;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy37;
		if (yych != 'u') goto yy26;
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy31;
		if (yych == 'e') goto yy31;
		goto yy26;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy39;
		if (yych != 'f') goto yy26;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(40, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy42;
				} else {
					if (yych != '\r') goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych >= '#') goto yy25;
				} else {
					if (yych == '%') goto yy25;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy25;
					if (yych >= '*') goto yy25;
				} else {
					if (yych == '<') goto yy25;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy25;
				} else {
					if (yych <= '^') goto yy41;
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 475 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 856 "Zend/zend_ini_scanner.c"
yy42:
		YYDEBUG(42, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(43, *YYCURSOR);
		if (yych == '\t') goto yy42;
		if (yych == ' ') goto yy42;
		goto yy41;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy26;
					if (yych <= '\t') goto yy42;
					goto yy41;
				} else {
					if (yych == '\r') goto yy41;
					goto yy26;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy39;
					if (yych <= '"') goto yy41;
					goto yy26;
				} else {
					if (yych == '%') goto yy26;
					if (yych <= '&') goto yy41;
					goto yy26;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= ';') {
					if (yych <= ')') goto yy41;
					if (yych <= ':') goto yy26;
					goto yy41;
				} else {
					if (yych == '=') goto yy41;
					if (yych <= 'M') goto yy26;
					goto yy52;
				}
			} else {
				if (yych <= 'm') {
					if (yych == '^') goto yy41;
					goto yy26;
				} else {
					if (yych <= 'n') goto yy52;
					if (yych <= 'z') goto yy26;
					if (yych <= '~') goto yy41;
					goto yy26;
				}
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy46;
		if (yych != 'l') goto yy26;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy47;
		if (yych != 'l') goto yy26;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy50;
				} else {
					if (yych != '\r') goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy47;
					if (yych >= '#') goto yy25;
				} else {
					if (yych == '%') goto yy25;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy25;
					if (yych >= '*') goto yy25;
				} else {
					if (yych == '<') goto yy25;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy25;
				} else {
					if (yych <= '^') goto yy49;
					if (yych <= 'z') goto yy25;
					if (yych >= 0x7F) goto yy25;
				}
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 479 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 971 "Zend/zend_ini_scanner.c"
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(51, *YYCURSOR);
		if (yych == '\t') goto yy50;
		if (yych == ' ') goto yy50;
		goto yy49;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy26;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy54;
		if (yych != 'l') goto yy26;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy55;
		if (yych != 's') goto yy26;
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy26;
yy56:
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy57:
		YYDEBUG(57, *YYCURSOR);
		if (yych == '\t') goto yy56;
		if (yych == ' ') goto yy56;
		goto yy17;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy59:
		YYDEBUG(59, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy58;
		}
		if (yych >= '\v') goto yy62;
yy60:
		YYDEBUG(60, *YYCURSOR);
		++YYCURSOR;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 639 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1036 "Zend/zend_ini_scanner.c"
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy60;
		goto yy61;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy64:
		YYDEBUG(64, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy6;
				if (yych <= '\t') goto yy63;
				goto yy67;
			} else {
				if (yych == '\r') goto yy68;
				goto yy6;
			}
		} else {
			if (yych <= ';') {
				if (yych <= ' ') goto yy63;
				if (yych <= ':') goto yy6;
				goto yy58;
			} else {
				if (yych == '=') goto yy56;
				goto yy6;
			}
		}
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(66, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy25;
					if (yych <= '\t') goto yy63;
				} else {
					if (yych == '\r') goto yy68;
					goto yy25;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy65;
					if (yych <= '"') goto yy4;
					goto yy25;
				} else {
					if (yych == '%') goto yy25;
					goto yy4;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '\'') goto yy25;
					if (yych <= ')') goto yy4;
					goto yy25;
				} else {
					if (yych <= ';') goto yy58;
					if (yych <= '<') goto yy25;
					goto yy56;
				}
			} else {
				if (yych <= ']') {
					if (yych == '[') goto yy28;
					goto yy25;
				} else {
					if (yych <= '^') goto yy4;
					if (yych <= 'z') goto yy25;
					if (yych <= '~') goto yy4;
					goto yy25;
				}
			}
		}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy8;
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy67;
		goto yy8;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(69, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy73;
		if (yych == '$') goto yy75;
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 589 "Zend/zend_ini_scanner.l"
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
#line 1211 "Zend/zend_ini_scanner.c"
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy79;
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 584 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
#line 1225 "Zend/zend_ini_scanner.c"
yy75:
		YYDEBUG(75, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy72;
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 1239 "Zend/zend_ini_scanner.c"
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy79:
		YYDEBUG(79, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy78;
		}
		goto yy74;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66, 194,  64,  66,  66,  64,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			194,  66,  64,  66,  68,  66,  66,   0, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114,  66,  64,  66,  66,  66,  66, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  72,  64,  66,  82, 
			 66,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
			 66,  66,  66,  66,  66,  66,  66,  66, 
		};
		YYDEBUG(80, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy82;
					if (yych <= '\t') goto yy84;
					goto yy85;
				} else {
					if (yych == '\r') goto yy85;
					if (yych >= ' ') goto yy84;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy87;
					if (yych >= '$') goto yy89;
				} else {
					if (yych == '\'') goto yy90;
					if (yych >= '-') goto yy91;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy92;
					if (yych >= '0') goto yy93;
				} else {
					if (yych == ';') goto yy85;
					if (yych >= 'A') goto yy95;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy82;
					if (yych <= '\\') goto yy97;
					if (yych <= ']') goto yy98;
				} else {
					if (yych == '`') goto yy82;
					if (yych <= 'z') goto yy95;
				}
			}
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy101;
yy83:
		YYDEBUG(83, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 575 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 1343 "Zend/zend_ini_scanner.c"
yy84:
		YYDEBUG(84, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy127;
		}
		if (yych == '"') goto yy129;
		if (yych == ']') goto yy130;
		goto yy101;
yy85:
		YYDEBUG(85, *YYCURSOR);
		++YYCURSOR;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 650 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 1364 "Zend/zend_ini_scanner.c"
yy87:
		YYDEBUG(87, *YYCURSOR);
		++YYCURSOR;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 579 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 1376 "Zend/zend_ini_scanner.c"
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy86;
			if (yych <= '[') goto yy100;
			goto yy105;
		} else {
			if (yych == '{') goto yy125;
			goto yy100;
		}
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy121;
		}
		goto yy86;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy101;
		if (yych <= '9') goto yy119;
		goto yy101;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy101;
		if (yych <= '9') goto yy117;
		goto yy101;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy94;
				if (yych <= '\f') goto yy101;
			} else {
				if (yych == '"') goto yy94;
				if (yych <= '&') goto yy101;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy113;
				if (yych <= '/') goto yy101;
				goto yy115;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy101;
				} else {
					if (yych != ']') goto yy101;
				}
			}
		}
yy94:
		YYDEBUG(94, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 553 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 1442 "Zend/zend_ini_scanner.c"
yy95:
		YYDEBUG(95, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy111;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy101;
			} else {
				if (yych <= '\r') goto yy96;
				if (yych <= '!') goto yy101;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy101;
			} else {
				if (yych <= ';') goto yy96;
				if (yych != ']') goto yy101;
			}
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 549 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 1472 "Zend/zend_ini_scanner.c"
yy97:
		YYDEBUG(97, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy100;
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 446 "Zend/zend_ini_scanner.l"
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
#line 1488 "Zend/zend_ini_scanner.c"
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy101:
		YYDEBUG(101, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy100;
		}
		if (yych <= '"') goto yy83;
		if (yych <= '$') goto yy103;
		if (yych <= ';') goto yy83;
		if (yych >= ']') goto yy83;
yy102:
		YYDEBUG(102, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy100;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy104;
			if (yych <= '[') goto yy100;
			goto yy105;
		} else {
			if (yych != '{') goto yy100;
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy83;
			} else {
				goto yy86;
			}
		} else {
			if (yyaccept == 2) {
				goto yy94;
			} else {
				goto yy96;
			}
		}
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy106;
		}
		if (yych == '\\') goto yy108;
		goto yy100;
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(107, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy106;
		}
		if (yych == '\\') goto yy110;
		goto yy100;
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy106;
		}
		if (yych == '\\') goto yy108;
		goto yy100;
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy106;
		}
		if (yych == '\\') goto yy108;
		goto yy100;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(112, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy111;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy96;
				if (yych <= '\f') goto yy100;
				goto yy96;
			} else {
				if (yych == '"') goto yy96;
				if (yych <= '#') goto yy100;
				goto yy103;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy96;
				if (yych <= ':') goto yy100;
				goto yy96;
			} else {
				if (yych <= '[') goto yy100;
				if (yych <= '\\') goto yy102;
				if (yych <= ']') goto yy96;
				goto yy100;
			}
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(114, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy113;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy94;
				if (yych <= '\f') goto yy100;
				goto yy94;
			} else {
				if (yych == '"') goto yy94;
				if (yych <= '#') goto yy100;
				goto yy103;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy94;
				if (yych <= ':') goto yy100;
				goto yy94;
			} else {
				if (yych <= '[') goto yy100;
				if (yych <= '\\') goto yy102;
				if (yych <= ']') goto yy94;
				goto yy100;
			}
		}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(116, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy100;
					goto yy94;
				} else {
					if (yych == '\r') goto yy94;
					goto yy100;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy94;
					goto yy100;
				} else {
					if (yych <= '$') goto yy103;
					if (yych <= '&') goto yy100;
					goto yy94;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy100;
					goto yy113;
				} else {
					if (yych <= '/') goto yy100;
					if (yych <= '9') goto yy115;
					goto yy100;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy94;
					goto yy100;
				} else {
					if (yych <= '\\') goto yy102;
					if (yych <= ']') goto yy94;
					goto yy100;
				}
			}
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(118, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy94;
				if (yych <= '\f') goto yy100;
				goto yy94;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy100;
					goto yy94;
				} else {
					if (yych == '$') goto yy103;
					goto yy100;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy94;
				if (yych <= '/') goto yy100;
				if (yych <= '9') goto yy117;
				goto yy100;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy94;
					goto yy100;
				} else {
					if (yych <= '\\') goto yy102;
					if (yych <= ']') goto yy94;
					goto yy100;
				}
			}
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy94;
				if (yych <= '\f') goto yy100;
				goto yy94;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy100;
					goto yy94;
				} else {
					if (yych == '$') goto yy103;
					goto yy100;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy94;
				if (yych <= '/') goto yy100;
				if (yych <= '9') goto yy119;
				goto yy100;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy94;
					goto yy100;
				} else {
					if (yych <= '\\') goto yy102;
					if (yych <= ']') goto yy94;
					goto yy100;
				}
			}
		}
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(122, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy121;
		}
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 418 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1789 "Zend/zend_ini_scanner.c"
yy125:
		YYDEBUG(125, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(126, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 1800 "Zend/zend_ini_scanner.c"
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(128, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy127;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy100;
				if (yych <= '\n') goto yy83;
				if (yych <= '\f') goto yy100;
				goto yy83;
			} else {
				if (yych == '"') goto yy129;
				if (yych <= '#') goto yy100;
				goto yy103;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy83;
				if (yych <= ':') goto yy100;
				goto yy83;
			} else {
				if (yych <= '[') goto yy100;
				if (yych <= '\\') goto yy102;
				if (yych <= ']') goto yy130;
				goto yy100;
			}
		}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy88;
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy99;
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(131, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) {
				if (yych >= 0x01) goto yy135;
			} else {
				if (yych <= '\t') goto yy137;
				if (yych <= '\n') goto yy138;
				goto yy135;
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') goto yy140;
				if (yych <= 0x1F) goto yy135;
				goto yy137;
			} else {
				if (yych == ';') goto yy141;
				goto yy135;
			}
		}
		YYDEBUG(133, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 645 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 1911 "Zend/zend_ini_scanner.c"
yy135:
		YYDEBUG(135, *YYCURSOR);
		++YYCURSOR;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 502 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yyleng > 1 && yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 1955 "Zend/zend_ini_scanner.c"
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy136;
			if (yych <= '\n') goto yy149;
			if (yych <= '\f') goto yy136;
			goto yy149;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy136;
				goto yy149;
			} else {
				if (yych == ';') goto yy149;
				goto yy136;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 543 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 1986 "Zend/zend_ini_scanner.c"
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy147;
		goto yy139;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy143;
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy142;
		}
		if (yych >= '\v') goto yy146;
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 639 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2020 "Zend/zend_ini_scanner.c"
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy144;
		goto yy145;
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy139;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy149:
		YYDEBUG(149, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy148;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy150;
			if (yych <= '\n') goto yy147;
		} else {
			if (yych <= '\r') goto yy151;
			if (yych == ';') goto yy142;
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 629 "Zend/zend_ini_scanner.l"
		{
	/* eat whitespace */
	goto restart;
}
#line 2056 "Zend/zend_ini_scanner.c"
yy151:
		YYDEBUG(151, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy147;
		goto yy139;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 192,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			192, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(152, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych == '\n') goto yy156;
		} else {
			if (yych <= '\r') goto yy156;
			if (yych == ']') goto yy158;
		}
		YYDEBUG(154, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy165;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 539 "Zend/zend_ini_scanner.l"
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2120 "Zend/zend_ini_scanner.c"
yy156:
		YYDEBUG(156, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(157, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 650 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2130 "Zend/zend_ini_scanner.c"
yy158:
		YYDEBUG(158, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy161;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 427 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2145 "Zend/zend_ini_scanner.c"
yy160:
		YYDEBUG(160, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy161:
		YYDEBUG(161, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy160;
		}
		if (yych <= 0x08) goto yy159;
		if (yych <= '\n') goto yy162;
		if (yych == '\r') goto yy163;
		goto yy159;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy159;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy162;
		goto yy159;
yy164:
		YYDEBUG(164, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy165:
		YYDEBUG(165, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy164;
		}
		goto yy155;
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 134, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			134, 132, 128, 132, 136, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			228, 228, 228, 228, 228, 228, 228, 228, 
			228, 228, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 144, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(166, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x08) goto yy168;
					if (yych <= '\t') goto yy170;
					goto yy171;
				} else {
					if (yych == '\r') goto yy171;
					if (yych >= ' ') goto yy170;
				}
			} else {
				if (yych <= '$') {
					if (yych == '"') goto yy173;
					if (yych >= '$') goto yy175;
				} else {
					if (yych == '\'') goto yy176;
					if (yych >= '-') goto yy177;
				}
			}
		} else {
			if (yych <= 'Z') {
				if (yych <= '9') {
					if (yych <= '.') goto yy178;
					if (yych >= '0') goto yy179;
				} else {
					if (yych == ';') goto yy171;
					if (yych >= 'A') goto yy181;
				}
			} else {
				if (yych <= '^') {
					if (yych <= '[') goto yy168;
					if (yych <= '\\') goto yy183;
					if (yych <= ']') goto yy184;
				} else {
					if (yych == '`') goto yy168;
					if (yych <= 'z') goto yy181;
				}
			}
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy191;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 575 "Zend/zend_ini_scanner.l"
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2272 "Zend/zend_ini_scanner.c"
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy217;
			goto yy191;
		} else {
			if (yych <= ' ') goto yy217;
			if (yych == '"') goto yy219;
			goto yy191;
		}
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 650 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 2295 "Zend/zend_ini_scanner.c"
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 579 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 2307 "Zend/zend_ini_scanner.c"
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy172;
			if (yych <= '[') goto yy190;
			goto yy195;
		} else {
			if (yych == '{') goto yy215;
			goto yy190;
		}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy211;
		}
		goto yy172;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy191;
		if (yych <= '9') goto yy209;
		goto yy191;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy191;
		if (yych <= '9') goto yy207;
		goto yy191;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy180;
				if (yych <= '\f') goto yy191;
			} else {
				if (yych == '"') goto yy180;
				if (yych <= '&') goto yy191;
			}
		} else {
			if (yych <= '9') {
				if (yych == '.') goto yy203;
				if (yych <= '/') goto yy191;
				goto yy205;
			} else {
				if (yych <= ';') {
					if (yych <= ':') goto yy191;
				} else {
					if (yych != ']') goto yy191;
				}
			}
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 553 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 2373 "Zend/zend_ini_scanner.c"
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy201;
		}
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych != '\n') goto yy191;
			} else {
				if (yych <= '\r') goto yy182;
				if (yych <= '!') goto yy191;
			}
		} else {
			if (yych <= ':') {
				if (yych != '\'') goto yy191;
			} else {
				if (yych <= ';') goto yy182;
				if (yych != ']') goto yy191;
			}
		}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 549 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 2403 "Zend/zend_ini_scanner.c"
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy190;
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy187;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 427 "Zend/zend_ini_scanner.l"
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
#line 2422 "Zend/zend_ini_scanner.c"
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy187:
		YYDEBUG(187, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy186;
		}
		if (yych <= 0x08) goto yy185;
		if (yych <= '\n') goto yy188;
		if (yych == '\r') goto yy189;
		goto yy185;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy185;
yy189:
		YYDEBUG(189, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy188;
		goto yy185;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy191:
		YYDEBUG(191, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy190;
		}
		if (yych <= '"') goto yy169;
		if (yych <= '$') goto yy193;
		if (yych <= ';') goto yy169;
		if (yych >= ']') goto yy169;
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy190;
yy193:
		YYDEBUG(193, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy194;
			if (yych <= '[') goto yy190;
			goto yy195;
		} else {
			if (yych != '{') goto yy190;
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy169;
			} else {
				goto yy172;
			}
		} else {
			if (yyaccept == 2) {
				goto yy180;
			} else {
				goto yy182;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy196;
		}
		if (yych == '\\') goto yy198;
		goto yy190;
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy196;
		}
		if (yych == '\\') goto yy200;
		goto yy190;
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy196;
		}
		if (yych == '\\') goto yy198;
		goto yy190;
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy196;
		}
		if (yych == '\\') goto yy198;
		goto yy190;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(202, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy201;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy182;
				if (yych <= '\f') goto yy190;
				goto yy182;
			} else {
				if (yych == '"') goto yy182;
				if (yych <= '#') goto yy190;
				goto yy193;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy182;
				if (yych <= ':') goto yy190;
				goto yy182;
			} else {
				if (yych <= '[') goto yy190;
				if (yych <= '\\') goto yy192;
				if (yych <= ']') goto yy182;
				goto yy190;
			}
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy203;
		}
		if (yych <= '$') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy180;
				if (yych <= '\f') goto yy190;
				goto yy180;
			} else {
				if (yych == '"') goto yy180;
				if (yych <= '#') goto yy190;
				goto yy193;
			}
		} else {
			if (yych <= ';') {
				if (yych == '\'') goto yy180;
				if (yych <= ':') goto yy190;
				goto yy180;
			} else {
				if (yych <= '[') goto yy190;
				if (yych <= '\\') goto yy192;
				if (yych <= ']') goto yy180;
				goto yy190;
			}
		}
yy205:
		YYDEBUG(205, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yych <= '\'') {
			if (yych <= '!') {
				if (yych <= '\n') {
					if (yych <= '\t') goto yy190;
					goto yy180;
				} else {
					if (yych == '\r') goto yy180;
					goto yy190;
				}
			} else {
				if (yych <= '#') {
					if (yych <= '"') goto yy180;
					goto yy190;
				} else {
					if (yych <= '$') goto yy193;
					if (yych <= '&') goto yy190;
					goto yy180;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '.') {
					if (yych <= '-') goto yy190;
					goto yy203;
				} else {
					if (yych <= '/') goto yy190;
					if (yych <= '9') goto yy205;
					goto yy190;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy180;
					goto yy190;
				} else {
					if (yych <= '\\') goto yy192;
					if (yych <= ']') goto yy180;
					goto yy190;
				}
			}
		}
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(208, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy180;
				if (yych <= '\f') goto yy190;
				goto yy180;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy190;
					goto yy180;
				} else {
					if (yych == '$') goto yy193;
					goto yy190;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy180;
				if (yych <= '/') goto yy190;
				if (yych <= '9') goto yy207;
				goto yy190;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy180;
					goto yy190;
				} else {
					if (yych <= '\\') goto yy192;
					if (yych <= ']') goto yy180;
					goto yy190;
				}
			}
		}
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(210, *YYCURSOR);
		if (yych <= '&') {
			if (yych <= '\r') {
				if (yych == '\n') goto yy180;
				if (yych <= '\f') goto yy190;
				goto yy180;
			} else {
				if (yych <= '"') {
					if (yych <= '!') goto yy190;
					goto yy180;
				} else {
					if (yych == '$') goto yy193;
					goto yy190;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '\'') goto yy180;
				if (yych <= '/') goto yy190;
				if (yych <= '9') goto yy209;
				goto yy190;
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy180;
					goto yy190;
				} else {
					if (yych <= '\\') goto yy192;
					if (yych <= ']') goto yy180;
					goto yy190;
				}
			}
		}
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy211;
		}
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 418 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 2746 "Zend/zend_ini_scanner.c"
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(216, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 2757 "Zend/zend_ini_scanner.c"
yy217:
		YYDEBUG(217, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy190;
				if (yych <= '\t') goto yy217;
				if (yych <= '\n') goto yy169;
				goto yy190;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy169;
					goto yy190;
				} else {
					if (yych <= ' ') goto yy217;
					if (yych <= '!') goto yy190;
				}
			}
		} else {
			if (yych <= ':') {
				if (yych <= '$') {
					if (yych <= '#') goto yy190;
					goto yy193;
				} else {
					if (yych == '\'') goto yy169;
					goto yy190;
				}
			} else {
				if (yych <= '[') {
					if (yych <= ';') goto yy169;
					goto yy190;
				} else {
					if (yych <= '\\') goto yy192;
					if (yych <= ']') goto yy169;
					goto yy190;
				}
			}
		}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy174;
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			160, 162, 162, 162, 162, 162, 162, 162, 
			162, 176, 128, 162, 162, 128, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			176, 160, 160, 162, 168, 162, 160,  32, 
			160, 160, 162, 162, 162, 162, 162, 162, 
			230, 230, 230, 230, 230, 230, 230, 230, 
			230, 230, 162, 160, 162, 160, 162, 162, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 162, 162, 160, 166, 
			162, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 166, 166, 166, 166, 166, 
			166, 166, 166, 162, 160, 162, 160, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
			162, 162, 162, 162, 162, 162, 162, 162, 
		};
		YYDEBUG(220, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:	goto yy222;
		case '\t':
		case ' ':	goto yy226;
		case '\n':	goto yy228;
		case '\r':	goto yy230;
		case '!':
		case '&':
		case '(':
		case ')':
		case '^':
		case '|':
		case '~':	goto yy231;
		case '"':	goto yy233;
		case '$':	goto yy235;
		case '\'':	goto yy236;
		case '-':	goto yy237;
		case '.':	goto yy238;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy239;
		case ';':	goto yy241;
		case '=':	goto yy242;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'z':	goto yy244;
		case 'F':
		case 'f':	goto yy246;
		case 'N':
		case 'n':	goto yy247;
		case 'O':
		case 'o':	goto yy248;
		case 'T':
		case 't':	goto yy249;
		case 'Y':
		case 'y':	goto yy250;
		default:	goto yy224;
		}
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
yy223:
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 645 "Zend/zend_ini_scanner.l"
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 2943 "Zend/zend_ini_scanner.c"
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy252;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 571 "Zend/zend_ini_scanner.l"
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
#line 2956 "Zend/zend_ini_scanner.c"
yy226:
		YYDEBUG(226, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy306;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 625 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
#line 2969 "Zend/zend_ini_scanner.c"
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 543 "Zend/zend_ini_scanner.l"
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 2982 "Zend/zend_ini_scanner.c"
yy230:
		YYDEBUG(230, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy304;
		goto yy229;
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy303;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 561 "Zend/zend_ini_scanner.l"
		{ /* Boolean operators */
	return yytext[0];
}
#line 3000 "Zend/zend_ini_scanner.c"
yy233:
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 579 "Zend/zend_ini_scanner.l"
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
#line 3012 "Zend/zend_ini_scanner.c"
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy223;
			if (yych <= '[') goto yy251;
			goto yy258;
		} else {
			if (yych == '{') goto yy300;
			goto yy251;
		}
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy296;
		}
		goto yy223;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy252;
		if (yych <= '9') goto yy294;
		goto yy252;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy252;
		if (yych <= '9') goto yy292;
		goto yy252;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy240;
					if (yych <= 0x08) goto yy252;
				} else {
					if (yych != '\r') goto yy252;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy240;
					if (yych <= '%') goto yy252;
				} else {
					if (yych == '.') goto yy288;
					goto yy252;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy290;
					if (yych <= ':') goto yy252;
				} else {
					if (yych != '=') goto yy252;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy240;
					if (yych <= '{') goto yy252;
				} else {
					if (yych != '~') goto yy252;
				}
			}
		}
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 553 "Zend/zend_ini_scanner.l"
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
#line 3091 "Zend/zend_ini_scanner.c"
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		goto yy284;
yy242:
		YYDEBUG(242, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 565 "Zend/zend_ini_scanner.l"
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
#line 3108 "Zend/zend_ini_scanner.c"
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy253;
		}
		if (yych <= ':') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy252;
				} else {
					if (yych <= '\n') goto yy245;
					if (yych <= '\f') goto yy252;
				}
			} else {
				if (yych <= '"') {
					if (yych <= 0x1F) goto yy252;
				} else {
					if (yych <= '%') goto yy252;
					if (yych >= '*') goto yy252;
				}
			}
		} else {
			if (yych <= '^') {
				if (yych <= '<') {
					if (yych >= '<') goto yy252;
				} else {
					if (yych <= '=') goto yy245;
					if (yych <= ']') goto yy252;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '{') goto yy252;
				} else {
					if (yych != '~') goto yy252;
				}
			}
		}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 549 "Zend/zend_ini_scanner.l"
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
#line 3155 "Zend/zend_ini_scanner.c"
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					goto yy252;
				} else {
					if (yych <= '9') goto yy253;
					if (yych == ';') goto yy245;
					goto yy252;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'A') {
					if (yych <= '=') goto yy245;
					if (yych <= '@') goto yy252;
					goto yy280;
				} else {
					if (yych <= 'Z') goto yy253;
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					goto yy253;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy252;
					if (yych <= 'a') goto yy280;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'N') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					if (yych <= '\n') goto yy245;
					goto yy252;
				} else {
					if (yych <= '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					if (yych <= '"') goto yy245;
					goto yy252;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					if (yych <= '9') goto yy253;
					goto yy252;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy245;
						goto yy252;
					} else {
						if (yych <= '=') goto yy245;
						if (yych <= '@') goto yy252;
						goto yy253;
					}
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'Z') {
					if (yych <= 'O') goto yy272;
					if (yych == 'U') goto yy273;
					goto yy253;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy252;
						goto yy245;
					} else {
						if (yych == '`') goto yy252;
						goto yy253;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'o') goto yy272;
					if (yych == 'u') goto yy273;
					goto yy253;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy252;
						goto yy245;
					} else {
						if (yych == '~') goto yy245;
						goto yy252;
					}
				}
			}
		}
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '%') {
				if (yych <= '\f') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					if (yych <= '\n') goto yy245;
					goto yy252;
				} else {
					if (yych <= '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					if (yych <= '"') goto yy245;
					goto yy252;
				}
			} else {
				if (yych <= ':') {
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					if (yych <= '9') goto yy253;
					goto yy252;
				} else {
					if (yych <= '<') {
						if (yych <= ';') goto yy245;
						goto yy252;
					} else {
						if (yych <= '=') goto yy245;
						if (yych <= '@') goto yy252;
						goto yy253;
					}
				}
			}
		} else {
			if (yych <= 'e') {
				if (yych <= 'Z') {
					if (yych <= 'F') goto yy267;
					if (yych == 'N') goto yy261;
					goto yy253;
				} else {
					if (yych <= '^') {
						if (yych <= ']') goto yy252;
						goto yy245;
					} else {
						if (yych == '`') goto yy252;
						goto yy253;
					}
				}
			} else {
				if (yych <= 'z') {
					if (yych <= 'f') goto yy267;
					if (yych == 'n') goto yy261;
					goto yy253;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy252;
						goto yy245;
					} else {
						if (yych == '~') goto yy245;
						goto yy252;
					}
				}
			}
		}
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych == 'R') goto yy265;
					goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'r') goto yy265;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych == 'E') goto yy255;
					goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy255;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy252:
		YYDEBUG(252, *YYCURSOR);
		if (yybm[0+yych] & 2) {
			goto yy251;
		}
		if (yych <= '"') goto yy225;
		if (yych <= '$') goto yy256;
		goto yy225;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(254, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy253;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy245;
					goto yy251;
				} else {
					if (yych <= '\n') goto yy245;
					if (yych <= '\f') goto yy251;
					goto yy245;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy251;
					if (yych <= '"') goto yy245;
					goto yy251;
				} else {
					if (yych <= '$') goto yy256;
					if (yych <= '%') goto yy251;
					goto yy245;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy251;
					goto yy245;
				} else {
					if (yych == '=') goto yy245;
					goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy245;
					if (yych <= '{') goto yy251;
					goto yy245;
				} else {
					if (yych == '~') goto yy245;
					goto yy251;
				}
			}
		}
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych == 'S') goto yy261;
					goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy261;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy256:
		YYDEBUG(256, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy257;
			if (yych <= '[') goto yy251;
			goto yy258;
		} else {
			if (yych != '{') goto yy251;
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy225;
				} else {
					goto yy227;
				}
			} else {
				if (yyaccept == 2) {
					goto yy223;
				} else {
					goto yy240;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy245;
				} else {
					goto yy262;
				}
			} else {
				if (yyaccept == 6) {
					goto yy269;
				} else {
					goto yy276;
				}
			}
		}
yy258:
		YYDEBUG(258, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy259;
		}
		goto yy251;
yy259:
		YYDEBUG(259, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(260, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy259;
		}
		if (yych <= 0x00) goto yy225;
		if (yych == '\\') goto yy258;
		goto yy251;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy263;
		}
		if (yych <= ';') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy262;
					if (yych <= 0x08) goto yy252;
				} else {
					if (yych != '\r') goto yy252;
				}
			} else {
				if (yych <= ')') {
					if (yych <= '"') goto yy262;
					if (yych <= '%') goto yy252;
				} else {
					if (yych <= '/') goto yy252;
					if (yych <= '9') goto yy253;
					if (yych <= ':') goto yy252;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') {
					if (yych != '=') goto yy252;
				} else {
					if (yych <= 'Z') goto yy253;
					if (yych <= ']') goto yy252;
					if (yych >= '_') goto yy253;
				}
			} else {
				if (yych <= '{') {
					if (yych <= '`') goto yy252;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych >= 0x7F) goto yy252;
				}
			}
		}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 471 "Zend/zend_ini_scanner.l"
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
#line 3672 "Zend/zend_ini_scanner.c"
yy263:
		YYDEBUG(263, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(264, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy263;
		}
		goto yy262;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych != 'U') goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'u') goto yy266;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych == 'E') goto yy261;
					goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy261;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych != 'F') goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'f') goto yy268;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy253;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy252;
				} else {
					if (yych <= '\t') goto yy270;
					if (yych >= '\v') goto yy252;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy269;
					if (yych <= 0x1F) goto yy252;
					goto yy270;
				} else {
					if (yych <= '"') goto yy269;
					if (yych <= '%') goto yy252;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy252;
				} else {
					if (yych != '=') goto yy252;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy269;
					if (yych <= '{') goto yy252;
				} else {
					if (yych != '~') goto yy252;
				}
			}
		}
yy269:
		YYDEBUG(269, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 475 "Zend/zend_ini_scanner.l"
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
#line 3882 "Zend/zend_ini_scanner.c"
yy270:
		YYDEBUG(270, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(271, *YYCURSOR);
		if (yych == '\t') goto yy270;
		if (yych == ' ') goto yy270;
		goto yy269;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '<') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy269;
					if (yych <= 0x08) goto yy252;
					if (yych <= '\t') goto yy270;
					goto yy269;
				} else {
					if (yych == '\r') goto yy269;
					if (yych <= 0x1F) goto yy252;
					goto yy270;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '"') goto yy269;
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy269;
					goto yy252;
				} else {
					if (yych <= '9') goto yy253;
					if (yych == ';') goto yy269;
					goto yy252;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'N') {
					if (yych <= '=') goto yy269;
					if (yych <= '@') goto yy252;
					if (yych <= 'M') goto yy253;
					goto yy279;
				} else {
					if (yych <= 'Z') goto yy253;
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy269;
					goto yy253;
				}
			} else {
				if (yych <= 'z') {
					if (yych <= '`') goto yy252;
					if (yych == 'n') goto yy279;
					goto yy253;
				} else {
					if (yych <= '|') {
						if (yych <= '{') goto yy252;
						goto yy269;
					} else {
						if (yych == '~') goto yy269;
						goto yy252;
					}
				}
			}
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych != 'L') goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy274;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych != 'L') goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy275;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy253;
		}
		if (yych <= ')') {
			if (yych <= '\f') {
				if (yych <= 0x08) {
					if (yych >= 0x01) goto yy252;
				} else {
					if (yych <= '\t') goto yy277;
					if (yych >= '\v') goto yy252;
				}
			} else {
				if (yych <= ' ') {
					if (yych <= '\r') goto yy276;
					if (yych <= 0x1F) goto yy252;
					goto yy277;
				} else {
					if (yych <= '"') goto yy276;
					if (yych <= '%') goto yy252;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy252;
				} else {
					if (yych != '=') goto yy252;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy276;
					if (yych <= '{') goto yy252;
				} else {
					if (yych != '~') goto yy252;
				}
			}
		}
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 479 "Zend/zend_ini_scanner.l"
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
#line 4097 "Zend/zend_ini_scanner.c"
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(278, *YYCURSOR);
		if (yych == '\t') goto yy277;
		if (yych == ' ') goto yy277;
		goto yy276;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych == 'E') goto yy268;
					goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy268;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych != 'L') goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'l') goto yy281;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych != 'S') goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 's') goto yy282;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych <= '"') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy245;
					if (yych <= 0x08) goto yy252;
					goto yy245;
				} else {
					if (yych == '\r') goto yy245;
					if (yych <= 0x1F) goto yy252;
					goto yy245;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '%') goto yy252;
					if (yych <= ')') goto yy245;
					if (yych <= '/') goto yy252;
					goto yy253;
				} else {
					if (yych == ';') goto yy245;
					if (yych <= '<') goto yy252;
					goto yy245;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych <= '@') goto yy252;
					if (yych == 'E') goto yy268;
					goto yy253;
				} else {
					if (yych <= ']') goto yy252;
					if (yych <= '^') goto yy245;
					if (yych <= '_') goto yy253;
					goto yy252;
				}
			} else {
				if (yych <= '{') {
					if (yych == 'e') goto yy268;
					if (yych <= 'z') goto yy253;
					goto yy252;
				} else {
					if (yych == '}') goto yy252;
					if (yych <= '~') goto yy245;
					goto yy252;
				}
			}
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy284:
		YYDEBUG(284, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy283;
		}
		if (yych >= '\v') goto yy287;
yy285:
		YYDEBUG(285, *YYCURSOR);
		++YYCURSOR;
yy286:
		YYDEBUG(286, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 639 "Zend/zend_ini_scanner.l"
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
#line 4332 "Zend/zend_ini_scanner.c"
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy285;
		goto yy286;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(289, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy288;
		}
		if (yych <= ')') {
			if (yych <= '\r') {
				if (yych <= 0x08) {
					if (yych <= 0x00) goto yy240;
					goto yy251;
				} else {
					if (yych <= '\n') goto yy240;
					if (yych <= '\f') goto yy251;
					goto yy240;
				}
			} else {
				if (yych <= '#') {
					if (yych <= 0x1F) goto yy251;
					if (yych <= '"') goto yy240;
					goto yy251;
				} else {
					if (yych <= '$') goto yy256;
					if (yych <= '%') goto yy251;
					goto yy240;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= ':') goto yy251;
					goto yy240;
				} else {
					if (yych == '=') goto yy240;
					goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy240;
					if (yych <= '{') goto yy251;
					goto yy240;
				} else {
					if (yych == '~') goto yy240;
					goto yy251;
				}
			}
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(291, *YYCURSOR);
		if (yych <= '.') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy240;
					if (yych <= 0x08) goto yy251;
					goto yy240;
				} else {
					if (yych == '\r') goto yy240;
					goto yy251;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy240;
					if (yych <= '#') goto yy251;
					goto yy256;
				} else {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy240;
					if (yych <= '-') goto yy251;
					goto yy288;
				}
			}
		} else {
			if (yych <= '=') {
				if (yych <= ':') {
					if (yych <= '/') goto yy251;
					if (yych <= '9') goto yy290;
					goto yy251;
				} else {
					if (yych == '<') goto yy251;
					goto yy240;
				}
			} else {
				if (yych <= '{') {
					if (yych == '^') goto yy240;
					goto yy251;
				} else {
					if (yych == '}') goto yy251;
					if (yych <= '~') goto yy240;
					goto yy251;
				}
			}
		}
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(293, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy240;
					if (yych <= 0x08) goto yy251;
					goto yy240;
				} else {
					if (yych == '\r') goto yy240;
					goto yy251;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy240;
					if (yych <= '#') goto yy251;
					goto yy256;
				} else {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy240;
					goto yy251;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy292;
					if (yych <= ':') goto yy251;
					goto yy240;
				} else {
					if (yych == '=') goto yy240;
					goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy240;
					if (yych <= '{') goto yy251;
					goto yy240;
				} else {
					if (yych == '~') goto yy240;
					goto yy251;
				}
			}
		}
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(295, *YYCURSOR);
		if (yych <= '/') {
			if (yych <= 0x1F) {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy240;
					if (yych <= 0x08) goto yy251;
					goto yy240;
				} else {
					if (yych == '\r') goto yy240;
					goto yy251;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy240;
					if (yych <= '#') goto yy251;
					goto yy256;
				} else {
					if (yych <= '%') goto yy251;
					if (yych <= ')') goto yy240;
					goto yy251;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= ';') {
					if (yych <= '9') goto yy294;
					if (yych <= ':') goto yy251;
					goto yy240;
				} else {
					if (yych == '=') goto yy240;
					goto yy251;
				}
			} else {
				if (yych <= '|') {
					if (yych <= '^') goto yy240;
					if (yych <= '{') goto yy251;
					goto yy240;
				} else {
					if (yych == '~') goto yy240;
					goto yy251;
				}
			}
		}
yy296:
		YYDEBUG(296, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(297, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy296;
		}
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(299, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 418 "Zend/zend_ini_scanner.l"
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
#line 4559 "Zend/zend_ini_scanner.c"
yy300:
		YYDEBUG(300, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(301, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 451 "Zend/zend_ini_scanner.l"
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
#line 4570 "Zend/zend_ini_scanner.c"
yy302:
		YYDEBUG(302, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy303:
		YYDEBUG(303, *YYCURSOR);
		if (yych == '\t') goto yy302;
		if (yych == ' ') goto yy302;
		goto yy232;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy229;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy306:
		YYDEBUG(306, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy227;
				if (yych <= '\t') goto yy305;
				goto yy304;
			} else {
				if (yych == '\r') goto yy308;
				goto yy227;
			}
		} else {
			if (yych <= '"') {
				if (yych <= ' ') goto yy305;
				if (yych <= '!') goto yy227;
			} else {
				if (yych == ';') goto yy283;
				goto yy227;
			}
		}
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy234;
yy308:
		YYDEBUG(308, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy304;
		goto yy229;
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128,   0,   0, 128,   0, 128,   0, 128, 
			  0,   0, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128,   0, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0, 128, 128,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(309, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '"') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy311;
					if (yych <= '\n') goto yy313;
				} else {
					if (yych <= '\r') goto yy313;
					if (yych >= '!') goto yy313;
				}
			} else {
				if (yych <= '%') {
					if (yych == '$') goto yy313;
				} else {
					if (yych != '\'') goto yy313;
				}
			}
		} else {
			if (yych <= '[') {
				if (yych <= '<') {
					if (yych == ';') goto yy313;
				} else {
					if (yych <= '=') goto yy313;
					if (yych >= '[') goto yy313;
				}
			} else {
				if (yych <= 'z') {
					if (yych == '^') goto yy313;
				} else {
					if (yych == '}') goto yy315;
					if (yych <= '~') goto yy313;
				}
			}
		}
yy311:
		YYDEBUG(311, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy318;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 456 "Zend/zend_ini_scanner.l"
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
#line 4711 "Zend/zend_ini_scanner.c"
yy313:
		YYDEBUG(313, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(314, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 650 "Zend/zend_ini_scanner.l"
		{
	return 0;
}
#line 4721 "Zend/zend_ini_scanner.c"
yy315:
		YYDEBUG(315, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(316, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 466 "Zend/zend_ini_scanner.l"
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
#line 4732 "Zend/zend_ini_scanner.c"
yy317:
		YYDEBUG(317, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy318:
		YYDEBUG(318, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy317;
		}
		goto yy312;
	}
}
#line 654 "Zend/zend_ini_scanner.l"

}
