--TEST--
gmp_random_seed() basic tests
--SKIPIF--
<?php if (!extension_loaded("gmp")) print "skip"; ?>
<?php if (PHP_INT_SIZE != 4) die("skip this test is for 32bit platform only"); ?>
--FILE--
<?php

// zero int
var_dump(gmp_random_seed(0));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// zero gmp
var_dump(gmp_random_seed(gmp_init(0)));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// negative int
var_dump(gmp_random_seed(-100));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// negative gmp
var_dump(gmp_random_seed(gmp_init(-100)));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// positive int
var_dump(gmp_random_seed(100));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// positive gmp
var_dump(gmp_random_seed(100));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


$seed = gmp_init(1);
$seed <<= 512;

// large negative gmp
var_dump(gmp_random_seed($seed * -1));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// large positive gmp
var_dump(gmp_random_seed($seed));

var_dump(gmp_strval(gmp_random()));
var_dump(gmp_strval(gmp_random(1)));
var_dump(gmp_strval(gmp_random(10)));

var_dump(gmp_strval(gmp_random_bits(10)));
var_dump(gmp_strval(gmp_random_bits(100)));
var_dump(gmp_strval(gmp_random_bits(1000)));

var_dump(gmp_strval(gmp_random_range(0, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 10000)));
var_dump(gmp_strval(gmp_random_range(-10000, 0)));


// standard non conversion error
var_dump(gmp_random_seed('not a number'));


echo "Done\n";
?>
--EXPECTF--
NULL
string(193) "2000022451473107283132031190545479155678097978829612864726689673263990484954900429188146529905019042225609517482723730948135765344007937183893986134210303199345433818579954244943136664096571499"
string(10) "3792281639"
string(97) "1281406676617847191505318987040099388645126071814252743902229506206669580396236451813261179688680"
string(2) "86"
string(30) "539590049119295715487546581833"
string(301) "1421393257467327495225454368915273750356127352353055226245692071178379257048985726109650766437957017507708821700349355658110489309871463201057688894986035545794429493563972043777521547094922637182497036750765553664196591958728194711096442220858890056073974348364544481270013556644174056049511198143353"
string(4) "8971"
string(4) "7838"
string(5) "-7823"
NULL
string(193) "2000022451473107283132031190545479155678097978829612864726689673263990484954900429188146529905019042225609517482723730948135765344007937183893986134210303199345433818579954244943136664096571499"
string(10) "3792281639"
string(97) "1281406676617847191505318987040099388645126071814252743902229506206669580396236451813261179688680"
string(2) "86"
string(30) "539590049119295715487546581833"
string(301) "1421393257467327495225454368915273750356127352353055226245692071178379257048985726109650766437957017507708821700349355658110489309871463201057688894986035545794429493563972043777521547094922637182497036750765553664196591958728194711096442220858890056073974348364544481270013556644174056049511198143353"
string(4) "8971"
string(4) "7838"
string(5) "-7823"
NULL
string(193) "2481908463276861025880840116973116041137167231715512003123396619946362384184452775649311777755189162364804428739438733886421190841599393284032499618736594054572838636962845446571583771860379424"
string(9) "513032517"
string(97) "1269389652350468424962405917839748437534426606829298977422985976022226588797299164880342257267822"
string(3) "111"
string(31) "1007352579363975542750518386428"
string(301) "5972672173406546932378461222050826195392618168845902231231085819967980051373112173617569638344495916340820360974139193579303652817960325137050189614326029375858951250371622253667077551034119958866481056760107123567590230789917209543206262943739654964107980961862387602012190907147667678648223791029527"
string(4) "2362"
string(5) "-9377"
string(5) "-8435"
NULL
string(193) "2481908463276861025880840116973116041137167231715512003123396619946362384184452775649311777755189162364804428739438733886421190841599393284032499618736594054572838636962845446571583771860379424"
string(9) "513032517"
string(97) "1269389652350468424962405917839748437534426606829298977422985976022226588797299164880342257267822"
string(3) "111"
string(31) "1007352579363975542750518386428"
string(301) "5972672173406546932378461222050826195392618168845902231231085819967980051373112173617569638344495916340820360974139193579303652817960325137050189614326029375858951250371622253667077551034119958866481056760107123567590230789917209543206262943739654964107980961862387602012190907147667678648223791029527"
string(4) "2362"
string(5) "-9377"
string(5) "-8435"
NULL
string(193) "2481908463276861025880840116973116041137167231715512003123396619946362384184452775649311777755189162364804428739438733886421190841599393284032499618736594054572838636962845446571583771860379424"
string(9) "513032517"
string(97) "1269389652350468424962405917839748437534426606829298977422985976022226588797299164880342257267822"
string(3) "111"
string(31) "1007352579363975542750518386428"
string(301) "5972672173406546932378461222050826195392618168845902231231085819967980051373112173617569638344495916340820360974139193579303652817960325137050189614326029375858951250371622253667077551034119958866481056760107123567590230789917209543206262943739654964107980961862387602012190907147667678648223791029527"
string(4) "2362"
string(5) "-9377"
string(5) "-8435"
NULL
string(193) "2481908463276861025880840116973116041137167231715512003123396619946362384184452775649311777755189162364804428739438733886421190841599393284032499618736594054572838636962845446571583771860379424"
string(9) "513032517"
string(97) "1269389652350468424962405917839748437534426606829298977422985976022226588797299164880342257267822"
string(3) "111"
string(31) "1007352579363975542750518386428"
string(301) "5972672173406546932378461222050826195392618168845902231231085819967980051373112173617569638344495916340820360974139193579303652817960325137050189614326029375858951250371622253667077551034119958866481056760107123567590230789917209543206262943739654964107980961862387602012190907147667678648223791029527"
string(4) "2362"
string(5) "-9377"
string(5) "-8435"
NULL
string(193) "4314861641594785951065006537821497084129700255567731661104366342587560122488351847486220156468888511744226746306538524023190734733433083354034308520246964938498767672539252131810891590624763642"
string(10) "3301287097"
string(97) "1532710025135934106005683287301200805525218110207399702226596673360222079570223526337866801028045"
string(3) "317"
string(30) "949682013136255600092941702271"
string(302) "10419061168407861659407303769436775291881708415032871985692089124472434944956010985892897595466043265819000974537553172663152640727594826474137173310039809413311432062725623183603946900548710858191078057179743726366436832870919212340219523613153893742764101120396858424887711932475871305848021245801132"
string(4) "2417"
string(5) "-7975"
string(4) "-378"
NULL
string(193) "4314861641594785951065006537821497084129700255567731661104366342587560122488351847486220156468888511744226746306538524023190734733433083354034308520246964938498767672539252131810891590624763642"
string(10) "3301287097"
string(97) "1532710025135934106005683287301200805525218110207399702226596673360222079570223526337866801028045"
string(3) "317"
string(30) "949682013136255600092941702271"
string(302) "10419061168407861659407303769436775291881708415032871985692089124472434944956010985892897595466043265819000974537553172663152640727594826474137173310039809413311432062725623183603946900548710858191078057179743726366436832870919212340219523613153893742764101120396858424887711932475871305848021245801132"
string(4) "2417"
string(5) "-7975"
string(4) "-378"

Warning: gmp_random_seed(): Unable to convert variable to GMP - string is not an integer in %s on line %d
bool(false)
Done
