/* Generated by re2c 0.15.3 on Tue Jan 10 15:16:26 2023 */
#line 1 "ext/date/lib/parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2019 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <math.h>
#include <assert.h>
#include <limits.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

#if defined(_POSIX_TZNAME_MAX)
# define MAX_ABBR_LEN _POSIX_TZNAME_MAX
#elif defined(TZNAME_MAX)
# define MAX_ABBR_LEN TZNAME_MAX
#else
# define MAX_ABBR_LEN 6
#endif

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "mondays",     TIMELIB_WEEKDAY, 1 },
	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesdays",    TIMELIB_WEEKDAY, 2 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesdays",  TIMELIB_WEEKDAY, 3 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursdays",   TIMELIB_WEEKDAY, 4 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "fridays",     TIMELIB_WEEKDAY, 5 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturdays",   TIMELIB_WEEKDAY, 6 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sundays",     TIMELIB_WEEKDAY, 0 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_error_message *alloc_error_message(timelib_error_message **messages, int *count)
{
	/* Realloc in power of two increments */
	int is_pow2 = (*count & (*count - 1)) == 0;

	if (is_pow2) {
		size_t alloc_size = *count ? (*count * 2) : 1;

		*messages = timelib_realloc(*messages, alloc_size * sizeof(timelib_error_message));
	}
	return *messages + (*count)++;
}

static void add_warning(Scanner *s, int error_code, const char *error)
{
	timelib_error_message *message = alloc_error_message(&s->errors->warning_messages, &s->errors->warning_count);

	message->error_code = error_code;
	message->position = s->tok ? s->tok - s->str : 0;
	message->character = s->tok ? *s->tok : 0;
	message->message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, const char *error)
{
	timelib_error_message *message = alloc_error_message(&s->errors->error_messages, &s->errors->error_count);

	message->error_code = error_code;
	message->position = s->tok ? s->tok - s->str : 0;
	message->character = s->tok ? *s->tok : 0;
	message->message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, const char *error, const char *sptr, const char *cptr)
{
	timelib_error_message *message = alloc_error_message(&s->errors->warning_messages, &s->errors->warning_count);

	message->error_code = error_code;
	message->position = cptr - sptr;
	message->character = *cptr;
	message->message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, const char *error, const char *sptr, const char *cptr)
{
	timelib_error_message *message = alloc_error_message(&s->errors->error_messages, &s->errors->error_count);

	message->error_code = error_code;
	message->position = cptr - sptr;
	message->character = *cptr;
	message->message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(const char **ptr, int max_length, int *scanned_length)
{
	const char *begin, *end;
	char *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(const char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(const char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(const char **ptr)
{
	const char *begin, *end;
	char *str;
	double tmp_nr = TIMELIB_UNSET;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) {
		++*ptr;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_signed_nr(Scanner *s, const char **ptr, int max_length)
{
	char *str, *str_ptr;
	timelib_sll tmp_nr = 0;
	int len = 0;

	str = timelib_calloc(1, max_length + 2); // for sign and \0
	str_ptr = str;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			add_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Found unexpected data");
			timelib_free(str);
			return 0;
		}
		++*ptr;
	}

	if ((**ptr == '+') || (**ptr == '-')) {
		*str_ptr = **ptr;
		++*ptr;
		++str_ptr;
	}

	while (((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			timelib_free(str);
			add_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Found unexpected data");
			return 0;
		}
		++*ptr;
	}

	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		*str_ptr = **ptr;
		++*ptr;
		++str_ptr;
		++len;
	}

	tmp_nr = strtoll(str, NULL, 10);

	timelib_free(str);

	return tmp_nr;
}

static timelib_sll timelib_lookup_relative_text(const char **ptr, int *behavior)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(const char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(const char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(const char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(const char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

/**
 * The time_part parameter is a flag. It can be TIMELIB_TIME_PART_KEEP in case
 * the time portion should not be reset to midnight, or
 * TIMELIB_TIME_PART_DONT_KEEP in case it does need to be reset. This is used
 * for not overwriting the time portion for 'X weekday'.
 */
static void timelib_set_relative(const char **ptr, timelib_sll amount, int behavior, Scanner *s, int time_part)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.us += amount * relunit->multiplier; break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			if (time_part != TIMELIB_TIME_PART_KEEP) {
				TIMELIB_UNHAVE_TIME();
			}
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			if (time_part != TIMELIB_TIME_PART_KEEP) {
				TIMELIB_UNHAVE_TIME();
			}
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(const char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	/* Only include A-Z, a-z, 0-9, /, _, and - in abbreviations/TZ IDs */
	while (
		(**ptr >= 'A' && **ptr <= 'Z') ||
		(**ptr >= 'a' && **ptr <= 'z') ||
		(**ptr >= '0' && **ptr <= '9') ||
		**ptr == '/' || **ptr == '_' || **ptr == '-' || **ptr == '+'
	) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if (end - begin < MAX_ABBR_LEN && (tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(const char **ptr, int *tz_not_found)
{
	const char *begin = *ptr, *end;
	timelib_long  tmp;

	*tz_not_found = 1;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			*tz_not_found = 0;
			return sHOUR(strtol(begin, NULL, 10));

		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				*tz_not_found = 0;
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				*tz_not_found = 0;
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				*tz_not_found = 0;
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}

		case 5: /* HH:MM */
			if (begin[2] != ':') {
				break;
			}

			*tz_not_found = 0;
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;

		case 6: /* HHMMSS */
			*tz_not_found = 0;
			tmp = strtol(begin, NULL, 10);
			tmp = sHOUR(tmp / 10000) + sMIN((tmp / 100) % 100) + (tmp % 100);
			return tmp;

		case 8: /* HH:MM:SS */
			if (begin[2] != ':' || begin[5] != ':') {
				break;
			}

			*tz_not_found = 0;
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10)) + strtol(begin + 6, NULL, 10);
			return tmp;

	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(const char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	const char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(const char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr, tz_not_found);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr, tz_not_found);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			t->dst = *dst;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str;
	const char *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1115 "ext/date/lib/parse_date.re"



#line 992 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,  64,  32,  80,  48,   0, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128,   0,   0,   0,   0,   0,   0, 
		  0,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   4,   0,   0,   0,   0,   0, 
		  0,  12,  12,  12,  44,  12,  12,  12, 
		 44,  12,  12,  12,  12,  12,  44,  12, 
		 12,  12,  44,  44,  44,  12,  12,  12, 
		 12,  12,  12,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 36) YYFILL(36);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy182;
			goto yy1635;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy182;
			if (yych >= 'a') goto yy187;
		} else {
			if (yych <= 'e') goto yy1644;
			if (yych <= 'z') goto yy187;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1849 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1143 "<stdout>"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy182;
			goto yy1635;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'e') goto yy1635;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1606;
				goto yy182;
			} else {
				if (yych <= 'I') goto yy1607;
				if (yych <= 'N') goto yy182;
				goto yy1605;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy182;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1622;
				goto yy187;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1623;
				goto yy187;
			} else {
				if (yych <= 'o') goto yy1621;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1606;
				goto yy182;
			} else {
				if (yych <= 'I') goto yy1607;
				if (yych <= 'N') goto yy182;
				goto yy1605;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy182;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1606;
				goto yy182;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1607;
				goto yy182;
			} else {
				if (yych <= 'o') goto yy1605;
				if (yych <= 'z') goto yy182;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy1573;
		} else {
			if (yych == 'I') goto yy1574;
			if (yych <= 'N') goto yy182;
			goto yy1575;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1589;
			goto yy187;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1590;
				goto yy187;
			} else {
				if (yych <= 'o') goto yy1591;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy1573;
		} else {
			if (yych == 'I') goto yy1574;
			if (yych <= 'N') goto yy182;
			goto yy1575;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1573;
			goto yy182;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1574;
				goto yy182;
			} else {
				if (yych <= 'o') goto yy1575;
				if (yych <= 'z') goto yy182;
				goto yy3;
			}
		}
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy181;
	case '0':
	case '1':	goto yy1499;
	case '2':	goto yy1500;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1501;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy182;
	case 'E':	goto yy1494;
	case 'H':	goto yy1495;
	case 'O':	goto yy1496;
	case 'U':	goto yy1497;
	case 'W':	goto yy1498;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy187;
	case 'e':	goto yy1539;
	case 'h':	goto yy1540;
	case 'o':	goto yy1541;
	case 'u':	goto yy1542;
	case 'w':	goto yy1543;
	default:	goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case ')':	goto yy181;
	case '0':
	case '1':	goto yy1499;
	case '2':	goto yy1500;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1501;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy182;
	case 'E':
	case 'e':	goto yy1494;
	case 'H':
	case 'h':	goto yy1495;
	case 'O':
	case 'o':	goto yy1496;
	case 'U':
	case 'u':	goto yy1497;
	case 'W':
	case 'w':	goto yy1498;
	default:	goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1482;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1483;
yy12:
	YYDEBUG(12, *YYCURSOR);
#line 1944 "ext/date/lib/parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1455 "<stdout>"
yy13:
	YYDEBUG(13, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy182;
				goto yy1415;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1416;
				goto yy182;
			} else {
				if (yych <= 'O') goto yy1417;
				if (yych <= 'Q') goto yy182;
				goto yy1418;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy182;
				if (yych <= '`') goto yy3;
				goto yy187;
			} else {
				if (yych <= 'e') goto yy1458;
				if (yych <= 'h') goto yy187;
				goto yy1459;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1460;
				goto yy187;
			} else {
				if (yych <= 'r') goto yy1461;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy182;
				goto yy1415;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1416;
				goto yy182;
			} else {
				if (yych <= 'O') goto yy1417;
				if (yych <= 'Q') goto yy182;
				goto yy1418;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy182;
				if (yych <= '`') goto yy3;
				goto yy182;
			} else {
				if (yych <= 'e') goto yy1415;
				if (yych <= 'h') goto yy182;
				goto yy1416;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1417;
				goto yy182;
			} else {
				if (yych <= 'r') goto yy1418;
				if (yych <= 'z') goto yy182;
				goto yy3;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy1401;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy182;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1412;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy1401;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy182;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1401;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy1380;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy182;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1398;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy1380;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy182;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1380;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1321;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1320;
				goto yy182;
			} else {
				if (yych <= 'I') goto yy1322;
				if (yych <= 'T') goto yy182;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy182;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1351;
				if (yych <= 'd') goto yy187;
				goto yy1350;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1352;
				goto yy187;
			} else {
				if (yych <= 'u') goto yy1353;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1321;
				goto yy182;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1320;
				goto yy182;
			} else {
				if (yych <= 'I') goto yy1322;
				if (yych <= 'T') goto yy182;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy182;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1321;
				if (yych <= 'd') goto yy182;
				goto yy1320;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1322;
				goto yy182;
			} else {
				if (yych <= 'u') goto yy1323;
				if (yych <= 'z') goto yy182;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1290;
			if (yych <= 'K') goto yy182;
			goto yy1291;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy187;
			goto yy1308;
		} else {
			if (yych == 'l') goto yy1309;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1290;
			if (yych <= 'K') goto yy182;
			goto yy1291;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy182;
			goto yy1290;
		} else {
			if (yych == 'l') goto yy1291;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy182;
			goto yy1157;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy187;
		} else {
			if (yych <= 'r') goto yy1283;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy182;
			goto yy1157;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'r') goto yy1157;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1111;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy1113;
					if (yych <= ',') goto yy12;
					goto yy506;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy1123;
					if (yych <= '/') goto yy505;
					goto yy1156;
				} else {
					if (yych <= '9') goto yy1155;
					if (yych <= ':') goto yy1124;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy1113;
					if (yych <= 'C') goto yy12;
					goto yy1113;
				} else {
					if (yych == 'F') goto yy1113;
					goto yy12;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy1113;
					if (yych <= 'L') goto yy12;
					goto yy1113;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy1113;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy1113;
					if (yych <= 'c') goto yy12;
					goto yy1113;
				} else {
					if (yych == 'f') goto yy1113;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy1113;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy1113;
					goto yy503;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy1113;
					if (yych <= 'q') goto yy12;
					goto yy504;
				} else {
					if (yych <= 's') goto yy498;
					if (yych <= 't') goto yy501;
					goto yy1113;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy1113;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy1113;
					if (yych == 0xC2) goto yy1113;
					goto yy12;
				}
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy493;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy495;
					if (yych <= ',') goto yy12;
					goto yy506;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy507;
					if (yych <= '/') goto yy505;
					goto yy1155;
				} else {
					if (yych <= '9') goto yy1122;
					if (yych <= ':') goto yy516;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy495;
					if (yych <= 'C') goto yy12;
					goto yy495;
				} else {
					if (yych == 'F') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy495;
					if (yych <= 'L') goto yy12;
					goto yy495;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy495;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy495;
					if (yych <= 'c') goto yy12;
					goto yy495;
				} else {
					if (yych == 'f') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy495;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy495;
					goto yy503;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy495;
					if (yych <= 'q') goto yy12;
					goto yy504;
				} else {
					if (yych <= 's') goto yy498;
					if (yych <= 't') goto yy501;
					goto yy495;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy495;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy495;
					if (yych == 0xC2) goto yy495;
					goto yy12;
				}
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy493;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy495;
					if (yych <= ',') goto yy12;
					goto yy506;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy507;
					if (yych <= '/') goto yy505;
					goto yy1122;
				} else {
					if (yych <= '9') goto yy1109;
					if (yych <= ':') goto yy516;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy495;
					if (yych <= 'C') goto yy12;
					goto yy495;
				} else {
					if (yych == 'F') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy495;
					if (yych <= 'L') goto yy12;
					goto yy495;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy495;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy495;
					if (yych <= 'c') goto yy12;
					goto yy495;
				} else {
					if (yych == 'f') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy495;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy495;
					goto yy503;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy495;
					if (yych <= 'q') goto yy12;
					goto yy504;
				} else {
					if (yych <= 's') goto yy498;
					if (yych <= 't') goto yy501;
					goto yy495;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy495;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy495;
					if (yych == 0xC2) goto yy495;
					goto yy12;
				}
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy493;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy495;
					if (yych <= ',') goto yy12;
					goto yy506;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy507;
					if (yych <= '/') goto yy505;
					goto yy1109;
				} else {
					if (yych <= '9') goto yy502;
					if (yych <= ':') goto yy516;
					goto yy12;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy495;
					if (yych <= 'C') goto yy12;
					goto yy495;
				} else {
					if (yych == 'F') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy495;
					if (yych <= 'L') goto yy12;
					goto yy495;
				} else {
					if (yych <= 'R') goto yy12;
					if (yych <= 'Y') goto yy495;
					goto yy12;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy495;
					if (yych <= 'c') goto yy12;
					goto yy495;
				} else {
					if (yych == 'f') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy12;
					goto yy495;
				} else {
					if (yych <= 'l') goto yy12;
					if (yych <= 'm') goto yy495;
					goto yy503;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy495;
					if (yych <= 'q') goto yy12;
					goto yy504;
				} else {
					if (yych <= 's') goto yy498;
					if (yych <= 't') goto yy501;
					goto yy495;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy495;
					goto yy12;
				} else {
					if (yych <= 'y') goto yy495;
					if (yych == 0xC2) goto yy495;
					goto yy12;
				}
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy493;
					goto yy12;
				} else {
					if (yych <= ' ') goto yy495;
					if (yych <= ',') goto yy12;
					goto yy506;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy507;
					if (yych <= '/') goto yy505;
					goto yy502;
				} else {
					if (yych <= ':') goto yy516;
					if (yych <= '@') goto yy12;
					goto yy495;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy495;
					goto yy12;
				} else {
					if (yych == 'G') goto yy12;
					goto yy495;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy12;
					if (yych <= 'P') goto yy495;
					goto yy12;
				} else {
					if (yych <= 'Y') goto yy495;
					if (yych <= '`') goto yy12;
					goto yy495;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy495;
					goto yy12;
				} else {
					if (yych == 'g') goto yy12;
					goto yy495;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy495;
					goto yy12;
				} else {
					if (yych == 'n') goto yy503;
					goto yy495;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy12;
					if (yych <= 'r') goto yy504;
					goto yy498;
				} else {
					if (yych <= 't') goto yy501;
					if (yych <= 'u') goto yy495;
					goto yy12;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy12;
					goto yy495;
				} else {
					if (yych == 0xC2) goto yy495;
					goto yy12;
				}
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy445;
	case '0':
	case '1':	goto yy442;
	case '2':	goto yy443;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy444;
	default:	goto yy12;
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy250;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy182;
			} else {
				if (yych <= 'I') goto yy441;
				if (yych <= 'U') goto yy182;
				goto yy440;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy440;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy3;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy250;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy437;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy3;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy250;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy435;
				goto yy182;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy418;
			if (yych <= 'T') goto yy182;
			goto yy417;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy427;
		} else {
			if (yych == 'u') goto yy426;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy418;
			if (yych <= 'T') goto yy182;
			goto yy417;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy418;
		} else {
			if (yych == 'u') goto yy417;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy396;
				goto yy182;
			} else {
				if (yych <= 'P') goto yy395;
				if (yych <= 'T') goto yy182;
				goto yy394;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy182;
				goto yy3;
			} else {
				if (yych == 'g') goto yy408;
				goto yy187;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy407;
				goto yy187;
			} else {
				if (yych <= 'u') goto yy406;
				if (yych <= 'z') goto yy187;
				goto yy3;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy396;
				goto yy182;
			} else {
				if (yych <= 'P') goto yy395;
				if (yych <= 'T') goto yy182;
				goto yy394;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy182;
				goto yy3;
			} else {
				if (yych == 'g') goto yy396;
				goto yy182;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy395;
				goto yy182;
			} else {
				if (yych <= 'u') goto yy394;
				if (yych <= 'z') goto yy182;
				goto yy3;
			}
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy182;
			goto yy384;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy187;
		} else {
			if (yych <= 'c') goto yy389;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy182;
			goto yy384;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'c') goto yy384;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy182;
			goto yy246;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy187;
		} else {
			if (yych <= 'e') goto yy375;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy182;
			goto yy246;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'e') goto yy246;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy182;
			goto yy217;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy187;
		} else {
			if (yych <= 'e') goto yy232;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy182;
			goto yy217;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy182;
			if (yych <= '`') goto yy3;
			goto yy182;
		} else {
			if (yych <= 'e') goto yy217;
			if (yych <= 'z') goto yy182;
			goto yy3;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy182;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy198;
			goto yy182;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy187;
			goto yy3;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy197;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy197;
	goto yy12;
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy182;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy187;
		goto yy3;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy182;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy182;
		goto yy3;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	YYDEBUG(49, *YYCURSOR);
#line 1933 "ext/date/lib/parse_date.re"
	{
		goto std;
	}
#line 2703 "<stdout>"
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(52, *YYCURSOR);
#line 1938 "ext/date/lib/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 2717 "<stdout>"
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	YYDEBUG(54, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy70;
	goto yy59;
yy55:
	YYDEBUG(55, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy12;
						} else {
							goto yy3;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept == 3) {
						goto yy84;
					} else {
						goto yy219;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy248;
					} else {
						goto yy262;
					}
				} else {
					if (yyaccept == 7) {
						goto yy276;
					} else {
						goto yy398;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy509;
					} else {
						goto yy524;
					}
				} else {
					if (yyaccept == 11) {
						goto yy645;
					} else {
						goto yy690;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy700;
					} else {
						goto yy734;
					}
				} else {
					if (yyaccept == 15) {
						goto yy808;
					} else {
						goto yy828;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy859;
						} else {
							goto yy866;
						}
					} else {
						goto yy893;
					}
				} else {
					if (yyaccept == 20) {
						goto yy838;
					} else {
						goto yy461;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy1018;
					} else {
						goto yy887;
					}
				} else {
					if (yyaccept == 24) {
						goto yy1127;
					} else {
						goto yy1135;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy1179;
					} else {
						goto yy1206;
					}
				} else {
					if (yyaccept == 28) {
						goto yy1388;
					} else {
						goto yy1524;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1527;
					} else {
						goto yy1612;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1620;
					} else {
						goto yy1643;
					}
				}
			}
		}
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 24) YYFILL(24);
	yych = *YYCURSOR;
	YYDEBUG(57, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy54;
	goto yy55;
yy58:
	YYDEBUG(58, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy59:
	YYDEBUG(59, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy58;
				if (yych <= 0x1F) goto yy55;
				goto yy58;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy65;
				} else {
					if (yych == 'F') goto yy66;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy64;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy55;
					goto yy63;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy69;
					goto yy62;
				} else {
					if (yych == 'W') goto yy68;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy65;
					if (yych <= 'e') goto yy55;
					goto yy66;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy64;
				} else {
					if (yych != 'm') goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy63;
					goto yy69;
				} else {
					if (yych <= 'u') goto yy62;
					if (yych <= 'v') goto yy55;
					goto yy68;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy67;
				} else {
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy154;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy153;
			if (yych <= 'R') goto yy55;
			goto yy155;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy154;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy153;
			if (yych == 's') goto yy155;
			goto yy55;
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy150;
	goto yy55;
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy148;
	if (yych == 's') goto yy148;
	goto yy55;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy134;
			if (yych <= 'T') goto yy55;
			goto yy132;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy134;
			if (yych == 'u') goto yy132;
			goto yy55;
		}
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy130;
	if (yych == 'o') goto yy130;
	goto yy55;
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy129;
	if (yych == 'a') goto yy129;
	goto yy55;
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy113;
		if (yych <= 'Q') goto yy55;
		goto yy112;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy55;
			goto yy113;
		} else {
			if (yych == 'r') goto yy112;
			goto yy55;
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy109;
	if (yych == 'e') goto yy109;
	goto yy55;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy55;
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy81;
		if (yych <= 'T') goto yy55;
		goto yy82;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy81;
		} else {
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy58;
	goto yy59;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy90;
	if (yych == 'u') goto yy90;
	goto yy55;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy83;
	if (yych != 'e') goto yy55;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy85;
	if (yych == 's') goto yy85;
yy84:
	YYDEBUG(84, *YYCURSOR);
#line 1917 "ext/date/lib/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_signed_nr(s, &ptr, 24);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, 1, s, TIMELIB_TIME_PART_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3154 "<stdout>"
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy86;
	if (yych != 'd') goto yy55;
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy87;
	if (yych != 'a') goto yy55;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy88;
	if (yych != 'y') goto yy55;
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych != 's') goto yy84;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy84;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy91;
	if (yych != 'r') goto yy84;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy92;
	if (yych != 's') goto yy55;
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy93;
	if (yych != 'd') goto yy55;
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy94;
	if (yych != 'a') goto yy55;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy95;
	if (yych != 'y') goto yy55;
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy98;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy98;
		if (yych >= 'f') goto yy55;
	}
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy105;
	if (yych == 'k') goto yy105;
	goto yy55;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy99;
	if (yych != 'n') goto yy84;
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy100;
	if (yych != 'e') goto yy55;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy101;
	if (yych != 's') goto yy55;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy102;
	if (yych != 'd') goto yy55;
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy103;
	if (yych != 'a') goto yy55;
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy104;
	if (yych != 'y') goto yy55;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy105:
	YYDEBUG(105, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy106;
		if (yych <= 'R') goto yy84;
		goto yy89;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy84;
		} else {
			if (yych == 's') goto yy89;
			goto yy84;
		}
	}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy107;
	if (yych != 'a') goto yy55;
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy108;
	if (yych != 'y') goto yy55;
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy110;
	if (yych != 'a') goto yy55;
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy111;
	if (yych != 'r') goto yy55;
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy125;
	if (yych == 'i') goto yy125;
	goto yy55;
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy114;
	if (yych != 'r') goto yy55;
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy115;
	if (yych != 't') goto yy55;
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy117;
		if (yych <= 'M') goto yy55;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy117;
		} else {
			if (yych != 'n') goto yy55;
		}
	}
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy122;
	if (yych == 'i') goto yy122;
	goto yy55;
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych != 'n') goto yy55;
yy118:
	YYDEBUG(118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy119;
	if (yych != 'i') goto yy55;
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy120;
	if (yych != 'g') goto yy55;
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy121;
	if (yych != 'h') goto yy55;
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy111;
	if (yych == 't') goto yy111;
	goto yy55;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy123;
	if (yych != 'g') goto yy55;
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy124;
	if (yych != 'h') goto yy55;
yy124:
	YYDEBUG(124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy111;
	if (yych == 't') goto yy111;
	goto yy55;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy126;
	if (yych != 'd') goto yy84;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy127;
	if (yych != 'a') goto yy55;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy128;
	if (yych != 'y') goto yy55;
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy111;
	if (yych == 'y') goto yy111;
	goto yy55;
yy130:
	YYDEBUG(130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy131;
	if (yych != 'u') goto yy55;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy111;
	if (yych == 'r') goto yy111;
	goto yy55;
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy144;
	if (yych == 'n') goto yy144;
	goto yy55;
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy138;
	if (yych == 't') goto yy138;
	goto yy55;
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy135;
	if (yych != 'c') goto yy55;
yy135:
	YYDEBUG(135, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy136;
		if (yych <= 'R') goto yy84;
		goto yy89;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy84;
		} else {
			if (yych == 's') goto yy89;
			goto yy84;
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy137;
	if (yych != 'n') goto yy55;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy111;
	if (yych == 'd') goto yy111;
	goto yy55;
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy139;
	if (yych != 'u') goto yy84;
yy139:
	YYDEBUG(139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy140;
	if (yych != 'r') goto yy55;
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy141;
	if (yych != 'd') goto yy55;
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy142;
	if (yych != 'a') goto yy55;
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy143;
	if (yych != 'y') goto yy55;
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy144:
	YYDEBUG(144, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy145;
	if (yych != 'd') goto yy84;
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy146;
	if (yych != 'a') goto yy55;
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy147;
	if (yych != 'y') goto yy55;
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy149;
	if (yych != 'e') goto yy55;
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy111;
	if (yych == 'c') goto yy111;
	goto yy55;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy151;
	if (yych != 's') goto yy55;
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy152;
	if (yych != 'e') goto yy84;
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy111;
	if (yych == 'c') goto yy111;
	goto yy55;
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy176;
	if (yych == 'n') goto yy176;
	goto yy55;
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy158;
			goto yy55;
		} else {
			if (yych <= 'L') goto yy157;
			if (yych <= 'M') goto yy55;
			goto yy159;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy158;
			goto yy55;
		} else {
			if (yych <= 'l') goto yy157;
			if (yych == 'n') goto yy159;
			goto yy55;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy156;
	if (yych != 'e') goto yy84;
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy111;
	if (yych == 'c') goto yy111;
	goto yy55;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy169;
	if (yych == 'l') goto yy169;
	goto yy55;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy162;
	if (yych == 'r') goto yy162;
	goto yy55;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy89;
		if (yych <= 'T') goto yy84;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy84;
			goto yy89;
		} else {
			if (yych != 'u') goto yy84;
		}
	}
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy161;
	if (yych != 't') goto yy55;
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy111;
	if (yych == 'e') goto yy111;
	goto yy55;
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy163;
	if (yych != 'o') goto yy55;
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy164;
	if (yych != 's') goto yy55;
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy165;
	if (yych != 'e') goto yy55;
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy166;
	if (yych != 'c') goto yy55;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy167;
	if (yych != 'o') goto yy55;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy168;
	if (yych != 'n') goto yy55;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy111;
	if (yych == 'd') goto yy111;
	goto yy55;
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy170;
	if (yych != 'i') goto yy55;
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy171;
	if (yych != 's') goto yy55;
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy172;
	if (yych != 'e') goto yy55;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy173;
	if (yych != 'c') goto yy55;
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy174;
	if (yych != 'o') goto yy55;
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy175;
	if (yych != 'n') goto yy55;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy111;
	if (yych == 'd') goto yy111;
	goto yy55;
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy177;
		if (yych <= 'S') goto yy84;
		goto yy178;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy84;
		} else {
			if (yych == 't') goto yy178;
			goto yy84;
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy179;
	if (yych == 'a') goto yy179;
	goto yy55;
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy111;
	if (yych == 'h') goto yy111;
	goto yy55;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy180;
	if (yych != 'y') goto yy55;
yy180:
	YYDEBUG(180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy89;
	if (yych == 's') goto yy89;
	goto yy84;
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy183;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy184;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy185;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy186;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy181;
	goto yy3;
yy187:
	YYDEBUG(187, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy183;
			goto yy3;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy184;
			goto yy3;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy192;
			goto yy3;
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy190;
	}
	goto yy55;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(191, *YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy190;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy189;
		goto yy3;
	} else {
		if (yych <= '/') goto yy189;
		if (yych == '_') goto yy189;
		goto yy3;
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy185;
			goto yy3;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy186;
			goto yy3;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy181;
		if (yych <= ',') goto yy3;
		goto yy189;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy189;
		} else {
			if (yych == '_') goto yy189;
			goto yy3;
		}
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy196:
	YYDEBUG(196, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy189;
		goto yy55;
	} else {
		if (yych <= '/') goto yy189;
		if (yych == '_') goto yy189;
		goto yy55;
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy182;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy182;
		goto yy3;
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy183;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy183;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
	YYDEBUG(199, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy200;
			if (yych <= '@') goto yy3;
			goto yy184;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy201;
	if (yych <= '2') goto yy202;
	if (yych <= '9') goto yy203;
	goto yy55;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy206;
	if (yych <= ':') goto yy204;
	goto yy3;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych <= '4') goto yy206;
		goto yy205;
	} else {
		if (yych <= '9') goto yy181;
		if (yych <= ':') goto yy204;
		goto yy3;
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy205;
	if (yych <= '9') goto yy181;
	if (yych >= ';') goto yy3;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy205;
	if (yych <= '9') goto yy181;
	goto yy55;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy181;
	goto yy3;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy207;
	if (yych <= '9') goto yy181;
	if (yych <= ':') goto yy208;
	goto yy3;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy214;
	goto yy3;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy209;
	if (yych <= '9') goto yy181;
	goto yy55;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych >= ':') goto yy3;
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy3;
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy212;
	if (yych <= '6') goto yy213;
	goto yy55;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy181;
	goto yy55;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy181;
	goto yy55;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy215;
	if (yych <= '6') goto yy216;
	goto yy3;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy181;
	goto yy55;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy181;
	goto yy55;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy183;
			if (yych >= 'E') goto yy220;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'd') goto yy218;
			if (yych <= 'e') goto yy220;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'M') goto yy184;
			goto yy226;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy184;
			if (yych >= 'a') goto yy184;
		} else {
			if (yych <= 'n') goto yy226;
			if (yych <= 'z') goto yy184;
		}
	}
yy219:
	YYDEBUG(219, *YYCURSOR);
#line 1780 "ext/date/lib/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit(&ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 4180 "<stdout>"
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy184;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'k') goto yy221;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy185;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'd') goto yy222;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy186;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy223;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy224;
		if (yych != 'y') goto yy3;
	}
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy225;
	if (yych != 's') goto yy219;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy219;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy185;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'e') goto yy227;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy186;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 's') goto yy228;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy228:
	YYDEBUG(228, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy229;
		if (yych != 'd') goto yy3;
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy230;
	if (yych != 'a') goto yy55;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy231;
	if (yych != 'y') goto yy55;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy225;
	if (yych == 's') goto yy225;
	goto yy219;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy189;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy183;
				goto yy218;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy220;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy188;
			} else {
				if (yych <= 'e') goto yy234;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
	YYDEBUG(233, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy226;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 'n') goto yy240;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy234:
	YYDEBUG(234, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy221;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'k') goto yy235;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy235:
	YYDEBUG(235, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy222;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'd') goto yy236;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy223;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy237;
			if (yych <= 'z') goto yy194;
			goto yy3;
		}
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy224;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'y') goto yy238;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy238:
	YYDEBUG(238, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy189;
			goto yy219;
		} else {
			if (yych <= '/') goto yy189;
			if (yych <= 'R') goto yy219;
			goto yy225;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy189;
		goto yy219;
	} else {
		if (yych <= '/') goto yy189;
		if (yych == '_') goto yy189;
		goto yy219;
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy227;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'e') goto yy241;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy228;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 's') goto yy242;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy229;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'd') goto yy243;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy230;
	if (yych != 'a') goto yy196;
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy231;
	if (yych != 'y') goto yy196;
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy189;
			goto yy219;
		} else {
			if (yych <= '/') goto yy189;
			if (yych <= 'R') goto yy219;
			goto yy225;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy183;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'c') goto yy247;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy250;
			} else {
				if (yych == ' ') goto yy250;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
			} else {
				if (yych == 'E') goto yy255;
				goto yy184;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy184;
			} else {
				if (yych <= 'e') goto yy255;
				if (yych <= 'z') goto yy184;
			}
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
#line 1839 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4735 "<stdout>"
yy249:
	YYDEBUG(249, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
yy250:
	YYDEBUG(250, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy249;
	}
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy252;
	if (yych <= '3') goto yy253;
	if (yych <= '9') goto yy254;
	goto yy55;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy250;
	if (yych <= '0') goto yy365;
	if (yych <= '2') goto yy366;
	if (yych <= '3') goto yy367;
	goto yy250;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy364;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy364;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy260;
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy260;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy185;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'm') goto yy256;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy186;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'b') goto yy257;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy258;
		if (yych != 'e') goto yy3;
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy259;
	if (yych != 'r') goto yy55;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy250;
		if (yych <= 0x1F) goto yy248;
		goto yy250;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy248;
			goto yy250;
		} else {
			if (yych <= '/') goto yy248;
			if (yych <= '9') goto yy250;
			goto yy248;
		}
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy361;
	goto yy55;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy360;
	goto yy267;
yy262:
	YYDEBUG(262, *YYCURSOR);
#line 1585 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 4997 "<stdout>"
yy263:
	YYDEBUG(263, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy360;
	goto yy267;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy360;
	goto yy267;
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy360;
	goto yy267;
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy267:
	YYDEBUG(267, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy266;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy262;
		if (yych <= '0') goto yy351;
		if (yych <= '1') goto yy352;
		goto yy353;
	} else {
		if (yych <= '9') goto yy354;
		if (yych == 'T') goto yy269;
		goto yy262;
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych <= '/') goto yy262;
			goto yy270;
		} else {
			if (yych <= '1') goto yy271;
			if (yych <= '2') goto yy272;
			goto yy273;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= 'S') goto yy262;
		} else {
			if (yych != 't') goto yy262;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy349;
	if (yych <= '2') goto yy350;
	if (yych <= '9') goto yy339;
	goto yy55;
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy55;
	} else {
		if (yych <= '0') goto yy339;
		if (yych <= '9') goto yy273;
		if (yych <= ':') goto yy340;
		goto yy55;
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy55;
	} else {
		if (yych <= '2') goto yy273;
		if (yych <= '9') goto yy339;
		if (yych <= ':') goto yy274;
		goto yy55;
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy55;
	} else {
		if (yych <= '4') goto yy339;
		if (yych == ':') goto yy274;
		goto yy55;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy274;
	if (yych != ':') goto yy55;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy275;
	if (yych <= '9') goto yy277;
	goto yy55;
yy275:
	YYDEBUG(275, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy278;
	} else {
		if (yych <= '9') goto yy332;
		if (yych <= ':') goto yy278;
	}
yy276:
	YYDEBUG(276, *YYCURSOR);
#line 1887 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 5153 "<stdout>"
yy277:
	YYDEBUG(277, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy278;
	if (yych != ':') goto yy276;
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy279;
	if (yych <= '6') goto yy280;
	if (yych <= '9') goto yy281;
	goto yy55;
yy279:
	YYDEBUG(279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy282;
	goto yy276;
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy282;
	goto yy276;
yy281:
	YYDEBUG(281, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy276;
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy284;
			goto yy276;
		} else {
			if (yych <= ' ') goto yy284;
			if (yych == '(') goto yy284;
			goto yy276;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy276;
			if (yych <= '-') goto yy284;
			goto yy276;
		} else {
			if (yych <= 'Z') goto yy284;
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy284;
			goto yy276;
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy284:
	YYDEBUG(284, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy55;
				goto yy283;
			} else {
				if (yych == ' ') goto yy283;
				goto yy55;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy287;
				if (yych <= '*') goto yy55;
				goto yy286;
			} else {
				if (yych == '-') goto yy286;
				goto yy55;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy288;
				if (yych <= 'F') goto yy289;
			} else {
				if (yych == 'P') goto yy288;
				goto yy289;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy55;
				if (yych <= 'a') goto yy290;
				goto yy291;
			} else {
				if (yych <= 'p') goto yy290;
				if (yych <= 'z') goto yy291;
				goto yy55;
			}
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy281;
		if (yych <= '@') goto yy276;
		goto yy292;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy330;
			goto yy292;
		} else {
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy303;
			goto yy276;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy314;
	if (yych <= '2') goto yy315;
	if (yych <= '9') goto yy316;
	goto yy55;
yy287:
	YYDEBUG(287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy55;
	if (yych <= 'Z') goto yy291;
	if (yych <= '`') goto yy55;
	if (yych <= 'z') goto yy291;
	goto yy55;
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy281;
			goto yy276;
		} else {
			if (yych <= '.') goto yy297;
			if (yych <= '@') goto yy276;
			goto yy292;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy298;
			if (yych <= 'Z') goto yy292;
			goto yy276;
		} else {
			if (yych == 'm') goto yy313;
			if (yych <= 'z') goto yy303;
			goto yy276;
		}
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy281;
		goto yy276;
	} else {
		if (yych <= 'Z') goto yy292;
		if (yych <= '`') goto yy276;
		if (yych <= 'z') goto yy303;
		goto yy276;
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy281;
			goto yy276;
		} else {
			if (yych <= '.') goto yy297;
			if (yych <= '@') goto yy276;
			goto yy292;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy298;
			if (yych <= 'Z') goto yy292;
			goto yy276;
		} else {
			if (yych == 'm') goto yy298;
			if (yych <= 'z') goto yy292;
			goto yy276;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy281;
		goto yy276;
	} else {
		if (yych <= 'Z') goto yy292;
		if (yych <= '`') goto yy276;
		if (yych >= '{') goto yy276;
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy281;
		goto yy276;
	} else {
		if (yych <= 'Z') goto yy293;
		if (yych <= '`') goto yy276;
		if (yych >= '{') goto yy276;
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy281;
		goto yy276;
	} else {
		if (yych <= 'Z') goto yy294;
		if (yych <= '`') goto yy276;
		if (yych >= '{') goto yy276;
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy281;
		goto yy276;
	} else {
		if (yych <= 'Z') goto yy295;
		if (yych <= '`') goto yy276;
		if (yych >= '{') goto yy276;
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy281;
		goto yy276;
	} else {
		if (yych <= 'Z') goto yy296;
		if (yych <= '`') goto yy276;
		if (yych >= '{') goto yy276;
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy281;
	goto yy276;
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy302;
	if (yych == 'm') goto yy302;
	goto yy55;
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy300;
			if (yych <= 0x08) goto yy276;
			goto yy300;
		} else {
			if (yych == ' ') goto yy300;
			if (yych <= '(') goto yy276;
			goto yy281;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy276;
		} else {
			if (yych <= 'Z') goto yy293;
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy293;
			goto yy276;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy300;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(301, *YYCURSOR);
#line 1863 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}

		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 5474 "<stdout>"
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy300;
		if (yych == '\t') goto yy300;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy300;
		if (yych == '.') goto yy299;
		goto yy55;
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy281;
			goto yy276;
		} else {
			if (yych == '.') goto yy276;
			goto yy305;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy276;
			if (yych <= 'Z') goto yy293;
			goto yy276;
		} else {
			if (yych <= '_') goto yy305;
			if (yych <= '`') goto yy276;
			if (yych >= '{') goto yy276;
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy281;
			goto yy276;
		} else {
			if (yych == '.') goto yy276;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy276;
			if (yych <= 'Z') goto yy294;
			goto yy276;
		} else {
			if (yych <= '_') goto yy305;
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy308;
			goto yy276;
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy55;
	if (yych <= 'Z') goto yy306;
	if (yych <= '`') goto yy55;
	if (yych >= '{') goto yy55;
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(307, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy276;
			goto yy305;
		} else {
			if (yych == '/') goto yy305;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy306;
			if (yych <= '^') goto yy276;
			goto yy305;
		} else {
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy306;
			goto yy276;
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy281;
			goto yy276;
		} else {
			if (yych == '.') goto yy276;
			goto yy305;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy276;
			if (yych <= 'Z') goto yy295;
			goto yy276;
		} else {
			if (yych <= '_') goto yy305;
			if (yych <= '`') goto yy276;
			if (yych >= '{') goto yy276;
		}
	}
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy281;
			goto yy276;
		} else {
			if (yych == '.') goto yy276;
			goto yy305;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy276;
			if (yych <= 'Z') goto yy296;
			goto yy276;
		} else {
			if (yych <= '_') goto yy305;
			if (yych <= '`') goto yy276;
			if (yych >= '{') goto yy276;
		}
	}
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy281;
		} else {
			if (yych == '-') goto yy305;
			goto yy276;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy305;
			if (yych <= '^') goto yy276;
			goto yy305;
		} else {
			if (yych <= '`') goto yy276;
			if (yych >= '{') goto yy276;
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(312, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy305;
		if (yych <= '.') goto yy55;
		goto yy305;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy55;
			goto yy305;
		} else {
			if (yych <= '`') goto yy55;
			if (yych <= 'z') goto yy311;
			goto yy55;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy300;
			if (yych == '\t') goto yy300;
			goto yy276;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy300;
				goto yy276;
			} else {
				if (yych <= ')') goto yy281;
				if (yych <= ',') goto yy276;
				goto yy305;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy299;
			if (yych <= '/') goto yy305;
			if (yych <= '@') goto yy276;
			goto yy293;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy276;
				goto yy305;
			} else {
				if (yych <= '`') goto yy276;
				if (yych <= 'z') goto yy304;
				goto yy276;
			}
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy319;
	if (yych <= ':') goto yy317;
	goto yy276;
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy276;
		if (yych <= '4') goto yy319;
		goto yy318;
	} else {
		if (yych <= '9') goto yy281;
		if (yych <= ':') goto yy317;
		goto yy276;
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy276;
	if (yych <= '5') goto yy318;
	if (yych <= '9') goto yy281;
	if (yych >= ';') goto yy276;
yy317:
	YYDEBUG(317, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy318;
	if (yych <= '9') goto yy281;
	goto yy55;
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy281;
	goto yy276;
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy276;
	if (yych <= '5') goto yy320;
	if (yych <= '9') goto yy281;
	if (yych <= ':') goto yy321;
	goto yy276;
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy327;
	goto yy276;
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy322;
	if (yych <= '9') goto yy281;
	goto yy55;
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych >= ':') goto yy276;
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy276;
	YYDEBUG(324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy325;
	if (yych <= '6') goto yy326;
	goto yy55;
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy281;
	goto yy55;
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy281;
	goto yy55;
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy276;
	if (yych <= '5') goto yy328;
	if (yych <= '6') goto yy329;
	goto yy276;
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy281;
	goto yy55;
yy329:
	YYDEBUG(329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy281;
	goto yy55;
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy281;
		if (yych <= '@') goto yy276;
		goto yy293;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy293;
		} else {
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy293;
			goto yy276;
		}
	}
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy276;
			goto yy281;
		} else {
			if (yych == '+') goto yy286;
			goto yy276;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy286;
			if (yych <= '@') goto yy276;
			goto yy294;
		} else {
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy294;
			goto yy276;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy333;
			if (yych <= 0x1F) goto yy276;
		} else {
			if (yych == '.') goto yy278;
			if (yych <= '9') goto yy276;
			goto yy278;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy335;
			if (yych <= 'O') goto yy276;
			goto yy335;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy276;
				goto yy335;
			} else {
				if (yych == 'p') goto yy335;
				goto yy276;
			}
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(334, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy333;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy333;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy335;
			if (yych != 'p') goto yy55;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy337;
		if (yych == 'm') goto yy337;
		goto yy55;
	}
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy337;
	if (yych != 'm') goto yy55;
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy300;
		if (yych == '\t') goto yy300;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy300;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy300;
		if (yych <= 0x08) goto yy55;
		goto yy300;
	} else {
		if (yych == ' ') goto yy300;
		goto yy55;
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy340;
	if (yych != ':') goto yy55;
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy341;
	if (yych <= '9') goto yy342;
	goto yy55;
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy343;
		goto yy276;
	} else {
		if (yych <= '9') goto yy342;
		if (yych <= ':') goto yy343;
		goto yy276;
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy343;
	if (yych != ':') goto yy276;
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy344;
	if (yych <= '6') goto yy345;
	if (yych <= '9') goto yy281;
	goto yy55;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy346;
	goto yy276;
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy276;
yy346:
	YYDEBUG(346, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy348;
			goto yy276;
		} else {
			if (yych <= ' ') goto yy348;
			if (yych == '(') goto yy348;
			goto yy276;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy276;
			if (yych <= '-') goto yy348;
			goto yy276;
		} else {
			if (yych <= 'Z') goto yy348;
			if (yych <= '`') goto yy276;
			if (yych <= 'z') goto yy348;
			goto yy276;
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy348:
	YYDEBUG(348, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy347;
			if (yych <= 0x1F) goto yy55;
			goto yy347;
		} else {
			if (yych == '(') goto yy287;
			if (yych <= '*') goto yy55;
			goto yy286;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy286;
			if (yych <= '@') goto yy55;
			goto yy289;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy285;
				goto yy289;
			} else {
				if (yych <= '`') goto yy55;
				if (yych <= 'z') goto yy291;
				goto yy55;
			}
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy55;
	} else {
		if (yych <= '9') goto yy339;
		if (yych <= ':') goto yy340;
		goto yy55;
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy55;
	} else {
		if (yych <= '4') goto yy339;
		if (yych == ':') goto yy340;
		goto yy55;
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy262;
	} else {
		if (yych <= '0') goto yy358;
		if (yych <= '9') goto yy359;
		if (yych <= ':') goto yy340;
		goto yy262;
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy262;
	} else {
		if (yych <= '2') goto yy359;
		if (yych <= '9') goto yy358;
		if (yych <= ':') goto yy274;
		goto yy262;
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy262;
	} else {
		if (yych <= '4') goto yy358;
		if (yych <= '9') goto yy355;
		if (yych <= ':') goto yy274;
		goto yy262;
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy262;
	} else {
		if (yych <= '9') goto yy355;
		if (yych <= ':') goto yy274;
		goto yy262;
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy262;
	if (yych >= ':') goto yy262;
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy262;
	if (yych >= ':') goto yy262;
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy262;
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy340;
		goto yy262;
	} else {
		if (yych <= '9') goto yy356;
		if (yych <= ':') goto yy340;
		goto yy262;
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy274;
		goto yy262;
	} else {
		if (yych <= '9') goto yy356;
		if (yych <= ':') goto yy274;
		goto yy262;
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy268;
	goto yy267;
yy361:
	YYDEBUG(361, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(362, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(363, *YYCURSOR);
#line 1557 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 6165 "<stdout>"
yy364:
	YYDEBUG(364, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy361;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy368;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy368;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy266;
				goto yy55;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy260;
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy268;
				goto yy55;
			} else {
				if (yych <= '\t') goto yy266;
				if (yych <= 0x1F) goto yy55;
				goto yy266;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy55;
				if (yych <= ',') goto yy266;
			} else {
				if (yych <= '.') goto yy266;
				if (yych <= '/') goto yy55;
				goto yy361;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy55;
				goto yy266;
			} else {
				if (yych == 'h') goto yy266;
				goto yy55;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy263;
				if (yych <= 'q') goto yy55;
				goto yy264;
			} else {
				if (yych <= 's') goto yy261;
				if (yych <= 't') goto yy265;
				goto yy55;
			}
		}
	}
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(370, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy371;
	if (yych <= '9') goto yy372;
yy371:
	YYDEBUG(371, *YYCURSOR);
#line 1701 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 6409 "<stdout>"
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy371;
	if (yych >= ':') goto yy371;
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy371;
	if (yych >= ':') goto yy371;
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy371;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy247;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'c') goto yy376;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'E') goto yy255;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'e') goto yy378;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy190;
	}
	if (yych <= '/') goto yy250;
	if (yych <= '0') goto yy365;
	if (yych <= '2') goto yy366;
	if (yych <= '3') goto yy367;
	goto yy250;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy256;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'm') goto yy379;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy257;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'b') goto yy380;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy258;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'e') goto yy381;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy259;
	if (yych != 'r') goto yy196;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy248;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych <= ',') goto yy248;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy189;
			goto yy250;
		} else {
			if (yych == '_') goto yy189;
			goto yy248;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy190;
	}
	goto yy250;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy183;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 't') goto yy385;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'O') goto yy184;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'o') goto yy386;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy185;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'b') goto yy387;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy186;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'e') goto yy388;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy259;
		if (yych == 'r') goto yy259;
		goto yy3;
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy385;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 't') goto yy390;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'O') goto yy386;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'o') goto yy391;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy387;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'b') goto yy392;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy388;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'e') goto yy393;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy259;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'r') goto yy382;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy183;
			goto yy402;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'g') goto yy402;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy183;
			goto yy399;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'r') goto yy399;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy183;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'o') goto yy397;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy181;
	} else {
		if (yych <= 'Z') goto yy184;
		if (yych <= '`') goto yy398;
		if (yych <= 'z') goto yy184;
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
#line 1759 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7011 "<stdout>"
yy399:
	YYDEBUG(399, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'I') goto yy184;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'i') goto yy400;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy185;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'l') goto yy401;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy248;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych == ')') goto yy181;
			goto yy248;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy248;
			if (yych <= '9') goto yy250;
			goto yy248;
		} else {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy248;
			if (yych <= 'z') goto yy186;
			goto yy248;
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'U') goto yy184;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'u') goto yy403;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy185;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 's') goto yy404;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy186;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 't') goto yy405;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy248;
			goto yy250;
		} else {
			if (yych == ' ') goto yy250;
			goto yy248;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy181;
			if (yych <= ',') goto yy248;
			goto yy250;
		} else {
			if (yych <= '/') goto yy248;
			if (yych <= '9') goto yy250;
			goto yy248;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy402;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'g') goto yy413;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy399;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'r') goto yy410;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy397;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'o') goto yy409;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy398;
		} else {
			if (yych == '.') goto yy398;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy398;
			if (yych <= 'Z') goto yy184;
			goto yy398;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy398;
			if (yych <= 'z') goto yy192;
			goto yy398;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'I') goto yy400;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'i') goto yy411;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy401;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'l') goto yy412;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy248;
			goto yy250;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy248;
				goto yy181;
			} else {
				if (yych <= ',') goto yy248;
				if (yych <= '-') goto yy383;
				goto yy250;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy189;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy248;
			goto yy186;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy248;
				goto yy189;
			} else {
				if (yych <= '`') goto yy248;
				if (yych <= 'z') goto yy194;
				goto yy248;
			}
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'U') goto yy403;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'u') goto yy414;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy404;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 's') goto yy415;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy405;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 't') goto yy416;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy248;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych == ')') goto yy181;
			goto yy248;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy383;
			if (yych <= '.') goto yy250;
			goto yy189;
		} else {
			if (yych <= '9') goto yy250;
			if (yych == '_') goto yy189;
			goto yy248;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'L') goto yy424;
			if (yych <= 'M') goto yy183;
			goto yy423;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy183;
			goto yy424;
		} else {
			if (yych == 'n') goto yy423;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy183;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'n') goto yy419;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'U') goto yy184;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'u') goto yy420;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy185;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy421;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy186;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'r') goto yy422;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy259;
		if (yych == 'y') goto yy259;
		goto yy3;
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych == 'E') goto yy425;
				goto yy184;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'e') goto yy425;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'Y') goto yy184;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'y') goto yy425;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy248;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych == ')') goto yy181;
			goto yy248;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy248;
			if (yych <= '9') goto yy250;
			goto yy248;
		} else {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy248;
			if (yych <= 'z') goto yy185;
			goto yy248;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy189;
				goto yy3;
			} else {
				if (yych == 'L') goto yy424;
				goto yy183;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy423;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy433;
				goto yy188;
			} else {
				if (yych <= 'n') goto yy432;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy419;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'n') goto yy428;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'U') goto yy420;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'u') goto yy429;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy421;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy430;
			if (yych <= 'z') goto yy193;
			goto yy3;
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy422;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'r') goto yy431;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy259;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'y') goto yy382;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'E') goto yy425;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'e') goto yy434;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'Y') goto yy425;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'y') goto yy434;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy248;
			goto yy250;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy248;
				goto yy181;
			} else {
				if (yych <= ',') goto yy248;
				if (yych <= '-') goto yy383;
				goto yy250;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy189;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy248;
			goto yy185;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy248;
				goto yy189;
			} else {
				if (yych <= '`') goto yy248;
				if (yych <= 'z') goto yy193;
				goto yy248;
			}
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy3;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy250;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy183;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy183;
				goto yy3;
			}
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych == ')') goto yy181;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy250;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy3;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy250;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy183;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy183;
				goto yy3;
			}
		}
	}
	YYDEBUG(438, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy3;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy250;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy184;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy184;
				goto yy3;
			}
		}
	}
	YYDEBUG(439, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych == ')') goto yy181;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy250;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy250;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy250;
			if (yych == ')') goto yy181;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy250;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy3;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy250;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy436;
				goto yy183;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy183;
				goto yy3;
			}
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy487;
				} else {
					if (yych <= ':') goto yy204;
					if (yych <= 'C') goto yy3;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy3;
					goto yy59;
				} else {
					if (yych == 'H') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy3;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy487;
					goto yy447;
				} else {
					if (yych <= '9') goto yy448;
					if (yych <= ':') goto yy204;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy447;
				} else {
					if (yych <= '9') goto yy448;
					if (yych <= ':') goto yy204;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 24) YYFILL(24);
	yych = *YYCURSOR;
	YYDEBUG(446, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy56;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy445;
		goto yy55;
	} else {
		if (yych <= '-') goto yy445;
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy54;
		goto yy55;
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy486;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy452;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy463;
	goto yy59;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy453;
	if (yych <= '1') goto yy454;
	goto yy55;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy455;
	goto yy55;
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy457;
	if (yych <= '2') goto yy458;
	if (yych <= '3') goto yy459;
	goto yy55;
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy460;
	goto yy55;
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy460;
	goto yy55;
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy460:
	YYDEBUG(460, *YYCURSOR);
	++YYCURSOR;
yy461:
	YYDEBUG(461, *YYCURSOR);
#line 1450 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_signed_nr(s, &ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 8811 "<stdout>"
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy477;
	if (yych <= '1') goto yy478;
	goto yy55;
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	goto yy55;
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy479;
	goto yy55;
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy481;
	if (yych <= '2') goto yy482;
	if (yych <= '3') goto yy483;
	goto yy55;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy484;
	goto yy55;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy484;
	goto yy55;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy484:
	YYDEBUG(484, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(485, *YYCURSOR);
#line 1476 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601datex");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_signed_nr(s, &ptr, 19);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 8944 "<stdout>"
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy450;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy486;
					if (yych <= ':') goto yy208;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych == 'D') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy3;
				if (yych <= 'H') goto yy59;
				goto yy3;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy3;
				} else {
					if (yych == 'V') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy3;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '9') {
			if (yych <= ',') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy3;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= '/') {
					if (yych <= '-') goto yy452;
					goto yy3;
				} else {
					if (yych <= '5') goto yy490;
					if (yych <= '6') goto yy491;
					goto yy451;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy59;
				} else {
					if (yych == 'F') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy59;
					if (yych <= 'R') goto yy3;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych <= 'W') {
					if (yych <= 'V') goto yy3;
					goto yy59;
				} else {
					if (yych == 'Y') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy59;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'm') {
					if (yych <= 'l') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'r') goto yy3;
					if (yych <= 'u') goto yy59;
					goto yy3;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy462;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy492;
	goto yy59;
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy462;
		goto yy59;
	} else {
		if (yych <= '0') goto yy492;
		if (yych <= '9') goto yy463;
		goto yy59;
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy3;
				goto yy59;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy3;
					goto yy462;
				} else {
					if (yych <= '/') goto yy3;
					if (yych <= '9') goto yy464;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'U') goto yy59;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy3;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy3;
				} else {
					if (yych == 'v') goto yy3;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy3;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy3;
				}
			}
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy495;
	if (yych <= '0') goto yy780;
	if (yych <= '1') goto yy781;
	if (yych <= '9') goto yy782;
	goto yy495;
yy494:
	YYDEBUG(494, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy495:
	YYDEBUG(495, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy494;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy494;
					if (yych <= ',') goto yy55;
					goto yy610;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy513;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy499;
					if (yych == 'F') goto yy500;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy64;
					if (yych <= 'I') goto yy508;
					goto yy512;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy496;
					if (yych <= 'N') goto yy515;
					goto yy514;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy517;
					if (yych <= 'R') goto yy55;
					goto yy497;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'U') goto yy62;
					if (yych <= 'V') goto yy510;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy511;
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy513;
					if (yych == 'd') goto yy499;
					goto yy55;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy500;
					if (yych <= 'g') goto yy55;
					goto yy64;
				} else {
					if (yych == 'j') goto yy512;
					if (yych <= 'l') goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy515;
					if (yych <= 'o') goto yy514;
					goto yy517;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy497;
					if (yych <= 't') goto yy69;
					goto yy62;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy68;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy67;
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy625;
			if (yych <= 'H') goto yy55;
			goto yy154;
		} else {
			if (yych == 'O') goto yy153;
			if (yych <= 'R') goto yy55;
			goto yy155;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy625;
			if (yych <= 'h') goto yy55;
			goto yy154;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy55;
				goto yy153;
			} else {
				if (yych == 's') goto yy155;
				goto yy55;
			}
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy1108;
			if (yych <= 'T') goto yy55;
			goto yy132;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy1108;
			if (yych == 'u') goto yy132;
			goto yy55;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy1108;
			if (yych == 'U') goto yy132;
			goto yy55;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy133;
			if (yych <= 'd') goto yy55;
			goto yy1108;
		} else {
			if (yych <= 's') goto yy55;
			if (yych <= 't') goto yy773;
			if (yych <= 'u') goto yy132;
			goto yy55;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy129;
		if (yych <= 'D') goto yy55;
		goto yy612;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy129;
		} else {
			if (yych == 'e') goto yy612;
			goto yy55;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy628;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy113;
			if (yych <= 'Q') goto yy55;
			goto yy112;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy628;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy113;
			if (yych == 'r') goto yy112;
			goto yy55;
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy81;
		if (yych <= 'T') goto yy55;
		goto yy82;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy1107;
		} else {
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy786;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy785;
	goto yy59;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy563;
		goto yy55;
	} else {
		if (yych <= 'd') goto yy773;
		if (yych == 'o') goto yy563;
		goto yy55;
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy773;
	goto yy55;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy699;
	case '3':	goto yy701;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy702;
	case 'A':
	case 'a':	goto yy706;
	case 'D':
	case 'd':	goto yy710;
	case 'F':
	case 'f':	goto yy704;
	case 'J':
	case 'j':	goto yy703;
	case 'M':
	case 'm':	goto yy705;
	case 'N':
	case 'n':	goto yy709;
	case 'O':
	case 'o':	goto yy708;
	case 'S':
	case 's':	goto yy707;
	default:	goto yy55;
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy649;
	case '1':	goto yy650;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy651;
	case 'A':
	case 'a':	goto yy655;
	case 'D':
	case 'd':	goto yy659;
	case 'F':
	case 'f':	goto yy653;
	case 'J':
	case 'j':	goto yy652;
	case 'M':
	case 'm':	goto yy654;
	case 'N':
	case 'n':	goto yy658;
	case 'O':
	case 'o':	goto yy657;
	case 'S':
	case 's':	goto yy656;
	default:	goto yy611;
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy611;
		if (yych <= '0') goto yy601;
		goto yy602;
	} else {
		if (yych <= '5') goto yy603;
		if (yych <= '9') goto yy604;
		goto yy611;
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '.') goto yy565;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy567;
			if (yych == 'I') goto yy600;
		} else {
			if (yych == 'W') goto yy509;
			if (yych <= 'X') goto yy573;
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
#line 1599 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 9709 "<stdout>"
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy565;
			if (yych <= '/') goto yy509;
			goto yy567;
		} else {
			if (yych == 'I') goto yy598;
			goto yy509;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy565;
			if (yych <= '/') goto yy509;
			goto yy567;
		} else {
			if (yych == 'I') goto yy597;
			goto yy509;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy590;
		if (yych <= 'T') goto yy55;
		goto yy589;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy590;
		} else {
			if (yych == 'u') goto yy589;
			goto yy55;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy518;
			goto yy55;
		} else {
			if (yych <= 'M') goto yy519;
			if (yych == 'P') goto yy583;
			goto yy55;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy582;
			if (yych == 'm') goto yy519;
			goto yy55;
		} else {
			if (yych <= 'p') goto yy583;
			if (yych == 'u') goto yy582;
			goto yy55;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy577;
	if (yych == 'c') goto yy577;
	goto yy55;
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy563;
	if (yych == 'o') goto yy563;
	goto yy55;
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy523;
	if (yych <= '9') goto yy525;
	goto yy55;
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy519;
		if (yych == 'm') goto yy519;
		goto yy55;
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy519;
	if (yych != 'm') goto yy55;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy521;
		if (yych == '\t') goto yy521;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy521;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy521;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(522, *YYCURSOR);
#line 1303 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);
			}
		}
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9866 "<stdout>"
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy526;
	} else {
		if (yych <= '9') goto yy540;
		if (yych <= ':') goto yy526;
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
#line 1340 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timetiny24 | timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);

				if (*ptr == '.') {
					s->time->us = timelib_get_frac_nr(&ptr);
				}
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 9906 "<stdout>"
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy526;
	if (yych != ':') goto yy524;
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy527;
	if (yych <= '6') goto yy528;
	if (yych <= '9') goto yy529;
	goto yy55;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych <= '9') goto yy533;
	goto yy524;
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych == '0') goto yy533;
	goto yy524;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy524;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy531;
	}
	goto yy55;
yy531:
	YYDEBUG(531, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(532, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy531;
	}
	goto yy524;
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy524;
		} else {
			if (yych <= ' ') goto yy534;
			if (yych == '.') goto yy530;
			goto yy524;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy536;
			if (yych == 'P') goto yy536;
			goto yy524;
		} else {
			if (yych <= 'a') goto yy536;
			if (yych == 'p') goto yy536;
			goto yy524;
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(535, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy534;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy534;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy536;
			if (yych != 'p') goto yy55;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy538;
		if (yych == 'm') goto yy538;
		goto yy55;
	}
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy538;
	if (yych != 'm') goto yy55;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy521;
		if (yych == '\t') goto yy521;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy521;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy521;
		if (yych <= 0x08) goto yy55;
		goto yy521;
	} else {
		if (yych == ' ') goto yy521;
		goto yy55;
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy541;
			if (yych <= 0x1F) goto yy524;
		} else {
			if (yych == '.') goto yy526;
			if (yych <= '9') goto yy524;
			goto yy544;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy543;
			if (yych <= 'O') goto yy524;
			goto yy543;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy524;
				goto yy543;
			} else {
				if (yych == 'p') goto yy543;
				goto yy524;
			}
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(542, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy541;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy541;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy543;
			if (yych != 'p') goto yy55;
		}
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy560;
		goto yy55;
	} else {
		if (yych <= 'M') goto yy561;
		if (yych == 'm') goto yy561;
		goto yy55;
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy545;
	if (yych <= '6') goto yy546;
	if (yych <= '9') goto yy529;
	goto yy55;
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych <= '9') goto yy547;
	goto yy524;
yy546:
	YYDEBUG(546, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych != '0') goto yy524;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy534;
			if (yych <= 0x1F) goto yy524;
			goto yy534;
		} else {
			if (yych == '.') goto yy548;
			if (yych <= '9') goto yy524;
			goto yy549;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy536;
			if (yych <= 'O') goto yy524;
			goto yy536;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy524;
				goto yy536;
			} else {
				if (yych == 'p') goto yy536;
				goto yy524;
			}
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy558;
	goto yy55;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy550:
	YYDEBUG(550, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(551, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy55;
			goto yy550;
		} else {
			if (yych != 'A') goto yy55;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy552;
			if (yych <= '`') goto yy55;
		} else {
			if (yych != 'p') goto yy55;
		}
	}
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy554;
		if (yych == 'm') goto yy554;
		goto yy55;
	}
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy554;
	if (yych != 'm') goto yy55;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy556;
		if (yych == '\t') goto yy556;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy556;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy556;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(557, *YYCURSOR);
#line 1320 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr);
			}
		}
		timelib_eat_spaces(&ptr);
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 10238 "<stdout>"
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(559, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy524;
			goto yy558;
		} else {
			if (yych == 'A') goto yy552;
			goto yy524;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy552;
			if (yych <= '`') goto yy524;
			goto yy552;
		} else {
			if (yych == 'p') goto yy552;
			goto yy524;
		}
	}
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy561;
	if (yych != 'm') goto yy55;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy521;
		if (yych == '\t') goto yy521;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy521;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy521;
		if (yych <= 0x08) goto yy55;
		goto yy521;
	} else {
		if (yych == ' ') goto yy521;
		goto yy55;
	}
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy564;
	if (yych != 'v') goto yy55;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy569;
			if (yych == 'e') goto yy569;
			goto yy509;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy566:
	YYDEBUG(566, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy565;
		if (yych <= 0x1F) goto yy55;
		goto yy565;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy55;
			goto yy565;
		} else {
			if (yych <= '/') goto yy55;
			if (yych >= ':') goto yy55;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy568;
	if (yych <= '9') goto yy574;
yy568:
	YYDEBUG(568, *YYCURSOR);
#line 1516 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 10358 "<stdout>"
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy570;
	if (yych != 'm') goto yy55;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy571;
	if (yych != 'b') goto yy55;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy572;
	if (yych != 'e') goto yy55;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy573;
	if (yych != 'r') goto yy55;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy565;
		if (yych <= 0x1F) goto yy509;
		goto yy565;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy509;
			goto yy565;
		} else {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy568;
	if (yych >= ':') goto yy568;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy568;
	if (yych >= ':') goto yy568;
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy568;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy578;
	if (yych != 't') goto yy55;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'O') goto yy579;
			if (yych != 'o') goto yy509;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy580;
	if (yych != 'b') goto yy55;
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy581;
	if (yych != 'e') goto yy55;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy573;
	if (yych == 'r') goto yy573;
	goto yy55;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy586;
	if (yych == 'g') goto yy586;
	goto yy55;
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy584;
	if (yych != 'r') goto yy55;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'I') goto yy585;
			if (yych != 'i') goto yy509;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy573;
	if (yych == 'l') goto yy573;
	goto yy55;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'U') goto yy587;
			if (yych != 'u') goto yy509;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy588;
	if (yych != 's') goto yy55;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy573;
	if (yych == 't') goto yy573;
	goto yy55;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy596;
		if (yych <= 'M') goto yy55;
		goto yy595;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy596;
		} else {
			if (yych == 'n') goto yy595;
			goto yy55;
		}
	}
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy591;
	if (yych != 'n') goto yy55;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'U') goto yy592;
			if (yych != 'u') goto yy509;
		}
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy593;
	if (yych != 'a') goto yy55;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy594;
	if (yych != 'r') goto yy55;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy573;
	if (yych == 'y') goto yy573;
	goto yy55;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy573;
			if (yych == 'e') goto yy573;
			goto yy509;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'Y') goto yy573;
			if (yych == 'y') goto yy573;
			goto yy509;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy565;
			if (yych <= '/') goto yy509;
			goto yy567;
		} else {
			if (yych == 'I') goto yy573;
			goto yy509;
		}
	}
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy565;
			if (yych <= '/') goto yy509;
			goto yy567;
		} else {
			if (yych != 'I') goto yy509;
		}
	}
	YYDEBUG(599, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy565;
			if (yych <= '/') goto yy509;
			goto yy567;
		} else {
			if (yych == 'I') goto yy573;
			goto yy509;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy565;
			if (yych <= '/') goto yy509;
			goto yy567;
		} else {
			if (yych == 'I') goto yy573;
			goto yy509;
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		goto yy634;
	} else {
		if (yych <= '/') goto yy524;
		if (yych <= '9') goto yy648;
		if (yych <= ':') goto yy526;
		goto yy524;
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		if (yych <= '.') goto yy634;
		goto yy524;
	} else {
		if (yych <= '2') goto yy648;
		if (yych <= '9') goto yy647;
		if (yych <= ':') goto yy526;
		goto yy524;
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		goto yy634;
	} else {
		if (yych <= '/') goto yy524;
		if (yych <= '9') goto yy647;
		if (yych <= ':') goto yy526;
		goto yy524;
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		goto yy634;
	} else {
		if (yych == ':') goto yy526;
		goto yy524;
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy628;
	if (yych == 'e') goto yy628;
	goto yy55;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy625;
	if (yych == 'a') goto yy625;
	goto yy55;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy583;
		if (yych <= 'T') goto yy55;
		goto yy582;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy583;
		} else {
			if (yych == 'u') goto yy582;
			goto yy55;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy618;
	if (yych == 'e') goto yy618;
	goto yy55;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy612;
	if (yych == 'e') goto yy612;
	goto yy55;
yy610:
	YYDEBUG(610, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy611:
	YYDEBUG(611, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy610;
	case 'A':
	case 'a':	goto yy607;
	case 'D':
	case 'd':	goto yy609;
	case 'F':
	case 'f':	goto yy605;
	case 'I':	goto yy508;
	case 'J':
	case 'j':	goto yy512;
	case 'M':
	case 'm':	goto yy606;
	case 'N':
	case 'n':	goto yy515;
	case 'O':
	case 'o':	goto yy514;
	case 'S':
	case 's':	goto yy608;
	case 'V':	goto yy510;
	case 'X':	goto yy511;
	default:	goto yy55;
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy613;
	if (yych != 'c') goto yy55;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy614;
			if (yych != 'e') goto yy509;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy615;
	if (yych != 'm') goto yy55;
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy616;
	if (yych != 'b') goto yy55;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy617;
	if (yych != 'e') goto yy55;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy573;
	if (yych == 'r') goto yy573;
	goto yy55;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy619;
	if (yych != 'p') goto yy55;
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'T') goto yy620;
			if (yych != 't') goto yy509;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy621;
			if (yych != 'e') goto yy509;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy622;
	if (yych != 'm') goto yy55;
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy623;
	if (yych != 'b') goto yy55;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy624;
	if (yych != 'e') goto yy55;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy573;
	if (yych == 'r') goto yy573;
	goto yy55;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy626;
		if (yych <= 'X') goto yy55;
		goto yy573;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy573;
			goto yy55;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'C') goto yy627;
			if (yych != 'c') goto yy509;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy573;
	if (yych == 'h') goto yy573;
	goto yy55;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy629;
	if (yych != 'b') goto yy55;
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			goto yy565;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'R') goto yy630;
			if (yych != 'r') goto yy509;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy631;
	if (yych != 'u') goto yy55;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy632;
	if (yych != 'a') goto yy55;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy633;
	if (yych != 'r') goto yy55;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy573;
	if (yych == 'y') goto yy573;
	goto yy55;
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy641;
	if (yych <= '6') goto yy642;
	if (yych <= '9') goto yy643;
	goto yy55;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(639, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(640, *YYCURSOR);
#line 1531 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 11105 "<stdout>"
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych <= '9') goto yy646;
	goto yy524;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy530;
		goto yy524;
	} else {
		if (yych <= '0') goto yy646;
		if (yych <= '9') goto yy644;
		goto yy524;
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych >= ':') goto yy524;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy645;
	if (yych <= '9') goto yy638;
yy645:
	YYDEBUG(645, *YYCURSOR);
#line 1543 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 11154 "<stdout>"
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy534;
			if (yych <= 0x1F) goto yy524;
			goto yy534;
		} else {
			if (yych == '.') goto yy530;
			if (yych <= '/') goto yy524;
			goto yy638;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy536;
			if (yych <= 'O') goto yy524;
			goto yy536;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy524;
				goto yy536;
			} else {
				if (yych == 'p') goto yy536;
				goto yy524;
			}
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy541;
			if (yych <= 0x1F) goto yy524;
			goto yy541;
		} else {
			if (yych == '.') goto yy526;
			if (yych <= '9') goto yy524;
			goto yy526;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy543;
			if (yych <= 'O') goto yy524;
			goto yy543;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy524;
				goto yy543;
			} else {
				if (yych == 'p') goto yy543;
				goto yy524;
			}
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy541;
			if (yych <= 0x1F) goto yy524;
			goto yy541;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy524;
				goto yy635;
			} else {
				if (yych <= '.') goto yy634;
				if (yych <= '9') goto yy524;
				goto yy526;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy543;
			if (yych <= 'O') goto yy524;
			goto yy543;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy524;
				goto yy543;
			} else {
				if (yych == 'p') goto yy543;
				goto yy524;
			}
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy688;
		goto yy635;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy651;
		goto yy55;
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy688;
		goto yy635;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy688;
	if (yych <= '.') goto yy635;
	goto yy55;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy684;
		if (yych <= 'T') goto yy55;
		goto yy683;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy684;
		} else {
			if (yych == 'u') goto yy683;
			goto yy55;
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy681;
	if (yych == 'e') goto yy681;
	goto yy55;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy678;
	if (yych == 'a') goto yy678;
	goto yy55;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy675;
		if (yych <= 'T') goto yy55;
		goto yy674;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy675;
		} else {
			if (yych == 'u') goto yy674;
			goto yy55;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy671;
	if (yych == 'e') goto yy671;
	goto yy55;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy669;
	if (yych == 'c') goto yy669;
	goto yy55;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy667;
	if (yych == 'o') goto yy667;
	goto yy55;
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy660;
	if (yych != 'e') goto yy55;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy661;
	if (yych != 'c') goto yy55;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych >= '.') goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy614;
			if (yych == 'e') goto yy614;
			goto yy509;
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy566;
	if (yych <= '0') goto yy663;
	if (yych <= '2') goto yy664;
	if (yych <= '3') goto yy665;
	goto yy566;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy568;
	if (yych <= '9') goto yy666;
	goto yy568;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy568;
	if (yych <= '9') goto yy666;
	goto yy568;
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy568;
	if (yych <= '1') goto yy666;
	if (yych <= '9') goto yy574;
	goto yy568;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy568;
	if (yych <= '9') goto yy575;
	goto yy568;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy668;
	if (yych != 'v') goto yy55;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy569;
			if (yych == 'e') goto yy569;
			goto yy509;
		}
	}
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy670;
	if (yych != 't') goto yy55;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'O') goto yy579;
			if (yych == 'o') goto yy579;
			goto yy509;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy672;
	if (yych != 'p') goto yy55;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'T') goto yy673;
			if (yych != 't') goto yy509;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy621;
			if (yych == 'e') goto yy621;
			goto yy509;
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy677;
	if (yych == 'g') goto yy677;
	goto yy55;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy676;
	if (yych != 'r') goto yy55;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'I') goto yy585;
			if (yych == 'i') goto yy585;
			goto yy509;
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'U') goto yy587;
			if (yych == 'u') goto yy587;
			goto yy509;
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy679;
		if (yych <= 'X') goto yy55;
		goto yy680;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy680;
			goto yy55;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'C') goto yy627;
			if (yych == 'c') goto yy627;
			goto yy509;
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy509;
			goto yy565;
		} else {
			if (yych == ' ') goto yy565;
			goto yy509;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy662;
			goto yy565;
		} else {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy682;
	if (yych != 'b') goto yy55;
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'R') goto yy630;
			if (yych == 'r') goto yy630;
			goto yy509;
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy687;
		if (yych <= 'M') goto yy55;
		goto yy686;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy687;
		} else {
			if (yych == 'n') goto yy686;
			goto yy55;
		}
	}
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy685;
	if (yych != 'n') goto yy55;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'U') goto yy592;
			if (yych == 'u') goto yy592;
			goto yy509;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'E') goto yy573;
			if (yych == 'e') goto yy573;
			goto yy509;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy565;
			goto yy509;
		} else {
			if (yych <= ' ') goto yy565;
			if (yych <= ',') goto yy509;
			if (yych <= '-') goto yy662;
			goto yy565;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy509;
			if (yych <= '9') goto yy567;
			goto yy509;
		} else {
			if (yych <= 'Y') goto yy573;
			if (yych == 'y') goto yy573;
			goto yy509;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy689;
	if (yych <= '3') goto yy691;
	if (yych <= '9') goto yy692;
	goto yy55;
yy689:
	YYDEBUG(689, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy698;
		if (yych >= 'n') goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
#line 1502 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 11808 "<stdout>"
yy691:
	YYDEBUG(691, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy690;
			goto yy698;
		} else {
			if (yych <= '9') goto yy637;
			if (yych <= 'm') goto yy690;
			goto yy694;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy637;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy697;
	goto yy55;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy697;
	goto yy55;
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy697;
	goto yy55;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy55;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy690;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy638;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy767;
		} else {
			if (yych <= '9') goto yy702;
			if (yych >= 'n') goto yy764;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy765;
		} else {
			if (yych <= 's') goto yy763;
			if (yych <= 't') goto yy766;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
#line 1434 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 11929 "<stdout>"
yy701:
	YYDEBUG(701, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy700;
			goto yy767;
		} else {
			if (yych <= '1') goto yy702;
			if (yych <= 'm') goto yy700;
			goto yy764;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy700;
			goto yy765;
		} else {
			if (yych <= 's') goto yy763;
			if (yych <= 't') goto yy766;
			goto yy700;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy767;
		if (yych <= 'm') goto yy700;
		goto yy764;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy700;
			goto yy765;
		} else {
			if (yych <= 's') goto yy763;
			if (yych <= 't') goto yy766;
			goto yy700;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy762;
		if (yych <= 'T') goto yy55;
		goto yy761;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy762;
		} else {
			if (yych == 'u') goto yy761;
			goto yy55;
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy760;
	if (yych == 'e') goto yy760;
	goto yy55;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy759;
	if (yych == 'a') goto yy759;
	goto yy55;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy758;
		if (yych <= 'T') goto yy55;
		goto yy757;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy758;
		} else {
			if (yych == 'u') goto yy757;
			goto yy55;
		}
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy755;
	if (yych == 'e') goto yy755;
	goto yy55;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy754;
	if (yych == 'c') goto yy754;
	goto yy55;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy753;
	if (yych == 'o') goto yy753;
	goto yy55;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy711;
	if (yych != 'e') goto yy55;
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy712;
	if (yych != 'c') goto yy55;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy55;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy719;
	if (yych <= '2') goto yy720;
	goto yy55;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy721;
	goto yy55;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '5') goto yy55;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy726;
	if (yych <= '6') goto yy727;
	goto yy55;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy728;
	goto yy55;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy55;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy729;
	if (yych != ' ') goto yy55;
yy729:
	YYDEBUG(729, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	YYDEBUG(730, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy729;
		} else {
			if (yych == ' ') goto yy729;
			goto yy55;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy55;
			goto yy732;
		} else {
			if (yych != 'G') goto yy55;
		}
	}
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy751;
	goto yy55;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy733;
	if (yych <= '2') goto yy735;
	if (yych <= '9') goto yy736;
	goto yy55;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy734;
	if (yych <= '9') goto yy740;
	if (yych <= ':') goto yy737;
yy734:
	YYDEBUG(734, *YYCURSOR);
#line 1729 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);
		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 12183 "<stdout>"
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy734;
		if (yych <= '4') goto yy740;
		goto yy738;
	} else {
		if (yych <= '9') goto yy739;
		if (yych <= ':') goto yy737;
		goto yy734;
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy734;
	if (yych <= '5') goto yy738;
	if (yych <= '9') goto yy739;
	if (yych >= ';') goto yy734;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy738;
	if (yych <= '9') goto yy739;
	goto yy55;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy734;
	if (yych >= ':') goto yy734;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy734;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy734;
	if (yych <= '5') goto yy741;
	if (yych <= '9') goto yy739;
	if (yych <= ':') goto yy742;
	goto yy734;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy734;
	if (yych <= '9') goto yy748;
	goto yy734;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy743;
	if (yych <= '9') goto yy739;
	goto yy55;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy734;
	if (yych >= ':') goto yy734;
	YYDEBUG(744, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy734;
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy746;
	if (yych <= '6') goto yy747;
	goto yy55;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy739;
	goto yy55;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy739;
	goto yy55;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy734;
	if (yych <= '5') goto yy749;
	if (yych <= '6') goto yy750;
	goto yy734;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy739;
	goto yy55;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy739;
	goto yy55;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy55;
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy732;
	if (yych == '-') goto yy732;
	goto yy55;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy712;
	if (yych == 'v') goto yy712;
	goto yy55;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy712;
	if (yych == 't') goto yy712;
	goto yy55;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy756;
	if (yych != 'p') goto yy55;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy713;
		goto yy55;
	} else {
		if (yych <= 'T') goto yy712;
		if (yych == 't') goto yy712;
		goto yy55;
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy712;
	if (yych == 'g') goto yy712;
	goto yy55;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy712;
	if (yych == 'r') goto yy712;
	goto yy55;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy712;
		if (yych <= 'X') goto yy55;
		goto yy712;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy712;
		} else {
			if (yych == 'y') goto yy712;
			goto yy55;
		}
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy712;
	if (yych == 'b') goto yy712;
	goto yy55;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy712;
		if (yych <= 'M') goto yy55;
		goto yy712;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy712;
		} else {
			if (yych == 'n') goto yy712;
			goto yy55;
		}
	}
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy712;
	if (yych == 'n') goto yy712;
	goto yy55;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy772;
	goto yy55;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy772;
	goto yy55;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy772;
	goto yy55;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy772;
	goto yy55;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych >= ':') goto yy700;
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych >= ':') goto yy700;
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych >= ':') goto yy700;
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy700;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy767;
	goto yy700;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy775;
		goto yy611;
	} else {
		if (yych <= '-') goto yy776;
		if (yych <= '.') goto yy775;
		if (yych >= '0') goto yy611;
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy706;
	case 'D':
	case 'd':	goto yy710;
	case 'F':
	case 'f':	goto yy704;
	case 'J':
	case 'j':	goto yy703;
	case 'M':
	case 'm':	goto yy705;
	case 'N':
	case 'n':	goto yy709;
	case 'O':
	case 'o':	goto yy708;
	case 'S':
	case 's':	goto yy707;
	default:	goto yy55;
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy611;
	if (yych <= '0') goto yy780;
	if (yych <= '1') goto yy781;
	if (yych <= '9') goto yy782;
	goto yy611;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy611;
	if (yych <= '0') goto yy777;
	if (yych <= '1') goto yy778;
	if (yych <= '9') goto yy779;
	goto yy611;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy635;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy779;
	goto yy55;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy635;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '.') goto yy635;
	goto yy55;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy635;
		goto yy783;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy782;
		goto yy55;
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy635;
		goto yy783;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy635;
	if (yych >= '/') goto yy55;
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy644;
	goto yy55;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy829;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy827;
	goto yy59;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy795;
	case '1':	goto yy796;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy797;
	case 'A':
	case 'a':	goto yy790;
	case 'D':
	case 'd':	goto yy794;
	case 'F':
	case 'f':	goto yy788;
	case 'J':
	case 'j':	goto yy787;
	case 'M':
	case 'm':	goto yy789;
	case 'N':
	case 'n':	goto yy793;
	case 'O':
	case 'o':	goto yy792;
	case 'S':
	case 's':	goto yy791;
	default:	goto yy55;
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy826;
		if (yych <= 'T') goto yy55;
		goto yy825;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy826;
		} else {
			if (yych == 'u') goto yy825;
			goto yy55;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy824;
	if (yych == 'e') goto yy824;
	goto yy55;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy823;
	if (yych == 'a') goto yy823;
	goto yy55;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy822;
		if (yych <= 'T') goto yy55;
		goto yy821;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy822;
		} else {
			if (yych == 'u') goto yy821;
			goto yy55;
		}
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy819;
	if (yych == 'e') goto yy819;
	goto yy55;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy818;
	if (yych == 'c') goto yy818;
	goto yy55;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy817;
	if (yych == 'o') goto yy817;
	goto yy55;
yy794:
	YYDEBUG(794, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy809;
	if (yych == 'e') goto yy809;
	goto yy55;
yy795:
	YYDEBUG(795, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy798;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy802;
	goto yy55;
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy798;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy802;
	goto yy55;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy799;
	if (yych <= '3') goto yy800;
	if (yych <= '9') goto yy801;
	goto yy55;
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy801;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '1') goto yy801;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy694;
		goto yy690;
	} else {
		if (yych <= 'r') goto yy695;
		if (yych <= 's') goto yy693;
		if (yych <= 't') goto yy696;
		goto yy690;
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy805;
	} else {
		if (yych <= '3') goto yy806;
		if (yych <= '9') goto yy801;
		goto yy55;
	}
	YYDEBUG(804, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy807;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy807;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '1') goto yy807;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy694;
	} else {
		if (yych <= 'r') goto yy695;
		if (yych <= 's') goto yy693;
		if (yych <= 't') goto yy696;
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
#line 1462 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 12816 "<stdout>"
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy810;
	if (yych != 'c') goto yy55;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '-') goto yy55;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy812;
	if (yych <= '2') goto yy813;
	if (yych <= '3') goto yy814;
	goto yy55;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy815;
	goto yy55;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy815;
	goto yy55;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy815:
	YYDEBUG(815, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(816, *YYCURSOR);
#line 1715 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 12868 "<stdout>"
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy810;
	if (yych == 'v') goto yy810;
	goto yy55;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy810;
	if (yych == 't') goto yy810;
	goto yy55;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy820;
	if (yych != 'p') goto yy55;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy811;
		goto yy55;
	} else {
		if (yych <= 'T') goto yy810;
		if (yych == 't') goto yy810;
		goto yy55;
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy810;
	if (yych == 'g') goto yy810;
	goto yy55;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy810;
	if (yych == 'r') goto yy810;
	goto yy55;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy810;
		if (yych <= 'X') goto yy55;
		goto yy810;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
			goto yy810;
		} else {
			if (yych == 'y') goto yy810;
			goto yy55;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy810;
	if (yych == 'b') goto yy810;
	goto yy55;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy810;
		if (yych <= 'M') goto yy55;
		goto yy810;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy810;
		} else {
			if (yych == 'n') goto yy810;
			goto yy55;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy810;
	if (yych == 'n') goto yy810;
	goto yy55;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy835;
				} else {
					if (yych <= ' ') goto yy835;
					if (yych >= '-') goto yy832;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy836;
					if (yych <= '/') goto yy833;
					goto yy849;
				} else {
					if (yych <= '1') goto yy850;
					if (yych <= '2') goto yy852;
					goto yy853;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy73;
					if (yych <= ':') goto yy851;
				} else {
					if (yych <= 'A') goto yy835;
					if (yych >= 'D') goto yy835;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy835;
				} else {
					if (yych <= 'J') goto yy835;
					if (yych >= 'M') goto yy835;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy828;
					if (yych <= 'V') goto yy835;
					goto yy854;
				} else {
					if (yych <= 'Y') goto yy835;
					if (yych >= 'a') goto yy835;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy835;
				} else {
					if (yych != 'g') goto yy835;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy835;
				} else {
					if (yych <= 'o') goto yy835;
					if (yych >= 's') goto yy835;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy835;
				} else {
					if (yych <= 'y') goto yy835;
					if (yych == 0xC2) goto yy835;
				}
			}
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
#line 1750 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 13041 "<stdout>"
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy830;
	case '1':	goto yy831;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy797;
	case 'A':
	case 'a':	goto yy790;
	case 'D':
	case 'd':	goto yy794;
	case 'F':
	case 'f':	goto yy788;
	case 'J':
	case 'j':	goto yy787;
	case 'M':
	case 'm':	goto yy789;
	case 'N':
	case 'n':	goto yy793;
	case 'O':
	case 'o':	goto yy792;
	case 'S':
	case 's':	goto yy791;
	default:	goto yy55;
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy798;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy797;
	goto yy55;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy798;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy797;
	goto yy55;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1017;
	case '1':	goto yy1019;
	case '2':	goto yy1020;
	case '3':	goto yy1021;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1022;
	case 'A':
	case 'a':	goto yy1011;
	case 'D':
	case 'd':	goto yy1015;
	case 'F':
	case 'f':	goto yy1009;
	case 'J':
	case 'j':	goto yy1008;
	case 'M':
	case 'm':	goto yy1010;
	case 'N':
	case 'n':	goto yy1014;
	case 'O':
	case 'o':	goto yy1013;
	case 'S':
	case 's':	goto yy1012;
	case 'W':	goto yy1016;
	default:	goto yy983;
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy991;
	if (yych <= '1') goto yy992;
	if (yych <= '9') goto yy993;
	goto yy55;
yy834:
	YYDEBUG(834, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy835:
	YYDEBUG(835, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy834;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy834;
					if (yych <= ',') goto yy55;
					goto yy982;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy844;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy848;
					if (yych == 'F') goto yy842;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy64;
					if (yych <= 'I') goto yy837;
					goto yy841;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy843;
					goto yy847;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy846;
					if (yych <= 'R') goto yy55;
					goto yy845;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'U') goto yy62;
					if (yych <= 'V') goto yy839;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy840;
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy844;
					if (yych <= 'c') goto yy55;
					goto yy848;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy842;
					goto yy55;
				} else {
					if (yych <= 'h') goto yy64;
					if (yych == 'j') goto yy841;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy843;
					if (yych <= 'n') goto yy847;
					goto yy846;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy845;
					if (yych <= 't') goto yy69;
					goto yy62;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy68;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy67;
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy983;
	if (yych <= '0') goto yy975;
	if (yych <= '2') goto yy976;
	if (yych <= '3') goto yy977;
	goto yy983;
yy837:
	YYDEBUG(837, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy974;
	} else {
		if (yych == 'W') goto yy838;
		if (yych <= 'X') goto yy928;
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
#line 1571 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 13259 "<stdout>"
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy972;
	goto yy838;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy971;
	goto yy838;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy964;
		if (yych <= 'T') goto yy55;
		goto yy963;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy964;
		} else {
			if (yych == 'u') goto yy963;
			goto yy55;
		}
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy957;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy113;
			if (yych <= 'Q') goto yy55;
			goto yy112;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy957;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy113;
			if (yych == 'r') goto yy112;
			goto yy55;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy954;
			if (yych <= 'H') goto yy55;
			goto yy154;
		} else {
			if (yych == 'O') goto yy153;
			if (yych <= 'R') goto yy55;
			goto yy155;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy954;
			if (yych <= 'h') goto yy55;
			goto yy154;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy55;
				goto yy153;
			} else {
				if (yych == 's') goto yy155;
				goto yy55;
			}
		}
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy948;
		if (yych <= 'T') goto yy55;
		goto yy947;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy948;
		} else {
			if (yych == 'u') goto yy947;
			goto yy55;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy940;
			if (yych <= 'T') goto yy55;
			goto yy132;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy133;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy940;
			if (yych == 'u') goto yy132;
			goto yy55;
		}
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy935;
	if (yych == 'c') goto yy935;
	goto yy55;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy929;
	if (yych == 'o') goto yy929;
	goto yy55;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy129;
		if (yych <= 'D') goto yy55;
		goto yy922;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy129;
		} else {
			if (yych == 'e') goto yy922;
			goto yy55;
		}
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy919;
	if (yych <= '9') goto yy920;
	goto yy59;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy888;
	if (yych <= '9') goto yy867;
	goto yy59;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy868;
	if (yych <= '1') goto yy869;
	goto yy55;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy867;
	goto yy59;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy863;
	if (yych <= '6') goto yy864;
	if (yych <= '9') goto yy74;
	goto yy59;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy55;
		if (yych <= '0') goto yy855;
		if (yych <= '4') goto yy856;
		goto yy857;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy55;
			goto yy96;
		} else {
			if (yych == 'e') goto yy96;
			goto yy55;
		}
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy55;
	if (yych <= '9') goto yy858;
	goto yy55;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy858;
	goto yy55;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '4') goto yy55;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy860;
	if (yych <= '/') goto yy859;
	if (yych <= '7') goto yy861;
yy859:
	YYDEBUG(859, *YYCURSOR);
#line 1682 "ext/date/lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 13498 "<stdout>"
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '8') goto yy55;
yy861:
	YYDEBUG(861, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(862, *YYCURSOR);
#line 1663 "ext/date/lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = timelib_get_nr(&ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 13526 "<stdout>"
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy865;
	goto yy59;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '6') goto yy865;
	if (yych <= '9') goto yy75;
	goto yy59;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy76;
				} else {
					if (yych == 'D') goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy866;
				if (yych <= 'H') goto yy59;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
				} else {
					if (yych != 'V') goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych >= 'd') goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy59;
				} else {
					if (yych == 'h') goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
				} else {
					if (yych != 'v') goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
				}
			}
		}
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
#line 1649 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = timelib_get_nr(&ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 13611 "<stdout>"
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy865;
	goto yy59;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy870;
	goto yy55;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '3') goto yy55;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy872;
	if (yych <= '2') goto yy873;
	if (yych <= '3') goto yy874;
	goto yy55;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy875;
	goto yy55;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy875;
	goto yy55;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '2') goto yy55;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy55;
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy877;
	if (yych <= '2') goto yy878;
	goto yy55;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy879;
	goto yy55;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '5') goto yy55;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy884;
	if (yych <= '6') goto yy885;
	goto yy55;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy886;
	goto yy55;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy55;
yy886:
	YYDEBUG(886, *YYCURSOR);
	++YYCURSOR;
yy887:
	YYDEBUG(887, *YYCURSOR);
#line 1623 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr(&ptr);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 13739 "<stdout>"
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy59;
		if (yych >= '1') goto yy890;
	} else {
		if (yych <= '3') goto yy891;
		if (yych <= '9') goto yy865;
		goto yy59;
	}
yy889:
	YYDEBUG(889, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy866;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy866;
					goto yy892;
				} else {
					if (yych == 'D') goto yy59;
					goto yy866;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy866;
				if (yych <= 'H') goto yy59;
				goto yy866;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy866;
				} else {
					if (yych == 'V') goto yy866;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy866;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy866;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy866;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy866;
				} else {
					if (yych == 'v') goto yy866;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy866;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy866;
				}
			}
		}
	}
yy890:
	YYDEBUG(890, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy866;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy866;
					goto yy892;
				} else {
					if (yych == 'D') goto yy59;
					goto yy866;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy866;
				if (yych <= 'H') goto yy59;
				goto yy866;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy866;
				} else {
					if (yych == 'V') goto yy866;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy866;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy866;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy866;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy866;
				} else {
					if (yych == 'v') goto yy866;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy866;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy866;
				}
			}
		}
	}
yy891:
	YYDEBUG(891, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy866;
				goto yy59;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy866;
				} else {
					if (yych <= '9') goto yy76;
					if (yych <= 'C') goto yy866;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy866;
					goto yy59;
				} else {
					if (yych == 'H') goto yy59;
					goto yy866;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy866;
				} else {
					if (yych == 'V') goto yy866;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy866;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy866;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy866;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy866;
				} else {
					if (yych == 'v') goto yy866;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy866;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy866;
				}
			}
		}
	}
yy892:
	YYDEBUG(892, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy58;
				} else {
					if (yych == ' ') goto yy58;
				}
			} else {
				if (yych <= 'C') {
					if (yych <= '9') goto yy77;
				} else {
					if (yych <= 'D') goto yy65;
					if (yych >= 'F') goto yy66;
				}
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') {
					if (yych >= 'H') goto yy64;
				} else {
					if (yych == 'M') goto yy60;
				}
			} else {
				if (yych <= 'T') {
					if (yych <= 'S') goto yy63;
					goto yy894;
				} else {
					if (yych <= 'U') goto yy62;
					if (yych >= 'W') goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych >= 'Y') goto yy67;
				} else {
					if (yych == 'd') goto yy65;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy66;
				} else {
					if (yych <= 'h') goto yy64;
					if (yych >= 'm') goto yy60;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych >= 's') goto yy63;
				} else {
					if (yych <= 't') goto yy895;
					if (yych <= 'u') goto yy62;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'w') goto yy68;
					if (yych >= 'y') goto yy67;
				} else {
					if (yych == 0xC2) goto yy61;
				}
			}
		}
	}
yy893:
	YYDEBUG(893, *YYCURSOR);
#line 1611 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 14046 "<stdout>"
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy55;
			if (yych <= '1') goto yy909;
			goto yy910;
		} else {
			if (yych <= '9') goto yy911;
			if (yych <= 'G') goto yy55;
			goto yy81;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy82;
			goto yy55;
		} else {
			if (yych <= 'h') goto yy81;
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy55;
			if (yych >= '2') goto yy897;
		} else {
			if (yych <= '9') goto yy898;
			if (yych <= 'G') goto yy55;
			goto yy81;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy82;
			goto yy55;
		} else {
			if (yych <= 'h') goto yy81;
			if (yych == 'u') goto yy82;
			goto yy55;
		}
	}
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy903;
	if (yych <= '9') goto yy898;
	goto yy55;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy903;
	if (yych <= '5') goto yy899;
	goto yy55;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy901;
	if (yych <= '6') goto yy902;
	goto yy55;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy886;
	goto yy55;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy886;
	goto yy55;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy904;
	if (yych <= '9') goto yy900;
	goto yy55;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy905;
	if (yych <= '6') goto yy906;
	if (yych <= '9') goto yy900;
	goto yy55;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy907;
	if (yych <= '6') goto yy908;
	if (yych <= '9') goto yy886;
	goto yy55;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy907;
	if (yych <= '5') goto yy901;
	if (yych <= '6') goto yy902;
	goto yy55;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy887;
	if (yych <= '9') goto yy886;
	goto yy887;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy886;
	goto yy887;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy918;
	if (yych <= '9') goto yy911;
	if (yych <= ':') goto yy912;
	goto yy55;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy55;
		if (yych <= '4') goto yy918;
		goto yy899;
	} else {
		if (yych == ':') goto yy912;
		goto yy55;
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy899;
	if (yych != ':') goto yy55;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= '6') goto yy55;
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy916;
	if (yych <= '6') goto yy917;
	goto yy55;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy886;
	goto yy55;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy886;
	goto yy55;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy904;
	if (yych <= '9') goto yy900;
	if (yych <= ':') goto yy912;
	goto yy55;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy59;
		if (yych <= '0') goto yy921;
		goto yy890;
	} else {
		if (yych <= '3') goto yy891;
		if (yych <= '9') goto yy865;
		goto yy59;
	}
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy59;
		if (yych <= '0') goto yy889;
		goto yy890;
	} else {
		if (yych <= '3') goto yy891;
		if (yych <= '9') goto yy865;
		goto yy59;
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy892;
	goto yy59;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy923;
	if (yych != 'c') goto yy55;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy924;
	if (yych != 'e') goto yy838;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy925;
	if (yych != 'm') goto yy55;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy926;
	if (yych != 'b') goto yy55;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy927;
	if (yych != 'e') goto yy55;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy928;
	if (yych != 'r') goto yy55;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy838;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy930;
	if (yych != 'v') goto yy55;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy931;
	if (yych != 'e') goto yy838;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy932;
	if (yych != 'm') goto yy55;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy933;
	if (yych != 'b') goto yy55;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy934;
	if (yych != 'e') goto yy55;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy928;
	if (yych == 'r') goto yy928;
	goto yy55;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy936;
	if (yych != 't') goto yy55;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy937;
	if (yych != 'o') goto yy838;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy938;
	if (yych != 'b') goto yy55;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy939;
	if (yych != 'e') goto yy55;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy928;
	if (yych == 'r') goto yy928;
	goto yy55;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy135;
		if (yych <= 'O') goto yy55;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy55;
			goto yy135;
		} else {
			if (yych != 'p') goto yy55;
		}
	}
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy942;
	if (yych != 't') goto yy838;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy943;
	if (yych != 'e') goto yy838;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy944;
	if (yych != 'm') goto yy55;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy945;
	if (yych != 'b') goto yy55;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy946;
	if (yych != 'e') goto yy55;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy928;
	if (yych == 'r') goto yy928;
	goto yy55;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy951;
	if (yych == 'g') goto yy951;
	goto yy55;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy949;
	if (yych != 'r') goto yy55;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy950;
	if (yych != 'i') goto yy838;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy928;
	if (yych == 'l') goto yy928;
	goto yy55;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy952;
	if (yych != 'u') goto yy838;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy953;
	if (yych != 's') goto yy55;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy928;
	if (yych == 't') goto yy928;
	goto yy55;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy955;
		if (yych <= 'X') goto yy55;
		goto yy928;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy928;
			goto yy55;
		}
	}
yy955:
	YYDEBUG(955, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy956;
	if (yych != 'c') goto yy838;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy928;
	if (yych == 'h') goto yy928;
	goto yy55;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy958;
	if (yych != 'b') goto yy55;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy959;
	if (yych != 'r') goto yy838;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy960;
	if (yych != 'u') goto yy55;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy961;
	if (yych != 'a') goto yy55;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy962;
	if (yych != 'r') goto yy55;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy928;
	if (yych == 'y') goto yy928;
	goto yy55;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy970;
		if (yych <= 'M') goto yy55;
		goto yy969;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy970;
		} else {
			if (yych == 'n') goto yy969;
			goto yy55;
		}
	}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy965;
	if (yych != 'n') goto yy55;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy966;
	if (yych != 'u') goto yy838;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy967;
	if (yych != 'a') goto yy55;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy968;
	if (yych != 'r') goto yy55;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy928;
	if (yych == 'y') goto yy928;
	goto yy55;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy928;
	if (yych == 'e') goto yy928;
	goto yy838;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy928;
	if (yych == 'y') goto yy928;
	goto yy838;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy928;
	goto yy838;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy838;
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy928;
	goto yy838;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy928;
	goto yy838;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy990;
	if (yych <= '9') goto yy989;
	goto yy55;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy988;
	goto yy55;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy986;
	if (yych <= '6') goto yy985;
	goto yy55;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy957;
	if (yych == 'e') goto yy957;
	goto yy55;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy954;
	if (yych == 'a') goto yy954;
	goto yy55;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy984;
	if (yych == 'e') goto yy984;
	goto yy55;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy922;
	if (yych == 'e') goto yy922;
	goto yy55;
yy982:
	YYDEBUG(982, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy983:
	YYDEBUG(983, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy982;
	case 'A':
	case 'a':	goto yy844;
	case 'D':
	case 'd':	goto yy981;
	case 'F':
	case 'f':	goto yy978;
	case 'I':	goto yy837;
	case 'J':
	case 'j':	goto yy841;
	case 'M':
	case 'm':	goto yy979;
	case 'N':
	case 'n':	goto yy847;
	case 'O':
	case 'o':	goto yy846;
	case 'S':
	case 's':	goto yy980;
	case 'V':	goto yy839;
	case 'X':	goto yy840;
	default:	goto yy55;
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy941;
	if (yych == 'p') goto yy941;
	goto yy55;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '6') goto yy987;
	goto yy55;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy866;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy987;
	goto yy55;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy987;
	goto yy55;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy55;
	if (yych <= '9') goto yy987;
	goto yy55;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy55;
	if (yych <= '/') goto yy994;
	if (yych <= '9') goto yy1002;
	goto yy55;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy55;
	if (yych <= '/') goto yy994;
	if (yych <= '2') goto yy1002;
	goto yy55;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy55;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy995;
	if (yych <= '3') goto yy996;
	if (yych <= '9') goto yy997;
	goto yy55;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy461;
		if (yych <= '9') goto yy997;
		if (yych <= 'm') goto yy461;
		goto yy999;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1000;
		} else {
			if (yych <= 's') goto yy998;
			if (yych <= 't') goto yy1001;
			goto yy461;
		}
	}
yy996:
	YYDEBUG(996, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy461;
		if (yych <= '1') goto yy997;
		if (yych <= 'm') goto yy461;
		goto yy999;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1000;
		} else {
			if (yych <= 's') goto yy998;
			if (yych <= 't') goto yy1001;
			goto yy461;
		}
	}
yy997:
	YYDEBUG(997, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy999;
		goto yy461;
	} else {
		if (yych <= 'r') goto yy1000;
		if (yych <= 's') goto yy998;
		if (yych <= 't') goto yy1001;
		goto yy461;
	}
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy460;
	goto yy55;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy460;
	goto yy55;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy460;
	goto yy55;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy460;
	goto yy55;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '/') goto yy55;
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy1005;
	} else {
		if (yych <= '3') goto yy1006;
		if (yych <= '9') goto yy997;
		goto yy55;
	}
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy461;
		if (yych <= '9') goto yy1007;
		if (yych <= 'm') goto yy461;
		goto yy999;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1000;
		} else {
			if (yych <= 's') goto yy998;
			if (yych <= 't') goto yy1001;
			goto yy461;
		}
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy461;
		if (yych <= '9') goto yy1007;
		if (yych <= 'm') goto yy461;
		goto yy999;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1000;
		} else {
			if (yych <= 's') goto yy998;
			if (yych <= 't') goto yy1001;
			goto yy461;
		}
	}
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy461;
		if (yych <= '1') goto yy1007;
		if (yych <= 'm') goto yy461;
		goto yy999;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1000;
		} else {
			if (yych <= 's') goto yy998;
			if (yych <= 't') goto yy1001;
			goto yy461;
		}
	}
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy460;
		if (yych <= 'm') goto yy461;
		goto yy999;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1000;
		} else {
			if (yych <= 's') goto yy998;
			if (yych <= 't') goto yy1001;
			goto yy461;
		}
	}
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1103;
		if (yych <= 'T') goto yy55;
		goto yy1102;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy55;
			goto yy1103;
		} else {
			if (yych == 'u') goto yy1102;
			goto yy55;
		}
	}
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1100;
	if (yych == 'e') goto yy1100;
	goto yy55;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1097;
	if (yych == 'a') goto yy1097;
	goto yy55;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1094;
		if (yych <= 'T') goto yy55;
		goto yy1093;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy55;
			goto yy1094;
		} else {
			if (yych == 'u') goto yy1093;
			goto yy55;
		}
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1090;
	if (yych == 'e') goto yy1090;
	goto yy55;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1088;
	if (yych == 'c') goto yy1088;
	goto yy55;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1086;
	if (yych == 'o') goto yy1086;
	goto yy55;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1084;
	if (yych == 'e') goto yy1084;
	goto yy55;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '0') goto yy855;
	if (yych <= '4') goto yy856;
	if (yych <= '5') goto yy857;
	goto yy55;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy1023;
	} else {
		if (yych <= '0') goto yy1082;
		if (yych <= '9') goto yy1083;
	}
yy1018:
	YYDEBUG(1018, *YYCURSOR);
#line 1488 "ext/date/lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 14981 "<stdout>"
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy1023;
		goto yy1018;
	} else {
		if (yych <= '2') goto yy1042;
		if (yych <= '9') goto yy988;
		goto yy1018;
	}
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1023;
	if (yych <= '/') goto yy1018;
	if (yych <= '9') goto yy988;
	goto yy1018;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy1023;
		goto yy1018;
	} else {
		if (yych <= '5') goto yy986;
		if (yych <= '6') goto yy985;
		goto yy1018;
	}
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy1018;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '2') goto yy1024;
	if (yych <= '3') goto yy1025;
	if (yych <= '9') goto yy1026;
	goto yy55;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy690;
			goto yy1026;
		} else {
			if (yych == 'T') goto yy1031;
			goto yy690;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1028;
			if (yych <= 'q') goto yy690;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy690;
		}
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy690;
		} else {
			if (yych == 'T') goto yy1031;
			goto yy690;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1028;
			if (yych <= 'q') goto yy690;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy690;
		}
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1031;
		if (yych <= 'm') goto yy690;
		goto yy1028;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy690;
		}
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1041;
	goto yy55;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1041;
	goto yy55;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1041;
	goto yy55;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1041;
	goto yy55;
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1032;
	if (yych <= '2') goto yy1033;
	if (yych <= '9') goto yy1034;
	goto yy55;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1034;
	if (yych <= ':') goto yy1035;
	goto yy55;
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1034;
	if (yych == ':') goto yy1035;
	goto yy55;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1036;
	if (yych <= '9') goto yy1037;
	goto yy55;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1037;
	if (yych <= ':') goto yy1038;
	goto yy55;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1039;
	if (yych <= '6') goto yy1040;
	if (yych <= '9') goto yy886;
	goto yy55;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy887;
	if (yych <= '9') goto yy886;
	goto yy887;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy886;
	goto yy887;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1031;
	goto yy690;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1043;
	if (yych <= '/') goto yy1018;
	if (yych <= '9') goto yy987;
	goto yy1018;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy1045;
	} else {
		if (yych <= '3') goto yy1046;
		if (yych <= '9') goto yy1026;
		goto yy55;
	}
	YYDEBUG(1044, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy690;
			goto yy1047;
		} else {
			if (yych == 'T') goto yy1031;
			goto yy690;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1028;
			if (yych <= 'q') goto yy690;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy690;
		}
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy690;
			goto yy1047;
		} else {
			if (yych == 'T') goto yy1031;
			goto yy690;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1028;
			if (yych <= 'q') goto yy690;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy690;
		}
	}
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy690;
		} else {
			if (yych == 'T') goto yy1031;
			goto yy690;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1028;
			if (yych <= 'q') goto yy690;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy690;
		}
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1048;
		if (yych <= 'm') goto yy461;
		goto yy1028;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy461;
			goto yy1029;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1030;
			goto yy461;
		}
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1049;
	if (yych <= '2') goto yy1050;
	if (yych <= '9') goto yy1034;
	goto yy55;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1051;
	if (yych <= ':') goto yy1035;
	goto yy55;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '4') goto yy1051;
	if (yych == ':') goto yy1035;
	goto yy55;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1053;
	if (yych <= '9') goto yy1037;
	goto yy55;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1054;
	if (yych <= ':') goto yy1038;
	goto yy55;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ':') goto yy55;
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1056;
	if (yych <= '6') goto yy1057;
	if (yych <= '9') goto yy886;
	goto yy55;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy887;
	if (yych <= '9') goto yy1058;
	goto yy887;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy887;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy887;
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yyaccept = 23;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	YYDEBUG(1061, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1063;
		if (yych <= ',') goto yy887;
		goto yy1063;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy887;
			goto yy1060;
		} else {
			if (yych != 'G') goto yy887;
		}
	}
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1080;
	goto yy55;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1064;
	if (yych <= '2') goto yy1065;
	if (yych <= '9') goto yy1066;
	goto yy55;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy887;
	if (yych <= '9') goto yy1069;
	if (yych <= ':') goto yy1067;
	goto yy887;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '5') {
		if (yych <= '/') goto yy887;
		if (yych <= '4') goto yy1069;
		goto yy1068;
	} else {
		if (yych <= '9') goto yy886;
		if (yych <= ':') goto yy1067;
		goto yy887;
	}
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy887;
	if (yych <= '5') goto yy1068;
	if (yych <= '9') goto yy886;
	if (yych >= ';') goto yy887;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1068;
	if (yych <= '9') goto yy886;
	goto yy55;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy887;
	if (yych <= '9') goto yy886;
	goto yy887;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy887;
	if (yych <= '5') goto yy1070;
	if (yych <= '9') goto yy886;
	if (yych <= ':') goto yy1071;
	goto yy887;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy887;
	if (yych <= '9') goto yy1077;
	goto yy887;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1072;
	if (yych <= '9') goto yy886;
	goto yy55;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy887;
	if (yych >= ':') goto yy887;
	YYDEBUG(1073, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != ':') goto yy887;
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1075;
	if (yych <= '6') goto yy1076;
	goto yy55;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy886;
	goto yy55;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy886;
	goto yy55;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy887;
	if (yych <= '5') goto yy1078;
	if (yych <= '6') goto yy1079;
	goto yy887;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy886;
	goto yy55;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy886;
	goto yy55;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy55;
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1063;
	if (yych == '-') goto yy1063;
	goto yy55;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1043;
	if (yych <= '0') goto yy1018;
	if (yych <= '9') goto yy987;
	goto yy1018;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1043;
	if (yych <= '/') goto yy1018;
	if (yych <= '9') goto yy987;
	goto yy1018;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1085;
	if (yych != 'c') goto yy55;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'E') goto yy924;
		if (yych == 'e') goto yy924;
		goto yy838;
	}
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1087;
	if (yych != 'v') goto yy55;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'E') goto yy931;
		if (yych == 'e') goto yy931;
		goto yy838;
	}
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1089;
	if (yych != 't') goto yy55;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'O') goto yy937;
		if (yych == 'o') goto yy937;
		goto yy838;
	}
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1091;
	if (yych != 'p') goto yy55;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'T') goto yy1092;
		if (yych != 't') goto yy838;
	}
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'E') goto yy943;
		if (yych == 'e') goto yy943;
		goto yy838;
	}
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1096;
	if (yych == 'g') goto yy1096;
	goto yy55;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1095;
	if (yych != 'r') goto yy55;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'I') goto yy950;
		if (yych == 'i') goto yy950;
		goto yy838;
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'U') goto yy952;
		if (yych == 'u') goto yy952;
		goto yy838;
	}
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1098;
		if (yych <= 'X') goto yy55;
		goto yy1099;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy55;
		} else {
			if (yych == 'y') goto yy1099;
			goto yy55;
		}
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'C') goto yy956;
		if (yych == 'c') goto yy956;
		goto yy838;
	}
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy811;
	goto yy838;
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1101;
	if (yych != 'b') goto yy55;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'R') goto yy959;
		if (yych == 'r') goto yy959;
		goto yy838;
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1106;
		if (yych <= 'M') goto yy55;
		goto yy1105;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy55;
			goto yy1106;
		} else {
			if (yych == 'n') goto yy1105;
			goto yy55;
		}
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1104;
	if (yych != 'n') goto yy55;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'U') goto yy966;
		if (yych == 'u') goto yy966;
		goto yy838;
	}
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'E') goto yy928;
		if (yych == 'e') goto yy928;
		goto yy838;
	}
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy811;
		goto yy838;
	} else {
		if (yych <= 'Y') goto yy928;
		if (yych == 'y') goto yy928;
		goto yy838;
	}
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy611;
			goto yy775;
		} else {
			if (yych <= ',') goto yy611;
			if (yych <= '-') goto yy776;
			goto yy775;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy774;
			if (yych <= 'T') goto yy611;
			goto yy90;
		} else {
			if (yych == 'u') goto yy90;
			goto yy611;
		}
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy135;
		if (yych <= 'O') goto yy55;
		goto yy619;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy55;
			goto yy135;
		} else {
			if (yych == 'p') goto yy619;
			goto yy55;
		}
	}
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1111;
			goto yy1113;
		} else {
			if (yych <= '-') goto yy1110;
			if (yych <= '.') goto yy775;
			if (yych <= '/') goto yy774;
			goto yy785;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy503;
			goto yy1113;
		} else {
			if (yych <= 'r') goto yy504;
			if (yych <= 's') goto yy498;
			if (yych <= 't') goto yy501;
			goto yy1113;
		}
	}
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1114;
	case '1':	goto yy1115;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy651;
	case 'A':
	case 'a':	goto yy655;
	case 'D':
	case 'd':	goto yy659;
	case 'F':
	case 'f':	goto yy653;
	case 'J':
	case 'j':	goto yy652;
	case 'M':
	case 'm':	goto yy654;
	case 'N':
	case 'n':	goto yy658;
	case 'O':
	case 'o':	goto yy657;
	case 'S':
	case 's':	goto yy656;
	default:	goto yy611;
	}
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1113;
	if (yych <= '0') goto yy780;
	if (yych <= '1') goto yy781;
	if (yych <= '9') goto yy782;
	goto yy1113;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy1112;
					goto yy55;
				} else {
					if (yych <= ' ') goto yy1112;
					if (yych <= ',') goto yy55;
					goto yy610;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy607;
					goto yy55;
				} else {
					if (yych <= 'D') goto yy499;
					if (yych == 'F') goto yy500;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy64;
					if (yych <= 'I') goto yy508;
					goto yy512;
				} else {
					if (yych <= 'L') goto yy55;
					if (yych <= 'M') goto yy496;
					goto yy515;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy514;
					if (yych <= 'R') goto yy55;
					goto yy497;
				} else {
					if (yych <= 'T') goto yy69;
					if (yych <= 'U') goto yy62;
					if (yych <= 'V') goto yy510;
					goto yy68;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy511;
					if (yych <= 'Y') goto yy67;
					goto yy55;
				} else {
					if (yych <= 'a') goto yy607;
					if (yych <= 'c') goto yy55;
					goto yy499;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy500;
					goto yy55;
				} else {
					if (yych <= 'h') goto yy64;
					if (yych == 'j') goto yy512;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy496;
					if (yych <= 'n') goto yy515;
					goto yy514;
				} else {
					if (yych <= 'r') goto yy55;
					if (yych <= 's') goto yy497;
					if (yych <= 't') goto yy69;
					goto yy62;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy68;
					goto yy55;
				} else {
					if (yych <= 'y') goto yy67;
					if (yych == 0xC2) goto yy61;
					goto yy55;
				}
			}
		}
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy688;
		goto yy635;
	} else {
		if (yych <= '/') goto yy55;
		if (yych <= '9') goto yy1116;
		goto yy55;
	}
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy55;
		if (yych <= '-') goto yy688;
		goto yy635;
	} else {
		if (yych <= '/') goto yy55;
		if (yych >= '3') goto yy55;
	}
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy55;
	if (yych <= '-') goto yy1117;
	if (yych <= '.') goto yy635;
	goto yy55;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy55;
		if (yych >= '1') goto yy1119;
	} else {
		if (yych <= '3') goto yy1120;
		if (yych <= '9') goto yy692;
		goto yy55;
	}
	YYDEBUG(1118, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy1121;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy690;
		if (yych <= '9') goto yy1121;
		if (yych <= 'm') goto yy690;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy690;
		} else {
			if (yych <= '9') goto yy637;
			if (yych <= 'm') goto yy690;
			goto yy694;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy690;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy690;
		}
	}
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy808;
		if (yych <= '9') goto yy638;
		if (yych <= 'm') goto yy808;
		goto yy694;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy808;
			goto yy695;
		} else {
			if (yych <= 's') goto yy693;
			if (yych <= 't') goto yy696;
			goto yy808;
		}
	}
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1111;
			if (yych <= ',') goto yy1113;
			goto yy1110;
		} else {
			if (yych <= '.') goto yy1123;
			if (yych <= '/') goto yy774;
			if (yych <= '5') goto yy1125;
			goto yy785;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1124;
			if (yych == 'n') goto yy503;
			goto yy1113;
		} else {
			if (yych <= 'r') goto yy504;
			if (yych <= 's') goto yy498;
			if (yych <= 't') goto yy501;
			goto yy1113;
		}
	}
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy611;
		if (yych <= '0') goto yy1147;
		goto yy1148;
	} else {
		if (yych <= '5') goto yy1149;
		if (yych <= '9') goto yy1150;
		goto yy611;
	}
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1142;
	if (yych <= '9') goto yy1143;
	goto yy55;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy829;
	if (yych <= '/') goto yy59;
	if (yych >= ':') goto yy59;
	YYDEBUG(1126, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy835;
				} else {
					if (yych <= ' ') goto yy835;
					if (yych >= '-') goto yy832;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy836;
					if (yych <= '/') goto yy833;
					goto yy1128;
				} else {
					if (yych <= '1') goto yy1129;
					if (yych <= '2') goto yy1130;
					goto yy1131;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy1132;
					if (yych <= '6') goto yy1133;
					goto yy73;
				} else {
					if (yych <= ':') goto yy851;
					if (yych >= 'A') goto yy835;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy835;
				} else {
					if (yych == 'G') goto yy1127;
					if (yych <= 'J') goto yy835;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy835;
					if (yych >= 'S') goto yy835;
				} else {
					if (yych <= 'W') goto yy854;
					if (yych <= 'Y') goto yy835;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy835;
					if (yych >= 'd') goto yy835;
				} else {
					if (yych == 'f') goto yy835;
					if (yych >= 'h') goto yy835;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy835;
				} else {
					if (yych <= 'o') goto yy835;
					if (yych >= 's') goto yy835;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy835;
				} else {
					if (yych <= 'y') goto yy835;
					if (yych == 0xC2) goto yy835;
				}
			}
		}
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);
#line 1368 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr(&ptr, 2);
				s->time->i = timelib_get_nr(&ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr(&ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 16211 "<stdout>"
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy1140;
	if (yych <= '9') goto yy1141;
	goto yy59;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '2') goto yy1139;
	if (yych <= '9') goto yy1138;
	goto yy59;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1138;
	goto yy59;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '5') goto yy1136;
	if (yych <= '6') goto yy1137;
	if (yych <= '9') goto yy1134;
	goto yy59;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '9') goto yy1134;
	goto yy59;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy59;
	if (yych <= '0') goto yy1134;
	if (yych <= '9') goto yy74;
	goto yy59;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy75;
				} else {
					if (yych == 'D') goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1135;
				if (yych <= 'H') goto yy59;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
				} else {
					if (yych != 'V') goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych >= 'd') goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy59;
				} else {
					if (yych == 'h') goto yy59;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
				} else {
					if (yych != 'v') goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
				}
			}
		}
	}
yy1135:
	YYDEBUG(1135, *YYCURSOR);
#line 1414 "ext/date/lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 16330 "<stdout>"
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy1135;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1135;
					goto yy865;
				} else {
					if (yych == 'D') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1135;
				if (yych <= 'H') goto yy59;
				goto yy1135;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'V') goto yy1135;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy1135;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'v') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1135;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1135;
				}
			}
		}
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy1135;
				goto yy59;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1135;
					goto yy865;
				} else {
					if (yych <= '9') goto yy75;
					if (yych <= 'C') goto yy1135;
					goto yy59;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'H') goto yy59;
					goto yy1135;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'V') goto yy1135;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy1135;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'v') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1135;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1135;
				}
			}
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy1135;
				goto yy59;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy1135;
					goto yy865;
				} else {
					if (yych == 'D') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy1135;
				if (yych <= 'H') goto yy59;
				goto yy1135;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'V') goto yy1135;
					goto yy59;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy59;
				if (yych <= 'c') goto yy1135;
				goto yy59;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'v') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1135;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1135;
				}
			}
		}
	}
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1135;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy1135;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy889;
					goto yy890;
				} else {
					if (yych <= '3') goto yy891;
					if (yych <= '9') goto yy865;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'G') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1135;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy1135;
					if (yych <= 'U') goto yy59;
					goto yy1135;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy1135;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'v') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1135;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1135;
				}
			}
		}
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1135;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy1135;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy921;
					goto yy890;
				} else {
					if (yych <= '3') goto yy891;
					if (yych <= '9') goto yy865;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'G') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1135;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy1135;
					if (yych <= 'U') goto yy59;
					goto yy1135;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy1135;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'v') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1135;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1135;
				}
			}
		}
	}
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy1135;
					goto yy59;
				} else {
					if (yych == ' ') goto yy59;
					goto yy1135;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy889;
					goto yy890;
				} else {
					if (yych <= '3') goto yy891;
					if (yych <= '9') goto yy865;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'G') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1135;
					goto yy59;
				} else {
					if (yych <= 'R') goto yy1135;
					if (yych <= 'U') goto yy59;
					goto yy1135;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy59;
					goto yy1135;
				} else {
					if (yych <= 'Y') goto yy59;
					if (yych <= 'c') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy1135;
					goto yy59;
				} else {
					if (yych == 'h') goto yy59;
					goto yy1135;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy59;
					goto yy1135;
				} else {
					if (yych == 'v') goto yy1135;
					goto yy59;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy1135;
					goto yy59;
				} else {
					if (yych == 0xC2) goto yy59;
					goto yy1135;
				}
			}
		}
	}
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1144;
		goto yy524;
	} else {
		if (yych <= '9') goto yy1143;
		if (yych <= ':') goto yy1144;
		goto yy524;
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1144;
	if (yych != ':') goto yy524;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1145;
	if (yych <= '6') goto yy1146;
	if (yych <= '9') goto yy529;
	goto yy55;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych <= '9') goto yy529;
	goto yy524;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych == '0') goto yy529;
	goto yy524;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		goto yy1151;
	} else {
		if (yych <= '/') goto yy524;
		if (yych <= '9') goto yy1150;
		if (yych <= ':') goto yy1144;
		goto yy524;
	}
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		if (yych <= '.') goto yy1151;
		goto yy524;
	} else {
		if (yych <= '2') goto yy1150;
		if (yych <= '9') goto yy1143;
		if (yych <= ':') goto yy1144;
		goto yy524;
	}
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
		goto yy1151;
	} else {
		if (yych <= '/') goto yy524;
		if (yych <= '9') goto yy1143;
		if (yych <= ':') goto yy1144;
		goto yy524;
	}
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy524;
		if (yych <= '-') goto yy635;
	} else {
		if (yych == ':') goto yy1144;
		goto yy524;
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '5') goto yy1152;
	if (yych <= '6') goto yy1153;
	if (yych <= '9') goto yy643;
	goto yy55;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych <= '9') goto yy1154;
	goto yy524;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy530;
		goto yy524;
	} else {
		if (yych <= '0') goto yy1154;
		if (yych <= '9') goto yy644;
		goto yy524;
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy530;
	if (yych <= '/') goto yy524;
	if (yych <= '9') goto yy638;
	goto yy524;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy493;
			if (yych <= ',') goto yy495;
			goto yy1110;
		} else {
			if (yych <= '.') goto yy507;
			if (yych <= '/') goto yy505;
			if (yych <= '5') goto yy1125;
			goto yy785;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy516;
			if (yych == 'n') goto yy503;
			goto yy495;
		} else {
			if (yych <= 'r') goto yy504;
			if (yych <= 's') goto yy498;
			if (yych <= 't') goto yy501;
			goto yy495;
		}
	}
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1111;
			if (yych <= ',') goto yy1113;
			goto yy1110;
		} else {
			if (yych <= '.') goto yy1123;
			if (yych <= '/') goto yy505;
			if (yych <= '5') goto yy1125;
			goto yy785;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1124;
			if (yych == 'n') goto yy503;
			goto yy1113;
		} else {
			if (yych <= 'r') goto yy504;
			if (yych <= 's') goto yy498;
			if (yych <= 't') goto yy501;
			goto yy1113;
		}
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy183;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'e') goto yy1158;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy184;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'v') goto yy1159;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy185;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'i') goto yy1160;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy186;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'o') goto yy1161;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1162;
		if (yych != 'u') goto yy3;
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1163;
	if (yych != 's') goto yy55;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1164;
	if (yych != ' ') goto yy55;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1164;
				if (yych <= 0x1F) goto yy55;
				goto yy1164;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy1171;
				} else {
					if (yych == 'F') goto yy1172;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1170;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy1166;
					if (yych <= 'R') goto yy55;
					goto yy1169;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1175;
					goto yy1168;
				} else {
					if (yych == 'W') goto yy1174;
					goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1173;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy1171;
					if (yych <= 'e') goto yy55;
					goto yy1172;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy1170;
				} else {
					if (yych != 'm') goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1169;
					goto yy1175;
				} else {
					if (yych <= 'u') goto yy1168;
					if (yych <= 'v') goto yy55;
					goto yy1174;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy1173;
				} else {
					if (yych == 0xC2) goto yy1167;
					goto yy55;
				}
			}
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy1256;
			goto yy55;
		} else {
			if (yych <= 'O') goto yy1255;
			if (yych <= 'R') goto yy55;
			goto yy1257;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy1256;
			goto yy55;
		} else {
			if (yych <= 'o') goto yy1255;
			if (yych == 's') goto yy1257;
			goto yy55;
		}
	}
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy1252;
	goto yy55;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1250;
	if (yych == 's') goto yy1250;
	goto yy55;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1235;
			goto yy55;
		} else {
			if (yych <= 'E') goto yy1236;
			if (yych <= 'T') goto yy55;
			goto yy1234;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1235;
			goto yy55;
		} else {
			if (yych <= 'e') goto yy1236;
			if (yych == 'u') goto yy1234;
			goto yy55;
		}
	}
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1232;
	if (yych == 'o') goto yy1232;
	goto yy55;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1231;
	if (yych == 'a') goto yy1231;
	goto yy55;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1215;
		if (yych <= 'Q') goto yy55;
		goto yy1214;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy55;
			goto yy1215;
		} else {
			if (yych == 'r') goto yy1214;
			goto yy55;
		}
	}
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1211;
	if (yych == 'e') goto yy1211;
	goto yy55;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1196;
	if (yych == 'e') goto yy1196;
	goto yy55;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1176;
		if (yych <= 'T') goto yy55;
		goto yy1177;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
		} else {
			if (yych == 'u') goto yy1177;
			goto yy55;
		}
	}
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1190;
	if (yych == 'u') goto yy1190;
	goto yy55;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1178;
	if (yych != 'e') goto yy55;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych >= ' ') goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1182;
		} else {
			if (yych == 's') goto yy1182;
		}
	}
yy1179:
	YYDEBUG(1179, *YYCURSOR);
#line 1822 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 17322 "<stdout>"
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1181, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy55;
		goto yy1180;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy55;
			goto yy1187;
		} else {
			if (yych == 'o') goto yy1187;
			goto yy55;
		}
	}
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1183;
	if (yych != 'd') goto yy55;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1184;
	if (yych != 'a') goto yy55;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1185;
	if (yych != 'y') goto yy55;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
		} else {
			if (yych != 's') goto yy1179;
		}
	}
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1180;
	if (yych == ' ') goto yy1180;
	goto yy1179;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1188;
	if (yych != 'f') goto yy55;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1189, *YYCURSOR);
#line 1281 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text(&ptr, &behavior);
		timelib_eat_spaces(&ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, 1, s, TIMELIB_TIME_PART_DONT_KEEP);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 17409 "<stdout>"
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1179;
		} else {
			if (yych != 'r') goto yy1179;
		}
	}
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1192;
	if (yych != 's') goto yy55;
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1193;
	if (yych != 'd') goto yy55;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1194;
	if (yych != 'a') goto yy55;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1195;
	if (yych != 'y') goto yy55;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
			goto yy1186;
		} else {
			if (yych == 's') goto yy1186;
			goto yy1179;
		}
	}
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy1198;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy1198;
		if (yych >= 'f') goto yy55;
	}
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1205;
	if (yych == 'k') goto yy1205;
	goto yy55;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1179;
		} else {
			if (yych != 'n') goto yy1179;
		}
	}
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1200;
	if (yych != 'e') goto yy55;
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1201;
	if (yych != 's') goto yy55;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1202;
	if (yych != 'd') goto yy55;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1203;
	if (yych != 'a') goto yy55;
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1204;
	if (yych != 'y') goto yy55;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
			goto yy1186;
		} else {
			if (yych == 's') goto yy1186;
			goto yy1179;
		}
	}
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1208;
		if (yych >= 'S') goto yy1207;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1208;
		} else {
			if (yych == 's') goto yy1207;
		}
	}
yy1206:
	YYDEBUG(1206, *YYCURSOR);
#line 1798 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s, TIMELIB_TIME_PART_DONT_KEEP);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 17572 "<stdout>"
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1179;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1209;
	if (yych != 'a') goto yy55;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1210;
	if (yych != 'y') goto yy55;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1207;
	if (yych == 's') goto yy1207;
	goto yy1179;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1212;
	if (yych != 'a') goto yy55;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1213;
	if (yych != 'r') goto yy55;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1207;
	if (yych == 's') goto yy1207;
	goto yy1179;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1227;
	if (yych == 'i') goto yy1227;
	goto yy55;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1216;
	if (yych != 'r') goto yy55;
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1217;
	if (yych != 't') goto yy55;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1219;
		if (yych <= 'M') goto yy55;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy55;
			goto yy1219;
		} else {
			if (yych != 'n') goto yy55;
		}
	}
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1224;
	if (yych == 'i') goto yy1224;
	goto yy55;
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1220;
	if (yych != 'n') goto yy55;
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1221;
	if (yych != 'i') goto yy55;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1222;
	if (yych != 'g') goto yy55;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1223;
	if (yych != 'h') goto yy55;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1213;
	if (yych == 't') goto yy1213;
	goto yy55;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1225;
	if (yych != 'g') goto yy55;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1226;
	if (yych != 'h') goto yy55;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1213;
	if (yych == 't') goto yy1213;
	goto yy55;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1179;
		} else {
			if (yych != 'd') goto yy1179;
		}
	}
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1229;
	if (yych != 'a') goto yy55;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1230;
	if (yych != 'y') goto yy55;
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
			goto yy1186;
		} else {
			if (yych == 's') goto yy1186;
			goto yy1179;
		}
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1213;
	if (yych == 'y') goto yy1213;
	goto yy55;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1233;
	if (yych != 'u') goto yy55;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1213;
	if (yych == 'r') goto yy1213;
	goto yy55;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1246;
	if (yych == 'n') goto yy1246;
	goto yy55;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1240;
	if (yych == 't') goto yy1240;
	goto yy55;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1237;
	if (yych != 'c') goto yy55;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1238;
		if (yych <= 'R') goto yy1179;
		goto yy1207;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1179;
		} else {
			if (yych == 's') goto yy1207;
			goto yy1179;
		}
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1239;
	if (yych != 'n') goto yy55;
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1213;
	if (yych == 'd') goto yy1213;
	goto yy55;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1179;
		} else {
			if (yych != 'u') goto yy1179;
		}
	}
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1242;
	if (yych != 'r') goto yy55;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1243;
	if (yych != 'd') goto yy55;
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1244;
	if (yych != 'a') goto yy55;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1245;
	if (yych != 'y') goto yy55;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
			goto yy1186;
		} else {
			if (yych == 's') goto yy1186;
			goto yy1179;
		}
	}
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1179;
		} else {
			if (yych != 'd') goto yy1179;
		}
	}
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1248;
	if (yych != 'a') goto yy55;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1249;
	if (yych != 'y') goto yy55;
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
			goto yy1186;
		} else {
			if (yych == 's') goto yy1186;
			goto yy1179;
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy55;
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1213;
	if (yych == 'c') goto yy1213;
	goto yy55;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1253;
	if (yych != 's') goto yy55;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1254;
	if (yych != 'e') goto yy1179;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1213;
	if (yych == 'c') goto yy1213;
	goto yy55;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1278;
	if (yych == 'n') goto yy1278;
	goto yy55;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1260;
			goto yy55;
		} else {
			if (yych <= 'L') goto yy1259;
			if (yych <= 'M') goto yy55;
			goto yy1261;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1260;
			goto yy55;
		} else {
			if (yych <= 'l') goto yy1259;
			if (yych == 'n') goto yy1261;
			goto yy55;
		}
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1258;
	if (yych != 'e') goto yy1179;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1213;
	if (yych == 'c') goto yy1213;
	goto yy55;
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1271;
	if (yych == 'l') goto yy1271;
	goto yy55;
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1264;
	if (yych == 'r') goto yy1264;
	goto yy55;
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1207;
		if (yych <= 'T') goto yy1179;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1179;
			goto yy1207;
		} else {
			if (yych != 'u') goto yy1179;
		}
	}
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1263;
	if (yych != 't') goto yy55;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1213;
	if (yych == 'e') goto yy1213;
	goto yy55;
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1265;
	if (yych != 'o') goto yy55;
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1266;
	if (yych != 's') goto yy55;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1267;
	if (yych != 'e') goto yy55;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1268;
	if (yych != 'c') goto yy55;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1269;
	if (yych != 'o') goto yy55;
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1270;
	if (yych != 'n') goto yy55;
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1213;
	if (yych == 'd') goto yy1213;
	goto yy55;
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1272;
	if (yych != 'i') goto yy55;
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1273;
	if (yych != 's') goto yy55;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1274;
	if (yych != 'e') goto yy55;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1275;
	if (yych != 'c') goto yy55;
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1276;
	if (yych != 'o') goto yy55;
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1277;
	if (yych != 'n') goto yy55;
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1213;
	if (yych == 'd') goto yy1213;
	goto yy55;
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1180;
			goto yy1179;
		} else {
			if (yych <= ' ') goto yy1180;
			if (yych <= 'C') goto yy1179;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1280;
			goto yy1179;
		} else {
			if (yych <= 'd') goto yy1279;
			if (yych == 't') goto yy1280;
			goto yy1179;
		}
	}
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1281;
	if (yych == 'a') goto yy1281;
	goto yy55;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1213;
	if (yych == 'h') goto yy1213;
	goto yy55;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1282;
	if (yych != 'y') goto yy55;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1180;
		if (yych <= 0x1F) goto yy1179;
		goto yy1180;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy1179;
			goto yy1186;
		} else {
			if (yych == 's') goto yy1186;
			goto yy1179;
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1158;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'e') goto yy1284;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1159;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'v') goto yy1285;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1160;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'i') goto yy1286;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1161;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'o') goto yy1287;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1162;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1288;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1163;
	if (yych != 's') goto yy196;
	YYDEBUG(1289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy1164;
		} else {
			if (yych == ' ') goto yy1164;
			goto yy55;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy55;
			goto yy189;
		} else {
			if (yych == '_') goto yy189;
			goto yy55;
		}
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy183;
			goto yy1304;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'g') goto yy1304;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy183;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'e') goto yy1292;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy184;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'v') goto yy1293;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy185;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'e') goto yy1294;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy186;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'n') goto yy1295;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1296;
		if (yych != 't') goto yy3;
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1297;
	if (yych != 'h') goto yy55;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1298;
	if (yych != ' ') goto yy55;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1298;
				if (yych <= 0x1F) goto yy55;
				goto yy1298;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy55;
					goto yy1171;
				} else {
					if (yych == 'F') goto yy1172;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy1170;
					goto yy55;
				} else {
					if (yych <= 'M') goto yy1166;
					if (yych <= 'R') goto yy55;
					goto yy1169;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1175;
					goto yy1168;
				} else {
					if (yych != 'W') goto yy55;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy1173;
					goto yy55;
				} else {
					if (yych <= 'd') goto yy1171;
					if (yych <= 'e') goto yy55;
					goto yy1172;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy55;
					goto yy1170;
				} else {
					if (yych == 'm') goto yy1166;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy1169;
					goto yy1175;
				} else {
					if (yych <= 'u') goto yy1168;
					if (yych <= 'v') goto yy55;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy55;
					goto yy1173;
				} else {
					if (yych == 0xC2) goto yy1167;
					goto yy55;
				}
			}
		}
	}
	YYDEBUG(1300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1301;
	if (yych != 'e') goto yy55;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy55;
		if (yych <= 'D') goto yy1198;
	} else {
		if (yych <= 'c') goto yy55;
		if (yych <= 'd') goto yy1198;
		if (yych >= 'f') goto yy55;
	}
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1303;
	if (yych != 'k') goto yy55;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1208;
		if (yych <= 'R') goto yy55;
		goto yy1207;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy55;
			goto yy1208;
		} else {
			if (yych == 's') goto yy1207;
			goto yy55;
		}
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy184;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'h') goto yy1305;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy185;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 't') goto yy1306;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1298;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1298;
			if (yych == ')') goto yy181;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1307;
			if (yych <= 'Z') goto yy186;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1307;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1298;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1298;
		if (yych == ')') goto yy181;
		goto yy3;
	}
yy1308:
	YYDEBUG(1308, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1304;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'g') goto yy1316;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1292;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'e') goto yy1310;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1293;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'v') goto yy1311;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1294;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'e') goto yy1312;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1295;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'n') goto yy1313;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1296;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 't') goto yy1314;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1297;
	if (yych != 'h') goto yy196;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy55;
			goto yy1298;
		} else {
			if (yych == ' ') goto yy1298;
			goto yy55;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy55;
			goto yy189;
		} else {
			if (yych == '_') goto yy189;
			goto yy55;
		}
	}
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1305;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'h') goto yy1317;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1317:
	YYDEBUG(1317, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1306;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 't') goto yy1318;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1298;
			} else {
				if (yych == ' ') goto yy1298;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy189;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy186;
			} else {
				if (yych <= 'H') goto yy1307;
				if (yych <= 'Z') goto yy186;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'h') goto yy1319;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1298;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1298;
			if (yych <= '(') goto yy3;
			goto yy181;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy189;
			goto yy3;
		} else {
			if (yych <= '/') goto yy189;
			if (yych == '_') goto yy189;
			goto yy3;
		}
	}
yy1320:
	YYDEBUG(1320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1337;
				goto yy183;
			} else {
				if (yych <= 'P') goto yy1339;
				if (yych <= 'U') goto yy183;
				goto yy1338;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy183;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1337;
				goto yy183;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1339;
				goto yy183;
			} else {
				if (yych <= 'v') goto yy1338;
				if (yych <= 'z') goto yy183;
				goto yy3;
			}
		}
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy183;
			goto yy1331;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 't') goto yy1331;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy183;
			goto yy1328;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'x') goto yy1328;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy183;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'n') goto yy1324;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy219;
			goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'C') goto yy184;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy219;
			goto yy184;
		} else {
			if (yych <= 'd') goto yy1325;
			if (yych <= 'z') goto yy184;
			goto yy219;
		}
	}
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy185;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1326;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy186;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'y') goto yy1327;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == ')') goto yy181;
		goto yy219;
	} else {
		if (yych <= 'S') goto yy225;
		if (yych == 's') goto yy225;
		goto yy219;
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1329;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy185;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'h') goto yy1330;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1298;
		} else {
			if (yych == ' ') goto yy1298;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy186;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy219;
			goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'T') goto yy184;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy219;
			goto yy184;
		} else {
			if (yych <= 'u') goto yy1332;
			if (yych <= 'z') goto yy184;
			goto yy219;
		}
	}
yy1332:
	YYDEBUG(1332, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy185;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'r') goto yy1333;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy186;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'd') goto yy1334;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1335;
		if (yych != 'a') goto yy3;
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1336;
	if (yych != 'y') goto yy55;
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy225;
	if (yych == 's') goto yy225;
	goto yy219;
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy184;
			goto yy1348;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'o') goto yy1348;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy184;
			goto yy1345;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'e') goto yy1345;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'T') goto yy184;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 't') goto yy1340;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'E') goto yy185;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy248;
				goto yy185;
			} else {
				if (yych <= 'e') goto yy1341;
				if (yych <= 'z') goto yy185;
				goto yy248;
			}
		}
	}
yy1341:
	YYDEBUG(1341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy186;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'm') goto yy1342;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1342:
	YYDEBUG(1342, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1343;
		if (yych != 'b') goto yy3;
	}
yy1343:
	YYDEBUG(1343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1344;
	if (yych != 'e') goto yy55;
yy1344:
	YYDEBUG(1344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy259;
	if (yych == 'r') goto yy259;
	goto yy55;
yy1345:
	YYDEBUG(1345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy185;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'n') goto yy1346;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1346:
	YYDEBUG(1346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy186;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 't') goto yy1347;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1347:
	YYDEBUG(1347, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1297;
		if (yych == 'h') goto yy1297;
		goto yy3;
	}
yy1348:
	YYDEBUG(1348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy185;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'n') goto yy1349;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1349:
	YYDEBUG(1349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy186;
			goto yy1307;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'd') goto yy1307;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1350:
	YYDEBUG(1350, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy181;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy189;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy183;
				goto yy1337;
			} else {
				if (yych == 'P') goto yy1339;
				goto yy183;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1338;
				if (yych <= 'Z') goto yy183;
				goto yy3;
			} else {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy3;
				goto yy188;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1367;
				if (yych <= 'o') goto yy188;
				goto yy1369;
			} else {
				if (yych == 'v') goto yy1368;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1351:
	YYDEBUG(1351, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1331;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 't') goto yy1361;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1352:
	YYDEBUG(1352, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1328;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'x') goto yy1358;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1353:
	YYDEBUG(1353, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1324;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'n') goto yy1354;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1354:
	YYDEBUG(1354, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1325;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 'd') goto yy1355;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy1355:
	YYDEBUG(1355, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1326;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1356;
			if (yych <= 'z') goto yy193;
			goto yy3;
		}
	}
yy1356:
	YYDEBUG(1356, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1327;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'y') goto yy1357;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1357:
	YYDEBUG(1357, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy219;
		} else {
			if (yych == '.') goto yy219;
			if (yych <= '/') goto yy189;
			goto yy219;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'S') goto yy225;
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy1358:
	YYDEBUG(1358, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1329;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1359;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1359:
	YYDEBUG(1359, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1330;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'h') goto yy1360;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1360:
	YYDEBUG(1360, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1298;
			if (yych <= 0x1F) goto yy3;
			goto yy1298;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy189;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1361:
	YYDEBUG(1361, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1332;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 'u') goto yy1362;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy1362:
	YYDEBUG(1362, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1333;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'r') goto yy1363;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1363:
	YYDEBUG(1363, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1334;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'd') goto yy1364;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1364:
	YYDEBUG(1364, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1335;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1365;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1365:
	YYDEBUG(1365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1336;
	if (yych != 'y') goto yy196;
	YYDEBUG(1366, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy189;
			goto yy219;
		} else {
			if (yych <= '/') goto yy189;
			if (yych <= 'R') goto yy219;
			goto yy225;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy1367:
	YYDEBUG(1367, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1348;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'o') goto yy1378;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1368:
	YYDEBUG(1368, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1345;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'e') goto yy1375;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1369:
	YYDEBUG(1369, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'T') goto yy1340;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1370;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy1370:
	YYDEBUG(1370, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy248;
				goto yy185;
			} else {
				if (yych <= 'E') goto yy1341;
				if (yych <= 'Z') goto yy185;
				goto yy248;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy193;
			} else {
				if (yych <= 'e') goto yy1371;
				if (yych <= 'z') goto yy193;
				goto yy248;
			}
		}
	}
yy1371:
	YYDEBUG(1371, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1342;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'm') goto yy1372;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1372:
	YYDEBUG(1372, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1343;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1373;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1373:
	YYDEBUG(1373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1344;
	if (yych != 'e') goto yy196;
	YYDEBUG(1374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy259;
	if (yych == 'r') goto yy382;
	goto yy196;
yy1375:
	YYDEBUG(1375, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1346;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'n') goto yy1376;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1376:
	YYDEBUG(1376, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1347;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 't') goto yy1377;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1377:
	YYDEBUG(1377, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1297;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1315;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1378:
	YYDEBUG(1378, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1349;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'n') goto yy1379;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1379:
	YYDEBUG(1379, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1307;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'd') goto yy1319;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1380:
	YYDEBUG(1380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy183;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'c') goto yy1381;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1381:
	YYDEBUG(1381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy184;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'k') goto yy1382;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1382:
	YYDEBUG(1382, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1383;
		if (yych <= '(') goto yy3;
		goto yy181;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy185;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1383:
	YYDEBUG(1383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1384;
	if (yych != 'o') goto yy55;
yy1384:
	YYDEBUG(1384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1385;
	if (yych != 'f') goto yy55;
yy1385:
	YYDEBUG(1385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy55;
	YYDEBUG(1386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1387;
	if (yych <= '2') goto yy1389;
	if (yych <= '9') goto yy1390;
	goto yy55;
yy1387:
	YYDEBUG(1387, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1391;
		} else {
			if (yych <= ' ') goto yy1391;
			if (yych <= '/') goto yy1388;
			if (yych <= '9') goto yy1390;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1393;
			if (yych == 'P') goto yy1393;
		} else {
			if (yych <= 'a') goto yy1393;
			if (yych == 'p') goto yy1393;
		}
	}
yy1388:
	YYDEBUG(1388, *YYCURSOR);
#line 1258 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr(&ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr(&ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces(&ptr);
			s->time->h += timelib_meridian(&ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 20543 "<stdout>"
yy1389:
	YYDEBUG(1389, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1391;
			goto yy1388;
		} else {
			if (yych <= ' ') goto yy1391;
			if (yych <= '/') goto yy1388;
			if (yych >= '5') goto yy1388;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1393;
			if (yych == 'P') goto yy1393;
			goto yy1388;
		} else {
			if (yych <= 'a') goto yy1393;
			if (yych == 'p') goto yy1393;
			goto yy1388;
		}
	}
yy1390:
	YYDEBUG(1390, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1388;
		} else {
			if (yych <= ' ') goto yy1391;
			if (yych <= '@') goto yy1388;
			goto yy1393;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1393;
			goto yy1388;
		} else {
			if (yych <= 'a') goto yy1393;
			if (yych == 'p') goto yy1393;
			goto yy1388;
		}
	}
yy1391:
	YYDEBUG(1391, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1392, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1391;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy1391;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy1393;
			if (yych != 'p') goto yy55;
		}
	}
yy1393:
	YYDEBUG(1393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy1395;
		if (yych == 'm') goto yy1395;
		goto yy55;
	}
	YYDEBUG(1394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1395;
	if (yych != 'm') goto yy55;
yy1395:
	YYDEBUG(1395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1397;
		if (yych == '\t') goto yy1397;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1397;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(1396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1397;
		if (yych <= 0x08) goto yy55;
	} else {
		if (yych != ' ') goto yy55;
	}
yy1397:
	YYDEBUG(1397, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1388;
yy1398:
	YYDEBUG(1398, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1381;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'c') goto yy1399;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1399:
	YYDEBUG(1399, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1382;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'k') goto yy1400;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1400:
	YYDEBUG(1400, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1383;
			goto yy3;
		} else {
			if (yych <= ')') goto yy181;
			if (yych == '-') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy189;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy185;
			goto yy3;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy193;
			goto yy3;
		}
	}
yy1401:
	YYDEBUG(1401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy183;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 's') goto yy1402;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1402:
	YYDEBUG(1402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1403;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1403:
	YYDEBUG(1403, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1164;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy185;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1404:
	YYDEBUG(1404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1405;
	if (yych != 'd') goto yy1165;
yy1405:
	YYDEBUG(1405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1406;
	if (yych != 'a') goto yy55;
yy1406:
	YYDEBUG(1406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1407;
	if (yych != 'y') goto yy55;
yy1407:
	YYDEBUG(1407, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1179;
	} else {
		if (yych <= 'S') goto yy1207;
		if (yych == 's') goto yy1207;
		goto yy1179;
	}
	YYDEBUG(1408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1409;
	if (yych != 'o') goto yy55;
yy1409:
	YYDEBUG(1409, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1410;
	if (yych != 'f') goto yy55;
yy1410:
	YYDEBUG(1410, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1411, *YYCURSOR);
#line 1241 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 20858 "<stdout>"
yy1412:
	YYDEBUG(1412, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1402;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 's') goto yy1413;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1413:
	YYDEBUG(1413, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1403;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1414;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1414:
	YYDEBUG(1414, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1164;
			if (yych <= 0x1F) goto yy3;
			goto yy1404;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy189;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1415:
	YYDEBUG(1415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy183;
			goto yy1453;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'b') goto yy1453;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1416:
	YYDEBUG(1416, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1443;
			if (yych <= 'Q') goto yy183;
			goto yy1442;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy183;
			goto yy1443;
		} else {
			if (yych == 'r') goto yy1442;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1417:
	YYDEBUG(1417, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy183;
			goto yy1439;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'u') goto yy1439;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1418:
	YYDEBUG(1418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1420;
			if (yych <= 'N') goto yy183;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy183;
			goto yy1420;
		} else {
			if (yych == 'o') goto yy1419;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1419:
	YYDEBUG(1419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy184;
			goto yy1424;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'n') goto yy1424;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1420:
	YYDEBUG(1420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy219;
			goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'C') goto yy184;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy219;
			goto yy184;
		} else {
			if (yych <= 'd') goto yy1421;
			if (yych <= 'z') goto yy184;
			goto yy219;
		}
	}
yy1421:
	YYDEBUG(1421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy185;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1422;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1422:
	YYDEBUG(1422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy186;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'y') goto yy1423;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1423:
	YYDEBUG(1423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == ')') goto yy181;
		goto yy219;
	} else {
		if (yych <= 'S') goto yy225;
		if (yych == 's') goto yy225;
		goto yy219;
	}
yy1424:
	YYDEBUG(1424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy185;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 't') goto yy1425;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1425:
	YYDEBUG(1425, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1426;
		if (yych <= '(') goto yy3;
		goto yy181;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy186;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1426:
	YYDEBUG(1426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1427;
	if (yych != 'o') goto yy55;
yy1427:
	YYDEBUG(1427, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1428;
	if (yych != 'f') goto yy55;
yy1428:
	YYDEBUG(1428, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy55;
	YYDEBUG(1429, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '1') goto yy1430;
	if (yych <= '2') goto yy1431;
	if (yych <= '9') goto yy1432;
	goto yy55;
yy1430:
	YYDEBUG(1430, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1433;
			goto yy1388;
		} else {
			if (yych <= ' ') goto yy1433;
			if (yych <= '/') goto yy1388;
			if (yych <= '9') goto yy1432;
			goto yy1388;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1435;
			if (yych == 'P') goto yy1435;
			goto yy1388;
		} else {
			if (yych <= 'a') goto yy1435;
			if (yych == 'p') goto yy1435;
			goto yy1388;
		}
	}
yy1431:
	YYDEBUG(1431, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1433;
			goto yy1388;
		} else {
			if (yych <= ' ') goto yy1433;
			if (yych <= '/') goto yy1388;
			if (yych >= '5') goto yy1388;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1435;
			if (yych == 'P') goto yy1435;
			goto yy1388;
		} else {
			if (yych <= 'a') goto yy1435;
			if (yych == 'p') goto yy1435;
			goto yy1388;
		}
	}
yy1432:
	YYDEBUG(1432, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy1388;
		} else {
			if (yych <= ' ') goto yy1433;
			if (yych <= '@') goto yy1388;
			goto yy1435;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1435;
			goto yy1388;
		} else {
			if (yych <= 'a') goto yy1435;
			if (yych == 'p') goto yy1435;
			goto yy1388;
		}
	}
yy1433:
	YYDEBUG(1433, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1434, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1433;
			goto yy55;
		} else {
			if (yych <= ' ') goto yy1433;
			if (yych <= '@') goto yy55;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy55;
		} else {
			if (yych <= 'a') goto yy1435;
			if (yych != 'p') goto yy55;
		}
	}
yy1435:
	YYDEBUG(1435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy55;
	} else {
		if (yych <= 'M') goto yy1437;
		if (yych == 'm') goto yy1437;
		goto yy55;
	}
	YYDEBUG(1436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1437;
	if (yych != 'm') goto yy55;
yy1437:
	YYDEBUG(1437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1397;
		if (yych == '\t') goto yy1397;
		goto yy55;
	} else {
		if (yych <= ' ') goto yy1397;
		if (yych != '.') goto yy55;
	}
	YYDEBUG(1438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1397;
		if (yych <= 0x08) goto yy55;
		goto yy1397;
	} else {
		if (yych == ' ') goto yy1397;
		goto yy55;
	}
yy1439:
	YYDEBUG(1439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy184;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'r') goto yy1440;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1440:
	YYDEBUG(1440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy185;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 't') goto yy1441;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1441:
	YYDEBUG(1441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy186;
			goto yy1307;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'h') goto yy1307;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1442:
	YYDEBUG(1442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy184;
			goto yy1445;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 's') goto yy1445;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1443:
	YYDEBUG(1443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1444;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1444:
	YYDEBUG(1444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy185;
			goto yy1330;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'h') goto yy1330;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1445:
	YYDEBUG(1445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy185;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 't') goto yy1446;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1446:
	YYDEBUG(1446, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1298;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy186;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1447:
	YYDEBUG(1447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1448;
	if (yych != 'd') goto yy1299;
yy1448:
	YYDEBUG(1448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1449;
	if (yych != 'a') goto yy55;
yy1449:
	YYDEBUG(1449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1450;
	if (yych != 'y') goto yy55;
yy1450:
	YYDEBUG(1450, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1179;
	} else {
		if (yych <= 'S') goto yy1207;
		if (yych == 's') goto yy1207;
		goto yy1179;
	}
	YYDEBUG(1451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1452;
	if (yych != 'o') goto yy55;
yy1452:
	YYDEBUG(1452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1410;
	if (yych == 'f') goto yy1410;
	goto yy55;
yy1453:
	YYDEBUG(1453, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'R') goto yy184;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'r') goto yy1454;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy1454:
	YYDEBUG(1454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy185;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'u') goto yy1455;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1455:
	YYDEBUG(1455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy186;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1456;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1456:
	YYDEBUG(1456, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1457;
		if (yych != 'r') goto yy3;
	}
yy1457:
	YYDEBUG(1457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy259;
	if (yych == 'y') goto yy259;
	goto yy55;
yy1458:
	YYDEBUG(1458, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1453;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'b') goto yy1477;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1459:
	YYDEBUG(1459, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy189;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1443;
				goto yy183;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1442;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1473;
				goto yy188;
			} else {
				if (yych <= 'r') goto yy1472;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1460:
	YYDEBUG(1460, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1439;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'u') goto yy1469;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1461:
	YYDEBUG(1461, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy189;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1420;
				goto yy183;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1419;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1463;
				goto yy188;
			} else {
				if (yych <= 'o') goto yy1462;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1462:
	YYDEBUG(1462, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1424;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'n') goto yy1467;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1463:
	YYDEBUG(1463, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1421;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 'd') goto yy1464;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy1464:
	YYDEBUG(1464, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1422;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1465;
			if (yych <= 'z') goto yy193;
			goto yy3;
		}
	}
yy1465:
	YYDEBUG(1465, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1423;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'y') goto yy1466;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1466:
	YYDEBUG(1466, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy219;
		} else {
			if (yych == '.') goto yy219;
			if (yych <= '/') goto yy189;
			goto yy219;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'S') goto yy225;
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy1467:
	YYDEBUG(1467, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1425;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 't') goto yy1468;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1468:
	YYDEBUG(1468, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1426;
			goto yy3;
		} else {
			if (yych <= ')') goto yy181;
			if (yych == '-') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy189;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy186;
			goto yy3;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy194;
			goto yy3;
		}
	}
yy1469:
	YYDEBUG(1469, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1440;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'r') goto yy1470;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1470:
	YYDEBUG(1470, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1441;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 't') goto yy1471;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1471:
	YYDEBUG(1471, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1307;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'h') goto yy1319;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1472:
	YYDEBUG(1472, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1445;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 's') goto yy1475;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1473:
	YYDEBUG(1473, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1444;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1474;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1474:
	YYDEBUG(1474, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1330;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'h') goto yy1360;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1475:
	YYDEBUG(1475, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1446;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 't') goto yy1476;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1476:
	YYDEBUG(1476, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1298;
			if (yych <= 0x1F) goto yy3;
			goto yy1447;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy189;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1477:
	YYDEBUG(1477, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'R') goto yy1454;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'r') goto yy1478;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy1478:
	YYDEBUG(1478, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1455;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'u') goto yy1479;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1479:
	YYDEBUG(1479, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1456;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1480;
			if (yych <= 'z') goto yy194;
			goto yy3;
		}
	}
yy1480:
	YYDEBUG(1480, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1457;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1481;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1481:
	YYDEBUG(1481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy259;
	if (yych == 'y') goto yy382;
	goto yy196;
yy1482:
	YYDEBUG(1482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
yy1483:
	YYDEBUG(1483, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	YYDEBUG(1484, *YYCURSOR);
	if (yych == '.') goto yy1486;
	if (yych <= '/') goto yy1485;
	if (yych <= '9') goto yy1483;
yy1485:
	YYDEBUG(1485, *YYCURSOR);
#line 1175 "ext/date/lib/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_signed_nr(s, &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22405 "<stdout>"
yy1486:
	YYDEBUG(1486, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy1487;
	if (yych <= '9') goto yy1488;
yy1487:
	YYDEBUG(1487, *YYCURSOR);
#line 1201 "ext/date/lib/parse_date.re"
	{
		timelib_sll i;
		timelib_ull us;
		const char *ptr_before;
		bool is_negative;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		is_negative = *(ptr + 1) == '-';

		i = timelib_get_signed_nr(s, &ptr, 24);

		ptr_before = ptr;
		us = timelib_get_signed_nr(s, &ptr, 6);
		us = us * pow(10, 7 - (ptr - ptr_before));
		if (is_negative) {
			us *= -1;
		}

		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22452 "<stdout>"
yy1488:
	YYDEBUG(1488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1487;
	if (yych >= ':') goto yy1487;
	YYDEBUG(1489, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1487;
	if (yych >= ':') goto yy1487;
	YYDEBUG(1490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1487;
	if (yych >= ':') goto yy1487;
	YYDEBUG(1491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1487;
	if (yych >= ':') goto yy1487;
	YYDEBUG(1492, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1487;
	if (yych >= ':') goto yy1487;
	YYDEBUG(1493, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1487;
yy1494:
	YYDEBUG(1494, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy183;
			goto yy1537;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'n') goto yy1537;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1495:
	YYDEBUG(1495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1528;
			if (yych <= 'T') goto yy183;
			goto yy1529;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy183;
			goto yy1528;
		} else {
			if (yych == 'u') goto yy1529;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1496:
	YYDEBUG(1496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1517;
			if (yych <= 'L') goto yy183;
			goto yy1518;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy183;
			goto yy1517;
		} else {
			if (yych == 'm') goto yy1518;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1497:
	YYDEBUG(1497, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy183;
			goto yy1512;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'e') goto yy1512;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1498:
	YYDEBUG(1498, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy183;
			goto yy1508;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'e') goto yy1508;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1499:
	YYDEBUG(1499, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1124;
		goto yy524;
	} else {
		if (yych <= '9') goto yy1502;
		if (yych <= ':') goto yy1124;
		goto yy524;
	}
yy1500:
	YYDEBUG(1500, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1124;
		goto yy524;
	} else {
		if (yych <= '4') goto yy1502;
		if (yych == ':') goto yy1124;
		goto yy524;
	}
yy1501:
	YYDEBUG(1501, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1124;
	if (yych == ':') goto yy1124;
	goto yy524;
yy1502:
	YYDEBUG(1502, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1124;
		goto yy524;
	} else {
		if (yych <= '5') goto yy1503;
		if (yych == ':') goto yy1124;
		goto yy524;
	}
yy1503:
	YYDEBUG(1503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych >= ':') goto yy55;
	YYDEBUG(1504, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1127;
	if (yych <= '5') goto yy1505;
	if (yych <= '6') goto yy1506;
	goto yy1127;
yy1505:
	YYDEBUG(1505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy55;
	if (yych <= '9') goto yy1507;
	goto yy55;
yy1506:
	YYDEBUG(1506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy55;
yy1507:
	YYDEBUG(1507, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1135;
yy1508:
	YYDEBUG(1508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy184;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'l') goto yy1509;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1509:
	YYDEBUG(1509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy185;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'f') goto yy1510;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1510:
	YYDEBUG(1510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy186;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 't') goto yy1511;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1511:
	YYDEBUG(1511, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1297;
		if (yych == 'h') goto yy1297;
		goto yy3;
	}
yy1512:
	YYDEBUG(1512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy219;
			goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'R') goto yy184;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy219;
			goto yy184;
		} else {
			if (yych <= 's') goto yy1513;
			if (yych <= 'z') goto yy184;
			goto yy219;
		}
	}
yy1513:
	YYDEBUG(1513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy185;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'd') goto yy1514;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1514:
	YYDEBUG(1514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy186;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1515;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1515:
	YYDEBUG(1515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy1516;
		if (yych != 'y') goto yy3;
	}
yy1516:
	YYDEBUG(1516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy225;
	if (yych == 's') goto yy225;
	goto yy219;
yy1517:
	YYDEBUG(1517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
		goto yy1525;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy184;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1525;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1518:
	YYDEBUG(1518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy184;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'o') goto yy1519;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1519:
	YYDEBUG(1519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy185;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'r') goto yy1520;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1520:
	YYDEBUG(1520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy186;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'r') goto yy1521;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1521:
	YYDEBUG(1521, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1522;
		if (yych != 'o') goto yy3;
	}
yy1522:
	YYDEBUG(1522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1523;
	if (yych != 'w') goto yy55;
yy1523:
	YYDEBUG(1523, *YYCURSOR);
	++YYCURSOR;
yy1524:
	YYDEBUG(1524, *YYCURSOR);
#line 1163 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22932 "<stdout>"
yy1525:
	YYDEBUG(1525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy185;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'y') goto yy1526;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1526:
	YYDEBUG(1526, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy181;
	} else {
		if (yych <= 'Z') goto yy186;
		if (yych <= '`') goto yy1527;
		if (yych <= 'z') goto yy186;
	}
yy1527:
	YYDEBUG(1527, *YYCURSOR);
#line 1153 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 22976 "<stdout>"
yy1528:
	YYDEBUG(1528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy184;
			if (yych <= 'R') goto yy1535;
			goto yy1536;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'r') goto yy1535;
			if (yych <= 's') goto yy1536;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1529:
	YYDEBUG(1529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy219;
			goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'Q') goto yy184;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy219;
			goto yy184;
		} else {
			if (yych <= 'r') goto yy1530;
			if (yych <= 'z') goto yy184;
			goto yy219;
		}
	}
yy1530:
	YYDEBUG(1530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy185;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 's') goto yy1531;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1531:
	YYDEBUG(1531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy186;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'd') goto yy1532;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1532:
	YYDEBUG(1532, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1533;
		if (yych != 'a') goto yy3;
	}
yy1533:
	YYDEBUG(1533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1534;
	if (yych != 'y') goto yy55;
yy1534:
	YYDEBUG(1534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy225;
	if (yych == 's') goto yy225;
	goto yy219;
yy1535:
	YYDEBUG(1535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy185;
			goto yy1330;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'd') goto yy1330;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1536:
	YYDEBUG(1536, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1164;
		} else {
			if (yych == ' ') goto yy1164;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy185;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1537:
	YYDEBUG(1537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1538;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1538:
	YYDEBUG(1538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy185;
			goto yy1330;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'h') goto yy1330;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1539:
	YYDEBUG(1539, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1537;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'n') goto yy1571;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1540:
	YYDEBUG(1540, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy189;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1528;
				goto yy183;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1529;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1562;
				goto yy188;
			} else {
				if (yych <= 'u') goto yy1563;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1541:
	YYDEBUG(1541, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy189;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1517;
				goto yy183;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1518;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1553;
				goto yy188;
			} else {
				if (yych <= 'm') goto yy1554;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1542:
	YYDEBUG(1542, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1512;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'e') goto yy1548;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1543:
	YYDEBUG(1543, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1508;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'e') goto yy1544;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1544:
	YYDEBUG(1544, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1509;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'l') goto yy1545;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1545:
	YYDEBUG(1545, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1510;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'f') goto yy1546;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1546:
	YYDEBUG(1546, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1511;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 't') goto yy1547;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1547:
	YYDEBUG(1547, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1297;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1315;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1548:
	YYDEBUG(1548, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1513;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 's') goto yy1549;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy1549:
	YYDEBUG(1549, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1514;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'd') goto yy1550;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1550:
	YYDEBUG(1550, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1515;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1551;
			if (yych <= 'z') goto yy194;
			goto yy3;
		}
	}
yy1551:
	YYDEBUG(1551, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy1516;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'y') goto yy1552;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1552:
	YYDEBUG(1552, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy189;
			goto yy219;
		} else {
			if (yych <= '/') goto yy189;
			if (yych <= 'R') goto yy219;
			goto yy225;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy1553:
	YYDEBUG(1553, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1525;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1560;
			if (yych <= 'z') goto yy192;
			goto yy3;
		}
	}
yy1554:
	YYDEBUG(1554, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1519;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'o') goto yy1555;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1555:
	YYDEBUG(1555, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1520;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'r') goto yy1556;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1556:
	YYDEBUG(1556, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1521;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'r') goto yy1557;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1557:
	YYDEBUG(1557, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1522;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1558;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1558:
	YYDEBUG(1558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1523;
	if (yych != 'w') goto yy196;
	YYDEBUG(1559, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy189;
		goto yy1524;
	} else {
		if (yych <= '/') goto yy189;
		if (yych == '_') goto yy189;
		goto yy1524;
	}
yy1560:
	YYDEBUG(1560, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1526;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'y') goto yy1561;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1561:
	YYDEBUG(1561, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy1527;
		} else {
			if (yych == '.') goto yy1527;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1527;
			if (yych <= 'Z') goto yy186;
			goto yy1527;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy1527;
			if (yych <= 'z') goto yy194;
			goto yy1527;
		}
	}
yy1562:
	YYDEBUG(1562, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy189;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy184;
				goto yy1535;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1536;
				goto yy184;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy192;
				goto yy1569;
			} else {
				if (yych <= 's') goto yy1570;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1563:
	YYDEBUG(1563, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1530;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 'r') goto yy1564;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy1564:
	YYDEBUG(1564, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1531;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 's') goto yy1565;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1565:
	YYDEBUG(1565, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1532;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'd') goto yy1566;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1566:
	YYDEBUG(1566, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1533;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1567;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1567:
	YYDEBUG(1567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1534;
	if (yych != 'y') goto yy196;
	YYDEBUG(1568, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy189;
			goto yy219;
		} else {
			if (yych <= '/') goto yy189;
			if (yych <= 'R') goto yy219;
			goto yy225;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy1569:
	YYDEBUG(1569, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1330;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'd') goto yy1360;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1570:
	YYDEBUG(1570, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1164;
			if (yych <= 0x1F) goto yy3;
			goto yy1164;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy189;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1571:
	YYDEBUG(1571, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1538;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1572;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1572:
	YYDEBUG(1572, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1330;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'h') goto yy1360;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1573:
	YYDEBUG(1573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1586;
			if (yych <= 'X') goto yy183;
			goto yy1587;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy183;
			goto yy1586;
		} else {
			if (yych == 'y') goto yy1587;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1574:
	YYDEBUG(1574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy183;
			goto yy1580;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'd') goto yy1580;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1575:
	YYDEBUG(1575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy183;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'n') goto yy1576;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1576:
	YYDEBUG(1576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy219;
			goto yy181;
		} else {
			if (yych <= '@') goto yy219;
			if (yych <= 'C') goto yy184;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy219;
			goto yy184;
		} else {
			if (yych <= 'd') goto yy1577;
			if (yych <= 'z') goto yy184;
			goto yy219;
		}
	}
yy1577:
	YYDEBUG(1577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy181;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy185;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1578;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1578:
	YYDEBUG(1578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy186;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'y') goto yy1579;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1579:
	YYDEBUG(1579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == ')') goto yy181;
		goto yy219;
	} else {
		if (yych <= 'S') goto yy225;
		if (yych == 's') goto yy225;
		goto yy219;
	}
yy1580:
	YYDEBUG(1580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy184;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'n') goto yy1581;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1581:
	YYDEBUG(1581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy185;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'i') goto yy1582;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1582:
	YYDEBUG(1582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy186;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'g') goto yy1583;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1583:
	YYDEBUG(1583, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1584;
		if (yych != 'h') goto yy3;
	}
yy1584:
	YYDEBUG(1584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1585;
	if (yych != 't') goto yy55;
yy1585:
	YYDEBUG(1585, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1527;
yy1586:
	YYDEBUG(1586, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych == 'C') goto yy1588;
				goto yy184;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'c') goto yy1588;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy1587:
	YYDEBUG(1587, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy248;
			goto yy250;
		} else {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy248;
			goto yy251;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy248;
			if (yych <= '9') goto yy250;
			goto yy248;
		} else {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy248;
			if (yych <= 'z') goto yy184;
			goto yy248;
		}
	}
yy1588:
	YYDEBUG(1588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy185;
			goto yy401;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'h') goto yy401;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1589:
	YYDEBUG(1589, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy189;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1586;
				goto yy183;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1587;
				goto yy183;
			} else {
				if (yych == '_') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1602;
				goto yy188;
			} else {
				if (yych <= 'y') goto yy1603;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1590:
	YYDEBUG(1590, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1580;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'd') goto yy1596;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1591:
	YYDEBUG(1591, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1576;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'n') goto yy1592;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1592:
	YYDEBUG(1592, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy219;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy219;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1577;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy219;
			goto yy189;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy219;
				goto yy192;
			} else {
				if (yych <= 'd') goto yy1593;
				if (yych <= 'z') goto yy192;
				goto yy219;
			}
		}
	}
yy1593:
	YYDEBUG(1593, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1578;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1594;
			if (yych <= 'z') goto yy193;
			goto yy3;
		}
	}
yy1594:
	YYDEBUG(1594, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1579;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'y') goto yy1595;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1595:
	YYDEBUG(1595, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy219;
		} else {
			if (yych == '.') goto yy219;
			if (yych <= '/') goto yy189;
			goto yy219;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'S') goto yy225;
			if (yych == '_') goto yy189;
			goto yy219;
		} else {
			if (yych == 's') goto yy239;
			if (yych <= 'z') goto yy195;
			goto yy219;
		}
	}
yy1596:
	YYDEBUG(1596, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1581;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'n') goto yy1597;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1597:
	YYDEBUG(1597, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1582;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'i') goto yy1598;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1598:
	YYDEBUG(1598, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1583;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'g') goto yy1599;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1599:
	YYDEBUG(1599, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1584;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1600;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1600:
	YYDEBUG(1600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1585;
	if (yych != 't') goto yy196;
	YYDEBUG(1601, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy189;
		goto yy1527;
	} else {
		if (yych <= '/') goto yy189;
		if (yych == '_') goto yy189;
		goto yy1527;
	}
yy1602:
	YYDEBUG(1602, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'C') goto yy1588;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'c') goto yy1604;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy1603:
	YYDEBUG(1603, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy250;
			if (yych <= 0x1F) goto yy248;
			goto yy250;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy248;
				goto yy181;
			} else {
				if (yych <= ',') goto yy248;
				if (yych <= '-') goto yy377;
				goto yy250;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy189;
			if (yych <= '9') goto yy250;
			if (yych <= '@') goto yy248;
			goto yy184;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy248;
				goto yy189;
			} else {
				if (yych <= '`') goto yy248;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy1604:
	YYDEBUG(1604, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy401;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'h') goto yy412;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1605:
	YYDEBUG(1605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy181;
			if (yych <= '@') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'O') goto yy1613;
			if (yych <= 'U') goto yy183;
			if (yych <= 'V') goto yy1614;
			goto yy1611;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy183;
			goto yy1613;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy183;
				goto yy1614;
			} else {
				if (yych <= 'w') goto yy1611;
				if (yych <= 'z') goto yy183;
				goto yy3;
			}
		}
	}
yy1606:
	YYDEBUG(1606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy183;
			goto yy1610;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'x') goto yy1610;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1607:
	YYDEBUG(1607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy183;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 'n') goto yy1608;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1608:
	YYDEBUG(1608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1609;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1609:
	YYDEBUG(1609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy185;
			goto yy1330;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'h') goto yy1330;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1610:
	YYDEBUG(1610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
			goto yy1536;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1536;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1611:
	YYDEBUG(1611, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy181;
	} else {
		if (yych <= 'Z') goto yy184;
		if (yych <= '`') goto yy1612;
		if (yych <= 'z') goto yy184;
	}
yy1612:
	YYDEBUG(1612, *YYCURSOR);
#line 1132 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 25079 "<stdout>"
yy1613:
	YYDEBUG(1613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy184;
			goto yy1619;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 'n') goto yy1619;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1614:
	YYDEBUG(1614, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy181;
				goto yy248;
			} else {
				if (yych <= '-') goto yy251;
				if (yych <= '.') goto yy250;
				goto yy248;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy250;
				goto yy248;
			} else {
				if (yych != 'E') goto yy184;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'e') goto yy1615;
				if (yych <= 'z') goto yy184;
				goto yy248;
			}
		}
	}
yy1615:
	YYDEBUG(1615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy185;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'm') goto yy1616;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1616:
	YYDEBUG(1616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy186;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'b') goto yy1617;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1617:
	YYDEBUG(1617, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1618;
		if (yych != 'e') goto yy3;
	}
yy1618:
	YYDEBUG(1618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy259;
	if (yych == 'r') goto yy259;
	goto yy55;
yy1619:
	YYDEBUG(1619, *YYCURSOR);
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy181;
	} else {
		if (yych <= 'Z') goto yy185;
		if (yych <= '`') goto yy1620;
		if (yych <= 'z') goto yy185;
	}
yy1620:
	YYDEBUG(1620, *YYCURSOR);
#line 1141 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 25229 "<stdout>"
yy1621:
	YYDEBUG(1621, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy181;
			} else {
				if (yych == '-') goto yy189;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy189;
				if (yych <= '@') goto yy3;
				goto yy183;
			} else {
				if (yych <= 'O') goto yy1613;
				if (yych <= 'U') goto yy183;
				goto yy1614;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1611;
				if (yych <= 'Z') goto yy183;
				goto yy3;
			} else {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy3;
				goto yy188;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1628;
				if (yych <= 'u') goto yy188;
				goto yy1629;
			} else {
				if (yych <= 'w') goto yy1627;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1622:
	YYDEBUG(1622, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1610;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'x') goto yy1626;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1623:
	YYDEBUG(1623, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1608;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 'n') goto yy1624;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1624:
	YYDEBUG(1624, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1609;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1625;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1625:
	YYDEBUG(1625, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1330;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'h') goto yy1360;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1626:
	YYDEBUG(1626, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1536;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1570;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1627:
	YYDEBUG(1627, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy1612;
		} else {
			if (yych == '.') goto yy1612;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1612;
			if (yych <= 'Z') goto yy184;
			goto yy1612;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy1612;
			if (yych <= 'z') goto yy192;
			goto yy1612;
		}
	}
yy1628:
	YYDEBUG(1628, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1619;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 'n') goto yy1634;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1629:
	YYDEBUG(1629, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy248;
				goto yy250;
			} else {
				if (yych == ' ') goto yy250;
				goto yy248;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy181;
				if (yych <= ',') goto yy248;
				goto yy377;
			} else {
				if (yych == '/') goto yy189;
				goto yy250;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy248;
				goto yy184;
			} else {
				if (yych <= 'E') goto yy1615;
				if (yych <= 'Z') goto yy184;
				goto yy248;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy189;
				if (yych <= '`') goto yy248;
				goto yy192;
			} else {
				if (yych <= 'e') goto yy1630;
				if (yych <= 'z') goto yy192;
				goto yy248;
			}
		}
	}
yy1630:
	YYDEBUG(1630, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1616;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'm') goto yy1631;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1631:
	YYDEBUG(1631, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1617;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'b') goto yy1632;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1632:
	YYDEBUG(1632, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1618;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1633;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1633:
	YYDEBUG(1633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy259;
	if (yych == 'r') goto yy382;
	goto yy196;
yy1634:
	YYDEBUG(1634, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy1620;
		} else {
			if (yych == '.') goto yy1620;
			goto yy189;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1620;
			if (yych <= 'Z') goto yy185;
			goto yy1620;
		} else {
			if (yych <= '_') goto yy189;
			if (yych <= '`') goto yy1620;
			if (yych <= 'z') goto yy193;
			goto yy1620;
		}
	}
yy1635:
	YYDEBUG(1635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy183;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy183;
			if (yych <= '`') goto yy3;
			goto yy183;
		} else {
			if (yych <= 's') goto yy1636;
			if (yych <= 'z') goto yy183;
			goto yy3;
		}
	}
yy1636:
	YYDEBUG(1636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy184;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy184;
			if (yych <= '`') goto yy3;
			goto yy184;
		} else {
			if (yych <= 't') goto yy1637;
			if (yych <= 'z') goto yy184;
			goto yy3;
		}
	}
yy1637:
	YYDEBUG(1637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy185;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy185;
			if (yych <= '`') goto yy3;
			goto yy185;
		} else {
			if (yych <= 'e') goto yy1638;
			if (yych <= 'z') goto yy185;
			goto yy3;
		}
	}
yy1638:
	YYDEBUG(1638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy181;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy186;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy186;
			if (yych <= '`') goto yy3;
			goto yy186;
		} else {
			if (yych <= 'r') goto yy1639;
			if (yych <= 'z') goto yy186;
			goto yy3;
		}
	}
yy1639:
	YYDEBUG(1639, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy181;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1640;
		if (yych != 'd') goto yy3;
	}
yy1640:
	YYDEBUG(1640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1641;
	if (yych != 'a') goto yy55;
yy1641:
	YYDEBUG(1641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1642;
	if (yych != 'y') goto yy55;
yy1642:
	YYDEBUG(1642, *YYCURSOR);
	++YYCURSOR;
yy1643:
	YYDEBUG(1643, *YYCURSOR);
#line 1120 "ext/date/lib/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 25773 "<stdout>"
yy1644:
	YYDEBUG(1644, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy183;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1636;
			if (yych <= 'Z') goto yy183;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy188;
			} else {
				if (yych <= 's') goto yy1645;
				if (yych <= 'z') goto yy188;
				goto yy3;
			}
		}
	}
yy1645:
	YYDEBUG(1645, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy184;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1637;
			if (yych <= 'Z') goto yy184;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy192;
			} else {
				if (yych <= 't') goto yy1646;
				if (yych <= 'z') goto yy192;
				goto yy3;
			}
		}
	}
yy1646:
	YYDEBUG(1646, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy185;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1638;
			if (yych <= 'Z') goto yy185;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy193;
			} else {
				if (yych <= 'e') goto yy1647;
				if (yych <= 'z') goto yy193;
				goto yy3;
			}
		}
	}
yy1647:
	YYDEBUG(1647, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy181;
			if (yych <= ',') goto yy3;
			goto yy189;
		} else {
			if (yych == '/') goto yy189;
			if (yych <= '@') goto yy3;
			goto yy186;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1639;
			if (yych <= 'Z') goto yy186;
			if (yych <= '^') goto yy3;
			goto yy189;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy194;
			} else {
				if (yych <= 'r') goto yy1648;
				if (yych <= 'z') goto yy194;
				goto yy3;
			}
		}
	}
yy1648:
	YYDEBUG(1648, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy181;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy189;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1640;
			if (yych == '_') goto yy189;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1649;
			if (yych <= 'z') goto yy195;
			goto yy3;
		}
	}
yy1649:
	YYDEBUG(1649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1641;
	if (yych != 'a') goto yy196;
	YYDEBUG(1650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1642;
	if (yych != 'y') goto yy196;
	YYDEBUG(1651, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy195;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy189;
		goto yy1643;
	} else {
		if (yych <= '/') goto yy189;
		if (yych == '_') goto yy189;
		goto yy1643;
	}
}
#line 1948 "ext/date/lib/parse_date.re"

}

#define YYMAXFILL 36

timelib_time *timelib_strtotime(const char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	const char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("+-0123456789", *ptr) == NULL)                      \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'p', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'x', TIMELIB_FORMAT_YEAR_EXPANDED},
	{'X', TIMELIB_FORMAT_YEAR_EXPANDED},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	const char  *fptr = format;
	const char  *ptr = string;
	const char  *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit(&ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix(&ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if (s->time->y == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "A 'day of year' can only come after a year has been found", string, begin);
				}
				if ((tmp = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
					break;
				}

				if (s->time->y != TIMELIB_UNSET) {
					s->time->have_date = 1;
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
					break;
				}
				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month(&ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				s->time->m = tmp;
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex(&ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
						break;
					}
					
					s->time->have_date = 1;
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_YEAR_EXPANDED: /* optional symbol, followed by up to 19 digits */
				TIMELIB_CHECK_SIGNED_NUMBER;
				if ((s->time->y = timelib_get_signed_nr(s, &ptr, 19)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "An expanded digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour cannot be higher than 12", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				}
				if ((tmp = timelib_meridian_with_check(&ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				if (s->time->h != TIMELIB_UNSET) {
					s->time->h += tmp;
				}
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex(&ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->i = min;
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex(&ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->s = sec;
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
						break;
					}

					s->time->us = (f * pow(10, 6 - (ptr - tptr)));
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
						break;
					}
					
					s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces(&ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				tmp = timelib_get_signed_nr(s, &ptr, 24);
				s->time->have_zone = 1;
				s->time->sse = tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				timelib_update_from_sse(s->time);
				break;

			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) != TIMELIB_FORMAT_SEPARATOR) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
					break;
				}
				
				++ptr;
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if (!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator(&ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
					break;
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr(&ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
					break;
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
						break;
					}

					s->time->have_zone = 1;
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes(&ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
					break;
				}

				s->time->have_zone = 1;
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Not enough data available to satisfy format", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;

	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;

		if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
		if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

		if (!parsed->tz_abbr) {
			parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		}
	}

	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

const char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
