/* media.h -- This file is part of Archimedes release 0.0.7.
   Archimedes is a simulator for Submicron 2D Silicon/GaAs/Germanium
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 05 Oct.2004, Siracusa, J.M.Sellier
// Last modif. : 08 August 2007, Siracusa, J.M.Sellier
// ######################################################

void media(void)
{
 register int i,j,n;
 int iv;
 int cont[NXM+1][NYM+1];
 real xvel[NXM+1][NYM+1],yvel[NXM+1][NYM+1],ener[NXM+1][NYM+1];
 real x,y,xvelocity,yvelocity,ksquared,thesquareroot;
 real superparticle_energy;

 printf("Computation of macroscopic mean values\n");

// resetting of the electronic density
// a simple way to avoid NaN propagation...
 for(i=1;i<=nx+1;i++)
   for(j=1;j<=ny+1;j++){
     cont[i][j]=0;
     xvel[i][j]=0.;
     yvel[i][j]=0.;
     ener[i][j]=0.;
   }
 for(n=1;n<=INUM;n++){
   i=(int)(x+1.5);
   j=(int)(y+1.5);
   if(i<1) i=1;
   if(j<1) j=1;
   if(i>=nx) i=nx;
   if(j>=ny) j=ny;
   iv=(int)(P[n][0]);
   x=P[n][5]/dx;
   y=P[n][6]/dy;
   ksquared=P[n][1]*P[n][1]+P[n][2]*P[n][2]+P[n][3]*P[n][3];
   thesquareroot=sqrt(1.+4.*alphaK[i_dom[i][j]][iv]*HHM[i_dom[i][j]][iv]*ksquared);
   superparticle_energy=(thesquareroot-1.)/(2.*alphaK[i_dom[i][j]][iv]);
// for the following two rows see
// pag.10 formula (1.19) of Tomizawa,
// "Numerical Simulation of Submicron Semiconductor
//  Devices", 1993, ARTECH HOUSE
// (this are due to the Kane non-parabolic energy band)
   xvelocity=P[n][1]*HM[i_dom[i][j]][iv]/thesquareroot;
   yvelocity=P[n][2]*HM[i_dom[i][j]][iv]/thesquareroot;
   cont[i][j]++;
   ener[i][j]+=superparticle_energy;
   if(iv==2) ener[i][j] += EG[i_dom[i][j]];
   xvel[i][j]+=xvelocity;
   yvel[i][j]+=yvelocity;
 }
// Mean Value of the macroscopic variables
// =======================================
  for(i=1;i<=nx+1;i++)
    for(j=1;j<=ny+1;j++){
      if(cont[i][j]!=0.){
          xvel[i][j]/=cont[i][j];
          yvel[i][j]/=cont[i][j];
          ener[i][j]/=cont[i][j];
      }
    }
// =======================================
  for(i=1;i<=nx+1;i++)
    for(j=1;j<=ny+1;j++){
      u2d[i][j][2]+=xvel[i][j];
      u2d[i][j][3]+=yvel[i][j];
      u2d[i][j][4]+=ener[i][j];
    }

}

// ================================================
