/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccResult;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.processing.ExportChecker;
import com.sun.electric.tool.ncc.processing.HashCodePartitioning;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.LocalPartitionResult;
import com.sun.electric.tool.ncc.processing.LocalPartitioning;
import com.sun.electric.tool.ncc.processing.ReportHashCodeFailure;
import com.sun.electric.tool.ncc.processing.SerialParallelMerge;
import com.sun.electric.tool.ncc.strategy.StratCheckSizes;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class NccEngine {
    private NccGlobals globals;

    private List buildNccNetlists(List cells, List contexts, List netlists, boolean blackBox, HierarchyInfo hierInfo) {
        this.globals.error(cells.size() != contexts.size() || contexts.size() != netlists.size(), "number of cells, contexts, and netlists must be the same");
        ArrayList<NccNetlist> nccLists = new ArrayList<NccNetlist>();
        Iterator itCell = cells.iterator();
        Iterator itCon = contexts.iterator();
        Iterator itNet = netlists.iterator();
        while (itCell.hasNext()) {
            Cell cell = (Cell)itCell.next();
            VarContext context = (VarContext)itCon.next();
            Netlist netlist = (Netlist)itNet.next();
            NccNetlist nccList = new NccNetlist(cell, context, netlist, hierInfo, blackBox, this.globals);
            nccLists.add(nccList);
        }
        return nccLists;
    }

    private int[] getNetObjCounts(EquivRecord rec, int numCells) {
        int[] counts = new int[numCells];
        if (rec == null) {
            return counts;
        }
        int i = 0;
        Iterator it = rec.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = (Circuit)it.next();
            counts[i] = ckt.numNetObjs();
            ++i;
        }
        return counts;
    }

    private void printWireComponentCounts() {
        int numCells = this.globals.getNumNetlistsBeingCompared();
        int[] partCounts = this.getNetObjCounts(this.globals.getParts(), numCells);
        int[] wireCounts = this.getNetObjCounts(this.globals.getWires(), numCells);
        int[] portCounts = this.getNetObjCounts(this.globals.getWires(), numCells);
        String[] cellNames = this.globals.getRootCellNames();
        VarContext[] contexts = this.globals.getRootContexts();
        for (int i = 0; i < cellNames.length; ++i) {
            this.globals.status1("  Cell: " + cellNames[i] + " has " + wireCounts[i] + " wires, " + partCounts[i] + " parts, and " + portCounts[i] + " ports after series/parallel combination. " + "Instance path: " + contexts[i].getInstPath("/"));
        }
    }

    private NccResult designsMatch(HierarchyInfo hierInfo, boolean hierInfoOnly) {
        boolean hasError = this.globals.cantBuildNetlist();
        if (this.globals.getRoot() == null || hasError) {
            this.globals.status2("empty cell or netlist error");
            this.globals.initLeafLists();
            return new NccResult(!hasError, !hasError, true, this.globals);
        }
        Date d0 = new Date();
        ExportChecker expCheck = new ExportChecker(this.globals);
        expCheck.markPortsForRenaming();
        boolean expNamesOK = expCheck.matchByName();
        if (expNamesOK) {
            expCheck.saveInfoNeededToMakeMeASubcircuit(hierInfo);
        } else if (hierInfo != null) {
            hierInfo.purgeCurrentCompareList();
        }
        Date d1 = new Date();
        this.globals.status1("  Export name matching took: " + NccUtils.hourMinSec(d0, d1));
        if (this.globals.userWantsToAbort()) {
            return new NccResult(true, true, true, this.globals);
        }
        SerialParallelMerge.doYourJob(this.globals);
        Date d2 = new Date();
        this.globals.status1("  Serial/parallel merge took: " + NccUtils.hourMinSec(d1, d2));
        if (this.globals.userWantsToAbort()) {
            return new NccResult(true, true, true, this.globals);
        }
        this.printWireComponentCounts();
        LocalPartitioning.doYourJob(this.globals);
        if (this.globals.userWantsToAbort()) {
            return new NccResult(true, true, true, this.globals);
        }
        this.globals.initLeafLists();
        LocalPartitionResult localRes = new LocalPartitionResult(this.globals);
        this.globals.getComparisonResult().setLocalPartitionResult(localRes);
        Date d3 = new Date();
        this.globals.status1("  Local partitioning took " + NccUtils.hourMinSec(d2, d3));
        boolean topoOK = HashCodePartitioning.doYourJob(this.globals);
        localRes.printErrorReport();
        if (!localRes.matches()) {
            return new NccResult(expNamesOK, false, false, this.globals);
        }
        if (this.globals.userWantsToAbort()) {
            return new NccResult(true, true, true, this.globals);
        }
        Date d4 = new Date();
        if (topoOK) {
            expCheck.suggestPortMatchesBasedOnTopology();
        }
        boolean expTopoOK = expCheck.ensureExportsWithMatchingNamesAreOnEquivalentNets();
        Date d5 = new Date();
        this.globals.status1("  Export checking took " + NccUtils.hourMinSec(d4, d5));
        boolean sizesOK = StratCheckSizes.doYourJob(this.globals);
        Date d6 = new Date();
        this.globals.status1("  Size checking took " + NccUtils.hourMinSec(d5, d6));
        if (!topoOK) {
            ReportHashCodeFailure.reportHashCodeFailure(this.globals);
        }
        boolean exportsOK = expNamesOK && expTopoOK;
        boolean topologyOK = localRes.matches() && topoOK;
        return new NccResult(exportsOK, topologyOK, sizesOK, this.globals);
    }

    private NccResult areEquivalent(List cells, List contexts, List netlists, HierarchyInfo hierInfo, boolean blackBox, NccOptions options, Aborter aborter) {
        this.globals = new NccGlobals(options, aborter);
        this.globals.status2("********************************************************************************");
        Date before = new Date();
        List nccNetlists = this.buildNccNetlists(cells, contexts, netlists, blackBox, hierInfo);
        Date after = new Date();
        this.globals.status1("  NCC net list construction took " + NccUtils.hourMinSec(before, after) + ".");
        this.globals.setInitialNetlists(nccNetlists);
        NccResult result = this.designsMatch(hierInfo, false);
        this.globals.status2("********************************************************************************");
        return result;
    }

    private static NccResult compare2(Cell cell1, VarContext context1, Cell cell2, VarContext context2, HierarchyInfo hierInfo, boolean blackBox, NccOptions options, Aborter aborter) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        cells.add(cell1);
        cells.add(cell2);
        ArrayList<VarContext> contexts = new ArrayList<VarContext>();
        contexts.add(context1);
        contexts.add(context2);
        ArrayList<Netlist> netlists = new ArrayList<Netlist>();
        netlists.add(cell1.getNetlist(true));
        netlists.add(cell2.getNetlist(true));
        return NccEngine.compareMany(cells, contexts, netlists, hierInfo, blackBox, options, aborter);
    }

    private static NccResult compareMany(List cells, List contexts, List netlists, HierarchyInfo hierCompInfo, boolean blackBox, NccOptions options, Aborter aborter) {
        NccEngine ncc = new NccEngine();
        return ncc.areEquivalent(cells, contexts, netlists, hierCompInfo, blackBox, options, aborter);
    }

    public static NccResult compare(List cells, List contexts, List netlists, HierarchyInfo hierCompInfo, NccOptions options, Aborter aborter) {
        return NccEngine.compareMany(cells, contexts, netlists, hierCompInfo, false, options, aborter);
    }

    public static NccResult compare(Cell cell1, VarContext context1, Cell cell2, VarContext context2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        return NccEngine.compare2(cell1, context1, cell2, context2, hierInfo, false, options, aborter);
    }

    public static boolean buildBlackBoxes(Cell cell1, VarContext ctxt1, Cell cell2, VarContext ctxt2, HierarchyInfo hierInfo, NccOptions options, Aborter aborter) {
        NccResult r = NccEngine.compare2(cell1, ctxt1, cell2, ctxt2, hierInfo, true, options, aborter);
        return r.exportMatch();
    }
}

