/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.Environment;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.UserInterfaceExec;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.EpicOutProcess;
import com.sun.electric.tool.io.input.HSpiceOut;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LTSpiceOut;
import com.sun.electric.tool.io.input.NewEpicOutProcess;
import com.sun.electric.tool.io.input.PSpiceOut;
import com.sun.electric.tool.io.input.RawSpiceOut;
import com.sun.electric.tool.io.input.SmartSpiceOut;
import com.sun.electric.tool.io.input.SpiceOut;
import com.sun.electric.tool.io.input.verilog.VerilogOut;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;

public abstract class Simulate
extends Input {
    public static void plotSpiceResults() {
        Simulation.SpiceEngine engine;
        String format = Simulation.getSpiceOutputFormat();
        FileType type = Simulate.getSpiceOutputType(format, engine = Simulation.getSpiceEngine());
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, null, null, null);
    }

    public static void plotSpiceResultsThisCell() {
        Simulation.SpiceEngine engine;
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        String format = Simulation.getSpiceOutputFormat();
        FileType type = Simulate.getSpiceOutputType(format, engine = Simulation.getSpiceEngine());
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, cell, null, null);
    }

    public static void plotVerilogResults() {
        Simulate.plotSimulationResults(FileType.VERILOGOUT, null, null, null);
    }

    public static void plotVerilogResultsThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        Simulate.plotSimulationResults(FileType.VERILOGOUT, cell, null, null);
    }

    private static Simulate getSimulate(FileType type) {
        Simulate is = null;
        if (type == FileType.HSPICEOUT) {
            is = new HSpiceOut();
        } else if (type == FileType.PSPICEOUT) {
            is = new PSpiceOut();
        } else if (type == FileType.RAWSPICEOUT) {
            is = new RawSpiceOut();
        } else if (type == FileType.RAWLTSPICEOUT) {
            is = new LTSpiceOut();
        } else if (type == FileType.RAWSSPICEOUT) {
            is = new SmartSpiceOut();
        } else if (type == FileType.SPICEOUT) {
            is = new SpiceOut();
        } else if (type == FileType.EPIC) {
            is = !Simulation.isUseLegacySimulationCode() ? new NewEpicOutProcess() : new EpicOutProcess();
        } else if (type == FileType.VERILOGOUT) {
            is = new VerilogOut();
        }
        return is;
    }

    public static void plotSimulationResults(FileType type, Cell cell, URL fileURL, WaveformWindow ww) {
        Simulate is = Simulate.getSimulate(type);
        if (is == null) {
            System.out.println("Cannot handle " + type.getName() + " files yet");
            return;
        }
        if (cell == null) {
            if (fileURL == null) {
                String fileName = OpenFile.chooseInputFile(type, null);
                if (fileName == null) {
                    return;
                }
                fileURL = TextUtils.makeURLToFile(fileName);
            }
            String cellName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library curLib = Library.getCurrent();
            cell = curLib.findNodeProto(cellName);
            if (cell == null) {
                CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), true, CellBrowser.DoAction.selectCellToAssoc);
                dialog.setVisible(true);
                cell = dialog.getSelectedCell();
                if (cell == null) {
                    return;
                }
            }
        } else if (fileURL == null) {
            String fileName = cell.getName() + "." + type.getFirstExtension();
            String filePath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
            File file = new File(filePath, fileName);
            if (!file.exists()) {
                String dir = type.getGroupPath();
                file = new File(dir, fileName);
            }
            fileURL = TextUtils.makeURLToFile(file.getPath());
        }
        new ReadSimulationOutput(type, is, fileURL, cell, ww).start();
    }

    public static Stimuli readSimulationResults(FileType type, Cell cell, URL fileURL) {
        Simulate is = Simulate.getSimulate(type);
        if (is == null) {
            System.out.println("Cannot handle " + type.getName() + " files yet");
            return null;
        }
        if (cell == null) {
            System.out.println("Error reading simulation results; specified Cell is null");
            return null;
        }
        if (fileURL == null) {
            System.out.println("Error reading simulation results; specified file is null");
            return null;
        }
        ReadSimulationOutput job = new ReadSimulationOutput(type, is, fileURL, cell, null);
        job.run();
        return job.sd;
    }

    protected abstract void readSimulationOutput(Stimuli var1, URL var2, Cell var3) throws IOException;

    public static FileType getSpiceOutputType(String format, Simulation.SpiceEngine engine) {
        if (format.equalsIgnoreCase("Standard")) {
            if (engine == Simulation.SpiceEngine.SPICE_ENGINE_H) {
                return FileType.HSPICEOUT;
            }
            if (engine == Simulation.SpiceEngine.SPICE_ENGINE_3 || engine == Simulation.SpiceEngine.SPICE_ENGINE_P) {
                return FileType.PSPICEOUT;
            }
            return FileType.SPICEOUT;
        }
        if (format.equalsIgnoreCase("Raw")) {
            return FileType.RAWSPICEOUT;
        }
        if (format.equalsIgnoreCase("RawSmart")) {
            return FileType.RAWSSPICEOUT;
        }
        if (format.equalsIgnoreCase("RawLT")) {
            return FileType.RAWLTSPICEOUT;
        }
        if (format.equalsIgnoreCase("Epic")) {
            return FileType.EPIC;
        }
        return null;
    }

    protected String getLineFromSimulator() throws IOException {
        StringBuffer sb = new StringBuffer();
        int bytesRead = 0;
        while (true) {
            int ch;
            if ((ch = this.lineReader.read()) == -1) {
                return null;
            }
            ++bytesRead;
            if (ch == 10 || ch == 13) break;
            sb.append((char)ch);
        }
        this.updateProgressDialog(bytesRead);
        return sb.toString();
    }

    static String removeLeadingX(String name) {
        int dotPos = -1;
        while (name.indexOf(46, dotPos + 1) >= 0) {
            int xPos = dotPos + 1;
            if (name.length() > xPos && name.charAt(xPos) == 'x') {
                name = name.substring(0, xPos) + name.substring(xPos + 1);
            }
            if ((dotPos = name.indexOf(46, xPos)) >= 0) continue;
            break;
        }
        return name;
    }

    private static class ReadSimulationOutput
    extends Thread {
        private FileType type;
        private Simulate is;
        private URL fileURL;
        private Cell cell;
        private WaveformWindow ww;
        private Stimuli sd;
        private final Environment launcherEnvironment;
        private final UserInterfaceExec userInterface;

        private ReadSimulationOutput(FileType type, Simulate is, URL fileURL, Cell cell, WaveformWindow ww) {
            this.type = type;
            this.is = is;
            this.fileURL = fileURL;
            this.cell = cell;
            this.ww = ww;
            this.sd = new Stimuli();
            this.launcherEnvironment = Environment.getThreadEnvironment();
            this.userInterface = new UserInterfaceExec();
        }

        public void run() {
            if (Thread.currentThread() == this) {
                Environment.setThreadEnvironment(this.launcherEnvironment);
                Job.setUserInterface(this.userInterface);
            }
            try {
                this.is.readSimulationOutput(this.sd, this.fileURL, this.cell);
                if (this.sd != null) {
                    this.sd.setDataType(this.type);
                    this.sd.setFileURL(this.fileURL);
                    final Stimuli sdx = this.sd;
                    final WaveformWindow wwx = this.ww;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Simulation.showSimulationData(sdx, wwx);
                        }
                    });
                }
            }
            catch (IOException e) {
                System.out.println("End of file reached while reading " + this.fileURL);
            }
        }
    }
}

