/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.KeyBindingManager;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SelectObject
extends EModelessDialog
implements DatabaseChangeListener {
    private static SelectObject theDialog = null;
    private static final int NODES = 1;
    private static final int ARCS = 2;
    private static final int EXPORTS = 3;
    private static final int NETS = 4;
    private static int what = 1;
    private Cell cell;
    private JList list;
    private DefaultListModel model;
    private Highlighter highlighter;
    private JRadioButton arcs;
    private JButton done;
    private JRadioButton exports;
    private JButton findText;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton networks;
    private JRadioButton nodes;
    private JScrollPane objectPane;
    private JTextField searchText;
    private ButtonGroup whatGroup;

    public static void selectObjectDialog(Cell thisCell, boolean updateOnlyIfVisible) {
        if (theDialog == null) {
            if (updateOnlyIfVisible) {
                return;
            }
            TopLevel jf = null;
            if (TopLevel.isMDIMode()) {
                jf = TopLevel.getCurrentJFrame();
            }
            theDialog = new SelectObject(jf);
        }
        if (updateOnlyIfVisible && !theDialog.isVisible()) {
            return;
        }
        theDialog.setVisible(true);
        theDialog.buttonClicked(thisCell);
        theDialog.toFront();
    }

    private SelectObject(Frame parent) {
        super(parent);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.done);
        UserInterfaceMain.addDatabaseChangeListener(this);
        switch (what) {
            case 1: {
                this.nodes.setSelected(true);
                break;
            }
            case 2: {
                this.arcs.setSelected(true);
                break;
            }
            case 3: {
                this.exports.setSelected(true);
                break;
            }
            case 4: {
                this.networks.setSelected(true);
            }
        }
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.setSelectionMode(2);
        this.objectPane.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SelectObject.this.listClicked();
            }
        });
        this.done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.closeDialog(null);
            }
        });
        this.nodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.arcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.exports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.networks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.buttonClicked(null);
            }
        });
        this.searchText.getDocument().addDocumentListener(new SelecdtObjectDocumentListener(this));
        TopLevel top = TopLevel.getCurrentJFrame();
        if (top != null && top.getTheMenuBar() != null) {
            KeyBindingManager.KeyMaps km = top.getEMenuBar().getKeyMaps();
            InputMap im = km.getInputMap();
            ActionMap am = km.getActionMap();
            this.getRootPane().getInputMap().setParent(im);
            this.getRootPane().getActionMap().setParent(am);
            this.findText.getInputMap().setParent(im);
            this.findText.getActionMap().setParent(am);
            this.list.getInputMap().setParent(im);
            this.list.getActionMap().setParent(am);
        }
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.closeDialog(null);
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        this.buttonClicked(null);
    }

    private void listClicked() {
        Netlist netlist;
        int[] si = this.list.getSelectedIndices();
        if (si.length > 0) {
            this.highlighter.clear();
        }
        if ((netlist = this.cell.getNetlist()) == null) {
            System.out.println("Sorry, a deadlock aborted selection (network information unavailable).  Please try again");
            return;
        }
        block0: for (int i = 0; i < si.length; ++i) {
            Iterator<Object> it;
            int index2 = si[i];
            String s = (String)this.model.get(index2);
            if (this.nodes.isSelected()) {
                it = this.cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (!s.equals(ni.getName())) continue;
                    this.highlighter.addElectricObject(ni, this.cell);
                    continue block0;
                }
                continue;
            }
            if (this.arcs.isSelected()) {
                it = this.cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    if (!s.equals(ai.getName())) continue;
                    this.highlighter.addElectricObject(ai, this.cell);
                    continue block0;
                }
                continue;
            }
            if (this.exports.isSelected()) {
                it = this.cell.getPorts();
                while (it.hasNext()) {
                    Export pp = (Export)it.next();
                    if (!s.equals(pp.getName())) continue;
                    this.highlighter.addText(pp, this.cell, Export.EXPORT_NAME);
                    continue block0;
                }
                continue;
            }
            it = netlist.getNetworks();
            while (it.hasNext()) {
                Network net = (Network)it.next();
                String netName = net.describe(false);
                if (netName.length() == 0 || !s.equals(netName)) continue;
                this.highlighter.addNetwork(net, this.cell);
                continue block0;
            }
        }
        if (si.length > 0) {
            this.highlighter.ensureHighlightingSeen();
            this.highlighter.finished();
        }
    }

    private void buttonClicked(Cell thisCell) {
        Iterator<Object> it;
        this.model.clear();
        Cell cell = this.cell = thisCell != null ? thisCell : WindowFrame.getCurrentCell();
        if (this.cell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent wc = wf.getContent();
        if (wc == null) {
            return;
        }
        this.highlighter = wc.getHighlighter();
        if (this.highlighter == null) {
            return;
        }
        ArrayList<String> allNames = new ArrayList<String>();
        if (this.nodes.isSelected()) {
            what = 1;
            it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                allNames.add(ni.getName());
            }
        } else if (this.arcs.isSelected()) {
            what = 2;
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                allNames.add(ai.getName());
            }
        } else if (this.exports.isSelected()) {
            what = 3;
            it = this.cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                allNames.add(pp.getName());
            }
        } else {
            what = 4;
            Netlist netlist = this.cell.getNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted selection (network information unavailable).  Please try again");
                return;
            }
            Iterator<Network> it2 = netlist.getNetworks();
            while (it2.hasNext()) {
                Network net = it2.next();
                String netName = net.describe(false);
                if (netName.length() == 0) continue;
                allNames.add(netName);
            }
        }
        Collections.sort(allNames, TextUtils.STRING_NUMBER_ORDER);
        for (String s : allNames) {
            this.model.addElement(s);
        }
    }

    private void searchTextChanged() {
        String currentSearchText = this.searchText.getText();
        int flags = 66;
        Pattern p = Pattern.compile(currentSearchText, flags);
        if (currentSearchText.length() == 0) {
            return;
        }
        for (int i = 0; i < this.model.size(); ++i) {
            String s = (String)this.model.get(i);
            Matcher m = p.matcher(s);
            if (!m.find()) continue;
            this.list.setSelectedIndex(i);
            this.list.ensureIndexIsVisible(i);
            return;
        }
    }

    private void initComponents() {
        this.whatGroup = new ButtonGroup();
        this.done = new JButton();
        this.objectPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.searchText = new JTextField();
        this.findText = new JButton();
        this.jPanel1 = new JPanel();
        this.nodes = new JRadioButton();
        this.exports = new JRadioButton();
        this.arcs = new JRadioButton();
        this.networks = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Select Object");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SelectObject.this.closeDialog(evt);
            }
        });
        this.done.setText("Done");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.done, gridBagConstraints);
        this.objectPane.setMinimumSize(new Dimension(200, 200));
        this.objectPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.objectPane, gridBagConstraints);
        this.jLabel1.setText("Search:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.searchText.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.searchText, gridBagConstraints);
        this.findText.setText("Find");
        this.findText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectObject.this.findTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findText, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.whatGroup.add(this.nodes);
        this.nodes.setText("Nodes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.nodes, gridBagConstraints);
        this.whatGroup.add(this.exports);
        this.exports.setText("Exports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.exports, gridBagConstraints);
        this.whatGroup.add(this.arcs);
        this.arcs.setText("Arcs");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.arcs, gridBagConstraints);
        this.whatGroup.add(this.networks);
        this.networks.setText("Networks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.networks, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void findTextActionPerformed(ActionEvent evt) {
        String search = this.searchText.getText();
        int flags = 66;
        Pattern p = Pattern.compile(search, flags);
        this.list.clearSelection();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        for (int i = 0; i < this.model.getSize(); ++i) {
            String thisLine = (String)this.model.getElementAt(i);
            Matcher m = p.matcher(thisLine);
            if (!m.find()) continue;
            selected.add(new Integer(i));
        }
        if (selected.size() > 0) {
            int[] indices = new int[selected.size()];
            int i = 0;
            for (Integer iO : selected) {
                indices[i++] = iO;
            }
            this.list.setSelectedIndices(indices);
        }
        this.listClicked();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class SelecdtObjectDocumentListener
    implements DocumentListener {
        SelectObject dialog;

        SelecdtObjectDocumentListener(SelectObject dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.searchTextChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.searchTextChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.searchTextChanged();
        }
    }
}

