/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output.bookshelf;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNodes;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutput;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class BookshelfOutputNodes
extends BookshelfOutputWriter {
    private static final Bookshelf.BookshelfFiles fileType = Bookshelf.BookshelfFiles.nodes;
    private Cell cell;
    private final EditingPreferences ep;

    public BookshelfOutputNodes(String genericFileName, Cell cell, EditingPreferences ep) {
        super(genericFileName, fileType);
        this.cell = cell;
        this.ep = ep;
    }

    @Override
    public void write() throws IOException {
        Job.getUserInterface().setProgressNote("Nodes File: " + this.fileName);
        PrintWriter writer = new PrintWriter(this.fileName);
        writer.println(BookshelfOutput.createBookshelfHeader(fileType));
        Iterator<NodeInst> ini = this.cell.getNodes();
        while (ini.hasNext()) {
            NodeInst ni = ini.next();
            BookshelfNodes.BookshelfNode node = new BookshelfNodes.BookshelfNode(ni.getName(), ni.getProto().getDefWidth(this.ep), ni.getProto().getDefHeight(this.ep), ni.isLocked());
            writer.println("   " + node.toString());
        }
        writer.flush();
        writer.close();
    }
}

