/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ncc.NccJob;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.result.NccResult;
import com.sun.electric.tool.ncc.result.NccResults;
import com.sun.electric.tool.ncc.result.equivalence.Equivalence;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AllSchemNamesToLay {
    static final long serialVersionUID = 0L;
    private static final boolean DEBUG = true;
    private String header;
    private final EditingPreferences ep;
    private int numArcRenames;
    private int numNodeRenames;
    private int numArcManRenames;
    private int numNodeManRenames;
    private int numNameConflicts;

    private void printHeader() {
        if (this.header != null) {
            this.prln(this.header);
        }
        this.header = null;
    }

    private boolean isAutoGenName(String nm) {
        return nm.indexOf(64) != -1;
    }

    private static int getAutoGenNumber(String nm) {
        char c;
        int ndx = nm.indexOf(64);
        if (ndx == -1) {
            return -1;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = ndx + 1; i < nm.length() && Character.isDigit(c = nm.charAt(i)); ++i) {
            sb.append(c);
        }
        if (sb.length() == 0) {
            return -1;
        }
        return Integer.valueOf(sb.toString());
    }

    private void prln(String s2) {
        System.out.println(s2);
    }

    private Map<String, ArcInst> buildNameToLayArcInst(Cell layCell) {
        HashMap<String, ArcInst> nmToArcInst = new HashMap<String, ArcInst>();
        Iterator<ArcInst> aiIt = layCell.getArcs();
        while (aiIt.hasNext()) {
            ArcInst ai = aiIt.next();
            nmToArcInst.put(ai.getName(), ai);
        }
        return nmToArcInst;
    }

    private Map<String, Network> buildNameToLayNetwork(Cell layCell) {
        HashMap<String, Network> nmToLayNet = new HashMap<String, Network>();
        Netlist nets = layCell.getNetlist(NccNetlist.SHORT_RESISTORS);
        Iterator<Network> netIt = nets.getNetworks();
        while (netIt.hasNext()) {
            Network net = netIt.next();
            Iterator<String> nmIt = net.getNames();
            while (nmIt.hasNext()) {
                String nm = nmIt.next();
                nmToLayNet.put(nm, net);
            }
        }
        return nmToLayNet;
    }

    private List<ArcInst> getArcInsts(Network layNet) {
        ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
        Iterator<ArcInst> aiIt = layNet.getArcs();
        while (aiIt.hasNext()) {
            arcs.add(aiIt.next());
        }
        return arcs;
    }

    private boolean isSchNameOnNonEquivLayNet(String schNetNm, Network layNet, Map<String, Network> nmToLayNet) {
        if (this.isAutoGenName(schNetNm)) {
            return false;
        }
        Network layNetWithSameNm = nmToLayNet.get(schNetNm);
        if (layNetWithSameNm != null && layNetWithSameNm != layNet) {
            this.printHeader();
            this.prln("    Can't copy schematic network name: " + schNetNm + " to layout because some non-equivalent layout network " + "already uses that name");
            ++this.numNameConflicts;
            return true;
        }
        return false;
    }

    private boolean isEquivLayNetDesignerNamed(String schNetNm, Network layNet) {
        Iterator<String> nmIt = layNet.getNames();
        while (nmIt.hasNext()) {
            String nm = nmIt.next();
            if (this.isAutoGenName(nm) || nm.equals(schNetNm)) continue;
            this.printHeader();
            this.prln("    Can't copy schematic network name: " + schNetNm + " to layout because equivalent layout network already " + "has a name assigned by the designer: " + nm);
            ++this.numArcManRenames;
            return true;
        }
        return false;
    }

    private boolean isLegalLayNetName(String schNetNm) {
        if (schNetNm.indexOf(64) != -1 && (schNetNm.indexOf(91) != -1 || schNetNm.indexOf(93) != -1)) {
            this.printHeader();
            this.prln("    Can't copy schematic network name: " + schNetNm + " to layout because name is not a legal name for layout arcs");
            return false;
        }
        return true;
    }

    private ArcRenameInfo buildArcRenameInfo(Cell schCell, Cell layCell, VarContext schCtxt, Equivalence equivs) {
        Map<String, ArcInst> nmToLayArcInst = this.buildNameToLayArcInst(layCell);
        Map<String, Network> nmToLayNet = this.buildNameToLayNetwork(layCell);
        ArrayList<SchemNetNm_LayArcInsts> schNmLayArcInsts = new ArrayList<SchemNetNm_LayArcInsts>();
        Netlist nets = schCell.getNetlist(NccNetlist.SHORT_RESISTORS);
        int maxSchemAutoGen = 0;
        for (Network schNet : new For<Network>(nets.getNetworks())) {
            String schNetNm;
            String layNetNm;
            Network layNet;
            HierarchyEnumerator.NetNameProxy layProx = equivs.findEquivalentNet(schCtxt, schNet);
            if (layProx == null || (layNet = layProx.getNet()).getParent() != layCell || layNet.isExported() || (layNetNm = layNet.getName()).equals(schNetNm = schNet.getName()) || this.isSchNameOnNonEquivLayNet(schNetNm, layNet, nmToLayNet) || this.isEquivLayNetDesignerNamed(schNetNm, layNet) || !this.isLegalLayNetName(schNetNm)) continue;
            List<ArcInst> layArcs = this.getArcInsts(layNet);
            if (layArcs.size() == 0) {
                this.printHeader();
                this.prln("    Can't copy schematic network name: " + schNetNm + " to layout because equivalent layout network has " + "no Arcs");
                continue;
            }
            ++this.numArcRenames;
            int autoGenNumb = AllSchemNamesToLay.getAutoGenNumber(schNetNm);
            if (autoGenNumb != -1) {
                maxSchemAutoGen = Math.max(maxSchemAutoGen, autoGenNumb);
            }
            this.printHeader();
            this.prln("    Renaming layout net from: " + layNetNm + " to: " + schNetNm);
            schNmLayArcInsts.add(new SchemNetNm_LayArcInsts(schNetNm, layArcs));
        }
        return new ArcRenameInfo(nmToLayArcInst, schNmLayArcInsts, maxSchemAutoGen);
    }

    private Map<String, NodeInst> buildNmToLayNodeInst(Cell layCell) {
        HashMap<String, NodeInst> nmsToLayNodeInsts = new HashMap<String, NodeInst>();
        Iterator<NodeInst> niIt = layCell.getNodes();
        while (niIt.hasNext()) {
            NodeInst ni = niIt.next();
            nmsToLayNodeInsts.put(ni.getName(), ni);
        }
        return nmsToLayNodeInsts;
    }

    private NodeRenameInfo buildNodeRenameInfo(Cell schCell, Cell layCell, VarContext schCtxt, Equivalence equivs) {
        Map<String, NodeInst> nmToLayNodeInst = this.buildNmToLayNodeInst(layCell);
        ArrayList<SchemNodaNm_LayNodeInst> schNmLayNodeInst = new ArrayList<SchemNodaNm_LayNodeInst>();
        for (Nodable schNode : new For<Nodable>(schCell.getNodables())) {
            String schNodeNm;
            NodeInst layNodeInst;
            String layNodeNm;
            Nodable layNoda;
            HierarchyEnumerator.NodableNameProxy layProx = equivs.findEquivalentNode(schCtxt, schNode);
            if (layProx == null || (layNoda = layProx.getNodable()).getParent() != layCell || !(layNoda instanceof NodeInst) || (layNodeNm = (layNodeInst = (NodeInst)layNoda).getName()).equals(schNodeNm = schNode.getName())) continue;
            if (!this.isAutoGenName(layNodeNm)) {
                this.printHeader();
                this.prln("    Can't copy schematic node name: " + schNodeNm + " to layout because equivalent layout NodeInst already " + "has a user assigned name: " + layNodeNm);
                ++this.numNodeManRenames;
                continue;
            }
            if (!this.isAutoGenName(schNodeNm) && nmToLayNodeInst.containsKey(schNodeNm)) {
                this.printHeader();
                this.prln("   Can't copy schematic node name: " + schNodeNm + " to layout because some " + " non-equivalent layout node already uses that name");
                ++this.numNameConflicts;
                continue;
            }
            schNmLayNodeInst.add(new SchemNodaNm_LayNodeInst(schNodeNm, layNodeInst));
            ++this.numNodeRenames;
            this.printHeader();
            this.prln("    Renaming layout NodeInst from: " + layNodeNm + " to: " + schNodeNm);
        }
        return new NodeRenameInfo(nmToLayNodeInst, schNmLayNodeInst);
    }

    private void renameLayNodesWithConflictingNames(NodeRenameInfo info, NameGenerator nameGen) {
        Map<String, NodeInst> nameToLayNodeInst = info.nameToLayNodeInst;
        for (SchemNodaNm_LayNodeInst i : info.toRename) {
            NodeInst layNode = nameToLayNodeInst.get(i.schemNodableName);
            if (layNode == null) continue;
            layNode.setName(nameGen.nextName());
        }
    }

    private void renameEquivLayNodes(NodeRenameInfo info, NameGenerator nameGen) {
        for (SchemNodaNm_LayNodeInst i : info.toRename) {
            i.equivLayoutNodeInst.setName(i.schemNodableName);
        }
    }

    private void renameNodes(NodeRenameInfo info) {
        NameGenerator nameGen = new NameGenerator("ncc", 0, info.nameToLayNodeInst.keySet());
        this.renameLayNodesWithConflictingNames(info, nameGen);
        this.renameEquivLayNodes(info, nameGen);
    }

    private void renameLayArcsWithConflictingNames(ArcRenameInfo info, NameGenerator nameGen) {
        Map<String, ArcInst> nameToLayArcInst = info.nameToLayArcInst;
        for (SchemNetNm_LayArcInsts i : info.toRename) {
            ArcInst layArc = nameToLayArcInst.get(i.schemNetworkName);
            if (layArc == null) continue;
            layArc.setName(nameGen.nextName(), this.ep);
        }
    }

    private ArcInst getLongestArc(List<ArcInst> arcs) {
        double longestDist = Double.NEGATIVE_INFINITY;
        ArcInst longest = null;
        for (ArcInst ai : arcs) {
            double length = ai.getGridLength();
            if (length <= longestDist) continue;
            longest = ai;
            longestDist = length;
        }
        return longest;
    }

    private void renameLayArcsToSchemName(ArcRenameInfo info, NameGenerator nameGen) {
        for (SchemNetNm_LayArcInsts i : info.toRename) {
            for (ArcInst a : i.equivLayoutArcInsts) {
                a.setName(nameGen.nextName(), this.ep);
            }
            ArcInst longest = this.getLongestArc(i.equivLayoutArcInsts);
            longest.setName(i.schemNetworkName, this.ep);
        }
    }

    private void renameArcs(ArcRenameInfo info) {
        NameGenerator nameGen = new NameGenerator("net", info.maxSchemAutoNameNumb, info.nameToLayArcInst.keySet());
        this.renameLayArcsWithConflictingNames(info, nameGen);
        this.renameLayArcsToSchemName(info, nameGen);
    }

    private void copySchematicNamesToLayout(Cell schCell, Cell layCell, VarContext schCtxt, Equivalence equivs) {
        this.header = "  Copy from: " + schCell.describe(false) + " to " + layCell.describe(false);
        if (!schCell.isSchematic()) {
            this.printHeader();
            this.prln("    First Cell isn't schematic: " + schCell.describe(false));
            return;
        }
        if (layCell.getView() != View.LAYOUT) {
            this.printHeader();
            this.prln("    Second Cell isn't layout: " + layCell.describe(false));
            return;
        }
        NodeRenameInfo nodeInfo = this.buildNodeRenameInfo(schCell, layCell, schCtxt, equivs);
        ArcRenameInfo arcInfo = this.buildArcRenameInfo(schCell, layCell, schCtxt, equivs);
        this.renameNodes(nodeInfo);
        this.renameArcs(arcInfo);
    }

    private void copySchematicNamesToLayout(NccResult result2) {
        int schNdx;
        Equivalence equivs = result2.getEquivalence();
        Cell[] rootCells = result2.getRootCells();
        if (rootCells.length != 2) {
            return;
        }
        if (rootCells[0].isSchematic() && rootCells[1].getView() == View.LAYOUT) {
            schNdx = 0;
        } else if (rootCells[0].getView() == View.LAYOUT && rootCells[1].isSchematic()) {
            schNdx = 1;
        } else {
            return;
        }
        int layNdx = schNdx == 0 ? 1 : 0;
        Cell schCell = rootCells[schNdx];
        Cell layCell = rootCells[layNdx];
        VarContext schContext = result2.getRootContexts()[schNdx];
        this.copySchematicNamesToLayout(schCell, layCell, schContext, equivs);
    }

    private AllSchemNamesToLay(NccResults results, EditingPreferences ep) {
        this.ep = ep;
        this.prln("Begin copying Network and Instance names from Schematic to Layout");
        if (results == null) {
            this.prln("  No saved NCC results. Please run NCC first.");
            return;
        }
        for (NccResult r : results) {
            if (!r.match()) continue;
            this.copySchematicNamesToLayout(r);
        }
        this.prln("Done");
    }

    RenameResult getResult() {
        return new RenameResult(this.numArcRenames, this.numNodeRenames, this.numArcManRenames, this.numNodeManRenames, this.numNameConflicts);
    }

    public static RenameResult copyNames(NccResults r, EditingPreferences ep) {
        AllSchemNamesToLay sntl = new AllSchemNamesToLay(r, ep);
        return sntl.getResult();
    }

    private static class For<T>
    implements Iterable<T> {
        Iterator<T> it;

        For(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public Iterator<T> iterator() {
            return this.it;
        }
    }

    public static class RenameJob
    extends Job {
        static final long serialVersionUID = 0L;
        private final NccResults results;

        @Override
        public boolean doIt() throws JobException {
            AllSchemNamesToLay.copyNames(this.results, this.getEditingPreferences());
            return true;
        }

        @Override
        public void terminateOK() {
            NccJob.invalidateLastNccResult();
        }

        public RenameJob(NccResults r) {
            super("SchemNamesToLayJob", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.results = r;
            this.startJob();
        }

        public RenameJob() {
            this(NccJob.getLastNccResults());
        }
    }

    public static class RenameResult {
        public final int numArcRenames;
        public final int numNodeRenames;
        public final int numArcManRenames;
        public final int numNodeManRenames;
        public final int numNameConflicts;

        RenameResult(int numArcRenames, int numNodeRenames, int numArcManRenames, int numNodeManRenames, int numNameConflicts) {
            this.numArcRenames = numArcRenames;
            this.numNodeRenames = numNodeRenames;
            this.numArcManRenames = numArcManRenames;
            this.numNodeManRenames = numNodeManRenames;
            this.numNameConflicts = numNameConflicts;
        }
    }

    private static class NameGenerator {
        private int maxNumb;
        private String prefix;

        NameGenerator(String prefix, int startNumb, Set<String> usedNames) {
            this.maxNumb = startNumb;
            this.prefix = prefix;
            for (String nm : usedNames) {
                if (!nm.startsWith(prefix + "@")) continue;
                int numb = AllSchemNamesToLay.getAutoGenNumber(nm);
                this.maxNumb = Math.max(this.maxNumb, numb);
            }
        }

        String nextName() {
            return this.prefix + "@" + ++this.maxNumb;
        }
    }

    private static class ArcRenameInfo {
        final Map<String, ArcInst> nameToLayArcInst;
        final List<SchemNetNm_LayArcInsts> toRename;
        final int maxSchemAutoNameNumb;

        ArcRenameInfo(Map<String, ArcInst> nameToArcInst, List<SchemNetNm_LayArcInsts> toRename, int maxSchemAutoNameNumb) {
            this.nameToLayArcInst = nameToArcInst;
            this.toRename = toRename;
            this.maxSchemAutoNameNumb = maxSchemAutoNameNumb;
        }
    }

    private static class SchemNetNm_LayArcInsts {
        final String schemNetworkName;
        final List<ArcInst> equivLayoutArcInsts;

        SchemNetNm_LayArcInsts(String schemNetworkName, List<ArcInst> equivLayoutArcInsts) {
            this.schemNetworkName = schemNetworkName;
            this.equivLayoutArcInsts = equivLayoutArcInsts;
        }
    }

    private static class NodeRenameInfo {
        final Map<String, NodeInst> nameToLayNodeInst;
        final List<SchemNodaNm_LayNodeInst> toRename;

        NodeRenameInfo(Map<String, NodeInst> nameToNodeInst, List<SchemNodaNm_LayNodeInst> toRename) {
            this.nameToLayNodeInst = nameToNodeInst;
            this.toRename = toRename;
        }
    }

    private static class SchemNodaNm_LayNodeInst {
        final String schemNodableName;
        final NodeInst equivLayoutNodeInst;

        SchemNodaNm_LayNodeInst(String schemNodableName, NodeInst equivLayoutNodeInst) {
            this.schemNodableName = schemNodableName;
            this.equivLayoutNodeInst = equivLayoutNodeInst;
        }
    }
}

