/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fillCell;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fillCell.FillCellGenJob;
import com.sun.electric.tool.generator.layout.fillCell.FillCellTool;
import com.sun.electric.tool.user.dialogs.FillGenDialog;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FillCelllGenPanel
extends JPanel {
    private JRadioButton cellButton;
    private JComboBox fillTypeComboBox;
    private JComboBox masterComboBox;
    private JTextField gapTextField;
    private JTextField levelTextField;
    private JCheckBox aroundButton;
    private JComboBox routerTypeComboBox;
    private JLabel gapLabel;
    private FillGenDialog parentDialog;

    public FillCelllGenPanel(FillGenDialog dialog, JPanel floorplanPanel, ButtonGroup topGroup, JButton okButton, JRadioButton templateButton) {
        this.parentDialog = dialog;
        this.initComponents(floorplanPanel, topGroup);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.okButtonActionPerformed();
            }
        });
        templateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.optionActionPerformed(evt);
            }
        });
        FillCellTool.FillCellMode mode = FillCellTool.getFillCellMode();
        this.fillTypeComboBox.setModel(new DefaultComboBoxModel<FillCellTool.FillCellMode>(FillCellTool.FillCellMode.values()));
        this.fillTypeComboBox.setSelectedItem((Object)mode);
        FillGenConfig.FillGenType routerMode = FillCellTool.getFillRouterMode();
        this.routerTypeComboBox.setModel(new DefaultComboBoxModel<FillGenConfig.FillGenType>(FillGenConfig.FillGenType.values()));
        this.routerTypeComboBox.setSelectedItem((Object)routerMode);
        boolean createMaster = FillCellTool.isFillCellCreateMasterOn();
        this.masterComboBox.setModel(new DefaultComboBoxModel<CellTypeEnum>(CellTypeEnum.values()));
        if (createMaster) {
            this.masterComboBox.setSelectedItem((Object)CellTypeEnum.CREATE);
        } else {
            this.masterComboBox.setSelectedItem((Object)CellTypeEnum.USE);
        }
        this.optionActionPerformed(null);
    }

    private void okButtonActionPerformed() {
        boolean binary = this.fillTypeComboBox.getSelectedItem() == FillCellTool.FillCellMode.BINARY;
        FillGenConfig.FillGenType routerType = (FillGenConfig.FillGenType)((Object)this.routerTypeComboBox.getSelectedItem());
        double gap = TextUtils.atof(this.gapTextField.getText());
        FillGenConfig config = this.parentDialog.okButtonClick(this.isFlatSelected(), this.isCreateOptionSelected(), binary, this.aroundButton.isSelected(), gap, routerType, TextUtils.atoi(this.levelTextField.getText()));
        if (config != null) {
            new FillCellGenJob(Job.getUserInterface().getCurrentCell(), config, false, new LayerCoverageTool.LayerCoveragePreferences(false));
        }
        FillCellTool.FillCellMode mode = (FillCellTool.FillCellMode)((Object)this.fillTypeComboBox.getSelectedItem());
        FillCellTool.setFillCellMode(mode);
        FillCellTool.setFillRouterMode(routerType);
        FillCellTool.setFillCellCreateMasterOn(this.isCreateOptionSelected());
    }

    private void initComponents(JPanel floorplanPanel, ButtonGroup topGroup) {
        this.setBorder(BorderFactory.createTitledBorder("Fill Information"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        floorplanPanel.add((Component)this, gridBagConstraints);
        this.cellButton = new JRadioButton();
        this.cellButton.setText("Fill Cell");
        this.cellButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cellButton.setMargin(new Insets(0, 0, 0, 0));
        this.cellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.optionActionPerformed(evt);
            }
        });
        topGroup.add(this.cellButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        floorplanPanel.add((Component)this.cellButton, gridBagConstraints);
        JLabel fillTypeLabel = new JLabel();
        fillTypeLabel.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)fillTypeLabel, gridBagConstraints);
        JLabel masterLabel = new JLabel();
        masterLabel.setText("Master");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 2);
        this.add((Component)masterLabel, gridBagConstraints);
        this.masterComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.add((Component)this.masterComboBox, gridBagConstraints);
        this.masterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.generalSetup();
            }
        });
        this.fillTypeComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.fillTypeComboBox, gridBagConstraints);
        this.fillTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.generalSetup();
            }
        });
        this.gapLabel = new JLabel();
        this.gapLabel.setText("Overlap");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 2);
        this.add((Component)this.gapLabel, gridBagConstraints);
        this.gapTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.add((Component)this.gapTextField, gridBagConstraints);
        JLabel levelLabel = new JLabel();
        levelLabel.setText("Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 2);
        this.add((Component)levelLabel, gridBagConstraints);
        this.levelTextField = new JTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.add((Component)this.levelTextField, gridBagConstraints);
        this.aroundButton = new JCheckBox();
        this.aroundButton.setText("Only Around");
        this.aroundButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.aroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.aroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.aroundButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.aroundButton, gridBagConstraints);
        JLabel routerLabel = new JLabel();
        routerLabel.setText("Router");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)routerLabel, gridBagConstraints);
        this.routerTypeComboBox = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.routerTypeComboBox, gridBagConstraints);
        this.routerTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FillCelllGenPanel.this.generalSetup();
            }
        });
    }

    private boolean isFlatSelected() {
        return this.fillTypeComboBox.getSelectedItem() == FillCellTool.FillCellMode.FLAT;
    }

    private boolean isCreateOptionSelected() {
        return this.masterComboBox.getSelectedItem() == CellTypeEnum.CREATE;
    }

    private void optionActionPerformed(ActionEvent evt) {
        boolean isCellSelected = this.cellButton.isSelected();
        FillCelllGenPanel.setEnabledInHierarchy(this, isCellSelected);
        this.parentDialog.optionAction(this.isFlatSelected(), this.isCreateOptionSelected(), isCellSelected);
    }

    private void aroundButtonActionPerformed(ActionEvent evt) {
        this.gapTextField.setEnabled(this.aroundButton.isSelected());
        this.gapLabel.setEnabled(this.aroundButton.isSelected());
    }

    private static void setEnabledInHierarchy(Container c, boolean value) {
        c.setEnabled(value);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component co = c.getComponent(i);
            co.setEnabled(value);
            if (!(co instanceof Container)) continue;
            FillCelllGenPanel.setEnabledInHierarchy((Container)co, value);
        }
    }

    private void generalSetup() {
        boolean flatSelected = this.isFlatSelected();
        FillCelllGenPanel.setEnabledInHierarchy(this.masterComboBox, !flatSelected);
        this.parentDialog.generalSetup(flatSelected, this.isCreateOptionSelected());
        this.aroundButtonActionPerformed(null);
    }

    private static enum CellTypeEnum {
        CREATE,
        USE;

    }
}

