/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.svex.funs;

import com.sun.electric.tool.simulation.acl2.svex.BigIntegerUtil;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexFunction;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.FunctionSyms;
import java.math.BigInteger;
import java.util.Map;

public class Vec4WildeqSafe<N extends SvarName>
extends SvexCall<N> {
    public static final Function FUNCTION = new Function();
    public final Svex<N> x;
    public final Svex<N> y;

    private Vec4WildeqSafe(Svex<N> x, Svex<N> y) {
        super(FUNCTION, x, y);
        this.x = x;
        this.y = y;
    }

    public static class Function
    extends SvexFunction {
        private Function() {
            super(FunctionSyms.SV_SAFER_EQ_EQ_QUEST, 2, "4vec-wildeq-safe");
        }

        public <N extends SvarName> Vec4WildeqSafe<N> build(Svex<N>[] args) {
            return new Vec4WildeqSafe<N>(args[0], args[1]);
        }

        @Override
        public Vec4 apply(Vec4 ... args) {
            Vec4 a = args[0];
            Vec4 b = args[1];
            BigInteger zMask = b.getLower().andNot(b.getUpper());
            return this.eq(a, b, zMask);
        }

        @Override
        protected <N extends SvarName> BigInteger[] svmaskFor(BigInteger mask, Svex<N>[] args, Map<Svex<N>, Vec4> xevalMemoize) {
            if (mask.signum() == 0) {
                return new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
            }
            Svex<N> b = args[1];
            Vec4 bVal = b.xeval(xevalMemoize);
            BigInteger bNonZ = bVal.getLower().andNot(bVal.getUpper()).not();
            return new BigInteger[]{bNonZ, BigIntegerUtil.MINUS_ONE};
        }
    }
}

