/* NameValuePair.java --
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package org.omg.CORBA;

import org.omg.CORBA.portable.IDLEntity;

import java.io.Serializable;

/**
 * Holds the value, having the given name(id). This class is used by
 * with {@link DynStruct} to name the fields of the record (structure).
 *
 * @author Audrius Meskauskas, Lithuania (AudriusA@Bioinformatics.org)
 */
public final class NameValuePair
  implements Serializable, IDLEntity
{
  /**
   * The value of the structure record.
   */
  public Any value;

  /**
   * Use serialVersionUID (v1.4) for interoperability.
   */
  private static final long serialVersionUID = 7000741877654946223L;

  /**
   * The name of the structure record.
   */
  public String id;

  /**
   * Cretes an unitialised instance of the name-value pair.
   */
  public NameValuePair()
  {
  }

  /**
   * Creates the name-value pair, initialising the fields to the passed
   * values.
   *
   * @param an_id the name (also called id) of the name-value pair, normally
   * the name of the structure field.
   *
   * @param a_value the value of the name-value pair.
   */
  public NameValuePair(String an_id, Any a_value)
  {
    id = an_id;
    value = a_value;
  }
}
