/* Information for instruction disassembly on the Convex.
   Copyright (C) 1989-2019 Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston,
   MA 02110-1301, USA.  */

#define xxx 0
#define rrr 1
#define rr 2
#define rxr 3
#define r 4
#define nops 5
#define nr 6
#define pcrel 7
#define lr 8
#define rxl 9
#define rlr 10
#define rrl 11
#define iml 12
#define imr 13
#define a1r 14
#define a1l 15
#define a2r 16
#define a2l 17
#define a3 18
#define a4 19
#define a5 20
#define V 1
#define S 2
#define VM 3
#define A 4
#define VL 5
#define VS 6
#define VLS 7
#define PSW 8
/* Prevent an error during "make depend".  */
#if !defined (PC)
#define PC 9
#endif
#define ITR 10
#define VV 11
#define ITSR 12
#define TOC 13
#define CIR 14
#define TTR 15
#define VMU 16
#define VML 17
#define ICR 18
#define TCPU 19
#define CPUID 20
#define TID 21

const char *op[] = {
  "",
  "v0\0v1\0v2\0v3\0v4\0v5\0v6\0v7",
  "s0\0s1\0s2\0s3\0s4\0s5\0s6\0s7",
  "vm",
  "sp\0a1\0a2\0a3\0a4\0a5\0ap\0fp",
  "vl",
  "vs",
  "vls",
  "psw",
  "pc",
  "itr",
  "vv",
  "itsr",
  "toc",
  "cir",
  "ttr",
  "vmu",
  "vml",
  "icr",
  "tcpu",
  "cpuid",
  "tid",
};

const struct formstr format0[] = {
  {0,0,rrr,V,S,S},	/* mov */
  {0,0,rrr,S,S,V},	/* mov */
  {1,1,rrr,V,V,V},	/* merg.t */
  {2,1,rrr,V,V,V},	/* mask.t */
  {1,2,rrr,V,S,V},	/* merg.f */
  {2,2,rrr,V,S,V},	/* mask.f */
  {1,1,rrr,V,S,V},	/* merg.t */
  {2,1,rrr,V,S,V},	/* mask.t */
  {3,3,rrr,V,V,V},	/* mul.s */
  {3,4,rrr,V,V,V},	/* mul.d */
  {4,3,rrr,V,V,V},	/* div.s */
  {4,4,rrr,V,V,V},	/* div.d */
  {3,3,rrr,V,S,V},	/* mul.s */
  {3,4,rrr,V,S,V},	/* mul.d */
  {4,3,rrr,V,S,V},	/* div.s */
  {4,4,rrr,V,S,V},	/* div.d */
  {5,0,rrr,V,V,V},	/* and */
  {6,0,rrr,V,V,V},	/* or */
  {7,0,rrr,V,V,V},	/* xor */
  {8,0,rrr,V,V,V},	/* shf */
  {5,0,rrr,V,S,V},	/* and */
  {6,0,rrr,V,S,V},	/* or */
  {7,0,rrr,V,S,V},	/* xor */
  {8,0,rrr,V,S,V},	/* shf */
  {9,3,rrr,V,V,V},	/* add.s */
  {9,4,rrr,V,V,V},	/* add.d */
  {10,3,rrr,V,V,V},	/* sub.s */
  {10,4,rrr,V,V,V},	/* sub.d */
  {9,3,rrr,V,S,V},	/* add.s */
  {9,4,rrr,V,S,V},	/* add.d */
  {10,3,rrr,V,S,V},	/* sub.s */
  {10,4,rrr,V,S,V},	/* sub.d */
  {9,5,rrr,V,V,V},	/* add.b */
  {9,6,rrr,V,V,V},	/* add.h */
  {9,7,rrr,V,V,V},	/* add.w */
  {9,8,rrr,V,V,V},	/* add.l */
  {9,5,rrr,V,S,V},	/* add.b */
  {9,6,rrr,V,S,V},	/* add.h */
  {9,7,rrr,V,S,V},	/* add.w */
  {9,8,rrr,V,S,V},	/* add.l */
  {10,5,rrr,V,V,V},	/* sub.b */
  {10,6,rrr,V,V,V},	/* sub.h */
  {10,7,rrr,V,V,V},	/* sub.w */
  {10,8,rrr,V,V,V},	/* sub.l */
  {10,5,rrr,V,S,V},	/* sub.b */
  {10,6,rrr,V,S,V},	/* sub.h */
  {10,7,rrr,V,S,V},	/* sub.w */
  {10,8,rrr,V,S,V},	/* sub.l */
  {3,5,rrr,V,V,V},	/* mul.b */
  {3,6,rrr,V,V,V},	/* mul.h */
  {3,7,rrr,V,V,V},	/* mul.w */
  {3,8,rrr,V,V,V},	/* mul.l */
  {3,5,rrr,V,S,V},	/* mul.b */
  {3,6,rrr,V,S,V},	/* mul.h */
  {3,7,rrr,V,S,V},	/* mul.w */
  {3,8,rrr,V,S,V},	/* mul.l */
  {4,5,rrr,V,V,V},	/* div.b */
  {4,6,rrr,V,V,V},	/* div.h */
  {4,7,rrr,V,V,V},	/* div.w */
  {4,8,rrr,V,V,V},	/* div.l */
  {4,5,rrr,V,S,V},	/* div.b */
  {4,6,rrr,V,S,V},	/* div.h */
  {4,7,rrr,V,S,V},	/* div.w */
  {4,8,rrr,V,S,V},	/* div.l */
};

const struct formstr format1[] = {
  {11,0,xxx,0,0,0},	/* exit */
  {12,0,a3,0,0,0},	/* jmp */
  {13,2,a3,0,0,0},	/* jmpi.f */
  {13,1,a3,0,0,0},	/* jmpi.t */
  {14,2,a3,0,0,0},	/* jmpa.f */
  {14,1,a3,0,0,0},	/* jmpa.t */
  {15,2,a3,0,0,0},	/* jmps.f */
  {15,1,a3,0,0,0},	/* jmps.t */
  {16,0,a3,0,0,0},	/* tac */
  {17,0,a1r,A,0,0},	/* ldea */
  {18,8,a1l,VLS,0,0},	/* ld.l */
  {18,9,a1l,VM,0,0},	/* ld.x */
  {19,0,a3,0,0,0},	/* tas */
  {20,0,a3,0,0,0},	/* pshea */
  {21,8,a2l,VLS,0,0},	/* st.l */
  {21,9,a2l,VM,0,0},	/* st.x */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {22,0,a3,0,0,0},	/* call */
  {23,0,a3,0,0,0},	/* calls */
  {24,0,a3,0,0,0},	/* callq */
  {25,0,a1r,A,0,0},	/* pfork */
  {26,5,a2r,S,0,0},	/* ste.b */
  {26,6,a2r,S,0,0},	/* ste.h */
  {26,7,a2r,S,0,0},	/* ste.w */
  {26,8,a2r,S,0,0},	/* ste.l */
  {18,5,a1r,A,0,0},	/* ld.b */
  {18,6,a1r,A,0,0},	/* ld.h */
  {18,7,a1r,A,0,0},	/* ld.w */
  {27,7,a1r,A,0,0},	/* incr.w */
  {21,5,a2r,A,0,0},	/* st.b */
  {21,6,a2r,A,0,0},	/* st.h */
  {21,7,a2r,A,0,0},	/* st.w */
  {27,8,a1r,S,0,0},	/* incr.l */
  {18,5,a1r,S,0,0},	/* ld.b */
  {18,6,a1r,S,0,0},	/* ld.h */
  {18,7,a1r,S,0,0},	/* ld.w */
  {18,8,a1r,S,0,0},	/* ld.l */
  {21,5,a2r,S,0,0},	/* st.b */
  {21,6,a2r,S,0,0},	/* st.h */
  {21,7,a2r,S,0,0},	/* st.w */
  {21,8,a2r,S,0,0},	/* st.l */
  {18,5,a1r,V,0,0},	/* ld.b */
  {18,6,a1r,V,0,0},	/* ld.h */
  {18,7,a1r,V,0,0},	/* ld.w */
  {18,8,a1r,V,0,0},	/* ld.l */
  {21,5,a2r,V,0,0},	/* st.b */
  {21,6,a2r,V,0,0},	/* st.h */
  {21,7,a2r,V,0,0},	/* st.w */
  {21,8,a2r,V,0,0},	/* st.l */
};

const struct formstr format2[] = {
  {28,5,rr,A,A,0},	/* cvtw.b */
  {28,6,rr,A,A,0},	/* cvtw.h */
  {29,7,rr,A,A,0},	/* cvtb.w */
  {30,7,rr,A,A,0},	/* cvth.w */
  {28,5,rr,S,S,0},	/* cvtw.b */
  {28,6,rr,S,S,0},	/* cvtw.h */
  {29,7,rr,S,S,0},	/* cvtb.w */
  {30,7,rr,S,S,0},	/* cvth.w */
  {28,3,rr,S,S,0},	/* cvtw.s */
  {31,7,rr,S,S,0},	/* cvts.w */
  {32,3,rr,S,S,0},	/* cvtd.s */
  {31,4,rr,S,S,0},	/* cvts.d */
  {31,8,rr,S,S,0},	/* cvts.l */
  {32,8,rr,S,S,0},	/* cvtd.l */
  {33,3,rr,S,S,0},	/* cvtl.s */
  {33,4,rr,S,S,0},	/* cvtl.d */
  {34,0,rr,A,A,0},	/* ldpa */
  {8,0,nr,A,0,0},	/* shf */
  {18,6,nr,A,0,0},	/* ld.h */
  {18,7,nr,A,0,0},	/* ld.w */
  {33,7,rr,S,S,0},	/* cvtl.w */
  {28,8,rr,S,S,0},	/* cvtw.l */
  {35,1,rr,S,S,0},	/* plc.t */
  {36,0,rr,S,S,0},	/* tzc */
  {37,6,rr,A,A,0},	/* eq.h */
  {37,7,rr,A,A,0},	/* eq.w */
  {37,6,nr,A,0,0},	/* eq.h */
  {37,7,nr,A,0,0},	/* eq.w */
  {37,5,rr,S,S,0},	/* eq.b */
  {37,6,rr,S,S,0},	/* eq.h */
  {37,7,rr,S,S,0},	/* eq.w */
  {37,8,rr,S,S,0},	/* eq.l */
  {38,6,rr,A,A,0},	/* leu.h */
  {38,7,rr,A,A,0},	/* leu.w */
  {38,6,nr,A,0,0},	/* leu.h */
  {38,7,nr,A,0,0},	/* leu.w */
  {38,5,rr,S,S,0},	/* leu.b */
  {38,6,rr,S,S,0},	/* leu.h */
  {38,7,rr,S,S,0},	/* leu.w */
  {38,8,rr,S,S,0},	/* leu.l */
  {39,6,rr,A,A,0},	/* ltu.h */
  {39,7,rr,A,A,0},	/* ltu.w */
  {39,6,nr,A,0,0},	/* ltu.h */
  {39,7,nr,A,0,0},	/* ltu.w */
  {39,5,rr,S,S,0},	/* ltu.b */
  {39,6,rr,S,S,0},	/* ltu.h */
  {39,7,rr,S,S,0},	/* ltu.w */
  {39,8,rr,S,S,0},	/* ltu.l */
  {40,6,rr,A,A,0},	/* le.h */
  {40,7,rr,A,A,0},	/* le.w */
  {40,6,nr,A,0,0},	/* le.h */
  {40,7,nr,A,0,0},	/* le.w */
  {40,5,rr,S,S,0},	/* le.b */
  {40,6,rr,S,S,0},	/* le.h */
  {40,7,rr,S,S,0},	/* le.w */
  {40,8,rr,S,S,0},	/* le.l */
  {41,6,rr,A,A,0},	/* lt.h */
  {41,7,rr,A,A,0},	/* lt.w */
  {41,6,nr,A,0,0},	/* lt.h */
  {41,7,nr,A,0,0},	/* lt.w */
  {41,5,rr,S,S,0},	/* lt.b */
  {41,6,rr,S,S,0},	/* lt.h */
  {41,7,rr,S,S,0},	/* lt.w */
  {41,8,rr,S,S,0},	/* lt.l */
  {9,7,rr,S,A,0},	/* add.w */
  {8,0,rr,A,A,0},	/* shf */
  {0,0,rr,A,A,0},	/* mov */
  {0,0,rr,S,A,0},	/* mov */
  {0,7,rr,S,S,0},	/* mov.w */
  {8,0,rr,S,S,0},	/* shf */
  {0,0,rr,S,S,0},	/* mov */
  {0,0,rr,A,S,0},	/* mov */
  {5,0,rr,A,A,0},	/* and */
  {6,0,rr,A,A,0},	/* or */
  {7,0,rr,A,A,0},	/* xor */
  {42,0,rr,A,A,0},	/* not */
  {5,0,rr,S,S,0},	/* and */
  {6,0,rr,S,S,0},	/* or */
  {7,0,rr,S,S,0},	/* xor */
  {42,0,rr,S,S,0},	/* not */
  {40,3,rr,S,S,0},	/* le.s */
  {40,4,rr,S,S,0},	/* le.d */
  {41,3,rr,S,S,0},	/* lt.s */
  {41,4,rr,S,S,0},	/* lt.d */
  {9,3,rr,S,S,0},	/* add.s */
  {9,4,rr,S,S,0},	/* add.d */
  {10,3,rr,S,S,0},	/* sub.s */
  {10,4,rr,S,S,0},	/* sub.d */
  {37,3,rr,S,S,0},	/* eq.s */
  {37,4,rr,S,S,0},	/* eq.d */
  {43,6,rr,A,A,0},	/* neg.h */
  {43,7,rr,A,A,0},	/* neg.w */
  {3,3,rr,S,S,0},	/* mul.s */
  {3,4,rr,S,S,0},	/* mul.d */
  {4,3,rr,S,S,0},	/* div.s */
  {4,4,rr,S,S,0},	/* div.d */
  {9,6,rr,A,A,0},	/* add.h */
  {9,7,rr,A,A,0},	/* add.w */
  {9,6,nr,A,0,0},	/* add.h */
  {9,7,nr,A,0,0},	/* add.w */
  {9,5,rr,S,S,0},	/* add.b */
  {9,6,rr,S,S,0},	/* add.h */
  {9,7,rr,S,S,0},	/* add.w */
  {9,8,rr,S,S,0},	/* add.l */
  {10,6,rr,A,A,0},	/* sub.h */
  {10,7,rr,A,A,0},	/* sub.w */
  {10,6,nr,A,0,0},	/* sub.h */
  {10,7,nr,A,0,0},	/* sub.w */
  {10,5,rr,S,S,0},	/* sub.b */
  {10,6,rr,S,S,0},	/* sub.h */
  {10,7,rr,S,S,0},	/* sub.w */
  {10,8,rr,S,S,0},	/* sub.l */
  {3,6,rr,A,A,0},	/* mul.h */
  {3,7,rr,A,A,0},	/* mul.w */
  {3,6,nr,A,0,0},	/* mul.h */
  {3,7,nr,A,0,0},	/* mul.w */
  {3,5,rr,S,S,0},	/* mul.b */
  {3,6,rr,S,S,0},	/* mul.h */
  {3,7,rr,S,S,0},	/* mul.w */
  {3,8,rr,S,S,0},	/* mul.l */
  {4,6,rr,A,A,0},	/* div.h */
  {4,7,rr,A,A,0},	/* div.w */
  {4,6,nr,A,0,0},	/* div.h */
  {4,7,nr,A,0,0},	/* div.w */
  {4,5,rr,S,S,0},	/* div.b */
  {4,6,rr,S,S,0},	/* div.h */
  {4,7,rr,S,S,0},	/* div.w */
  {4,8,rr,S,S,0},	/* div.l */
};

const struct formstr format3[] = {
  {32,3,rr,V,V,0},	/* cvtd.s */
  {31,4,rr,V,V,0},	/* cvts.d */
  {33,4,rr,V,V,0},	/* cvtl.d */
  {32,8,rr,V,V,0},	/* cvtd.l */
  {0,0,rrl,S,S,VM},	/* mov */
  {0,0,rlr,S,VM,S},	/* mov */
  {0,0,0,0,0,0},
  {44,0,rr,S,S,0},	/* lop */
  {36,0,rr,V,V,0},	/* tzc */
  {44,0,rr,V,V,0},	/* lop */
  {0,0,0,0,0,0},
  {42,0,rr,V,V,0},	/* not */
  {8,0,rr,S,V,0},	/* shf */
  {35,1,rr,V,V,0},	/* plc.t */
  {45,2,rr,V,V,0},	/* cprs.f */
  {45,1,rr,V,V,0},	/* cprs.t */
  {37,3,rr,V,V,0},	/* eq.s */
  {37,4,rr,V,V,0},	/* eq.d */
  {43,3,rr,V,V,0},	/* neg.s */
  {43,4,rr,V,V,0},	/* neg.d */
  {37,3,rr,S,V,0},	/* eq.s */
  {37,4,rr,S,V,0},	/* eq.d */
  {43,3,rr,S,S,0},	/* neg.s */
  {43,4,rr,S,S,0},	/* neg.d */
  {40,3,rr,V,V,0},	/* le.s */
  {40,4,rr,V,V,0},	/* le.d */
  {41,3,rr,V,V,0},	/* lt.s */
  {41,4,rr,V,V,0},	/* lt.d */
  {40,3,rr,S,V,0},	/* le.s */
  {40,4,rr,S,V,0},	/* le.d */
  {41,3,rr,S,V,0},	/* lt.s */
  {41,4,rr,S,V,0},	/* lt.d */
  {37,5,rr,V,V,0},	/* eq.b */
  {37,6,rr,V,V,0},	/* eq.h */
  {37,7,rr,V,V,0},	/* eq.w */
  {37,8,rr,V,V,0},	/* eq.l */
  {37,5,rr,S,V,0},	/* eq.b */
  {37,6,rr,S,V,0},	/* eq.h */
  {37,7,rr,S,V,0},	/* eq.w */
  {37,8,rr,S,V,0},	/* eq.l */
  {40,5,rr,V,V,0},	/* le.b */
  {40,6,rr,V,V,0},	/* le.h */
  {40,7,rr,V,V,0},	/* le.w */
  {40,8,rr,V,V,0},	/* le.l */
  {40,5,rr,S,V,0},	/* le.b */
  {40,6,rr,S,V,0},	/* le.h */
  {40,7,rr,S,V,0},	/* le.w */
  {40,8,rr,S,V,0},	/* le.l */
  {41,5,rr,V,V,0},	/* lt.b */
  {41,6,rr,V,V,0},	/* lt.h */
  {41,7,rr,V,V,0},	/* lt.w */
  {41,8,rr,V,V,0},	/* lt.l */
  {41,5,rr,S,V,0},	/* lt.b */
  {41,6,rr,S,V,0},	/* lt.h */
  {41,7,rr,S,V,0},	/* lt.w */
  {41,8,rr,S,V,0},	/* lt.l */
  {43,5,rr,V,V,0},	/* neg.b */
  {43,6,rr,V,V,0},	/* neg.h */
  {43,7,rr,V,V,0},	/* neg.w */
  {43,8,rr,V,V,0},	/* neg.l */
  {43,5,rr,S,S,0},	/* neg.b */
  {43,6,rr,S,S,0},	/* neg.h */
  {43,7,rr,S,S,0},	/* neg.w */
  {43,8,rr,S,S,0},	/* neg.l */
};

const struct formstr format4[] = {
  {46,0,nops,0,0,0},	/* nop */
  {47,0,pcrel,0,0,0},	/* br */
  {48,2,pcrel,0,0,0},	/* bri.f */
  {48,1,pcrel,0,0,0},	/* bri.t */
  {49,2,pcrel,0,0,0},	/* bra.f */
  {49,1,pcrel,0,0,0},	/* bra.t */
  {50,2,pcrel,0,0,0},	/* brs.f */
  {50,1,pcrel,0,0,0},	/* brs.t */
};

const struct formstr format5[] = {
  {51,5,rr,V,V,0},	/* ldvi.b */
  {51,6,rr,V,V,0},	/* ldvi.h */
  {51,7,rr,V,V,0},	/* ldvi.w */
  {51,8,rr,V,V,0},	/* ldvi.l */
  {28,3,rr,V,V,0},	/* cvtw.s */
  {31,7,rr,V,V,0},	/* cvts.w */
  {28,8,rr,V,V,0},	/* cvtw.l */
  {33,7,rr,V,V,0},	/* cvtl.w */
  {52,5,rxr,V,V,0},	/* stvi.b */
  {52,6,rxr,V,V,0},	/* stvi.h */
  {52,7,rxr,V,V,0},	/* stvi.w */
  {52,8,rxr,V,V,0},	/* stvi.l */
  {52,5,rxr,S,V,0},	/* stvi.b */
  {52,6,rxr,S,V,0},	/* stvi.h */
  {52,7,rxr,S,V,0},	/* stvi.w */
  {52,8,rxr,S,V,0},	/* stvi.l */
};

const struct formstr format6[] = {
  {53,0,r,A,0,0},	/* ldsdr */
  {54,0,r,A,0,0},	/* ldkdr */
  {55,3,r,S,0,0},	/* ln.s */
  {55,4,r,S,0,0},	/* ln.d */
  {56,0,nops,0,0,0},	/* patu */
  {57,0,r,A,0,0},	/* pate */
  {58,0,nops,0,0,0},	/* pich */
  {59,0,nops,0,0,0},	/* plch */
  {0,0,lr,PSW,A,0},	/* mov */
  {0,0,rxl,A,PSW,0},	/* mov */
  {0,0,lr,PC,A,0},	/* mov */
  {60,0,r,S,0,0},	/* idle */
  {0,0,lr,ITR,S,0},	/* mov */
  {0,0,rxl,S,ITR,0},	/* mov */
  {0,0,0,0,0,0},
  {0,0,rxl,S,ITSR,0},	/* mov */
  {61,0,nops,0,0,0},	/* rtnq */
  {62,0,nops,0,0,0},	/* cfork */
  {63,0,nops,0,0,0},	/* rtn */
  {64,0,nops,0,0,0},	/* wfork */
  {65,0,nops,0,0,0},	/* join */
  {66,0,nops,0,0,0},	/* rtnc */
  {67,3,r,S,0,0},	/* exp.s */
  {67,4,r,S,0,0},	/* exp.d */
  {68,3,r,S,0,0},	/* sin.s */
  {68,4,r,S,0,0},	/* sin.d */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {69,3,r,S,0,0},	/* cos.s */
  {69,4,r,S,0,0},	/* cos.d */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {70,7,r,A,0,0},	/* psh.w */
  {0,0,0,0,0,0},
  {71,7,r,A,0,0},	/* pop.w */
  {0,0,0,0,0,0},
  {70,7,r,S,0,0},	/* psh.w */
  {70,8,r,S,0,0},	/* psh.l */
  {71,7,r,S,0,0},	/* pop.w */
  {71,8,r,S,0,0},	/* pop.l */
  {72,0,nops,0,0,0},	/* eni */
  {73,0,nops,0,0,0},	/* dsi */
  {74,0,nops,0,0,0},	/* bkpt */
  {75,0,nops,0,0,0},	/* msync */
  {76,0,r,S,0,0},	/* mski */
  {77,0,r,S,0,0},	/* xmti */
  {0,0,rxl,S,VV,0},	/* mov */
  {78,0,nops,0,0,0},	/* tstvv */
  {0,0,lr,VS,A,0},	/* mov */
  {0,0,rxl,A,VS,0},	/* mov */
  {0,0,lr,VL,A,0},	/* mov */
  {0,0,rxl,A,VL,0},	/* mov */
  {0,7,lr,VS,S,0},	/* mov.w */
  {0,7,rxl,S,VS,0},	/* mov.w */
  {0,7,lr,VL,S,0},	/* mov.w */
  {0,7,rxl,S,VL,0},	/* mov.w */
  {79,0,r,A,0,0},	/* diag */
  {80,0,nops,0,0,0},	/* pbkpt */
  {81,3,r,S,0,0},	/* sqrt.s */
  {81,4,r,S,0,0},	/* sqrt.d */
  {82,0,nops,0,0,0},	/* casr */
  {0,0,0,0,0,0},
  {83,3,r,S,0,0},	/* atan.s */
  {83,4,r,S,0,0},	/* atan.d */
};

const struct formstr format7[] = {
  {84,5,r,V,0,0},	/* sum.b */
  {84,6,r,V,0,0},	/* sum.h */
  {84,7,r,V,0,0},	/* sum.w */
  {84,8,r,V,0,0},	/* sum.l */
  {85,0,r,V,0,0},	/* all */
  {86,0,r,V,0,0},	/* any */
  {87,0,r,V,0,0},	/* parity */
  {0,0,0,0,0,0},
  {88,5,r,V,0,0},	/* max.b */
  {88,6,r,V,0,0},	/* max.h */
  {88,7,r,V,0,0},	/* max.w */
  {88,8,r,V,0,0},	/* max.l */
  {89,5,r,V,0,0},	/* min.b */
  {89,6,r,V,0,0},	/* min.h */
  {89,7,r,V,0,0},	/* min.w */
  {89,8,r,V,0,0},	/* min.l */
  {84,3,r,V,0,0},	/* sum.s */
  {84,4,r,V,0,0},	/* sum.d */
  {90,3,r,V,0,0},	/* prod.s */
  {90,4,r,V,0,0},	/* prod.d */
  {88,3,r,V,0,0},	/* max.s */
  {88,4,r,V,0,0},	/* max.d */
  {89,3,r,V,0,0},	/* min.s */
  {89,4,r,V,0,0},	/* min.d */
  {90,5,r,V,0,0},	/* prod.b */
  {90,6,r,V,0,0},	/* prod.h */
  {90,7,r,V,0,0},	/* prod.w */
  {90,8,r,V,0,0},	/* prod.l */
  {35,2,lr,VM,S,0},	/* plc.f */
  {35,1,lr,VM,S,0},	/* plc.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr formatx[] = {
  {0,0,0,0,0,0},
};

const struct formstr format1a[] = {
  {91,0,imr,A,0,0},	/* halt */
  {92,0,a4,0,0,0},	/* sysc */
  {18,6,imr,A,0,0},	/* ld.h */
  {18,7,imr,A,0,0},	/* ld.w */
  {5,0,imr,A,0,0},	/* and */
  {6,0,imr,A,0,0},	/* or */
  {7,0,imr,A,0,0},	/* xor */
  {8,0,imr,A,0,0},	/* shf */
  {9,6,imr,A,0,0},	/* add.h */
  {9,7,imr,A,0,0},	/* add.w */
  {10,6,imr,A,0,0},	/* sub.h */
  {10,7,imr,A,0,0},	/* sub.w */
  {3,6,imr,A,0,0},	/* mul.h */
  {3,7,imr,A,0,0},	/* mul.w */
  {4,6,imr,A,0,0},	/* div.h */
  {4,7,imr,A,0,0},	/* div.w */
  {18,7,iml,VL,0,0},	/* ld.w */
  {18,7,iml,VS,0,0},	/* ld.w */
  {0,0,0,0,0,0},
  {8,7,imr,S,0,0},	/* shf.w */
  {93,0,a5,0,0,0},	/* trap */
  {0,0,0,0,0,0},
  {37,6,imr,A,0,0},	/* eq.h */
  {37,7,imr,A,0,0},	/* eq.w */
  {38,6,imr,A,0,0},	/* leu.h */
  {38,7,imr,A,0,0},	/* leu.w */
  {39,6,imr,A,0,0},	/* ltu.h */
  {39,7,imr,A,0,0},	/* ltu.w */
  {40,6,imr,A,0,0},	/* le.h */
  {40,7,imr,A,0,0},	/* le.w */
  {41,6,imr,A,0,0},	/* lt.h */
  {41,7,imr,A,0,0},	/* lt.w */
};

const struct formstr format1b[] = {
  {18,4,imr,S,0,0},	/* ld.d */
  {18,10,imr,S,0,0},	/* ld.u */
  {18,8,imr,S,0,0},	/* ld.l */
  {18,7,imr,S,0,0},	/* ld.w */
  {5,0,imr,S,0,0},	/* and */
  {6,0,imr,S,0,0},	/* or */
  {7,0,imr,S,0,0},	/* xor */
  {8,0,imr,S,0,0},	/* shf */
  {9,6,imr,S,0,0},	/* add.h */
  {9,7,imr,S,0,0},	/* add.w */
  {10,6,imr,S,0,0},	/* sub.h */
  {10,7,imr,S,0,0},	/* sub.w */
  {3,6,imr,S,0,0},	/* mul.h */
  {3,7,imr,S,0,0},	/* mul.w */
  {4,6,imr,S,0,0},	/* div.h */
  {4,7,imr,S,0,0},	/* div.w */
  {9,3,imr,S,0,0},	/* add.s */
  {10,3,imr,S,0,0},	/* sub.s */
  {3,3,imr,S,0,0},	/* mul.s */
  {4,3,imr,S,0,0},	/* div.s */
  {40,3,imr,S,0,0},	/* le.s */
  {41,3,imr,S,0,0},	/* lt.s */
  {37,6,imr,S,0,0},	/* eq.h */
  {37,7,imr,S,0,0},	/* eq.w */
  {38,6,imr,S,0,0},	/* leu.h */
  {38,7,imr,S,0,0},	/* leu.w */
  {39,6,imr,S,0,0},	/* ltu.h */
  {39,7,imr,S,0,0},	/* ltu.w */
  {40,6,imr,S,0,0},	/* le.h */
  {40,7,imr,S,0,0},	/* le.w */
  {41,6,imr,S,0,0},	/* lt.h */
  {41,7,imr,S,0,0},	/* lt.w */
};

const struct formstr e0_format0[] = {
  {10,3,rrr,S,V,V},	/* sub.s */
  {10,4,rrr,S,V,V},	/* sub.d */
  {4,3,rrr,S,V,V},	/* div.s */
  {4,4,rrr,S,V,V},	/* div.d */
  {10,11,rrr,S,V,V},	/* sub.s.f */
  {10,12,rrr,S,V,V},	/* sub.d.f */
  {4,11,rrr,S,V,V},	/* div.s.f */
  {4,12,rrr,S,V,V},	/* div.d.f */
  {3,11,rrr,V,V,V},	/* mul.s.f */
  {3,12,rrr,V,V,V},	/* mul.d.f */
  {4,11,rrr,V,V,V},	/* div.s.f */
  {4,12,rrr,V,V,V},	/* div.d.f */
  {3,11,rrr,V,S,V},	/* mul.s.f */
  {3,12,rrr,V,S,V},	/* mul.d.f */
  {4,11,rrr,V,S,V},	/* div.s.f */
  {4,12,rrr,V,S,V},	/* div.d.f */
  {5,2,rrr,V,V,V},	/* and.f */
  {6,2,rrr,V,V,V},	/* or.f */
  {7,2,rrr,V,V,V},	/* xor.f */
  {8,2,rrr,V,V,V},	/* shf.f */
  {5,2,rrr,V,S,V},	/* and.f */
  {6,2,rrr,V,S,V},	/* or.f */
  {7,2,rrr,V,S,V},	/* xor.f */
  {8,2,rrr,V,S,V},	/* shf.f */
  {9,11,rrr,V,V,V},	/* add.s.f */
  {9,12,rrr,V,V,V},	/* add.d.f */
  {10,11,rrr,V,V,V},	/* sub.s.f */
  {10,12,rrr,V,V,V},	/* sub.d.f */
  {9,11,rrr,V,S,V},	/* add.s.f */
  {9,12,rrr,V,S,V},	/* add.d.f */
  {10,11,rrr,V,S,V},	/* sub.s.f */
  {10,12,rrr,V,S,V},	/* sub.d.f */
  {9,13,rrr,V,V,V},	/* add.b.f */
  {9,14,rrr,V,V,V},	/* add.h.f */
  {9,15,rrr,V,V,V},	/* add.w.f */
  {9,16,rrr,V,V,V},	/* add.l.f */
  {9,13,rrr,V,S,V},	/* add.b.f */
  {9,14,rrr,V,S,V},	/* add.h.f */
  {9,15,rrr,V,S,V},	/* add.w.f */
  {9,16,rrr,V,S,V},	/* add.l.f */
  {10,13,rrr,V,V,V},	/* sub.b.f */
  {10,14,rrr,V,V,V},	/* sub.h.f */
  {10,15,rrr,V,V,V},	/* sub.w.f */
  {10,16,rrr,V,V,V},	/* sub.l.f */
  {10,13,rrr,V,S,V},	/* sub.b.f */
  {10,14,rrr,V,S,V},	/* sub.h.f */
  {10,15,rrr,V,S,V},	/* sub.w.f */
  {10,16,rrr,V,S,V},	/* sub.l.f */
  {3,13,rrr,V,V,V},	/* mul.b.f */
  {3,14,rrr,V,V,V},	/* mul.h.f */
  {3,15,rrr,V,V,V},	/* mul.w.f */
  {3,16,rrr,V,V,V},	/* mul.l.f */
  {3,13,rrr,V,S,V},	/* mul.b.f */
  {3,14,rrr,V,S,V},	/* mul.h.f */
  {3,15,rrr,V,S,V},	/* mul.w.f */
  {3,16,rrr,V,S,V},	/* mul.l.f */
  {4,13,rrr,V,V,V},	/* div.b.f */
  {4,14,rrr,V,V,V},	/* div.h.f */
  {4,15,rrr,V,V,V},	/* div.w.f */
  {4,16,rrr,V,V,V},	/* div.l.f */
  {4,13,rrr,V,S,V},	/* div.b.f */
  {4,14,rrr,V,S,V},	/* div.h.f */
  {4,15,rrr,V,S,V},	/* div.w.f */
  {4,16,rrr,V,S,V},	/* div.l.f */
};

const struct formstr e0_format1[] = {
  {0,0,0,0,0,0},
  {94,0,a3,0,0,0},	/* tst */
  {95,0,a3,0,0,0},	/* lck */
  {96,0,a3,0,0,0},	/* ulk */
  {17,0,a1r,S,0,0},	/* ldea */
  {97,0,a1r,A,0,0},	/* spawn */
  {98,0,a1r,A,0,0},	/* ldcmr */
  {99,0,a2r,A,0,0},	/* stcmr */
  {100,0,a1r,A,0,0},	/* popr */
  {101,0,a2r,A,0,0},	/* pshr */
  {102,7,a1r,A,0,0},	/* rcvr.w */
  {103,7,a2r,A,0,0},	/* matm.w */
  {104,7,a2r,A,0,0},	/* sndr.w */
  {104,8,a2r,S,0,0},	/* sndr.l */
  {102,8,a1r,S,0,0},	/* rcvr.l */
  {103,8,a2r,S,0,0},	/* matm.l */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {105,7,a2r,A,0,0},	/* putr.w */
  {105,8,a2r,S,0,0},	/* putr.l */
  {106,7,a1r,A,0,0},	/* getr.w */
  {106,8,a1r,S,0,0},	/* getr.l */
  {26,13,a2r,S,0,0},	/* ste.b.f */
  {26,14,a2r,S,0,0},	/* ste.h.f */
  {26,15,a2r,S,0,0},	/* ste.w.f */
  {26,16,a2r,S,0,0},	/* ste.l.f */
  {107,7,a2r,A,0,0},	/* matr.w */
  {108,7,a2r,A,0,0},	/* mat.w */
  {109,7,a1r,A,0,0},	/* get.w */
  {110,7,a1r,A,0,0},	/* rcv.w */
  {0,0,0,0,0,0},
  {111,7,a1r,A,0,0},	/* inc.w */
  {112,7,a2r,A,0,0},	/* put.w */
  {113,7,a2r,A,0,0},	/* snd.w */
  {107,8,a2r,S,0,0},	/* matr.l */
  {108,8,a2r,S,0,0},	/* mat.l */
  {109,8,a1r,S,0,0},	/* get.l */
  {110,8,a1r,S,0,0},	/* rcv.l */
  {0,0,0,0,0,0},
  {111,8,a1r,S,0,0},	/* inc.l */
  {112,8,a2r,S,0,0},	/* put.l */
  {113,8,a2r,S,0,0},	/* snd.l */
  {18,13,a1r,V,0,0},	/* ld.b.f */
  {18,14,a1r,V,0,0},	/* ld.h.f */
  {18,15,a1r,V,0,0},	/* ld.w.f */
  {18,16,a1r,V,0,0},	/* ld.l.f */
  {21,13,a2r,V,0,0},	/* st.b.f */
  {21,14,a2r,V,0,0},	/* st.h.f */
  {21,15,a2r,V,0,0},	/* st.w.f */
  {21,16,a2r,V,0,0},	/* st.l.f */
};

const struct formstr e0_format2[] = {
  {28,5,rr,V,V,0},	/* cvtw.b */
  {28,6,rr,V,V,0},	/* cvtw.h */
  {29,7,rr,V,V,0},	/* cvtb.w */
  {30,7,rr,V,V,0},	/* cvth.w */
  {28,13,rr,V,V,0},	/* cvtw.b.f */
  {28,14,rr,V,V,0},	/* cvtw.h.f */
  {29,15,rr,V,V,0},	/* cvtb.w.f */
  {30,15,rr,V,V,0},	/* cvth.w.f */
  {31,8,rr,V,V,0},	/* cvts.l */
  {32,7,rr,V,V,0},	/* cvtd.w */
  {33,3,rr,V,V,0},	/* cvtl.s */
  {28,4,rr,V,V,0},	/* cvtw.d */
  {31,16,rr,V,V,0},	/* cvts.l.f */
  {32,15,rr,V,V,0},	/* cvtd.w.f */
  {33,11,rr,V,V,0},	/* cvtl.s.f */
  {28,12,rr,V,V,0},	/* cvtw.d.f */
  {114,0,rr,S,S,0},	/* enal */
  {8,7,rr,S,S,0},	/* shf.w */
  {115,0,rr,S,S,0},	/* enag */
  {0,0,0,0,0,0},
  {28,4,rr,S,S,0},	/* cvtw.d */
  {32,7,rr,S,S,0},	/* cvtd.w */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {116,3,rr,S,S,0},	/* frint.s */
  {116,4,rr,S,S,0},	/* frint.d */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {116,3,rr,V,V,0},	/* frint.s */
  {116,4,rr,V,V,0},	/* frint.d */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {116,11,rr,V,V,0},	/* frint.s.f */
  {116,12,rr,V,V,0},	/* frint.d.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {81,3,rr,V,V,0},	/* sqrt.s */
  {81,4,rr,V,V,0},	/* sqrt.d */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {81,11,rr,V,V,0},	/* sqrt.s.f */
  {81,12,rr,V,V,0},	/* sqrt.d.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e0_format3[] = {
  {32,11,rr,V,V,0},	/* cvtd.s.f */
  {31,12,rr,V,V,0},	/* cvts.d.f */
  {33,12,rr,V,V,0},	/* cvtl.d.f */
  {32,16,rr,V,V,0},	/* cvtd.l.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {36,2,rr,V,V,0},	/* tzc.f */
  {44,2,rr,V,V,0},	/* lop.f */
  {117,2,rr,V,V,0},	/* xpnd.f */
  {42,2,rr,V,V,0},	/* not.f */
  {8,2,rr,S,V,0},	/* shf.f */
  {35,17,rr,V,V,0},	/* plc.t.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {37,11,rr,V,V,0},	/* eq.s.f */
  {37,12,rr,V,V,0},	/* eq.d.f */
  {43,11,rr,V,V,0},	/* neg.s.f */
  {43,12,rr,V,V,0},	/* neg.d.f */
  {37,11,rr,S,V,0},	/* eq.s.f */
  {37,12,rr,S,V,0},	/* eq.d.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {40,11,rr,V,V,0},	/* le.s.f */
  {40,12,rr,V,V,0},	/* le.d.f */
  {41,11,rr,V,V,0},	/* lt.s.f */
  {41,12,rr,V,V,0},	/* lt.d.f */
  {40,11,rr,S,V,0},	/* le.s.f */
  {40,12,rr,S,V,0},	/* le.d.f */
  {41,11,rr,S,V,0},	/* lt.s.f */
  {41,12,rr,S,V,0},	/* lt.d.f */
  {37,13,rr,V,V,0},	/* eq.b.f */
  {37,14,rr,V,V,0},	/* eq.h.f */
  {37,15,rr,V,V,0},	/* eq.w.f */
  {37,16,rr,V,V,0},	/* eq.l.f */
  {37,13,rr,S,V,0},	/* eq.b.f */
  {37,14,rr,S,V,0},	/* eq.h.f */
  {37,15,rr,S,V,0},	/* eq.w.f */
  {37,16,rr,S,V,0},	/* eq.l.f */
  {40,13,rr,V,V,0},	/* le.b.f */
  {40,14,rr,V,V,0},	/* le.h.f */
  {40,15,rr,V,V,0},	/* le.w.f */
  {40,16,rr,V,V,0},	/* le.l.f */
  {40,13,rr,S,V,0},	/* le.b.f */
  {40,14,rr,S,V,0},	/* le.h.f */
  {40,15,rr,S,V,0},	/* le.w.f */
  {40,16,rr,S,V,0},	/* le.l.f */
  {41,13,rr,V,V,0},	/* lt.b.f */
  {41,14,rr,V,V,0},	/* lt.h.f */
  {41,15,rr,V,V,0},	/* lt.w.f */
  {41,16,rr,V,V,0},	/* lt.l.f */
  {41,13,rr,S,V,0},	/* lt.b.f */
  {41,14,rr,S,V,0},	/* lt.h.f */
  {41,15,rr,S,V,0},	/* lt.w.f */
  {41,16,rr,S,V,0},	/* lt.l.f */
  {43,13,rr,V,V,0},	/* neg.b.f */
  {43,14,rr,V,V,0},	/* neg.h.f */
  {43,15,rr,V,V,0},	/* neg.w.f */
  {43,16,rr,V,V,0},	/* neg.l.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e0_format4[] = {
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e0_format5[] = {
  {51,13,rr,V,V,0},	/* ldvi.b.f */
  {51,14,rr,V,V,0},	/* ldvi.h.f */
  {51,15,rr,V,V,0},	/* ldvi.w.f */
  {51,16,rr,V,V,0},	/* ldvi.l.f */
  {28,11,rr,V,V,0},	/* cvtw.s.f */
  {31,15,rr,V,V,0},	/* cvts.w.f */
  {28,16,rr,V,V,0},	/* cvtw.l.f */
  {33,15,rr,V,V,0},	/* cvtl.w.f */
  {52,13,rxr,V,V,0},	/* stvi.b.f */
  {52,14,rxr,V,V,0},	/* stvi.h.f */
  {52,15,rxr,V,V,0},	/* stvi.w.f */
  {52,16,rxr,V,V,0},	/* stvi.l.f */
  {52,13,rxr,S,V,0},	/* stvi.b.f */
  {52,14,rxr,S,V,0},	/* stvi.h.f */
  {52,15,rxr,S,V,0},	/* stvi.w.f */
  {52,16,rxr,S,V,0},	/* stvi.l.f */
};

const struct formstr e0_format6[] = {
  {0,0,rxl,S,CIR,0},	/* mov */
  {0,0,lr,CIR,S,0},	/* mov */
  {0,0,lr,TOC,S,0},	/* mov */
  {0,0,lr,CPUID,S,0},	/* mov */
  {0,0,rxl,S,TTR,0},	/* mov */
  {0,0,lr,TTR,S,0},	/* mov */
  {118,0,nops,0,0,0},	/* ctrsl */
  {119,0,nops,0,0,0},	/* ctrsg */
  {0,0,rxl,S,VMU,0},	/* mov */
  {0,0,lr,VMU,S,0},	/* mov */
  {0,0,rxl,S,VML,0},	/* mov */
  {0,0,lr,VML,S,0},	/* mov */
  {0,0,rxl,S,ICR,0},	/* mov */
  {0,0,lr,ICR,S,0},	/* mov */
  {0,0,rxl,S,TCPU,0},	/* mov */
  {0,0,lr,TCPU,S,0},	/* mov */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {120,0,nops,0,0,0},	/* stop */
  {0,0,0,0,0,0},
  {0,0,rxl,S,TID,0},	/* mov */
  {0,0,lr,TID,S,0},	/* mov */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e0_format7[] = {
  {84,13,r,V,0,0},	/* sum.b.f */
  {84,14,r,V,0,0},	/* sum.h.f */
  {84,15,r,V,0,0},	/* sum.w.f */
  {84,16,r,V,0,0},	/* sum.l.f */
  {85,2,r,V,0,0},	/* all.f */
  {86,2,r,V,0,0},	/* any.f */
  {87,2,r,V,0,0},	/* parity.f */
  {0,0,0,0,0,0},
  {88,13,r,V,0,0},	/* max.b.f */
  {88,14,r,V,0,0},	/* max.h.f */
  {88,15,r,V,0,0},	/* max.w.f */
  {88,16,r,V,0,0},	/* max.l.f */
  {89,13,r,V,0,0},	/* min.b.f */
  {89,14,r,V,0,0},	/* min.h.f */
  {89,15,r,V,0,0},	/* min.w.f */
  {89,16,r,V,0,0},	/* min.l.f */
  {84,11,r,V,0,0},	/* sum.s.f */
  {84,12,r,V,0,0},	/* sum.d.f */
  {90,11,r,V,0,0},	/* prod.s.f */
  {90,12,r,V,0,0},	/* prod.d.f */
  {88,11,r,V,0,0},	/* max.s.f */
  {88,12,r,V,0,0},	/* max.d.f */
  {89,11,r,V,0,0},	/* min.s.f */
  {89,12,r,V,0,0},	/* min.d.f */
  {90,13,r,V,0,0},	/* prod.b.f */
  {90,14,r,V,0,0},	/* prod.h.f */
  {90,15,r,V,0,0},	/* prod.w.f */
  {90,16,r,V,0,0},	/* prod.l.f */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e1_format0[] = {
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {10,18,rrr,S,V,V},	/* sub.s.t */
  {10,19,rrr,S,V,V},	/* sub.d.t */
  {4,18,rrr,S,V,V},	/* div.s.t */
  {4,19,rrr,S,V,V},	/* div.d.t */
  {3,18,rrr,V,V,V},	/* mul.s.t */
  {3,19,rrr,V,V,V},	/* mul.d.t */
  {4,18,rrr,V,V,V},	/* div.s.t */
  {4,19,rrr,V,V,V},	/* div.d.t */
  {3,18,rrr,V,S,V},	/* mul.s.t */
  {3,19,rrr,V,S,V},	/* mul.d.t */
  {4,18,rrr,V,S,V},	/* div.s.t */
  {4,19,rrr,V,S,V},	/* div.d.t */
  {5,1,rrr,V,V,V},	/* and.t */
  {6,1,rrr,V,V,V},	/* or.t */
  {7,1,rrr,V,V,V},	/* xor.t */
  {8,1,rrr,V,V,V},	/* shf.t */
  {5,1,rrr,V,S,V},	/* and.t */
  {6,1,rrr,V,S,V},	/* or.t */
  {7,1,rrr,V,S,V},	/* xor.t */
  {8,1,rrr,V,S,V},	/* shf.t */
  {9,18,rrr,V,V,V},	/* add.s.t */
  {9,19,rrr,V,V,V},	/* add.d.t */
  {10,18,rrr,V,V,V},	/* sub.s.t */
  {10,19,rrr,V,V,V},	/* sub.d.t */
  {9,18,rrr,V,S,V},	/* add.s.t */
  {9,19,rrr,V,S,V},	/* add.d.t */
  {10,18,rrr,V,S,V},	/* sub.s.t */
  {10,19,rrr,V,S,V},	/* sub.d.t */
  {9,20,rrr,V,V,V},	/* add.b.t */
  {9,21,rrr,V,V,V},	/* add.h.t */
  {9,22,rrr,V,V,V},	/* add.w.t */
  {9,23,rrr,V,V,V},	/* add.l.t */
  {9,20,rrr,V,S,V},	/* add.b.t */
  {9,21,rrr,V,S,V},	/* add.h.t */
  {9,22,rrr,V,S,V},	/* add.w.t */
  {9,23,rrr,V,S,V},	/* add.l.t */
  {10,20,rrr,V,V,V},	/* sub.b.t */
  {10,21,rrr,V,V,V},	/* sub.h.t */
  {10,22,rrr,V,V,V},	/* sub.w.t */
  {10,23,rrr,V,V,V},	/* sub.l.t */
  {10,20,rrr,V,S,V},	/* sub.b.t */
  {10,21,rrr,V,S,V},	/* sub.h.t */
  {10,22,rrr,V,S,V},	/* sub.w.t */
  {10,23,rrr,V,S,V},	/* sub.l.t */
  {3,20,rrr,V,V,V},	/* mul.b.t */
  {3,21,rrr,V,V,V},	/* mul.h.t */
  {3,22,rrr,V,V,V},	/* mul.w.t */
  {3,23,rrr,V,V,V},	/* mul.l.t */
  {3,20,rrr,V,S,V},	/* mul.b.t */
  {3,21,rrr,V,S,V},	/* mul.h.t */
  {3,22,rrr,V,S,V},	/* mul.w.t */
  {3,23,rrr,V,S,V},	/* mul.l.t */
  {4,20,rrr,V,V,V},	/* div.b.t */
  {4,21,rrr,V,V,V},	/* div.h.t */
  {4,22,rrr,V,V,V},	/* div.w.t */
  {4,23,rrr,V,V,V},	/* div.l.t */
  {4,20,rrr,V,S,V},	/* div.b.t */
  {4,21,rrr,V,S,V},	/* div.h.t */
  {4,22,rrr,V,S,V},	/* div.w.t */
  {4,23,rrr,V,S,V},	/* div.l.t */
};

const struct formstr e1_format1[] = {
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {26,20,a2r,S,0,0},	/* ste.b.t */
  {26,21,a2r,S,0,0},	/* ste.h.t */
  {26,22,a2r,S,0,0},	/* ste.w.t */
  {26,23,a2r,S,0,0},	/* ste.l.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {18,20,a1r,V,0,0},	/* ld.b.t */
  {18,21,a1r,V,0,0},	/* ld.h.t */
  {18,22,a1r,V,0,0},	/* ld.w.t */
  {18,23,a1r,V,0,0},	/* ld.l.t */
  {21,20,a2r,V,0,0},	/* st.b.t */
  {21,21,a2r,V,0,0},	/* st.h.t */
  {21,22,a2r,V,0,0},	/* st.w.t */
  {21,23,a2r,V,0,0},	/* st.l.t */
};

const struct formstr e1_format2[] = {
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {28,20,rr,V,V,0},	/* cvtw.b.t */
  {28,21,rr,V,V,0},	/* cvtw.h.t */
  {29,22,rr,V,V,0},	/* cvtb.w.t */
  {30,22,rr,V,V,0},	/* cvth.w.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {31,23,rr,V,V,0},	/* cvts.l.t */
  {32,22,rr,V,V,0},	/* cvtd.w.t */
  {33,18,rr,V,V,0},	/* cvtl.s.t */
  {28,19,rr,V,V,0},	/* cvtw.d.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {116,18,rr,V,V,0},	/* frint.s.t */
  {116,19,rr,V,V,0},	/* frint.d.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {81,18,rr,V,V,0},	/* sqrt.s.t */
  {81,19,rr,V,V,0},	/* sqrt.d.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e1_format3[] = {
  {32,18,rr,V,V,0},	/* cvtd.s.t */
  {31,19,rr,V,V,0},	/* cvts.d.t */
  {33,19,rr,V,V,0},	/* cvtl.d.t */
  {32,23,rr,V,V,0},	/* cvtd.l.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {36,1,rr,V,V,0},	/* tzc.t */
  {44,1,rr,V,V,0},	/* lop.t */
  {117,1,rr,V,V,0},	/* xpnd.t */
  {42,1,rr,V,V,0},	/* not.t */
  {8,1,rr,S,V,0},	/* shf.t */
  {35,24,rr,V,V,0},	/* plc.t.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {37,18,rr,V,V,0},	/* eq.s.t */
  {37,19,rr,V,V,0},	/* eq.d.t */
  {43,18,rr,V,V,0},	/* neg.s.t */
  {43,19,rr,V,V,0},	/* neg.d.t */
  {37,18,rr,S,V,0},	/* eq.s.t */
  {37,19,rr,S,V,0},	/* eq.d.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {40,18,rr,V,V,0},	/* le.s.t */
  {40,19,rr,V,V,0},	/* le.d.t */
  {41,18,rr,V,V,0},	/* lt.s.t */
  {41,19,rr,V,V,0},	/* lt.d.t */
  {40,18,rr,S,V,0},	/* le.s.t */
  {40,19,rr,S,V,0},	/* le.d.t */
  {41,18,rr,S,V,0},	/* lt.s.t */
  {41,19,rr,S,V,0},	/* lt.d.t */
  {37,20,rr,V,V,0},	/* eq.b.t */
  {37,21,rr,V,V,0},	/* eq.h.t */
  {37,22,rr,V,V,0},	/* eq.w.t */
  {37,23,rr,V,V,0},	/* eq.l.t */
  {37,20,rr,S,V,0},	/* eq.b.t */
  {37,21,rr,S,V,0},	/* eq.h.t */
  {37,22,rr,S,V,0},	/* eq.w.t */
  {37,23,rr,S,V,0},	/* eq.l.t */
  {40,20,rr,V,V,0},	/* le.b.t */
  {40,21,rr,V,V,0},	/* le.h.t */
  {40,22,rr,V,V,0},	/* le.w.t */
  {40,23,rr,V,V,0},	/* le.l.t */
  {40,20,rr,S,V,0},	/* le.b.t */
  {40,21,rr,S,V,0},	/* le.h.t */
  {40,22,rr,S,V,0},	/* le.w.t */
  {40,23,rr,S,V,0},	/* le.l.t */
  {41,20,rr,V,V,0},	/* lt.b.t */
  {41,21,rr,V,V,0},	/* lt.h.t */
  {41,22,rr,V,V,0},	/* lt.w.t */
  {41,23,rr,V,V,0},	/* lt.l.t */
  {41,20,rr,S,V,0},	/* lt.b.t */
  {41,21,rr,S,V,0},	/* lt.h.t */
  {41,22,rr,S,V,0},	/* lt.w.t */
  {41,23,rr,S,V,0},	/* lt.l.t */
  {43,20,rr,V,V,0},	/* neg.b.t */
  {43,21,rr,V,V,0},	/* neg.h.t */
  {43,22,rr,V,V,0},	/* neg.w.t */
  {43,23,rr,V,V,0},	/* neg.l.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e1_format4[] = {
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e1_format5[] = {
  {51,20,rr,V,V,0},	/* ldvi.b.t */
  {51,21,rr,V,V,0},	/* ldvi.h.t */
  {51,22,rr,V,V,0},	/* ldvi.w.t */
  {51,23,rr,V,V,0},	/* ldvi.l.t */
  {28,18,rr,V,V,0},	/* cvtw.s.t */
  {31,22,rr,V,V,0},	/* cvts.w.t */
  {28,23,rr,V,V,0},	/* cvtw.l.t */
  {33,22,rr,V,V,0},	/* cvtl.w.t */
  {52,20,rxr,V,V,0},	/* stvi.b.t */
  {52,21,rxr,V,V,0},	/* stvi.h.t */
  {52,22,rxr,V,V,0},	/* stvi.w.t */
  {52,23,rxr,V,V,0},	/* stvi.l.t */
  {52,20,rxr,S,V,0},	/* stvi.b.t */
  {52,21,rxr,S,V,0},	/* stvi.h.t */
  {52,22,rxr,S,V,0},	/* stvi.w.t */
  {52,23,rxr,S,V,0},	/* stvi.l.t */
};

const struct formstr e1_format6[] = {
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

const struct formstr e1_format7[] = {
  {84,20,r,V,0,0},	/* sum.b.t */
  {84,21,r,V,0,0},	/* sum.h.t */
  {84,22,r,V,0,0},	/* sum.w.t */
  {84,23,r,V,0,0},	/* sum.l.t */
  {85,1,r,V,0,0},	/* all.t */
  {86,1,r,V,0,0},	/* any.t */
  {87,1,r,V,0,0},	/* parity.t */
  {0,0,0,0,0,0},
  {88,20,r,V,0,0},	/* max.b.t */
  {88,21,r,V,0,0},	/* max.h.t */
  {88,22,r,V,0,0},	/* max.w.t */
  {88,23,r,V,0,0},	/* max.l.t */
  {89,20,r,V,0,0},	/* min.b.t */
  {89,21,r,V,0,0},	/* min.h.t */
  {89,22,r,V,0,0},	/* min.w.t */
  {89,23,r,V,0,0},	/* min.l.t */
  {84,18,r,V,0,0},	/* sum.s.t */
  {84,19,r,V,0,0},	/* sum.d.t */
  {90,18,r,V,0,0},	/* prod.s.t */
  {90,19,r,V,0,0},	/* prod.d.t */
  {88,18,r,V,0,0},	/* max.s.t */
  {88,19,r,V,0,0},	/* max.d.t */
  {89,18,r,V,0,0},	/* min.s.t */
  {89,19,r,V,0,0},	/* min.d.t */
  {90,20,r,V,0,0},	/* prod.b.t */
  {90,21,r,V,0,0},	/* prod.h.t */
  {90,22,r,V,0,0},	/* prod.w.t */
  {90,23,r,V,0,0},	/* prod.l.t */
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
  {0,0,0,0,0,0},
};

char *lop[] = {
  "mov",	/* 0 */
  "merg",	/* 1 */
  "mask",	/* 2 */
  "mul",	/* 3 */
  "div",	/* 4 */
  "and",	/* 5 */
  "or",	/* 6 */
  "xor",	/* 7 */
  "shf",	/* 8 */
  "add",	/* 9 */
  "sub",	/* 10 */
  "exit",	/* 11 */
  "jmp",	/* 12 */
  "jmpi",	/* 13 */
  "jmpa",	/* 14 */
  "jmps",	/* 15 */
  "tac",	/* 16 */
  "ldea",	/* 17 */
  "ld",	/* 18 */
  "tas",	/* 19 */
  "pshea",	/* 20 */
  "st",	/* 21 */
  "call",	/* 22 */
  "calls",	/* 23 */
  "callq",	/* 24 */
  "pfork",	/* 25 */
  "ste",	/* 26 */
  "incr",	/* 27 */
  "cvtw",	/* 28 */
  "cvtb",	/* 29 */
  "cvth",	/* 30 */
  "cvts",	/* 31 */
  "cvtd",	/* 32 */
  "cvtl",	/* 33 */
  "ldpa",	/* 34 */
  "plc",	/* 35 */
  "tzc",	/* 36 */
  "eq",	/* 37 */
  "leu",	/* 38 */
  "ltu",	/* 39 */
  "le",	/* 40 */
  "lt",	/* 41 */
  "not",	/* 42 */
  "neg",	/* 43 */
  "lop",	/* 44 */
  "cprs",	/* 45 */
  "nop",	/* 46 */
  "br",	/* 47 */
  "bri",	/* 48 */
  "bra",	/* 49 */
  "brs",	/* 50 */
  "ldvi",	/* 51 */
  "stvi",	/* 52 */
  "ldsdr",	/* 53 */
  "ldkdr",	/* 54 */
  "ln",	/* 55 */
  "patu",	/* 56 */
  "pate",	/* 57 */
  "pich",	/* 58 */
  "plch",	/* 59 */
  "idle",	/* 60 */
  "rtnq",	/* 61 */
  "cfork",	/* 62 */
  "rtn",	/* 63 */
  "wfork",	/* 64 */
  "join",	/* 65 */
  "rtnc",	/* 66 */
  "exp",	/* 67 */
  "sin",	/* 68 */
  "cos",	/* 69 */
  "psh",	/* 70 */
  "pop",	/* 71 */
  "eni",	/* 72 */
  "dsi",	/* 73 */
  "bkpt",	/* 74 */
  "msync",	/* 75 */
  "mski",	/* 76 */
  "xmti",	/* 77 */
  "tstvv",	/* 78 */
  "diag",	/* 79 */
  "pbkpt",	/* 80 */
  "sqrt",	/* 81 */
  "casr",	/* 82 */
  "atan",	/* 83 */
  "sum",	/* 84 */
  "all",	/* 85 */
  "any",	/* 86 */
  "parity",	/* 87 */
  "max",	/* 88 */
  "min",	/* 89 */
  "prod",	/* 90 */
  "halt",	/* 91 */
  "sysc",	/* 92 */
  "trap",	/* 93 */
  "tst",	/* 94 */
  "lck",	/* 95 */
  "ulk",	/* 96 */
  "spawn",	/* 97 */
  "ldcmr",	/* 98 */
  "stcmr",	/* 99 */
  "popr",	/* 100 */
  "pshr",	/* 101 */
  "rcvr",	/* 102 */
  "matm",	/* 103 */
  "sndr",	/* 104 */
  "putr",	/* 105 */
  "getr",	/* 106 */
  "matr",	/* 107 */
  "mat",	/* 108 */
  "get",	/* 109 */
  "rcv",	/* 110 */
  "inc",	/* 111 */
  "put",	/* 112 */
  "snd",	/* 113 */
  "enal",	/* 114 */
  "enag",	/* 115 */
  "frint",	/* 116 */
  "xpnd",	/* 117 */
  "ctrsl",	/* 118 */
  "ctrsg",	/* 119 */
  "stop",	/* 120 */
};

char *rop[] = {
  "",	/* 0 */
  ".t",	/* 1 */
  ".f",	/* 2 */
  ".s",	/* 3 */
  ".d",	/* 4 */
  ".b",	/* 5 */
  ".h",	/* 6 */
  ".w",	/* 7 */
  ".l",	/* 8 */
  ".x",	/* 9 */
  ".u",	/* 10 */
  ".s.f",	/* 11 */
  ".d.f",	/* 12 */
  ".b.f",	/* 13 */
  ".h.f",	/* 14 */
  ".w.f",	/* 15 */
  ".l.f",	/* 16 */
  ".t.f",	/* 17 */
  ".s.t",	/* 18 */
  ".d.t",	/* 19 */
  ".b.t",	/* 20 */
  ".h.t",	/* 21 */
  ".w.t",	/* 22 */
  ".l.t",	/* 23 */
  ".t.t",	/* 24 */
};
