/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;

public class RandomAccessFileReader
extends Reader {
    RandomAccessFile raf;
    InputStreamReader rd;

    public RandomAccessFileReader(RandomAccessFile randomAccess) {
        this.raf = randomAccess;
        this.createReader();
    }

    protected void createReader() {
        this.rd = new InputStreamReader(new InputStream(){

            @Override
            public int read() throws IOException {
                return RandomAccessFileReader.this.raf.read();
            }
        });
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
        this.createReader();
    }

    public long getPosition() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        this.rd.close();
        this.raf.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.rd.read(cbuf, off, len);
    }

    public long size() throws IOException {
        return this.raf.length();
    }
}

