#/usr/bin/env python
import mozdevice
import logging
import unittest
from sut import MockAgent


class TestApp(unittest.TestCase):

    def test_getAppRoot(self):
        command = [("getapproot org.gnu.icecat",
                    "/data/data/org.gnu.icecat")]

        m = MockAgent(self, commands=command)
        d = mozdevice.DroidSUT("127.0.0.1", port=m.port, logLevel=logging.DEBUG)

        self.assertEqual(command[0][1], d.getAppRoot('org.gnu.icecat'))

if __name__ == '__main__':
    unittest.main()
