/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.InputStreamHandler;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.ProcessMode;
import gnu.mapping.WrappedException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class InfProcessMode
extends ProcessMode {
    Process proc;
    InputStream out;
    InputStream err;
    OutputStream in;

    public InfProcessMode(Buffer buffer, String command) {
        this.buffer = buffer;
        this.processMark = new Marker(buffer.pointMarker);
        try {
            this.proc = Runtime.getRuntime().exec(command);
        }
        catch (Exception ex) {
            throw new WrappedException("cannot run " + command, ex);
        }
        this.in = this.proc.getOutputStream();
        this.out = this.proc.getInputStream();
        this.err = this.proc.getErrorStream();
        this.toInferior = new OutputStreamWriter(this.in);
        InputStreamHandler outThread = new InputStreamHandler(this.out, this);
        outThread.setPriority(Thread.currentThread().getPriority() + 1);
        outThread.start();
        InputStreamHandler errThread = new InputStreamHandler(this.err, this);
        errThread.setPriority(Thread.currentThread().getPriority() + 1);
        errThread.start();
    }

    public static void shellMode(Buffer buffer, String command) {
        buffer.modes = new InfProcessMode(buffer, command);
    }
}

