/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionsAttr
extends Attribute {
    ClassType[] exceptions;
    short[] exception_table;

    public ExceptionsAttr(Method method) {
        super("Exceptions");
        this.addToFrontOf(method);
    }

    public void setExceptions(short[] sArray, ClassType classType) {
        this.exception_table = sArray;
        this.exceptions = new ClassType[sArray.length];
        ConstantPool constantPool = classType.getConstants();
        int n = sArray.length - 1;
        while (n >= 0) {
            this.exceptions[n] = (ClassType)((CpoolClass)constantPool.getPoolEntry(sArray[n])).getClassType();
            --n;
        }
    }

    public void setExceptions(ClassType[] classTypeArray) {
        this.exceptions = classTypeArray;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        ConstantPool constantPool = classType.getConstants();
        int n = this.exceptions.length;
        this.exception_table = new short[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.exception_table[n2] = (short)constantPool.addClass((ObjectType)this.exceptions[n2]).index;
            --n2;
        }
    }

    public final int getLength() {
        return 2 + 2 * (this.exceptions == null ? 0 : this.exceptions.length);
    }

    public final ClassType[] getExceptions() {
        return this.exceptions;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.exceptions.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeShort(this.exception_table[n2]);
            ++n2;
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        int n = this.exceptions.length;
        classTypeWriter.println(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.exception_table[n2] & 0xFFFF;
            classTypeWriter.print("  ");
            classTypeWriter.printOptionalIndex(n3);
            classTypeWriter.printConstantTersely(n3, 7);
            classTypeWriter.println();
            ++n2;
        }
    }
}

