/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.lists.FString;
import gnu.mapping.InPort;
import gnu.mapping.Procedure2;
import gnu.mapping.WrongType;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kawa.lang.GenericError;

public class CompileFile
extends Procedure2 {
    public CompileFile() {
        super("compile-file");
    }

    public static final Compilation read(String string, SourceMessages sourceMessages) throws IOException, SyntaxException {
        try {
            InPort inPort = InPort.openFile(string);
            Compilation compilation = CompileFile.read(inPort, sourceMessages);
            inPort.close();
            return compilation;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenericError("compile-file: file not found: " + string);
        }
        catch (IOException iOException) {
            throw new GenericError(string.toString());
        }
    }

    public static final Compilation read(InPort inPort, SourceMessages sourceMessages) throws IOException, SyntaxException {
        return Interpreter.getInterpreter().parseFile(inPort, false, sourceMessages);
    }

    public final Object apply2(Object object2, Object object3) throws Throwable {
        if (!(object2 instanceof FString)) {
            throw new WrongType(this.getName(), 1, "file name");
        }
        SourceMessages sourceMessages = new SourceMessages();
        Compilation compilation = CompileFile.read(object2.toString(), sourceMessages);
        compilation.compileToArchive(compilation.getModule(), object3.toString());
        if (sourceMessages.seenErrors()) {
            throw new SyntaxException(sourceMessages);
        }
        return Interpreter.voidObject;
    }

    public static void compile_to_files(String string, String string2, String string3, String string4, SourceMessages sourceMessages) {
        Object object2;
        if (string4 == null) {
            object2 = new File(string);
            String string5 = ((File)object2).getName();
            int n = string5.lastIndexOf(46);
            if (n > 0) {
                string5 = string5.substring(0, n);
            }
            string4 = string5 = Compilation.mangleNameIfNeeded(string5);
            if (string3 != null) {
                string4 = string3 + string5;
            }
        }
        try {
            object2 = CompileFile.read(string, sourceMessages);
            if (sourceMessages.seenErrors()) {
                return;
            }
            try {
                ((Compilation)object2).compileToFiles(((Compilation)object2).getModule(), string4, string2, string3);
            }
            catch (Throwable throwable) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Internal error while compiling ");
                stringBuffer.append(string);
                int n = ((Compilation)object2).getLine();
                if (n > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(n);
                }
                System.err.println(stringBuffer);
                throwable.printStackTrace(System.err);
                System.exit(-1);
            }
            if (sourceMessages.seenErrors()) {
                return;
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new RuntimeException("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }
}

