/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.ExitExp;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.ThisExp;
import gnu.expr.TryExp;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;

public class ExpWalker
implements SourceLocator {
    protected SourceMessages messages;
    Compilation comp;
    protected LambdaExp currentLambda = null;
    Object exitValue = null;

    public Compilation getCompilation() {
        return this.comp;
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    protected Expression walkExpression(Expression exp) {
        exp.walkChildren(this);
        return exp;
    }

    public void setContext(Compilation comp) {
        this.comp = comp;
        this.messages = comp.getMessages();
    }

    public Expression walk(Expression exp) {
        int line = exp.getLineNumber();
        if (this.messages != null && line > 0) {
            String saveFile = this.messages.getFileName();
            int saveLine = this.messages.getLineNumber();
            int saveColumn = this.messages.getColumnNumber();
            this.messages.setLine(exp.getFileName(), line, exp.getColumnNumber());
            Expression ret = exp.walk(this);
            this.messages.setLine(saveFile, saveLine, saveColumn);
            return ret;
        }
        return exp.walk(this);
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkIfExp(IfExp exp) {
        return this.walkExpression(exp);
    }

    protected final void walkDeclarationType(Declaration decl) {
        Expression texp2;
        Expression texp1 = decl.getTypeExp();
        if (texp1 != null && (texp2 = texp1.walk(this)) != texp1) {
            decl.setTypeExp(texp2);
        }
    }

    protected final void walkDeclarationTypes(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            this.walkDeclarationType(decl);
        }
    }

    protected Expression walkScopeExp(ScopeExp exp) {
        this.walkDeclarationTypes(exp);
        return this.walkExpression(exp);
    }

    protected Expression walkLetExp(LetExp exp) {
        return this.walkScopeExp(exp);
    }

    protected Expression walkLambdaExp(LambdaExp exp) {
        return this.walkScopeExp(exp);
    }

    protected Expression walkClassExp(ClassExp exp) {
        return this.walkLambdaExp(exp);
    }

    protected Expression walkObjectExp(ObjectExp exp) {
        return this.walkClassExp(exp);
    }

    protected Expression walkModuleExp(ModuleExp exp) {
        return this.walkLambdaExp(exp);
    }

    protected Expression walkSetExp(SetExp exp) {
        Declaration decl = exp.binding;
        boolean updateNeeded = decl != null && decl.value == exp.new_value;
        Expression ret = this.walkExpression(exp);
        if (updateNeeded && exp.isDefining()) {
            decl.value = exp.new_value;
            if (exp.new_value instanceof LambdaExp) {
                ((LambdaExp)exp.new_value).nameDecl = decl;
            }
        }
        return ret;
    }

    protected Expression walkTryExp(TryExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkBeginExp(BeginExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkQuoteExp(QuoteExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkThisExp(ThisExp exp) {
        return this.walkReferenceExp(exp);
    }

    protected Expression walkSynchronizedExp(SynchronizedExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkBlockExp(BlockExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkExitExp(ExitExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkFluidLetExp(FluidLetExp exp) {
        return this.walkLetExp(exp);
    }

    protected Expression walkLangExp(LangExp exp) {
        return this.walkExpression(exp);
    }

    public final LambdaExp getCurrentLambda() {
        return this.currentLambda;
    }

    public Expression[] walkExps(Expression[] exps) {
        return this.walkExps(exps, exps.length);
    }

    public Expression[] walkExps(Expression[] exps, int n) {
        int saveColumn;
        int saveLine;
        String saveFile;
        if (this.messages != null) {
            saveFile = this.messages.getFileName();
            saveLine = this.messages.getLineNumber();
            saveColumn = this.messages.getColumnNumber();
        } else {
            saveFile = null;
            saveLine = 0;
            saveColumn = 0;
        }
        boolean mustRestore = false;
        for (int i = 0; i < n && this.exitValue == null; ++i) {
            Expression exp = exps[i];
            int line = exp.getLineNumber();
            if (this.messages != null && line > 0) {
                this.messages.setLine(exp.getFileName(), line, exp.getColumnNumber());
                mustRestore = true;
            } else if (mustRestore) {
                this.messages.setLine(saveFile, saveLine, saveColumn);
                mustRestore = false;
            }
            exps[i] = this.walk(exp);
        }
        if (mustRestore) {
            this.messages.setLine(saveFile, saveLine, saveColumn);
        }
        return exps;
    }

    public void walkDefaultArgs(LambdaExp exp) {
        if (exp.defaultArgs != null) {
            exp.defaultArgs = this.walkExps(exp.defaultArgs);
        }
    }

    public void error(char kind, String message) {
        if (kind == 'w' && this.comp.getBooleanOption("warn-as-error", false)) {
            kind = (char)101;
        }
        if (this.messages != null) {
            this.messages.error(kind, message);
        } else {
            new Error("internal error: " + message);
        }
    }

    public Expression noteError(String message) {
        if (this.messages != null) {
            this.messages.error('e', message);
        }
        return new ErrorExp(message);
    }

    public final String getFileName() {
        return this.messages.getFileName();
    }

    public final int getLineNumber() {
        return this.messages.getLineNumber();
    }

    public final int getColumnNumber() {
        return this.messages.getColumnNumber();
    }

    public String getPublicId() {
        return this.messages.getPublicId();
    }

    public String getSystemId() {
        return this.messages.getSystemId();
    }

    public boolean isStableSourceLocation() {
        return false;
    }

    public void setFile(String filename) {
        this.messages.setFile(filename);
    }

    public void setLine(int line) {
        this.messages.setLine(line);
    }

    public void setColumn(int column) {
        this.messages.setColumn(column);
    }

    public void setLine(String filename, int line, int column) {
        this.messages.setLine(filename, line, column);
    }
}

