/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EMenu;
import gnu.jemacs.swing.SwingMenu;
import gnu.jemacs.swing.SwingWindow;
import gnu.lists.LList;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SwingFrame
extends EFrame {
    JFrame jframe;
    JMenuBar menuBar;
    JPanel contents;

    public SwingFrame() {
    }

    public SwingFrame(Buffer buffer) {
        this(new SwingWindow(buffer, true));
    }

    public SwingFrame(SwingWindow window) {
        super(window);
        this.contents = window.wrap();
        this.jframe = new JFrame(SwingFrame.defaultName());
        this.jframe.getContentPane().add(this.contents);
        this.jframe.setSize(600, 400);
        this.jframe.setVisible(true);
        this.jframe.setTitle("JEmacs");
        this.menuBar = new JMenuBar();
        this.jframe.setJMenuBar(this.menuBar);
    }

    public boolean isLive() {
        return this.contents != null;
    }

    public void validate() {
        this.jframe.validate();
    }

    public void delete() {
        super.delete();
        this.contents = null;
        this.jframe.dispose();
    }

    public String ask(String prompt) {
        String result = JOptionPane.showInputDialog(this.jframe, (Object)prompt);
        if (result == null) {
            throw new CancelledException();
        }
        return result;
    }

    public void setMenuBar(EMenu menu) {
        SwingMenu swingMenu = (SwingMenu)menu;
        this.menuBar.removeAll();
        while (swingMenu.getMenuComponentCount() > 0) {
            this.menuBar.add(swingMenu.getMenuComponent(0));
        }
        this.menuBar.updateUI();
    }

    public void setMenu(LList menu) {
        SwingMenu sMenu = new SwingMenu(menu);
        this.setMenuBar(sMenu);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("#<frame #");
        sbuf.append(this.id);
        if (this.jframe != null) {
            sbuf.append(" size: ");
            sbuf.append(this.jframe.getSize());
            sbuf.append(" preferred: ");
            sbuf.append(this.jframe.getPreferredSize());
        }
        sbuf.append('>');
        return sbuf.toString();
    }
}

