/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TelnetOutputStream
extends FilterOutputStream {
    public TelnetOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int value) throws IOException {
        if (value == 255) {
            this.out.write(value);
        }
        this.out.write(value);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int limit = off + len;
        for (int i = off; i < limit; ++i) {
            if (b[i] != -1) continue;
            this.out.write(b, off, i + 1 - off);
            off = i;
        }
        this.out.write(b, off, limit - off);
    }

    public void writeCommand(int code) throws IOException {
        this.out.write(255);
        this.out.write(code);
    }

    public final void writeCommand(int code, int option2) throws IOException {
        this.out.write(255);
        this.out.write(code);
        this.out.write(option2);
    }

    public final void writeDo(int option2) throws IOException {
        this.writeCommand(253, option2);
    }

    public final void writeDont(int option2) throws IOException {
        this.writeCommand(254, option2);
    }

    public final void writeWill(int option2) throws IOException {
        this.writeCommand(251, option2);
    }

    public final void writeWont(int option2) throws IOException {
        this.writeCommand(252, option2);
    }

    public final void writeSubCommand(int option2, byte[] command) throws IOException {
        this.writeCommand(250, option2);
        this.write(command);
        this.writeCommand(240);
    }
}

