#!/bin/bash

# 0install-filene må være i pwd når vi kjører dette.

if [ "$1" = "-h" ]; then
 echo "Usage:"
 echo "  tools/update-0install-xml.sh 3.20.1"
 exit 0;
fi

VERSION=$1

if test ! -e solfege-$VERSION-Linux-i386.tar.gz; then
  echo "solfege-$VERSION-Linux-i386.tar.gz must exist in the current directory"
  exit 1
fi

if test ! -e solfege-$VERSION-Linux-x86_64.tar.gz; then
  echo "solfege-$VERSION-Linux-x86_64.tar.gz must exist in the current directory"
  exit 1
fi


0publish -v solfege.xml \
  --add-version=$VERSION \
  --set-released=today \
  --set-arch=Linux-x86_64 \
  --set-stability=stable \
  --set-main=solfege-$VERSION-Linux-x86_64/bin/solfege \
  --archive-url=http://downloads.sourceforge.net/project/solfege/solfege-stable/$VERSION/0install/solfege-$VERSION-Linux-x86_64.tar.gz


0publish -v solfege.xml \
  --add-version=$VERSION \
  --set-released=today \
  --set-arch=Linux-i386 \
  --set-stability=stable \
  --set-main=solfege-$VERSION-Linux-i386/bin/solfege \
  --archive-url=http://downloads.sourceforge.net/project/solfege/solfege-stable/$VERSION/0install/solfege-$VERSION-Linux-i386.tar.gz

echo "Not complete yet. Must check solfege.xml with 0publish-gui"
