//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QValidator;
import org.kde.qt.QObject;

/**

 @brief Base class for a meta information plugin
 Meta information plugins are used to extract useful information from files
 of a given type. These plugins are used in Konqueror's file properties
 dialog, for example.
 If you want to write your own plugin, you need to derive from this class.
 In the constructor of your class, you need to call addMimeTypeInfo() to tell
 the KFile framework which mimetype(s) your plugin supports. For each
 mimetype, use the addGroupInfo() and addItemInfo() methods to declare the
 meta information items the plugin calculates and to group them accordingly.
 For groups, use setAttributes() to customize your group (see
 KFileMimeTypeInfo.Attributes). For items, use setAttributes() to define the
 behaviour of the item; use setHint() to define the meaning of the item; use
 setUnit() to define the Unit, such as KFileMimeTypeInfo.Seconds or
 KFileMimeTypeInfo.KiloBytes. In short, the constructor defines the data
 structure of the meta information supported by your plugin.
 Example:
  @code
  FooPlugin.FooPlugin(QObject parent, String name,
                       ArrayListargs)
  {
      KFileMimeTypeInfo info = addMimeTypeInfo( "application/x-foo" );
      // our new group
      KFileMimeTypeInfo.GroupInfo group = null;
      group = addGroupInfo(info, "FooInfo", i18n("Foo Information"));
      KFileMimeTypeInfo.ItemInfo item;
      // our new items in the group
      item = addItemInfo(group, "Items", i18n("Items"), QVariant.Int);
      item = addItemInfo(group, "Size", i18n("Size"), QVariant.Int);
      setUnit(item, KFileMimeTypeInfo.KiloBytes);
      // strings are possible, too:
      //addItemInfo(group, "Document Type", i18n("Document type"), QVariant.String);
  }
  @endcode
 Some meta information items are likely to be available in several different
 file formats, such as @c "Author", @c "Title" (for documents), and
 @c "Length" (for multimedia files). Be sure to use the naming scheme from
 existing plugins for your meta information items if possible. If, for
 example, the meta information of a group of files is shown in a table view,
 this will allow two files to share the same column (say "Length") even if
 they are of a different file type.
 You must overwrite the readInfo() method. In this method you need to extract
 the meta information of the given file. You can use a third-party library to
 achieve this task. This might be the best way for binary files, since a
 change in the file format is likely to be supported by subsequent releases
 of that library. Alternatively, for text-based file formats, you can use
 QTextStream to parse the file. For simple file formats, QRegExp can be of
 great help, too.
 After you extracted the relevant information, use appendGroup() and
 appendItem() to fill the meta information data structure (as defined in the
 constructor) with values. Note that you can leave out groups or items
 which are not appropriate for a particular file.
 Example:
  @code
  boolean FooPlugin.readInfo( KFileMetaInfo& info, uint what)
  {
      int numItems = 0;
      int size = 0;
      // do your calculations here, e.g. using a third-party
      // library or by writing an own parser using e.g. QTextStream
      // calculate numItems and size ...
      // note: use the same key strings as in the constructor
      KFileMetaInfoGroup group = appendGroup(info, "FooInfo");
      appendItem(group, "Items", numItems);
      appendItem(group, "Size", size);
      return true;
  }
  @endcode
 If you want to define mutable meta information items, you need to overwrite
 the writeInfo() method. In this method, you can use third-party library
 (appropriate mostly for binary files, see above) or QTextStream to write the
 information back to the file. If you use QTextStream, be sure to write all
 file contents back.
 For some items, it might be that not all possible values are allowed. You
 can overwrite the createValidator() method to define constraints for a meta
 information item. For example, the @c "Year" field for an MP3 file could
 reject values outside the range 1500 - 2050 (at least for now). The
 validator is used to check values before the writeInfo() method is called so
 that writeInfo() is only provided correct values.
 In your plugin, you need to create a factory for the KFilePlugin
 Example:
  @code
  typedef KGenericFactory<FooPlugin> FooFactory;
  K_EXPORT_COMPONENT_FACTORY(kfile_foo, FooFactory("kfile_foo"));
  @endcode
 To make your plugin available within KDE, you also need to provide a
 <code>.desktop</code> file which describes your plugin. The required fields in the
 file are:
 - <code>Type</code>: must be @c "Service"
 - <code>Name</code>: the name of the plugin
 - <code>ServiceTypes</code>: must contain @c "KFilePlugin"
 - <code>X</code>-KDE-Library: the name of the library containing the KFile plugin
 - <code>MimeType</code>: the mimetype(s) which are supported by the plugin
 - <code>PreferredGroups</code>: a comma-separated list of the most important groups.
   This list defines the order in which the meta information groups should be
   displayed
 - <code>PreferredItems</code>: a comma-separated list of the most important items.
   This list defines the order in which the meta information items should be
   displayed
 Example:
  @code
  [Desktop Entry]
  Encoding=UTF-8
  Type=Service
  Name=Foo Info
  ServiceTypes=KFilePlugin
  X-KDE-Library=kfile_foo
  MimeType=application/x-foo
  PreferredGroups=FooInfo
  PreferredItems=Items,Size
  @endcode
		@short    @brief Base class for a meta information plugin

*/
public class KFilePlugin extends QObject  {
	protected KFilePlugin(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Creates a new KFilePlugin instance. You need to implement a constructor
		 with the same argument list as this is required by KGenericFactory
			@param parent the parent of the QObject, can be <code>0</code>
			@param name the name of the QObject, can be <code>0</code>
			@param args currently ignored
				@short    Creates a new KFilePlugin instance.
		@see #addMimeTypeInfo
		@see #addGroupInfo
		@see #addItemInfo
		@see org.kde.qt.QObject
	*/
	/**	
		 Read the info from the file in this method and insert it into the
		 provided KFileMetaInfo object. You can get the path to the file with
		 KFileMetaInfo.path(). Use appendGroup() and appendItem() to fill
		 <code>info</code> with the extracted values
			@param info the information will be written here
			@param what defines what to read, see KFileMetaInfo.What
				@return @c true if successful, @c false if it failed

		@short    Read the info from the file in this method and insert it into the  provided KFileMetaInfo object.
		@see #writeInfo
	*/
	public native boolean readInfo(KFileMetaInfo info, int what);
	public native boolean readInfo(KFileMetaInfo info);
	/**	
		 Similar to the readInfo() but for writing the info back to the file.
		 If you don't have any writable keys, don't implement this method
			@param info the information that will be written
				@return @c true if successful, @c false if it failed

		@short    Similar to the readInfo() but for writing the info back to the file.
	*/
	public native boolean writeInfo(KFileMetaInfo info);
	/**	
		 This method should create an appropriate validator for the specified
		 item if it's editable or return a null pointer if not. If you don't have
		 any editable items, you don't need to implement this method.
			 If you you don't need any validation, e.g. you accept any input, you can
		 simply return <code>null</code>, or not reimplement this method at all.
			@param mimeType the mime type
			@param group the group name of the validator item
			@param key the key name of the validator item
			@param parent the QObject parent, can be <code>0</code>
			@param name the name of the QObject, can be <code>0</code>
				@short    This method should create an appropriate validator for the specified  item if it's editable or return a null pointer if not.
	*/
	public native QValidator createValidator(String mimeType, String group, String key, QObject parent, String name);
}
