// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
//using System.IO;
using System.Collections;

namespace QtCSharp {

	public class QType {

		string name, access, iname;
		bool isInterface, isConverted, isQObject;
		ArrayList qancestors, qenums, qctors, qdctors, qmethods;

		public QType ()
		{
			qancestors = new ArrayList ();
			qenums = new ArrayList ();
			qctors = new ArrayList ();
			qdctors = new ArrayList ();
			qmethods = new ArrayList ();
		}

		public void AddQAncestor (QAncestor qancestor)
		{
			qancestors.Add (qancestor);
		}

		public void AddQEnum (QEnum qenum)
		{
			qenums.Add (qenum);
		}

		public void AddQCtor (QCtor qctor)
		{
			qctors.Add (qctor);
		}

		public void AddQDCtor (QDCtor qdctor)
		{
			qdctors.Add (qdctor);
		}

		public void AddQMethod (QMethod qmethod)
		{
			qmethods.Add (qmethod);
		}

		public string Name
		{
			get {return name;}
			set {name = value;}
		}

		public string Access
		{
			get {return access;}
			set {access = value;}
		}

		public bool IsInterface
		{
			get {return isInterface;}
			set {isInterface = value;}
		}
		
		public bool IsConverted
		{
			get {return isConverted;}
			set {isConverted = value;}
		}

		public bool IsQObject {
			get { return isQObject; }
			set { isQObject = value; }
		}

		public string IName
		{
			get {return iname;}
			set {iname = value;}
		}

		public ArrayList QAncestors
		{
			get {return qancestors;}
		}

		public ArrayList QEnums
		{
			get {return qenums;}
		}

		public ArrayList QCtors
		{
			get {return qctors;}
		}

		public ArrayList QDCtors
		{
			get {return qdctors;}
		}

		public ArrayList QMethods
		{
			get {return qmethods;}
			set {qmethods = value;}
		}
	}
}
