//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class KUrl kurl.h <KUrl>
    ///  Represents and parses a URL.
    ///  A prototypical URL looks like:
    ///  <pre>
    ///    protocol://user:password\@hostname:port/path/to/file.ext#reference
    ///  </pre>
    ///  KUrl handles escaping of URLs. This means that the specification
    ///  of a full URL will differ from the corresponding string that would specify a
    ///  local file or directory in file-operations like fopen. This is because an URL
    ///  doesn't allow certain characters and escapes them. (e.g. '#'."%23", space."%20")
    ///  (In a URL the hash-character '#' is used to specify a "reference", i.e. the position
    ///  within a document).
    ///  The constructor KUrl(string) expects a string properly escaped,
    ///  or at least non-ambiguous.
    ///  If you have the absolute path you should use KUrl.FromPath(string).
    ///  <pre>
    ///      KUrl kurl = KUrl.FromPath("/bar/#foo#");
    ///      string url = kurl.url();    // . "file:///bar/%23foo%23"
    ///  </pre>
    ///  If you have the URL of a local file or directory and need the absolute path,
    ///  you would use path().
    ///  <pre>
    ///     KUrl url( "file:///bar/%23foo%23" );
    ///     ...
    ///     if ( url.isLocalFile() )
    ///        string path = url.path();       // . "/bar/#foo#"
    ///  </pre>
    ///  This must also be considered when you have separated directory and file
    ///  strings and need to put them together.
    ///  While you can simply concatenate normal path strings, you must take care if
    ///  the directory-part is already an escaped URL.
    ///  (This might be needed if the user specifies a relative path, and your
    ///  program supplies the rest from elsewhere.)
    ///  Wrong:
    ///  <pre>
    ///     string dirUrl = "file:///bar/";
    ///     string fileName = "#foo#";
    ///     string invalidURL = dirUrl + fileName;   // . "file:///bar/#foo#" won't behave like you would expect.
    ///  </pre>
    ///  Instead you should use addPath():
    ///  Right:
    ///  <pre>
    ///     KUrl url( "file:///bar/" );
    ///     string fileName = "#foo#";
    ///     url.addPath( fileName );
    ///     string validURL = url.url();    // . "file:///bar/%23foo%23"
    ///  </pre>
    ///  Also consider that some URLs contain the password, but this shouldn't be
    ///  visible. Your program should use prettyUrl() every time it displays a
    ///  URL, whether in the GUI or in debug output or...
    ///  <pre>
    ///     KUrl url( "ftp://name:password@ftp.faraway.org/bar/%23foo%23");
    ///     string visibleURL = url.prettyUrl(); // . "ftp://name@ftp.faraway.org/bar/%23foo%23"
    ///  </pre>
    ///  Note that prettyUrl() doesn't change the character escapes (like "%23").
    ///  Otherwise the URL would be invalid and the user wouldn't be able to use it in another
    ///  context.
    ///  </remarks>        <short>    \class KUrl kurl.</short>
    [SmokeClass("KUrl")]
    public class KUrl : QUrl, IDisposable {
        protected KUrl(Type dummy) : base((Type) null) {}
        /// <remarks>
        ///  \class List kurl.h <KUrl>
        ///  KUrl.List is a QList that contains KUrls with a few
        ///  convenience methods.
        /// </remarks>        <short>    \class List kurl.</short>
        ///         <see> KUrl</see>
        ///         <see> QValueList</see>
        [SmokeClass("KUrl::List")]
        public class List : Object {
            protected SmokeInvocation interceptor = null;
            private IntPtr smokeObject;
            protected List(Type dummy) {}
            protected void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(List), this);
            }
            private static SmokeInvocation staticInterceptor = null;
            static List() {
                staticInterceptor = new SmokeInvocation(typeof(List), null);
            }
            //  List(); >>>> NOT CONVERTED
            //  List(const KUrl& arg1); >>>> NOT CONVERTED
            //  List(const QStringList& arg1); >>>> NOT CONVERTED
            //  List(); >>>> NOT CONVERTED
            //  operator QVariant(); >>>> NOT CONVERTED
            // void populateMimeData(,,); >>>> NOT CONVERTED
            // KUrl::List fromMimeData(,); >>>> NOT CONVERTED
            /// <remarks>
            ///  Creates an empty List.
            ///      </remarks>        <short>    Creates an empty List.</short>
            /// <remarks>
            ///  Creates a list that contains the given URL as only
            ///  item.
            /// <param> name="url" the url to add.
            ///        </param></remarks>        <short>    Creates a list that contains the given URL as only  item.</short>
            /// <remarks>
            ///  Creates a list that contains the URLs from the given
            ///  list of strings.
            /// <param> name="list" the list containing the URLs as strings
            ///        </param></remarks>        <short>    Creates a list that contains the URLs from the given  list of strings.</short>
            /// <remarks>
            ///  Creates a list that contains the URLs from the given QList<KUrl>.
            /// <param> name="list" the list containing the URLs
            ///        </param></remarks>        <short>    Creates a list that contains the URLs from the given QList<KUrl>.</short>
            /// <remarks>
            ///  Converts the URLs of this list to a list of strings.
            /// </remarks>        <return> the list of strings
            ///        </return>
            ///         <short>    Converts the URLs of this list to a list of strings.</short>
            public List<string> ToStringList() {
                return (List<string>) interceptor.Invoke("toStringList", "toStringList() const", typeof(List<string>));
            }
            /// <remarks>
            ///  Converts this KUrl.List to a QVariant, this allows to use KUrl.List
            ///  in QVariant() constructor
            ///        </remarks>        <short>    Converts this KUrl.List to a QVariant, this allows to use KUrl.List  in QVariant() constructor        </short>
            /// <remarks>
            ///  Adds URLs data into the given QMimeData.
            ///  By default, populateMimeData also exports the URLs as plain text, for e.g. dropping
            ///  onto a text editor.
            ///  But in some cases this might not be wanted, e.g. if adding other mime data
            ///  which provides better plain text data.
            ///  WARNING: do not call this method multiple times on the same mimedata object,
            ///  you can add urls only once. But you can add other things, e.g. images, XML...
            /// <param> name="mimeData" the QMimeData instance used to drag or copy this URL
            /// </param><param> name="metaData" KIO metadata shipped in the mime data, which is used for instance to
            ///  set a correct HTTP referrer (some websites require it for downloading e.g. an image)
            /// </param><param> name="flags" set NoTextExport to prevent setting plain/text data into <code>mimeData</code>
            ///  In such a case, setExportAsText( false ) should be called.
            ///        </param></remarks>        <short>    Adds URLs data into the given QMimeData.</short>
            /// <remarks>
            ///  Return true if <code>mimeData</code> contains URI data
            ///        </remarks>        <short>    Return true if <code>mimeData</code> contains URI data        </short>
            public static bool CanDecode(QMimeData mimeData) {
                return (bool) staticInterceptor.Invoke("canDecode#", "canDecode(const QMimeData*)", typeof(bool), typeof(QMimeData), mimeData);
            }
            /// <remarks>
            ///  Return the list of mimeTypes that can be decoded by fromMimeData
            ///         </remarks>        <short>    Return the list of mimeTypes that can be decoded by fromMimeData         </short>
            public static List<string> MimeDataTypes() {
                return (List<string>) staticInterceptor.Invoke("mimeDataTypes", "mimeDataTypes()", typeof(List<string>));
            }
            /// <remarks>
            ///  Extract a list of KUrls from the contents of <code>mimeData.</code>
            ///  Decoding will fail if <code>mimeData</code> does not contain any URLs, or if at
            ///  least one extracted URL is not valid.
            /// <param> name="mimeData" the mime data to extract from; cannot be 0
            /// </param><param> name="metaData" optional pointer to a map holding the metadata
            /// </param></remarks>        <return> the list of urls
            ///        </return>
            ///         <short>    Extract a list of KUrls from the contents of <code>mimeData.</code></short>
        }
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KUrl), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KUrl() {
            staticInterceptor = new SmokeInvocation(typeof(KUrl), null);
        }
        public enum MimeDataFlags {
            DefaultMimeDataFlags = 0,
            NoTextExport = 1,
        }
        /// <remarks>
        ///  Options to be used in adjustPath
        ///    </remarks>        <short>    Options to be used in adjustPath    </short>
        public enum AdjustPathOption {
            RemoveTrailingSlash = 0,
            LeaveTrailingSlash = 1,
            AddTrailingSlash = 2,
        }
        /// <remarks>
        ///  Options to be used in cleanPath
        ///    </remarks>        <short>    Options to be used in cleanPath    </short>
        public enum CleanPathOption {
            SimplifyDirSeparators = 0x00,
            KeepDirSeparators = 0x01,
        }
        /// <remarks>
        ///  Option to be used in encodedPathAndQuery
        /// </remarks>        <short>    Option to be used in encodedPathAndQuery </short>
        public enum EncodedPathAndQueryOption {
            PermitEmptyPath = 0x00,
            AvoidEmptyPath = 0x01,
        }
        /// <remarks>
        ///  Options for queryItems. Currently, only one option is
        ///  defined:
        /// <param> name="CaseInsensitiveKeys" normalize query keys to lowercase.
        /// </param></remarks>        <short>    Options for queryItems.</short>
        public enum QueryItemsOption {
            CaseInsensitiveKeys = 1,
        }
        /// <remarks>
        ///  option to be used in fileName and directory
        ///    </remarks>        <short>    option to be used in fileName and directory    </short>
        public enum DirectoryOption {
            ObeyTrailingSlash = 0x02,
            AppendTrailingSlash = 0x04,
            IgnoreTrailingSlash = 0x01,
        }
        /// <remarks>
        ///  flags to be used in url compartators function like equal, or urlcmp
        /// </remarks>        <short>    flags to be used in url compartators function like equal, or urlcmp </short>
        public enum EqualsOption {
            CompareWithoutTrailingSlash = 0x01,
            CompareWithoutFragment = 0x02,
        }
        //  operator QVariant(); >>>> NOT CONVERTED
        /// <remarks>
        ///  Constructs an empty URL.
        ///    </remarks>        <short>    Constructs an empty URL.</short>
        public KUrl() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUrl", "KUrl()", typeof(void));
        }
        /// <remarks>
        ///  Usual constructor, to construct from a string.
        /// <param> name="urlOrPath" An encoded URL or a path.
        ///    </param></remarks>        <short>    Usual constructor, to construct from a string.</short>
        public KUrl(string urlOrPath) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUrl$", "KUrl(const QString&)", typeof(void), typeof(string), urlOrPath);
        }
        /// <remarks>
        ///  Constructor taking a QByteArray <code>urlOrPath</code>, which is an _encoded_ representation
        ///  of the URL, exactly like the usual constructor. This is useful when
        ///  the URL, in its encoded form, is strictly ascii.
        /// <param> name="urlOrPath" An encoded URL, or a path.
        ///    </param></remarks>        <short>    Constructor taking a QByteArray <code>urlOrPath</code>, which is an _encoded_ representation  of the URL, exactly like the usual constructor.</short>
        public KUrl(QByteArray urlOrPath) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUrl#", "KUrl(const QByteArray&)", typeof(void), typeof(QByteArray), urlOrPath);
        }
        /// <remarks>
        ///  Copy constructor.
        /// <param> name="u" the KUrl to copy
        ///    </param></remarks>        <short>    Copy constructor.</short>
        public KUrl(KUrl u) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUrl#", "KUrl(const KUrl&)", typeof(void), typeof(KUrl), u);
        }
        /// <remarks>
        ///  Converts from a QUrl.
        /// <param> name="u" the QUrl
        ///    </param></remarks>        <short>    Converts from a QUrl.</short>
        public KUrl(QUrl u) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUrl#", "KUrl(const QUrl&)", typeof(void), typeof(QUrl), u);
        }
        /// <remarks>
        ///  Constructor allowing relative URLs.
        /// <param> name="_baseurl" The base url.
        /// </param><param> name="_rel_url" A relative or absolute URL.
        ///  If this is an absolute URL then <code>_baseurl</code> will be ignored.
        ///  If this is a relative URL it will be combined with <code>_baseurl.</code>
        ///  Note that _rel_url should be encoded too, in any case.
        ///  So do NOT pass a path here (use setPath or addPath instead).
        ///    </param></remarks>        <short>    Constructor allowing relative URLs.</short>
        public KUrl(KUrl _baseurl, string _rel_url) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KUrl#$", "KUrl(const KUrl&, const QString&)", typeof(void), typeof(KUrl), _baseurl, typeof(string), _rel_url);
        }
        /// <remarks>
        ///  Returns the protocol for the URL (i.e., file, http, etc.), lowercased.
        /// </remarks>        <short>    Returns the protocol for the URL (i.</short>
        ///         <see> QUrl.Scheme</see>
        public string Protocol() {
            return (string) interceptor.Invoke("protocol", "protocol() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the protocol for the URL (i.e., file, http, etc.)
        /// <param> name="proto" the new protocol of the URL (without colon)
        ///    </param></remarks>        <short>    Sets the protocol for the URL (i.</short>
        public void SetProtocol(string proto) {
            interceptor.Invoke("setProtocol$", "setProtocol(const QString&)", typeof(void), typeof(string), proto);
        }
        /// <remarks>
        ///  Returns the decoded user name (login, user id, ...) included in the URL.
        /// </remarks>        <return> the user name or string() if there is no user name
        ///    </return>
        ///         <short>    Returns the decoded user name (login, user id, .</short>
        public string User() {
            return (string) interceptor.Invoke("user", "user() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the user name (login, user id, ...) included in the URL.
        ///  Special characters in the user name will appear encoded in the URL.
        /// <param> name="user" the name of the user or string() to remove the user
        ///    </param></remarks>        <short>    Sets the user name (login, user id, .</short>
        public void SetUser(string user) {
            interceptor.Invoke("setUser$", "setUser(const QString&)", typeof(void), typeof(string), user);
        }
        /// <remarks>
        ///  Test to see if this URL has a user name included in it.
        /// </remarks>        <return> true if the URL has an non-empty user name
        ///    </return>
        ///         <short>    Test to see if this URL has a user name included in it.</short>
        public bool HasUser() {
            return (bool) interceptor.Invoke("hasUser", "hasUser() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the decoded password (corresponding to user()) included in the URL.
        /// </remarks>        <return> the password or string() if it does not exist
        /// </return>
        ///         <short>    Returns the decoded password (corresponding to user()) included in the URL.</short>
        public string Pass() {
            return (string) interceptor.Invoke("pass", "pass() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the password (corresponding to user()) included in the URL.
        ///  Special characters in the password will appear encoded in the URL.
        ///  Note that a password can only appear in a URL string if you also set
        ///  a user.
        /// <param> name="pass" the password to set or string() to remove the password
        /// </param></remarks>        <short>    Sets the password (corresponding to user()) included in the URL.</short>
        ///         <see> setUser</see>
        ///         <see> hasUser</see>
        public void SetPass(string pass) {
            interceptor.Invoke("setPass$", "setPass(const QString&)", typeof(void), typeof(string), pass);
        }
        /// <remarks>
        ///  Test to see if this URL has a password included in it.
        /// </remarks>        <return> true if there is a non-empty password set
        /// </return>
        ///         <short>    Test to see if this URL has a password included in it.</short>
        public bool HasPass() {
            return (bool) interceptor.Invoke("hasPass", "hasPass() const", typeof(bool));
        }
        /// <remarks>
        ///  Test to see if this URL has a hostname included in it.
        /// </remarks>        <return> true if the URL has a host
        /// </return>
        ///         <short>    Test to see if this URL has a hostname included in it.</short>
        public bool HasHost() {
            return (bool) interceptor.Invoke("hasHost", "hasHost() const", typeof(bool));
        }
        /// <remarks>
        /// <param> name="trailing" use to add or remove a trailing slash to/from the path. see adjustPath
        /// </param></remarks>        <return> The current decoded path. This does not include the query. Can
        ///          be string() if no path is set.
        ///    </return>
        ///         <short>   </short>
        public string Path(KUrl.AdjustPathOption trailing) {
            return (string) interceptor.Invoke("path$", "path(KUrl::AdjustPathOption) const", typeof(string), typeof(KUrl.AdjustPathOption), trailing);
        }
        public new string Path() {
            return (string) interceptor.Invoke("path", "path() const", typeof(string));
        }
        /// <remarks>
        /// <param> name="trailing" use to add or remove a trailing slash to/from the local path. see adjustPath
        /// </param></remarks>        <return> The current local path. Can
        ///    be string() if no path is set.
        ///    </return>
        ///         <short>   </short>
        public string ToLocalFile(KUrl.AdjustPathOption trailing) {
            return (string) interceptor.Invoke("toLocalFile$", "toLocalFile(KUrl::AdjustPathOption) const", typeof(string), typeof(KUrl.AdjustPathOption), trailing);
        }
        public new string ToLocalFile() {
            return (string) interceptor.Invoke("toLocalFile", "toLocalFile() const", typeof(string));
        }
        public new void SetPath(string path) {
            interceptor.Invoke("setPath$", "setPath(const QString&)", typeof(void), typeof(string), path);
        }
        /// <remarks>
        ///  Test to see if this URL has a path is included in it.
        /// </remarks>        <return> true if there is a path
        /// </return>
        ///         <short>    Test to see if this URL has a path is included in it.</short>
        public bool HasPath() {
            return (bool) interceptor.Invoke("hasPath", "hasPath() const", typeof(bool));
        }
        /// <remarks>
        ///  Resolves "." and ".." components in path.
        ///  Some servers seem not to like the removal of extra '/'
        ///  even though it is against the specification in RFC 2396.
        /// <param> name="options" use KeepDirSeparators if you don't want to remove consecutive
        ///                 occurrences of directory separator
        ///    </param></remarks>        <short>    Resolves ".</short>
        public void CleanPath(KUrl.CleanPathOption options) {
            interceptor.Invoke("cleanPath$", "cleanPath(const KUrl::CleanPathOption&)", typeof(void), typeof(KUrl.CleanPathOption), options);
        }
        public void CleanPath() {
            interceptor.Invoke("cleanPath", "cleanPath()", typeof(void));
        }
        /// <remarks>
        ///  Add or remove a trailing slash to/from the path.
        ///  If the URL has no path, then no '/' is added
        ///  anyway. And on the other side: If the path is "/", then this
        ///  character won't be stripped. Reason: "ftp://weis\@host" means something
        ///  completely different than "ftp://weis\@host/". So adding or stripping
        ///  the '/' would really alter the URL, while "ftp://host/path" and
        ///  "ftp://host/path/" mean the same directory.
        /// <param> name="trailing" RemoveTrailingSlash strips any trailing '/' and
        ///                   AddTrailingSlash adds  a trailing '/' if there is none yet
        ///    </param></remarks>        <short>    Add or remove a trailing slash to/from the path.</short>
        public void AdjustPath(KUrl.AdjustPathOption trailing) {
            interceptor.Invoke("adjustPath$", "adjustPath(KUrl::AdjustPathOption)", typeof(void), typeof(KUrl.AdjustPathOption), trailing);
        }
        /// <remarks>
        ///  This is useful for HTTP. It looks first for '?' and decodes then.
        ///  The encoded path is the concatenation of the current path and the query.
        /// <param> name="_txt" the new path and query.
        ///    </param></remarks>        <short>    This is useful for HTTP.</short>
        public void SetEncodedPathAndQuery(string _txt) {
            interceptor.Invoke("setEncodedPathAndQuery$", "setEncodedPathAndQuery(const QString&)", typeof(void), typeof(string), _txt);
        }
        /// <remarks>
        ///  Returns the encoded path and the query.
        /// <param> name="trailing" add or remove a trailing '/', see adjustPath
        /// </param><param> name="options" a set of flags from EncodedPathAndQueryOption
        /// </param>   </remarks>        <return> The concatenation of the encoded path , '?' and the encoded query.
        /// </return>
        ///         <short>    Returns the encoded path and the query.</short>
        public string EncodedPathAndQuery(KUrl.AdjustPathOption trailing, uint options) {
            return (string) interceptor.Invoke("encodedPathAndQuery$$", "encodedPathAndQuery(KUrl::AdjustPathOption, const KUrl::EncodedPathAndQueryOptions&) const", typeof(string), typeof(KUrl.AdjustPathOption), trailing, typeof(uint), options);
        }
        public string EncodedPathAndQuery(KUrl.AdjustPathOption trailing) {
            return (string) interceptor.Invoke("encodedPathAndQuery$", "encodedPathAndQuery(KUrl::AdjustPathOption) const", typeof(string), typeof(KUrl.AdjustPathOption), trailing);
        }
        public string EncodedPathAndQuery() {
            return (string) interceptor.Invoke("encodedPathAndQuery", "encodedPathAndQuery() const", typeof(string));
        }
        /// <remarks>
        /// <param> name="query" This is considered to be encoded. This has a good reason:
        ///  The query may contain the 0 character.
        /// </param> The query should start with a '?'. If it doesn't '?' is prepended.
        ///    </remarks>        <short>   </short>
        public void SetQuery(string query) {
            interceptor.Invoke("setQuery$", "setQuery(const QString&)", typeof(void), typeof(string), query);
        }
        /// <remarks>
        ///  Returns the query of the URL.
        ///  The query may contain the 0 character.
        ///  If a query is present it always starts with a '?'.
        ///  A single '?' means an empty query.
        ///  An empty string means no query.
        /// </remarks>        <return> The encoded query, or string() if there is none.
        ///    </return>
        ///         <short>    Returns the query of the URL.</short>
        public string Query() {
            return (string) interceptor.Invoke("query", "query() const", typeof(string));
        }
        /// <remarks>
        ///  The reference is <b>never</b> decoded automatically.
        /// </remarks>        <return> the undecoded reference, or string() if there is none
        ///    </return>
        ///         <short>    The reference is @em never decoded automatically.</short>
        public string Ref() {
            return (string) interceptor.Invoke("ref", "ref() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the reference part (everything after '#').
        ///  If you have an encoded fragment already (as a QByteArray), you can call setFragment directly.
        /// <param> name="fragment" the encoded reference (or string() to remove it).
        ///    </param></remarks>        <short>    Sets the reference part (everything after '#').</short>
        public void SetRef(string fragment) {
            interceptor.Invoke("setRef$", "setRef(const QString&)", typeof(void), typeof(string), fragment);
        }
        /// <remarks>
        ///  Checks whether the URL has a reference part.
        /// </remarks>        <return> true if the URL has a reference part. In a URL like
        ///          http://www.kde.org/kdebase.tar#tar:/README it would
        ///          return true, too.
        ///    </return>
        ///         <short>    Checks whether the URL has a reference part.</short>
        public bool HasRef() {
            return (bool) interceptor.Invoke("hasRef", "hasRef() const", typeof(bool));
        }
        /// <remarks>
        ///  Returns the HTML reference (the part of the URL after "#").
        /// </remarks>        <return> The HTML-style reference.
        /// </return>
        ///         <short>    Returns the HTML reference (the part of the URL after "#").</short>
        ///         <see> split</see>
        ///         <see> hasSubUrl</see>
        ///         <see> encodedHtmlRef</see>
        public string HtmlRef() {
            return (string) interceptor.Invoke("htmlRef", "htmlRef() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the HTML reference (the part of the URL after "#") in
        ///  encoded form.
        /// </remarks>        <return> The HTML-style reference in its original form.
        ///    </return>
        ///         <short>    Returns the HTML reference (the part of the URL after "#") in  encoded form.</short>
        public string EncodedHtmlRef() {
            return (string) interceptor.Invoke("encodedHtmlRef", "encodedHtmlRef() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the HTML-style reference.
        /// <param> name="_ref" The new reference. This is considered to be <b>not</b> encoded in
        ///          contrast to setRef(). Use string() to remove it.
        /// </param></remarks>        <short>    Sets the HTML-style reference.</short>
        ///         <see> htmlRef</see>
        public void SetHTMLRef(string _ref) {
            interceptor.Invoke("setHTMLRef$", "setHTMLRef(const QString&)", typeof(void), typeof(string), _ref);
        }
        /// <remarks>
        ///  Checks whether there is a HTML reference.
        /// </remarks>        <return> true if the URL has an HTML-style reference.
        /// </return>
        ///         <short>    Checks whether there is a HTML reference.</short>
        ///         <see> htmlRef</see>
        public bool HasHTMLRef() {
            return (bool) interceptor.Invoke("hasHTMLRef", "hasHTMLRef() const", typeof(bool));
        }
        /// <remarks>
        ///  Checks whether the file is local.
        /// </remarks>        <return> true if the file is a plain local file and has no filter protocols
        ///          attached to it.
        ///    </return>
        ///         <short>    Checks whether the file is local.</short>
        public bool IsLocalFile() {
            return (bool) interceptor.Invoke("isLocalFile", "isLocalFile() const", typeof(bool));
        }
        /// <remarks>
        ///  Adds encoding information to url by adding a "charset" parameter. If there
        ///  is already a charset parameter, it will be replaced.
        /// <param> name="encoding" the encoding to add or string() to remove the
        ///                  encoding.
        ///    </param></remarks>        <short>    Adds encoding information to url by adding a "charset" parameter.</short>
        public void SetFileEncoding(string encoding) {
            interceptor.Invoke("setFileEncoding$", "setFileEncoding(const QString&)", typeof(void), typeof(string), encoding);
        }
        /// <remarks>
        ///  Returns encoding information from url, the content of the "charset"
        ///  parameter.
        /// </remarks>        <return> An encoding suitable for QTextCodec.CodecForName()
        ///          or string() if not encoding was specified.
        ///    </return>
        ///         <short>    Returns encoding information from url, the content of the "charset"  parameter.</short>
        public string FileEncoding() {
            return (string) interceptor.Invoke("fileEncoding", "fileEncoding() const", typeof(string));
        }
        /// <remarks>
        ///  Checks whether the URL has any sub URLs. See split()
        ///  for examples for sub URLs.
        /// </remarks>        <return> true if the file has at least one sub URL.
        /// </return>
        ///         <short>    Checks whether the URL has any sub URLs.</short>
        ///         <see> split</see>
        public bool HasSubUrl() {
            return (bool) interceptor.Invoke("hasSubUrl", "hasSubUrl() const", typeof(bool));
        }
        /// <remarks>
        ///  Adds to the current path.
        ///  Assumes that the current path is a directory. <code>_txt</code> is appended to the
        ///  current path. The function adds '/' if needed while concatenating.
        ///  This means it does not matter whether the current path has a trailing
        ///  '/' or not. If there is none, it becomes appended. If <code>_txt</code>
        ///  has a leading '/' then this one is stripped.
        /// <param> name="txt" The text to add. It is considered to be decoded.
        ///    </param></remarks>        <short>    Adds to the current path.</short>
        public void AddPath(string txt) {
            interceptor.Invoke("addPath$", "addPath(const QString&)", typeof(void), typeof(string), txt);
        }
        /// <remarks>
        ///  Returns the list of query items as a map mapping keys to values.
        ///  This does the same as QUrl.QueryItems(), except that it
        ///  decodes "+" into " " in the value, supports CaseInsensitiveKeys,
        ///  and returns a different data type.
        /// <param> name="options" any of QueryItemsOption <em>or</em>ed together.
        /// </param></remarks>        <return> the map of query items or the empty map if the url has no
        ///  query items.
        ///    </return>
        ///         <short>    Returns the list of query items as a map mapping keys to values.</short>
        public Dictionary<string, string> QueryItems(uint options) {
            return (Dictionary<string, string>) interceptor.Invoke("queryItems$", "queryItems(const KUrl::QueryItemsOptions&) const", typeof(Dictionary<string, string>), typeof(uint), options);
        }
        public new Dictionary<string, string> QueryItems() {
            return (Dictionary<string, string>) interceptor.Invoke("queryItems", "queryItems() const", typeof(Dictionary<string, string>));
        }
        /// <remarks>
        ///  Returns the value of a certain query item.
        ///  This does the same as QUrl.QueryItemValue(), except that it
        ///  decodes "+" into " " in the value.
        /// <param> name="item" Item whose value we want
        /// </param></remarks>        <return> the value of the given query item name or string() if the
        ///  specified item does not exist.
        ///    </return>
        ///         <short>    Returns the value of a certain query item.</short>
        public string QueryItem(string item) {
            return (string) interceptor.Invoke("queryItem$", "queryItem(const QString&) const", typeof(string), typeof(string), item);
        }
        /// <remarks>
        ///  Add an additional query item.
        ///  To replace an existing query item, the item should first be
        ///  removed with removeQueryItem()
        /// <param> name="_item" Name of item to add
        /// </param><param> name="_value" Value of item to add
        ///    </param></remarks>        <short>    Add an additional query item.</short>
        public new void AddQueryItem(string _item, string _value) {
            interceptor.Invoke("addQueryItem$$", "addQueryItem(const QString&, const QString&)", typeof(void), typeof(string), _item, typeof(string), _value);
        }
        /// <remarks>
        ///  Sets the filename of the path.
        ///  In comparison to addPath() this function does not assume that the current
        ///  path is a directory. This is only assumed if the current path ends with '/'.
        ///  Any reference is reset.
        /// <param> name="_txt" The filename to be set. It is considered to be decoded. If the
        ///              current path ends with '/' then <code>_txt</code> int just appended, otherwise
        ///              all text behind the last '/' in the current path is erased and
        ///              <code>_txt</code> is appended then. It does not matter whether <code>_txt</code> starts
        ///              with '/' or not.
        ///    </param></remarks>        <short>    Sets the filename of the path.</short>
        public void SetFileName(string _txt) {
            interceptor.Invoke("setFileName$", "setFileName(const QString&)", typeof(void), typeof(string), _txt);
        }
        /// <remarks>
        ///  Returns the filename of the path.
        /// <param> name="options" a set of DirectoryOption flags.  (StripTrailingSlashFromResult has no effect)
        /// </param></remarks>        <return> The filename of the current path. The returned string is decoded. Null
        ///          if there is no file (and thus no path).
        ///    </return>
        ///         <short>    Returns the filename of the path.</short>
        public string FileName(uint options) {
            return (string) interceptor.Invoke("fileName$", "fileName(const KUrl::DirectoryOptions&) const", typeof(string), typeof(uint), options);
        }
        public string FileName() {
            return (string) interceptor.Invoke("fileName", "fileName() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the directory of the path.
        /// <param> name="options" a set of DirectoryOption flags
        /// </param></remarks>        <return> The directory part of the current path. Everything between the last and the second last '/'
        ///          is returned. For example <tt>file:///hallo/torben/</tt> would return "/hallo/torben/" while
        ///          <tt>file:///hallo/torben</tt> would return "hallo/". The returned string is decoded.
        ///          string() is returned when there is no path.
        ///    </return>
        ///         <short>    Returns the directory of the path.</short>
        public string Directory(uint options) {
            return (string) interceptor.Invoke("directory$", "directory(const KUrl::DirectoryOptions&) const", typeof(string), typeof(uint), options);
        }
        public string Directory() {
            return (string) interceptor.Invoke("directory", "directory() const", typeof(string));
        }
        /// <remarks>
        ///  Set the directory to <code>dir</code>, leaving the filename empty.
        ///    </remarks>        <short>    Set the directory to <code>dir</code>, leaving the filename empty.</short>
        public void SetDirectory(string dir) {
            interceptor.Invoke("setDirectory$", "setDirectory(const QString&)", typeof(void), typeof(string), dir);
        }
        /// <remarks>
        ///  Changes the directory by descending into the given directory.
        ///  It is assumed the current URL represents a directory.
        ///  If <code>dir</code> starts with a "/" the
        ///  current URL will be "protocol://host/dir" otherwise <code>_dir</code> will
        ///  be appended to the path. <code>_dir</code> can be ".."
        ///  This function won't strip protocols. That means that when you are in
        ///  file:///dir/dir2/my.tgz#tar:/ and you do cd("..") you will
        ///  still be in file:///dir/dir2/my.tgz#tar:/
        /// <param> name="_dir" the directory to change to
        /// </param></remarks>        <return> true if successful
        ///    </return>
        ///         <short>    Changes the directory by descending into the given directory.</short>
        public bool Cd(string _dir) {
            return (bool) interceptor.Invoke("cd$", "cd(const QString&)", typeof(bool), typeof(string), _dir);
        }
        /// <remarks>
        ///  Returns the URL as string, with all escape sequences intact,
        ///  encoded in a given charset.
        ///  This is used in particular for encoding URLs in UTF-8 before using them
        ///  in a drag and drop operation.
        ///  Please note that the string returned by url() will include
        ///  the password of the URL. If you want to show the URL to the
        ///  user, use prettyUrl().
        /// <param> name="trailing" use to add or remove a trailing slash to/from the path. See adjustPath
        /// </param></remarks>        <return> The complete URL, with all escape sequences intact, encoded
        ///  in a given charset.
        /// </return>
        ///         <short>    Returns the URL as string, with all escape sequences intact,  encoded in a given charset.</short>
        ///         <see> prettyUrl</see>
        public string Url(KUrl.AdjustPathOption trailing) {
            return (string) interceptor.Invoke("url$", "url(KUrl::AdjustPathOption) const", typeof(string), typeof(KUrl.AdjustPathOption), trailing);
        }
        public string Url() {
            return (string) interceptor.Invoke("url", "url() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the URL as string in human-friendly format.
        ///  Example:
        ///  <pre>
        ///  http://localhost:8080/test.cgi?test=hello world&name=fred
        ///  </pre>
        /// <param> name="trailing" use to add or remove a trailing slash to/from the path. see adjustPath.
        /// </param></remarks>        <return> A human readable URL, with no non-necessary encodings/escaped
        ///  characters. Password will not be shown.
        /// </return>
        ///         <short>    Returns the URL as string in human-friendly format.</short>
        ///         <see> url</see>
        public string PrettyUrl(KUrl.AdjustPathOption trailing) {
            return (string) interceptor.Invoke("prettyUrl$", "prettyUrl(KUrl::AdjustPathOption) const", typeof(string), typeof(KUrl.AdjustPathOption), trailing);
        }
        public string PrettyUrl() {
            return (string) interceptor.Invoke("prettyUrl", "prettyUrl() const", typeof(string));
        }
        /// <remarks>
        ///  Return the URL as a string, which will be either the URL (as prettyUrl
        ///  would return) or, when the URL is a local file without query or ref,
        ///  the path.
        ///  Use this method, to display URLs to the user.
        ///  You can give the result of pathOrUrl back to the KUrl constructor, it accepts
        ///  both paths and urls.
        /// </remarks>        <return> the new KUrl
        ///    </return>
        ///         <short>    Return the URL as a string, which will be either the URL (as prettyUrl  would return) or, when the URL is a local file without query or ref,  the path.</short>
        public string PathOrUrl() {
            return (string) interceptor.Invoke("pathOrUrl", "pathOrUrl() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the URL as a string, using the standard conventions for mime data
        ///  (drag-n-drop or copy-n-paste).
        ///  Internally used by KUrl.List.FromMimeData, which is probably what you want to use instead.
        ///    </remarks>        <short>    Returns the URL as a string, using the standard conventions for mime data  (drag-n-drop or copy-n-paste).</short>
        public string ToMimeDataString() {
            return (string) interceptor.Invoke("toMimeDataString", "toMimeDataString() const", typeof(string));
        }
        /// <remarks>
        ///  This function is useful to implement the "Up" button in a file manager for example.
        ///  cd() never strips a sub-protocol. That means that if you are in
        ///  file:///home/x.tgz#gzip:/#tar:/ and hit the up button you expect to see
        ///  file:///home. The algorithm tries to go up on the right-most URL. If that is not
        ///  possible it strips the right most URL. It continues stripping URLs.
        /// </remarks>        <return> a URL that is a level higher
        ///    </return>
        ///         <short>    This function is useful to implement the "Up" button in a file manager for example.</short>
        public KUrl UpUrl() {
            return (KUrl) interceptor.Invoke("upUrl", "upUrl() const", typeof(KUrl));
        }
        public override bool Equals(object o) {
            if (!(o is KUrl)) { return false; }
            return this == (KUrl) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Converts this KUrl to a QVariant, this allows to use KUrl
        ///  in QVariant() constructor
        ///    </remarks>        <short>    Converts this KUrl to a QVariant, this allows to use KUrl  in QVariant() constructor    </short>
        /// <remarks>
        ///  Compares this url with <code>u.</code>
        /// <param> name="u" the URL to compare this one with.
        /// </param><param> name="options" a set of EqualsOption flags
        /// </param></remarks>        <return> true if both urls are the same
        /// </return>
        ///         <short>    Compares this url with <code>u.</code></short>
        ///         <see> operator==.</see>
        ///         <see> This</see>
        ///         <see> function</see>
        ///         <see> should</see>
        ///         <see> be</see>
        ///         <see> used</see>
        ///         <see> if</see>
        ///         <see> you</see>
        ///         <see> want</see>
        ///         <see> to</see>
        ///         <see> ignore</see>
        ///         <see> trailing</see>
        ///         <see> characters.</see>
        public bool Equals(KUrl u, uint options) {
            return (bool) interceptor.Invoke("equals#$", "equals(const KUrl&, const KUrl::EqualsOptions&) const", typeof(bool), typeof(KUrl), u, typeof(uint), options);
        }
        public bool Equals(KUrl u) {
            return (bool) interceptor.Invoke("equals#", "equals(const KUrl&) const", typeof(bool), typeof(KUrl), u);
        }
        /// <remarks>
        ///  Checks whether the given URL is parent of this URL.
        ///  For instance, ftp://host/dir/ is a parent of ftp://host/dir/subdir/subsubdir/.
        ///    </remarks>        <return> true if this url is a parent of <code>u</code> (or the same URL as <code>u</code>)
        /// </return>
        ///         <short>    Checks whether the given URL is parent of this URL.</short>
        public bool IsParentOf(KUrl u) {
            return (bool) interceptor.Invoke("isParentOf#", "isParentOf(const KUrl&) const", typeof(bool), typeof(KUrl), u);
        }
        /// <remarks>
        ///  Adds URL data into the given QMimeData.
        ///  By default, populateMimeData also exports the URL as plain text, for e.g. dropping
        ///  onto a text editor.
        ///  But in some cases this might not be wanted, e.g. if adding other mime data
        ///  which provides better plain text data.
        ///  WARNING: do not call this method multiple times, use KUrl.List.PopulateMimeData instead.
        /// <param> name="mimeData" the QMimeData instance used to drag or copy this URL
        /// </param><param> name="metaData" KIO metadata shipped in the mime data, which is used for instance to
        ///  set a correct HTTP referrer (some websites require it for downloading e.g. an image)
        /// </param><param> name="flags" set NoTextExport to prevent setting plain/text data into <code>mimeData</code>
        ///  In such a case, setExportAsText( false ) should be called.
        ///    </param></remarks>        <short>    Adds URL data into the given QMimeData.</short>
        public void PopulateMimeData(QMimeData mimeData, Dictionary<string, string> metaData, KUrl.MimeDataFlags flags) {
            interceptor.Invoke("populateMimeData#?$", "populateMimeData(QMimeData*, const QMap<QString,QString>&, KUrl::MimeDataFlags) const", typeof(void), typeof(QMimeData), mimeData, typeof(Dictionary<string, string>), metaData, typeof(KUrl.MimeDataFlags), flags);
        }
        public void PopulateMimeData(QMimeData mimeData, Dictionary<string, string> metaData) {
            interceptor.Invoke("populateMimeData#?", "populateMimeData(QMimeData*, const QMap<QString,QString>&) const", typeof(void), typeof(QMimeData), mimeData, typeof(Dictionary<string, string>), metaData);
        }
        public void PopulateMimeData(QMimeData mimeData) {
            interceptor.Invoke("populateMimeData#", "populateMimeData(QMimeData*) const", typeof(void), typeof(QMimeData), mimeData);
        }
        ~KUrl() {
            interceptor.Invoke("~KUrl", "~KUrl()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KUrl", "~KUrl()", typeof(void));
        }
        public static bool operator==(KUrl lhs, KUrl _u) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const KUrl&) const", typeof(bool), typeof(KUrl), lhs, typeof(KUrl), _u);
        }
        public static bool operator!=(KUrl lhs, KUrl _u) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const KUrl&) const", typeof(bool), typeof(KUrl), lhs, typeof(KUrl), _u);
        }
        public static bool operator==(KUrl lhs, string _u) {
            return (bool) staticInterceptor.Invoke("operator==$", "operator==(const QString&) const", typeof(bool), typeof(KUrl), lhs, typeof(string), _u);
        }
        public static bool operator!=(KUrl lhs, string _u) {
            return !(bool) staticInterceptor.Invoke("operator==$", "operator==(const QString&) const", typeof(bool), typeof(KUrl), lhs, typeof(string), _u);
        }
        /// <remarks>
        ///  Splits nested URLs like file:///home/weis/kde.tgz#gzip:/#tar:/kdebase
        ///  A URL like http://www.kde.org#tar:/kde/README.hml#ref1 will be split in
        ///  http://www.kde.org and tar:/kde/README.html#ref1.
        ///  That means in turn that "#ref1" is an HTML-style reference and not a new sub URL.
        ///  Since HTML-style references mark
        ///  a certain position in a document this reference is appended to every URL.
        ///  The idea behind this is that browsers, for example, only look at the first URL while
        ///  the rest is not of interest to them.
        /// <param> name="_url" The URL that has to be split.
        /// </param></remarks>        <return> An empty list on error or the list of split URLs.
        /// </return>
        ///         <short>    Splits nested URLs like file:///home/weis/kde.</short>
        ///         <see> hasSubUrl</see>
        public static List<KUrl> Split(string _url) {
            return (List<KUrl>) staticInterceptor.Invoke("split$", "split(const QString&)", typeof(List<KUrl>), typeof(string), _url);
        }
        /// <remarks>
        ///  Splits nested URLs like file:///home/weis/kde.tgz#gzip:/#tar:/kdebase
        ///  A URL like http://www.kde.org#tar:/kde/README.hml#ref1 will be split in
        ///  http://www.kde.org and tar:/kde/README.html#ref1.
        ///  That means in turn that "#ref1" is an HTML-style reference and not a new sub URL.
        ///  Since HTML-style references mark
        ///  a certain position in a document this reference is appended to every URL.
        ///  The idea behind this is that browsers, for example, only look at the first URL while
        ///  the rest is not of interest to them.
        /// <param> name="_url" The URL that has to be split.
        /// </param></remarks>        <return> An empty list on error or the list of split URLs.
        /// </return>
        ///         <short>    Splits nested URLs like file:///home/weis/kde.</short>
        ///         <see> hasSubUrl</see>
        public static List<KUrl> Split(KUrl _url) {
            return (List<KUrl>) staticInterceptor.Invoke("split#", "split(const KUrl&)", typeof(List<KUrl>), typeof(KUrl), _url);
        }
        /// <remarks>
        ///  Reverses split(). Only the first URL may have a reference. This reference
        ///  is considered to be HTML-like and is appended at the end of the resulting
        ///  joined URL.
        /// <param> name="_list" the list to join
        /// </param></remarks>        <return> the joined URL
        ///    </return>
        ///         <short>    Reverses split().</short>
        public static KUrl Join(List<KUrl> _list) {
            return (KUrl) staticInterceptor.Invoke("join?", "join(const KUrl::List&)", typeof(KUrl), typeof(List<KUrl>), _list);
        }
        /// <remarks>
        ///  Creates a KUrl object from a string representing an absolute path.
        ///  KUrl url( somePath ) does the same, but this method is more explicit
        ///  and avoids the path-or-url detection in the KUrl constructor.
        /// <param> name="text" the path
        /// </param></remarks>        <return> the new KUrl
        ///    </return>
        ///         <short>    Creates a KUrl object from a string representing an absolute path.</short>
        public static KUrl FromPath(string text) {
            return (KUrl) staticInterceptor.Invoke("fromPath$", "fromPath(const QString&)", typeof(KUrl), typeof(string), text);
        }
        /// <remarks>
        ///  Creates a KUrl from a string, using the standard conventions for mime data
        ///  (drag-n-drop or copy-n-paste).
        ///  Internally used by KUrl.List.FromMimeData, which is probably what you want to use instead.
        ///    </remarks>        <short>    Creates a KUrl from a string, using the standard conventions for mime data  (drag-n-drop or copy-n-paste).</short>
        public static KUrl FromMimeDataByteArray(QByteArray str) {
            return (KUrl) staticInterceptor.Invoke("fromMimeDataByteArray#", "fromMimeDataByteArray(const QByteArray&)", typeof(KUrl), typeof(QByteArray), str);
        }
        /// <remarks>
        ///  Convenience function.
        ///  Returns whether '_url' is likely to be a "relative" URL instead of
        ///  an "absolute" URL.
        /// <param> name="_url" URL to examine
        /// </param></remarks>        <return> true when the URL is likely to be "relative", false otherwise.
        ///    </return>
        ///         <short>    Convenience function.</short>
        public static bool IsRelativeUrl(string _url) {
            return (bool) staticInterceptor.Invoke("isRelativeUrl$", "isRelativeUrl(const QString&)", typeof(bool), typeof(string), _url);
        }
        /// <remarks>
        ///  Convenience function
        ///  Returns a "relative URL" based on <code>base_url</code> that points to <code>url.</code>
        ///  If no "relative URL" can be created, e.g. because the protocol
        ///  and/or hostname differ between <code>base_url</code> and <code>url</code> an absolute
        ///  URL is returned.
        ///  Note that if <code>base_url</code> represents a directory, it should contain
        ///  a trailing slash.
        /// <param> name="base_url" the URL to derive from
        /// </param><param> name="url" new URL
        /// </param></remarks>        <short>    Convenience function </short>
        ///         <see> adjustPath</see>
        public static string RelativeUrl(KUrl base_url, KUrl url) {
            return (string) staticInterceptor.Invoke("relativeUrl##", "relativeUrl(const KUrl&, const KUrl&)", typeof(string), typeof(KUrl), base_url, typeof(KUrl), url);
        }
        /// <remarks>
        ///  Convenience function
        ///  Returns a relative path based on <code>base_dir</code> that points to <code>path.</code>
        /// <param> name="base_dir" the base directory to derive from
        /// </param><param> name="path" the new target directory
        /// </param><param> name="isParent" A pointer to a boolean which, if provided, will be set to reflect
        ///  whether <code>path</code> has <code>base_dir</code> is a parent dir.
        ///    </param></remarks>        <short>    Convenience function </short>
        public static string RelativePath(string base_dir, string path, ref bool isParent) {
            StackItem[] stack = new StackItem[4];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(base_dir);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(base_dir);
#endif
#if DEBUG
            stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(path);
#else
            stack[2].s_class = (IntPtr) GCHandle.Alloc(path);
#endif
            stack[3].s_bool = isParent;
            staticInterceptor.Invoke("relativePath$$$", "relativePath(const QString&, const QString&, bool*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
            ((GCHandle) stack[2].s_class).Free();
#endif
            isParent = stack[3].s_bool;
            object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
            ((GCHandle) stack[0].s_class).Free();
#endif
            return (string) returnValue;
        }
        public static string RelativePath(string base_dir, string path) {
            return (string) staticInterceptor.Invoke("relativePath$$", "relativePath(const QString&, const QString&)", typeof(string), typeof(string), base_dir, typeof(string), path);
        }
    }
}
