/* -*- c++ -*-
 *
 * mlconfig.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003,2004,2007 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_mlconfig_h__
#define __kmldonkey_mlconfig_h__

#include <q3dict.h>
#include <kpagedialog.h>

#include "optioneditor.h"

class QCheckBox;

class NetworkPage : public QWidget
{
        Q_OBJECT
    public:
        NetworkPage(QWidget* parent = 0, const char* name = 0);
        void applyOptions(DonkeyProtocol* target);
    protected slots:
        void becomeDirty(bool);
    signals:
        void pageDirty();
    private:
        Q3IntDict<QCheckBox> nwBox;
};

class MLDonkeyConfigDialog : public KPageDialog
{
        Q_OBJECT
    public:
        MLDonkeyConfigDialog(QWidget* parent = 0, const char* name = 0);
    protected slots:
        void setDirtyDialog();
        void applyOptions();
        void closeDialog();
    private:
        Q3Dict<OptionEditorWidget> pages;
        NetworkPage* m_networkPage;
};

#endif // __kmldonkey_mlconfig_h__
