//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class KCoreConfigSkeleton kcoreconfigskeleton.h <KCoreConfigSkeleton>
    ///  This class provides an interface to preferences settings. Preferences items
    ///  can be registered by the addItem() function corresponding to the data type of
    ///  the seetting. KCoreConfigSkeleton then handles reading and writing of config files and
    ///  setting of default values.
    ///  Normally you will subclass KCoreConfigSkeleton, add data members for the preferences
    ///  settings and register the members in the constructor of the subclass.
    ///  Example:
    ///  <pre>
    ///  class MyPrefs : public KCoreConfigSkeleton
    ///  {
    ///    public      MyPrefs()
    ///      {
    ///        setCurrentGroup("MyGroup");
    ///        addItemBool("MySetting1", mMyBool, false);
    ///        addItemPoint("MySetting2", mMyPoint, QPoint(100, 200));
    ///        setCurrentGroup("MyOtherGroup");
    ///        addItemDouble("MySetting3", mMyDouble, 3.14);
    ///      }
    ///      bool mMyBool;
    ///      QPoint mMyPoint;
    ///      double mMyDouble;
    ///  }
    ///  </pre>
    ///  It might be convenient in many cases to make this subclass of KCoreConfigSkeleton a
    ///  singleton for global access from all over the application without passing
    ///  references to the KCoreConfigSkeleton object around.
    ///  You can write the data to the configuration file by calling <see cref="#writeConfig"></see>
    ///  and read the data from the configuration file by calling <see cref="#readConfig"></see>.
    ///  If you want to watch for config changes, use <see cref="#configChanged"></see> signal.
    ///  If you have items, which are not covered by the existing addItem() functions
    ///  you can add customized code for reading, writing and default setting by
    ///  implementing the functions <see cref="#usrUseDefaults"></see>, <see cref="#usrReadConfig"></see> and
    ///  <see cref="#usrWriteConfig"></see>.
    ///  Internally preferences settings are stored in instances of subclasses of
    ///  <see cref="KConfigSkeletonItem"></see>. You can also add KConfigSkeletonItem subclasses
    ///  for your own types and call the generic <see cref="#addItem"></see> to register them.
    ///  In many cases you don't have to write the specific KCoreConfigSkeleton
    ///  subclasses yourself, but you can use \ref kconfig_compiler to automatically
    ///  generate the C++ code from an XML description of the configuration options.
    ///  Use KConfigSkeleton if you need GUI types as well.
    ///     See <see cref="IKCoreConfigSkeletonSignals"></see> for signals emitted by KCoreConfigSkeleton
    /// </remarks>        <author> Cornelius Schumacher
    /// </author>
    ///         <short> Class for handling preferences settings for an application. </short>
    ///         <see> KConfigSkeletonItem</see>
    [SmokeClass("KCoreConfigSkeleton")]
    public class KCoreConfigSkeleton : QObject, IDisposable {
        protected KCoreConfigSkeleton(Type dummy) : base((Type) null) {}
        /// <remarks>
        ///  Class for handling a string preferences item.
        ///    </remarks>        <short>    Class for handling a string preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemString")]
        public class ItemString : KConfigSkeletonGenericItem, IDisposable {
            protected ItemString(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemString), this);
            }
            public enum TypeOf {
                Normal = 0,
                Password = 1,
                Path = 2,
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem
            /// <param> name="type" The type of string held by the item
            ///      </param></remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemString(string _group, string _key, StringBuilder reference, string defaultValue, KCoreConfigSkeleton.ItemString.TypeOf type) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemString$$$$$", "ItemString(const QString&, const QString&, QString&, const QString&, KCoreConfigSkeleton::ItemString::Type)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(KCoreConfigSkeleton.ItemString.TypeOf), type);
            }
            public ItemString(string _group, string _key, StringBuilder reference, string defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemString$$$$", "ItemString(const QString&, const QString&, QString&, const QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue);
            }
            public ItemString(string _group, string _key, StringBuilder reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemString$$$", "ItemString(const QString&, const QString&, QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
            public void WriteConfig(KConfig config) {
                interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemString() {
                interceptor.Invoke("~ItemString", "~ItemString()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemString", "~ItemString()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a password preferences item.
        ///    </remarks>        <short>    Class for handling a password preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemPassword")]
        public class ItemPassword : KCoreConfigSkeleton.ItemString, IDisposable {
            protected ItemPassword(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemPassword), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemPassword(string _group, string _key, StringBuilder reference, string defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPassword$$$$", "ItemPassword(const QString&, const QString&, QString&, const QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue);
            }
            public ItemPassword(string _group, string _key, StringBuilder reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPassword$$$", "ItemPassword(const QString&, const QString&, QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference);
            }
            ~ItemPassword() {
                interceptor.Invoke("~ItemPassword", "~ItemPassword()", typeof(void));
            }
            public new void Dispose() {
                interceptor.Invoke("~ItemPassword", "~ItemPassword()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a path preferences item.
        ///    </remarks>        <short>    Class for handling a path preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemPath")]
        public class ItemPath : KCoreConfigSkeleton.ItemString, IDisposable {
            protected ItemPath(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemPath), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemPath(string _group, string _key, StringBuilder reference, string defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPath$$$$", "ItemPath(const QString&, const QString&, QString&, const QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference, typeof(string), defaultValue);
            }
            public ItemPath(string _group, string _key, StringBuilder reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPath$$$", "ItemPath(const QString&, const QString&, QString&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(StringBuilder), reference);
            }
            ~ItemPath() {
                interceptor.Invoke("~ItemPath", "~ItemPath()", typeof(void));
            }
            public new void Dispose() {
                interceptor.Invoke("~ItemPath", "~ItemPath()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a url preferences item.
        ///      </remarks>        <short>    Class for handling a url preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemUrl")]
        public class ItemUrl : KConfigSkeletonGenericItem, IDisposable {
            protected ItemUrl(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemUrl), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem
            ///          </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem          </short>
            public ItemUrl(string _group, string _key, KUrl reference, KUrl defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemUrl$$##", "ItemUrl(const QString&, const QString&, KUrl&, const KUrl&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(KUrl), reference, typeof(KUrl), defaultValue);
            }
            public ItemUrl(string _group, string _key, KUrl reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemUrl$$#", "ItemUrl(const QString&, const QString&, KUrl&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(KUrl), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
            public void WriteConfig(KConfig config) {
                interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemUrl() {
                interceptor.Invoke("~ItemUrl", "~ItemUrl()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemUrl", "~ItemUrl()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a QVariant preferences item.
        ///    </remarks>        <short>    Class for handling a QVariant preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemProperty")]
        public class ItemProperty : KConfigSkeletonGenericItem, IDisposable {
            protected ItemProperty(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemProperty), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemProperty(string _group, string _key, QVariant reference, QVariant defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemProperty$$##", "ItemProperty(const QString&, const QString&, QVariant&, const QVariant&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QVariant), reference, typeof(QVariant), defaultValue);
            }
            public ItemProperty(string _group, string _key, QVariant reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemProperty$$#", "ItemProperty(const QString&, const QString&, QVariant&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QVariant), reference);
            }
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemProperty() {
                interceptor.Invoke("~ItemProperty", "~ItemProperty()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemProperty", "~ItemProperty()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a bool preferences item.
        ///    </remarks>        <short>    Class for handling a bool preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemBool")]
        public class ItemBool : KConfigSkeletonGenericItem, IDisposable {
            protected ItemBool(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemBool), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemBool(string _group, string _key, bool reference, bool defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemBool$$$$", "ItemBool(const QString&, const QString&, bool&, bool)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(bool), reference, typeof(bool), defaultValue);
            }
            public ItemBool(string _group, string _key, bool reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemBool$$$", "ItemBool(const QString&, const QString&, bool&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(bool), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemBool() {
                interceptor.Invoke("~ItemBool", "~ItemBool()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemBool", "~ItemBool()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a 32-bit integer preferences item.
        ///    </remarks>        <short>    Class for handling a 32-bit integer preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemInt")]
        public class ItemInt : KConfigSkeletonGenericItem, IDisposable {
            protected ItemInt(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemInt), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemInt(string _group, string _key, ref int reference, int defaultValue) : this((Type) null) {
                CreateProxy();
                StackItem[] stack = new StackItem[5];
    #if DEBUG
                stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(_group);
    #else
                stack[1].s_class = (IntPtr) GCHandle.Alloc(_group);
    #endif
    #if DEBUG
                stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(_key);
    #else
                stack[2].s_class = (IntPtr) GCHandle.Alloc(_key);
    #endif
                stack[3].s_int = reference;
                stack[4].s_int = defaultValue;
                interceptor.Invoke("ItemInt$$$$", "ItemInt(const QString&, const QString&, int&, int)", stack);
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[1].s_class);
    #else
                ((GCHandle) stack[1].s_class).Free();
    #endif
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[2].s_class);
    #else
                ((GCHandle) stack[2].s_class).Free();
    #endif
                reference = stack[3].s_int;
                return;
            }
            public ItemInt(string _group, string _key, ref int reference) : this((Type) null) {
                CreateProxy();
                StackItem[] stack = new StackItem[4];
    #if DEBUG
                stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(_group);
    #else
                stack[1].s_class = (IntPtr) GCHandle.Alloc(_group);
    #endif
    #if DEBUG
                stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(_key);
    #else
                stack[2].s_class = (IntPtr) GCHandle.Alloc(_key);
    #endif
                stack[3].s_int = reference;
                interceptor.Invoke("ItemInt$$$", "ItemInt(const QString&, const QString&, int&)", stack);
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[1].s_class);
    #else
                ((GCHandle) stack[1].s_class).Free();
    #endif
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[2].s_class);
    #else
                ((GCHandle) stack[2].s_class).Free();
    #endif
                reference = stack[3].s_int;
                return;
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            /// <remarks> Get the minimum value that is allowed to be stored in this item </remarks>        <short>   Get the minimum value that is allowed to be stored in this item </short>
            public QVariant MinValue() {
                return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
            }
            /// <remarks> Get the maximum value this is allowed to be stored in this item </remarks>        <short>   Get the maximum value this is allowed to be stored in this item </short>
            public QVariant MaxValue() {
                return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
            }
            /// <remarks> Set the minimum value for the item
            ///         @sa minValue()
            ///      </remarks>        <short>   Set the minimum value for the item         @sa minValue()      </short>
            public void SetMinValue(int arg1) {
                interceptor.Invoke("setMinValue$", "setMinValue(int)", typeof(void), typeof(int), arg1);
            }
            /// <remarks> Set the maximum value for the item
            ///         @sa maxValue
            ///      </remarks>        <short>   Set the maximum value for the item         @sa maxValue      </short>
            public void SetMaxValue(int arg1) {
                interceptor.Invoke("setMaxValue$", "setMaxValue(int)", typeof(void), typeof(int), arg1);
            }
            ~ItemInt() {
                interceptor.Invoke("~ItemInt", "~ItemInt()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemInt", "~ItemInt()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a 64-bit integer preferences item.
        ///    </remarks>        <short>    Class for handling a 64-bit integer preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemLongLong")]
        public class ItemLongLong : KConfigSkeletonGenericItem, IDisposable {
            protected ItemLongLong(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemLongLong), this);
            }
            // KCoreConfigSkeleton::ItemLongLong* ItemLongLong(const QString& arg1,const QString& arg2,qint64& arg3,qint64 arg4); >>>> NOT CONVERTED
            // KCoreConfigSkeleton::ItemLongLong* ItemLongLong(const QString& arg1,const QString& arg2,qint64& arg3); >>>> NOT CONVERTED
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MinValue() </remarks>        <short>   @copydoc ItemInt.MinValue() </short>
            public QVariant MinValue() {
                return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MaxValue() </remarks>        <short>   @copydoc ItemInt.MaxValue() </short>
            public QVariant MaxValue() {
                return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.SetMinValue(qint32) </remarks>        <short>   @copydoc ItemInt.SetMinValue(qint32) </short>
            public void SetMinValue(long arg1) {
                interceptor.Invoke("setMinValue$", "setMinValue(qint64)", typeof(void), typeof(long), arg1);
            }
            /// <remarks> @copydoc ItemInt.SetMaxValue(qint32) </remarks>        <short>   @copydoc ItemInt.SetMaxValue(qint32) </short>
            public void SetMaxValue(long arg1) {
                interceptor.Invoke("setMaxValue$", "setMaxValue(qint64)", typeof(void), typeof(long), arg1);
            }
            ~ItemLongLong() {
                interceptor.Invoke("~ItemLongLong", "~ItemLongLong()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemLongLong", "~ItemLongLong()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling enums.
        ///    </remarks>        <short>    Class for handling enums.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemEnum")]
        public class ItemEnum : KCoreConfigSkeleton.ItemInt, IDisposable {
            protected ItemEnum(Type dummy) : base((Type) null) {}
            [SmokeClass("KCoreConfigSkeleton::ItemEnum::Choice")]
            public class Choice : Object, IDisposable {
                protected SmokeInvocation interceptor = null;
                private IntPtr smokeObject;
                protected Choice(Type dummy) {}
                protected void CreateProxy() {
                    interceptor = new SmokeInvocation(typeof(Choice), this);
                }
                public Choice() : this((Type) null) {
                    CreateProxy();
                    interceptor.Invoke("Choice", "Choice()", typeof(void));
                }
                ~Choice() {
                    interceptor.Invoke("~Choice", "~Choice()", typeof(void));
                }
                public void Dispose() {
                    interceptor.Invoke("~Choice", "~Choice()", typeof(void));
                }
            }
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemEnum), this);
            }
/*
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem
            /// <param> name="choices" The list of enums that can be stored in this item
            ///       </param></remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemEnum(string _group, string _key, ref int reference, List<KCoreConfigSkeleton.ItemEnum.Choice> choices, int defaultValue) : this((Type) null) {
                CreateProxy();
                StackItem[] stack = new StackItem[6];
    #if DEBUG
                stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(_group);
    #else
                stack[1].s_class = (IntPtr) GCHandle.Alloc(_group);
    #endif
    #if DEBUG
                stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(_key);
    #else
                stack[2].s_class = (IntPtr) GCHandle.Alloc(_key);
    #endif
                stack[3].s_int = reference;
                stack[4].s_int = (int) choices;
                stack[5].s_int = defaultValue;
                interceptor.Invoke("ItemEnum$$$?$", "ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&, int)", stack);
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[1].s_class);
    #else
                ((GCHandle) stack[1].s_class).Free();
    #endif
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[2].s_class);
    #else
                ((GCHandle) stack[2].s_class).Free();
    #endif
                reference = stack[3].s_int;
                return;
            }
            public ItemEnum(string _group, string _key, ref int reference, List<KCoreConfigSkeleton.ItemEnum.Choice> choices) : this((Type) null) {
                CreateProxy();
                StackItem[] stack = new StackItem[5];
    #if DEBUG
                stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(_group);
    #else
                stack[1].s_class = (IntPtr) GCHandle.Alloc(_group);
    #endif
    #if DEBUG
                stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(_key);
    #else
                stack[2].s_class = (IntPtr) GCHandle.Alloc(_key);
    #endif
                stack[3].s_int = reference;
                stack[4].s_int = (int) choices;
                interceptor.Invoke("ItemEnum$$$?", "ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&)", stack);
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[1].s_class);
    #else
                ((GCHandle) stack[1].s_class).Free();
    #endif
    #if DEBUG
                DebugGCHandle.Free((GCHandle) stack[2].s_class);
    #else
                ((GCHandle) stack[2].s_class).Free();
    #endif
                reference = stack[3].s_int;
                return;
            }
*/
            public List<KCoreConfigSkeleton.ItemEnum.Choice> Choices() {
                return (List<KCoreConfigSkeleton.ItemEnum.Choice>) interceptor.Invoke("choices", "choices() const", typeof(List<KCoreConfigSkeleton.ItemEnum.Choice>));
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public new void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
            public void WriteConfig(KConfig config) {
                interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            ~ItemEnum() {
                interceptor.Invoke("~ItemEnum", "~ItemEnum()", typeof(void));
            }
            public new void Dispose() {
                interceptor.Invoke("~ItemEnum", "~ItemEnum()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling an unsigned 32-bit integer preferences item.
        ///    </remarks>        <short>    Class for handling an unsigned 32-bit integer preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemUInt")]
        public class ItemUInt : KConfigSkeletonGenericItem, IDisposable {
            protected ItemUInt(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemUInt), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemUInt(string _group, string _key, uint reference, uint defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemUInt$$$$", "ItemUInt(const QString&, const QString&, unsigned int&, unsigned int)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(uint), reference, typeof(uint), defaultValue);
            }
            public ItemUInt(string _group, string _key, uint reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemUInt$$$", "ItemUInt(const QString&, const QString&, unsigned int&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(uint), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MinValue() </remarks>        <short>   @copydoc ItemInt.MinValue() </short>
            public QVariant MinValue() {
                return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MaxValue() </remarks>        <short>   @copydoc ItemInt.MaxValue() </short>
            public QVariant MaxValue() {
                return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.SetMinValue(qint32) </remarks>        <short>   @copydoc ItemInt.SetMinValue(qint32) </short>
            public void SetMinValue(uint arg1) {
                interceptor.Invoke("setMinValue$", "setMinValue(unsigned int)", typeof(void), typeof(uint), arg1);
            }
            /// <remarks> @copydoc ItemInt.SetMaxValue(qint32) </remarks>        <short>   @copydoc ItemInt.SetMaxValue(qint32) </short>
            public void SetMaxValue(uint arg1) {
                interceptor.Invoke("setMaxValue$", "setMaxValue(unsigned int)", typeof(void), typeof(uint), arg1);
            }
            ~ItemUInt() {
                interceptor.Invoke("~ItemUInt", "~ItemUInt()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemUInt", "~ItemUInt()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling unsigned 64-bit integer preferences item.
        ///    </remarks>        <short>    Class for handling unsigned 64-bit integer preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemULongLong")]
        public class ItemULongLong : KConfigSkeletonGenericItem, IDisposable {
            protected ItemULongLong(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemULongLong), this);
            }
            // KCoreConfigSkeleton::ItemULongLong* ItemULongLong(const QString& arg1,const QString& arg2,quint64& arg3,quint64 arg4); >>>> NOT CONVERTED
            // KCoreConfigSkeleton::ItemULongLong* ItemULongLong(const QString& arg1,const QString& arg2,quint64& arg3); >>>> NOT CONVERTED
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MinValue() </remarks>        <short>   @copydoc ItemInt.MinValue() </short>
            public QVariant MinValue() {
                return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MaxValue() </remarks>        <short>   @copydoc ItemInt.MaxValue() </short>
            public QVariant MaxValue() {
                return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.SetMinValue(qint32) </remarks>        <short>   @copydoc ItemInt.SetMinValue(qint32) </short>
            public void SetMinValue(ulong arg1) {
                interceptor.Invoke("setMinValue$", "setMinValue(quint64)", typeof(void), typeof(ulong), arg1);
            }
            /// <remarks> @copydoc ItemInt.SetMaxValue(qint32) </remarks>        <short>   @copydoc ItemInt.SetMaxValue(qint32) </short>
            public void SetMaxValue(ulong arg1) {
                interceptor.Invoke("setMaxValue$", "setMaxValue(quint64)", typeof(void), typeof(ulong), arg1);
            }
            ~ItemULongLong() {
                interceptor.Invoke("~ItemULongLong", "~ItemULongLong()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemULongLong", "~ItemULongLong()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a floating point preference item.
        ///    </remarks>        <short>    Class for handling a floating point preference item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemDouble")]
        public class ItemDouble : KConfigSkeletonGenericItem, IDisposable {
            protected ItemDouble(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemDouble), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemDouble(string _group, string _key, double reference, double defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemDouble$$$$", "ItemDouble(const QString&, const QString&, double&, double)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(double), reference, typeof(double), defaultValue);
            }
            public ItemDouble(string _group, string _key, double reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemDouble$$$", "ItemDouble(const QString&, const QString&, double&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(double), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MinValue() </remarks>        <short>   @copydoc ItemInt.MinValue() </short>
            public QVariant MinValue() {
                return (QVariant) interceptor.Invoke("minValue", "minValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.MaxValue() </remarks>        <short>   @copydoc ItemInt.MaxValue() </short>
            public QVariant MaxValue() {
                return (QVariant) interceptor.Invoke("maxValue", "maxValue() const", typeof(QVariant));
            }
            /// <remarks> @copydoc ItemInt.SetMinValue() </remarks>        <short>   @copydoc ItemInt.SetMinValue() </short>
            public void SetMinValue(double arg1) {
                interceptor.Invoke("setMinValue$", "setMinValue(double)", typeof(void), typeof(double), arg1);
            }
            /// <remarks> @copydoc ItemInt.SetMaxValue() </remarks>        <short>   @copydoc ItemInt.SetMaxValue() </short>
            public void SetMaxValue(double arg1) {
                interceptor.Invoke("setMaxValue$", "setMaxValue(double)", typeof(void), typeof(double), arg1);
            }
            ~ItemDouble() {
                interceptor.Invoke("~ItemDouble", "~ItemDouble()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemDouble", "~ItemDouble()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a QRect preferences item.
        ///    </remarks>        <short>    Class for handling a QRect preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemRect")]
        public class ItemRect : KConfigSkeletonGenericItem, IDisposable {
            protected ItemRect(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemRect), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemRect(string _group, string _key, QRect reference, QRect defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemRect$$##", "ItemRect(const QString&, const QString&, QRect&, const QRect&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QRect), reference, typeof(QRect), defaultValue);
            }
            public ItemRect(string _group, string _key, QRect reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemRect$$#", "ItemRect(const QString&, const QString&, QRect&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QRect), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemRect() {
                interceptor.Invoke("~ItemRect", "~ItemRect()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemRect", "~ItemRect()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a QPoint preferences item.
        ///    </remarks>        <short>    Class for handling a QPoint preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemPoint")]
        public class ItemPoint : KConfigSkeletonGenericItem, IDisposable {
            protected ItemPoint(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemPoint), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemPoint(string _group, string _key, QPoint reference, QPoint defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPoint$$##", "ItemPoint(const QString&, const QString&, QPoint&, const QPoint&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QPoint), reference, typeof(QPoint), defaultValue);
            }
            public ItemPoint(string _group, string _key, QPoint reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPoint$$#", "ItemPoint(const QString&, const QString&, QPoint&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QPoint), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemPoint() {
                interceptor.Invoke("~ItemPoint", "~ItemPoint()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemPoint", "~ItemPoint()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a QSize preferences item.
        ///    </remarks>        <short>    Class for handling a QSize preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemSize")]
        public class ItemSize : KConfigSkeletonGenericItem, IDisposable {
            protected ItemSize(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemSize), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemSize(string _group, string _key, QSize reference, QSize defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemSize$$##", "ItemSize(const QString&, const QString&, QSize&, const QSize&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QSize), reference, typeof(QSize), defaultValue);
            }
            public ItemSize(string _group, string _key, QSize reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemSize$$#", "ItemSize(const QString&, const QString&, QSize&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QSize), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemSize() {
                interceptor.Invoke("~ItemSize", "~ItemSize()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemSize", "~ItemSize()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a QDateTime preferences item.
        ///    </remarks>        <short>    Class for handling a QDateTime preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemDateTime")]
        public class ItemDateTime : KConfigSkeletonGenericItem, IDisposable {
            protected ItemDateTime(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemDateTime), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemDateTime(string _group, string _key, QDateTime reference, QDateTime defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemDateTime$$##", "ItemDateTime(const QString&, const QString&, QDateTime&, const QDateTime&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QDateTime), reference, typeof(QDateTime), defaultValue);
            }
            public ItemDateTime(string _group, string _key, QDateTime reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemDateTime$$#", "ItemDateTime(const QString&, const QString&, QDateTime&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(QDateTime), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemDateTime() {
                interceptor.Invoke("~ItemDateTime", "~ItemDateTime()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemDateTime", "~ItemDateTime()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a string list preferences item.
        ///    </remarks>        <short>    Class for handling a string list preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemStringList")]
        public class ItemStringList : KConfigSkeletonGenericItem, IDisposable {
            protected ItemStringList(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemStringList), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemStringList(string _group, string _key, List<string> reference, List<string> defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemStringList$$??", "ItemStringList(const QString&, const QString&, QStringList&, const QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference, typeof(List<string>), defaultValue);
            }
            public ItemStringList(string _group, string _key, List<string> reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemStringList$$?", "ItemStringList(const QString&, const QString&, QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemStringList() {
                interceptor.Invoke("~ItemStringList", "~ItemStringList()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemStringList", "~ItemStringList()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a path list preferences item.
        ///    </remarks>        <short>    Class for handling a path list preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemPathList")]
        public class ItemPathList : KCoreConfigSkeleton.ItemStringList, IDisposable {
            protected ItemPathList(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemPathList), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemPathList(string _group, string _key, List<string> reference, List<string> defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPathList$$??", "ItemPathList(const QString&, const QString&, QStringList&, const QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference, typeof(List<string>), defaultValue);
            }
            public ItemPathList(string _group, string _key, List<string> reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemPathList$$?", "ItemPathList(const QString&, const QString&, QStringList&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<string>), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig </short>
            public new void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.WriteConfig </remarks>        <short>   @copydoc KConfigSkeletonItem.WriteConfig </short>
            public void WriteConfig(KConfig config) {
                interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            ~ItemPathList() {
                interceptor.Invoke("~ItemPathList", "~ItemPathList()", typeof(void));
            }
            public new void Dispose() {
                interceptor.Invoke("~ItemPathList", "~ItemPathList()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling a url list preferences item.
        ///      </remarks>        <short>    Class for handling a url list preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemUrlList")]
        public class ItemUrlList : KConfigSkeletonGenericItem, IDisposable {
            protected ItemUrlList(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemUrlList), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemUrlList(string _group, string _key, List<KUrl> reference, List<KUrl> defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemUrlList$$??", "ItemUrlList(const QString&, const QString&, KUrl::List&, const KUrl::List&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<KUrl>), reference, typeof(List<KUrl>), defaultValue);
            }
            public ItemUrlList(string _group, string _key, List<KUrl> reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemUrlList$$?", "ItemUrlList(const QString&, const QString&, KUrl::List&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<KUrl>), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.WriteConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.WriteConfig(KConfig ) </short>
            public void WriteConfig(KConfig config) {
                interceptor.Invoke("writeConfig#", "writeConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemUrlList() {
                interceptor.Invoke("~ItemUrlList", "~ItemUrlList()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemUrlList", "~ItemUrlList()", typeof(void));
            }
        }
        /// <remarks>
        ///  Class for handling an integer list preferences item.
        ///    </remarks>        <short>    Class for handling an integer list preferences item.</short>
        [SmokeClass("KCoreConfigSkeleton::ItemIntList")]
        public class ItemIntList : KConfigSkeletonGenericItem, IDisposable {
            protected ItemIntList(Type dummy) : base((Type) null) {}
            protected new void CreateProxy() {
                interceptor = new SmokeInvocation(typeof(ItemIntList), this);
            }
            /// <remarks> @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </remarks>        <short>   @copydoc KConfigSkeletonGenericItem.KConfigSkeletonGenericItem </short>
            public ItemIntList(string _group, string _key, List<int> reference, List<int> defaultValue) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemIntList$$??", "ItemIntList(const QString&, const QString&, QList<int>&, const QList<int>&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<int>), reference, typeof(List<int>), defaultValue);
            }
            public ItemIntList(string _group, string _key, List<int> reference) : this((Type) null) {
                CreateProxy();
                interceptor.Invoke("ItemIntList$$?", "ItemIntList(const QString&, const QString&, QList<int>&)", typeof(void), typeof(string), _group, typeof(string), _key, typeof(List<int>), reference);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.ReadConfig(KConfig) </remarks>        <short>   @copydoc KConfigSkeletonItem.ReadConfig(KConfig ) </short>
            public void ReadConfig(KConfig config) {
                interceptor.Invoke("readConfig#", "readConfig(KConfig*)", typeof(void), typeof(KConfig), config);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.SetProperty(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.SetProperty(QVariant) </short>
            public void SetProperty(QVariant p) {
                interceptor.Invoke("setProperty#", "setProperty(const QVariant&)", typeof(void), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.IsEqual(QVariant) </remarks>        <short>   @copydoc KConfigSkeletonItem.IsEqual(QVariant) </short>
            public bool IsEqual(QVariant p) {
                return (bool) interceptor.Invoke("isEqual#", "isEqual(const QVariant&) const", typeof(bool), typeof(QVariant), p);
            }
            /// <remarks> @copydoc KConfigSkeletonItem.Property() </remarks>        <short>   @copydoc KConfigSkeletonItem.Property() </short>
            public QVariant Property() {
                return (QVariant) interceptor.Invoke("property", "property() const", typeof(QVariant));
            }
            ~ItemIntList() {
                interceptor.Invoke("~ItemIntList", "~ItemIntList()", typeof(void));
            }
            public void Dispose() {
                interceptor.Invoke("~ItemIntList", "~ItemIntList()", typeof(void));
            }
        }
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KCoreConfigSkeleton), this);
        }
        // KCoreConfigSkeleton::ItemLongLong* addItemLongLong(const QString& arg1,qint64& arg2,qint64 arg3,const QString& arg4); >>>> NOT CONVERTED
        // KCoreConfigSkeleton::ItemLongLong* addItemLongLong(const QString& arg1,qint64& arg2,qint64 arg3); >>>> NOT CONVERTED
        // KCoreConfigSkeleton::ItemLongLong* addItemLongLong(const QString& arg1,qint64& arg2); >>>> NOT CONVERTED
        // KCoreConfigSkeleton::ItemULongLong* addItemULongLong(const QString& arg1,quint64& arg2,quint64 arg3,const QString& arg4); >>>> NOT CONVERTED
        // KCoreConfigSkeleton::ItemULongLong* addItemULongLong(const QString& arg1,quint64& arg2,quint64 arg3); >>>> NOT CONVERTED
        // KCoreConfigSkeleton::ItemULongLong* addItemULongLong(const QString& arg1,quint64& arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  Constructor.
        /// <param> name="configname" name of config file. If no name is given, the default
        ///  config file as returned by KGlobal.Config() is used.
        ///    </param></remarks>        <short>    Constructor.</short>
        public KCoreConfigSkeleton(string configname, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCoreConfigSkeleton$#", "KCoreConfigSkeleton(const QString&, QObject*)", typeof(void), typeof(string), configname, typeof(QObject), parent);
        }
        public KCoreConfigSkeleton(string configname) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCoreConfigSkeleton$", "KCoreConfigSkeleton(const QString&)", typeof(void), typeof(string), configname);
        }
        public KCoreConfigSkeleton() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCoreConfigSkeleton", "KCoreConfigSkeleton()", typeof(void));
        }
        /// <remarks>
        ///  Constructor.
        /// <param> name="config" configuration object to use.
        ///    </param></remarks>        <short>    Constructor.</short>
        public KCoreConfigSkeleton(KSharedConfig config, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCoreConfigSkeleton?#", "KCoreConfigSkeleton(KSharedPtr<KSharedConfig>, QObject*)", typeof(void), typeof(KSharedConfig), config, typeof(QObject), parent);
        }
        public KCoreConfigSkeleton(KSharedConfig config) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCoreConfigSkeleton?", "KCoreConfigSkeleton(KSharedPtr<KSharedConfig>)", typeof(void), typeof(KSharedConfig), config);
        }
        /// <remarks>
        ///  Set all registered items to their default values.
        ///  This method calls usrSetDefaults() after setting the defaults for the
        ///  registered items. You can overridde usrSetDefaults() in derived classes
        ///  if you have special requirements.
        ///  If you need more fine-grained control of setting the default values of
        ///  the registered items you can override setDefaults() in a derived class.
        ///    </remarks>        <short>    Set all registered items to their default values.</short>
        [SmokeMethod("setDefaults()")]
        public virtual void SetDefaults() {
            interceptor.Invoke("setDefaults", "setDefaults()", typeof(void));
        }
        /// <remarks>
        ///  Read preferences from config file. All registered items are set to the
        ///  values read from disk.
        ///  This method calls usrReadConfig() after reading the settings of the
        ///  registered items from the KConfig. You can overridde usrReadConfig()
        ///  in derived classes if you have special requirements.
        ///  If you need more fine-grained control of storing the settings from
        ///  the registered items you can override readConfig() in a derived class.
        ///    </remarks>        <short>    Read preferences from config file.</short>
        [SmokeMethod("readConfig()")]
        public virtual void ReadConfig() {
            interceptor.Invoke("readConfig", "readConfig()", typeof(void));
        }
        /// <remarks>
        ///  Write preferences to config file. The values of all registered items are
        ///  written to disk.
        ///  This method calls usrWriteConfig() after writing the settings from the
        ///  registered items to the KConfig. You can overridde usrWriteConfig()
        ///  in derived classes if you have special requirements.
        ///  If you need more fine-grained control of storing the settings from
        ///  the registered items you can override writeConfig() in a derived class.
        ///    </remarks>        <short>    Write preferences to config file.</short>
        [SmokeMethod("writeConfig()")]
        public virtual void WriteConfig() {
            interceptor.Invoke("writeConfig", "writeConfig()", typeof(void));
        }
        /// <remarks>
        ///  Set the config file group for subsequent addItem() calls. It is valid
        ///  until setCurrentGroup() is called with a new argument. Call this before
        ///  you add any items. The default value is "No Group".
        ///    </remarks>        <short>    Set the config file group for subsequent addItem() calls.</short>
        public void SetCurrentGroup(string group) {
            interceptor.Invoke("setCurrentGroup$", "setCurrentGroup(const QString&)", typeof(void), typeof(string), group);
        }
        /// <remarks>
        ///  Returns the current group used for addItem() calls.
        ///    </remarks>        <short>    Returns the current group used for addItem() calls.</short>
        public string CurrentGroup() {
            return (string) interceptor.Invoke("currentGroup", "currentGroup() const", typeof(string));
        }
        /// <remarks>
        ///  Register a custom <see cref="KConfigSkeletonItem"></see> with a given name. If the name
        ///  parameter is null, take the name from KConfigSkeletonItem.Key().
        ///  Note that all names must be unique but that multiple entries can have
        ///  the same key if they reside in different groups.
        ///    </remarks>        <short>    Register a custom @ref KConfigSkeletonItem with a given name.</short>
        public void AddItem(KConfigSkeletonItem arg1, string name) {
            interceptor.Invoke("addItem#$", "addItem(KConfigSkeletonItem*, const QString&)", typeof(void), typeof(KConfigSkeletonItem), arg1, typeof(string), name);
        }
        public void AddItem(KConfigSkeletonItem arg1) {
            interceptor.Invoke("addItem#", "addItem(KConfigSkeletonItem*)", typeof(void), typeof(KConfigSkeletonItem), arg1);
        }
        /// <remarks>
        ///  Register an item of type string.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type string.</short>
        public KCoreConfigSkeleton.ItemString AddItemString(string name, StringBuilder reference, string defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemString) interceptor.Invoke("addItemString$$$$", "addItemString(const QString&, QString&, const QString&, const QString&)", typeof(KCoreConfigSkeleton.ItemString), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemString AddItemString(string name, StringBuilder reference, string defaultValue) {
            return (KCoreConfigSkeleton.ItemString) interceptor.Invoke("addItemString$$$", "addItemString(const QString&, QString&, const QString&)", typeof(KCoreConfigSkeleton.ItemString), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue);
        }
        public KCoreConfigSkeleton.ItemString AddItemString(string name, StringBuilder reference) {
            return (KCoreConfigSkeleton.ItemString) interceptor.Invoke("addItemString$$", "addItemString(const QString&, QString&)", typeof(KCoreConfigSkeleton.ItemString), typeof(string), name, typeof(StringBuilder), reference);
        }
        /// <remarks>
        ///  Register a password item of type string. The string value is written
        ///  encrypted to the config file. Note that the current encryption scheme
        ///  is very weak.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register a password item of type string.</short>
        public KCoreConfigSkeleton.ItemPassword AddItemPassword(string name, StringBuilder reference, string defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemPassword) interceptor.Invoke("addItemPassword$$$$", "addItemPassword(const QString&, QString&, const QString&, const QString&)", typeof(KCoreConfigSkeleton.ItemPassword), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemPassword AddItemPassword(string name, StringBuilder reference, string defaultValue) {
            return (KCoreConfigSkeleton.ItemPassword) interceptor.Invoke("addItemPassword$$$", "addItemPassword(const QString&, QString&, const QString&)", typeof(KCoreConfigSkeleton.ItemPassword), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue);
        }
        public KCoreConfigSkeleton.ItemPassword AddItemPassword(string name, StringBuilder reference) {
            return (KCoreConfigSkeleton.ItemPassword) interceptor.Invoke("addItemPassword$$", "addItemPassword(const QString&, QString&)", typeof(KCoreConfigSkeleton.ItemPassword), typeof(string), name, typeof(StringBuilder), reference);
        }
        /// <remarks>
        ///  Register a path item of type string. The string value is interpreted
        ///  as a path. This means, dollar expension is activated for this value, so
        ///  that e.g. $HOME gets expanded.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register a path item of type string.</short>
        public KCoreConfigSkeleton.ItemPath AddItemPath(string name, StringBuilder reference, string defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemPath) interceptor.Invoke("addItemPath$$$$", "addItemPath(const QString&, QString&, const QString&, const QString&)", typeof(KCoreConfigSkeleton.ItemPath), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemPath AddItemPath(string name, StringBuilder reference, string defaultValue) {
            return (KCoreConfigSkeleton.ItemPath) interceptor.Invoke("addItemPath$$$", "addItemPath(const QString&, QString&, const QString&)", typeof(KCoreConfigSkeleton.ItemPath), typeof(string), name, typeof(StringBuilder), reference, typeof(string), defaultValue);
        }
        public KCoreConfigSkeleton.ItemPath AddItemPath(string name, StringBuilder reference) {
            return (KCoreConfigSkeleton.ItemPath) interceptor.Invoke("addItemPath$$", "addItemPath(const QString&, QString&)", typeof(KCoreConfigSkeleton.ItemPath), typeof(string), name, typeof(StringBuilder), reference);
        }
        /// <remarks>
        ///  Register a property item of type QVariant. Note that only the following
        ///  QVariant types are allowed: String, StringList, Font, Point, Rect, Size,
        ///  Color, Int, UInt, Bool, Double, DateTime and Date.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register a property item of type QVariant.</short>
        public KCoreConfigSkeleton.ItemProperty AddItemProperty(string name, QVariant reference, QVariant defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemProperty) interceptor.Invoke("addItemProperty$##$", "addItemProperty(const QString&, QVariant&, const QVariant&, const QString&)", typeof(KCoreConfigSkeleton.ItemProperty), typeof(string), name, typeof(QVariant), reference, typeof(QVariant), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemProperty AddItemProperty(string name, QVariant reference, QVariant defaultValue) {
            return (KCoreConfigSkeleton.ItemProperty) interceptor.Invoke("addItemProperty$##", "addItemProperty(const QString&, QVariant&, const QVariant&)", typeof(KCoreConfigSkeleton.ItemProperty), typeof(string), name, typeof(QVariant), reference, typeof(QVariant), defaultValue);
        }
        public KCoreConfigSkeleton.ItemProperty AddItemProperty(string name, QVariant reference) {
            return (KCoreConfigSkeleton.ItemProperty) interceptor.Invoke("addItemProperty$#", "addItemProperty(const QString&, QVariant&)", typeof(KCoreConfigSkeleton.ItemProperty), typeof(string), name, typeof(QVariant), reference);
        }
        /// <remarks>
        ///  Register an item of type bool.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type bool.</short>
        public KCoreConfigSkeleton.ItemBool AddItemBool(string name, bool reference, bool defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemBool) interceptor.Invoke("addItemBool$$$$", "addItemBool(const QString&, bool&, bool, const QString&)", typeof(KCoreConfigSkeleton.ItemBool), typeof(string), name, typeof(bool), reference, typeof(bool), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemBool AddItemBool(string name, bool reference, bool defaultValue) {
            return (KCoreConfigSkeleton.ItemBool) interceptor.Invoke("addItemBool$$$", "addItemBool(const QString&, bool&, bool)", typeof(KCoreConfigSkeleton.ItemBool), typeof(string), name, typeof(bool), reference, typeof(bool), defaultValue);
        }
        public KCoreConfigSkeleton.ItemBool AddItemBool(string name, bool reference) {
            return (KCoreConfigSkeleton.ItemBool) interceptor.Invoke("addItemBool$$", "addItemBool(const QString&, bool&)", typeof(KCoreConfigSkeleton.ItemBool), typeof(string), name, typeof(bool), reference);
        }
        /// <remarks>
        ///  Register an item of type qint32.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type qint32.</short>
        public KCoreConfigSkeleton.ItemInt AddItemInt(string name, ref int reference, int defaultValue, string key) {
            StackItem[] stack = new StackItem[5];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(name);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(name);
#endif
            stack[2].s_int = reference;
            stack[3].s_int = defaultValue;
#if DEBUG
            stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(key);
#else
            stack[4].s_class = (IntPtr) GCHandle.Alloc(key);
#endif
            interceptor.Invoke("addItemInt$$$$", "addItemInt(const QString&, int&, int, const QString&)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
            reference = stack[2].s_int;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
            ((GCHandle) stack[4].s_class).Free();
#endif
            return (KCoreConfigSkeleton.ItemInt) Enum.ToObject(typeof(KCoreConfigSkeleton.ItemInt), stack[0].s_int);
        }
        public KCoreConfigSkeleton.ItemInt AddItemInt(string name, ref int reference, int defaultValue) {
            StackItem[] stack = new StackItem[4];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(name);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(name);
#endif
            stack[2].s_int = reference;
            stack[3].s_int = defaultValue;
            interceptor.Invoke("addItemInt$$$", "addItemInt(const QString&, int&, int)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
            reference = stack[2].s_int;
            return (KCoreConfigSkeleton.ItemInt) Enum.ToObject(typeof(KCoreConfigSkeleton.ItemInt), stack[0].s_int);
        }
        public KCoreConfigSkeleton.ItemInt AddItemInt(string name, ref int reference) {
            StackItem[] stack = new StackItem[3];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(name);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(name);
#endif
            stack[2].s_int = reference;
            interceptor.Invoke("addItemInt$$", "addItemInt(const QString&, int&)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
            reference = stack[2].s_int;
            return (KCoreConfigSkeleton.ItemInt) Enum.ToObject(typeof(KCoreConfigSkeleton.ItemInt), stack[0].s_int);
        }
        /// <remarks>
        ///  Register an item of type quint32.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type quint32.</short>
        public KCoreConfigSkeleton.ItemUInt AddItemUInt(string name, uint reference, uint defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemUInt) interceptor.Invoke("addItemUInt$$$$", "addItemUInt(const QString&, unsigned int&, unsigned int, const QString&)", typeof(KCoreConfigSkeleton.ItemUInt), typeof(string), name, typeof(uint), reference, typeof(uint), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemUInt AddItemUInt(string name, uint reference, uint defaultValue) {
            return (KCoreConfigSkeleton.ItemUInt) interceptor.Invoke("addItemUInt$$$", "addItemUInt(const QString&, unsigned int&, unsigned int)", typeof(KCoreConfigSkeleton.ItemUInt), typeof(string), name, typeof(uint), reference, typeof(uint), defaultValue);
        }
        public KCoreConfigSkeleton.ItemUInt AddItemUInt(string name, uint reference) {
            return (KCoreConfigSkeleton.ItemUInt) interceptor.Invoke("addItemUInt$$", "addItemUInt(const QString&, unsigned int&)", typeof(KCoreConfigSkeleton.ItemUInt), typeof(string), name, typeof(uint), reference);
        }
        /// <remarks>
        ///  Register an item of type qint64.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type qint64.</short>
        /// <remarks>
        ///  Register an item of type quint64
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type quint64 </short>
        /// <remarks>
        ///  Register an item of type double.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type double.</short>
        public KCoreConfigSkeleton.ItemDouble AddItemDouble(string name, double reference, double defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemDouble) interceptor.Invoke("addItemDouble$$$$", "addItemDouble(const QString&, double&, double, const QString&)", typeof(KCoreConfigSkeleton.ItemDouble), typeof(string), name, typeof(double), reference, typeof(double), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemDouble AddItemDouble(string name, double reference, double defaultValue) {
            return (KCoreConfigSkeleton.ItemDouble) interceptor.Invoke("addItemDouble$$$", "addItemDouble(const QString&, double&, double)", typeof(KCoreConfigSkeleton.ItemDouble), typeof(string), name, typeof(double), reference, typeof(double), defaultValue);
        }
        public KCoreConfigSkeleton.ItemDouble AddItemDouble(string name, double reference) {
            return (KCoreConfigSkeleton.ItemDouble) interceptor.Invoke("addItemDouble$$", "addItemDouble(const QString&, double&)", typeof(KCoreConfigSkeleton.ItemDouble), typeof(string), name, typeof(double), reference);
        }
        /// <remarks>
        ///  Register an item of type QRect.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type QRect.</short>
        public KCoreConfigSkeleton.ItemRect AddItemRect(string name, QRect reference, QRect defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemRect) interceptor.Invoke("addItemRect$##$", "addItemRect(const QString&, QRect&, const QRect&, const QString&)", typeof(KCoreConfigSkeleton.ItemRect), typeof(string), name, typeof(QRect), reference, typeof(QRect), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemRect AddItemRect(string name, QRect reference, QRect defaultValue) {
            return (KCoreConfigSkeleton.ItemRect) interceptor.Invoke("addItemRect$##", "addItemRect(const QString&, QRect&, const QRect&)", typeof(KCoreConfigSkeleton.ItemRect), typeof(string), name, typeof(QRect), reference, typeof(QRect), defaultValue);
        }
        public KCoreConfigSkeleton.ItemRect AddItemRect(string name, QRect reference) {
            return (KCoreConfigSkeleton.ItemRect) interceptor.Invoke("addItemRect$#", "addItemRect(const QString&, QRect&)", typeof(KCoreConfigSkeleton.ItemRect), typeof(string), name, typeof(QRect), reference);
        }
        /// <remarks>
        ///  Register an item of type QPoint.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type QPoint.</short>
        public KCoreConfigSkeleton.ItemPoint AddItemPoint(string name, QPoint reference, QPoint defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemPoint) interceptor.Invoke("addItemPoint$##$", "addItemPoint(const QString&, QPoint&, const QPoint&, const QString&)", typeof(KCoreConfigSkeleton.ItemPoint), typeof(string), name, typeof(QPoint), reference, typeof(QPoint), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemPoint AddItemPoint(string name, QPoint reference, QPoint defaultValue) {
            return (KCoreConfigSkeleton.ItemPoint) interceptor.Invoke("addItemPoint$##", "addItemPoint(const QString&, QPoint&, const QPoint&)", typeof(KCoreConfigSkeleton.ItemPoint), typeof(string), name, typeof(QPoint), reference, typeof(QPoint), defaultValue);
        }
        public KCoreConfigSkeleton.ItemPoint AddItemPoint(string name, QPoint reference) {
            return (KCoreConfigSkeleton.ItemPoint) interceptor.Invoke("addItemPoint$#", "addItemPoint(const QString&, QPoint&)", typeof(KCoreConfigSkeleton.ItemPoint), typeof(string), name, typeof(QPoint), reference);
        }
        /// <remarks>
        ///  Register an item of type QSize.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type QSize.</short>
        public KCoreConfigSkeleton.ItemSize AddItemSize(string name, QSize reference, QSize defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemSize) interceptor.Invoke("addItemSize$##$", "addItemSize(const QString&, QSize&, const QSize&, const QString&)", typeof(KCoreConfigSkeleton.ItemSize), typeof(string), name, typeof(QSize), reference, typeof(QSize), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemSize AddItemSize(string name, QSize reference, QSize defaultValue) {
            return (KCoreConfigSkeleton.ItemSize) interceptor.Invoke("addItemSize$##", "addItemSize(const QString&, QSize&, const QSize&)", typeof(KCoreConfigSkeleton.ItemSize), typeof(string), name, typeof(QSize), reference, typeof(QSize), defaultValue);
        }
        public KCoreConfigSkeleton.ItemSize AddItemSize(string name, QSize reference) {
            return (KCoreConfigSkeleton.ItemSize) interceptor.Invoke("addItemSize$#", "addItemSize(const QString&, QSize&)", typeof(KCoreConfigSkeleton.ItemSize), typeof(string), name, typeof(QSize), reference);
        }
        /// <remarks>
        ///  Register an item of type QDateTime.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type QDateTime.</short>
        public KCoreConfigSkeleton.ItemDateTime AddItemDateTime(string name, QDateTime reference, QDateTime defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemDateTime) interceptor.Invoke("addItemDateTime$##$", "addItemDateTime(const QString&, QDateTime&, const QDateTime&, const QString&)", typeof(KCoreConfigSkeleton.ItemDateTime), typeof(string), name, typeof(QDateTime), reference, typeof(QDateTime), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemDateTime AddItemDateTime(string name, QDateTime reference, QDateTime defaultValue) {
            return (KCoreConfigSkeleton.ItemDateTime) interceptor.Invoke("addItemDateTime$##", "addItemDateTime(const QString&, QDateTime&, const QDateTime&)", typeof(KCoreConfigSkeleton.ItemDateTime), typeof(string), name, typeof(QDateTime), reference, typeof(QDateTime), defaultValue);
        }
        public KCoreConfigSkeleton.ItemDateTime AddItemDateTime(string name, QDateTime reference) {
            return (KCoreConfigSkeleton.ItemDateTime) interceptor.Invoke("addItemDateTime$#", "addItemDateTime(const QString&, QDateTime&)", typeof(KCoreConfigSkeleton.ItemDateTime), typeof(string), name, typeof(QDateTime), reference);
        }
        /// <remarks>
        ///  Register an item of type List<string>.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type List<string>.</short>
        public KCoreConfigSkeleton.ItemStringList AddItemStringList(string name, List<string> reference, List<string> defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemStringList) interceptor.Invoke("addItemStringList$??$", "addItemStringList(const QString&, QStringList&, const QStringList&, const QString&)", typeof(KCoreConfigSkeleton.ItemStringList), typeof(string), name, typeof(List<string>), reference, typeof(List<string>), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemStringList AddItemStringList(string name, List<string> reference, List<string> defaultValue) {
            return (KCoreConfigSkeleton.ItemStringList) interceptor.Invoke("addItemStringList$??", "addItemStringList(const QString&, QStringList&, const QStringList&)", typeof(KCoreConfigSkeleton.ItemStringList), typeof(string), name, typeof(List<string>), reference, typeof(List<string>), defaultValue);
        }
        public KCoreConfigSkeleton.ItemStringList AddItemStringList(string name, List<string> reference) {
            return (KCoreConfigSkeleton.ItemStringList) interceptor.Invoke("addItemStringList$?", "addItemStringList(const QString&, QStringList&)", typeof(KCoreConfigSkeleton.ItemStringList), typeof(string), name, typeof(List<string>), reference);
        }
        /// <remarks>
        ///  Register an item of type QList<int>.
        /// <param> name="name" Name used to identify this setting. Names must be unique.
        /// </param><param> name="reference" Pointer to the variable, which is set by readConfig()
        ///  calls and read by writeConfig() calls.
        /// </param><param> name="defaultValue" Default value, which is used when the config file
        ///  does not yet contain the key of this item.
        /// </param><param> name="key" Key used in config file. If key is null, name is used as key.
        /// </param></remarks>        <return> The created item
        ///    </return>
        ///         <short>    Register an item of type QList<int>.</short>
        public KCoreConfigSkeleton.ItemIntList AddItemIntList(string name, List<int> reference, List<int> defaultValue, string key) {
            return (KCoreConfigSkeleton.ItemIntList) interceptor.Invoke("addItemIntList$??$", "addItemIntList(const QString&, QList<int>&, const QList<int>&, const QString&)", typeof(KCoreConfigSkeleton.ItemIntList), typeof(string), name, typeof(List<int>), reference, typeof(List<int>), defaultValue, typeof(string), key);
        }
        public KCoreConfigSkeleton.ItemIntList AddItemIntList(string name, List<int> reference, List<int> defaultValue) {
            return (KCoreConfigSkeleton.ItemIntList) interceptor.Invoke("addItemIntList$??", "addItemIntList(const QString&, QList<int>&, const QList<int>&)", typeof(KCoreConfigSkeleton.ItemIntList), typeof(string), name, typeof(List<int>), reference, typeof(List<int>), defaultValue);
        }
        public KCoreConfigSkeleton.ItemIntList AddItemIntList(string name, List<int> reference) {
            return (KCoreConfigSkeleton.ItemIntList) interceptor.Invoke("addItemIntList$?", "addItemIntList(const QString&, QList<int>&)", typeof(KCoreConfigSkeleton.ItemIntList), typeof(string), name, typeof(List<int>), reference);
        }
        /// <remarks>
        ///  Return the <see cref="KConfig"></see> object used for reading and writing the settings.
        ///    </remarks>        <short>    Return the @ref KConfig object used for reading and writing the settings.</short>
        public KConfig Config() {
            return (KConfig) interceptor.Invoke("config", "config()", typeof(KConfig));
        }
        /// <remarks>
        ///  Set the <see cref="KSharedConfig"></see> object used for reading and writing the settings.
        ///    </remarks>        <short>    Set the @ref KSharedConfig object used for reading and writing the settings.</short>
        public void SetSharedConfig(KSharedConfig pConfig) {
            interceptor.Invoke("setSharedConfig?", "setSharedConfig(KSharedPtr<KSharedConfig>)", typeof(void), typeof(KSharedConfig), pConfig);
        }
        /// <remarks>
        ///  Return list of items managed by this KCoreConfigSkeleton object.
        ///    </remarks>        <short>    Return list of items managed by this KCoreConfigSkeleton object.</short>
        public List<KConfigSkeletonItem> Items() {
            return (List<KConfigSkeletonItem>) interceptor.Invoke("items", "items() const", typeof(List<KConfigSkeletonItem>));
        }
        /// <remarks>
        ///  Return whether a certain item is immutable
        ///    </remarks>        <short>    Return whether a certain item is immutable    </short>
        public bool IsImmutable(string name) {
            return (bool) interceptor.Invoke("isImmutable$", "isImmutable(const QString&)", typeof(bool), typeof(string), name);
        }
        /// <remarks>
        ///  Lookup item by name
        ///    </remarks>        <short>    Lookup item by name    </short>
        public KConfigSkeletonItem FindItem(string name) {
            return (KConfigSkeletonItem) interceptor.Invoke("findItem$", "findItem(const QString&)", typeof(KConfigSkeletonItem), typeof(string), name);
        }
        /// <remarks>
        ///  Specify whether this object should reflect the actual values or the
        ///  default values.
        ///  This method is implemented by usrUseDefaults(), which can be overridden
        ///  in derived classes if you have special requirements and can call
        ///  usrUseDefaults() directly.
        ///  If you don't have control whether useDefaults() or usrUseDefaults() is
        ///  called override useDefaults() directly.
        /// <param> name="b" true to make this object reflect the default values,
        ///           false to make it reflect the actual values.
        /// </param></remarks>        <return> The state prior to this call
        ///    </return>
        ///         <short>    Specify whether this object should reflect the actual values or the  default values.</short>
        [SmokeMethod("useDefaults(bool)")]
        public virtual bool UseDefaults(bool b) {
            return (bool) interceptor.Invoke("useDefaults$", "useDefaults(bool)", typeof(bool), typeof(bool), b);
        }
        /// <remarks>
        ///  Implemented by subclasses that use special defaults.
        ///  It replaces the default values with the actual values and
        ///  vice versa.  Called from <see cref="#useDefaults"></see>
        /// <param> name="b" true to make this object reflect the default values,
        ///           false to make it reflect the actual values.
        /// </param></remarks>        <return> The state prior to this call
        ///    </return>
        ///         <short>    Implemented by subclasses that use special defaults.</short>
        [SmokeMethod("usrUseDefaults(bool)")]
        protected virtual bool UsrUseDefaults(bool b) {
            return (bool) interceptor.Invoke("usrUseDefaults$", "usrUseDefaults(bool)", typeof(bool), typeof(bool), b);
        }
        /// <remarks>
        ///  Perform the actual setting of default values.
        ///  Override in derived classes to set special default values.
        ///  Called from <see cref="#setDefaults"></see>
        ///    </remarks>        <short>    Perform the actual setting of default values.</short>
        [SmokeMethod("usrSetDefaults()")]
        protected virtual void UsrSetDefaults() {
            interceptor.Invoke("usrSetDefaults", "usrSetDefaults()", typeof(void));
        }
        /// <remarks>
        ///  Perform the actual reading of the configuration file.
        ///  Override in derived classes to read special config values.
        ///  Called from <see cref="#readConfig"></see>
        ///    </remarks>        <short>    Perform the actual reading of the configuration file.</short>
        [SmokeMethod("usrReadConfig()")]
        protected virtual void UsrReadConfig() {
            interceptor.Invoke("usrReadConfig", "usrReadConfig()", typeof(void));
        }
        /// <remarks>
        ///  Perform the actual writing of the configuration file.
        ///  Override in derived classes to write special config values.
        ///  Called from <see cref="#writeConfig"></see>
        ///    </remarks>        <short>    Perform the actual writing of the configuration file.</short>
        [SmokeMethod("usrWriteConfig()")]
        protected virtual void UsrWriteConfig() {
            interceptor.Invoke("usrWriteConfig", "usrWriteConfig()", typeof(void));
        }
        ~KCoreConfigSkeleton() {
            interceptor.Invoke("~KCoreConfigSkeleton", "~KCoreConfigSkeleton()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KCoreConfigSkeleton", "~KCoreConfigSkeleton()", typeof(void));
        }
        protected new IKCoreConfigSkeletonSignals Emit {
            get { return (IKCoreConfigSkeletonSignals) Q_EMIT; }
        }
    }

    public interface IKCoreConfigSkeletonSignals : IQObjectSignals {
        /// <remarks>
        ///  This signal is emitted when the configuration change.
        ///    </remarks>        <short>    This signal is emitted when the configuration change.</short>
        [Q_SIGNAL("void configChanged()")]
        void ConfigChanged();
    }
}
