//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief Mark extension interface for the Document.
    ///  \ingroup kte_group_doc_extensions
    ///  \section markext_intro Introduction
    ///  The MarkInterface provides methods to enable and disable marks in a
    ///  Document, a marked line can be visualized for example with a shaded
    ///  background color and/or a pixmap in the iconborder of the Document's View.
    ///  There are a number of predefined mark types, specified in
    ///  reservedMarkersCount(). Additionally it is possible to add custom marks
    ///  and set custom pixmaps.
    ///  \section markext_access Accessing the Interface
    ///  The MarkInterface is supposed to be an extension interface for a Document,
    ///  i.e. the Document inherits the interface \e provided that the
    ///  KTextEditor library in use implements the interface. Use qobject_cast to access
    ///  the interface:
    ///  <pre>
    ///  // doc is of type KTextEditor.Document
    ///  KTextEditor.MarkInterface iface =
    ///      qobject_cast<KTextEditor.MarkInterface>( doc );
    ///  if( iface ) {
    ///      // the implementation supports the interface
    ///      // do stuff
    ///  }
    ///  </pre>
    ///  \section markext_handling Handling Marks
    ///  Get all marks in the document by calling marks(). Use clearMarks() to
    ///  remove all marks in the entire document. A single mark can be retrieved
    ///  with mark(). To remove all marks from a line call clearMark(). To add
    ///  and remove marks from a given line use addMark() and removeMark(). It is
    ///  also possible to replace all marks with setMark(), i.e. setMark() is the
    ///  same as a call of clearMark() followed by addMark(). The signals
    ///  marksChanged() and markChanged() are emitted whenever a line's marks
    ///  changed.
    ///  \attention A mark type is represented as an \e uint. An \e uint can have
    ///      several mark types combined (see above: logical OR). That means for
    ///      all functions/signals with an \e uint parameter, e.g. setMark(),
    ///      removeMark(), etc, the \e uint may contain \e multiple marks, i.e.
    ///      you can add and remove multiple marks \e simultaneously.
    ///  \section markext_userdefined User Defined Marks
    ///  All marks that should be editable by the user can be specified with a mark
    ///  mask via setEditableMarks(). To set a description and pixmap of a mark type
    ///  call setMarkDescription() and setMarkPixmap().
    ///  \see KTextEditor.Document, KTextEditor.Mark
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief Mark extension interface for the Document.</short>
    [SmokeClass("KTextEditor::MarkInterface")]
    public class MarkInterface : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected MarkInterface(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(MarkInterface), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static MarkInterface() {
            staticInterceptor = new SmokeInvocation(typeof(MarkInterface), null);
        }
        /// <remarks>
        ///  Predefined mark types.
        ///  To add a new standard mark type, edit this interface and document
        ///  the type.
        ///      </remarks>        <short>    Predefined mark types.</short>
        public enum MarkTypes : uint {
            markType01 = 0x1,
            markType02 = 0x2,
            markType03 = 0x4,
            markType04 = 0x8,
            markType05 = 0x10,
            markType06 = 0x20,
            markType07 = 0x40,
            markType08 = 0x80,
            markType09 = 0x100,
            markType10 = 0x200,
            markType11 = 0x400,
            markType12 = 0x800,
            markType13 = 0x1000,
            markType14 = 0x2000,
            markType15 = 0x4000,
            markType16 = 0x8000,
            markType17 = 0x10000,
            markType18 = 0x20000,
            markType19 = 0x40000,
            markType20 = 0x80000,
            markType21 = 0x100000,
            markType22 = 0x200000,
            markType23 = 0x400000,
            markType24 = 0x800000,
            markType25 = 0x1000000,
            markType26 = 0x2000000,
            markType27 = 0x4000000,
            markType28 = 0x8000000,
            markType29 = 0x10000000,
            markType30 = 0x20000000,
            markType31 = 0x40000000,
            markType32 = 0x80000000,
            Bookmark = markType01,
            BreakpointActive = markType02,
            BreakpointReached = markType03,
            BreakpointDisabled = markType04,
            Execution = markType05,
            Warning = markType06,
            Error = markType07,
        }
        /// <remarks>
        ///  Possible actions on a mark.
        ///  \see markChanged()
        ///      </remarks>        <short>    Possible actions on a mark.</short>
        public enum MarkChangeAction {
            MarkAdded = 0,
            MarkRemoved = 1,
        }
        // const QHash<int, KTextEditor::Mark*>& marks(); >>>> NOT CONVERTED
        public MarkInterface() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("MarkInterface", "MarkInterface()", typeof(void));
        }
        /// <remarks>
        ///  Get all marks set on the <pre>line</pre>.
        ///  \param line requested line
        ///  \return a \e uint representing of the marks set in <pre>line</pre> concatenated
        ///          by logical OR
        ///  \see addMark(), removeMark()
        ///      </remarks>        <short>    Get all marks set on the \p line.</short>
        [SmokeMethod("mark(int)")]
        public virtual uint Mark(int line) {
            return (uint) interceptor.Invoke("mark$", "mark(int)", typeof(uint), typeof(int), line);
        }
        /// <remarks>
        ///  Set the <pre>line</pre>'s mark types to <pre>markType</pre>.
        ///  If <pre>line</pre> already contains a mark of the given type it has no effect.
        ///  All other marks are deleted before the mark is set. You can achieve
        ///  the same by calling
        ///  <pre>
        ///  clearMark(line);
        ///  addMark(line, markType);
        ///  </pre>
        ///  \param line line to set the mark
        ///  \param markType mark type
        ///  \see clearMark(), addMark(), mark()
        ///      </remarks>        <short>    Set the \p line's mark types to \p markType.</short>
        [SmokeMethod("setMark(int, uint)")]
        public virtual void SetMark(int line, uint markType) {
            interceptor.Invoke("setMark$$", "setMark(int, uint)", typeof(void), typeof(int), line, typeof(uint), markType);
        }
        /// <remarks>
        ///  Clear all marks set in the <pre>line</pre>.
        ///  \param line line to clear marks
        ///  \see clearMarks(), removeMark(), addMark()
        ///      </remarks>        <short>    Clear all marks set in the \p line.</short>
        [SmokeMethod("clearMark(int)")]
        public virtual void ClearMark(int line) {
            interceptor.Invoke("clearMark$", "clearMark(int)", typeof(void), typeof(int), line);
        }
        /// <remarks>
        ///  Add marks of type <pre>markType</pre> to <pre>line</pre>. Existing marks on this line
        ///  are preserved. If the mark <pre>markType</pre> already is set, nothing
        ///  happens.
        ///  \param line line to set the mark
        ///  \param markType mark type
        ///  \see removeMark(), setMark()
        ///      </remarks>        <short>    Add marks of type \p markType to \p line.</short>
        [SmokeMethod("addMark(int, uint)")]
        public virtual void AddMark(int line, uint markType) {
            interceptor.Invoke("addMark$$", "addMark(int, uint)", typeof(void), typeof(int), line, typeof(uint), markType);
        }
        /// <remarks>
        ///  Remove the mark mask of type <pre>markType</pre> from <pre>line</pre>.
        ///  \param line line to remove the mark
        ///  \param markType mark type to be removed
        ///  \see clearMark()
        ///      </remarks>        <short>    Remove the mark mask of type \p markType from \p line.</short>
        [SmokeMethod("removeMark(int, uint)")]
        public virtual void RemoveMark(int line, uint markType) {
            interceptor.Invoke("removeMark$$", "removeMark(int, uint)", typeof(void), typeof(int), line, typeof(uint), markType);
        }
        /// <remarks>
        ///  Get a hash holding all marks in the document.
        ///  The hash key for a mark is its line.
        ///  \return a hash holding all marks in the document
        ///      </remarks>        <short>    Get a hash holding all marks in the document.</short>
        /// <remarks>
        ///  Clear all marks in the entire document.
        ///  \see clearMark(), removeMark()
        ///      </remarks>        <short>    Clear all marks in the entire document.</short>
        [SmokeMethod("clearMarks()")]
        public virtual void ClearMarks() {
            interceptor.Invoke("clearMarks", "clearMarks()", typeof(void));
        }
        /// <remarks>
        ///  The <pre>document</pre> emits this signal whenever a mark mask changed.
        ///  \param document document which emitted this signal
        ///  \see markChanged()
        ///      </remarks>        <short>    The \p document emits this signal whenever a mark mask changed.</short>
        [SmokeMethod("marksChanged(KTextEditor::Document*)")]
        public virtual void MarksChanged(KTextEditor.Document document) {
            interceptor.Invoke("marksChanged#", "marksChanged(KTextEditor::Document*)", typeof(void), typeof(KTextEditor.Document), document);
        }
        /// <remarks>
        ///  Set the <pre>mark</pre>'s pixmap to <pre>pixmap</pre>.
        ///  \param mark mark to which the pixmap will be attached
        ///  \param pixmap new pixmap
        ///  \see setMarkDescription()
        ///      </remarks>        <short>    Set the \p mark's pixmap to \p pixmap.</short>
        [SmokeMethod("setMarkPixmap(KTextEditor::MarkInterface::MarkTypes, const QPixmap&)")]
        public virtual void SetMarkPixmap(KTextEditor.MarkInterface.MarkTypes mark, QPixmap pixmap) {
            interceptor.Invoke("setMarkPixmap$#", "setMarkPixmap(KTextEditor::MarkInterface::MarkTypes, const QPixmap&)", typeof(void), typeof(KTextEditor.MarkInterface.MarkTypes), mark, typeof(QPixmap), pixmap);
        }
        /// <remarks>
        ///  Get the <pre>mark</pre>'s pixmap.
        ///  \param mark mark type. If the pixmap does not exist the resulting is null
        ///         (check with QPixmap.IsNull()).
        ///  \see setMarkDescription()
        ///      </remarks>        <short>    Get the \p mark's pixmap.</short>
        [SmokeMethod("markPixmap(KTextEditor::MarkInterface::MarkTypes) const")]
        public virtual QPixmap MarkPixmap(KTextEditor.MarkInterface.MarkTypes mark) {
            return (QPixmap) interceptor.Invoke("markPixmap$", "markPixmap(KTextEditor::MarkInterface::MarkTypes) const", typeof(QPixmap), typeof(KTextEditor.MarkInterface.MarkTypes), mark);
        }
        /// <remarks>
        ///  Set the <pre>mark</pre>'s description to <pre>text</pre>.
        ///  \param mark mark to set the description
        ///  \param text new descriptive text
        ///  \see markDescription(), setMarkPixmap()
        ///      </remarks>        <short>    Set the \p mark's description to \p text.</short>
        [SmokeMethod("setMarkDescription(KTextEditor::MarkInterface::MarkTypes, const QString&)")]
        public virtual void SetMarkDescription(KTextEditor.MarkInterface.MarkTypes mark, string text) {
            interceptor.Invoke("setMarkDescription$$", "setMarkDescription(KTextEditor::MarkInterface::MarkTypes, const QString&)", typeof(void), typeof(KTextEditor.MarkInterface.MarkTypes), mark, typeof(string), text);
        }
        /// <remarks>
        ///  Get the <pre>mark</pre>'s description to text.
        ///  \param mark mark to set the description
        ///  \return text of the given <pre>mark</pre> or string(), if the entry does not
        ///          exist
        ///  \see setMarkDescription(), setMarkPixmap()
        ///      </remarks>        <short>    Get the \p mark's description to text.</short>
        [SmokeMethod("markDescription(KTextEditor::MarkInterface::MarkTypes) const")]
        public virtual string MarkDescription(KTextEditor.MarkInterface.MarkTypes mark) {
            return (string) interceptor.Invoke("markDescription$", "markDescription(KTextEditor::MarkInterface::MarkTypes) const", typeof(string), typeof(KTextEditor.MarkInterface.MarkTypes), mark);
        }
        /// <remarks>
        ///  Set the mark mask the user is allowed to toggle to <pre>markMask</pre>.
        ///  I.e. concatenate all editable marks with a logical OR. If the user should
        ///  be able to add a bookmark and set a breakpoint with the context menu in
        ///  the icon pane, you have to call
        ///  <pre>
        ///  // iface is of Type KTextEditor.MarkInterface
        ///  // only make bookmark and breakpoint editable
        ///  iface.SetEditableMarks( MarkInterface.Bookmark |
        ///                           MarkInterface.BreakpointActive );
        ///  // or preserve last settings, and add bookmark and breakpoint
        ///  iface.SetEditableMarks( iface.EditableMarks() |
        ///                           MarkInterface.Bookmark |
        ///                           MarkInterface.BreakpointActive );
        ///  </pre>
        ///  \param markMask bitmap pattern
        ///  \see editableMarks(), setMarkPixmap(), setMarkDescription()
        ///      </remarks>        <short>    Set the mark mask the user is allowed to toggle to \p markMask.</short>
        [SmokeMethod("setEditableMarks(uint)")]
        public virtual void SetEditableMarks(uint markMask) {
            interceptor.Invoke("setEditableMarks$", "setEditableMarks(uint)", typeof(void), typeof(uint), markMask);
        }
        /// <remarks>
        ///  Get, which marks can be toggled by the user.
        ///  The returned value is a mark mask containing all editable marks combined
        ///  with a logical OR.
        ///  \return mark mask containing all editable marks
        ///  \see setEditableMarks()
        ///      </remarks>        <short>    Get, which marks can be toggled by the user.</short>
        [SmokeMethod("editableMarks() const")]
        public virtual uint EditableMarks() {
            return (uint) interceptor.Invoke("editableMarks", "editableMarks() const", typeof(uint));
        }
        /// <remarks>
        ///  The <pre>document</pre> emits this signal whenever the <pre>mark</pre> changes.
        ///  \param document the document which emitted the signal
        ///  \param mark changed mark
        ///  \param action action, either removed or added
        ///  \see marksChanged()
        ///      </remarks>        <short>    The \p document emits this signal whenever the \p mark changes.</short>
        [SmokeMethod("markChanged(KTextEditor::Document*, KTextEditor::Mark, KTextEditor::MarkInterface::MarkChangeAction)")]
        public virtual void MarkChanged(KTextEditor.Document document, KTextEditor.Mark mark, KTextEditor.MarkInterface.MarkChangeAction action) {
            interceptor.Invoke("markChanged##$", "markChanged(KTextEditor::Document*, KTextEditor::Mark, KTextEditor::MarkInterface::MarkChangeAction)", typeof(void), typeof(KTextEditor.Document), document, typeof(KTextEditor.Mark), mark, typeof(KTextEditor.MarkInterface.MarkChangeAction), action);
        }
        ~MarkInterface() {
            interceptor.Invoke("~MarkInterface", "~MarkInterface()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~MarkInterface", "~MarkInterface()", typeof(void));
        }
        /// <remarks>
        ///  Get the number of predefined mark types we have so far.
        ///  <b>Note:<> FIXME: If you change this you have to make sure katepart
        ///               supports the new size!
        ///  \return number of reserved marker types
        ///      </remarks>        <short>    Get the number of predefined mark types we have so far.</short>
        public static int ReservedMarkersCount() {
            return (int) staticInterceptor.Invoke("reservedMarkersCount", "reservedMarkersCount()", typeof(int));
        }
    }
}
