//
// This file is part of the Marble Desktop Globe.
//
// This program is free software licensed under the GNU LGPL. You can
// find a copy of this license in LICENSE.txt in the top directory of
// the source code.
//
// Copyright 2008  Henry de Valence <hdevalence@gmail.com>
//

#ifndef WINKELLOOKUP_H
#define WINKELLOOKUP_H

namespace Marble {


static const float WinkelX[181][91] = {

{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },

{0.005556, 0.005555, 0.005554, 0.005552, 0.00555, 0.005547, 0.005543, 0.005539, 0.005533,
0.005528, 0.005521, 0.005514, 0.005506, 0.005497, 0.005488, 0.005478, 0.005467, 0.005455,
0.005443, 0.00543, 0.005417, 0.005402, 0.005387, 0.005371, 0.005355, 0.005337, 0.005319,
0.0053, 0.005281, 0.005261, 0.00524, 0.005218, 0.005195, 0.005172, 0.005147, 0.005122,
0.005097, 0.00507, 0.005043, 0.005014, 0.004985, 0.004955, 0.004925, 0.004893, 0.00486,
0.004827, 0.004793, 0.004758, 0.004722, 0.004685, 0.004647, 0.004608, 0.004568, 0.004527,
0.004485, 0.004443, 0.004399, 0.004354, 0.004308, 0.004261, 0.004213, 0.004164, 0.004114,
0.004063, 0.00401, 0.003957, 0.003902, 0.003846, 0.003789, 0.00373, 0.00367, 0.003609,
0.003547, 0.003483, 0.003418, 0.003352, 0.003284, 0.003214, 0.003143, 0.003071, 0.002997,
0.002921, 0.002844, 0.002765, 0.002684, 0.002602, 0.002517, 0.002431, 0.002343, 0.002253,
0.002161 },

{0.011111, 0.01111, 0.011108, 0.011105, 0.0111, 0.011094, 0.011086, 0.011077, 0.011067,
0.011055, 0.011042, 0.011027, 0.011012, 0.010994, 0.010975, 0.010955, 0.010934, 0.010911,
0.010886, 0.01086, 0.010833, 0.010804, 0.010774, 0.010742, 0.010709, 0.010675, 0.010639,
0.010601, 0.010562, 0.010521, 0.010479, 0.010435, 0.01039, 0.010343, 0.010295, 0.010245,
0.010193, 0.01014, 0.010085, 0.010029, 0.009971, 0.009911, 0.009849, 0.009786, 0.009721,
0.009654, 0.009586, 0.009515, 0.009443, 0.009369, 0.009293, 0.009216, 0.009136, 0.009054,
0.008971, 0.008885, 0.008798, 0.008708, 0.008616, 0.008523, 0.008427, 0.008329, 0.008228,
0.008126, 0.008021, 0.007913, 0.007804, 0.007692, 0.007577, 0.00746, 0.007341, 0.007219,
0.007094, 0.006967, 0.006836, 0.006703, 0.006567, 0.006428, 0.006287, 0.006142, 0.005993,
0.005842, 0.005688, 0.00553, 0.005368, 0.005203, 0.005035, 0.004862, 0.004686, 0.004506,
0.004322 },

{0.016667, 0.016666, 0.016663, 0.016657, 0.01665, 0.016641, 0.016629, 0.016616, 0.0166,
0.016583, 0.016563, 0.016541, 0.016517, 0.016491, 0.016463, 0.016433, 0.016401, 0.016366,
0.016329, 0.016291, 0.01625, 0.016206, 0.016161, 0.016114, 0.016064, 0.016012, 0.015958,
0.015901, 0.015843, 0.015782, 0.015718, 0.015653, 0.015585, 0.015515, 0.015442, 0.015367,
0.01529, 0.01521, 0.015128, 0.015043, 0.014956, 0.014866, 0.014774, 0.014679, 0.014581,
0.014481, 0.014378, 0.014273, 0.014165, 0.014054, 0.01394, 0.013823, 0.013704, 0.013581,
0.013456, 0.013328, 0.013196, 0.013062, 0.012924, 0.012784, 0.01264, 0.012493, 0.012342,
0.012188, 0.012031, 0.01187, 0.011706, 0.011538, 0.011366, 0.01119, 0.011011, 0.010828,
0.010641, 0.01045, 0.010254, 0.010055, 0.009851, 0.009642, 0.00943, 0.009212, 0.00899,
0.008763, 0.008531, 0.008294, 0.008052, 0.007805, 0.007552, 0.007293, 0.007029, 0.006759,
0.006483 },

{0.022222, 0.022221, 0.022217, 0.02221, 0.0222, 0.022188, 0.022173, 0.022155, 0.022134,
0.02211, 0.022084, 0.022055, 0.022023, 0.021988, 0.021951, 0.021911, 0.021867, 0.021821,
0.021772, 0.021721, 0.021666, 0.021609, 0.021548, 0.021485, 0.021419, 0.021349, 0.021277,
0.021202, 0.021124, 0.021042, 0.020958, 0.02087, 0.02078, 0.020686, 0.020589, 0.020489,
0.020386, 0.02028, 0.02017, 0.020057, 0.019941, 0.019821, 0.019698, 0.019571, 0.019441,
0.019308, 0.019171, 0.01903, 0.018886, 0.018738, 0.018586, 0.018431, 0.018271, 0.018108,
0.017941, 0.01777, 0.017595, 0.017416, 0.017232, 0.017045, 0.016853, 0.016657, 0.016456,
0.016251, 0.016041, 0.015826, 0.015607, 0.015383, 0.015154, 0.01492, 0.014681, 0.014437,
0.014188, 0.013933, 0.013672, 0.013406, 0.013134, 0.012856, 0.012573, 0.012283, 0.011987,
0.011684, 0.011375, 0.011059, 0.010736, 0.010406, 0.010069, 0.009724, 0.009372, 0.009012,
0.008644 },

{0.027778, 0.027776, 0.027771, 0.027762, 0.02775, 0.027735, 0.027716, 0.027693, 0.027667,
0.027638, 0.027605, 0.027569, 0.027529, 0.027485, 0.027439, 0.027388, 0.027334, 0.027277,
0.027216, 0.027151, 0.027083, 0.027011, 0.026935, 0.026856, 0.026773, 0.026686, 0.026596,
0.026502, 0.026404, 0.026303, 0.026197, 0.026088, 0.025975, 0.025858, 0.025737, 0.025612,
0.025483, 0.02535, 0.025212, 0.025071, 0.024926, 0.024776, 0.024622, 0.024464, 0.024302,
0.024135, 0.023963, 0.023787, 0.023607, 0.023422, 0.023232, 0.023038, 0.022839, 0.022635,
0.022426, 0.022212, 0.021993, 0.021769, 0.02154, 0.021306, 0.021066, 0.02082, 0.020569,
0.020313, 0.020051, 0.019783, 0.019509, 0.019229, 0.018942, 0.01865, 0.018351, 0.018046,
0.017734, 0.017415, 0.01709, 0.016757, 0.016417, 0.01607, 0.015715, 0.015353, 0.014983,
0.014605, 0.014218, 0.013823, 0.01342, 0.013007, 0.012586, 0.012155, 0.011715, 0.011265,
0.010805 },

{0.033333, 0.033331, 0.033325, 0.033315, 0.0333, 0.033282, 0.033259, 0.033232, 0.033201,
0.033165, 0.033126, 0.033082, 0.033035, 0.032982, 0.032926, 0.032866, 0.032801, 0.032732,
0.032659, 0.032581, 0.032499, 0.032413, 0.032322, 0.032227, 0.032128, 0.032024, 0.031915,
0.031802, 0.031685, 0.031563, 0.031436, 0.031305, 0.03117, 0.031029, 0.030884, 0.030734,
0.030579, 0.030419, 0.030255, 0.030085, 0.029911, 0.029731, 0.029546, 0.029357, 0.029161,
0.028961, 0.028756, 0.028545, 0.028328, 0.028106, 0.027879, 0.027645, 0.027406, 0.027162,
0.026911, 0.026654, 0.026391, 0.026123, 0.025848, 0.025566, 0.025278, 0.024984, 0.024683,
0.024375, 0.02406, 0.023739, 0.02341, 0.023074, 0.02273, 0.022379, 0.022021, 0.021654, 0.02128,
0.020898, 0.020507, 0.020108, 0.0197, 0.019284, 0.018858, 0.018423, 0.017979, 0.017525,
0.017061, 0.016588, 0.016103, 0.015609, 0.015103, 0.014586, 0.014058, 0.013518, 0.012966 },

{0.038889, 0.038886, 0.038879, 0.038867, 0.03885, 0.038829, 0.038802, 0.03877, 0.038734,
0.038693, 0.038647, 0.038596, 0.03854, 0.03848, 0.038414, 0.038343, 0.038268, 0.038187,
0.038102, 0.038011, 0.037915, 0.037815, 0.037709, 0.037598, 0.037482, 0.037361, 0.037234,
0.037103, 0.036966, 0.036823, 0.036676, 0.036523, 0.036364, 0.0362, 0.036031, 0.035856,
0.035675, 0.035489, 0.035297, 0.035099, 0.034895, 0.034686, 0.03447, 0.034249, 0.034021,
0.033787, 0.033548, 0.033301, 0.033049, 0.03279, 0.032524, 0.032252, 0.031973, 0.031688,
0.031395, 0.031096, 0.030789, 0.030476, 0.030155, 0.029826, 0.02949, 0.029147, 0.028796,
0.028437, 0.028069, 0.027694, 0.02731, 0.026918, 0.026518, 0.026108, 0.02569, 0.025263,
0.024826, 0.02438, 0.023924, 0.023458, 0.022983, 0.022497, 0.022, 0.021493, 0.020975, 0.020445,
0.019904, 0.019352, 0.018787, 0.01821, 0.01762, 0.017017, 0.016401, 0.015771, 0.015127 },

{0.044444, 0.044442, 0.044433, 0.04442, 0.0444, 0.044375, 0.044345, 0.044309, 0.044268,
0.044221, 0.044168, 0.04411, 0.044046, 0.043977, 0.043901, 0.043821, 0.043734, 0.043642,
0.043545, 0.043441, 0.043332, 0.043217, 0.043096, 0.042969, 0.042836, 0.042698, 0.042553,
0.042403, 0.042246, 0.042083, 0.041915, 0.04174, 0.041559, 0.041371, 0.041178, 0.040977,
0.040771, 0.040558, 0.040339, 0.040112, 0.03988, 0.03964, 0.039394, 0.039141, 0.038881,
0.038614, 0.038339, 0.038058, 0.037769, 0.037473, 0.03717, 0.036859, 0.03654, 0.036214,
0.035879, 0.035537, 0.035187, 0.034828, 0.034461, 0.034086, 0.033702, 0.03331, 0.032908,
0.032498, 0.032078, 0.031649, 0.031211, 0.030763, 0.030305, 0.029837, 0.029359, 0.02887,
0.028371, 0.027862, 0.027341, 0.026808, 0.026265, 0.025709, 0.025142, 0.024562, 0.02397,
0.023365, 0.022747, 0.022115, 0.02147, 0.02081, 0.020136, 0.019448, 0.018744, 0.018024,
0.017288 },

{0.05, 0.049997, 0.049988, 0.049972, 0.04995, 0.049922, 0.049888, 0.049848, 0.049801, 0.049748,
0.049689, 0.049623, 0.049552, 0.049474, 0.049389, 0.049298, 0.049201, 0.049097, 0.048987,
0.048871, 0.048748, 0.048618, 0.048482, 0.04834, 0.048191, 0.048035, 0.047872, 0.047703,
0.047526, 0.047343, 0.047154, 0.046957, 0.046753, 0.046542, 0.046324, 0.046099, 0.045867,
0.045627, 0.04538, 0.045126, 0.044864, 0.044594, 0.044317, 0.044032, 0.04374, 0.043439,
0.043131, 0.042814, 0.042489, 0.042156, 0.041815, 0.041465, 0.041106, 0.040739, 0.040363,
0.039978, 0.039584, 0.03918, 0.038768, 0.038346, 0.037914, 0.037472, 0.03702, 0.036559,
0.036086, 0.035604, 0.035111, 0.034607, 0.034092, 0.033565, 0.033027, 0.032478, 0.031916,
0.031343, 0.030757, 0.030158, 0.029547, 0.028922, 0.028283, 0.027631, 0.026965, 0.026285,
0.025589, 0.024879, 0.024153, 0.023411, 0.022653, 0.021878, 0.021086, 0.020277, 0.019449 },

{0.055556, 0.055552, 0.055542, 0.055524, 0.0555, 0.055469, 0.055431, 0.055386, 0.055334,
0.055276, 0.05521, 0.055137, 0.055057, 0.05497, 0.054877, 0.054776, 0.054668, 0.054553,
0.05443, 0.054301, 0.054164, 0.05402, 0.053869, 0.053711, 0.053545, 0.053371, 0.053191,
0.053002, 0.052807, 0.052603, 0.052392, 0.052174, 0.051947, 0.051713, 0.051471, 0.05122,
0.050962, 0.050696, 0.050421, 0.050139, 0.049848, 0.049548, 0.04924, 0.048924, 0.048599,
0.048265, 0.047922, 0.04757, 0.047209, 0.046839, 0.04646, 0.046071, 0.045672, 0.045264,
0.044846, 0.044418, 0.04398, 0.043532, 0.043074, 0.042604, 0.042125, 0.041634, 0.041132,
0.040619, 0.040094, 0.039558, 0.03901, 0.03845, 0.037878, 0.037293, 0.036695, 0.036085,
0.035461, 0.034824, 0.034172, 0.033507, 0.032828, 0.032134, 0.031425, 0.0307, 0.02996,
0.029204, 0.028431, 0.027642, 0.026835, 0.026011, 0.025169, 0.024308, 0.023429, 0.02253,
0.02161 },

{0.061111, 0.061107, 0.061096, 0.061077, 0.06105, 0.061016, 0.060974, 0.060925, 0.060868,
0.060803, 0.060731, 0.060651, 0.060563, 0.060467, 0.060364, 0.060253, 0.060134, 0.060008,
0.059873, 0.059731, 0.05958, 0.059422, 0.059256, 0.059081, 0.058899, 0.058708, 0.058509,
0.058302, 0.058087, 0.057863, 0.057631, 0.05739, 0.057141, 0.056883, 0.056617, 0.056342,
0.056057, 0.055765, 0.055463, 0.055152, 0.054831, 0.054502, 0.054163, 0.053815, 0.053457,
0.05309, 0.052713, 0.052326, 0.051928, 0.051521, 0.051104, 0.050676, 0.050238, 0.049789,
0.049329, 0.048858, 0.048377, 0.047883, 0.047379, 0.046863, 0.046335, 0.045795, 0.045243,
0.044679, 0.044101, 0.043512, 0.042909, 0.042293, 0.041663, 0.04102, 0.040362, 0.039691,
0.039005, 0.038304, 0.037588, 0.036856, 0.036109, 0.035345, 0.034565, 0.033768, 0.032954,
0.032123, 0.031273, 0.030405, 0.029518, 0.028611, 0.027685, 0.026739, 0.025771, 0.024782,
0.023771 },

{0.066667, 0.066663, 0.06665, 0.066629, 0.0666, 0.066563, 0.066517, 0.066463, 0.066401,
0.066331, 0.066252, 0.066164, 0.066068, 0.065964, 0.065852, 0.06573, 0.065601, 0.065463,
0.065316, 0.06516, 0.064996, 0.064823, 0.064642, 0.064452, 0.064253, 0.064045, 0.063828,
0.063602, 0.063367, 0.063122, 0.062869, 0.062607, 0.062335, 0.062053, 0.061763, 0.061462,
0.061152, 0.060833, 0.060503, 0.060164, 0.059815, 0.059455, 0.059086, 0.058706, 0.058315,
0.057914, 0.057503, 0.057081, 0.056647, 0.056203, 0.055748, 0.055281, 0.054803, 0.054313,
0.053811, 0.053298, 0.052772, 0.052234, 0.051684, 0.051121, 0.050545, 0.049956, 0.049353,
0.048738, 0.048108, 0.047465, 0.046807, 0.046135, 0.045448, 0.044746, 0.044029, 0.043296,
0.042548, 0.041783, 0.041002, 0.040204, 0.039389, 0.038556, 0.037705, 0.036836, 0.035948,
0.035041, 0.034114, 0.033167, 0.0322, 0.031211, 0.030201, 0.029168, 0.028113, 0.027035,
0.025932 },

{0.072222, 0.072218, 0.072204, 0.072182, 0.07215, 0.07211, 0.072061, 0.072002, 0.071935,
0.071858, 0.071772, 0.071678, 0.071574, 0.071461, 0.071339, 0.071208, 0.071067, 0.070917,
0.070758, 0.07059, 0.070412, 0.070225, 0.070028, 0.069822, 0.069606, 0.069381, 0.069146,
0.068901, 0.068646, 0.068382, 0.068107, 0.067823, 0.067528, 0.067223, 0.066908, 0.066583,
0.066247, 0.065901, 0.065544, 0.065176, 0.064798, 0.064408, 0.064008, 0.063596, 0.063173,
0.062739, 0.062293, 0.061835, 0.061366, 0.060884, 0.060391, 0.059885, 0.059367, 0.058836,
0.058293, 0.057737, 0.057167, 0.056584, 0.055988, 0.055378, 0.054754, 0.054116, 0.053463,
0.052796, 0.052114, 0.051417, 0.050704, 0.049976, 0.049232, 0.048472, 0.047695, 0.046901,
0.046091, 0.045262, 0.044416, 0.043551, 0.042668, 0.041766, 0.040844, 0.039903, 0.038941,
0.037959, 0.036955, 0.035929, 0.034881, 0.033811, 0.032716, 0.031598, 0.030455, 0.029287,
0.028093 },

{0.077778, 0.077773, 0.077758, 0.077734, 0.0777, 0.077657, 0.077604, 0.077541, 0.077468,
0.077385, 0.077293, 0.077191, 0.077079, 0.076958, 0.076826, 0.076685, 0.076534, 0.076372,
0.076201, 0.076019, 0.075828, 0.075626, 0.075414, 0.075192, 0.07496, 0.074717, 0.074464,
0.0742, 0.073926, 0.073641, 0.073345, 0.073039, 0.072721, 0.072393, 0.072054, 0.071703,
0.071341, 0.070968, 0.070584, 0.070188, 0.06978, 0.069361, 0.068929, 0.068486, 0.06803,
0.067562, 0.067082, 0.066589, 0.066084, 0.065565, 0.065034, 0.064489, 0.063931, 0.063359,
0.062774, 0.062175, 0.061561, 0.060934, 0.060291, 0.059634, 0.058962, 0.058275, 0.057572,
0.056854, 0.056119, 0.055368, 0.054601, 0.053817, 0.053016, 0.052197, 0.05136, 0.050506,
0.049632, 0.04874, 0.047829, 0.046898, 0.045947, 0.044976, 0.043983, 0.042969, 0.041934,
0.040876, 0.039795, 0.038691, 0.037562, 0.03641, 0.035232, 0.034028, 0.032797, 0.03154,
0.030254 },

{0.083333, 0.083328, 0.083313, 0.083287, 0.08325, 0.083204, 0.083147, 0.083079, 0.083001,
0.082913, 0.082814, 0.082705, 0.082585, 0.082455, 0.082314, 0.082162, 0.082, 0.081827,
0.081643, 0.081449, 0.081244, 0.081028, 0.0808, 0.080562, 0.080313, 0.080053, 0.079782,
0.079499, 0.079205, 0.0789, 0.078583, 0.078254, 0.077914, 0.077562, 0.077199, 0.076823,
0.076435, 0.076036, 0.075624, 0.075199, 0.074762, 0.074313, 0.07385, 0.073375, 0.072887,
0.072386, 0.071871, 0.071343, 0.070801, 0.070245, 0.069676, 0.069092, 0.068494, 0.067882,
0.067254, 0.066612, 0.065955, 0.065282, 0.064594, 0.06389, 0.06317, 0.062433, 0.06168,
0.060911, 0.060124, 0.059319, 0.058497, 0.057657, 0.056798, 0.055921, 0.055025, 0.054109,
0.053173, 0.052218, 0.051241, 0.050244, 0.049225, 0.048184, 0.047121, 0.046035, 0.044926,
0.043792, 0.042635, 0.041452, 0.040243, 0.039008, 0.037746, 0.036457, 0.035139, 0.033792,
0.032415 },

{0.088889, 0.088883, 0.088867, 0.088839, 0.0888, 0.088751, 0.08869, 0.088618, 0.088535,
0.08844, 0.088335, 0.088218, 0.08809, 0.087951, 0.087801, 0.087639, 0.087466, 0.087282,
0.087086, 0.086878, 0.086659, 0.086429, 0.086186, 0.085932, 0.085667, 0.085389, 0.085099,
0.084798, 0.084484, 0.084158, 0.08382, 0.08347, 0.083107, 0.082732, 0.082343, 0.081943,
0.081529, 0.081103, 0.080663, 0.08021, 0.079744, 0.079264, 0.078771, 0.078264, 0.077743,
0.077208, 0.076659, 0.076096, 0.075518, 0.074925, 0.074317, 0.073695, 0.073057, 0.072403,
0.071734, 0.071049, 0.070348, 0.06963, 0.068896, 0.068145, 0.067377, 0.066591, 0.065788,
0.064967, 0.064127, 0.063269, 0.062392, 0.061496, 0.06058, 0.059644, 0.058688, 0.057711,
0.056714, 0.055694, 0.054653, 0.053589, 0.052502, 0.051392, 0.050258, 0.0491, 0.047917,
0.046708, 0.045474, 0.044212, 0.042923, 0.041606, 0.040261, 0.038886, 0.037481, 0.036044,
0.034576 },

{0.094444, 0.094439, 0.094421, 0.094392, 0.09435, 0.094297, 0.094233, 0.094156, 0.094068,
0.093968, 0.093856, 0.093732, 0.093596, 0.093448, 0.093288, 0.093116, 0.092932, 0.092736,
0.092528, 0.092307, 0.092075, 0.09183, 0.091572, 0.091302, 0.09102, 0.090725, 0.090417,
0.090096, 0.089763, 0.089417, 0.089057, 0.088685, 0.088299, 0.0879, 0.087488, 0.087062,
0.086622, 0.086169, 0.085702, 0.08522, 0.084725, 0.084215, 0.083691, 0.083152, 0.082599,
0.08203, 0.081447, 0.080848, 0.080234, 0.079604, 0.078958, 0.078296, 0.077618, 0.076924,
0.076213, 0.075485, 0.07474, 0.073977, 0.073197, 0.072399, 0.071583, 0.070748, 0.069894,
0.069022, 0.06813, 0.067218, 0.066286, 0.065334, 0.064361, 0.063367, 0.062351, 0.061313,
0.060253, 0.05917, 0.058063, 0.056933, 0.055779, 0.0546, 0.053395, 0.052165, 0.050908,
0.049624, 0.048312, 0.046972, 0.045603, 0.044204, 0.042775, 0.041314, 0.039822, 0.038297,
0.036737 },

{0.1, 0.099994, 0.099975, 0.099944, 0.0999, 0.099844, 0.099776, 0.099695, 0.099601, 0.099495,
0.099376, 0.099245, 0.099101, 0.098944, 0.098775, 0.098593, 0.098398, 0.098191, 0.09797,
0.097736, 0.09749, 0.09723, 0.096958, 0.096672, 0.096372, 0.09606, 0.095734, 0.095394,
0.095041, 0.094675, 0.094294, 0.0939, 0.093491, 0.093069, 0.092632, 0.092181, 0.091715,
0.091235, 0.09074, 0.09023, 0.089706, 0.089166, 0.088611, 0.08804, 0.087454, 0.086852,
0.086234, 0.0856, 0.084949, 0.084282, 0.083598, 0.082897, 0.082179, 0.081444, 0.080691,
0.07992, 0.079131, 0.078324, 0.077497, 0.076652, 0.075788, 0.074904, 0.074, 0.073076, 0.072131,
0.071166, 0.070179, 0.069171, 0.068141, 0.067088, 0.066012, 0.064914, 0.063791, 0.062644,
0.061473, 0.060276, 0.059054, 0.057806, 0.056531, 0.055228, 0.053897, 0.052538, 0.05115,
0.049731, 0.048282, 0.046801, 0.045289, 0.043743, 0.042163, 0.040549, 0.038898 },

{0.105556, 0.105549, 0.105529, 0.105496, 0.10545, 0.105391, 0.105319, 0.105233, 0.105134,
0.105022, 0.104897, 0.104758, 0.104606, 0.104441, 0.104262, 0.10407, 0.103864, 0.103645,
0.103412, 0.103165, 0.102905, 0.102631, 0.102343, 0.102041, 0.101725, 0.101395, 0.101051,
0.100692, 0.10032, 0.099932, 0.09953, 0.099114, 0.098683, 0.098237, 0.097775, 0.097299,
0.096807, 0.096301, 0.095778, 0.09524, 0.094686, 0.094116, 0.09353, 0.092927, 0.092308,
0.091673, 0.09102, 0.090351, 0.089664, 0.088959, 0.088237, 0.087498, 0.08674, 0.085963,
0.085168, 0.084354, 0.083521, 0.082669, 0.081797, 0.080904, 0.079992, 0.079059, 0.078105,
0.077129, 0.076132, 0.075113, 0.074071, 0.073007, 0.071919, 0.070808, 0.069673, 0.068513,
0.067328, 0.066118, 0.064882, 0.063619, 0.062329, 0.061011, 0.059665, 0.058291, 0.056886,
0.055452, 0.053987, 0.05249, 0.05096, 0.049398, 0.047802, 0.046171, 0.044504, 0.0428, 0.041059
},

{0.111111, 0.111104, 0.111083, 0.111049, 0.111, 0.110938, 0.110862, 0.110772, 0.110668,
0.11055, 0.110418, 0.110272, 0.110112, 0.109937, 0.109749, 0.109547, 0.10933, 0.109099,
0.108854, 0.108594, 0.10832, 0.108031, 0.107728, 0.10741, 0.107078, 0.10673, 0.106368, 0.10599,
0.105598, 0.10519, 0.104767, 0.104328, 0.103874, 0.103404, 0.102918, 0.102417, 0.101899,
0.101366, 0.100815, 0.100249, 0.099665, 0.099065, 0.098448, 0.097814, 0.097162, 0.096493,
0.095806, 0.095101, 0.094378, 0.093636, 0.092876, 0.092097, 0.091299, 0.090481, 0.089644,
0.088788, 0.087911, 0.087013, 0.086095, 0.085156, 0.084195, 0.083212, 0.082208, 0.081181,
0.080132, 0.079059, 0.077962, 0.076842, 0.075697, 0.074527, 0.073332, 0.072112, 0.070864,
0.06959, 0.068289, 0.06696, 0.065602, 0.064216, 0.062799, 0.061352, 0.059874, 0.058365,
0.056823, 0.055248, 0.053638, 0.051994, 0.050315, 0.048598, 0.046845, 0.045052, 0.043221 },

{0.116667, 0.116659, 0.116638, 0.116601, 0.11655, 0.116485, 0.116405, 0.11631, 0.116201,
0.116077, 0.115938, 0.115785, 0.115617, 0.115434, 0.115236, 0.115023, 0.114796, 0.114553,
0.114296, 0.114023, 0.113735, 0.113432, 0.113113, 0.112779, 0.11243, 0.112065, 0.111684,
0.111288, 0.110875, 0.110447, 0.110002, 0.109542, 0.109065, 0.108571, 0.108061, 0.107534,
0.106991, 0.10643, 0.105852, 0.105257, 0.104644, 0.104014, 0.103366, 0.102699, 0.102015,
0.101312, 0.10059, 0.09985, 0.099091, 0.098312, 0.097514, 0.096695, 0.095857, 0.094999,
0.09412, 0.09322, 0.092299, 0.091356, 0.090392, 0.089406, 0.088397, 0.087365, 0.08631,
0.085232, 0.08413, 0.083003, 0.081852, 0.080676, 0.079474, 0.078245, 0.076991, 0.075709,
0.074399, 0.073062, 0.071696, 0.0703, 0.068875, 0.067419, 0.065932, 0.064413, 0.062862,
0.061277, 0.059658, 0.058005, 0.056316, 0.05459, 0.052827, 0.051026, 0.049185, 0.047304,
0.045382 },

{0.122222, 0.122215, 0.122192, 0.122154, 0.1221, 0.122032, 0.121948, 0.121848, 0.121734,
0.121604, 0.121459, 0.121298, 0.121122, 0.12093, 0.120723, 0.1205, 0.120261, 0.120007,
0.119737, 0.119451, 0.11915, 0.118832, 0.118498, 0.118148, 0.117782, 0.117399, 0.117, 0.116585,
0.116152, 0.115704, 0.115238, 0.114755, 0.114255, 0.113738, 0.113203, 0.112651, 0.112082,
0.111494, 0.110888, 0.110265, 0.109623, 0.108962, 0.108283, 0.107584, 0.106867, 0.106131,
0.105374, 0.104599, 0.103803, 0.102987, 0.10215, 0.101293, 0.100415, 0.099515, 0.098594,
0.097651, 0.096686, 0.095699, 0.094688, 0.093655, 0.092598, 0.091517, 0.090412, 0.089282,
0.088127, 0.086947, 0.085741, 0.084508, 0.083249, 0.081962, 0.080648, 0.079305, 0.077933,
0.076532, 0.075101, 0.073639, 0.072146, 0.070621, 0.069064, 0.067473, 0.065848, 0.064188,
0.062493, 0.060761, 0.058992, 0.057185, 0.055339, 0.053452, 0.051525, 0.049555, 0.047543 },

{0.127778, 0.12777, 0.127746, 0.127706, 0.12765, 0.127578, 0.127491, 0.127387, 0.127267,
0.127131, 0.126979, 0.126811, 0.126627, 0.126426, 0.126209, 0.125976, 0.125727, 0.125461,
0.125179, 0.12488, 0.124564, 0.124232, 0.123882, 0.123516, 0.123133, 0.122733, 0.122316,
0.121881, 0.121429, 0.12096, 0.120473, 0.119968, 0.119445, 0.118904, 0.118345, 0.117768,
0.117172, 0.116557, 0.115924, 0.115272, 0.1146, 0.113909, 0.113199, 0.112469, 0.111719,
0.110948, 0.110158, 0.109346, 0.108514, 0.107661, 0.106786, 0.105889, 0.104971, 0.10403,
0.103067, 0.102081, 0.101072, 0.10004, 0.098983, 0.097902, 0.096797, 0.095667, 0.094512,
0.09333, 0.092123, 0.090889, 0.089628, 0.088339, 0.087023, 0.085678, 0.084303, 0.0829,
0.081466, 0.080001, 0.078505, 0.076977, 0.075416, 0.073822, 0.072194, 0.070531, 0.068833,
0.067098, 0.065327, 0.063517, 0.061668, 0.059779, 0.05785, 0.055879, 0.053865, 0.051807,
0.049704 },

{0.133333, 0.133325, 0.1333, 0.133258, 0.1332, 0.133125, 0.133034, 0.132925, 0.1328, 0.132658,
0.1325, 0.132324, 0.132132, 0.131922, 0.131696, 0.131453, 0.131192, 0.130915, 0.13062,
0.130308, 0.129978, 0.129631, 0.129267, 0.128885, 0.128485, 0.128067, 0.127631, 0.127178,
0.126706, 0.126216, 0.125707, 0.12518, 0.124634, 0.12407, 0.123486, 0.122884, 0.122262,
0.12162, 0.120959, 0.120278, 0.119577, 0.118856, 0.118114, 0.117352, 0.116569, 0.115765,
0.11494, 0.114093, 0.113224, 0.112334, 0.111421, 0.110485, 0.109526, 0.108545, 0.107539,
0.10651, 0.105457, 0.104379, 0.103277, 0.102149, 0.100996, 0.099816, 0.09861, 0.097378,
0.096118, 0.09483, 0.093514, 0.092169, 0.090795, 0.089392, 0.087958, 0.086493, 0.084997,
0.083469, 0.081908, 0.080314, 0.078685, 0.077022, 0.075324, 0.073589, 0.071817, 0.070008,
0.068159, 0.066272, 0.064343, 0.062373, 0.060361, 0.058305, 0.056204, 0.054058, 0.051865 },

{0.138889, 0.13888, 0.138854, 0.138811, 0.13875, 0.138672, 0.138576, 0.138464, 0.138333,
0.138185, 0.13802, 0.137837, 0.137637, 0.137418, 0.137183, 0.136929, 0.136658, 0.136368,
0.136061, 0.135736, 0.135392, 0.135031, 0.134651, 0.134253, 0.133836, 0.133401, 0.132947,
0.132474, 0.131982, 0.131471, 0.130941, 0.130392, 0.129823, 0.129235, 0.128627, 0.127999,
0.127351, 0.126682, 0.125993, 0.125284, 0.124553, 0.123802, 0.123029, 0.122235, 0.121419,
0.120581, 0.119721, 0.118839, 0.117934, 0.117006, 0.116054, 0.115079, 0.114081, 0.113058,
0.11201, 0.110938, 0.109841, 0.108718, 0.107569, 0.106394, 0.105193, 0.103964, 0.102708,
0.101423, 0.100111, 0.098769, 0.097398, 0.095998, 0.094567, 0.093105, 0.091611, 0.090085,
0.088527, 0.086935, 0.085309, 0.083649, 0.081953, 0.080221, 0.078452, 0.076645, 0.0748,
0.072916, 0.070991, 0.069025, 0.067017, 0.064966, 0.062871, 0.06073, 0.058544, 0.056309,
0.054026 },

{0.144444, 0.144435, 0.144408, 0.144363, 0.1443, 0.144219, 0.144119, 0.144002, 0.143866,
0.143712, 0.14354, 0.14335, 0.143141, 0.142914, 0.142669, 0.142405, 0.142123, 0.141822,
0.141502, 0.141163, 0.140806, 0.14043, 0.140035, 0.13962, 0.139187, 0.138734, 0.138261,
0.137769, 0.137258, 0.136726, 0.136175, 0.135604, 0.135012, 0.1344, 0.133767, 0.133113,
0.132439, 0.131744, 0.131027, 0.130289, 0.129529, 0.128747, 0.127943, 0.127117, 0.126268,
0.125396, 0.124502, 0.123584, 0.122642, 0.121676, 0.120687, 0.119673, 0.118634, 0.11757,
0.11648, 0.115365, 0.114223, 0.113055, 0.11186, 0.110638, 0.109388, 0.10811, 0.106804,
0.105468, 0.104103, 0.102707, 0.101282, 0.099825, 0.098336, 0.096816, 0.095263, 0.093676,
0.092055, 0.0904, 0.088709, 0.086983, 0.085219, 0.083418, 0.081579, 0.079701, 0.077782,
0.075823, 0.073822, 0.071778, 0.069691, 0.067559, 0.065381, 0.063156, 0.060882, 0.05856,
0.056187 },

{0.15, 0.149991, 0.149962, 0.149916, 0.14985, 0.149765, 0.149662, 0.14954, 0.149399, 0.149239,
0.149061, 0.148863, 0.148646, 0.14841, 0.148155, 0.147881, 0.147588, 0.147275, 0.146943,
0.146591, 0.14622, 0.145829, 0.145418, 0.144988, 0.144537, 0.144067, 0.143576, 0.143065,
0.142533, 0.141981, 0.141408, 0.140814, 0.1402, 0.139564, 0.138906, 0.138227, 0.137527,
0.136804, 0.13606, 0.135293, 0.134503, 0.133691, 0.132856, 0.131998, 0.131116, 0.13021,
0.129281, 0.128327, 0.127349, 0.126346, 0.125318, 0.124265, 0.123185, 0.12208, 0.120948,
0.11979, 0.118604, 0.117391, 0.11615, 0.114881, 0.113582, 0.112255, 0.110898, 0.109511,
0.108093, 0.106644, 0.105163, 0.10365, 0.102105, 0.100526, 0.098913, 0.097265, 0.095582,
0.093863, 0.092108, 0.090315, 0.088484, 0.086614, 0.084705, 0.082755, 0.080763, 0.078729,
0.076652, 0.07453, 0.072364, 0.07015, 0.06789, 0.06558, 0.063221, 0.060811, 0.058348 },

{0.155556, 0.155546, 0.155517, 0.155468, 0.1554, 0.155312, 0.155205, 0.155078, 0.154932,
0.154766, 0.154581, 0.154376, 0.154151, 0.153906, 0.153641, 0.153357, 0.153052, 0.152728,
0.152383, 0.152018, 0.151633, 0.151228, 0.150802, 0.150355, 0.149887, 0.149399, 0.14889,
0.14836, 0.147808, 0.147235, 0.146641, 0.146025, 0.145387, 0.144727, 0.144045, 0.143341,
0.142614, 0.141864, 0.141092, 0.140296, 0.139477, 0.138635, 0.137768, 0.136878, 0.135963,
0.135024, 0.134059, 0.13307, 0.132055, 0.131015, 0.129948, 0.128856, 0.127736, 0.12659,
0.125416, 0.124214, 0.122984, 0.121726, 0.120438, 0.119122, 0.117775, 0.116398, 0.114991,
0.113552, 0.112082, 0.110579, 0.109043, 0.107474, 0.105871, 0.104234, 0.102561, 0.100853,
0.099107, 0.097325, 0.095505, 0.093646, 0.091748, 0.089809, 0.087829, 0.085807, 0.083743,
0.081634, 0.079481, 0.077282, 0.075035, 0.072741, 0.070398, 0.068004, 0.065559, 0.063061,
0.060509 },

{0.161111, 0.161101, 0.161071, 0.16102, 0.16095, 0.160859, 0.160748, 0.160617, 0.160465,
0.160293, 0.160101, 0.159888, 0.159655, 0.159402, 0.159127, 0.158833, 0.158517, 0.158181,
0.157824, 0.157446, 0.157046, 0.156626, 0.156185, 0.155722, 0.155237, 0.154731, 0.154204,
0.153654, 0.153083, 0.152489, 0.151873, 0.151235, 0.150574, 0.14989, 0.149183, 0.148453,
0.1477, 0.146924, 0.146123, 0.145299, 0.14445, 0.143577, 0.142679, 0.141757, 0.140809,
0.139836, 0.138837, 0.137812, 0.13676, 0.135682, 0.134577, 0.133445, 0.132285, 0.131098,
0.129881, 0.128636, 0.127362, 0.126059, 0.124725, 0.123361, 0.121966, 0.12054, 0.119082,
0.117592, 0.116069, 0.114512, 0.112922, 0.111297, 0.109636, 0.10794, 0.106208, 0.104438,
0.102631, 0.100785, 0.0989, 0.096975, 0.09501, 0.093002, 0.090952, 0.088859, 0.086721,
0.084538, 0.082308, 0.080032, 0.077706, 0.075331, 0.072906, 0.070428, 0.067897, 0.065311,
0.06267 },

{0.166667, 0.166656, 0.166625, 0.166573, 0.1665, 0.166406, 0.166291, 0.166155, 0.165998,
0.16582, 0.165621, 0.165401, 0.16516, 0.164897, 0.164613, 0.164308, 0.163982, 0.163634,
0.163264, 0.162872, 0.162459, 0.162024, 0.161567, 0.161088, 0.160587, 0.160063, 0.159517,
0.158948, 0.158357, 0.157742, 0.157105, 0.156444, 0.15576, 0.155052, 0.154321, 0.153565,
0.152786, 0.151982, 0.151154, 0.1503, 0.149422, 0.148519, 0.147589, 0.146635, 0.145654,
0.144647, 0.143613, 0.142552, 0.141464, 0.140348, 0.139205, 0.138033, 0.136833, 0.135604,
0.134346, 0.133058, 0.131739, 0.13039, 0.129011, 0.127599, 0.126156, 0.12468, 0.123172,
0.12163, 0.120054, 0.118444, 0.116798, 0.115117, 0.1134, 0.111645, 0.109853, 0.108023,
0.106153, 0.104244, 0.102294, 0.100303, 0.09827, 0.096194, 0.094074, 0.091909, 0.089698,
0.08744, 0.085135, 0.082781, 0.080376, 0.077921, 0.075413, 0.072851, 0.070234, 0.067561,
0.064831 },

{0.172222, 0.172211, 0.172179, 0.172125, 0.17205, 0.171952, 0.171833, 0.171693, 0.171531,
0.171347, 0.171141, 0.170913, 0.170664, 0.170393, 0.170099, 0.169784, 0.169446, 0.169086,
0.168704, 0.168299, 0.167872, 0.167422, 0.16695, 0.166454, 0.165936, 0.165394, 0.16483,
0.164242, 0.16363, 0.162995, 0.162336, 0.161653, 0.160945, 0.160214, 0.159458, 0.158677,
0.157871, 0.15704, 0.156183, 0.155301, 0.154393, 0.153459, 0.152499, 0.151512, 0.150498,
0.149456, 0.148388, 0.147291, 0.146167, 0.145013, 0.143831, 0.14262, 0.14138, 0.140109,
0.138809, 0.137477, 0.136115, 0.13472, 0.133294, 0.131836, 0.130344, 0.128819, 0.12726,
0.125666, 0.124038, 0.122374, 0.120673, 0.118936, 0.117161, 0.115348, 0.113496, 0.111605,
0.109674, 0.107701, 0.105687, 0.10363, 0.101529, 0.099384, 0.097194, 0.094957, 0.092674,
0.090342, 0.08796, 0.085529, 0.083045, 0.080509, 0.077919, 0.075274, 0.072572, 0.069811,
0.066992 },

{0.177778, 0.177767, 0.177733, 0.177677, 0.177599, 0.177499, 0.177376, 0.177231, 0.177064,
0.176874, 0.176661, 0.176426, 0.176168, 0.175888, 0.175585, 0.175259, 0.17491, 0.174538,
0.174144, 0.173726, 0.173284, 0.17282, 0.172332, 0.17182, 0.171285, 0.170725, 0.170142,
0.169535, 0.168903, 0.168247, 0.167566, 0.166861, 0.16613, 0.165375, 0.164594, 0.163787,
0.162955, 0.162097, 0.161212, 0.160301, 0.159363, 0.158399, 0.157407, 0.156387, 0.15534,
0.154265, 0.153161, 0.152029, 0.150868, 0.149677, 0.148457, 0.147206, 0.145925, 0.144613,
0.14327, 0.141895, 0.140488, 0.139049, 0.137576, 0.13607, 0.13453, 0.132956, 0.131346,
0.129701, 0.12802, 0.126302, 0.124546, 0.122753, 0.120921, 0.119049, 0.117138, 0.115186,
0.113192, 0.111156, 0.109077, 0.106954, 0.104786, 0.102573, 0.100312, 0.098004, 0.095648,
0.093241, 0.090784, 0.088275, 0.085713, 0.083097, 0.080425, 0.077696, 0.074908, 0.072061,
0.069153 },

{0.183333, 0.183322, 0.183287, 0.18323, 0.183149, 0.183046, 0.182919, 0.182769, 0.182596,
0.1824, 0.182181, 0.181938, 0.181672, 0.181383, 0.18107, 0.180734, 0.180374, 0.179991,
0.179583, 0.179152, 0.178697, 0.178217, 0.177713, 0.177186, 0.176633, 0.176056, 0.175454,
0.174827, 0.174176, 0.173499, 0.172796, 0.172068, 0.171315, 0.170535, 0.169729, 0.168897,
0.168038, 0.167153, 0.16624, 0.1653, 0.164333, 0.163337, 0.162314, 0.161262, 0.160182,
0.159073, 0.157934, 0.156766, 0.155568, 0.154339, 0.15308, 0.15179, 0.150469, 0.149115,
0.14773, 0.146312, 0.14486, 0.143375, 0.141857, 0.140303, 0.138715, 0.137091, 0.135431,
0.133734, 0.132, 0.130228, 0.128418, 0.126568, 0.124679, 0.122749, 0.120778, 0.118765,
0.116709, 0.11461, 0.112466, 0.110277, 0.108042, 0.105759, 0.103429, 0.10105, 0.09862, 0.09614,
0.093607, 0.091021, 0.08838, 0.085683, 0.082929, 0.080117, 0.077244, 0.074311, 0.071314 },

{0.188889, 0.188877, 0.188841, 0.188782, 0.188699, 0.188592, 0.188462, 0.188307, 0.188129,
0.187927, 0.187701, 0.187451, 0.187177, 0.186878, 0.186556, 0.186209, 0.185838, 0.185442,
0.185022, 0.184578, 0.184108, 0.183614, 0.183095, 0.182551, 0.181981, 0.181386, 0.180766,
0.18012, 0.179448, 0.17875, 0.178026, 0.177275, 0.176498, 0.175694, 0.174864, 0.174006,
0.173121, 0.172208, 0.171267, 0.170298, 0.169301, 0.168275, 0.16722, 0.166136, 0.165022,
0.163879, 0.162705, 0.161501, 0.160266, 0.159, 0.157702, 0.156373, 0.155011, 0.153616,
0.152188, 0.150726, 0.149231, 0.1477, 0.146135, 0.144534, 0.142897, 0.141224, 0.139513,
0.137765, 0.135978, 0.134152, 0.132287, 0.130381, 0.128435, 0.126446, 0.124416, 0.122342,
0.120224, 0.118061, 0.115853, 0.113598, 0.111295, 0.108945, 0.106544, 0.104094, 0.101592,
0.099037, 0.096429, 0.093765, 0.091046, 0.088269, 0.085433, 0.082538, 0.07958, 0.07656,
0.073475 },

{0.194444, 0.194432, 0.194396, 0.194334, 0.194249, 0.194139, 0.194004, 0.193845, 0.193662,
0.193453, 0.19322, 0.192963, 0.19268, 0.192373, 0.192041, 0.191684, 0.191302, 0.190894,
0.190462, 0.190003, 0.18952, 0.189011, 0.188476, 0.187915, 0.187329, 0.186716, 0.186077,
0.185411, 0.184719, 0.184, 0.183254, 0.182481, 0.181681, 0.180853, 0.179997, 0.179114,
0.178202, 0.177262, 0.176293, 0.175295, 0.174268, 0.173211, 0.172125, 0.171008, 0.169861,
0.168684, 0.167475, 0.166235, 0.164963, 0.163659, 0.162323, 0.160954, 0.159551, 0.158115,
0.156644, 0.155139, 0.153599, 0.152024, 0.150412, 0.148764, 0.147078, 0.145355, 0.143594,
0.141794, 0.139954, 0.138075, 0.136154, 0.134192, 0.132188, 0.130142, 0.128051, 0.125917,
0.123737, 0.12151, 0.119238, 0.116917, 0.114547, 0.112128, 0.109658, 0.107136, 0.104561,
0.101933, 0.099249, 0.096509, 0.093711, 0.090854, 0.087937, 0.084958, 0.081916, 0.078809,
0.075636 },

{0.2, 0.199987, 0.19995, 0.199887, 0.199799, 0.199685, 0.199547, 0.199383, 0.199194, 0.19898,
0.19874, 0.198475, 0.198184, 0.197868, 0.197526, 0.197159, 0.196765, 0.196346, 0.1959,
0.195429, 0.194931, 0.194407, 0.193857, 0.19328, 0.192676, 0.192045, 0.191387, 0.190702,
0.18999, 0.18925, 0.188482, 0.187687, 0.186863, 0.186011, 0.18513, 0.184221, 0.183283,
0.182315, 0.181318, 0.180291, 0.179234, 0.178146, 0.177028, 0.175879, 0.174699, 0.173487,
0.172244, 0.170967, 0.169659, 0.168317, 0.166942, 0.165533, 0.16409, 0.162612, 0.161099,
0.159551, 0.157966, 0.156345, 0.154687, 0.152991, 0.151257, 0.149484, 0.147673, 0.145821,
0.143928, 0.141995, 0.140019, 0.138002, 0.13594, 0.133835, 0.131685, 0.129489, 0.127247,
0.124958, 0.12262, 0.120234, 0.117797, 0.115309, 0.11277, 0.110177, 0.107529, 0.104827,
0.102068, 0.09925, 0.096374, 0.093438, 0.090439, 0.087377, 0.084251, 0.081058, 0.077797 },

{0.205556, 0.205543, 0.205504, 0.205439, 0.205349, 0.205232, 0.20509, 0.204921, 0.204727,
0.204506, 0.20426, 0.203987, 0.203688, 0.203363, 0.203011, 0.202633, 0.202228, 0.201797,
0.201339, 0.200854, 0.200342, 0.199803, 0.199237, 0.198644, 0.198022, 0.197374, 0.196697,
0.195993, 0.19526, 0.194499, 0.19371, 0.192892, 0.192044, 0.191168, 0.190263, 0.189327,
0.188362, 0.187367, 0.186342, 0.185286, 0.184199, 0.18308, 0.181931, 0.180749, 0.179536,
0.17829, 0.177011, 0.175699, 0.174353, 0.172973, 0.171559, 0.170111, 0.168627, 0.167108,
0.165552, 0.16396, 0.162331, 0.160664, 0.15896, 0.157216, 0.155434, 0.153612, 0.151749,
0.149846, 0.1479, 0.145913, 0.143883, 0.141809, 0.13969, 0.137526, 0.135317, 0.13306, 0.130756,
0.128403, 0.126001, 0.123549, 0.121045, 0.118489, 0.11588, 0.113215, 0.110496, 0.107719,
0.104885, 0.101991, 0.099037, 0.09602, 0.092941, 0.089796, 0.086585, 0.083306, 0.079958 },

{0.211111, 0.211098, 0.211058, 0.210991, 0.210898, 0.210779, 0.210632, 0.210459, 0.210259,
0.210033, 0.209779, 0.209499, 0.209192, 0.208857, 0.208496, 0.208107, 0.207691, 0.207248,
0.206777, 0.206279, 0.205753, 0.205199, 0.204617, 0.204007, 0.203369, 0.202702, 0.202007,
0.201283, 0.20053, 0.199748, 0.198936, 0.198096, 0.197225, 0.196325, 0.195394, 0.194433,
0.193441, 0.192418, 0.191365, 0.190279, 0.189162, 0.188013, 0.186832, 0.185618, 0.184371,
0.18309, 0.181776, 0.180428, 0.179045, 0.177628, 0.176175, 0.174687, 0.173162, 0.171601,
0.170003, 0.168368, 0.166694, 0.164982, 0.163231, 0.16144, 0.159609, 0.157737, 0.155824,
0.153868, 0.15187, 0.149829, 0.147744, 0.145613, 0.143438, 0.141215, 0.138946, 0.136629,
0.134263, 0.131847, 0.12938, 0.126862, 0.124291, 0.121667, 0.118988, 0.116253, 0.113461,
0.11061, 0.107701, 0.10473, 0.101698, 0.098602, 0.095441, 0.092214, 0.088919, 0.085555,
0.082119 },

{0.216667, 0.216653, 0.216612, 0.216544, 0.216448, 0.216325, 0.216175, 0.215997, 0.215792,
0.215559, 0.215299, 0.215011, 0.214695, 0.214352, 0.213981, 0.213581, 0.213154, 0.212699,
0.212215, 0.211703, 0.211163, 0.210594, 0.209997, 0.20937, 0.208715, 0.20803, 0.207316,
0.206572, 0.205799, 0.204996, 0.204162, 0.203299, 0.202405, 0.20148, 0.200524, 0.199537,
0.198519, 0.197469, 0.196386, 0.195272, 0.194125, 0.192945, 0.191732, 0.190485, 0.189204,
0.18789, 0.18654, 0.185156, 0.183736, 0.182281, 0.180789, 0.179261, 0.177696, 0.176093,
0.174453, 0.172773, 0.171055, 0.169297, 0.1675, 0.165661, 0.163781, 0.16186, 0.159896,
0.157889, 0.155838, 0.153743, 0.151602, 0.149416, 0.147183, 0.144902, 0.142573, 0.140195,
0.137767, 0.135288, 0.132757, 0.130173, 0.127535, 0.124843, 0.122094, 0.119288, 0.116424,
0.1135, 0.110515, 0.107468, 0.104358, 0.101183, 0.097941, 0.094632, 0.091253, 0.087803, 0.08428
},

{0.222222, 0.222208, 0.222166, 0.222096, 0.221998, 0.221872, 0.221717, 0.221535, 0.221324,
0.221085, 0.220818, 0.220522, 0.220199, 0.219846, 0.219465, 0.219055, 0.218617, 0.218149,
0.217653, 0.217128, 0.216573, 0.215989, 0.215376, 0.214733, 0.21406, 0.213357, 0.212624,
0.211861, 0.211067, 0.210243, 0.209388, 0.208501, 0.207584, 0.206635, 0.205654, 0.204641,
0.203595, 0.202518, 0.201407, 0.200263, 0.199086, 0.197875, 0.19663, 0.195351, 0.194037,
0.192688, 0.191303, 0.189882, 0.188426, 0.186932, 0.185402, 0.183834, 0.182228, 0.180583,
0.1789, 0.177177, 0.175414, 0.173611, 0.171766, 0.16988, 0.167952, 0.165981, 0.163966,
0.161907, 0.159803, 0.157654, 0.155459, 0.153216, 0.150926, 0.148587, 0.146198, 0.143759,
0.141269, 0.138727, 0.136132, 0.133482, 0.130777, 0.128016, 0.125198, 0.122321, 0.119385,
0.116387, 0.113328, 0.110205, 0.107017, 0.103762, 0.10044, 0.097048, 0.093586, 0.090051,
0.086441 },

{0.227778, 0.227763, 0.22772, 0.227648, 0.227548, 0.227418, 0.22726, 0.227073, 0.226857,
0.226611, 0.226337, 0.226034, 0.225702, 0.22534, 0.224949, 0.224529, 0.224079, 0.2236,
0.223091, 0.222552, 0.221983, 0.221384, 0.220754, 0.220095, 0.219405, 0.218684, 0.217932,
0.217149, 0.216335, 0.215489, 0.214612, 0.213703, 0.212762, 0.211788, 0.210782, 0.209743,
0.208671, 0.207566, 0.206427, 0.205253, 0.204046, 0.202804, 0.201527, 0.200215, 0.198868,
0.197484, 0.196064, 0.194607, 0.193113, 0.191582, 0.190012, 0.188404, 0.186758, 0.185071,
0.183345, 0.181579, 0.179771, 0.177922, 0.176031, 0.174097, 0.17212, 0.170099, 0.168034,
0.165923, 0.163767, 0.161563, 0.159313, 0.157014, 0.154666, 0.152269, 0.149821, 0.147321,
0.144769, 0.142164, 0.139504, 0.136789, 0.134017, 0.131188, 0.1283, 0.125353, 0.122344,
0.119273, 0.116139, 0.11294, 0.109674, 0.106341, 0.102938, 0.099464, 0.095918, 0.092298,
0.088602 },

{0.233333, 0.233319, 0.233274, 0.233201, 0.233097, 0.232965, 0.232802, 0.23261, 0.232389,
0.232137, 0.231856, 0.231546, 0.231205, 0.230834, 0.230433, 0.230002, 0.229541, 0.22905,
0.228528, 0.227975, 0.227392, 0.226778, 0.226133, 0.225457, 0.224749, 0.22401, 0.223239,
0.222437, 0.221602, 0.220735, 0.219836, 0.218904, 0.217939, 0.216941, 0.21591, 0.214845,
0.213746, 0.212613, 0.211445, 0.210242, 0.209005, 0.207732, 0.206423, 0.205078, 0.203697,
0.202279, 0.200823, 0.19933, 0.197799, 0.19623, 0.194621, 0.192973, 0.191286, 0.189557,
0.187788, 0.185978, 0.184126, 0.182231, 0.180293, 0.178312, 0.176286, 0.174216, 0.172099,
0.169937, 0.167727, 0.16547, 0.163164, 0.160809, 0.158404, 0.155948, 0.153441, 0.15088,
0.148266, 0.145598, 0.142874, 0.140093, 0.137255, 0.134358, 0.1314, 0.128382, 0.125302,
0.122158, 0.118949, 0.115673, 0.11233, 0.108918, 0.105435, 0.10188, 0.09825, 0.094545, 0.090763
},

{0.238889, 0.238874, 0.238828, 0.238753, 0.238647, 0.238511, 0.238345, 0.238148, 0.237921,
0.237664, 0.237376, 0.237057, 0.236708, 0.236328, 0.235917, 0.235476, 0.235003, 0.2345,
0.233965, 0.233399, 0.232801, 0.232172, 0.231511, 0.230818, 0.230093, 0.229335, 0.228546,
0.227723, 0.226868, 0.22598, 0.225059, 0.224104, 0.223115, 0.222093, 0.221036, 0.219945,
0.218819, 0.217658, 0.216462, 0.21523, 0.213962, 0.212658, 0.211317, 0.20994, 0.208525,
0.207072, 0.205581, 0.204052, 0.202483, 0.200876, 0.199228, 0.19754, 0.195811, 0.194041,
0.19223, 0.190376, 0.188479, 0.186538, 0.184554, 0.182524, 0.18045, 0.178329, 0.176162,
0.173948, 0.171685, 0.169374, 0.167013, 0.164602, 0.16214, 0.159626, 0.157058, 0.154437,
0.151761, 0.14903, 0.146241, 0.143395, 0.14049, 0.137525, 0.134498, 0.13141, 0.128257, 0.12504,
0.121757, 0.118405, 0.114985, 0.111494, 0.107931, 0.104294, 0.100582, 0.096792, 0.092924 },

{0.244444, 0.244429, 0.244383, 0.244305, 0.244197, 0.244058, 0.243887, 0.243686, 0.243453,
0.243189, 0.242895, 0.242568, 0.242211, 0.241822, 0.241401, 0.240949, 0.240465, 0.239949,
0.239401, 0.238822, 0.238209, 0.237565, 0.236888, 0.236178, 0.235436, 0.23466, 0.233852,
0.23301, 0.232134, 0.231224, 0.230281, 0.229303, 0.228291, 0.227244, 0.226162, 0.225044,
0.223891, 0.222703, 0.221478, 0.220216, 0.218918, 0.217583, 0.21621, 0.2148, 0.213351,
0.211863, 0.210337, 0.208771, 0.207166, 0.20552, 0.203833, 0.202105, 0.200335, 0.198523,
0.196669, 0.194771, 0.192829, 0.190843, 0.188811, 0.186734, 0.184611, 0.182441, 0.180223,
0.177957, 0.175641, 0.173276, 0.17086, 0.168393, 0.165873, 0.1633, 0.160673, 0.157992,
0.155254, 0.152459, 0.149606, 0.146695, 0.143723, 0.14069, 0.137594, 0.134435, 0.131211,
0.127921, 0.124563, 0.121136, 0.117638, 0.114069, 0.110426, 0.106708, 0.102913, 0.099039,
0.095085 },

{0.25, 0.249984, 0.249937, 0.249857, 0.249747, 0.249604, 0.249429, 0.249223, 0.248985,
0.248715, 0.248413, 0.248079, 0.247713, 0.247315, 0.246885, 0.246422, 0.245926, 0.245398,
0.244838, 0.244244, 0.243618, 0.242958, 0.242265, 0.241539, 0.240779, 0.239985, 0.239157,
0.238295, 0.237399, 0.236468, 0.235502, 0.234501, 0.233465, 0.232394, 0.231286, 0.230143,
0.228963, 0.227746, 0.226492, 0.225202, 0.223873, 0.222506, 0.221102, 0.219658, 0.218175,
0.216653, 0.215091, 0.213489, 0.211846, 0.210162, 0.208436, 0.206668, 0.204857, 0.203003,
0.201106, 0.199164, 0.197177, 0.195145, 0.193067, 0.190942, 0.18877, 0.18655, 0.184281,
0.181963, 0.179594, 0.177175, 0.174704, 0.17218, 0.169604, 0.166972, 0.164286, 0.161543,
0.158744, 0.155886, 0.152969, 0.149992, 0.146954, 0.143853, 0.140688, 0.137459, 0.134163,
0.130799, 0.127367, 0.123865, 0.12029, 0.116643, 0.11292, 0.109121, 0.105243, 0.101286,
0.097246 },

{0.255556, 0.255539, 0.255491, 0.25541, 0.255296, 0.25515, 0.254972, 0.254761, 0.254517,
0.254241, 0.253932, 0.25359, 0.253216, 0.252808, 0.252368, 0.251894, 0.251388, 0.250847,
0.250274, 0.249666, 0.249025, 0.24835, 0.247642, 0.246898, 0.246121, 0.245309, 0.244462,
0.24358, 0.242663, 0.241711, 0.240723, 0.239699, 0.238639, 0.237542, 0.23641, 0.23524,
0.234033, 0.232788, 0.231506, 0.230185, 0.228826, 0.227428, 0.225991, 0.224515, 0.222998,
0.221441, 0.219844, 0.218205, 0.216524, 0.214802, 0.213037, 0.211228, 0.209377, 0.207481,
0.20554, 0.203554, 0.201523, 0.199445, 0.19732, 0.195147, 0.192926, 0.190656, 0.188336,
0.185966, 0.183545, 0.181071, 0.178545, 0.175966, 0.173331, 0.170642, 0.167896, 0.165093,
0.162231, 0.15931, 0.156329, 0.153287, 0.150182, 0.147013, 0.143779, 0.14048, 0.137112,
0.133676, 0.13017, 0.126592, 0.122941, 0.119215, 0.115413, 0.111533, 0.107573, 0.103532,
0.099407 },

{0.261111, 0.261095, 0.261045, 0.260962, 0.260846, 0.260697, 0.260514, 0.260298, 0.260049,
0.259767, 0.259451, 0.259101, 0.258718, 0.258302, 0.257851, 0.257367, 0.256848, 0.256296,
0.255709, 0.255088, 0.254433, 0.253743, 0.253018, 0.252258, 0.251462, 0.250632, 0.249766,
0.248864, 0.247926, 0.246952, 0.245942, 0.244895, 0.243811, 0.24269, 0.241532, 0.240336,
0.239101, 0.237829, 0.236518, 0.235167, 0.233778, 0.232349, 0.23088, 0.22937, 0.227819,
0.226228, 0.224594, 0.222919, 0.221201, 0.21944, 0.217635, 0.215787, 0.213894, 0.211956,
0.209972, 0.207943, 0.205866, 0.203742, 0.20157, 0.19935, 0.19708, 0.19476, 0.192389, 0.189967,
0.187493, 0.184965, 0.182384, 0.179748, 0.177056, 0.174308, 0.171503, 0.168639, 0.165716,
0.162732, 0.159687, 0.156579, 0.153408, 0.150171, 0.146869, 0.143499, 0.14006, 0.136551,
0.132971, 0.129317, 0.12559, 0.121786, 0.117905, 0.113944, 0.109902, 0.105778, 0.101568 },

{0.266667, 0.26665, 0.266599, 0.266514, 0.266396, 0.266243, 0.266056, 0.265836, 0.265581,
0.265292, 0.264969, 0.264612, 0.264221, 0.263795, 0.263334, 0.262839, 0.262309, 0.261744,
0.261145, 0.26051, 0.25984, 0.259134, 0.258393, 0.257616, 0.256803, 0.255954, 0.255069,
0.254147, 0.253189, 0.252193, 0.251161, 0.250091, 0.248983, 0.247837, 0.246653, 0.24543,
0.244169, 0.242868, 0.241528, 0.240148, 0.238728, 0.237268, 0.235766, 0.234223, 0.232639,
0.231012, 0.229343, 0.227631, 0.225875, 0.224076, 0.222232, 0.220343, 0.218409, 0.216429,
0.214402, 0.212328, 0.210207, 0.208037, 0.205818, 0.203549, 0.201231, 0.198861, 0.196439,
0.193965, 0.191438, 0.188856, 0.18622, 0.183527, 0.180778, 0.177972, 0.175107, 0.172183,
0.169198, 0.166151, 0.163042, 0.159869, 0.156631, 0.153327, 0.149955, 0.146515, 0.143005,
0.139424, 0.13577, 0.132041, 0.128237, 0.124356, 0.120395, 0.116354, 0.112231, 0.108023,
0.103729 },

{0.272222, 0.272205, 0.272153, 0.272066, 0.271945, 0.271789, 0.271599, 0.271373, 0.271113,
0.270818, 0.270488, 0.270123, 0.269723, 0.269287, 0.268817, 0.268311, 0.267769, 0.267192,
0.26658, 0.265931, 0.265246, 0.264525, 0.263768, 0.262974, 0.262144, 0.261276, 0.260372,
0.25943, 0.258451, 0.257434, 0.256379, 0.255285, 0.254153, 0.252983, 0.251773, 0.250524,
0.249235, 0.247906, 0.246537, 0.245128, 0.243677, 0.242185, 0.240651, 0.239075, 0.237456,
0.235795, 0.23409, 0.232341, 0.230548, 0.22871, 0.226827, 0.224897, 0.222922, 0.2209, 0.21883,
0.216712, 0.214545, 0.212329, 0.210063, 0.207747, 0.205379, 0.202959, 0.200486, 0.19796,
0.19538, 0.192744, 0.190052, 0.187304, 0.184498, 0.181633, 0.178708, 0.175723, 0.172677,
0.169567, 0.166394, 0.163156, 0.159851, 0.15648, 0.15304, 0.14953, 0.145948, 0.142295,
0.138567, 0.134763, 0.130883, 0.126924, 0.122885, 0.118764, 0.114559, 0.110268, 0.10589 },

{0.277778, 0.27776, 0.277707, 0.277619, 0.277495, 0.277335, 0.277141, 0.276911, 0.276645,
0.276343, 0.276006, 0.275633, 0.275225, 0.27478, 0.274299, 0.273783, 0.27323, 0.27264,
0.272014, 0.271352, 0.270652, 0.269916, 0.269142, 0.268332, 0.267483, 0.266598, 0.265674,
0.264712, 0.263712, 0.262673, 0.261595, 0.260479, 0.259323, 0.258127, 0.256892, 0.255616,
0.2543, 0.252943, 0.251545, 0.250105, 0.248624, 0.2471, 0.245534, 0.243925, 0.242272, 0.240575,
0.238835, 0.237049, 0.235218, 0.233342, 0.231419, 0.229449, 0.227432, 0.225368, 0.223255,
0.221092, 0.218881, 0.216619, 0.214306, 0.211941, 0.209524, 0.207054, 0.204531, 0.201953,
0.199319, 0.196629, 0.193882, 0.191078, 0.188214, 0.185291, 0.182307, 0.179261, 0.176153,
0.17298, 0.169743, 0.16644, 0.163069, 0.15963, 0.156121, 0.152542, 0.148889, 0.145163,
0.141362, 0.137484, 0.133527, 0.129491, 0.125373, 0.121172, 0.116886, 0.112513, 0.108051 },

{0.283333, 0.283315, 0.283261, 0.283171, 0.283044, 0.282882, 0.282683, 0.282448, 0.282176,
0.281869, 0.281524, 0.281144, 0.280726, 0.280272, 0.279782, 0.279254, 0.278689, 0.278087,
0.277448, 0.276772, 0.276058, 0.275306, 0.274516, 0.273689, 0.272823, 0.271918, 0.270975,
0.269993, 0.268972, 0.267911, 0.266811, 0.265671, 0.264491, 0.26327, 0.262009, 0.260707,
0.259364, 0.257978, 0.256551, 0.255082, 0.253569, 0.252014, 0.250415, 0.248773, 0.247086,
0.245354, 0.243577, 0.241755, 0.239886, 0.237971, 0.236009, 0.233999, 0.23194, 0.229833,
0.227677, 0.225471, 0.223214, 0.220906, 0.218546, 0.216133, 0.213667, 0.211147, 0.208572,
0.205942, 0.203255, 0.200511, 0.197709, 0.194848, 0.191928, 0.188946, 0.185902, 0.182796,
0.179626, 0.176391, 0.17309, 0.169721, 0.166285, 0.162778, 0.159201, 0.155551, 0.151828,
0.14803, 0.144155, 0.140202, 0.13617, 0.132057, 0.127861, 0.12358, 0.119213, 0.114758, 0.110212
},

{0.288889, 0.28887, 0.288815, 0.288723, 0.288594, 0.288428, 0.288225, 0.287985, 0.287708,
0.287394, 0.287043, 0.286654, 0.286228, 0.285765, 0.285264, 0.284725, 0.284149, 0.283535,
0.282882, 0.282192, 0.281463, 0.280696, 0.27989, 0.279045, 0.278161, 0.277238, 0.276275,
0.275273, 0.274231, 0.273149, 0.272026, 0.270863, 0.269658, 0.268413, 0.267126, 0.265797,
0.264426, 0.263012, 0.261556, 0.260056, 0.258513, 0.256926, 0.255295, 0.253619, 0.251898,
0.250131, 0.248318, 0.246459, 0.244552, 0.242598, 0.240596, 0.238546, 0.236446, 0.234297,
0.232097, 0.229846, 0.227544, 0.22519, 0.222782, 0.220322, 0.217807, 0.215237, 0.212611,
0.209928, 0.207188, 0.20439, 0.201533, 0.198616, 0.195638, 0.192598, 0.189495, 0.186328,
0.183096, 0.179798, 0.176433, 0.173, 0.169497, 0.165923, 0.162278, 0.158558, 0.154764,
0.150894, 0.146946, 0.142919, 0.138811, 0.134621, 0.130347, 0.125987, 0.121539, 0.117002,
0.112373 },

{0.294444, 0.294426, 0.294369, 0.294275, 0.294143, 0.293974, 0.293767, 0.293522, 0.29324,
0.292919, 0.292561, 0.292164, 0.291729, 0.291257, 0.290746, 0.290196, 0.289608, 0.288981,
0.288316, 0.287611, 0.286868, 0.286085, 0.285263, 0.284401, 0.283499, 0.282557, 0.281575,
0.280552, 0.279489, 0.278385, 0.27724, 0.276053, 0.274824, 0.273554, 0.272241, 0.270885,
0.269486, 0.268045, 0.266559, 0.265029, 0.263455, 0.261837, 0.260173, 0.258463, 0.256708,
0.254906, 0.253057, 0.25116, 0.249216, 0.247223, 0.245181, 0.24309, 0.240949, 0.238757,
0.236514, 0.234219, 0.231872, 0.229471, 0.227017, 0.224508, 0.221943, 0.219323, 0.216646,
0.213912, 0.211119, 0.208266, 0.205354, 0.20238, 0.199345, 0.196247, 0.193084, 0.189857,
0.186564, 0.183203, 0.179774, 0.176276, 0.172707, 0.169066, 0.165352, 0.161563, 0.157698,
0.153756, 0.149735, 0.145634, 0.141451, 0.137184, 0.132832, 0.128392, 0.123864, 0.119246,
0.114534 },

{0.3, 0.299981, 0.299923, 0.299827, 0.299693, 0.29952, 0.299309, 0.299059, 0.298771, 0.298444,
0.298078, 0.297674, 0.297231, 0.296748, 0.296227, 0.295667, 0.295067, 0.294428, 0.293749,
0.29303, 0.292272, 0.291473, 0.290635, 0.289756, 0.288836, 0.287875, 0.286874, 0.285831,
0.284747, 0.283621, 0.282452, 0.281242, 0.279989, 0.278693, 0.277354, 0.275972, 0.274546,
0.273075, 0.271561, 0.270001, 0.268396, 0.266745, 0.265049, 0.263305, 0.261515, 0.259678,
0.257793, 0.255859, 0.253877, 0.251845, 0.249764, 0.247632, 0.245449, 0.243215, 0.240928,
0.238589, 0.236196, 0.233749, 0.231248, 0.228691, 0.226077, 0.223407, 0.220679, 0.217892,
0.215046, 0.212139, 0.209172, 0.206142, 0.203049, 0.199892, 0.19667, 0.193383, 0.190028,
0.186604, 0.183112, 0.179549, 0.175914, 0.172206, 0.168423, 0.164565, 0.16063, 0.156616,
0.152522, 0.148347, 0.144088, 0.139745, 0.135315, 0.130797, 0.126189, 0.121489, 0.116695 },

{0.305556, 0.305536, 0.305477, 0.305379, 0.305243, 0.305066, 0.304851, 0.304596, 0.304302,
0.303969, 0.303596, 0.303184, 0.302732, 0.30224, 0.301708, 0.301137, 0.300525, 0.299874,
0.299182, 0.298449, 0.297676, 0.296862, 0.296006, 0.29511, 0.294172, 0.293193, 0.292172,
0.291109, 0.290003, 0.288855, 0.287664, 0.28643, 0.285153, 0.283832, 0.282467, 0.281057,
0.279604, 0.278105, 0.27656, 0.27497, 0.273334, 0.271652, 0.269922, 0.268146, 0.266321,
0.264448, 0.262527, 0.260556, 0.258536, 0.256466, 0.254344, 0.252172, 0.249947, 0.24767,
0.24534, 0.242956, 0.240518, 0.238025, 0.235476, 0.23287, 0.230208, 0.227487, 0.224708,
0.221869, 0.218969, 0.216009, 0.212986, 0.2099, 0.20675, 0.203535, 0.200253, 0.196905,
0.193489, 0.190003, 0.186446, 0.182818, 0.179118, 0.175342, 0.171492, 0.167565, 0.163559,
0.159474, 0.155307, 0.151058, 0.146724, 0.142305, 0.137798, 0.133201, 0.128513, 0.123732,
0.118856 },

{0.311111, 0.311091, 0.311031, 0.310932, 0.310792, 0.310612, 0.310393, 0.310133, 0.309834,
0.309494, 0.309114, 0.308693, 0.308233, 0.307731, 0.30719, 0.306607, 0.305984, 0.305319,
0.304614, 0.303867, 0.303079, 0.302249, 0.301377, 0.300464, 0.299508, 0.29851, 0.297469,
0.296385, 0.295259, 0.294088, 0.292875, 0.291617, 0.290315, 0.288969, 0.287578, 0.286142,
0.28466, 0.283132, 0.281559, 0.279938, 0.278271, 0.276557, 0.274794, 0.272984, 0.271125,
0.269217, 0.267259, 0.265251, 0.263193, 0.261083, 0.258922, 0.256708, 0.254442, 0.252123,
0.249749, 0.247321, 0.244837, 0.242297, 0.239701, 0.237047, 0.234335, 0.231564, 0.228734,
0.225843, 0.22289, 0.219875, 0.216797, 0.213654, 0.210447, 0.207174, 0.203833, 0.200424,
0.196946, 0.193398, 0.189778, 0.186085, 0.182318, 0.178476, 0.174558, 0.170561, 0.166485,
0.162329, 0.15809, 0.153767, 0.149359, 0.144863, 0.140279, 0.135604, 0.130837, 0.125975,
0.121017 },

{0.316667, 0.316646, 0.316585, 0.316484, 0.316341, 0.316158, 0.315935, 0.31567, 0.315365,
0.315019, 0.314631, 0.314203, 0.313733, 0.313223, 0.31267, 0.312077, 0.311442, 0.310765,
0.310046, 0.309285, 0.308482, 0.307636, 0.306748, 0.305817, 0.304843, 0.303826, 0.302765,
0.301661, 0.300513, 0.299321, 0.298084, 0.296803, 0.295477, 0.294105, 0.292688, 0.291224,
0.289715, 0.288158, 0.286555, 0.284905, 0.283206, 0.28146, 0.279664, 0.27782, 0.275926,
0.273983, 0.271988, 0.269943, 0.267847, 0.265698, 0.263497, 0.261243, 0.258935, 0.256572,
0.254155, 0.251682, 0.249153, 0.246567, 0.243923, 0.241221, 0.23846, 0.235638, 0.232756,
0.229813, 0.226807, 0.223738, 0.220604, 0.217406, 0.214141, 0.210809, 0.207409, 0.20394,
0.200401, 0.19679, 0.193106, 0.189349, 0.185516, 0.181608, 0.177621, 0.173555, 0.169409,
0.165182, 0.16087, 0.156474, 0.151991, 0.14742, 0.142759, 0.138006, 0.133159, 0.128218,
0.123178 },

{0.322222, 0.322202, 0.322139, 0.322036, 0.321891, 0.321704, 0.321477, 0.321207, 0.320896,
0.320543, 0.320149, 0.319712, 0.319234, 0.318714, 0.318151, 0.317546, 0.316899, 0.316209,
0.315477, 0.314702, 0.313884, 0.313022, 0.312118, 0.311169, 0.310177, 0.309141, 0.308061,
0.306936, 0.305767, 0.304552, 0.303293, 0.301987, 0.300636, 0.299239, 0.297796, 0.296305,
0.294768, 0.293183, 0.29155, 0.289869, 0.288139, 0.286361, 0.284532, 0.282654, 0.280726,
0.278746, 0.276716, 0.274633, 0.272498, 0.27031, 0.268069, 0.265774, 0.263424, 0.261019,
0.258558, 0.25604, 0.253466, 0.250833, 0.248142, 0.245391, 0.242581, 0.239709, 0.236776,
0.23378, 0.230721, 0.227597, 0.224408, 0.221154, 0.217832, 0.214442, 0.210982, 0.207453,
0.203852, 0.200178, 0.196431, 0.192609, 0.188711, 0.184736, 0.180681, 0.176547, 0.172331,
0.168032, 0.163648, 0.159179, 0.154621, 0.149975, 0.145237, 0.140407, 0.135481, 0.13046,
0.125339 },

{0.327778, 0.327757, 0.327693, 0.327588, 0.32744, 0.32725, 0.327018, 0.326744, 0.326427,
0.326068, 0.325666, 0.325221, 0.324734, 0.324204, 0.323631, 0.323015, 0.322356, 0.321654,
0.320908, 0.320119, 0.319285, 0.318408, 0.317487, 0.316521, 0.315511, 0.314456, 0.313356,
0.31221, 0.311019, 0.309783, 0.3085, 0.307171, 0.305795, 0.304372, 0.302903, 0.301385, 0.29982,
0.298206, 0.296543, 0.294832, 0.293071, 0.29126, 0.289398, 0.287486, 0.285523, 0.283508,
0.28144, 0.27932, 0.277147, 0.27492, 0.272639, 0.270303, 0.267911, 0.265463, 0.262958,
0.260396, 0.257775, 0.255096, 0.252357, 0.249558, 0.246698, 0.243776, 0.240792, 0.237743,
0.234631, 0.231453, 0.228209, 0.224898, 0.221519, 0.21807, 0.214552, 0.210962, 0.207299,
0.203563, 0.199753, 0.195866, 0.191903, 0.187861, 0.183739, 0.179535, 0.17525, 0.17088,
0.166424, 0.161882, 0.15725, 0.152528, 0.147714, 0.142806, 0.137803, 0.132701, 0.1275 },

{0.333333, 0.333312, 0.333247, 0.33314, 0.33299, 0.332796, 0.33256, 0.332281, 0.331958,
0.331592, 0.331183, 0.33073, 0.330234, 0.329695, 0.329111, 0.328484, 0.327813, 0.327098,
0.326339, 0.325535, 0.324686, 0.323793, 0.322855, 0.321872, 0.320843, 0.319769, 0.318649,
0.317483, 0.316271, 0.315012, 0.313706, 0.312353, 0.310952, 0.309504, 0.308008, 0.306463,
0.304869, 0.303227, 0.301534, 0.299792, 0.298, 0.296156, 0.294262, 0.292316, 0.290318,
0.288267, 0.286163, 0.284005, 0.281794, 0.279527, 0.277206, 0.274828, 0.272394, 0.269903,
0.267355, 0.264748, 0.262082, 0.259356, 0.25657, 0.253722, 0.250812, 0.24784, 0.244804,
0.241703, 0.238538, 0.235305, 0.232006, 0.228639, 0.225202, 0.221695, 0.218117, 0.214467,
0.210743, 0.206945, 0.203071, 0.19912, 0.195091, 0.190983, 0.186793, 0.182521, 0.178166,
0.173725, 0.169198, 0.164582, 0.159877, 0.15508, 0.15019, 0.145205, 0.140123, 0.134943,
0.129662 },

{0.338889, 0.338867, 0.338801, 0.338692, 0.338539, 0.338342, 0.338102, 0.337817, 0.337489,
0.337116, 0.3367, 0.336239, 0.335734, 0.335185, 0.334591, 0.333953, 0.33327, 0.332542,
0.331769, 0.330951, 0.330087, 0.329178, 0.328223, 0.327222, 0.326175, 0.325082, 0.323942,
0.322755, 0.321521, 0.32024, 0.318911, 0.317534, 0.316108, 0.314634, 0.313112, 0.31154,
0.309918, 0.308246, 0.306524, 0.304751, 0.302927, 0.301051, 0.299123, 0.297143, 0.29511,
0.293023, 0.290883, 0.288687, 0.286437, 0.284132, 0.28177, 0.279351, 0.276875, 0.274341,
0.271749, 0.269097, 0.266385, 0.263612, 0.260778, 0.257882, 0.254923, 0.2519, 0.248813,
0.24566, 0.242441, 0.239154, 0.235799, 0.232376, 0.228882, 0.225317, 0.22168, 0.217969,
0.214184, 0.210323, 0.206386, 0.202371, 0.198276, 0.194101, 0.189844, 0.185504, 0.181079,
0.176568, 0.171969, 0.167281, 0.162502, 0.15763, 0.152664, 0.147603, 0.142443, 0.137184,
0.131823 },

{0.344444, 0.344422, 0.344355, 0.344244, 0.344089, 0.343888, 0.343643, 0.343354, 0.34302,
0.34264, 0.342217, 0.341748, 0.341234, 0.340675, 0.340071, 0.339421, 0.338726, 0.337985,
0.337198, 0.336366, 0.335487, 0.334562, 0.33359, 0.332572, 0.331506, 0.330394, 0.329234,
0.328026, 0.326771, 0.325467, 0.324114, 0.322713, 0.321263, 0.319763, 0.318214, 0.316614,
0.314964, 0.313264, 0.311511, 0.309708, 0.307852, 0.305944, 0.303983, 0.301968, 0.2999,
0.297777, 0.2956, 0.293367, 0.291078, 0.288733, 0.286331, 0.283871, 0.281353, 0.278776,
0.276139, 0.273442, 0.270685, 0.267865, 0.264984, 0.262039, 0.25903, 0.255957, 0.252818,
0.249613, 0.24634, 0.242999, 0.239589, 0.236109, 0.232558, 0.228935, 0.225238, 0.221467,
0.217621, 0.213698, 0.209698, 0.205618, 0.201458, 0.197217, 0.192892, 0.188484, 0.18399,
0.179408, 0.174738, 0.169977, 0.165125, 0.160179, 0.155137, 0.149999, 0.144762, 0.139424,
0.133984 },

{0.35, 0.349977, 0.349909, 0.349796, 0.349638, 0.349434, 0.349185, 0.34889, 0.34855, 0.348165,
0.347733, 0.347256, 0.346733, 0.346165, 0.34555, 0.344889, 0.344182, 0.343428, 0.342628,
0.34178, 0.340886, 0.339945, 0.338957, 0.337921, 0.336837, 0.335705, 0.334525, 0.333296,
0.332019, 0.330692, 0.329317, 0.327891, 0.326416, 0.324891, 0.323315, 0.321688, 0.320009,
0.318279, 0.316497, 0.314663, 0.312775, 0.310834, 0.30884, 0.306791, 0.304688, 0.302529,
0.300315, 0.298044, 0.295716, 0.293332, 0.290889, 0.288388, 0.285827, 0.283207, 0.280526,
0.277785, 0.274981, 0.272115, 0.269186, 0.266192, 0.263134, 0.26001, 0.256819, 0.253562,
0.250236, 0.24684, 0.243375, 0.239839, 0.23623, 0.232548, 0.228793, 0.224962, 0.221054,
0.217069, 0.213005, 0.208862, 0.204637, 0.200329, 0.195938, 0.191461, 0.186897, 0.182245,
0.177504, 0.172671, 0.167746, 0.162725, 0.157609, 0.152394, 0.14708, 0.141664, 0.136145 },

{0.355556, 0.355533, 0.355463, 0.355348, 0.355187, 0.35498, 0.354726, 0.354427, 0.354081,
0.353688, 0.35325, 0.352765, 0.352233, 0.351654, 0.351029, 0.350356, 0.349637, 0.34887,
0.348056, 0.347195, 0.346285, 0.345328, 0.344322, 0.343269, 0.342166, 0.341015, 0.339815,
0.338565, 0.337266, 0.335917, 0.334518, 0.333068, 0.331568, 0.330016, 0.328414, 0.326759,
0.325052, 0.323293, 0.321481, 0.319615, 0.317696, 0.315723, 0.313695, 0.311611, 0.309473,
0.307278, 0.305027, 0.302718, 0.300352, 0.297927, 0.295444, 0.292901, 0.290299, 0.287635,
0.284911, 0.282124, 0.279274, 0.276361, 0.273384, 0.270342, 0.267234, 0.264059, 0.260817,
0.257507, 0.254127, 0.250678, 0.247157, 0.243564, 0.239898, 0.236159, 0.232344, 0.228452,
0.224484, 0.220437, 0.21631, 0.212102, 0.207812, 0.203438, 0.198979, 0.194435, 0.189802,
0.18508, 0.180268, 0.175363, 0.170364, 0.16527, 0.160079, 0.154789, 0.149398, 0.143904,
0.138306 },

{0.361111, 0.361088, 0.361017, 0.3609, 0.360736, 0.360526, 0.360268, 0.359963, 0.359611,
0.359212, 0.358766, 0.358273, 0.357732, 0.357143, 0.356507, 0.355824, 0.355092, 0.354312,
0.353484, 0.352608, 0.351683, 0.35071, 0.349687, 0.348616, 0.347495, 0.346324, 0.345103,
0.343833, 0.342512, 0.34114, 0.339718, 0.338244, 0.336718, 0.335141, 0.333511, 0.331829,
0.330094, 0.328305, 0.326463, 0.324566, 0.322615, 0.320609, 0.318547, 0.316429, 0.314255,
0.312024, 0.309736, 0.307389, 0.304984, 0.30252, 0.299996, 0.297412, 0.294767, 0.29206,
0.289291, 0.286459, 0.283564, 0.280604, 0.277579, 0.274488, 0.27133, 0.268105, 0.264811,
0.261448, 0.258015, 0.254511, 0.250935, 0.247286, 0.243563, 0.239765, 0.235891, 0.231939,
0.227909, 0.2238, 0.21961, 0.215338, 0.210983, 0.206544, 0.202018, 0.197405, 0.192704,
0.187912, 0.183029, 0.178053, 0.172981, 0.167814, 0.162548, 0.157182, 0.151714, 0.146143,
0.140467 },

{0.366667, 0.366643, 0.366571, 0.366452, 0.366286, 0.366071, 0.365809, 0.365499, 0.365142,
0.364736, 0.364282, 0.36378, 0.363231, 0.362632, 0.361986, 0.36129, 0.360547, 0.359754,
0.358912, 0.358021, 0.357081, 0.356091, 0.355052, 0.353962, 0.352822, 0.351632, 0.350391,
0.3491, 0.347757, 0.346362, 0.344916, 0.343418, 0.341867, 0.340263, 0.338607, 0.336897,
0.335133, 0.333315, 0.331442, 0.329515, 0.327531, 0.325492, 0.323397, 0.321245, 0.319035,
0.316768, 0.314442, 0.312058, 0.309614, 0.30711, 0.304545, 0.301919, 0.299232, 0.296482,
0.293668, 0.290791, 0.28785, 0.284843, 0.281769, 0.27863, 0.275422, 0.272146, 0.268801,
0.265385, 0.261899, 0.258341, 0.254709, 0.251004, 0.247223, 0.243367, 0.239434, 0.235422,
0.231331, 0.22716, 0.222907, 0.218571, 0.214151, 0.209646, 0.205053, 0.200373, 0.195603,
0.190742, 0.185788, 0.18074, 0.175596, 0.170355, 0.165015, 0.159574, 0.15403, 0.148382,
0.142628 },

{0.372222, 0.372198, 0.372125, 0.372004, 0.371835, 0.371617, 0.371351, 0.371035, 0.370672,
0.370259, 0.369798, 0.369288, 0.368729, 0.368121, 0.367464, 0.366757, 0.366001, 0.365195,
0.364339, 0.363434, 0.362478, 0.361472, 0.360415, 0.359308, 0.358149, 0.356939, 0.355678,
0.354365, 0.353, 0.351583, 0.350113, 0.34859, 0.347014, 0.345384, 0.343701, 0.341963, 0.34017,
0.338323, 0.33642, 0.334461, 0.332446, 0.330374, 0.328245, 0.326058, 0.323813, 0.321509,
0.319146, 0.316723, 0.31424, 0.311696, 0.309091, 0.306424, 0.303693, 0.3009, 0.298042, 0.29512,
0.292132, 0.289078, 0.285957, 0.282768, 0.279511, 0.276184, 0.272787, 0.269319, 0.265779,
0.262166, 0.258479, 0.254717, 0.25088, 0.246965, 0.242973, 0.238901, 0.234749, 0.230516,
0.2262, 0.2218, 0.217316, 0.212744, 0.208085, 0.203337, 0.198499, 0.193568, 0.188544, 0.183425,
0.178209, 0.172894, 0.16748, 0.161964, 0.156345, 0.15062, 0.144789 },

{0.377778, 0.377753, 0.377679, 0.377556, 0.377384, 0.377163, 0.376892, 0.376572, 0.376202,
0.375783, 0.375314, 0.374796, 0.374227, 0.373609, 0.372941, 0.372223, 0.371455, 0.370636,
0.369766, 0.368846, 0.367874, 0.366852, 0.365778, 0.364652, 0.363475, 0.362246, 0.360964,
0.35963, 0.358243, 0.356802, 0.355309, 0.353761, 0.35216, 0.350504, 0.348793, 0.347027,
0.345206, 0.343329, 0.341395, 0.339405, 0.337358, 0.335253, 0.33309, 0.330868, 0.328587,
0.326247, 0.323847, 0.321386, 0.318864, 0.31628, 0.313634, 0.310924, 0.308151, 0.305314,
0.302412, 0.299444, 0.29641, 0.293309, 0.29014, 0.286902, 0.283595, 0.280217, 0.276769,
0.273248, 0.269655, 0.265987, 0.262245, 0.258427, 0.254532, 0.250559, 0.246508, 0.242376,
0.238163, 0.233868, 0.229489, 0.225026, 0.220476, 0.21584, 0.211114, 0.206299, 0.201392,
0.196392, 0.191297, 0.186107, 0.180819, 0.175432, 0.169944, 0.164354, 0.158659, 0.152858,
0.14695 },

{0.383333, 0.383308, 0.383233, 0.383108, 0.382933, 0.382708, 0.382433, 0.382108, 0.381732,
0.381306, 0.38083, 0.380303, 0.379726, 0.379098, 0.378419, 0.377689, 0.376908, 0.376076,
0.375192, 0.374257, 0.37327, 0.372231, 0.37114, 0.369996, 0.3688, 0.367551, 0.366249, 0.364893,
0.363484, 0.36202, 0.360503, 0.358931, 0.357304, 0.355622, 0.353884, 0.35209, 0.35024,
0.348333, 0.346369, 0.344347, 0.342267, 0.340129, 0.337932, 0.335676, 0.333359, 0.330982,
0.328545, 0.326045, 0.323484, 0.32086, 0.318173, 0.315422, 0.312606, 0.309725, 0.306779,
0.303766, 0.300685, 0.297537, 0.294319, 0.291033, 0.287675, 0.284247, 0.280747, 0.277173,
0.273526, 0.269804, 0.266007, 0.262132, 0.25818, 0.254149, 0.250038, 0.245847, 0.241573,
0.237216, 0.232775, 0.228247, 0.223633, 0.218931, 0.214139, 0.209256, 0.204281, 0.199212,
0.194048, 0.188787, 0.183427, 0.177968, 0.172407, 0.166742, 0.160973, 0.155096, 0.149111 },

{0.388889, 0.388863, 0.388787, 0.38866, 0.388482, 0.388254, 0.387974, 0.387644, 0.387262,
0.386829, 0.386345, 0.38581, 0.385223, 0.384585, 0.383896, 0.383154, 0.382361, 0.381515,
0.380618, 0.379668, 0.378665, 0.377609, 0.376501, 0.375339, 0.374124, 0.372855, 0.371532,
0.370155, 0.368724, 0.367237, 0.365696, 0.364099, 0.362446, 0.360738, 0.358972, 0.35715,
0.355271, 0.353335, 0.35134, 0.349287, 0.347175, 0.345003, 0.342772, 0.340481, 0.338128,
0.335715, 0.33324, 0.330702, 0.328101, 0.325437, 0.322709, 0.319916, 0.317057, 0.314133,
0.311142, 0.308083, 0.304956, 0.30176, 0.298495, 0.295159, 0.291752, 0.288273, 0.28472,
0.281094, 0.277393, 0.273617, 0.269764, 0.265833, 0.261824, 0.257735, 0.253565, 0.249313,
0.244979, 0.24056, 0.236056, 0.231465, 0.226787, 0.222019, 0.217161, 0.212211, 0.207168,
0.20203, 0.196796, 0.191464, 0.186034, 0.180502, 0.174868, 0.169129, 0.163285, 0.157333,
0.151272 },

{0.394444, 0.394419, 0.394341, 0.394212, 0.394032, 0.393799, 0.393515, 0.393179, 0.392792,
0.392352, 0.391861, 0.391317, 0.390721, 0.390073, 0.389372, 0.388619, 0.387813, 0.386954,
0.386043, 0.385078, 0.384059, 0.382987, 0.381861, 0.380681, 0.379447, 0.378158, 0.376815,
0.375416, 0.373962, 0.372453, 0.370887, 0.369265, 0.367587, 0.365852, 0.364059, 0.362209,
0.360301, 0.358334, 0.356309, 0.354224, 0.352079, 0.349875, 0.347609, 0.345283, 0.342895,
0.340444, 0.337931, 0.335355, 0.332715, 0.330011, 0.327241, 0.324406, 0.321505, 0.318537,
0.315501, 0.312396, 0.309223, 0.30598, 0.302666, 0.299281, 0.295824, 0.292294, 0.28869,
0.285011, 0.281256, 0.277425, 0.273517, 0.26953, 0.265463, 0.261316, 0.257087, 0.252776,
0.24838, 0.2439, 0.239333, 0.234679, 0.229936, 0.225103, 0.220179, 0.215162, 0.210051,
0.204845, 0.199541, 0.194139, 0.188637, 0.183034, 0.177327, 0.171515, 0.165597, 0.15957,
0.153433 },

{0.4, 0.399974, 0.399895, 0.399764, 0.399581, 0.399345, 0.399056, 0.398715, 0.398321, 0.397875,
0.397376, 0.396824, 0.396218, 0.39556, 0.394849, 0.394084, 0.393265, 0.392393, 0.391467,
0.390487, 0.389453, 0.388364, 0.387221, 0.386022, 0.384769, 0.38346, 0.382096, 0.380676,
0.379199, 0.377667, 0.376077, 0.37443, 0.372726, 0.370964, 0.369144, 0.367266, 0.365328,
0.363332, 0.361275, 0.359159, 0.356982, 0.354744, 0.352444, 0.350082, 0.347658, 0.345171,
0.34262, 0.340005, 0.337326, 0.334581, 0.33177, 0.328893, 0.325949, 0.322937, 0.319856,
0.316706, 0.313486, 0.310195, 0.306833, 0.303399, 0.299892, 0.296311, 0.292655, 0.288923,
0.285115, 0.281229, 0.277265, 0.273222, 0.269098, 0.264893, 0.260605, 0.256234, 0.251777,
0.247235, 0.242606, 0.237889, 0.233082, 0.228184, 0.223194, 0.21811, 0.212931, 0.207656,
0.202284, 0.196812, 0.191239, 0.185564, 0.179785, 0.1739, 0.167907, 0.161806, 0.155594 },

{0.405556, 0.405529, 0.405449, 0.405316, 0.40513, 0.40489, 0.404597, 0.404251, 0.403851,
0.403398, 0.402891, 0.40233, 0.401716, 0.401047, 0.400325, 0.399548, 0.398717, 0.397831,
0.396891, 0.395896, 0.394846, 0.39374, 0.392579, 0.391363, 0.39009, 0.388761, 0.387376,
0.385934, 0.384435, 0.382879, 0.381265, 0.379594, 0.377864, 0.376075, 0.374227, 0.37232,
0.370354, 0.368327, 0.36624, 0.364091, 0.361882, 0.35961, 0.357276, 0.354879, 0.352419,
0.349894, 0.347306, 0.344652, 0.341933, 0.339148, 0.336296, 0.333376, 0.330389, 0.327333,
0.324207, 0.321011, 0.317745, 0.314407, 0.310996, 0.307513, 0.303955, 0.300323, 0.296615,
0.292831, 0.288969, 0.285029, 0.28101, 0.27691, 0.272729, 0.268465, 0.264119, 0.259687,
0.25517, 0.250567, 0.245875, 0.241094, 0.236223, 0.23126, 0.226204, 0.221054, 0.215808,
0.210465, 0.205023, 0.199482, 0.193838, 0.188092, 0.182241, 0.176283, 0.170217, 0.164042,
0.157755 },

{0.411111, 0.411084, 0.411003, 0.410868, 0.410679, 0.410436, 0.410138, 0.409786, 0.409381,
0.40892, 0.408406, 0.407836, 0.407212, 0.406534, 0.4058, 0.405012, 0.404168, 0.403269,
0.402314, 0.401304, 0.400238, 0.399116, 0.397937, 0.396702, 0.39541, 0.394061, 0.392655,
0.391191, 0.38967, 0.38809, 0.386452, 0.384755, 0.382999, 0.381184, 0.379309, 0.377373,
0.375377, 0.37332, 0.371202, 0.369021, 0.366779, 0.364473, 0.362105, 0.359673, 0.357176,
0.354615, 0.351988, 0.349296, 0.346537, 0.343711, 0.340818, 0.337856, 0.334825, 0.331725,
0.328554, 0.325313, 0.322, 0.318614, 0.315155, 0.311622, 0.308015, 0.304331, 0.300572,
0.296734, 0.292819, 0.288824, 0.284749, 0.280593, 0.276355, 0.272033, 0.267628, 0.263137,
0.258559, 0.253894, 0.24914, 0.244296, 0.239361, 0.234333, 0.229211, 0.223995, 0.218682,
0.213271, 0.20776, 0.202149, 0.196435, 0.190618, 0.184695, 0.178665, 0.172526, 0.166277,
0.159916 },

{0.416667, 0.416639, 0.416557, 0.41642, 0.416228, 0.415981, 0.415679, 0.415322, 0.41491,
0.414443, 0.41392, 0.413342, 0.412709, 0.41202, 0.411275, 0.410475, 0.409618, 0.408706,
0.407737, 0.406711, 0.405629, 0.40449, 0.403294, 0.40204, 0.400729, 0.39936, 0.397933,
0.396447, 0.394903, 0.3933, 0.391637, 0.389915, 0.388133, 0.386291, 0.384388, 0.382424,
0.380398, 0.378311, 0.376161, 0.373949, 0.371673, 0.369334, 0.366931, 0.364463, 0.361931,
0.359332, 0.356667, 0.353936, 0.351137, 0.348271, 0.345336, 0.342332, 0.339258, 0.336113,
0.332898, 0.32961, 0.32625, 0.322817, 0.31931, 0.315727, 0.312069, 0.308335, 0.304523,
0.300633, 0.296664, 0.292614, 0.288484, 0.284272, 0.279976, 0.275597, 0.271132, 0.266581,
0.261943, 0.257216, 0.2524, 0.247493, 0.242494, 0.237402, 0.232215, 0.226932, 0.221552,
0.216073, 0.210494, 0.204813, 0.19903, 0.193142, 0.187147, 0.181046, 0.174834, 0.168512,
0.162077 },

{0.422222, 0.422194, 0.422111, 0.421972, 0.421777, 0.421526, 0.42122, 0.420857, 0.420439,
0.419965, 0.419435, 0.418848, 0.418205, 0.417506, 0.41675, 0.415938, 0.415069, 0.414142,
0.413159, 0.412118, 0.41102, 0.409864, 0.40865, 0.407378, 0.406047, 0.404658, 0.403209,
0.401702, 0.400135, 0.398508, 0.396821, 0.395073, 0.393265, 0.391396, 0.389465, 0.387472,
0.385417, 0.383299, 0.381118, 0.378874, 0.376565, 0.374192, 0.371754, 0.369251, 0.366682,
0.364046, 0.361343, 0.358573, 0.355734, 0.352827, 0.34985, 0.346804, 0.343686, 0.340498,
0.337237, 0.333904, 0.330497, 0.327016, 0.32346, 0.319828, 0.31612, 0.312334, 0.30847,
0.304527, 0.300504, 0.2964, 0.292214, 0.287945, 0.283593, 0.279155, 0.274632, 0.270021,
0.265323, 0.260535, 0.255656, 0.250686, 0.245624, 0.240467, 0.235214, 0.229865, 0.224418,
0.218872, 0.213225, 0.207475, 0.201622, 0.195664, 0.189598, 0.183425, 0.177141, 0.170746,
0.164238 },

{0.427778, 0.42775, 0.427665, 0.427524, 0.427326, 0.427071, 0.42676, 0.426393, 0.425968,
0.425487, 0.424949, 0.424354, 0.423701, 0.422992, 0.422225, 0.4214, 0.420518, 0.419578,
0.41858, 0.417524, 0.41641, 0.415237, 0.414005, 0.412714, 0.411364, 0.409954, 0.408485,
0.406955, 0.405365, 0.403714, 0.402003, 0.40023, 0.398395, 0.396499, 0.39454, 0.392518,
0.390434, 0.388285, 0.386073, 0.383796, 0.381455, 0.379048, 0.376575, 0.374036, 0.37143,
0.368757, 0.366016, 0.363206, 0.360328, 0.357379, 0.354361, 0.351272, 0.348111, 0.344878,
0.341572, 0.338193, 0.334739, 0.33121, 0.327605, 0.323924, 0.320165, 0.316328, 0.312412,
0.308416, 0.30434, 0.300181, 0.29594, 0.291614, 0.287205, 0.282709, 0.278127, 0.273457,
0.268698, 0.263848, 0.258908, 0.253875, 0.248749, 0.243527, 0.23821, 0.232795, 0.227282,
0.221668, 0.215953, 0.210134, 0.204212, 0.198183, 0.192048, 0.185803, 0.179448, 0.17298,
0.166399 },

{0.433333, 0.433305, 0.433219, 0.433075, 0.432875, 0.432616, 0.432301, 0.431928, 0.431497,
0.431009, 0.430463, 0.429859, 0.429197, 0.428477, 0.427699, 0.426862, 0.425967, 0.425014,
0.424001, 0.42293, 0.421799, 0.420609, 0.419359, 0.418049, 0.41668, 0.415249, 0.413759,
0.412207, 0.410594, 0.408919, 0.407183, 0.405385, 0.403524, 0.4016, 0.399613, 0.397562,
0.395448, 0.393269, 0.391025, 0.388716, 0.386341, 0.3839, 0.381392, 0.378818, 0.376175,
0.373464, 0.370685, 0.367836, 0.364917, 0.361928, 0.358868, 0.355736, 0.352531, 0.349254,
0.345903, 0.342477, 0.338976, 0.3354, 0.331746, 0.328015, 0.324206, 0.320318, 0.31635,
0.312301, 0.30817, 0.303957, 0.29966, 0.295279, 0.290812, 0.286258, 0.281617, 0.276887,
0.272068, 0.267158, 0.262155, 0.25706, 0.25187, 0.246584, 0.241202, 0.235721, 0.230141,
0.22446, 0.218677, 0.212791, 0.206799, 0.200701, 0.194495, 0.188179, 0.181753, 0.175214,
0.16856 },

{0.438889, 0.43886, 0.438773, 0.438627, 0.438423, 0.438162, 0.437841, 0.437463, 0.437026,
0.436531, 0.435977, 0.435364, 0.434692, 0.433962, 0.433173, 0.432324, 0.431416, 0.430449,
0.429421, 0.428334, 0.427187, 0.42598, 0.424712, 0.423384, 0.421994, 0.420543, 0.419031,
0.417457, 0.415821, 0.414123, 0.412362, 0.410538, 0.40865, 0.406699, 0.404684, 0.402604,
0.40046, 0.39825, 0.395974, 0.393633, 0.391225, 0.388749, 0.386207, 0.383596, 0.380917,
0.378168, 0.37535, 0.372462, 0.369503, 0.366473, 0.363371, 0.360196, 0.356948, 0.353626,
0.350229, 0.346757, 0.34321, 0.339585, 0.335883, 0.332102, 0.328243, 0.324303, 0.320283,
0.316181, 0.311996, 0.307728, 0.303376, 0.298938, 0.294414, 0.289802, 0.285103, 0.280313,
0.275433, 0.270462, 0.265398, 0.26024, 0.254986, 0.249637, 0.24419, 0.238643, 0.232997,
0.22725, 0.221399, 0.215444, 0.209384, 0.203217, 0.196941, 0.190555, 0.184057, 0.177446,
0.170721 },

{0.444444, 0.444415, 0.444326, 0.444179, 0.443972, 0.443707, 0.443382, 0.442998, 0.442555,
0.442052, 0.44149, 0.440869, 0.440188, 0.439447, 0.438646, 0.437785, 0.436864, 0.435883,
0.434841, 0.433738, 0.432575, 0.43135, 0.430064, 0.428717, 0.427308, 0.425836, 0.424303,
0.422706, 0.421047, 0.419325, 0.417539, 0.415689, 0.413775, 0.411796, 0.409753, 0.407644,
0.405469, 0.403229, 0.400921, 0.398547, 0.396106, 0.393596, 0.391018, 0.388371, 0.385655,
0.382869, 0.380012, 0.377085, 0.374085, 0.371014, 0.36787, 0.364652, 0.36136, 0.357993,
0.354551, 0.351033, 0.347438, 0.343765, 0.340014, 0.336184, 0.332274, 0.328283, 0.32421,
0.320055, 0.315817, 0.311494, 0.307086, 0.302592, 0.298011, 0.293342, 0.288583, 0.283734,
0.278794, 0.273762, 0.268636, 0.263415, 0.258099, 0.252685, 0.247173, 0.241562, 0.23585,
0.230035, 0.224118, 0.218095, 0.211966, 0.20573, 0.199384, 0.192928, 0.18636, 0.179679,
0.172882 },

{0.45, 0.44997, 0.44988, 0.449731, 0.449521, 0.449252, 0.448922, 0.448533, 0.448083, 0.447574,
0.447004, 0.446373, 0.445682, 0.444931, 0.444119, 0.443246, 0.442312, 0.441316, 0.44026,
0.439142, 0.437962, 0.43672, 0.435416, 0.434049, 0.43262, 0.431128, 0.429573, 0.427954,
0.426271, 0.424525, 0.422714, 0.420838, 0.418897, 0.416891, 0.414819, 0.412681, 0.410476,
0.408205, 0.405866, 0.403459, 0.400983, 0.398439, 0.395826, 0.393143, 0.39039, 0.387566,
0.384671, 0.381703, 0.378664, 0.375551, 0.372364, 0.369104, 0.365768, 0.362357, 0.358869,
0.355304, 0.351662, 0.347941, 0.344141, 0.340261, 0.3363, 0.332258, 0.328133, 0.323925,
0.319633, 0.315255, 0.310792, 0.306241, 0.301603, 0.296876, 0.292059, 0.28715, 0.28215,
0.277057, 0.271869, 0.266586, 0.261206, 0.255729, 0.250153, 0.244476, 0.238699, 0.232818,
0.226833, 0.220743, 0.214546, 0.208241, 0.201827, 0.195301, 0.188663, 0.181911, 0.175043 },

{0.455556, 0.455525, 0.455434, 0.455282, 0.45507, 0.454797, 0.454463, 0.454068, 0.453612,
0.453095, 0.452517, 0.451877, 0.451177, 0.450415, 0.449591, 0.448706, 0.447759, 0.446749,
0.445678, 0.444544, 0.443347, 0.442088, 0.440766, 0.43938, 0.437931, 0.436418, 0.434841,
0.4332, 0.431494, 0.429723, 0.427887, 0.425985, 0.424018, 0.421984, 0.419883, 0.417716,
0.415481, 0.413178, 0.410807, 0.408367, 0.405858, 0.40328, 0.400631, 0.397912, 0.395122,
0.39226, 0.389325, 0.386318, 0.383238, 0.380084, 0.376855, 0.373551, 0.370172, 0.366715,
0.363182, 0.359571, 0.355881, 0.352112, 0.348263, 0.344333, 0.340322, 0.336228, 0.332051,
0.32779, 0.323443, 0.319011, 0.314492, 0.309885, 0.30519, 0.300405, 0.295529, 0.290561,
0.285501, 0.280347, 0.275098, 0.269752, 0.26431, 0.258769, 0.253128, 0.247387, 0.241544,
0.235597, 0.229545, 0.223388, 0.217123, 0.21075, 0.204267, 0.197672, 0.190964, 0.184142,
0.177204 },

{0.461111, 0.46108, 0.460988, 0.460834, 0.460619, 0.460342, 0.460003, 0.459602, 0.45914,
0.458616, 0.45803, 0.457381, 0.456671, 0.455898, 0.455063, 0.454166, 0.453205, 0.452182,
0.451095, 0.449946, 0.448732, 0.447456, 0.446115, 0.44471, 0.443241, 0.441707, 0.440108,
0.438444, 0.436715, 0.43492, 0.433058, 0.431131, 0.429136, 0.427074, 0.424945, 0.422748,
0.420483, 0.418149, 0.415746, 0.413273, 0.41073, 0.408117, 0.405433, 0.402677, 0.39985,
0.396949, 0.393976, 0.39093, 0.387809, 0.384613, 0.381342, 0.377995, 0.374571, 0.37107,
0.367491, 0.363833, 0.360096, 0.356279, 0.35238, 0.348401, 0.344338, 0.340193, 0.335963,
0.331649, 0.327249, 0.322762, 0.318187, 0.313524, 0.308772, 0.303929, 0.298994, 0.293967,
0.288847, 0.283632, 0.278321, 0.272914, 0.267409, 0.261804, 0.2561, 0.250294, 0.244385,
0.238372, 0.232254, 0.22603, 0.219698, 0.213257, 0.206705, 0.200041, 0.193264, 0.186373,
0.179365 },

{0.466667, 0.466635, 0.466542, 0.466386, 0.466167, 0.465886, 0.465543, 0.465137, 0.464668,
0.464137, 0.463542, 0.462885, 0.462165, 0.461382, 0.460535, 0.459625, 0.458651, 0.457613,
0.456512, 0.455347, 0.454117, 0.452822, 0.451463, 0.450039, 0.44855, 0.446995, 0.445374,
0.443687, 0.441934, 0.440115, 0.438228, 0.436274, 0.434252, 0.432163, 0.430005, 0.427778,
0.425482, 0.423117, 0.420682, 0.418176, 0.415599, 0.412951, 0.410231, 0.407439, 0.404574,
0.401636, 0.398623, 0.395537, 0.392375, 0.389138, 0.385824, 0.382433, 0.378966, 0.375419,
0.371795, 0.36809, 0.364305, 0.36044, 0.356493, 0.352463, 0.34835, 0.344153, 0.339871,
0.335503, 0.331049, 0.326507, 0.321877, 0.317158, 0.312348, 0.307447, 0.302454, 0.297368,
0.292188, 0.286912, 0.28154, 0.276071, 0.270503, 0.264835, 0.259067, 0.253196, 0.247222,
0.241144, 0.23496, 0.228669, 0.22227, 0.215761, 0.209141, 0.202409, 0.195564, 0.188603,
0.181526 },

{0.472222, 0.472191, 0.472096, 0.471938, 0.471716, 0.471431, 0.471083, 0.470671, 0.470196,
0.469657, 0.469055, 0.468389, 0.467659, 0.466864, 0.466006, 0.465083, 0.464096, 0.463045,
0.461928, 0.460747, 0.4595, 0.458188, 0.45681, 0.455367, 0.453857, 0.452281, 0.450638,
0.448929, 0.447152, 0.445308, 0.443396, 0.441415, 0.439367, 0.437249, 0.435062, 0.432806,
0.430479, 0.428082, 0.425615, 0.423076, 0.420465, 0.417782, 0.415026, 0.412197, 0.409295,
0.406318, 0.403267, 0.40014, 0.396937, 0.393658, 0.390302, 0.386868, 0.383356, 0.379765,
0.376094, 0.372342, 0.36851, 0.364596, 0.3606, 0.35652, 0.352356, 0.348107, 0.343773, 0.339352,
0.334844, 0.330247, 0.325562, 0.320786, 0.315919, 0.310961, 0.305909, 0.300764, 0.295524,
0.290188, 0.284754, 0.279223, 0.273593, 0.267862, 0.26203, 0.256095, 0.250056, 0.243913,
0.237663, 0.231305, 0.224839, 0.218263, 0.211576, 0.204776, 0.197862, 0.190833, 0.183687 },

{0.477778, 0.477746, 0.47765, 0.477489, 0.477265, 0.476976, 0.476623, 0.476206, 0.475724,
0.475178, 0.474567, 0.473892, 0.473152, 0.472347, 0.471477, 0.470542, 0.469541, 0.468475,
0.467343, 0.466146, 0.464882, 0.463552, 0.462156, 0.460693, 0.459163, 0.457566, 0.455901,
0.454169, 0.452368, 0.450499, 0.448561, 0.446555, 0.444479, 0.442333, 0.440117, 0.437831,
0.435474, 0.433045, 0.430545, 0.427972, 0.425327, 0.422609, 0.419818, 0.416952, 0.414012,
0.410997, 0.407906, 0.404739, 0.401495, 0.398174, 0.394775, 0.391298, 0.387741, 0.384105,
0.380388, 0.37659, 0.37271, 0.368747, 0.364701, 0.360571, 0.356357, 0.352056, 0.347669,
0.343195, 0.338633, 0.333982, 0.32924, 0.324409, 0.319485, 0.314469, 0.309359, 0.304154,
0.298854, 0.293458, 0.287963, 0.28237, 0.276678, 0.270884, 0.264988, 0.258989, 0.252886,
0.246677, 0.240362, 0.233939, 0.227406, 0.220763, 0.214009, 0.207141, 0.20016, 0.193062,
0.185848 },

{0.483333, 0.483301, 0.483203, 0.483041, 0.482813, 0.482521, 0.482163, 0.48174, 0.481252,
0.480698, 0.480079, 0.479395, 0.478645, 0.477829, 0.476947, 0.475999, 0.474985, 0.473905,
0.472758, 0.471544, 0.470264, 0.468916, 0.467501, 0.466018, 0.464468, 0.462849, 0.461162,
0.459407, 0.457582, 0.455689, 0.453725, 0.451692, 0.449589, 0.447415, 0.44517, 0.442853,
0.440465, 0.438005, 0.435472, 0.432866, 0.430187, 0.427434, 0.424606, 0.421703, 0.418725,
0.415672, 0.412541, 0.409334, 0.406049, 0.402686, 0.399244, 0.395723, 0.392122, 0.38844,
0.384677, 0.380832, 0.376904, 0.372893, 0.368798, 0.364618, 0.360352, 0.356, 0.35156, 0.347033,
0.342417, 0.337711, 0.332914, 0.328026, 0.323045, 0.317971, 0.312803, 0.307539, 0.30218,
0.296723, 0.291167, 0.285513, 0.279758, 0.273901, 0.267942, 0.261879, 0.255712, 0.249438,
0.243058, 0.236569, 0.22997, 0.223261, 0.216439, 0.209505, 0.202456, 0.195291, 0.188009 },

{0.488889, 0.488856, 0.488757, 0.488592, 0.488362, 0.488065, 0.487703, 0.487274, 0.486779,
0.486218, 0.485591, 0.484897, 0.484137, 0.48331, 0.482417, 0.481456, 0.480429, 0.479334,
0.478172, 0.476942, 0.475644, 0.474279, 0.472845, 0.471343, 0.469771, 0.468131, 0.466422,
0.464643, 0.462795, 0.460876, 0.458887, 0.456827, 0.454696, 0.452494, 0.450219, 0.447873,
0.445454, 0.442962, 0.440396, 0.437757, 0.435043, 0.432254, 0.42939, 0.426451, 0.423435,
0.420343, 0.417173, 0.413925, 0.410599, 0.407194, 0.403709, 0.400144, 0.396498, 0.392771,
0.388962, 0.38507, 0.381094, 0.377034, 0.372889, 0.368659, 0.364342, 0.359938, 0.355446,
0.350865, 0.346195, 0.341434, 0.336582, 0.331637, 0.3266, 0.321468, 0.316241, 0.310919, 0.3055,
0.299982, 0.294366, 0.28865, 0.282833, 0.276914, 0.270892, 0.264765, 0.258534, 0.252196,
0.24575, 0.239195, 0.232531, 0.225756, 0.218868, 0.211867, 0.204751, 0.197519, 0.19017 },

{0.494444, 0.494411, 0.494311, 0.494144, 0.49391, 0.49361, 0.493242, 0.492808, 0.492307,
0.491738, 0.491103, 0.4904, 0.489629, 0.488792, 0.487886, 0.486913, 0.485872, 0.484762,
0.483585, 0.482339, 0.481024, 0.47964, 0.478187, 0.476665, 0.475074, 0.473412, 0.47168,
0.469878, 0.468006, 0.466062, 0.464047, 0.46196, 0.459802, 0.457571, 0.455267, 0.45289,
0.45044, 0.447916, 0.445317, 0.442644, 0.439896, 0.437072, 0.434171, 0.431195, 0.428141,
0.425009, 0.4218, 0.418512, 0.415144, 0.411697, 0.408169, 0.40456, 0.400869, 0.397097,
0.393241, 0.389302, 0.385278, 0.38117, 0.376975, 0.372694, 0.368327, 0.363871, 0.359326,
0.354692, 0.349967, 0.345152, 0.340244, 0.335243, 0.330149, 0.324959, 0.319674, 0.314293,
0.308814, 0.303237, 0.29756, 0.291782, 0.285903, 0.279922, 0.273837, 0.267647, 0.261351,
0.254949, 0.248439, 0.241819, 0.23509, 0.228248, 0.221295, 0.214227, 0.207045, 0.199747,
0.192331 },

{0.5, 0.499966, 0.499865, 0.499696, 0.499459, 0.499154, 0.498782, 0.498342, 0.497834, 0.497258,
0.496614, 0.495902, 0.495121, 0.494272, 0.493355, 0.492369, 0.491314, 0.49019, 0.488997,
0.487734, 0.486402, 0.485001, 0.483529, 0.481987, 0.480374, 0.478691, 0.476937, 0.475112,
0.473215, 0.471246, 0.469205, 0.467091, 0.464905, 0.462645, 0.460312, 0.457904, 0.455423,
0.452867, 0.450235, 0.447528, 0.444745, 0.441885, 0.438949, 0.435935, 0.432843, 0.429672,
0.426423, 0.423094, 0.419685, 0.416195, 0.412624, 0.408971, 0.405236, 0.401417, 0.397515,
0.393529, 0.389457, 0.3853, 0.381056, 0.376724, 0.372305, 0.367798, 0.3632, 0.358513, 0.353734,
0.348863, 0.3439, 0.338843, 0.333692, 0.328445, 0.323102, 0.317662, 0.312123, 0.306486,
0.300748, 0.294909, 0.288969, 0.282925, 0.276777, 0.270524, 0.264165, 0.257699, 0.251124,
0.24444, 0.237645, 0.230739, 0.22372, 0.216586, 0.209338, 0.201974, 0.194492 },

{0.505556, 0.505521, 0.505418, 0.505247, 0.505007, 0.504699, 0.504322, 0.503876, 0.503361,
0.502777, 0.502125, 0.501403, 0.500613, 0.499753, 0.498823, 0.497824, 0.496756, 0.495617,
0.494408, 0.493129, 0.49178, 0.49036, 0.488869, 0.487307, 0.485674, 0.483969, 0.482192,
0.480343, 0.478422, 0.476427, 0.47436, 0.47222, 0.470005, 0.467717, 0.465354, 0.462916,
0.460403, 0.457814, 0.45515, 0.452409, 0.449591, 0.446695, 0.443722, 0.440671, 0.437541,
0.434331, 0.431041, 0.427672, 0.424221, 0.420689, 0.417074, 0.413377, 0.409597, 0.405733,
0.401784, 0.39775, 0.39363, 0.389424, 0.38513, 0.380749, 0.376279, 0.371719, 0.367069,
0.362328, 0.357495, 0.352569, 0.347551, 0.342437, 0.337229, 0.331925, 0.326523, 0.321024,
0.315427, 0.309729, 0.303931, 0.298031, 0.292029, 0.285924, 0.279713, 0.273397, 0.266975,
0.260445, 0.253806, 0.247057, 0.240198, 0.233227, 0.226142, 0.218944, 0.21163, 0.204201,
0.196653 },

{0.511111, 0.511076, 0.510972, 0.510799, 0.510556, 0.510243, 0.509861, 0.509409, 0.508888,
0.508297, 0.507636, 0.506905, 0.506104, 0.505233, 0.504291, 0.503279, 0.502197, 0.501043,
0.499819, 0.498523, 0.497157, 0.495718, 0.494208, 0.492626, 0.490972, 0.489245, 0.487445,
0.485573, 0.483627, 0.481607, 0.479514, 0.477346, 0.475103, 0.472786, 0.470393, 0.467925,
0.46538, 0.462759, 0.460061, 0.457286, 0.454433, 0.451502, 0.448492, 0.445403, 0.442234,
0.438985, 0.435656, 0.432245, 0.428753, 0.425178, 0.42152, 0.417779, 0.413953, 0.410043,
0.406048, 0.401966, 0.397798, 0.393543, 0.3892, 0.384767, 0.380246, 0.375634, 0.370931,
0.366137, 0.36125, 0.356269, 0.351195, 0.346026, 0.34076, 0.335399, 0.329939, 0.324382,
0.318725, 0.312967, 0.307109, 0.301148, 0.295085, 0.288917, 0.282644, 0.276266, 0.26978,
0.263187, 0.256484, 0.249672, 0.242748, 0.235712, 0.228563, 0.2213, 0.213921, 0.206426,
0.198814 },

{0.516667, 0.516632, 0.516526, 0.51635, 0.516104, 0.515787, 0.5154, 0.514943, 0.514415,
0.513816, 0.513146, 0.512406, 0.511595, 0.510712, 0.509758, 0.508733, 0.507637, 0.506469,
0.505229, 0.503917, 0.502532, 0.501076, 0.499546, 0.497944, 0.496268, 0.49452, 0.492697,
0.490801, 0.48883, 0.486785, 0.484665, 0.48247, 0.480199, 0.477853, 0.47543, 0.472931,
0.470355, 0.467701, 0.46497, 0.46216, 0.459272, 0.456305, 0.453258, 0.450131, 0.446924,
0.443636, 0.440266, 0.436814, 0.433279, 0.429662, 0.425961, 0.422175, 0.418304, 0.414348,
0.410306, 0.406177, 0.401961, 0.397656, 0.393263, 0.38878, 0.384207, 0.379543, 0.374788,
0.36994, 0.364999, 0.359963, 0.354833, 0.349608, 0.344286, 0.338867, 0.333349, 0.327733,
0.322017, 0.3162, 0.310281, 0.30426, 0.298135, 0.291906, 0.285571, 0.27913, 0.272582, 0.265925,
0.259159, 0.252282, 0.245295, 0.238195, 0.230982, 0.223654, 0.216211, 0.208652, 0.200975 },

{0.522222, 0.522187, 0.52208, 0.521902, 0.521652, 0.521332, 0.52094, 0.520476, 0.519941,
0.519335, 0.518657, 0.517907, 0.517085, 0.516191, 0.515225, 0.514187, 0.513077, 0.511893,
0.510638, 0.509309, 0.507907, 0.506432, 0.504883, 0.50326, 0.501564, 0.499793, 0.497947,
0.496027, 0.494031, 0.491961, 0.489814, 0.487591, 0.485293, 0.482917, 0.480464, 0.477934,
0.475326, 0.47264, 0.469875, 0.467031, 0.464107, 0.461104, 0.45802, 0.454855, 0.451609,
0.448281, 0.444871, 0.441378, 0.437802, 0.434141, 0.430396, 0.426566, 0.42265, 0.418648,
0.414559, 0.410382, 0.406118, 0.401764, 0.397321, 0.392787, 0.388163, 0.383447, 0.378638,
0.373737, 0.368741, 0.363651, 0.358466, 0.353184, 0.347805, 0.342329, 0.336753, 0.331078,
0.325303, 0.319426, 0.313448, 0.307366, 0.30118, 0.294889, 0.288493, 0.281989, 0.275379,
0.268659, 0.26183, 0.25489, 0.247839, 0.240675, 0.233398, 0.226007, 0.2185, 0.210877, 0.203136
},

{0.527778, 0.527742, 0.527633, 0.527453, 0.527201, 0.526876, 0.526479, 0.526009, 0.525468,
0.524853, 0.524167, 0.523407, 0.522575, 0.52167, 0.520692, 0.51964, 0.518516, 0.517317,
0.516046, 0.5147, 0.51328, 0.511787, 0.510218, 0.508575, 0.506857, 0.505064, 0.503195,
0.501251, 0.499231, 0.497134, 0.494961, 0.492711, 0.490383, 0.487978, 0.485495, 0.482934,
0.480294, 0.477575, 0.474776, 0.471898, 0.468939, 0.465899, 0.462778, 0.459575, 0.456291,
0.452923, 0.449472, 0.445938, 0.442319, 0.438616, 0.434827, 0.430952, 0.426991, 0.422942,
0.418806, 0.414582, 0.410269, 0.405866, 0.401372, 0.396788, 0.392112, 0.387344, 0.382483,
0.377528, 0.372478, 0.367333, 0.362092, 0.356754, 0.351319, 0.345785, 0.340151, 0.334418,
0.328584, 0.322648, 0.316609, 0.310466, 0.30422, 0.297868, 0.29141, 0.284844, 0.278171,
0.271389, 0.264497, 0.257494, 0.25038, 0.243153, 0.235813, 0.228358, 0.220787, 0.213101,
0.205297 },

{0.533333, 0.533297, 0.533187, 0.533005, 0.532749, 0.53242, 0.532018, 0.531542, 0.530994,
0.530372, 0.529676, 0.528907, 0.528064, 0.527148, 0.526157, 0.525093, 0.523954, 0.522741,
0.521453, 0.52009, 0.518653, 0.51714, 0.515552, 0.513889, 0.512149, 0.510334, 0.508442,
0.506473, 0.504428, 0.502305, 0.500105, 0.497828, 0.495472, 0.493037, 0.490524, 0.487931,
0.485259, 0.482507, 0.479674, 0.476761, 0.473766, 0.47069, 0.467532, 0.464291, 0.460967,
0.45756, 0.454069, 0.450493, 0.446832, 0.443085, 0.439252, 0.435333, 0.431326, 0.427231,
0.423048, 0.418776, 0.414414, 0.409962, 0.405418, 0.400783, 0.396056, 0.391235, 0.386321,
0.381312, 0.376208, 0.371009, 0.365712, 0.360318, 0.354826, 0.349234, 0.343543, 0.337751,
0.331858, 0.325863, 0.319764, 0.313562, 0.307254, 0.300841, 0.294322, 0.287695, 0.280959,
0.274115, 0.267161, 0.260095, 0.252918, 0.245628, 0.238225, 0.230707, 0.223074, 0.215325,
0.207458 },

{0.538889, 0.538852, 0.538741, 0.538556, 0.538297, 0.537964, 0.537557, 0.537075, 0.53652,
0.53589, 0.535186, 0.534407, 0.533554, 0.532625, 0.531622, 0.530545, 0.529391, 0.528163,
0.526859, 0.52548, 0.524024, 0.522493, 0.520885, 0.519201, 0.51744, 0.515602, 0.513687,
0.511694, 0.509623, 0.507475, 0.505248, 0.502942, 0.500557, 0.498093, 0.495549, 0.492925,
0.490221, 0.487435, 0.484569, 0.481621, 0.47859, 0.475478, 0.472282, 0.469003, 0.46564,
0.462192, 0.45866, 0.455043, 0.451339, 0.447549, 0.443672, 0.439708, 0.435656, 0.431514,
0.427284, 0.422964, 0.418553, 0.414051, 0.409458, 0.404772, 0.399993, 0.39512, 0.390153,
0.385091, 0.379932, 0.374678, 0.369326, 0.363875, 0.358326, 0.352678, 0.346929, 0.341079,
0.335127, 0.329072, 0.322914, 0.316651, 0.310283, 0.30381, 0.297229, 0.29054, 0.283743,
0.276837, 0.26982, 0.262693, 0.255453, 0.248101, 0.240635, 0.233055, 0.225359, 0.217548,
0.209619 },

{0.544444, 0.544407, 0.544295, 0.544107, 0.543845, 0.543508, 0.543096, 0.542608, 0.542046,
0.541408, 0.540695, 0.539906, 0.539042, 0.538103, 0.537087, 0.535996, 0.534828, 0.533585,
0.532265, 0.530868, 0.529394, 0.527844, 0.526216, 0.524511, 0.522729, 0.520868, 0.518929,
0.516912, 0.514816, 0.512642, 0.510387, 0.508054, 0.50564, 0.503146, 0.500572, 0.497916,
0.495179, 0.492361, 0.48946, 0.486477, 0.483411, 0.480261, 0.477028, 0.47371, 0.470308,
0.46682, 0.463247, 0.459588, 0.455842, 0.452008, 0.448087, 0.444078, 0.43998, 0.435792,
0.431514, 0.427146, 0.422687, 0.418135, 0.413491, 0.408754, 0.403924, 0.398999, 0.393978,
0.388862, 0.38365, 0.37834, 0.372933, 0.367426, 0.361821, 0.356115, 0.350308, 0.3444, 0.33839,
0.332276, 0.326058, 0.319735, 0.313307, 0.306773, 0.300131, 0.293381, 0.286523, 0.279555,
0.272476, 0.265287, 0.257985, 0.250571, 0.243043, 0.235401, 0.227644, 0.21977, 0.21178 },

{0.55, 0.549962, 0.549848, 0.549659, 0.549393, 0.549052, 0.548634, 0.548141, 0.547571,
0.546926, 0.546204, 0.545405, 0.544531, 0.543579, 0.542551, 0.541446, 0.540264, 0.539005,
0.537669, 0.536255, 0.534764, 0.533194, 0.531546, 0.529821, 0.528016, 0.526133, 0.52417,
0.522129, 0.520007, 0.517806, 0.515525, 0.513163, 0.51072, 0.508196, 0.505591, 0.502904,
0.500134, 0.497282, 0.494347, 0.491329, 0.488227, 0.48504, 0.481769, 0.478413, 0.474971,
0.471443, 0.467829, 0.464128, 0.460339, 0.456462, 0.452497, 0.448442, 0.444298, 0.440064,
0.435739, 0.431322, 0.426814, 0.422213, 0.417519, 0.412731, 0.407848, 0.402871, 0.397797,
0.392628, 0.387361, 0.381996, 0.376533, 0.370971, 0.365309, 0.359546, 0.353682, 0.347715,
0.341646, 0.335473, 0.329196, 0.322814, 0.316325, 0.30973, 0.303028, 0.296217, 0.289298,
0.282268, 0.275129, 0.267878, 0.260514, 0.253038, 0.245449, 0.237745, 0.229927, 0.221992,
0.213941 },

{0.555556, 0.555517, 0.555402, 0.55521, 0.554941, 0.554596, 0.554173, 0.553673, 0.553097,
0.552443, 0.551712, 0.550904, 0.550018, 0.549055, 0.548015, 0.546896, 0.5457, 0.544425,
0.543072, 0.541641, 0.540131, 0.538543, 0.536875, 0.535128, 0.533302, 0.531396, 0.52941,
0.527343, 0.525196, 0.522969, 0.52066, 0.51827, 0.515798, 0.513244, 0.510608, 0.507888,
0.505086, 0.502201, 0.499231, 0.496177, 0.493039, 0.489815, 0.486506, 0.483111, 0.47963,
0.476062, 0.472406, 0.468663, 0.464831, 0.460911, 0.456901, 0.452801, 0.448611, 0.44433,
0.439957, 0.435492, 0.430935, 0.426284, 0.42154, 0.4167, 0.411766, 0.406736, 0.40161, 0.396387,
0.391065, 0.385646, 0.380127, 0.374509, 0.36879, 0.36297, 0.357048, 0.351024, 0.344896,
0.338665, 0.332328, 0.325886, 0.319338, 0.312683, 0.30592, 0.299049, 0.292068, 0.284978,
0.277777, 0.270465, 0.26304, 0.255503, 0.247853, 0.240088, 0.232208, 0.224214, 0.216103 },

{0.561111, 0.561072, 0.560956, 0.560761, 0.560489, 0.560139, 0.559711, 0.559206, 0.558622,
0.55796, 0.55722, 0.556402, 0.555506, 0.554531, 0.553478, 0.552345, 0.551134, 0.549844,
0.548475, 0.547026, 0.545498, 0.54389, 0.542202, 0.540434, 0.538586, 0.536657, 0.534647,
0.532556, 0.530383, 0.528129, 0.525792, 0.523374, 0.520873, 0.518288, 0.515621, 0.51287,
0.510035, 0.507115, 0.504111, 0.501022, 0.497847, 0.494586, 0.491239, 0.487805, 0.484284,
0.480675, 0.476978, 0.473193, 0.469318, 0.465354, 0.461299, 0.457154, 0.452918, 0.44859,
0.444169, 0.439656, 0.43505, 0.430349, 0.425554, 0.420664, 0.415678, 0.410595, 0.405416,
0.400139, 0.394763, 0.389289, 0.383715, 0.37804, 0.372265, 0.366388, 0.360409, 0.354326,
0.34814, 0.34185, 0.335454, 0.328953, 0.322345, 0.31563, 0.308807, 0.301875, 0.294834,
0.287683, 0.280421, 0.273048, 0.265563, 0.257965, 0.250254, 0.242429, 0.234489, 0.226434,
0.218264 },

{0.566667, 0.566627, 0.566509, 0.566313, 0.566037, 0.565683, 0.56525, 0.564738, 0.564147,
0.563477, 0.562728, 0.5619, 0.560993, 0.560006, 0.55894, 0.557794, 0.556568, 0.555262,
0.553877, 0.55241, 0.550864, 0.549236, 0.547528, 0.545739, 0.543868, 0.541916, 0.539882,
0.537766, 0.535567, 0.533286, 0.530922, 0.528475, 0.525944, 0.52333, 0.520631, 0.517848,
0.51498, 0.512026, 0.508987, 0.505862, 0.502651, 0.499353, 0.495967, 0.492494, 0.488933,
0.485284, 0.481545, 0.477717, 0.473799, 0.469791, 0.465692, 0.461501, 0.457219, 0.452844,
0.448375, 0.443814, 0.439158, 0.434408, 0.429562, 0.42462, 0.419582, 0.414447, 0.409215,
0.403884, 0.398454, 0.392925, 0.387295, 0.381565, 0.375733, 0.369799, 0.363762, 0.357622,
0.351378, 0.345029, 0.338574, 0.332014, 0.325346, 0.318571, 0.311688, 0.304697, 0.297595,
0.290384, 0.283062, 0.275628, 0.268083, 0.260425, 0.252653, 0.244768, 0.236769, 0.228654,
0.220425 },

{0.572222, 0.572182, 0.572063, 0.571864, 0.571585, 0.571226, 0.570788, 0.57027, 0.569672,
0.568994, 0.568236, 0.567398, 0.56648, 0.565481, 0.564402, 0.563242, 0.562001, 0.56068,
0.559277, 0.557793, 0.556228, 0.554581, 0.552853, 0.551042, 0.549149, 0.547174, 0.545115,
0.542974, 0.54075, 0.538442, 0.53605, 0.533574, 0.531013, 0.528368, 0.525638, 0.522822,
0.519921, 0.516934, 0.51386, 0.510699, 0.507451, 0.504115, 0.500691, 0.497179, 0.493578,
0.489887, 0.486107, 0.482237, 0.478275, 0.474223, 0.470079, 0.465843, 0.461514, 0.457091,
0.452575, 0.447965, 0.44326, 0.43846, 0.433563, 0.42857, 0.42348, 0.418293, 0.413007, 0.407622,
0.402138, 0.396554, 0.390869, 0.385082, 0.379194, 0.373203, 0.367109, 0.360911, 0.354609,
0.348202, 0.341688, 0.335069, 0.328342, 0.321507, 0.314565, 0.307513, 0.300352, 0.29308,
0.285698, 0.278205, 0.270599, 0.262881, 0.25505, 0.247106, 0.239047, 0.230874, 0.222586 },

{0.577778, 0.577737, 0.577617, 0.577415, 0.577133, 0.57677, 0.576326, 0.575802, 0.575197,
0.574511, 0.573743, 0.572895, 0.571966, 0.570955, 0.569863, 0.568689, 0.567433, 0.566096,
0.564677, 0.563175, 0.561591, 0.559925, 0.558176, 0.556343, 0.554428, 0.552429, 0.550347,
0.54818, 0.545929, 0.543594, 0.541174, 0.53867, 0.536079, 0.533404, 0.530642, 0.527794,
0.524859, 0.521837, 0.518728, 0.515531, 0.512246, 0.508873, 0.505411, 0.501859, 0.498218,
0.494486, 0.490664, 0.486751, 0.482746, 0.478649, 0.47446, 0.470178, 0.465802, 0.461333,
0.456769, 0.45211, 0.447356, 0.442505, 0.437558, 0.432514, 0.427372, 0.422131, 0.416792,
0.411354, 0.405815, 0.400176, 0.394435, 0.388593, 0.382649, 0.376601, 0.37045, 0.364194,
0.357834, 0.351368, 0.344796, 0.338117, 0.331332, 0.324438, 0.317436, 0.310325, 0.303104,
0.295773, 0.288331, 0.280778, 0.273113, 0.265335, 0.257445, 0.249442, 0.241324, 0.233093,
0.224747 },

{0.583333, 0.583293, 0.58317, 0.582966, 0.582681, 0.582313, 0.581864, 0.581334, 0.580721,
0.580027, 0.57925, 0.578392, 0.577451, 0.576428, 0.575323, 0.574135, 0.572865, 0.571512,
0.570075, 0.568556, 0.566953, 0.565267, 0.563497, 0.561643, 0.559705, 0.557683, 0.555576,
0.553384, 0.551107, 0.548745, 0.546297, 0.543763, 0.541142, 0.538436, 0.535642, 0.532761,
0.529793, 0.526737, 0.523592, 0.520359, 0.517038, 0.513626, 0.510125, 0.506534, 0.502852,
0.499079, 0.495215, 0.491259, 0.487211, 0.48307, 0.478835, 0.474507, 0.470085, 0.465568,
0.460956, 0.456248, 0.451444, 0.446544, 0.441546, 0.43645, 0.431256, 0.425963, 0.420571,
0.415078, 0.409485, 0.403791, 0.397995, 0.392097, 0.386096, 0.379992, 0.373783, 0.36747,
0.361052, 0.354528, 0.347898, 0.34116, 0.334316, 0.327363, 0.320301, 0.313131, 0.305851,
0.29846, 0.290959, 0.283347, 0.275623, 0.267786, 0.259837, 0.251776, 0.2436, 0.235311, 0.226908
},

{0.588889, 0.588848, 0.588724, 0.588517, 0.588228, 0.587857, 0.587402, 0.586865, 0.586245,
0.585543, 0.584757, 0.583888, 0.582937, 0.581901, 0.580783, 0.579581, 0.578295, 0.576926,
0.575473, 0.573935, 0.572314, 0.570608, 0.568817, 0.566941, 0.56498, 0.562934, 0.560803,
0.558585, 0.556282, 0.553892, 0.551416, 0.548853, 0.546202, 0.543465, 0.540639, 0.537726,
0.534724, 0.531633, 0.528453, 0.525184, 0.521824, 0.518375, 0.514835, 0.511204, 0.507482,
0.503668, 0.499761, 0.495762, 0.49167, 0.487484, 0.483205, 0.478831, 0.474362, 0.469797,
0.465137, 0.46038, 0.455527, 0.450576, 0.445527, 0.440379, 0.435133, 0.429787, 0.424342,
0.418795, 0.413148, 0.407399, 0.401548, 0.395594, 0.389536, 0.383375, 0.37711, 0.370739,
0.364263, 0.357681, 0.350993, 0.344197, 0.337294, 0.330282, 0.323162, 0.315932, 0.308593,
0.301143, 0.293583, 0.285912, 0.278129, 0.270235, 0.262228, 0.254108, 0.245875, 0.237529,
0.229069 },

{0.594444, 0.594403, 0.594277, 0.594068, 0.593776, 0.5934, 0.59294, 0.592397, 0.591769,
0.591058, 0.590263, 0.589384, 0.588421, 0.587374, 0.586242, 0.585026, 0.583725, 0.58234,
0.580869, 0.579314, 0.577673, 0.575947, 0.574135, 0.572238, 0.570254, 0.568184, 0.566028,
0.563785, 0.561455, 0.559037, 0.556533, 0.55394, 0.551259, 0.54849, 0.545633, 0.542686,
0.53965, 0.536525, 0.533309, 0.530003, 0.526607, 0.523119, 0.51954, 0.515869, 0.512106,
0.50825, 0.504302, 0.50026, 0.496123, 0.491893, 0.487568, 0.483148, 0.478632, 0.47402,
0.469311, 0.464505, 0.459602, 0.454601, 0.449501, 0.444302, 0.439003, 0.433605, 0.428106,
0.422505, 0.416804, 0.411, 0.405093, 0.399083, 0.39297, 0.386752, 0.380429, 0.374002, 0.367468,
0.360828, 0.354082, 0.347227, 0.340266, 0.333195, 0.326016, 0.318728, 0.31133, 0.303822,
0.296204, 0.288474, 0.280633, 0.27268, 0.264615, 0.256438, 0.248148, 0.239746, 0.23123 },

{0.6, 0.599958, 0.599831, 0.59962, 0.599324, 0.598943, 0.598478, 0.597928, 0.597293, 0.596574,
0.595769, 0.59488, 0.593905, 0.592846, 0.591701, 0.59047, 0.589154, 0.587752, 0.586265,
0.584691, 0.583031, 0.581285, 0.579452, 0.577532, 0.575526, 0.573432, 0.571251, 0.568982,
0.566625, 0.56418, 0.561646, 0.559024, 0.556313, 0.553513, 0.550623, 0.547643, 0.544573,
0.541413, 0.538161, 0.534819, 0.531384, 0.527858, 0.52424, 0.520529, 0.516725, 0.512828,
0.508837, 0.504751, 0.500571, 0.496296, 0.491925, 0.487458, 0.482895, 0.478236, 0.473478,
0.468624, 0.46367, 0.458619, 0.453468, 0.448217, 0.442866, 0.437415, 0.431862, 0.426208,
0.420452, 0.414593, 0.408631, 0.402565, 0.396396, 0.390121, 0.383742, 0.377257, 0.370666,
0.363968, 0.357164, 0.350252, 0.343232, 0.336103, 0.328866, 0.321519, 0.314063, 0.306496,
0.29882, 0.291032, 0.283133, 0.275123, 0.267001, 0.258767, 0.250421, 0.241962, 0.233391 },

{0.605556, 0.605513, 0.605384, 0.605171, 0.604871, 0.604486, 0.604015, 0.603459, 0.602817,
0.602089, 0.601275, 0.600375, 0.599389, 0.598317, 0.597158, 0.595914, 0.594582, 0.593164,
0.591659, 0.590067, 0.588388, 0.586621, 0.584767, 0.582825, 0.580795, 0.578677, 0.576471,
0.574176, 0.571792, 0.56932, 0.566757, 0.564106, 0.561364, 0.558532, 0.555609, 0.552596,
0.549492, 0.546296, 0.543009, 0.53963, 0.536158, 0.532593, 0.528935, 0.525184, 0.521339,
0.5174, 0.513366, 0.509237, 0.505013, 0.500692, 0.496276, 0.491763, 0.487153, 0.482445,
0.477639, 0.472735, 0.467732, 0.462629, 0.457427, 0.452125, 0.446722, 0.441217, 0.435611,
0.429903, 0.424093, 0.418179, 0.412162, 0.40604, 0.399815, 0.393484, 0.387048, 0.380506,
0.373857, 0.367102, 0.36024, 0.35327, 0.346191, 0.339005, 0.331709, 0.324305, 0.31679,
0.309166, 0.301431, 0.293586, 0.28563, 0.277563, 0.269384, 0.261094, 0.252692, 0.244178,
0.235552 },

{0.611111, 0.611068, 0.610938, 0.610722, 0.610419, 0.610029, 0.609553, 0.60899, 0.60834,
0.607604, 0.60678, 0.60587, 0.604872, 0.603788, 0.602616, 0.601356, 0.600009, 0.598575,
0.597052, 0.595442, 0.593743, 0.591956, 0.590081, 0.588116, 0.586063, 0.583921, 0.58169,
0.579368, 0.576958, 0.574457, 0.571865, 0.569184, 0.566411, 0.563547, 0.560592, 0.557546,
0.554407, 0.551176, 0.547852, 0.544436, 0.540926, 0.537323, 0.533625, 0.529834, 0.525948,
0.521966, 0.517889, 0.513717, 0.509448, 0.505083, 0.50062, 0.496061, 0.491403, 0.486647,
0.481793, 0.476839, 0.471786, 0.466633, 0.46138, 0.456025, 0.45057, 0.445013, 0.439353,
0.433591, 0.427726, 0.421757, 0.415685, 0.409508, 0.403226, 0.396839, 0.390346, 0.383747,
0.377041, 0.370229, 0.363309, 0.356281, 0.349145, 0.341901, 0.334547, 0.327085, 0.319513,
0.311831, 0.304039, 0.296136, 0.288123, 0.279999, 0.271765, 0.263419, 0.254961, 0.246393,
0.237713 },

{0.616667, 0.616623, 0.616492, 0.616273, 0.615966, 0.615572, 0.61509, 0.614521, 0.613863,
0.613118, 0.612285, 0.611364, 0.610355, 0.609258, 0.608072, 0.606798, 0.605435, 0.603984,
0.602444, 0.600815, 0.599097, 0.597289, 0.595392, 0.593406, 0.591329, 0.589163, 0.586906,
0.584558, 0.58212, 0.579591, 0.576971, 0.574259, 0.571455, 0.56856, 0.565572, 0.562491,
0.559318, 0.556051, 0.552692, 0.549238, 0.54569, 0.542048, 0.53831, 0.534478, 0.53055,
0.526527, 0.522407, 0.518191, 0.513877, 0.509467, 0.504958, 0.500352, 0.495647, 0.490843,
0.485939, 0.480936, 0.475833, 0.470629, 0.465325, 0.459919, 0.454411, 0.4488, 0.443087,
0.437271, 0.431352, 0.425328, 0.4192, 0.412968, 0.40663, 0.400186, 0.393637, 0.386981,
0.380218, 0.373349, 0.366371, 0.359286, 0.352093, 0.344791, 0.33738, 0.32986, 0.32223,
0.314491, 0.306642, 0.298683, 0.290613, 0.282433, 0.274143, 0.265742, 0.25723, 0.248607,
0.239874 },

{0.622222, 0.622178, 0.622045, 0.621824, 0.621514, 0.621115, 0.620627, 0.620051, 0.619386,
0.618632, 0.61779, 0.616858, 0.615837, 0.614727, 0.613528, 0.612239, 0.610861, 0.609393,
0.607835, 0.606187, 0.604449, 0.602621, 0.600702, 0.598693, 0.596593, 0.594402, 0.592119,
0.589745, 0.58728, 0.584722, 0.582073, 0.579331, 0.576496, 0.573568, 0.570547, 0.567433,
0.564225, 0.560923, 0.557526, 0.554035, 0.550449, 0.546767, 0.54299, 0.539117, 0.535148,
0.531082, 0.526919, 0.522659, 0.5183, 0.513844, 0.50929, 0.504636, 0.499884, 0.495031,
0.490079, 0.485026, 0.479873, 0.474618, 0.469262, 0.463804, 0.458244, 0.45258, 0.446814,
0.440944, 0.43497, 0.428891, 0.422708, 0.41642, 0.410026, 0.403526, 0.396921, 0.390208,
0.383388, 0.376462, 0.369427, 0.362285, 0.355034, 0.347674, 0.340206, 0.332629, 0.324943,
0.317147, 0.309241, 0.301226, 0.2931, 0.284865, 0.276519, 0.268063, 0.259497, 0.250821,
0.242035 },

{0.627778, 0.627733, 0.627599, 0.627375, 0.627061, 0.626657, 0.626164, 0.625582, 0.624909,
0.624146, 0.623294, 0.622351, 0.621319, 0.620196, 0.618983, 0.617679, 0.616285, 0.6148,
0.613225, 0.611558, 0.6098, 0.607951, 0.606011, 0.603979, 0.601855, 0.599639, 0.597331,
0.59493, 0.592437, 0.589851, 0.587172, 0.584399, 0.581533, 0.578573, 0.575519, 0.572371,
0.569128, 0.56579, 0.562356, 0.558827, 0.555203, 0.551482, 0.547665, 0.543751, 0.53974,
0.535631, 0.531425, 0.52712, 0.522717, 0.518215, 0.513615, 0.508914, 0.504114, 0.499213,
0.494212, 0.489109, 0.483905, 0.4786, 0.473192, 0.467682, 0.462069, 0.456352, 0.450532,
0.444608, 0.43858, 0.432447, 0.426208, 0.419865, 0.413415, 0.406859, 0.400197, 0.393428,
0.386551, 0.379567, 0.372476, 0.365276, 0.357969, 0.350552, 0.343027, 0.335393, 0.32765,
0.319798, 0.311836, 0.303764, 0.295583, 0.287293, 0.278892, 0.270382, 0.261763, 0.253034,
0.244196 },

{0.633333, 0.633288, 0.633152, 0.632925, 0.632608, 0.6322, 0.631701, 0.631112, 0.630431,
0.62966, 0.628798, 0.627844, 0.6268, 0.625664, 0.624437, 0.623119, 0.621708, 0.620207,
0.618613, 0.616928, 0.61515, 0.61328, 0.611317, 0.609262, 0.607115, 0.604874, 0.60254,
0.600112, 0.597591, 0.594977, 0.592268, 0.589465, 0.586567, 0.583575, 0.580487, 0.577304,
0.574026, 0.570652, 0.567182, 0.563615, 0.559952, 0.556192, 0.552334, 0.548379, 0.544326,
0.540174, 0.535924, 0.531576, 0.527128, 0.52258, 0.517933, 0.513185, 0.508337, 0.503387,
0.498337, 0.493184, 0.48793, 0.482574, 0.477114, 0.471552, 0.465886, 0.460117, 0.454243,
0.448265, 0.442182, 0.435994, 0.429701, 0.423301, 0.416796, 0.410184, 0.403465, 0.39664,
0.389707, 0.382666, 0.375518, 0.368262, 0.360897, 0.353424, 0.345842, 0.338152, 0.330352,
0.322444, 0.314426, 0.306299, 0.298063, 0.289718, 0.281263, 0.2727, 0.264028, 0.255246,
0.246357 },

{0.638889, 0.638843, 0.638706, 0.638476, 0.638155, 0.637743, 0.637238, 0.636642, 0.635953,
0.635173, 0.634301, 0.633337, 0.63228, 0.631132, 0.629891, 0.628557, 0.627131, 0.625612, 0.624,
0.622296, 0.620498, 0.618607, 0.616622, 0.614544, 0.612372, 0.610106, 0.607746, 0.605292,
0.602743, 0.600099, 0.597361, 0.594527, 0.591597, 0.588572, 0.585451, 0.582234, 0.57892,
0.57551, 0.572003, 0.568398, 0.564696, 0.560896, 0.556998, 0.553001, 0.548906, 0.544712,
0.540418, 0.536025, 0.531531, 0.526938, 0.522244, 0.517449, 0.512552, 0.507554, 0.502454,
0.497252, 0.491948, 0.48654, 0.481029, 0.475414, 0.469696, 0.463873, 0.457946, 0.451914,
0.445776, 0.439534, 0.433185, 0.42673, 0.420169, 0.413501, 0.406726, 0.399844, 0.392855,
0.385758, 0.378553, 0.37124, 0.363819, 0.356289, 0.348651, 0.340904, 0.333049, 0.325085,
0.317012, 0.30883, 0.300539, 0.29214, 0.283632, 0.275016, 0.266291, 0.257458, 0.248518 },

{0.644444, 0.644398, 0.644259, 0.644027, 0.643702, 0.643285, 0.642775, 0.642172, 0.641475,
0.640686, 0.639804, 0.638829, 0.63776, 0.636599, 0.635343, 0.633995, 0.632552, 0.631016,
0.629386, 0.627662, 0.625844, 0.623932, 0.621925, 0.619824, 0.617628, 0.615337, 0.61295,
0.610469, 0.607892, 0.605219, 0.60245, 0.599585, 0.596624, 0.593566, 0.590411, 0.587159,
0.58381, 0.580363, 0.576819, 0.573176, 0.569434, 0.565595, 0.561656, 0.557618, 0.55348,
0.549243, 0.544905, 0.540467, 0.535929, 0.531289, 0.526548, 0.521705, 0.516761, 0.511714,
0.506565, 0.501313, 0.495957, 0.490498, 0.484936, 0.479269, 0.473497, 0.467622, 0.461641,
0.455554, 0.449363, 0.443065, 0.436661, 0.430151, 0.423534, 0.41681, 0.40998, 0.403041,
0.395996, 0.388842, 0.381581, 0.374212, 0.366734, 0.359148, 0.351454, 0.343652, 0.335741,
0.327721, 0.319593, 0.311357, 0.303012, 0.294559, 0.285998, 0.277329, 0.268553, 0.259669,
0.250679 },

{0.65, 0.649953, 0.649812, 0.649578, 0.64925, 0.648827, 0.648311, 0.647701, 0.646997, 0.646199,
0.645307, 0.64432, 0.64324, 0.642065, 0.640795, 0.639431, 0.637973, 0.636419, 0.634771,
0.633028, 0.631189, 0.629256, 0.627226, 0.625102, 0.622881, 0.620565, 0.618152, 0.615643,
0.613038, 0.610336, 0.607537, 0.60464, 0.601647, 0.598556, 0.595367, 0.59208, 0.588695,
0.585212, 0.58163, 0.577948, 0.574168, 0.570288, 0.566308, 0.562228, 0.558048, 0.553768,
0.549386, 0.544903, 0.540319, 0.535633, 0.530845, 0.525955, 0.520962, 0.515866, 0.510667,
0.505365, 0.499959, 0.494449, 0.488834, 0.483115, 0.477291, 0.471362, 0.465327, 0.459187,
0.452941, 0.446588, 0.440129, 0.433564, 0.426891, 0.420112, 0.413225, 0.406231, 0.399129,
0.391919, 0.384602, 0.377177, 0.369643, 0.362001, 0.354251, 0.346393, 0.338427, 0.330352,
0.32217, 0.313879, 0.305481, 0.296975, 0.288362, 0.279641, 0.270814, 0.26188, 0.25284 },

{0.655556, 0.655508, 0.655366, 0.655129, 0.654797, 0.654369, 0.653847, 0.65323, 0.652518,
0.651711, 0.650809, 0.649811, 0.648719, 0.64753, 0.646247, 0.644867, 0.643392, 0.641821,
0.640155, 0.638392, 0.636533, 0.634578, 0.632526, 0.630377, 0.628132, 0.62579, 0.623351,
0.620815, 0.618181, 0.615449, 0.61262, 0.609692, 0.606666, 0.603542, 0.600319, 0.596997,
0.593576, 0.590056, 0.586436, 0.582716, 0.578896, 0.574976, 0.570955, 0.566833, 0.562611,
0.558286, 0.55386, 0.549333, 0.544703, 0.53997, 0.535135, 0.530197, 0.525156, 0.520011,
0.514762, 0.50941, 0.503953, 0.498391, 0.492725, 0.486953, 0.481076, 0.475094, 0.469005,
0.462811, 0.45651, 0.450103, 0.443589, 0.436968, 0.43024, 0.423405, 0.416463, 0.409413,
0.402255, 0.394989, 0.387616, 0.380134, 0.372545, 0.364848, 0.357042, 0.349129, 0.341108,
0.332979, 0.324742, 0.316398, 0.307947, 0.299388, 0.290723, 0.281951, 0.273073, 0.26409,
0.255001 },

{0.661111, 0.661063, 0.660919, 0.660679, 0.660343, 0.659912, 0.659384, 0.65876, 0.65804,
0.657223, 0.656311, 0.655302, 0.654197, 0.652995, 0.651697, 0.650302, 0.648811, 0.647222,
0.645537, 0.643754, 0.641875, 0.639898, 0.637823, 0.635651, 0.633381, 0.631013, 0.628547,
0.625983, 0.623321, 0.620559, 0.617699, 0.61474, 0.611682, 0.608524, 0.605267, 0.60191,
0.598453, 0.594895, 0.591237, 0.587479, 0.583619, 0.579658, 0.575596, 0.571432, 0.567166,
0.562799, 0.558328, 0.553755, 0.549079, 0.5443, 0.539418, 0.534432, 0.529342, 0.524148,
0.518849, 0.513446, 0.507938, 0.502325, 0.496607, 0.490783, 0.484853, 0.478817, 0.472675,
0.466427, 0.460071, 0.45361, 0.447041, 0.440365, 0.433581, 0.426691, 0.419692, 0.412586,
0.405373, 0.398052, 0.390622, 0.383085, 0.37544, 0.367688, 0.359827, 0.351859, 0.343783,
0.3356, 0.32731, 0.318913, 0.310408, 0.301798, 0.293081, 0.284259, 0.275331, 0.266299, 0.257162
},

{0.666667, 0.666618, 0.666473, 0.66623, 0.66589, 0.665454, 0.66492, 0.664289, 0.66356,
0.662735, 0.661812, 0.660792, 0.659674, 0.658459, 0.657146, 0.655736, 0.654228, 0.652622,
0.650918, 0.649115, 0.647215, 0.645216, 0.643119, 0.640923, 0.638628, 0.636234, 0.633741,
0.631149, 0.628458, 0.625666, 0.622776, 0.619785, 0.616694, 0.613502, 0.61021, 0.606818,
0.603324, 0.59973, 0.596033, 0.592236, 0.588336, 0.584335, 0.580231, 0.576025, 0.571716,
0.567304, 0.562789, 0.558171, 0.553449, 0.548623, 0.543693, 0.538659, 0.533521, 0.528277,
0.522929, 0.517475, 0.511916, 0.506251, 0.500481, 0.494604, 0.488621, 0.482532, 0.476336,
0.470034, 0.463624, 0.457108, 0.450484, 0.443753, 0.436914, 0.429968, 0.422914, 0.415752,
0.408483, 0.401106, 0.393622, 0.386029, 0.378329, 0.370521, 0.362606, 0.354583, 0.346453,
0.338217, 0.329873, 0.321423, 0.312867, 0.304205, 0.295437, 0.286565, 0.277588, 0.268507,
0.259323 },

{0.672222, 0.672173, 0.672026, 0.671781, 0.671437, 0.670995, 0.670456, 0.669817, 0.669081,
0.668246, 0.667313, 0.666281, 0.665151, 0.663923, 0.662595, 0.661169, 0.659644, 0.65802,
0.656297, 0.654475, 0.652553, 0.650532, 0.648412, 0.646192, 0.643872, 0.641452, 0.638932,
0.636312, 0.633591, 0.63077, 0.627848, 0.624825, 0.621702, 0.618476, 0.61515, 0.611721,
0.608191, 0.604559, 0.600825, 0.596988, 0.593048, 0.589006, 0.58486, 0.580612, 0.576259,
0.571804, 0.567244, 0.56258, 0.557812, 0.552939, 0.547961, 0.542879, 0.537691, 0.532398, 0.527,
0.521496, 0.515885, 0.510169, 0.504346, 0.498417, 0.492381, 0.486239, 0.479989, 0.473632,
0.467168, 0.460597, 0.453918, 0.447132, 0.440238, 0.433237, 0.426127, 0.41891, 0.411586,
0.404153, 0.396613, 0.388966, 0.381211, 0.373348, 0.365378, 0.357302, 0.349118, 0.340828,
0.332432, 0.323929, 0.315321, 0.306608, 0.297791, 0.288869, 0.279843, 0.270715, 0.261484 },

{0.677778, 0.677728, 0.677579, 0.677331, 0.676984, 0.676537, 0.675991, 0.675346, 0.674601,
0.673757, 0.672814, 0.67177, 0.670628, 0.669385, 0.668043, 0.666601, 0.665059, 0.663417,
0.661675, 0.659833, 0.65789, 0.655847, 0.653703, 0.651459, 0.649114, 0.646668, 0.644121,
0.641472, 0.638722, 0.635871, 0.632918, 0.629863, 0.626705, 0.623446, 0.620084, 0.61662,
0.613053, 0.609383, 0.60561, 0.601734, 0.597754, 0.593671, 0.589483, 0.585192, 0.580796,
0.576296, 0.571691, 0.566982, 0.562167, 0.557247, 0.552222, 0.547091, 0.541854, 0.536512,
0.531063, 0.525508, 0.519846, 0.514078, 0.508203, 0.502221, 0.496132, 0.489936, 0.483633,
0.477222, 0.470704, 0.464078, 0.457344, 0.450503, 0.443554, 0.436497, 0.429333, 0.42206,
0.41468, 0.407193, 0.399598, 0.391895, 0.384085, 0.376168, 0.368145, 0.360014, 0.351777,
0.343434, 0.334985, 0.326431, 0.317772, 0.309009, 0.300141, 0.291171, 0.282097, 0.272922,
0.263645 },

{0.683333, 0.683283, 0.683133, 0.682882, 0.682531, 0.682079, 0.681527, 0.680874, 0.680121,
0.679268, 0.678314, 0.677259, 0.676103, 0.674847, 0.67349, 0.672032, 0.670473, 0.668813,
0.667052, 0.665189, 0.663225, 0.66116, 0.658993, 0.656724, 0.654353, 0.651881, 0.649306,
0.646629, 0.64385, 0.640968, 0.637983, 0.634896, 0.631705, 0.628412, 0.625015, 0.621514,
0.61791, 0.614203, 0.610391, 0.606475, 0.602455, 0.59833, 0.5941, 0.589766, 0.585326, 0.580782,
0.576132, 0.571376, 0.566515, 0.561548, 0.556475, 0.551295, 0.546009, 0.540617, 0.535118,
0.529512, 0.523799, 0.517979, 0.512052, 0.506017, 0.499875, 0.493625, 0.487268, 0.480803,
0.47423, 0.46755, 0.460761, 0.453865, 0.446861, 0.439749, 0.43253, 0.425202, 0.417767,
0.410225, 0.402575, 0.394817, 0.386953, 0.378982, 0.370904, 0.362721, 0.354431, 0.346035,
0.337535, 0.328929, 0.32022, 0.311406, 0.30249, 0.293471, 0.28435, 0.275128, 0.265806 },

{0.688889, 0.688838, 0.688686, 0.688432, 0.688077, 0.68762, 0.687062, 0.686402, 0.685641,
0.684778, 0.683813, 0.682747, 0.681578, 0.680308, 0.678936, 0.677462, 0.675886, 0.674208,
0.672427, 0.670544, 0.668559, 0.666471, 0.66428, 0.661987, 0.65959, 0.657091, 0.654489,
0.651783, 0.648974, 0.646061, 0.643045, 0.639925, 0.636701, 0.633373, 0.629941, 0.626404,
0.622763, 0.619017, 0.615166, 0.61121, 0.607149, 0.602983, 0.598711, 0.594333, 0.58985,
0.585261, 0.580565, 0.575764, 0.570856, 0.565841, 0.560719, 0.555491, 0.550156, 0.544714,
0.539164, 0.533507, 0.527743, 0.521871, 0.515891, 0.509804, 0.503608, 0.497305, 0.490894,
0.484375, 0.477748, 0.471013, 0.46417, 0.457219, 0.45016, 0.442993, 0.435718, 0.428336,
0.420846, 0.413248, 0.405544, 0.397732, 0.389814, 0.381789, 0.373658, 0.365421, 0.357079,
0.348631, 0.340079, 0.331423, 0.322663, 0.3138, 0.304835, 0.295769, 0.286601, 0.277334,
0.267967 },

{0.694444, 0.694393, 0.694239, 0.693983, 0.693624, 0.693162, 0.692597, 0.69193, 0.69116,
0.690288, 0.689312, 0.688234, 0.687053, 0.685769, 0.684381, 0.682891, 0.681298, 0.679601,
0.677801, 0.675897, 0.67389, 0.67178, 0.669565, 0.667247, 0.664825, 0.662299, 0.659669,
0.656934, 0.654095, 0.651152, 0.648103, 0.644951, 0.641693, 0.63833, 0.634862, 0.631289,
0.62761, 0.623826, 0.619935, 0.61594, 0.611838, 0.607629, 0.603315, 0.598894, 0.594367,
0.589733, 0.584992, 0.580144, 0.575188, 0.570126, 0.564957, 0.559679, 0.554295, 0.548802,
0.543202, 0.537494, 0.531678, 0.525754, 0.519722, 0.513581, 0.507333, 0.500976, 0.494511,
0.487938, 0.481257, 0.474467, 0.467569, 0.460563, 0.45345, 0.446228, 0.438898, 0.431461,
0.423916, 0.416264, 0.408505, 0.40064, 0.392667, 0.384589, 0.376405, 0.368115, 0.359721,
0.351222, 0.342619, 0.333912, 0.325103, 0.316191, 0.307178, 0.298065, 0.288851, 0.279539,
0.270128 },

{0.7, 0.699948, 0.699793, 0.699533, 0.69917, 0.698703, 0.698132, 0.697458, 0.69668, 0.695797,
0.694811, 0.693721, 0.692527, 0.691228, 0.689826, 0.688319, 0.686708, 0.684993, 0.683173,
0.681249, 0.67922, 0.677087, 0.674848, 0.672505, 0.670057, 0.667504, 0.664845, 0.662082,
0.659213, 0.656238, 0.653158, 0.649972, 0.64668, 0.643282, 0.639779, 0.636168, 0.632452,
0.628629, 0.624699, 0.620663, 0.61652, 0.61227, 0.607913, 0.603448, 0.598877, 0.594197,
0.589411, 0.584516, 0.579514, 0.574404, 0.569185, 0.563859, 0.558425, 0.552882, 0.547231,
0.541472, 0.535604, 0.529628, 0.523543, 0.51735, 0.511048, 0.504638, 0.498119, 0.491492,
0.484756, 0.477912, 0.47096, 0.463899, 0.45673, 0.449454, 0.44207, 0.434578, 0.426979,
0.419272, 0.411459, 0.40354, 0.395514, 0.387382, 0.379145, 0.370804, 0.362357, 0.353807,
0.345153, 0.336397, 0.327539, 0.318579, 0.309519, 0.300359, 0.2911, 0.281743, 0.272289 },

{0.705556, 0.705503, 0.705346, 0.705084, 0.704716, 0.704244, 0.703667, 0.702985, 0.702198,
0.701306, 0.700309, 0.699207, 0.698, 0.696687, 0.695269, 0.693746, 0.692117, 0.690383,
0.688544, 0.686599, 0.684548, 0.682391, 0.680129, 0.677761, 0.675286, 0.672706, 0.670019,
0.667226, 0.664327, 0.661321, 0.658209, 0.654989, 0.651663, 0.64823, 0.64469, 0.641043,
0.637289, 0.633427, 0.629458, 0.625381, 0.621196, 0.616904, 0.612504, 0.607996, 0.603379,
0.598655, 0.593822, 0.588881, 0.583831, 0.578673, 0.573406, 0.568031, 0.562547, 0.556954,
0.551252, 0.545441, 0.539522, 0.533493, 0.527356, 0.52111, 0.514755, 0.508291, 0.501718,
0.495037, 0.488246, 0.481348, 0.474341, 0.467226, 0.460002, 0.452671, 0.445232, 0.437686,
0.430033, 0.422272, 0.414405, 0.406432, 0.398353, 0.390169, 0.381879, 0.373486, 0.364988,
0.356387, 0.347683, 0.338878, 0.329971, 0.320964, 0.311857, 0.302651, 0.293347, 0.283946,
0.27445 },

{0.711111, 0.711058, 0.710899, 0.710634, 0.710263, 0.709785, 0.709202, 0.708512, 0.707717,
0.706815, 0.705807, 0.704693, 0.703472, 0.702145, 0.700712, 0.699172, 0.697526, 0.695773,
0.693913, 0.691947, 0.689874, 0.687694, 0.685408, 0.683014, 0.680513, 0.677905, 0.67519,
0.672368, 0.669438, 0.6664, 0.663255, 0.660002, 0.656642, 0.653174, 0.649597, 0.645913,
0.64212, 0.63822, 0.63421, 0.630093, 0.625867, 0.621532, 0.617088, 0.612536, 0.607875,
0.603105, 0.598226, 0.593238, 0.588141, 0.582935, 0.577619, 0.572194, 0.56666, 0.561016,
0.555264, 0.549402, 0.54343, 0.537349, 0.531159, 0.52486, 0.518451, 0.511934, 0.505307,
0.498572, 0.491727, 0.484774, 0.477713, 0.470543, 0.463265, 0.45588, 0.448386, 0.440786,
0.433078, 0.425264, 0.417343, 0.409317, 0.401185, 0.392948, 0.384607, 0.376162, 0.367613,
0.358962, 0.350209, 0.341354, 0.332399, 0.323345, 0.314192, 0.304941, 0.295593, 0.286149,
0.276611 },

{0.716667, 0.716613, 0.716452, 0.716184, 0.715809, 0.715326, 0.714737, 0.714039, 0.713235,
0.712323, 0.711304, 0.710178, 0.708944, 0.707602, 0.706153, 0.704597, 0.702932, 0.701161,
0.699281, 0.697294, 0.695198, 0.692995, 0.690684, 0.688265, 0.685737, 0.683102, 0.680358,
0.677506, 0.674545, 0.671476, 0.668298, 0.665011, 0.661616, 0.658112, 0.654499, 0.650777,
0.646946, 0.643006, 0.638957, 0.634798, 0.63053, 0.626153, 0.621666, 0.61707, 0.612364,
0.607548, 0.602623, 0.597587, 0.592442, 0.587188, 0.581823, 0.576349, 0.570764, 0.56507,
0.559266, 0.553353, 0.547329, 0.541196, 0.534953, 0.528601, 0.522139, 0.515568, 0.508887,
0.502097, 0.495199, 0.488192, 0.481076, 0.473851, 0.466519, 0.459079, 0.451532, 0.443877,
0.436115, 0.428247, 0.420273, 0.412194, 0.404009, 0.39572, 0.387327, 0.378831, 0.370232,
0.361531, 0.352729, 0.343826, 0.334824, 0.325723, 0.316524, 0.307228, 0.297837, 0.288351,
0.278772 },

{0.722222, 0.722168, 0.722005, 0.721734, 0.721355, 0.720867, 0.720271, 0.719566, 0.718753,
0.717831, 0.716801, 0.715662, 0.714415, 0.713058, 0.711594, 0.71002, 0.708338, 0.706547,
0.704647, 0.702638, 0.70052, 0.698294, 0.695958, 0.693513, 0.690959, 0.688295, 0.685522,
0.68264, 0.679648, 0.676547, 0.673337, 0.670016, 0.666586, 0.663046, 0.659396, 0.655637,
0.651767, 0.647787, 0.643698, 0.639498, 0.635188, 0.630768, 0.626237, 0.621596, 0.616845,
0.611983, 0.607011, 0.601929, 0.596736, 0.591433, 0.586019, 0.580495, 0.57486, 0.569115,
0.56326, 0.557295, 0.551219, 0.545033, 0.538738, 0.532332, 0.525817, 0.519192, 0.512457,
0.505613, 0.498661, 0.491599, 0.484429, 0.47715, 0.469764, 0.46227, 0.454668, 0.446959,
0.439144, 0.431223, 0.423196, 0.415063, 0.406827, 0.398486, 0.390041, 0.381494, 0.372845,
0.364095, 0.355244, 0.346294, 0.337244, 0.328097, 0.318854, 0.309514, 0.30008, 0.290553,
0.280933 },

{0.727778, 0.727723, 0.727559, 0.727285, 0.726901, 0.726408, 0.725805, 0.725092, 0.72427,
0.723339, 0.722297, 0.721146, 0.719885, 0.718514, 0.717033, 0.715443, 0.713742, 0.711932,
0.710012, 0.707981, 0.705841, 0.70359, 0.701229, 0.698758, 0.696177, 0.693486, 0.690684,
0.687771, 0.684748, 0.681615, 0.678371, 0.675016, 0.671551, 0.667975, 0.664288, 0.660491,
0.656582, 0.652563, 0.648432, 0.644191, 0.639839, 0.635375, 0.630801, 0.626115, 0.621319,
0.616411, 0.611392, 0.606262, 0.601021, 0.595669, 0.590206, 0.584632, 0.578947, 0.573151,
0.567245, 0.561227, 0.555099, 0.548861, 0.542512, 0.536054, 0.529485, 0.522806, 0.516018,
0.50912, 0.502113, 0.494997, 0.487773, 0.48044, 0.472999, 0.465451, 0.457795, 0.450033,
0.442164, 0.434189, 0.42611, 0.417925, 0.409636, 0.401244, 0.392749, 0.384151, 0.375453,
0.366653, 0.357754, 0.348757, 0.339661, 0.330469, 0.321181, 0.311798, 0.302322, 0.292753,
0.283094 },

{0.733333, 0.733278, 0.733112, 0.732835, 0.732447, 0.731948, 0.731339, 0.730619, 0.729788,
0.728846, 0.727793, 0.726629, 0.725354, 0.723968, 0.722472, 0.720864, 0.719145, 0.717315,
0.715374, 0.713322, 0.711159, 0.708884, 0.706499, 0.704001, 0.701393, 0.698673, 0.695842,
0.692899, 0.689845, 0.686679, 0.683401, 0.680012, 0.676512, 0.672899, 0.669175, 0.665339,
0.661392, 0.657332, 0.653161, 0.648878, 0.644483, 0.639976, 0.635358, 0.630627, 0.625785,
0.620831, 0.615765, 0.610587, 0.605298, 0.599897, 0.594384, 0.58876, 0.583025, 0.577178,
0.57122, 0.56515, 0.55897, 0.552679, 0.546278, 0.539765, 0.533143, 0.526411, 0.519568,
0.512616, 0.505555, 0.498385, 0.491107, 0.48372, 0.476225, 0.468623, 0.460913, 0.453097,
0.445175, 0.437148, 0.429015, 0.420779, 0.412438, 0.403995, 0.395449, 0.386802, 0.378054,
0.369206, 0.36026, 0.351215, 0.342074, 0.332837, 0.323505, 0.314079, 0.304562, 0.294953,
0.285255 },

{0.738889, 0.738833, 0.738665, 0.738385, 0.737993, 0.737489, 0.736873, 0.736145, 0.735304,
0.734352, 0.733288, 0.732111, 0.730823, 0.729422, 0.727909, 0.726284, 0.724547, 0.722697,
0.720736, 0.718662, 0.716475, 0.714176, 0.711765, 0.709242, 0.706606, 0.703857, 0.700997,
0.698023, 0.694937, 0.691739, 0.688428, 0.685004, 0.681467, 0.677818, 0.674057, 0.670182,
0.666195, 0.662096, 0.657883, 0.653558, 0.649121, 0.64457, 0.639907, 0.635132, 0.630243,
0.625243, 0.62013, 0.614904, 0.609566, 0.604116, 0.598554, 0.592879, 0.587093, 0.581195,
0.575185, 0.569064, 0.562831, 0.556488, 0.550033, 0.543467, 0.536791, 0.530005, 0.523109,
0.516103, 0.508988, 0.501764, 0.494431, 0.48699, 0.479441, 0.471785, 0.464022, 0.456153,
0.448178, 0.440098, 0.431913, 0.423624, 0.415233, 0.406738, 0.398142, 0.389446, 0.380649,
0.371754, 0.36276, 0.353669, 0.344483, 0.335201, 0.325826, 0.316359, 0.3068, 0.297153, 0.287416
},

{0.744444, 0.744388, 0.744218, 0.743935, 0.743539, 0.743029, 0.742406, 0.74167, 0.740821,
0.739858, 0.738782, 0.737593, 0.736291, 0.734875, 0.733346, 0.731703, 0.729947, 0.728078,
0.726095, 0.723999, 0.721789, 0.719466, 0.71703, 0.714479, 0.711816, 0.709039, 0.706148,
0.703144, 0.700026, 0.696794, 0.693449, 0.689991, 0.686418, 0.682732, 0.678933, 0.67502,
0.670993, 0.666853, 0.662599, 0.658232, 0.653751, 0.649157, 0.644449, 0.639628, 0.634694,
0.629647, 0.624486, 0.619212, 0.613826, 0.608326, 0.602714, 0.59699, 0.591152, 0.585203,
0.579141, 0.572968, 0.566683, 0.560286, 0.553778, 0.547159, 0.54043, 0.53359, 0.526639,
0.51958, 0.51241, 0.505132, 0.497745, 0.49025, 0.482648, 0.474938, 0.467122, 0.459199,
0.451171, 0.443039, 0.434802, 0.426462, 0.418019, 0.409475, 0.400829, 0.392083, 0.383238,
0.374295, 0.365255, 0.356119, 0.346887, 0.337562, 0.328145, 0.318636, 0.309038, 0.299351,
0.289577 },

{0.75, 0.749943, 0.749771, 0.749485, 0.749084, 0.748569, 0.74794, 0.747196, 0.746337, 0.745364,
0.744276, 0.743074, 0.741758, 0.740327, 0.738781, 0.737121, 0.735346, 0.733457, 0.731453,
0.729334, 0.727101, 0.724754, 0.722291, 0.719714, 0.717023, 0.714217, 0.711296, 0.708261,
0.705111, 0.701846, 0.698467, 0.694973, 0.691364, 0.687641, 0.683804, 0.679852, 0.675785,
0.671604, 0.667309, 0.662899, 0.658375, 0.653737, 0.648984, 0.644118, 0.639137, 0.634043,
0.628834, 0.623512, 0.618077, 0.612528, 0.606866, 0.60109, 0.595202, 0.589201, 0.583088,
0.576862, 0.570524, 0.564075, 0.557513, 0.550841, 0.544058, 0.537164, 0.53016, 0.523046,
0.515823, 0.50849, 0.50105, 0.493501, 0.485845, 0.478081, 0.470212, 0.462237, 0.454156,
0.445971, 0.437683, 0.429292, 0.420798, 0.412204, 0.403509, 0.394714, 0.385822, 0.376831,
0.367745, 0.358564, 0.349288, 0.33992, 0.330461, 0.320911, 0.311274, 0.301549, 0.291738 },

{0.755556, 0.755498, 0.755324, 0.755035, 0.75463, 0.754109, 0.753473, 0.752721, 0.751853,
0.750869, 0.74977, 0.748555, 0.747224, 0.745778, 0.744215, 0.742537, 0.740744, 0.738834,
0.736809, 0.734668, 0.732411, 0.730039, 0.72755, 0.724947, 0.722227, 0.719392, 0.71644,
0.713374, 0.710191, 0.706893, 0.703479, 0.69995, 0.696305, 0.692545, 0.688669, 0.684678,
0.680571, 0.676349, 0.672012, 0.667559, 0.662992, 0.658309, 0.653511, 0.648599, 0.643572,
0.63843, 0.633174, 0.627803, 0.622319, 0.61672, 0.611008, 0.605182, 0.599242, 0.59319,
0.587024, 0.580746, 0.574355, 0.567853, 0.561238, 0.554512, 0.547675, 0.540728, 0.53367,
0.526502, 0.519225, 0.511839, 0.504344, 0.496741, 0.489032, 0.481215, 0.473293, 0.465265,
0.457132, 0.448895, 0.440555, 0.432113, 0.423569, 0.414925, 0.406181, 0.397339, 0.388399,
0.379362, 0.37023, 0.361004, 0.351685, 0.342275, 0.332774, 0.323185, 0.313508, 0.303746,
0.293899 },

{0.761111, 0.761053, 0.760877, 0.760585, 0.760175, 0.759649, 0.759006, 0.758245, 0.757368,
0.756374, 0.755263, 0.754035, 0.752689, 0.751227, 0.749648, 0.747952, 0.74614, 0.74421,
0.742163, 0.739999, 0.737719, 0.735321, 0.732807, 0.730176, 0.727428, 0.724563, 0.721581,
0.718483, 0.715268, 0.711936, 0.708488, 0.704923, 0.701241, 0.697443, 0.693529, 0.689498,
0.685351, 0.681087, 0.676708, 0.672212, 0.667601, 0.662874, 0.658031, 0.653072, 0.647999,
0.642809, 0.637505, 0.632086, 0.626552, 0.620903, 0.615141, 0.609264, 0.603273, 0.597168,
0.590951, 0.58462, 0.578177, 0.571621, 0.564953, 0.558173, 0.551283, 0.544281, 0.537169,
0.529948, 0.522616, 0.515176, 0.507628, 0.499972, 0.492209, 0.484339, 0.476364, 0.468283,
0.460098, 0.45181, 0.443419, 0.434926, 0.426333, 0.417639, 0.408847, 0.399956, 0.390969,
0.381887, 0.37271, 0.36344, 0.354078, 0.344625, 0.335084, 0.325455, 0.315741, 0.305942, 0.29606
},

{0.766667, 0.766608, 0.76643, 0.766135, 0.765721, 0.765189, 0.764538, 0.76377, 0.762883,
0.761878, 0.760755, 0.759514, 0.758154, 0.756676, 0.75508, 0.753366, 0.751534, 0.749584,
0.747515, 0.745329, 0.743024, 0.740602, 0.738061, 0.735402, 0.732626, 0.729731, 0.726719,
0.723589, 0.720341, 0.716975, 0.713491, 0.70989, 0.706172, 0.702336, 0.698383, 0.694312,
0.690124, 0.685819, 0.681397, 0.676859, 0.672203, 0.667431, 0.662543, 0.657538, 0.652417,
0.64718, 0.641827, 0.636359, 0.630776, 0.625077, 0.619264, 0.613336, 0.607293, 0.601137,
0.594867, 0.588484, 0.581987, 0.575378, 0.568657, 0.561824, 0.55488, 0.547824, 0.540658,
0.533383, 0.525998, 0.518504, 0.510902, 0.503192, 0.495376, 0.487453, 0.479425, 0.471292,
0.463056, 0.454716, 0.446274, 0.437731, 0.429088, 0.420346, 0.411505, 0.402567, 0.393534,
0.384406, 0.375184, 0.365871, 0.356466, 0.346973, 0.337392, 0.327724, 0.317972, 0.308137,
0.298221 },

{0.772222, 0.772162, 0.771983, 0.771684, 0.771266, 0.770728, 0.770071, 0.769294, 0.768398,
0.767382, 0.766247, 0.764992, 0.763618, 0.762124, 0.760511, 0.758779, 0.756927, 0.754956,
0.752866, 0.750656, 0.748327, 0.745879, 0.743312, 0.740626, 0.73782, 0.734896, 0.731852,
0.72869, 0.725409, 0.722009, 0.71849, 0.714853, 0.711097, 0.707223, 0.703231, 0.69912,
0.694891, 0.690545, 0.68608, 0.681498, 0.676798, 0.671981, 0.667046, 0.661995, 0.656827,
0.651542, 0.646141, 0.640624, 0.63499, 0.629241, 0.623377, 0.617398, 0.611304, 0.605096,
0.598773, 0.592337, 0.585788, 0.579125, 0.572351, 0.565464, 0.558466, 0.551356, 0.544137,
0.536807, 0.529368, 0.521821, 0.514165, 0.506402, 0.498533, 0.490557, 0.482477, 0.474292,
0.466004, 0.457613, 0.449121, 0.440528, 0.431835, 0.423044, 0.414156, 0.405172, 0.396092,
0.386919, 0.377654, 0.368297, 0.358851, 0.349317, 0.339696, 0.329991, 0.320202, 0.310332,
0.300382 },

{0.777778, 0.777717, 0.777536, 0.777234, 0.776811, 0.776268, 0.775603, 0.774818, 0.773912,
0.772885, 0.771738, 0.77047, 0.769081, 0.767571, 0.765941, 0.76419, 0.762319, 0.760327,
0.758214, 0.755981, 0.753628, 0.751154, 0.74856, 0.745846, 0.743012, 0.740057, 0.736982,
0.733788, 0.730473, 0.727039, 0.723485, 0.719811, 0.716018, 0.712105, 0.708073, 0.703922,
0.699652, 0.695263, 0.690756, 0.68613, 0.681385, 0.676523, 0.671542, 0.666444, 0.661228,
0.655895, 0.650445, 0.644879, 0.639196, 0.633396, 0.627481, 0.62145, 0.615304, 0.609044,
0.602669, 0.59618, 0.589577, 0.582862, 0.576033, 0.569093, 0.562041, 0.554878, 0.547604,
0.540221, 0.532728, 0.525127, 0.517418, 0.509602, 0.501679, 0.493651, 0.485519, 0.477282,
0.468942, 0.460501, 0.451958, 0.443316, 0.434575, 0.425736, 0.4168, 0.407769, 0.398644,
0.389427, 0.380118, 0.370719, 0.361232, 0.351657, 0.341998, 0.332255, 0.322431, 0.312526,
0.302544 },

{0.783333, 0.783272, 0.783089, 0.782784, 0.782356, 0.781807, 0.781135, 0.780342, 0.779426,
0.778388, 0.777228, 0.775947, 0.774543, 0.773017, 0.77137, 0.7696, 0.767709, 0.765696,
0.763561, 0.761305, 0.758927, 0.756427, 0.753806, 0.751063, 0.7482, 0.745215, 0.742108,
0.738881, 0.735533, 0.732064, 0.728474, 0.724763, 0.720932, 0.716981, 0.712909, 0.708718,
0.704406, 0.699975, 0.695424, 0.690754, 0.685965, 0.681057, 0.67603, 0.670885, 0.665621,
0.66024, 0.654741, 0.649124, 0.643391, 0.637541, 0.631575, 0.625493, 0.619295, 0.612982,
0.606554, 0.600012, 0.593356, 0.586587, 0.579705, 0.572711, 0.565605, 0.558388, 0.551061,
0.543624, 0.536077, 0.528423, 0.52066, 0.512791, 0.504816, 0.496735, 0.48855, 0.480262,
0.471872, 0.46338, 0.454787, 0.446096, 0.437306, 0.428419, 0.419437, 0.41036, 0.40119,
0.391928, 0.382576, 0.373136, 0.363608, 0.353994, 0.344297, 0.334518, 0.324658, 0.314719,
0.304705 },

{0.788889, 0.788827, 0.788642, 0.788333, 0.787901, 0.787346, 0.786667, 0.785865, 0.784939,
0.78389, 0.782718, 0.781423, 0.780004, 0.778462, 0.776797, 0.775009, 0.773097, 0.771063,
0.768906, 0.766626, 0.764223, 0.761697, 0.759049, 0.756278, 0.753384, 0.750369, 0.747231,
0.74397, 0.740588, 0.737084, 0.733458, 0.72971, 0.725841, 0.721851, 0.71774, 0.713507,
0.709154, 0.70468, 0.700086, 0.695371, 0.690537, 0.685583, 0.680509, 0.675317, 0.670005,
0.664575, 0.659027, 0.653361, 0.647577, 0.641676, 0.635659, 0.629525, 0.623274, 0.616909,
0.610428, 0.603833, 0.597124, 0.590301, 0.583366, 0.576318, 0.569158, 0.561887, 0.554506,
0.547015, 0.539415, 0.531707, 0.523892, 0.515969, 0.507941, 0.499809, 0.491572, 0.483233,
0.474791, 0.466249, 0.457607, 0.448867, 0.440029, 0.431095, 0.422066, 0.412943, 0.403729,
0.394424, 0.38503, 0.375548, 0.36598, 0.356328, 0.346593, 0.336778, 0.326883, 0.316912,
0.306866 },

{0.794444, 0.794382, 0.794195, 0.793883, 0.793446, 0.792885, 0.792199, 0.791388, 0.790452,
0.789392, 0.788207, 0.786898, 0.785464, 0.783906, 0.782223, 0.780416, 0.778484, 0.776428,
0.774248, 0.771944, 0.769516, 0.766964, 0.764288, 0.761489, 0.758566, 0.755519, 0.752349,
0.749055, 0.745639, 0.7421, 0.738437, 0.734652, 0.730745, 0.726715, 0.722563, 0.71829,
0.713894, 0.709378, 0.70474, 0.69998, 0.695101, 0.690101, 0.68498, 0.67974, 0.67438, 0.668901,
0.663304, 0.657587, 0.651753, 0.645801, 0.639732, 0.633546, 0.627244, 0.620826, 0.614292,
0.607644, 0.600881, 0.594005, 0.587015, 0.579914, 0.5727, 0.565375, 0.55794, 0.550396,
0.542742, 0.534981, 0.527112, 0.519137, 0.511057, 0.502872, 0.494584, 0.486193, 0.477701,
0.469109, 0.460418, 0.451629, 0.442743, 0.433762, 0.424688, 0.41552, 0.406262, 0.396914,
0.387478, 0.377955, 0.368348, 0.358658, 0.348886, 0.339036, 0.329107, 0.319104, 0.309027 },

{0.8, 0.799937, 0.799748, 0.799432, 0.798991, 0.798424, 0.79773, 0.796911, 0.795965, 0.794893,
0.793696, 0.792373, 0.790923, 0.789348, 0.787648, 0.785821, 0.783869, 0.781792, 0.779589,
0.777261, 0.774807, 0.772229, 0.769525, 0.766697, 0.763743, 0.760665, 0.757463, 0.754136,
0.750685, 0.74711, 0.743411, 0.739589, 0.735643, 0.731573, 0.727381, 0.723066, 0.718628,
0.714068, 0.709386, 0.704582, 0.699657, 0.69461, 0.689443, 0.684154, 0.678746, 0.673218,
0.667571, 0.661804, 0.655919, 0.649916, 0.643795, 0.637557, 0.631202, 0.624731, 0.618145,
0.611443, 0.604627, 0.597697, 0.590654, 0.583498, 0.576231, 0.568852, 0.561363, 0.553765,
0.546058, 0.538243, 0.530322, 0.522294, 0.514161, 0.505925, 0.497585, 0.489144, 0.480602,
0.47196, 0.46322, 0.454383, 0.44545, 0.436422, 0.427302, 0.41809, 0.408788, 0.399398, 0.38992,
0.380358, 0.370712, 0.360984, 0.351177, 0.341291, 0.33133, 0.321295, 0.311188 },

{0.805556, 0.805492, 0.805301, 0.804982, 0.804536, 0.803962, 0.803261, 0.802433, 0.801477,
0.800394, 0.799184, 0.797846, 0.796382, 0.79479, 0.793071, 0.791225, 0.789253, 0.787153,
0.784927, 0.782575, 0.780096, 0.77749, 0.774759, 0.771901, 0.768918, 0.765808, 0.762573,
0.759213, 0.755727, 0.752116, 0.74838, 0.74452, 0.740535, 0.736426, 0.732192, 0.727835,
0.723355, 0.718751, 0.714025, 0.709176, 0.704204, 0.699111, 0.693896, 0.68856, 0.683103,
0.677526, 0.671828, 0.666011, 0.660075, 0.654021, 0.647848, 0.641557, 0.63515, 0.628626,
0.621986, 0.615231, 0.608361, 0.601378, 0.594281, 0.587071, 0.57975, 0.572317, 0.564775,
0.557123, 0.549363, 0.541495, 0.53352, 0.52544, 0.517255, 0.508967, 0.500576, 0.492084,
0.483492, 0.474801, 0.466012, 0.457127, 0.448148, 0.439074, 0.429909, 0.420653, 0.411308,
0.401876, 0.392358, 0.382756, 0.373072, 0.363307, 0.353464, 0.343545, 0.333551, 0.323485,
0.313349 },

{0.811111, 0.811047, 0.810853, 0.810531, 0.81008, 0.809501, 0.808792, 0.807955, 0.806989,
0.805894, 0.804671, 0.803319, 0.801839, 0.80023, 0.798493, 0.796628, 0.794635, 0.792513,
0.790264, 0.787887, 0.785382, 0.782749, 0.77999, 0.777102, 0.774088, 0.770947, 0.767679,
0.764285, 0.760764, 0.757117, 0.753344, 0.749445, 0.745421, 0.741271, 0.736997, 0.732598,
0.728075, 0.723427, 0.718656, 0.713762, 0.708744, 0.703604, 0.698341, 0.692957, 0.687451,
0.681824, 0.676076, 0.670208, 0.664221, 0.658115, 0.65189, 0.645547, 0.639087, 0.63251,
0.625816, 0.619008, 0.612084, 0.605047, 0.597896, 0.590632, 0.583257, 0.575771, 0.568175,
0.560469, 0.552656, 0.544735, 0.536707, 0.528575, 0.520338, 0.511998, 0.503557, 0.495014,
0.486373, 0.477633, 0.468796, 0.459864, 0.450837, 0.441718, 0.432508, 0.423209, 0.413821,
0.404348, 0.394789, 0.385149, 0.375427, 0.365626, 0.355749, 0.345796, 0.335771, 0.325674,
0.31551 },

{0.816667, 0.816602, 0.816406, 0.816081, 0.815625, 0.815039, 0.814323, 0.813476, 0.8125,
0.811394, 0.810157, 0.808791, 0.807295, 0.80567, 0.803914, 0.802029, 0.800015, 0.797871,
0.795598, 0.793196, 0.790665, 0.788005, 0.785217, 0.7823, 0.779255, 0.776082, 0.772781,
0.769352, 0.765796, 0.762112, 0.758302, 0.754365, 0.750301, 0.746111, 0.741795, 0.737354,
0.732787, 0.728096, 0.72328, 0.718339, 0.713275, 0.708087, 0.702777, 0.697344, 0.691789,
0.686112, 0.680314, 0.674395, 0.668356, 0.662198, 0.655921, 0.649525, 0.643012, 0.636382,
0.629635, 0.622773, 0.615796, 0.608704, 0.601499, 0.594182, 0.586753, 0.579213, 0.571563,
0.563804, 0.555937, 0.547963, 0.539883, 0.531698, 0.52341, 0.515019, 0.506527, 0.497934,
0.489243, 0.480455, 0.47157, 0.462591, 0.453518, 0.444354, 0.4351, 0.425757, 0.416328,
0.406813, 0.397216, 0.387537, 0.377778, 0.367942, 0.35803, 0.348045, 0.337989, 0.327863,
0.317671 },

{0.822222, 0.822156, 0.821959, 0.82163, 0.821169, 0.820577, 0.819853, 0.818998, 0.818011,
0.816893, 0.815643, 0.814263, 0.812751, 0.811108, 0.809334, 0.807429, 0.805393, 0.803227,
0.80093, 0.798503, 0.795946, 0.793259, 0.790441, 0.787495, 0.784418, 0.781213, 0.777878,
0.774415, 0.770823, 0.767103, 0.763254, 0.759278, 0.755175, 0.750944, 0.746587, 0.742103,
0.737492, 0.732756, 0.727895, 0.722909, 0.717798, 0.712562, 0.707204, 0.701722, 0.696117,
0.69039, 0.684541, 0.678571, 0.672481, 0.666271, 0.659941, 0.653493, 0.646926, 0.640243,
0.633442, 0.626526, 0.619495, 0.61235, 0.605091, 0.597719, 0.590236, 0.582643, 0.574939,
0.567127, 0.559207, 0.55118, 0.543048, 0.534811, 0.526471, 0.518029, 0.509486, 0.500844,
0.492104, 0.483267, 0.474335, 0.465309, 0.456191, 0.446982, 0.437684, 0.428299, 0.418828,
0.409273, 0.399636, 0.38992, 0.380125, 0.370254, 0.360309, 0.350292, 0.340205, 0.330051,
0.319832 },

{0.827778, 0.827711, 0.827512, 0.827179, 0.826713, 0.826115, 0.825383, 0.824519, 0.823521,
0.822391, 0.821128, 0.819733, 0.818205, 0.816544, 0.814752, 0.812827, 0.81077, 0.808581,
0.80626, 0.803808, 0.801224, 0.798509, 0.795663, 0.792685, 0.789578, 0.78634, 0.782971,
0.779473, 0.775845, 0.772088, 0.768201, 0.764186, 0.760042, 0.755771, 0.751371, 0.746844,
0.74219, 0.737409, 0.732502, 0.72747, 0.722311, 0.717028, 0.711621, 0.70609, 0.700435,
0.694658, 0.688758, 0.682737, 0.676595, 0.670332, 0.66395, 0.657449, 0.650829, 0.644092,
0.637238, 0.630268, 0.623183, 0.615983, 0.60867, 0.601245, 0.593708, 0.58606, 0.578303,
0.570438, 0.562464, 0.554385, 0.5462, 0.537912, 0.52952, 0.521028, 0.512435, 0.503743,
0.494954, 0.486069, 0.47709, 0.468018, 0.458854, 0.449601, 0.44026, 0.430833, 0.421321,
0.411727, 0.402052, 0.392298, 0.382467, 0.372562, 0.362584, 0.352536, 0.34242, 0.332238,
0.321993 },

{0.833333, 0.833266, 0.833064, 0.832728, 0.832258, 0.831652, 0.830913, 0.830039, 0.829031,
0.827889, 0.826613, 0.825202, 0.823658, 0.82198, 0.820168, 0.818223, 0.816144, 0.813933,
0.811588, 0.80911, 0.806499, 0.803756, 0.80088, 0.797873, 0.794733, 0.791462, 0.78806,
0.784526, 0.780862, 0.777068, 0.773143, 0.769088, 0.764904, 0.760591, 0.756149, 0.751578,
0.74688, 0.742054, 0.737101, 0.732022, 0.726816, 0.721485, 0.716029, 0.710449, 0.704744,
0.698916, 0.692965, 0.686892, 0.680698, 0.674383, 0.667948, 0.661393, 0.65472, 0.647929,
0.641022, 0.633998, 0.626858, 0.619605, 0.612238, 0.604758, 0.597167, 0.589466, 0.581655,
0.573736, 0.56571, 0.557578, 0.549341, 0.541001, 0.532559, 0.524015, 0.515373, 0.506632,
0.497794, 0.488862, 0.479836, 0.470718, 0.461509, 0.452212, 0.442829, 0.43336, 0.423808,
0.414174, 0.404461, 0.394671, 0.384806, 0.374867, 0.364857, 0.354779, 0.344634, 0.334425,
0.324154 },

{0.838889, 0.838821, 0.838617, 0.838277, 0.837801, 0.83719, 0.836443, 0.835559, 0.834541,
0.833386, 0.832096, 0.830671, 0.82911, 0.827414, 0.825584, 0.823618, 0.821517, 0.819282,
0.816913, 0.814409, 0.811771, 0.809, 0.806095, 0.803056, 0.799885, 0.796581, 0.793144,
0.789575, 0.785874, 0.782042, 0.778078, 0.773984, 0.769759, 0.765404, 0.760919, 0.756305,
0.751562, 0.746691, 0.741692, 0.736566, 0.731313, 0.725933, 0.720428, 0.714797, 0.709042,
0.703164, 0.697161, 0.691037, 0.68479, 0.678422, 0.671934, 0.665326, 0.6586, 0.651755,
0.644793, 0.637715, 0.630522, 0.623214, 0.615793, 0.608259, 0.600614, 0.592859, 0.584995,
0.577023, 0.568944, 0.56076, 0.552471, 0.544079, 0.535586, 0.526992, 0.5183, 0.50951, 0.500624,
0.491644, 0.482572, 0.473408, 0.464156, 0.454815, 0.445389, 0.435879, 0.426287, 0.416615,
0.406865, 0.397039, 0.387139, 0.377168, 0.367127, 0.357019, 0.346846, 0.33661, 0.326315 },

{0.844444, 0.844376, 0.84417, 0.843826, 0.843345, 0.842727, 0.841972, 0.841079, 0.84005,
0.838883, 0.837579, 0.836139, 0.834561, 0.832848, 0.830997, 0.829011, 0.826888, 0.82463,
0.822236, 0.819706, 0.817041, 0.814241, 0.811306, 0.808236, 0.805032, 0.801695, 0.798223,
0.794619, 0.790881, 0.78701, 0.783008, 0.778873, 0.774607, 0.77021, 0.765682, 0.761024,
0.756237, 0.75132, 0.746274, 0.741101, 0.735799, 0.730371, 0.724817, 0.719136, 0.713331,
0.707401, 0.701347, 0.69517, 0.688871, 0.68245, 0.675909, 0.669247, 0.662467, 0.655568,
0.648552, 0.64142, 0.634173, 0.626811, 0.619335, 0.611748, 0.604049, 0.59624, 0.588323,
0.580297, 0.572166, 0.563929, 0.555588, 0.547145, 0.538601, 0.529957, 0.521215, 0.512377,
0.503444, 0.494417, 0.485298, 0.47609, 0.466793, 0.45741, 0.447942, 0.438392, 0.42876, 0.41905,
0.409264, 0.399402, 0.389469, 0.379465, 0.369394, 0.359256, 0.349056, 0.338795, 0.328476 },

{0.85, 0.849931, 0.849722, 0.849375, 0.848889, 0.848264, 0.847501, 0.846599, 0.845558,
0.844379, 0.843061, 0.841605, 0.840011, 0.838279, 0.83641, 0.834402, 0.832257, 0.829975,
0.827556, 0.825, 0.822307, 0.819478, 0.816513, 0.813412, 0.810176, 0.806804, 0.803298,
0.799657, 0.795882, 0.791973, 0.787931, 0.783756, 0.779449, 0.775009, 0.770438, 0.765736,
0.760903, 0.75594, 0.750848, 0.745627, 0.740277, 0.7348, 0.729196, 0.723465, 0.717608,
0.711627, 0.705521, 0.699292, 0.69294, 0.686467, 0.679872, 0.673157, 0.666322, 0.65937,
0.652299, 0.645113, 0.637811, 0.630395, 0.622865, 0.615223, 0.607471, 0.599608, 0.591637,
0.583559, 0.575375, 0.567086, 0.558693, 0.550199, 0.541605, 0.532911, 0.52412, 0.515233,
0.506253, 0.497179, 0.488015, 0.478762, 0.469422, 0.459996, 0.450487, 0.440896, 0.431226,
0.421479, 0.411656, 0.401761, 0.391794, 0.381759, 0.371657, 0.361492, 0.351265, 0.340979,
0.330637 },

{0.855556, 0.855485, 0.855275, 0.854924, 0.854433, 0.853801, 0.85303, 0.852118, 0.851066,
0.849874, 0.848542, 0.847071, 0.84546, 0.84371, 0.84182, 0.839792, 0.837624, 0.835318,
0.832874, 0.830291, 0.827571, 0.824712, 0.821717, 0.818584, 0.815315, 0.811909, 0.808368,
0.80469, 0.800878, 0.79693, 0.792849, 0.788633, 0.784284, 0.779801, 0.775186, 0.77044,
0.765561, 0.760552, 0.755413, 0.750144, 0.744745, 0.739219, 0.733565, 0.727783, 0.721876,
0.715843, 0.709685, 0.703403, 0.696998, 0.690471, 0.683823, 0.677054, 0.670165, 0.663158,
0.656034, 0.648793, 0.641437, 0.633966, 0.626382, 0.618686, 0.61088, 0.602964, 0.594939,
0.586808, 0.578571, 0.57023, 0.561786, 0.553241, 0.544596, 0.535853, 0.527014, 0.518079,
0.509051, 0.499931, 0.490722, 0.481425, 0.472041, 0.462574, 0.453024, 0.443394, 0.433686,
0.423901, 0.414043, 0.404114, 0.394115, 0.384049, 0.373918, 0.363725, 0.353472, 0.343162,
0.332798 },

{0.861111, 0.86104, 0.860827, 0.860473, 0.859976, 0.859338, 0.858558, 0.857636, 0.856573,
0.855369, 0.854023, 0.852536, 0.850908, 0.849139, 0.84723, 0.84518, 0.842989, 0.840659,
0.838189, 0.83558, 0.832831, 0.829943, 0.826917, 0.823753, 0.82045, 0.81701, 0.813433,
0.809719, 0.805868, 0.801882, 0.79776, 0.793503, 0.789111, 0.784586, 0.779927, 0.775135,
0.770211, 0.765155, 0.759969, 0.754651, 0.749204, 0.743628, 0.737923, 0.732091, 0.726132,
0.720047, 0.713837, 0.707502, 0.701044, 0.694464, 0.687761, 0.680938, 0.673996, 0.666934,
0.659756, 0.65246, 0.645049, 0.637524, 0.629886, 0.622136, 0.614276, 0.606306, 0.598229,
0.590045, 0.581755, 0.573362, 0.564867, 0.556271, 0.547576, 0.538784, 0.529896, 0.520913,
0.511839, 0.502673, 0.493419, 0.484078, 0.474652, 0.465143, 0.455553, 0.445884, 0.436138,
0.426318, 0.416425, 0.406462, 0.396431, 0.386335, 0.376176, 0.365956, 0.355678, 0.345345,
0.334959 },

{0.866667, 0.866595, 0.86638, 0.866021, 0.86552, 0.864874, 0.864086, 0.863155, 0.86208,
0.860863, 0.859503, 0.858, 0.856354, 0.854567, 0.852637, 0.850566, 0.848352, 0.845998,
0.843502, 0.840866, 0.838088, 0.835171, 0.832114, 0.828917, 0.825581, 0.822106, 0.818493,
0.814741, 0.810853, 0.806827, 0.802665, 0.798366, 0.793932, 0.789363, 0.78466, 0.779823,
0.774853, 0.76975, 0.764515, 0.759149, 0.753653, 0.748027, 0.742272, 0.736389, 0.730378,
0.724241, 0.717978, 0.71159, 0.705079, 0.698444, 0.691688, 0.684811, 0.677814, 0.670698,
0.663464, 0.656114, 0.648649, 0.64107, 0.633377, 0.625573, 0.617659, 0.609636, 0.601505,
0.593268, 0.584927, 0.576482, 0.567936, 0.559289, 0.550544, 0.541703, 0.532767, 0.523737,
0.514615, 0.505405, 0.496106, 0.486722, 0.477253, 0.467703, 0.458074, 0.448366, 0.438583,
0.428727, 0.4188, 0.408805, 0.398743, 0.388617, 0.37843, 0.368184, 0.357882, 0.347527, 0.33712
},

{0.872222, 0.87215, 0.871932, 0.87157, 0.871063, 0.870411, 0.869614, 0.868672, 0.867586,
0.866356, 0.864981, 0.863463, 0.8618, 0.859993, 0.858043, 0.85595, 0.853713, 0.851334,
0.848812, 0.846148, 0.843342, 0.840395, 0.837306, 0.834077, 0.830707, 0.827197, 0.823547,
0.819759, 0.815832, 0.811766, 0.807563, 0.803223, 0.798746, 0.794133, 0.789385, 0.784503,
0.779486, 0.774336, 0.769053, 0.763638, 0.758092, 0.752416, 0.74661, 0.740675, 0.734612,
0.728423, 0.722107, 0.715666, 0.709101, 0.702412, 0.695602, 0.68867, 0.681619, 0.674448,
0.66716, 0.659755, 0.652236, 0.644602, 0.636855, 0.628997, 0.621029, 0.612952, 0.604768,
0.596479, 0.588085, 0.579589, 0.570991, 0.562295, 0.5535, 0.54461, 0.535626, 0.526549,
0.517382, 0.508126, 0.498783, 0.489356, 0.479846, 0.470255, 0.460586, 0.450841, 0.441022,
0.431131, 0.42117, 0.411143, 0.40105, 0.390896, 0.380682, 0.370411, 0.360085, 0.349707,
0.339281 },

{0.877778, 0.877705, 0.877485, 0.877119, 0.876606, 0.875947, 0.875141, 0.87419, 0.873092,
0.871849, 0.870459, 0.868924, 0.867244, 0.865418, 0.863448, 0.861332, 0.859072, 0.856668,
0.85412, 0.851428, 0.848593, 0.845616, 0.842495, 0.839233, 0.835829, 0.832283, 0.828597,
0.824771, 0.820804, 0.816699, 0.812455, 0.808072, 0.803552, 0.798896, 0.794103, 0.789174,
0.78411, 0.778912, 0.773581, 0.768117, 0.762521, 0.756794, 0.750937, 0.744951, 0.738836,
0.732593, 0.726224, 0.71973, 0.713111, 0.706368, 0.699503, 0.692517, 0.685411, 0.678186,
0.670843, 0.663383, 0.655809, 0.64812, 0.640319, 0.632407, 0.624385, 0.616255, 0.608018,
0.599676, 0.59123, 0.582683, 0.574034, 0.565288, 0.556444, 0.547505, 0.538473, 0.52935,
0.520137, 0.510836, 0.50145, 0.49198, 0.482429, 0.472798, 0.463091, 0.453308, 0.443453,
0.433528, 0.423534, 0.413475, 0.403353, 0.393171, 0.38293, 0.372635, 0.362286, 0.351888,
0.341442 },

{0.883333, 0.883259, 0.883037, 0.882667, 0.882149, 0.881483, 0.880669, 0.879707, 0.878597,
0.877341, 0.875936, 0.874385, 0.872687, 0.870842, 0.86885, 0.866712, 0.864429, 0.861999,
0.859425, 0.856705, 0.853841, 0.850833, 0.84768, 0.844385, 0.840946, 0.837365, 0.833642,
0.829777, 0.825771, 0.821626, 0.81734, 0.812915, 0.808351, 0.80365, 0.798812, 0.793836,
0.788726, 0.78348, 0.7781, 0.772586, 0.76694, 0.761162, 0.755254, 0.749215, 0.743048, 0.736752,
0.73033, 0.723781, 0.717108, 0.710311, 0.703392, 0.696351, 0.68919, 0.68191, 0.674512,
0.666998, 0.659368, 0.651625, 0.64377, 0.635803, 0.627728, 0.619544, 0.611254, 0.60286,
0.594362, 0.585763, 0.577065, 0.568268, 0.559375, 0.550388, 0.541309, 0.532139, 0.522881,
0.513536, 0.504106, 0.494595, 0.485003, 0.475333, 0.465587, 0.455768, 0.445877, 0.435918,
0.425892, 0.415803, 0.405652, 0.395442, 0.385176, 0.374856, 0.364486, 0.354067, 0.343603 },

{0.888889, 0.888814, 0.88859, 0.888215, 0.887692, 0.887018, 0.886195, 0.885223, 0.884102,
0.882832, 0.881413, 0.879845, 0.878128, 0.876264, 0.874251, 0.872091, 0.869783, 0.867328,
0.864727, 0.861979, 0.859085, 0.856046, 0.852861, 0.849532, 0.846058, 0.842441, 0.838681,
0.834778, 0.830732, 0.826546, 0.822218, 0.81775, 0.813143, 0.808397, 0.803512, 0.79849,
0.793332, 0.788038, 0.782609, 0.777045, 0.771348, 0.765519, 0.759559, 0.753468, 0.747248,
0.740899, 0.734423, 0.727821, 0.721093, 0.714242, 0.707267, 0.700172, 0.692955, 0.68562,
0.678167, 0.670598, 0.662914, 0.655116, 0.647206, 0.639186, 0.631057, 0.62282, 0.614477,
0.60603, 0.597481, 0.588831, 0.580082, 0.571236, 0.562294, 0.553259, 0.544133, 0.534917,
0.525614, 0.516225, 0.506753, 0.497199, 0.487567, 0.477858, 0.468075, 0.458219, 0.448294,
0.438302, 0.428245, 0.418125, 0.407946, 0.397709, 0.387418, 0.377075, 0.366684, 0.356245,
0.345764 },

{0.894444, 0.894369, 0.894142, 0.893764, 0.893234, 0.892554, 0.891722, 0.890739, 0.889606,
0.888322, 0.886888, 0.885303, 0.883569, 0.881684, 0.87965, 0.877467, 0.875135, 0.872655,
0.870026, 0.86725, 0.864326, 0.861255, 0.858038, 0.854675, 0.851166, 0.847512, 0.843714,
0.839772, 0.835687, 0.831459, 0.827089, 0.822578, 0.817927, 0.813135, 0.808205, 0.803136,
0.797929, 0.792586, 0.787108, 0.781494, 0.775746, 0.769866, 0.763853, 0.75771, 0.751436,
0.745034, 0.738504, 0.731847, 0.725065, 0.718159, 0.71113, 0.703979, 0.696708, 0.689317,
0.681809, 0.674185, 0.666446, 0.658593, 0.650629, 0.642555, 0.634372, 0.626082, 0.617686,
0.609187, 0.600586, 0.591886, 0.583086, 0.574191, 0.565201, 0.556118, 0.546945, 0.537683,
0.528335, 0.518903, 0.509389, 0.499794, 0.490122, 0.480375, 0.470555, 0.460664, 0.450704,
0.440679, 0.430591, 0.420442, 0.410235, 0.399973, 0.389657, 0.379292, 0.36888, 0.358423,
0.347925 },

{0.9, 0.899924, 0.899694, 0.899312, 0.898777, 0.898089, 0.897248, 0.896255, 0.89511, 0.893812,
0.892362, 0.890761, 0.889007, 0.887103, 0.885048, 0.882842, 0.880485, 0.877979, 0.875323,
0.872517, 0.869563, 0.866461, 0.863211, 0.859813, 0.856269, 0.852578, 0.848742, 0.844761,
0.840635, 0.836366, 0.831954, 0.827399, 0.822703, 0.817865, 0.812888, 0.807772, 0.802517,
0.797125, 0.791597, 0.785932, 0.780134, 0.774201, 0.768136, 0.76194, 0.755613, 0.749157,
0.742572, 0.735861, 0.729024, 0.722063, 0.714979, 0.707773, 0.700446, 0.693, 0.685437,
0.677758, 0.669964, 0.662057, 0.654038, 0.64591, 0.637673, 0.62933, 0.620882, 0.612331,
0.603678, 0.594927, 0.586077, 0.577133, 0.568094, 0.558964, 0.549745, 0.540438, 0.531046,
0.52157, 0.512014, 0.502379, 0.492668, 0.482883, 0.473026, 0.4631, 0.453107, 0.44305, 0.432931,
0.422754, 0.41252, 0.402232, 0.391894, 0.381507, 0.371075, 0.3606, 0.350086 },

{0.905556, 0.905478, 0.905246, 0.90486, 0.904319, 0.903624, 0.902774, 0.90177, 0.900612,
0.899301, 0.897835, 0.896217, 0.894445, 0.89252, 0.890443, 0.888214, 0.885833, 0.8833,
0.880616, 0.877782, 0.874797, 0.871663, 0.868379, 0.864947, 0.861367, 0.857639, 0.853765,
0.849744, 0.845577, 0.841266, 0.836811, 0.832212, 0.827471, 0.822587, 0.817563, 0.812399,
0.807096, 0.801654, 0.796075, 0.79036, 0.78451, 0.778525, 0.772407, 0.766158, 0.759777,
0.753267, 0.746628, 0.739862, 0.73297, 0.725954, 0.718814, 0.711552, 0.70417, 0.696669,
0.689051, 0.681316, 0.673467, 0.665505, 0.657432, 0.64925, 0.64096, 0.632563, 0.624063,
0.61546, 0.606756, 0.597954, 0.589055, 0.580061, 0.570975, 0.561798, 0.552533, 0.543181,
0.533745, 0.524227, 0.514629, 0.504954, 0.495204, 0.485382, 0.475489, 0.465528, 0.455503,
0.445414, 0.435266, 0.42506, 0.4148, 0.404488, 0.394127, 0.383719, 0.373268, 0.362776, 0.352247
},

{0.911111, 0.911033, 0.910799, 0.910408, 0.909861, 0.909158, 0.908299, 0.907285, 0.906115,
0.904789, 0.903308, 0.901672, 0.899881, 0.897936, 0.895837, 0.893584, 0.891178, 0.888618,
0.885907, 0.883043, 0.880027, 0.876861, 0.873543, 0.870076, 0.86646, 0.862695, 0.858781,
0.85472, 0.850513, 0.846159, 0.84166, 0.837017, 0.83223, 0.827301, 0.822229, 0.817017,
0.811665, 0.806173, 0.800544, 0.794777, 0.788875, 0.782838, 0.776667, 0.770364, 0.763929,
0.757364, 0.750671, 0.74385, 0.736903, 0.729831, 0.722636, 0.715318, 0.707881, 0.700324,
0.69265, 0.68486, 0.676956, 0.66894, 0.660812, 0.652576, 0.644232, 0.635783, 0.62723, 0.618575,
0.60982, 0.600968, 0.592019, 0.582977, 0.573843, 0.564619, 0.555308, 0.545912, 0.536432,
0.526872, 0.517234, 0.507519, 0.497731, 0.487871, 0.477943, 0.467949, 0.457891, 0.447772,
0.437595, 0.427362, 0.417076, 0.40674, 0.396357, 0.385929, 0.37546, 0.364952, 0.354408 },

{0.916667, 0.916588, 0.916351, 0.915956, 0.915403, 0.914693, 0.913825, 0.912799, 0.911616,
0.910276, 0.908779, 0.907126, 0.905316, 0.90335, 0.901229, 0.898952, 0.89652, 0.893934,
0.891194, 0.8883, 0.885254, 0.882054, 0.878703, 0.875201, 0.871548, 0.867744, 0.863792,
0.859691, 0.855441, 0.851045, 0.846503, 0.841815, 0.836982, 0.832006, 0.826886, 0.821625,
0.816224, 0.810682, 0.805002, 0.799184, 0.793229, 0.787139, 0.780915, 0.774558, 0.768069,
0.761449, 0.754701, 0.747825, 0.740822, 0.733694, 0.726443, 0.71907, 0.711577, 0.703965,
0.696235, 0.68839, 0.680431, 0.672359, 0.664178, 0.655887, 0.64749, 0.638988, 0.630382,
0.621676, 0.61287, 0.603968, 0.59497, 0.585879, 0.576698, 0.567428, 0.558071, 0.548631,
0.539108, 0.529506, 0.519827, 0.510074, 0.500248, 0.490352, 0.480389, 0.470361, 0.460272,
0.450123, 0.439917, 0.429658, 0.419347, 0.408988, 0.398584, 0.388137, 0.37765, 0.367126,
0.356569 },

{0.922222, 0.922142, 0.921903, 0.921504, 0.920945, 0.920227, 0.919349, 0.918313, 0.917117,
0.915763, 0.91425, 0.912579, 0.910749, 0.908763, 0.906619, 0.904318, 0.901861, 0.899247,
0.896478, 0.893555, 0.890476, 0.887244, 0.883859, 0.88032, 0.87663, 0.872789, 0.868796,
0.864654, 0.860363, 0.855924, 0.851337, 0.846604, 0.841725, 0.836702, 0.831534, 0.826224,
0.820773, 0.81518, 0.809449, 0.803579, 0.797571, 0.791428, 0.78515, 0.778739, 0.772195,
0.765521, 0.758717, 0.751785, 0.744727, 0.737544, 0.730237, 0.722808, 0.715259, 0.70759,
0.699805, 0.691905, 0.68389, 0.675764, 0.667528, 0.659184, 0.650733, 0.642178, 0.63352,
0.624763, 0.615906, 0.606954, 0.597907, 0.588768, 0.57954, 0.570223, 0.560822, 0.551338,
0.541773, 0.532129, 0.52241, 0.512618, 0.502755, 0.492823, 0.482826, 0.472766, 0.462645,
0.452467, 0.442234, 0.431948, 0.421614, 0.411232, 0.400807, 0.390342, 0.379838, 0.3693, 0.35873
},

{0.927778, 0.927697, 0.927455, 0.927051, 0.926487, 0.925761, 0.924874, 0.923826, 0.922617,
0.921248, 0.919719, 0.91803, 0.916181, 0.914173, 0.912007, 0.909681, 0.907198, 0.904557,
0.90176, 0.898805, 0.895695, 0.89243, 0.889009, 0.885435, 0.881707, 0.877827, 0.873795,
0.869612, 0.865278, 0.860796, 0.856164, 0.851385, 0.84646, 0.841389, 0.836173, 0.830813,
0.825312, 0.819668, 0.813885, 0.807962, 0.801902, 0.795705, 0.789373, 0.782908, 0.776309,
0.769579, 0.76272, 0.755733, 0.748618, 0.741379, 0.734016, 0.726531, 0.718925, 0.711201,
0.703361, 0.695404, 0.687335, 0.679154, 0.670864, 0.662465, 0.653961, 0.645353, 0.636644,
0.627835, 0.618928, 0.609926, 0.60083, 0.591643, 0.582368, 0.573006, 0.56356, 0.554032,
0.544425, 0.534741, 0.524983, 0.515152, 0.505252, 0.495286, 0.485255, 0.475163, 0.465012,
0.454805, 0.444544, 0.434234, 0.423876, 0.413473, 0.403028, 0.392544, 0.382025, 0.371473,
0.360891 },

{0.933333, 0.933252, 0.933007, 0.932599, 0.932028, 0.931294, 0.930398, 0.929339, 0.928117,
0.926733, 0.925187, 0.92348, 0.921612, 0.919582, 0.917393, 0.915043, 0.912533, 0.909865,
0.907038, 0.904052, 0.90091, 0.897611, 0.894155, 0.890545, 0.886779, 0.88286, 0.878787,
0.874563, 0.870186, 0.86566, 0.860983, 0.856158, 0.851186, 0.846066, 0.840802, 0.835393,
0.82984, 0.824145, 0.81831, 0.812335, 0.806221, 0.799971, 0.793584, 0.787063, 0.78041,
0.773625, 0.766709, 0.759666, 0.752495, 0.7452, 0.73778, 0.730239, 0.722578, 0.714798,
0.706901, 0.698889, 0.690765, 0.682529, 0.674184, 0.665732, 0.657174, 0.648514, 0.639752,
0.630892, 0.621935, 0.612883, 0.603739, 0.594505, 0.585183, 0.575776, 0.566286, 0.556715,
0.547066, 0.537341, 0.527544, 0.517676, 0.50774, 0.497739, 0.487675, 0.477551, 0.467371,
0.457135, 0.446849, 0.436514, 0.426133, 0.415709, 0.405245, 0.394745, 0.38421, 0.373645,
0.363052 },

{0.938889, 0.938806, 0.938559, 0.938147, 0.93757, 0.936828, 0.935921, 0.934851, 0.933616,
0.932217, 0.930655, 0.928929, 0.927041, 0.92499, 0.922776, 0.920402, 0.917866, 0.915169,
0.912312, 0.909296, 0.906121, 0.902787, 0.899297, 0.895649, 0.891845, 0.887886, 0.883773,
0.879506, 0.875087, 0.870516, 0.865794, 0.860923, 0.855903, 0.850735, 0.845421, 0.839962,
0.834358, 0.828612, 0.822724, 0.816695, 0.810528, 0.804223, 0.797782, 0.791206, 0.784497,
0.777656, 0.770685, 0.763585, 0.756358, 0.749006, 0.74153, 0.733932, 0.726214, 0.718378,
0.710426, 0.702358, 0.694179, 0.685888, 0.677489, 0.668983, 0.660372, 0.651659, 0.642846,
0.633935, 0.624927, 0.615826, 0.606634, 0.597353, 0.587985, 0.578532, 0.568998, 0.559385,
0.549695, 0.53993, 0.530094, 0.520189, 0.510218, 0.500182, 0.490086, 0.479932, 0.469722,
0.459459, 0.449147, 0.438788, 0.428385, 0.417942, 0.40746, 0.396943, 0.386394, 0.375817,
0.365213 },

{0.944444, 0.944361, 0.944111, 0.943694, 0.943111, 0.942361, 0.941445, 0.940362, 0.939114,
0.9377, 0.936121, 0.934377, 0.932468, 0.930395, 0.928158, 0.925758, 0.923195, 0.92047,
0.917583, 0.914536, 0.911328, 0.90796, 0.904433, 0.900748, 0.896906, 0.892907, 0.888753,
0.884443, 0.87998, 0.875365, 0.870597, 0.865679, 0.860611, 0.855394, 0.85003, 0.84452,
0.838865, 0.833067, 0.827126, 0.821044, 0.814823, 0.808463, 0.801967, 0.795336, 0.788571,
0.781674, 0.774646, 0.76749, 0.760206, 0.752797, 0.745265, 0.73761, 0.729836, 0.721944,
0.713935, 0.705812, 0.697577, 0.689232, 0.680778, 0.672218, 0.663555, 0.654789, 0.645925,
0.636962, 0.627905, 0.618755, 0.609515, 0.600186, 0.590773, 0.581276, 0.571698, 0.562043,
0.552312, 0.542508, 0.532634, 0.522692, 0.512685, 0.502617, 0.492489, 0.482304, 0.472066,
0.461777, 0.45144, 0.441058, 0.430633, 0.42017, 0.409671, 0.399138, 0.388576, 0.377987,
0.367374 },

{0.95, 0.949916, 0.949663, 0.949241, 0.948652, 0.947894, 0.946967, 0.945873, 0.944611,
0.943182, 0.941586, 0.939823, 0.937894, 0.935798, 0.933538, 0.931112, 0.928522, 0.925768,
0.922851, 0.919772, 0.91653, 0.913128, 0.909565, 0.905842, 0.901961, 0.897922, 0.893726,
0.889373, 0.884866, 0.880205, 0.875392, 0.870426, 0.86531, 0.860044, 0.85463, 0.849069,
0.843362, 0.837511, 0.831517, 0.825381, 0.819105, 0.812691, 0.806139, 0.799452, 0.792631,
0.785677, 0.778593, 0.77138, 0.764039, 0.756574, 0.748984, 0.741273, 0.733442, 0.725493,
0.717429, 0.70925, 0.70096, 0.69256, 0.684052, 0.675438, 0.666722, 0.657904, 0.648988,
0.639975, 0.630868, 0.621669, 0.612381, 0.603006, 0.593547, 0.584005, 0.574385, 0.564688,
0.554916, 0.545073, 0.535162, 0.525184, 0.515143, 0.505042, 0.494882, 0.484668, 0.474402,
0.464087, 0.453726, 0.443321, 0.432877, 0.422395, 0.411879, 0.401332, 0.390757, 0.380157,
0.369535 },

{0.955556, 0.95547, 0.955215, 0.954789, 0.954192, 0.953426, 0.95249, 0.951384, 0.950108,
0.948664, 0.94705, 0.945268, 0.943318, 0.9412, 0.938915, 0.936464, 0.933846, 0.931063,
0.928116, 0.925004, 0.921728, 0.918291, 0.914691, 0.91093, 0.90701, 0.90293, 0.898692,
0.894296, 0.889745, 0.885038, 0.880178, 0.875164, 0.869999, 0.864683, 0.859219, 0.853606,
0.847847, 0.841943, 0.835895, 0.829705, 0.823375, 0.816905, 0.810297, 0.803554, 0.796677,
0.789666, 0.782525, 0.775255, 0.767858, 0.760335, 0.752688, 0.74492, 0.737033, 0.729027,
0.720907, 0.712672, 0.704326, 0.695871, 0.687309, 0.678642, 0.669873, 0.661003, 0.652035,
0.642972, 0.633816, 0.624568, 0.615233, 0.605811, 0.596307, 0.586722, 0.577059, 0.56732,
0.557509, 0.547627, 0.537679, 0.527666, 0.517591, 0.507457, 0.497267, 0.487024, 0.476731,
0.466391, 0.456006, 0.44558, 0.435115, 0.424615, 0.414084, 0.403523, 0.392936, 0.382326,
0.371696 },

{0.961111, 0.961025, 0.960767, 0.960336, 0.959733, 0.958958, 0.958012, 0.956894, 0.955604,
0.954144, 0.952513, 0.950711, 0.94874, 0.9466, 0.94429, 0.941813, 0.939167, 0.936355, 0.933376,
0.930232, 0.926922, 0.923449, 0.919812, 0.916013, 0.912053, 0.907931, 0.903651, 0.899212,
0.894615, 0.889863, 0.884955, 0.879893, 0.874679, 0.869313, 0.863797, 0.858133, 0.852321,
0.846364, 0.840262, 0.834017, 0.827631, 0.821106, 0.814442, 0.807643, 0.800708, 0.793641,
0.786443, 0.779115, 0.77166, 0.76408, 0.756377, 0.748552, 0.740607, 0.732545, 0.724368,
0.716078, 0.707677, 0.699167, 0.690551, 0.68183, 0.673008, 0.664086, 0.655067, 0.645954,
0.636748, 0.627453, 0.61807, 0.608603, 0.599053, 0.589425, 0.579719, 0.56994, 0.560089,
0.55017, 0.540185, 0.530136, 0.520028, 0.509863, 0.499643, 0.489372, 0.479052, 0.468687,
0.45828, 0.447833, 0.437349, 0.426832, 0.416285, 0.405711, 0.395113, 0.384494, 0.373857 },

{0.966667, 0.96658, 0.966318, 0.965883, 0.965273, 0.96449, 0.963533, 0.962403, 0.961099,
0.959623, 0.957974, 0.956153, 0.954161, 0.951997, 0.949663, 0.947159, 0.944486, 0.941644,
0.938633, 0.935456, 0.932112, 0.928603, 0.924928, 0.92109, 0.917089, 0.912927, 0.908603,
0.90412, 0.899478, 0.894679, 0.889723, 0.884613, 0.879349, 0.873933, 0.868365, 0.862649,
0.856784, 0.850773, 0.844616, 0.838317, 0.831875, 0.825294, 0.818574, 0.811717, 0.804725,
0.797601, 0.790345, 0.78296, 0.775448, 0.76781, 0.760049, 0.752167, 0.744165, 0.736047,
0.727814, 0.719468, 0.711011, 0.702446, 0.693776, 0.685002, 0.676127, 0.667153, 0.658084,
0.64892, 0.639665, 0.630322, 0.620892, 0.611379, 0.601785, 0.592114, 0.582366, 0.572546,
0.562657, 0.5527, 0.542679, 0.532597, 0.522456, 0.512259, 0.50201, 0.491711, 0.481366,
0.470977, 0.460547, 0.45008, 0.439578, 0.429045, 0.418484, 0.407897, 0.397289, 0.386661,
0.376018 },

{0.972222, 0.972134, 0.97187, 0.97143, 0.970814, 0.970022, 0.969054, 0.967912, 0.966594,
0.965101, 0.963435, 0.961594, 0.95958, 0.957393, 0.955034, 0.952503, 0.949801, 0.946929,
0.943887, 0.940676, 0.937297, 0.933751, 0.930039, 0.926162, 0.92212, 0.917915, 0.913548,
0.90902, 0.904333, 0.899486, 0.894483, 0.889323, 0.884009, 0.878542, 0.872923, 0.867153,
0.861235, 0.855169, 0.848958, 0.842603, 0.836105, 0.829467, 0.822691, 0.815777, 0.808728,
0.801546, 0.794232, 0.78679, 0.77922, 0.771524, 0.763706, 0.755766, 0.747707, 0.739532,
0.731242, 0.72284, 0.714329, 0.705709, 0.696985, 0.688157, 0.67923, 0.670204, 0.661084,
0.65187, 0.642567, 0.633176, 0.623699, 0.614141, 0.604503, 0.594789, 0.585, 0.57514, 0.565212,
0.555218, 0.545162, 0.535046, 0.524873, 0.514646, 0.504368, 0.494043, 0.483672, 0.47326,
0.462809, 0.452322, 0.441803, 0.431254, 0.420679, 0.410081, 0.399463, 0.388828, 0.378179 },

{0.977778, 0.977689, 0.977422, 0.976977, 0.976354, 0.975553, 0.974575, 0.97342, 0.972087,
0.970579, 0.968894, 0.967033, 0.964997, 0.962787, 0.960402, 0.957844, 0.955113, 0.95221,
0.949136, 0.945892, 0.942478, 0.938895, 0.935144, 0.931227, 0.927144, 0.922897, 0.918486,
0.913913, 0.909179, 0.904285, 0.899233, 0.894024, 0.888659, 0.88314, 0.877469, 0.871646,
0.865674, 0.859554, 0.853287, 0.846876, 0.840322, 0.833627, 0.826794, 0.819822, 0.812716,
0.805476, 0.798104, 0.790603, 0.782975, 0.775222, 0.767346, 0.759349, 0.751233, 0.743001,
0.734654, 0.726197, 0.717629, 0.708955, 0.700177, 0.691296, 0.682316, 0.673239, 0.664068,
0.654805, 0.645453, 0.636014, 0.626492, 0.616888, 0.607207, 0.59745, 0.58762, 0.577721,
0.567755, 0.557725, 0.547633, 0.537484, 0.52728, 0.517023, 0.506717, 0.496365, 0.48597,
0.475535, 0.465064, 0.454558, 0.444022, 0.433459, 0.422871, 0.412262, 0.401635, 0.390993,
0.38034 },

{0.983333, 0.983243, 0.982973, 0.982523, 0.981893, 0.981084, 0.980095, 0.978927, 0.97758,
0.976055, 0.974352, 0.972471, 0.970413, 0.968178, 0.965768, 0.963182, 0.960422, 0.957489,
0.954382, 0.951103, 0.947653, 0.944033, 0.940244, 0.936286, 0.932162, 0.927872, 0.923416,
0.918798, 0.914017, 0.909075, 0.903974, 0.898715, 0.893299, 0.887728, 0.882004, 0.876127,
0.870101, 0.863925, 0.857603, 0.851136, 0.844525, 0.837773, 0.830882, 0.823853, 0.816688,
0.80939, 0.80196, 0.794401, 0.786715, 0.778903, 0.770969, 0.762914, 0.754741, 0.746452,
0.738049, 0.729536, 0.720913, 0.712184, 0.703352, 0.694418, 0.685386, 0.676257, 0.667036,
0.657723, 0.648323, 0.638837, 0.629269, 0.619621, 0.609896, 0.600097, 0.590227, 0.580289,
0.570285, 0.560219, 0.550093, 0.539911, 0.529676, 0.51939, 0.509057, 0.49868, 0.488261,
0.477804, 0.467313, 0.456789, 0.446237, 0.43566, 0.42506, 0.414441, 0.403806, 0.393158,
0.382501 },

{0.988889, 0.988798, 0.988525, 0.98807, 0.987433, 0.986615, 0.985615, 0.984434, 0.983072,
0.98153, 0.979808, 0.977907, 0.975826, 0.973568, 0.971131, 0.968518, 0.965728, 0.962763,
0.959624, 0.95631, 0.952824, 0.949166, 0.945338, 0.94134, 0.937173, 0.932839, 0.928339,
0.923675, 0.918847, 0.913856, 0.908706, 0.903396, 0.897929, 0.892305, 0.886527, 0.880597,
0.874515, 0.868284, 0.861906, 0.855382, 0.848714, 0.841905, 0.834955, 0.827868, 0.820645,
0.813289, 0.8058, 0.798183, 0.790438, 0.782568, 0.774576, 0.766463, 0.758233, 0.749886,
0.741427, 0.732858, 0.72418, 0.715396, 0.70651, 0.697523, 0.688438, 0.679259, 0.669987,
0.660625, 0.651177, 0.641644, 0.63203, 0.622338, 0.61257, 0.60273, 0.59282, 0.582843, 0.572802,
0.562701, 0.552542, 0.542328, 0.532062, 0.521748, 0.511388, 0.500985, 0.490544, 0.480066,
0.469555, 0.459015, 0.448447, 0.437856, 0.427245, 0.416617, 0.405975, 0.395322, 0.384662 },

{0.994444, 0.994352, 0.994076, 0.993616, 0.992972, 0.992145, 0.991134, 0.98994, 0.988563,
0.987004, 0.985263, 0.983341, 0.981238, 0.978955, 0.976492, 0.97385, 0.971031, 0.968034,
0.964861, 0.961513, 0.95799, 0.954294, 0.950426, 0.946387, 0.942177, 0.9378, 0.933254,
0.928543, 0.923667, 0.918628, 0.913428, 0.908067, 0.902547, 0.896871, 0.891039, 0.885054,
0.878917, 0.87263, 0.866195, 0.859614, 0.852889, 0.846022, 0.839014, 0.831868, 0.824587,
0.817171, 0.809624, 0.801948, 0.794144, 0.786216, 0.778165, 0.769995, 0.761707, 0.753303,
0.744788, 0.736162, 0.727429, 0.718591, 0.70965, 0.700611, 0.691474, 0.682243, 0.672921,
0.663511, 0.654015, 0.644435, 0.634776, 0.62504, 0.61523, 0.605349, 0.595399, 0.585384,
0.575307, 0.565171, 0.554978, 0.544733, 0.534438, 0.524095, 0.513709, 0.503283, 0.492819,
0.482321, 0.471792, 0.461234, 0.450653, 0.440049, 0.429428, 0.418791, 0.408143, 0.397486,
0.386824 },

{1, 0.999907, 0.999628, 0.999163, 0.998512, 0.997675, 0.996653, 0.995446, 0.994054, 0.992477,
0.990717, 0.988774, 0.986648, 0.98434, 0.98185, 0.97918, 0.97633, 0.973302, 0.970095, 0.966711,
0.963151, 0.959417, 0.955508, 0.951427, 0.947175, 0.942753, 0.938162, 0.933403, 0.928479,
0.923391, 0.918139, 0.912727, 0.907155, 0.901425, 0.895539, 0.889499, 0.883306, 0.876963,
0.870471, 0.863833, 0.85705, 0.850124, 0.843058, 0.835853, 0.828512, 0.821038, 0.813432,
0.805696, 0.797834, 0.789847, 0.781738, 0.773509, 0.765163, 0.756703, 0.74813, 0.739449,
0.73066, 0.721767, 0.712773, 0.703681, 0.694492, 0.685211, 0.675839, 0.66638, 0.656836,
0.647211, 0.637507, 0.627727, 0.617875, 0.607953, 0.597964, 0.587912, 0.577799, 0.567628,
0.557403, 0.547127, 0.536803, 0.526433, 0.516022, 0.505572, 0.495086, 0.484568, 0.474021,
0.463449, 0.452853, 0.442238, 0.431607, 0.420963, 0.410309, 0.399648, 0.388985 }

};

static const float WinkelY[181][91] = {

{0, 0.006789, 0.013578, 0.020367, 0.027156, 0.033945, 0.040734, 0.047523, 0.054312, 0.061102,
0.067891, 0.07468, 0.081469, 0.088258, 0.095047, 0.101836, 0.108625, 0.115414, 0.122203,
0.128992, 0.135781, 0.14257, 0.149359, 0.156148, 0.162937, 0.169727, 0.176516, 0.183305,
0.190094, 0.196883, 0.203672, 0.210461, 0.21725, 0.224039, 0.230828, 0.237617, 0.244406,
0.251195, 0.257984, 0.264773, 0.271562, 0.278351, 0.285141, 0.29193, 0.298719, 0.305508,
0.312297, 0.319086, 0.325875, 0.332664, 0.339453, 0.346242, 0.353031, 0.35982, 0.366609,
0.373398, 0.380187, 0.386976, 0.393766, 0.400555, 0.407344, 0.414133, 0.420922, 0.427711,
0.4345, 0.441289, 0.448078, 0.454867, 0.461656, 0.468445, 0.475234, 0.482023, 0.488812,
0.495601, 0.50239, 0.50918, 0.515969, 0.522758, 0.529547, 0.536336, 0.543125, 0.549914,
0.556703, 0.563492, 0.570281, 0.57707, 0.583859, 0.590648, 0.597437, 0.604226, 0.611015 },

{0, 0.006789, 0.013578, 0.020367, 0.027156, 0.033946, 0.040735, 0.047524, 0.054313, 0.061102,
0.067891, 0.07468, 0.081469, 0.088258, 0.095047, 0.101837, 0.108626, 0.115415, 0.122204,
0.128993, 0.135782, 0.142571, 0.14936, 0.156149, 0.162938, 0.169728, 0.176517, 0.183306,
0.190095, 0.196884, 0.203673, 0.210462, 0.217251, 0.22404, 0.230829, 0.237618, 0.244408,
0.251197, 0.257986, 0.264775, 0.271564, 0.278353, 0.285142, 0.291931, 0.29872, 0.305509,
0.312298, 0.319087, 0.325877, 0.332666, 0.339455, 0.346244, 0.353033, 0.359822, 0.366611,
0.3734, 0.380189, 0.386978, 0.393767, 0.400556, 0.407345, 0.414134, 0.420923, 0.427712,
0.434502, 0.441291, 0.44808, 0.454869, 0.461658, 0.468447, 0.475236, 0.482025, 0.488814,
0.495603, 0.502392, 0.509181, 0.51597, 0.522759, 0.529548, 0.536337, 0.543126, 0.549915,
0.556704, 0.563493, 0.570282, 0.577071, 0.58386, 0.590649, 0.597438, 0.604227, 0.611015 },

{0, 0.006789, 0.013578, 0.020368, 0.027157, 0.033946, 0.040735, 0.047525, 0.054314, 0.061103,
0.067892, 0.074682, 0.081471, 0.08826, 0.095049, 0.101838, 0.108628, 0.115417, 0.122206,
0.128995, 0.135785, 0.142574, 0.149363, 0.156152, 0.162941, 0.169731, 0.17652, 0.183309,
0.190098, 0.196887, 0.203677, 0.210466, 0.217255, 0.224044, 0.230833, 0.237623, 0.244412,
0.251201, 0.25799, 0.264779, 0.271568, 0.278358, 0.285147, 0.291936, 0.298725, 0.305514,
0.312303, 0.319092, 0.325881, 0.332671, 0.33946, 0.346249, 0.353038, 0.359827, 0.366616,
0.373405, 0.380194, 0.386983, 0.393772, 0.400561, 0.40735, 0.414139, 0.420928, 0.427717,
0.434506, 0.441295, 0.448084, 0.454873, 0.461662, 0.468451, 0.47524, 0.482029, 0.488818,
0.495607, 0.502396, 0.509185, 0.515974, 0.522762, 0.529551, 0.53634, 0.543129, 0.549918,
0.556706, 0.563495, 0.570284, 0.577072, 0.583861, 0.59065, 0.597438, 0.604227, 0.611015 },

{0, 0.006789, 0.013579, 0.020368, 0.027158, 0.033947, 0.040737, 0.047526, 0.054316, 0.061105,
0.067894, 0.074684, 0.081473, 0.088263, 0.095052, 0.101842, 0.108631, 0.11542, 0.12221,
0.128999, 0.135789, 0.142578, 0.149368, 0.156157, 0.162946, 0.169736, 0.176525, 0.183314,
0.190104, 0.196893, 0.203683, 0.210472, 0.217261, 0.224051, 0.23084, 0.237629, 0.244419,
0.251208, 0.257997, 0.264786, 0.271576, 0.278365, 0.285154, 0.291944, 0.298733, 0.305522,
0.312311, 0.3191, 0.32589, 0.332679, 0.339468, 0.346257, 0.353046, 0.359835, 0.366625,
0.373414, 0.380203, 0.386992, 0.393781, 0.40057, 0.407359, 0.414148, 0.420937, 0.427726,
0.434515, 0.441304, 0.448092, 0.454881, 0.46167, 0.468459, 0.475248, 0.482036, 0.488825,
0.495614, 0.502403, 0.509191, 0.51598, 0.522768, 0.529557, 0.536345, 0.543134, 0.549922,
0.55671, 0.563499, 0.570287, 0.577075, 0.583863, 0.590652, 0.59744, 0.604228, 0.611015 },

{0, 0.00679, 0.01358, 0.020369, 0.027159, 0.033949, 0.040738, 0.047528, 0.054318, 0.061108,
0.067897, 0.074687, 0.081477, 0.088267, 0.095056, 0.101846, 0.108636, 0.115425, 0.122215,
0.129005, 0.135795, 0.142584, 0.149374, 0.156164, 0.162953, 0.169743, 0.176532, 0.183322,
0.190112, 0.196901, 0.203691, 0.210481, 0.21727, 0.22406, 0.230849, 0.237639, 0.244428,
0.251218, 0.258007, 0.264797, 0.271586, 0.278376, 0.285165, 0.291954, 0.298744, 0.305533,
0.312323, 0.319112, 0.325901, 0.33269, 0.33948, 0.346269, 0.353058, 0.359847, 0.366636,
0.373426, 0.380215, 0.387004, 0.393793, 0.400582, 0.407371, 0.41416, 0.420949, 0.427737,
0.434526, 0.441315, 0.448104, 0.454892, 0.461681, 0.46847, 0.475258, 0.482047, 0.488835,
0.495624, 0.502412, 0.5092, 0.515988, 0.522777, 0.529565, 0.536353, 0.543141, 0.549928,
0.556716, 0.563504, 0.570292, 0.577079, 0.583867, 0.590654, 0.597441, 0.604228, 0.611015 },

{0, 0.00679, 0.01358, 0.02037, 0.027161, 0.033951, 0.040741, 0.047531, 0.054321, 0.061111,
0.067901, 0.074691, 0.081482, 0.088272, 0.095062, 0.101852, 0.108642, 0.115432, 0.122222,
0.129012, 0.135802, 0.142592, 0.149382, 0.156172, 0.162962, 0.169752, 0.176542, 0.183332,
0.190122, 0.196912, 0.203702, 0.210492, 0.217281, 0.224071, 0.230861, 0.237651, 0.244441,
0.25123, 0.25802, 0.26481, 0.2716, 0.278389, 0.285179, 0.291968, 0.298758, 0.305547, 0.312337,
0.319126, 0.325916, 0.332705, 0.339495, 0.346284, 0.353073, 0.359862, 0.366652, 0.373441,
0.38023, 0.387019, 0.393808, 0.400597, 0.407386, 0.414175, 0.420964, 0.427752, 0.434541,
0.44133, 0.448118, 0.454907, 0.461695, 0.468483, 0.475272, 0.48206, 0.488848, 0.495636,
0.502424, 0.509212, 0.516, 0.522787, 0.529575, 0.536362, 0.543149, 0.549937, 0.556724,
0.563511, 0.570298, 0.577084, 0.583871, 0.590657, 0.597443, 0.60423, 0.611015 },

{0, 0.006791, 0.013581, 0.020372, 0.027162, 0.033953, 0.040744, 0.047534, 0.054325, 0.061115,
0.067906, 0.074697, 0.081487, 0.088278, 0.095068, 0.101859, 0.108649, 0.11544, 0.12223,
0.129021, 0.135811, 0.142602, 0.149392, 0.156183, 0.162973, 0.169763, 0.176554, 0.183344,
0.190134, 0.196925, 0.203715, 0.210505, 0.217295, 0.224085, 0.230876, 0.237666, 0.244456,
0.251246, 0.258036, 0.264826, 0.271616, 0.278406, 0.285196, 0.291985, 0.298775, 0.305565,
0.312355, 0.319144, 0.325934, 0.332723, 0.339513, 0.346302, 0.353092, 0.359881, 0.36667,
0.37346, 0.380249, 0.387038, 0.393827, 0.400616, 0.407405, 0.414193, 0.420982, 0.427771,
0.434559, 0.441348, 0.448136, 0.454924, 0.461712, 0.4685, 0.475288, 0.482076, 0.488864,
0.495651, 0.502439, 0.509226, 0.516013, 0.5228, 0.529587, 0.536374, 0.54316, 0.549947,
0.556733, 0.563519, 0.570305, 0.57709, 0.583876, 0.590661, 0.597446, 0.604231, 0.611015 },

{0, 0.006791, 0.013582, 0.020374, 0.027165, 0.033956, 0.040747, 0.047538, 0.054329, 0.06112,
0.067912, 0.074703, 0.081494, 0.088285, 0.095076, 0.101867, 0.108658, 0.115449, 0.12224,
0.129031, 0.135822, 0.142613, 0.149404, 0.156195, 0.162986, 0.169777, 0.176567, 0.183358,
0.190149, 0.19694, 0.20373, 0.210521, 0.217312, 0.224102, 0.230893, 0.237683, 0.244474,
0.251264, 0.258055, 0.264845, 0.271635, 0.278425, 0.285215, 0.292006, 0.298796, 0.305586,
0.312376, 0.319165, 0.325955, 0.332745, 0.339535, 0.346324, 0.353114, 0.359903, 0.366692,
0.373482, 0.380271, 0.38706, 0.393849, 0.400638, 0.407427, 0.414215, 0.421004, 0.427792,
0.43458, 0.441369, 0.448157, 0.454945, 0.461732, 0.46852, 0.475308, 0.482095, 0.488882,
0.495669, 0.502456, 0.509243, 0.516029, 0.522815, 0.529602, 0.536387, 0.543173, 0.549959,
0.556744, 0.563529, 0.570313, 0.577098, 0.583882, 0.590666, 0.597449, 0.604233, 0.611015 },

{0, 0.006792, 0.013584, 0.020375, 0.027167, 0.033959, 0.040751, 0.047543, 0.054334, 0.061126,
0.067918, 0.07471, 0.081501, 0.088293, 0.095085, 0.101877, 0.108668, 0.11546, 0.122251,
0.129043, 0.135835, 0.142626, 0.149418, 0.156209, 0.163, 0.169792, 0.176583, 0.183375,
0.190166, 0.196957, 0.203748, 0.210539, 0.217331, 0.224122, 0.230913, 0.237704, 0.244494,
0.251285, 0.258076, 0.264867, 0.271657, 0.278448, 0.285238, 0.292029, 0.298819, 0.305609,
0.3124, 0.31919, 0.32598, 0.33277, 0.33956, 0.346349, 0.353139, 0.359928, 0.366718, 0.373507,
0.380296, 0.387085, 0.393874, 0.400663, 0.407452, 0.41424, 0.421029, 0.427817, 0.434605,
0.441393, 0.448181, 0.454968, 0.461756, 0.468543, 0.47533, 0.482117, 0.488904, 0.49569,
0.502476, 0.509262, 0.516048, 0.522833, 0.529618, 0.536403, 0.543188, 0.549972, 0.556756,
0.56354, 0.570323, 0.577106, 0.583889, 0.590671, 0.597453, 0.604234, 0.611015 },

{0, 0.006793, 0.013585, 0.020378, 0.02717, 0.033963, 0.040755, 0.047548, 0.05434, 0.061133,
0.067925, 0.074718, 0.08151, 0.088303, 0.095095, 0.101887, 0.10868, 0.115472, 0.122264,
0.129057, 0.135849, 0.142641, 0.149433, 0.156225, 0.163017, 0.169809, 0.176601, 0.183393,
0.190185, 0.196977, 0.203769, 0.21056, 0.217352, 0.224144, 0.230935, 0.237727, 0.244518,
0.251309, 0.2581, 0.264892, 0.271683, 0.278474, 0.285264, 0.292055, 0.298846, 0.305637,
0.312427, 0.319217, 0.326008, 0.332798, 0.339588, 0.346378, 0.353168, 0.359957, 0.366747,
0.373536, 0.380325, 0.387114, 0.393903, 0.400692, 0.407481, 0.414269, 0.421057, 0.427845,
0.434633, 0.441421, 0.448208, 0.454995, 0.461782, 0.468569, 0.475356, 0.482142, 0.488928,
0.495713, 0.502499, 0.509284, 0.516069, 0.522853, 0.529637, 0.536421, 0.543205, 0.549988,
0.55677, 0.563553, 0.570334, 0.577116, 0.583897, 0.590677, 0.597457, 0.604237, 0.611015 },

{0, 0.006793, 0.013587, 0.02038, 0.027173, 0.033967, 0.04076, 0.047553, 0.054347, 0.06114,
0.067933, 0.074727, 0.08152, 0.088313, 0.095106, 0.101899, 0.108693, 0.115486, 0.122279,
0.129072, 0.135865, 0.142658, 0.14945, 0.156243, 0.163036, 0.169829, 0.176621, 0.183414,
0.190206, 0.196999, 0.203791, 0.210584, 0.217376, 0.224168, 0.23096, 0.237752, 0.244544,
0.251336, 0.258128, 0.264919, 0.271711, 0.278502, 0.285294, 0.292085, 0.298876, 0.305667,
0.312458, 0.319248, 0.326039, 0.332829, 0.33962, 0.34641, 0.3532, 0.359989, 0.366779, 0.373568,
0.380358, 0.387147, 0.393936, 0.400724, 0.407513, 0.414301, 0.421089, 0.427877, 0.434664,
0.441452, 0.448239, 0.455025, 0.461812, 0.468598, 0.475384, 0.48217, 0.488955, 0.49574,
0.502524, 0.509308, 0.516092, 0.522876, 0.529659, 0.536441, 0.543223, 0.550005, 0.556786,
0.563567, 0.570347, 0.577127, 0.583906, 0.590684, 0.597462, 0.604239, 0.611015 },

{0, 0.006794, 0.013589, 0.020383, 0.027177, 0.033971, 0.040766, 0.04756, 0.054354, 0.061148,
0.067942, 0.074737, 0.081531, 0.088325, 0.095119, 0.101913, 0.108707, 0.115501, 0.122295,
0.129088, 0.135882, 0.142676, 0.14947, 0.156263, 0.163057, 0.16985, 0.176644, 0.183437,
0.19023, 0.197023, 0.203816, 0.210609, 0.217402, 0.224195, 0.230988, 0.237781, 0.244573,
0.251365, 0.258158, 0.26495, 0.271742, 0.278534, 0.285326, 0.292117, 0.298909, 0.3057,
0.312491, 0.319282, 0.326073, 0.332864, 0.339654, 0.346445, 0.353235, 0.360025, 0.366815,
0.373604, 0.380393, 0.387183, 0.393971, 0.40076, 0.407548, 0.414336, 0.421124, 0.427912,
0.434699, 0.441486, 0.448272, 0.455059, 0.461845, 0.46863, 0.475415, 0.4822, 0.488985,
0.495769, 0.502552, 0.509335, 0.516118, 0.5229, 0.529682, 0.536463, 0.543244, 0.550024,
0.556804, 0.563582, 0.570361, 0.577138, 0.583915, 0.590691, 0.597467, 0.604242, 0.611015 },

{0, 0.006795, 0.013591, 0.020386, 0.027181, 0.033976, 0.040772, 0.047567, 0.054362, 0.061157,
0.067952, 0.074747, 0.081542, 0.088337, 0.095132, 0.101927, 0.108722, 0.115517, 0.122312,
0.129107, 0.135901, 0.142696, 0.149491, 0.156285, 0.163079, 0.169874, 0.176668, 0.183462,
0.190256, 0.19705, 0.203844, 0.210638, 0.217431, 0.224225, 0.231018, 0.237812, 0.244605,
0.251398, 0.258191, 0.264984, 0.271776, 0.278569, 0.285361, 0.292153, 0.298945, 0.305737,
0.312528, 0.31932, 0.326111, 0.332902, 0.339693, 0.346483, 0.353274, 0.360064, 0.366854,
0.373643, 0.380433, 0.387222, 0.394011, 0.400799, 0.407587, 0.414375, 0.421163, 0.42795,
0.434737, 0.441523, 0.448309, 0.455095, 0.46188, 0.468665, 0.47545, 0.482234, 0.489017, 0.4958,
0.502583, 0.509365, 0.516147, 0.522927, 0.529708, 0.536488, 0.543267, 0.550045, 0.556823,
0.5636, 0.570376, 0.577151, 0.583926, 0.5907, 0.597473, 0.604245, 0.611015 },

{0, 0.006796, 0.013593, 0.020389, 0.027185, 0.033982, 0.040778, 0.047574, 0.054371, 0.061167,
0.067963, 0.074759, 0.081555, 0.088351, 0.095147, 0.101943, 0.108739, 0.115535, 0.122331,
0.129127, 0.135922, 0.142718, 0.149513, 0.156309, 0.163104, 0.169899, 0.176694, 0.183489,
0.190284, 0.197079, 0.203874, 0.210668, 0.217463, 0.224257, 0.231051, 0.237845, 0.244639,
0.251433, 0.258227, 0.26502, 0.271813, 0.278606, 0.285399, 0.292192, 0.298984, 0.305777,
0.312569, 0.31936, 0.326152, 0.332943, 0.339734, 0.346525, 0.353316, 0.360106, 0.366896,
0.373686, 0.380475, 0.387264, 0.394053, 0.400841, 0.40763, 0.414417, 0.421205, 0.427991,
0.434778, 0.441564, 0.44835, 0.455135, 0.461919, 0.468704, 0.475487, 0.48227, 0.489053,
0.495835, 0.502616, 0.509397, 0.516177, 0.522957, 0.529736, 0.536514, 0.543291, 0.550068,
0.556843, 0.563618, 0.570392, 0.577165, 0.583938, 0.590709, 0.597479, 0.604248, 0.611015 },

{0, 0.006798, 0.013595, 0.020393, 0.02719, 0.033988, 0.040785, 0.047582, 0.05438, 0.061177,
0.067975, 0.074772, 0.081569, 0.088366, 0.095163, 0.10196, 0.108757, 0.115554, 0.122351,
0.129148, 0.135945, 0.142741, 0.149538, 0.156334, 0.163131, 0.169927, 0.176723, 0.183519,
0.190315, 0.197111, 0.203906, 0.210702, 0.217497, 0.224292, 0.231087, 0.237882, 0.244677,
0.251471, 0.258265, 0.26506, 0.271853, 0.278647, 0.285441, 0.292234, 0.299027, 0.30582,
0.312612, 0.319404, 0.326196, 0.332988, 0.339779, 0.346571, 0.353361, 0.360152, 0.366942,
0.373732, 0.380521, 0.38731, 0.394099, 0.400887, 0.407675, 0.414463, 0.42125, 0.428036,
0.434822, 0.441608, 0.448393, 0.455178, 0.461961, 0.468745, 0.475528, 0.48231, 0.489091,
0.495872, 0.502653, 0.509432, 0.516211, 0.522989, 0.529766, 0.536542, 0.543318, 0.550092,
0.556866, 0.563638, 0.57041, 0.577181, 0.58395, 0.590718, 0.597485, 0.604251, 0.611015 },

{0, 0.006799, 0.013598, 0.020396, 0.027195, 0.033994, 0.040792, 0.047591, 0.05439, 0.061188,
0.067987, 0.074785, 0.081584, 0.088382, 0.095181, 0.101979, 0.108777, 0.115575, 0.122373,
0.129171, 0.135969, 0.142767, 0.149564, 0.156362, 0.163159, 0.169957, 0.176754, 0.183551,
0.190348, 0.197144, 0.203941, 0.210737, 0.217534, 0.22433, 0.231126, 0.237921, 0.244717,
0.251512, 0.258307, 0.265102, 0.271897, 0.278691, 0.285485, 0.292279, 0.299073, 0.305866,
0.312659, 0.319452, 0.326244, 0.333036, 0.339828, 0.346619, 0.35341, 0.360201, 0.366991,
0.373781, 0.380571, 0.38736, 0.394148, 0.400937, 0.407724, 0.414512, 0.421298, 0.428084,
0.43487, 0.441655, 0.44844, 0.455223, 0.462007, 0.468789, 0.475571, 0.482352, 0.489133,
0.495912, 0.502691, 0.509469, 0.516247, 0.523023, 0.529798, 0.536573, 0.543346, 0.550119,
0.55689, 0.56366, 0.570429, 0.577197, 0.583963, 0.590729, 0.597492, 0.604255, 0.611015 },

{0, 0.0068, 0.0136, 0.0204, 0.0272, 0.034, 0.0408, 0.0476, 0.0544, 0.0612, 0.068, 0.0748,
0.0816, 0.0884, 0.095199, 0.101999, 0.108798, 0.115597, 0.122397, 0.129196, 0.135995, 0.142794,
0.149593, 0.156391, 0.16319, 0.169988, 0.176787, 0.183585, 0.190383, 0.197181, 0.203978,
0.210776, 0.217573, 0.22437, 0.231167, 0.237963, 0.24476, 0.251556, 0.258352, 0.265147,
0.271943, 0.278738, 0.285533, 0.292327, 0.299121, 0.305915, 0.312709, 0.319502, 0.326295,
0.333087, 0.33988, 0.346671, 0.353463, 0.360254, 0.367044, 0.373834, 0.380624, 0.387413,
0.394201, 0.400989, 0.407777, 0.414564, 0.42135, 0.428136, 0.434921, 0.441706, 0.448489,
0.455273, 0.462055, 0.468837, 0.475618, 0.482398, 0.489177, 0.495955, 0.502733, 0.509509,
0.516285, 0.52306, 0.529833, 0.536605, 0.543377, 0.550147, 0.556916, 0.563683, 0.57045,
0.577214, 0.583978, 0.59074, 0.5975, 0.604259, 0.611015 },

{0, 0.006802, 0.013603, 0.020405, 0.027206, 0.034008, 0.040809, 0.04761, 0.054412, 0.061213,
0.068014, 0.074816, 0.081617, 0.088418, 0.095219, 0.10202, 0.10882, 0.115621, 0.122422,
0.129222, 0.136023, 0.142823, 0.149623, 0.156423, 0.163223, 0.170022, 0.176822, 0.183621,
0.19042, 0.197219, 0.204018, 0.210816, 0.217615, 0.224413, 0.23121, 0.238008, 0.244805,
0.251602, 0.258399, 0.265196, 0.271992, 0.278788, 0.285583, 0.292378, 0.299173, 0.305968,
0.312762, 0.319556, 0.326349, 0.333142, 0.339935, 0.346727, 0.353518, 0.36031, 0.3671, 0.37389,
0.38068, 0.387469, 0.394258, 0.401045, 0.407833, 0.414619, 0.421405, 0.428191, 0.434975,
0.441759, 0.448543, 0.455325, 0.462106, 0.468887, 0.475667, 0.482446, 0.489224, 0.496001,
0.502777, 0.509552, 0.516326, 0.523098, 0.52987, 0.53664, 0.543409, 0.550177, 0.556943,
0.563708, 0.570471, 0.577233, 0.583993, 0.590751, 0.597508, 0.604263, 0.611015 },

{0, 0.006803, 0.013606, 0.020409, 0.027212, 0.034015, 0.040818, 0.047621, 0.054424, 0.061227,
0.068029, 0.074832, 0.081635, 0.088437, 0.09524, 0.102042, 0.108844, 0.115646, 0.122448,
0.12925, 0.136052, 0.142853, 0.149655, 0.156456, 0.163257, 0.170058, 0.176859, 0.183659,
0.19046, 0.19726, 0.20406, 0.210859, 0.217659, 0.224458, 0.231257, 0.238055, 0.244854,
0.251652, 0.258449, 0.265247, 0.272044, 0.278841, 0.285637, 0.292433, 0.299229, 0.306024,
0.312818, 0.319613, 0.326407, 0.3332, 0.339993, 0.346786, 0.353577, 0.360369, 0.36716, 0.37395,
0.38074, 0.387529, 0.394317, 0.401105, 0.407892, 0.414678, 0.421464, 0.428249, 0.435033,
0.441816, 0.448599, 0.45538, 0.462161, 0.468941, 0.475719, 0.482497, 0.489274, 0.496049,
0.502824, 0.509597, 0.516369, 0.52314, 0.529909, 0.536677, 0.543444, 0.550209, 0.556972,
0.563734, 0.570494, 0.577253, 0.584009, 0.590764, 0.597517, 0.604267, 0.611015 },

{0, 0.006805, 0.013609, 0.020414, 0.027219, 0.034023, 0.040828, 0.047632, 0.054437, 0.061241,
0.068045, 0.07485, 0.081654, 0.088458, 0.095262, 0.102066, 0.108869, 0.115673, 0.122476,
0.12928, 0.136083, 0.142886, 0.149689, 0.156491, 0.163294, 0.170096, 0.176898, 0.1837,
0.190502, 0.197303, 0.204104, 0.210905, 0.217706, 0.224506, 0.231306, 0.238106, 0.244905,
0.251704, 0.258503, 0.265301, 0.272099, 0.278897, 0.285694, 0.292491, 0.299287, 0.306083,
0.312878, 0.319673, 0.326468, 0.333261, 0.340055, 0.346848, 0.35364, 0.360432, 0.367223,
0.374013, 0.380803, 0.387592, 0.39438, 0.401168, 0.407955, 0.414741, 0.421526, 0.428311,
0.435094, 0.441877, 0.448658, 0.455439, 0.462219, 0.468997, 0.475775, 0.482551, 0.489326,
0.4961, 0.502873, 0.509645, 0.516415, 0.523183, 0.52995, 0.536716, 0.54348, 0.550242, 0.557003,
0.563762, 0.570518, 0.577273, 0.584026, 0.590777, 0.597526, 0.604272, 0.611015 },

{0, 0.006806, 0.013613, 0.020419, 0.027225, 0.034032, 0.040838, 0.047644, 0.05445, 0.061256,
0.068062, 0.074868, 0.081674, 0.08848, 0.095285, 0.102091, 0.108896, 0.115701, 0.122506,
0.129311, 0.136116, 0.14292, 0.149724, 0.156529, 0.163333, 0.170136, 0.17694, 0.183743,
0.190546, 0.197349, 0.204151, 0.210953, 0.217755, 0.224556, 0.231358, 0.238159, 0.244959,
0.251759, 0.258559, 0.265358, 0.272157, 0.278956, 0.285754, 0.292551, 0.299348, 0.306145,
0.312941, 0.319737, 0.326532, 0.333326, 0.34012, 0.346913, 0.353706, 0.360498, 0.367289,
0.37408, 0.380869, 0.387659, 0.394447, 0.401234, 0.408021, 0.414807, 0.421591, 0.428375,
0.435158, 0.44194, 0.448721, 0.455501, 0.46228, 0.469057, 0.475833, 0.482608, 0.489382,
0.496154, 0.502925, 0.509695, 0.516463, 0.523229, 0.529994, 0.536757, 0.543518, 0.550278,
0.557035, 0.563791, 0.570544, 0.577295, 0.584044, 0.590791, 0.597535, 0.604277, 0.611015 },

{0, 0.006808, 0.013616, 0.020424, 0.027232, 0.03404, 0.040848, 0.047656, 0.054464, 0.061272,
0.06808, 0.074887, 0.081695, 0.088502, 0.09531, 0.102117, 0.108924, 0.115731, 0.122537,
0.129344, 0.13615, 0.142956, 0.149762, 0.156568, 0.163373, 0.170178, 0.176983, 0.183788,
0.190592, 0.197396, 0.2042, 0.211004, 0.217807, 0.22461, 0.231412, 0.238214, 0.245016,
0.251817, 0.258618, 0.265418, 0.272218, 0.279018, 0.285817, 0.292615, 0.299413, 0.306211,
0.313007, 0.319804, 0.326599, 0.333394, 0.340189, 0.346982, 0.353775, 0.360567, 0.367359,
0.37415, 0.38094, 0.387729, 0.394517, 0.401304, 0.40809, 0.414876, 0.42166, 0.428444, 0.435226,
0.442007, 0.448787, 0.455566, 0.462343, 0.46912, 0.475895, 0.482668, 0.48944, 0.496211,
0.50298, 0.509748, 0.516513, 0.523278, 0.53004, 0.5368, 0.543559, 0.550315, 0.557069, 0.563821,
0.570571, 0.577318, 0.584063, 0.590805, 0.597545, 0.604282, 0.611015 },

{0, 0.00681, 0.01362, 0.02043, 0.02724, 0.03405, 0.04086, 0.047669, 0.054479, 0.061289,
0.068098, 0.074908, 0.081717, 0.088526, 0.095335, 0.102144, 0.108953, 0.115762, 0.12257,
0.129378, 0.136186, 0.142994, 0.149801, 0.156609, 0.163416, 0.170223, 0.177029, 0.183835,
0.190641, 0.197447, 0.204252, 0.211057, 0.217861, 0.224666, 0.231469, 0.238273, 0.245076,
0.251878, 0.25868, 0.265481, 0.272282, 0.279083, 0.285883, 0.292682, 0.299481, 0.306279,
0.313077, 0.319874, 0.32667, 0.333466, 0.34026, 0.347055, 0.353848, 0.36064, 0.367432,
0.374223, 0.381013, 0.387802, 0.39459, 0.401377, 0.408163, 0.414948, 0.421732, 0.428515,
0.435297, 0.442077, 0.448856, 0.455634, 0.462411, 0.469186, 0.475959, 0.482731, 0.489502,
0.496271, 0.503038, 0.509803, 0.516567, 0.523328, 0.530088, 0.536845, 0.543601, 0.550354,
0.557105, 0.563853, 0.570599, 0.577343, 0.584083, 0.590821, 0.597555, 0.604287, 0.611015 },

{0, 0.006812, 0.013624, 0.020436, 0.027248, 0.03406, 0.040871, 0.047683, 0.054495, 0.061306,
0.068118, 0.074929, 0.08174, 0.088551, 0.095362, 0.102173, 0.108984, 0.115794, 0.122604,
0.129414, 0.136224, 0.143033, 0.149843, 0.156652, 0.16346, 0.170269, 0.177077, 0.183885,
0.190692, 0.197499, 0.204306, 0.211113, 0.217918, 0.224724, 0.231529, 0.238334, 0.245138,
0.251942, 0.258745, 0.265548, 0.27235, 0.279151, 0.285952, 0.292752, 0.299552, 0.306351,
0.31315, 0.319947, 0.326744, 0.33354, 0.340336, 0.34713, 0.353924, 0.360717, 0.367509, 0.3743,
0.38109, 0.387879, 0.394667, 0.401454, 0.40824, 0.415024, 0.421808, 0.42859, 0.435371,
0.442151, 0.448929, 0.455706, 0.462481, 0.469255, 0.476027, 0.482797, 0.489566, 0.496333,
0.503098, 0.509861, 0.516622, 0.523381, 0.530138, 0.536893, 0.543645, 0.550395, 0.557142,
0.563887, 0.570629, 0.577368, 0.584104, 0.590837, 0.597566, 0.604293, 0.611015 },

{0, 0.006814, 0.013628, 0.020442, 0.027256, 0.03407, 0.040884, 0.047697, 0.054511, 0.061325,
0.068138, 0.074951, 0.081765, 0.088578, 0.09539, 0.102203, 0.109016, 0.115828, 0.12264,
0.129452, 0.136263, 0.143075, 0.149886, 0.156697, 0.163507, 0.170317, 0.177127, 0.183937,
0.190746, 0.197554, 0.204363, 0.211171, 0.217978, 0.224785, 0.231592, 0.238398, 0.245203,
0.252008, 0.258813, 0.265617, 0.27242, 0.279222, 0.286025, 0.292826, 0.299627, 0.306426,
0.313226, 0.320024, 0.326822, 0.333618, 0.340414, 0.34721, 0.354004, 0.360797, 0.367589,
0.37438, 0.38117, 0.387959, 0.394747, 0.401534, 0.40832, 0.415104, 0.421887, 0.428668,
0.435448, 0.442227, 0.449004, 0.45578, 0.462554, 0.469326, 0.476097, 0.482866, 0.489633,
0.496398, 0.503161, 0.509922, 0.51668, 0.523437, 0.530191, 0.536942, 0.543691, 0.550438,
0.557181, 0.563922, 0.57066, 0.577394, 0.584126, 0.590853, 0.597578, 0.604299, 0.611015 },

{0, 0.006816, 0.013632, 0.020448, 0.027264, 0.03408, 0.040896, 0.047712, 0.054528, 0.061344,
0.068159, 0.074975, 0.08179, 0.088605, 0.09542, 0.102235, 0.109049, 0.115863, 0.122677,
0.129491, 0.136305, 0.143118, 0.149931, 0.156744, 0.163556, 0.170368, 0.177179, 0.183991,
0.190801, 0.197612, 0.204422, 0.211231, 0.21804, 0.224849, 0.231657, 0.238464, 0.245271,
0.252078, 0.258883, 0.265689, 0.272493, 0.279297, 0.2861, 0.292902, 0.299704, 0.306505,
0.313305, 0.320104, 0.326903, 0.3337, 0.340497, 0.347292, 0.354087, 0.36088, 0.367673,
0.374464, 0.381254, 0.388043, 0.394831, 0.401618, 0.408403, 0.415187, 0.421969, 0.42875,
0.435529, 0.442307, 0.449083, 0.455858, 0.462631, 0.469402, 0.476171, 0.482938, 0.489703,
0.496466, 0.503226, 0.509985, 0.516741, 0.523494, 0.530245, 0.536994, 0.543739, 0.550482,
0.557222, 0.563958, 0.570692, 0.577422, 0.584148, 0.590871, 0.59759, 0.604305, 0.611015 },

{0, 0.006818, 0.013637, 0.020455, 0.027273, 0.034092, 0.04091, 0.047728, 0.054546, 0.061363,
0.068181, 0.074999, 0.081816, 0.088633, 0.09545, 0.102267, 0.109084, 0.1159, 0.122716,
0.129532, 0.136348, 0.143163, 0.149978, 0.156792, 0.163607, 0.17042, 0.177234, 0.184047,
0.19086, 0.197672, 0.204483, 0.211295, 0.218105, 0.224915, 0.231725, 0.238534, 0.245342,
0.25215, 0.258957, 0.265764, 0.272569, 0.279374, 0.286179, 0.292982, 0.299785, 0.306587,
0.313388, 0.320188, 0.326987, 0.333785, 0.340582, 0.347378, 0.354173, 0.360967, 0.36776,
0.374551, 0.381342, 0.388131, 0.394918, 0.401705, 0.408489, 0.415273, 0.422055, 0.428835,
0.435613, 0.44239, 0.449166, 0.455939, 0.46271, 0.46948, 0.476247, 0.483012, 0.489775,
0.496536, 0.503294, 0.51005, 0.516804, 0.523554, 0.530302, 0.537047, 0.543789, 0.550528,
0.557264, 0.563996, 0.570725, 0.57745, 0.584172, 0.590889, 0.597602, 0.604311, 0.611015 },

{0, 0.006821, 0.013641, 0.020462, 0.027283, 0.034103, 0.040923, 0.047744, 0.054564, 0.061384,
0.068204, 0.075024, 0.081844, 0.088663, 0.095482, 0.102301, 0.10912, 0.115939, 0.122757,
0.129575, 0.136392, 0.14321, 0.150027, 0.156843, 0.163659, 0.170475, 0.177291, 0.184105,
0.19092, 0.197734, 0.204547, 0.21136, 0.218173, 0.224984, 0.231796, 0.238606, 0.245416,
0.252225, 0.259034, 0.265842, 0.272649, 0.279455, 0.28626, 0.293065, 0.299869, 0.306672,
0.313473, 0.320274, 0.327074, 0.333873, 0.340671, 0.347467, 0.354263, 0.361057, 0.36785,
0.374642, 0.381432, 0.388221, 0.395009, 0.401795, 0.408579, 0.415362, 0.422144, 0.428923,
0.435701, 0.442477, 0.449251, 0.456023, 0.462793, 0.469561, 0.476327, 0.48309, 0.489851,
0.496609, 0.503365, 0.510119, 0.516869, 0.523617, 0.530362, 0.537103, 0.543841, 0.550576,
0.557308, 0.564036, 0.57076, 0.57748, 0.584196, 0.590908, 0.597615, 0.604318, 0.611015 },

{0, 0.006823, 0.013646, 0.020469, 0.027292, 0.034115, 0.040938, 0.047761, 0.054583, 0.061406,
0.068228, 0.07505, 0.081872, 0.088694, 0.095515, 0.102337, 0.109158, 0.115978, 0.122799,
0.129619, 0.136439, 0.143258, 0.150077, 0.156896, 0.163714, 0.170532, 0.177349, 0.184166,
0.190983, 0.197799, 0.204614, 0.211429, 0.218243, 0.225056, 0.231869, 0.238681, 0.245493,
0.252303, 0.259114, 0.265923, 0.272731, 0.279539, 0.286345, 0.293151, 0.299956, 0.30676,
0.313563, 0.320364, 0.327165, 0.333965, 0.340763, 0.34756, 0.354356, 0.361151, 0.367944,
0.374736, 0.381527, 0.388316, 0.395103, 0.401889, 0.408673, 0.415455, 0.422236, 0.429015,
0.435792, 0.442567, 0.44934, 0.45611, 0.462879, 0.469645, 0.476409, 0.48317, 0.489929,
0.496685, 0.503439, 0.510189, 0.516937, 0.523682, 0.530423, 0.537161, 0.543895, 0.550626,
0.557353, 0.564077, 0.570796, 0.577511, 0.584221, 0.590927, 0.597628, 0.604325, 0.611015 },

{0, 0.006826, 0.013651, 0.020477, 0.027302, 0.034127, 0.040953, 0.047778, 0.054603, 0.061428,
0.068253, 0.075077, 0.081902, 0.088726, 0.09555, 0.102373, 0.109197, 0.11602, 0.122842,
0.129665, 0.136487, 0.143309, 0.15013, 0.156951, 0.163771, 0.170591, 0.17741, 0.184229,
0.191048, 0.197866, 0.204683, 0.211499, 0.218315, 0.225131, 0.231945, 0.238759, 0.245572,
0.252385, 0.259196, 0.266007, 0.272817, 0.279625, 0.286433, 0.29324, 0.300046, 0.306851,
0.313655, 0.320458, 0.327259, 0.33406, 0.340859, 0.347657, 0.354453, 0.361248, 0.368042,
0.374834, 0.381624, 0.388413, 0.395201, 0.401986, 0.40877, 0.415552, 0.422332, 0.42911,
0.435886, 0.44266, 0.449432, 0.456201, 0.462968, 0.469732, 0.476495, 0.483254, 0.490011,
0.496764, 0.503515, 0.510263, 0.517007, 0.523749, 0.530487, 0.537221, 0.543951, 0.550678,
0.557401, 0.564119, 0.570833, 0.577543, 0.584248, 0.590947, 0.597642, 0.604332, 0.611015 },

{0, 0.006828, 0.013656, 0.020484, 0.027312, 0.03414, 0.040968, 0.047796, 0.054624, 0.061451,
0.068278, 0.075105, 0.081932, 0.088759, 0.095585, 0.102411, 0.109237, 0.116063, 0.122888,
0.129712, 0.136537, 0.143361, 0.150184, 0.157007, 0.16383, 0.170652, 0.177474, 0.184295,
0.191115, 0.197935, 0.204754, 0.211573, 0.218391, 0.225208, 0.232024, 0.23884, 0.245655,
0.252469, 0.259282, 0.266094, 0.272905, 0.279715, 0.286525, 0.293333, 0.30014, 0.306946,
0.313751, 0.320555, 0.327357, 0.334158, 0.340958, 0.347756, 0.354553, 0.361349, 0.368143,
0.374935, 0.381726, 0.388514, 0.395302, 0.402087, 0.40887, 0.415652, 0.422431, 0.429208,
0.435983, 0.442756, 0.449527, 0.456295, 0.46306, 0.469823, 0.476583, 0.48334, 0.490095,
0.496846, 0.503594, 0.510339, 0.51708, 0.523818, 0.530552, 0.537283, 0.544009, 0.550732,
0.557449, 0.564163, 0.570872, 0.577576, 0.584275, 0.590968, 0.597657, 0.604339, 0.611015 },

{0, 0.006831, 0.013662, 0.020492, 0.027323, 0.034154, 0.040984, 0.047815, 0.054645, 0.061475,
0.068305, 0.075134, 0.081964, 0.088793, 0.095622, 0.102451, 0.109279, 0.116107, 0.122934,
0.129762, 0.136588, 0.143415, 0.150241, 0.157066, 0.163891, 0.170715, 0.177539, 0.184362,
0.191185, 0.198007, 0.204828, 0.211649, 0.218468, 0.225287, 0.232106, 0.238923, 0.24574,
0.252555, 0.25937, 0.266184, 0.272997, 0.279808, 0.286619, 0.293429, 0.300237, 0.307044,
0.31385, 0.320655, 0.327458, 0.33426, 0.34106, 0.347859, 0.354657, 0.361453, 0.368247,
0.375039, 0.38183, 0.388619, 0.395406, 0.402191, 0.408974, 0.415755, 0.422534, 0.42931,
0.436084, 0.442856, 0.449625, 0.456392, 0.463155, 0.469916, 0.476675, 0.48343, 0.490182,
0.49693, 0.503676, 0.510417, 0.517156, 0.52389, 0.530621, 0.537347, 0.544069, 0.550787, 0.5575,
0.564208, 0.570912, 0.57761, 0.584303, 0.59099, 0.597671, 0.604347, 0.611015 },

{0, 0.006834, 0.013667, 0.020501, 0.027334, 0.034167, 0.041001, 0.047834, 0.054667, 0.0615,
0.068332, 0.075165, 0.081997, 0.088828, 0.09566, 0.102491, 0.109322, 0.116153, 0.122983,
0.129813, 0.136642, 0.143471, 0.150299, 0.157127, 0.163954, 0.170781, 0.177607, 0.184432,
0.191257, 0.198081, 0.204904, 0.211727, 0.218549, 0.22537, 0.23219, 0.239009, 0.245828,
0.252645, 0.259462, 0.266277, 0.273091, 0.279905, 0.286717, 0.293528, 0.300337, 0.307146,
0.313953, 0.320758, 0.327562, 0.334365, 0.341166, 0.347966, 0.354764, 0.36156, 0.368355,
0.375148, 0.381938, 0.388727, 0.395514, 0.402299, 0.409081, 0.415862, 0.42264, 0.429415,
0.436188, 0.442959, 0.449727, 0.456492, 0.463254, 0.470013, 0.476769, 0.483522, 0.490271,
0.497017, 0.50376, 0.510499, 0.517233, 0.523964, 0.530691, 0.537413, 0.544131, 0.550844,
0.557552, 0.564255, 0.570953, 0.577645, 0.584332, 0.591012, 0.597687, 0.604354, 0.611015 },

{0, 0.006836, 0.013673, 0.020509, 0.027346, 0.034182, 0.041018, 0.047854, 0.054689, 0.061525,
0.06836, 0.075196, 0.08203, 0.088865, 0.095699, 0.102533, 0.109367, 0.1162, 0.123033, 0.129865,
0.136697, 0.143528, 0.150359, 0.157189, 0.164019, 0.170848, 0.177677, 0.184504, 0.191331,
0.198158, 0.204983, 0.211808, 0.218632, 0.225455, 0.232277, 0.239099, 0.245919, 0.252738,
0.259556, 0.266373, 0.273189, 0.280004, 0.286817, 0.29363, 0.300441, 0.30725, 0.314058,
0.320865, 0.32767, 0.334474, 0.341276, 0.348076, 0.354875, 0.361671, 0.368466, 0.375259,
0.38205, 0.388839, 0.395626, 0.40241, 0.409192, 0.415972, 0.422749, 0.429524, 0.436296,
0.443065, 0.449832, 0.456595, 0.463356, 0.470113, 0.476867, 0.483617, 0.490364, 0.497107,
0.503847, 0.510582, 0.517314, 0.524041, 0.530763, 0.537481, 0.544195, 0.550903, 0.557606,
0.564303, 0.570995, 0.577682, 0.584362, 0.591035, 0.597702, 0.604362, 0.611015 },

{0, 0.006839, 0.013679, 0.020518, 0.027357, 0.034196, 0.041035, 0.047874, 0.054713, 0.061551,
0.06839, 0.075228, 0.082065, 0.088903, 0.09574, 0.102577, 0.109413, 0.116249, 0.123084,
0.129919, 0.136754, 0.143588, 0.150421, 0.157254, 0.164086, 0.170918, 0.177749, 0.184579,
0.191408, 0.198237, 0.205065, 0.211892, 0.218718, 0.225543, 0.232367, 0.23919, 0.246013,
0.252834, 0.259654, 0.266472, 0.27329, 0.280106, 0.286921, 0.293735, 0.300547, 0.307358,
0.314168, 0.320975, 0.327781, 0.334586, 0.341389, 0.34819, 0.354989, 0.361786, 0.368581,
0.375374, 0.382165, 0.388954, 0.395741, 0.402525, 0.409306, 0.416086, 0.422862, 0.429636,
0.436407, 0.443175, 0.44994, 0.456702, 0.46346, 0.470216, 0.476967, 0.483715, 0.49046, 0.4972,
0.503936, 0.510669, 0.517396, 0.52412, 0.530838, 0.537552, 0.54426, 0.550963, 0.557661,
0.564353, 0.571039, 0.577719, 0.584392, 0.591059, 0.597719, 0.604371, 0.611015 },

{0, 0.006842, 0.013685, 0.020527, 0.027369, 0.034212, 0.041054, 0.047895, 0.054737, 0.061579,
0.06842, 0.075261, 0.082101, 0.088942, 0.095782, 0.102621, 0.10946, 0.116299, 0.123137,
0.129975, 0.136812, 0.143649, 0.150485, 0.157321, 0.164156, 0.17099, 0.177823, 0.184656,
0.191488, 0.198319, 0.205149, 0.211978, 0.218806, 0.225634, 0.23246, 0.239285, 0.246109,
0.252932, 0.259754, 0.266575, 0.273394, 0.280212, 0.287029, 0.293844, 0.300657, 0.30747,
0.31428, 0.321089, 0.327896, 0.334701, 0.341505, 0.348307, 0.355106, 0.361904, 0.3687,
0.375493, 0.382284, 0.389073, 0.395859, 0.402643, 0.409424, 0.416203, 0.422978, 0.429751,
0.436521, 0.443288, 0.450051, 0.456811, 0.463568, 0.470321, 0.477071, 0.483816, 0.490558,
0.497296, 0.504029, 0.510757, 0.517482, 0.524201, 0.530915, 0.537624, 0.544328, 0.551026,
0.557718, 0.564404, 0.571084, 0.577758, 0.584424, 0.591083, 0.597735, 0.604379, 0.611015 },

{0, 0.006846, 0.013691, 0.020537, 0.027382, 0.034227, 0.041072, 0.047917, 0.054762, 0.061607,
0.068451, 0.075295, 0.082138, 0.088982, 0.095825, 0.102667, 0.109509, 0.116351, 0.123192,
0.130033, 0.136873, 0.143712, 0.150551, 0.157389, 0.164227, 0.171064, 0.1779, 0.184735,
0.191569, 0.198403, 0.205235, 0.212067, 0.218897, 0.225727, 0.232555, 0.239383, 0.246209,
0.253034, 0.259858, 0.26668, 0.273501, 0.280321, 0.287139, 0.293956, 0.300771, 0.307584,
0.314396, 0.321206, 0.328014, 0.33482, 0.341625, 0.348427, 0.355227, 0.362026, 0.368821,
0.375615, 0.382406, 0.389195, 0.395981, 0.402765, 0.409545, 0.416323, 0.423098, 0.42987,
0.436639, 0.443404, 0.450166, 0.456924, 0.463679, 0.47043, 0.477177, 0.483921, 0.490659,
0.497394, 0.504124, 0.510849, 0.517569, 0.524284, 0.530994, 0.537699, 0.544397, 0.55109,
0.557777, 0.564457, 0.571131, 0.577797, 0.584457, 0.591108, 0.597752, 0.604388, 0.611015 },

{0, 0.006849, 0.013697, 0.020546, 0.027395, 0.034243, 0.041092, 0.04794, 0.054788, 0.061635,
0.068483, 0.07533, 0.082177, 0.089023, 0.095869, 0.102715, 0.10956, 0.116404, 0.123249,
0.130092, 0.136935, 0.143777, 0.150619, 0.15746, 0.1643, 0.17114, 0.177978, 0.184816, 0.191653,
0.198489, 0.205324, 0.212158, 0.218991, 0.225823, 0.232654, 0.239483, 0.246312, 0.253139,
0.259964, 0.266789, 0.273611, 0.280433, 0.287253, 0.294071, 0.300887, 0.307702, 0.314515,
0.321326, 0.328136, 0.334943, 0.341748, 0.348551, 0.355352, 0.362151, 0.368947, 0.375741,
0.382532, 0.389321, 0.396107, 0.40289, 0.40967, 0.416447, 0.423221, 0.429992, 0.43676,
0.443524, 0.450284, 0.457041, 0.463794, 0.470542, 0.477287, 0.484028, 0.490763, 0.497495,
0.504221, 0.510943, 0.517659, 0.52437, 0.531076, 0.537775, 0.544469, 0.551156, 0.557837,
0.564511, 0.571178, 0.577838, 0.58449, 0.591134, 0.59777, 0.604397, 0.611015 },

{0, 0.006852, 0.013704, 0.020556, 0.027408, 0.03426, 0.041111, 0.047963, 0.054814, 0.061665,
0.068516, 0.075366, 0.082216, 0.089066, 0.095915, 0.102763, 0.109612, 0.116459, 0.123307,
0.130153, 0.136999, 0.143844, 0.150689, 0.157533, 0.164376, 0.171218, 0.17806, 0.1849, 0.19174,
0.198578, 0.205416, 0.212252, 0.219088, 0.225922, 0.232755, 0.239587, 0.246417, 0.253246,
0.260074, 0.2669, 0.273725, 0.280548, 0.287369, 0.294189, 0.301007, 0.307823, 0.314638,
0.32145, 0.32826, 0.335069, 0.341875, 0.348679, 0.35548, 0.362279, 0.369076, 0.37587, 0.382661,
0.38945, 0.396236, 0.403018, 0.409798, 0.416575, 0.423348, 0.430118, 0.436884, 0.443646,
0.450405, 0.45716, 0.463911, 0.470658, 0.4774, 0.484137, 0.49087, 0.497599, 0.504322, 0.511039,
0.517752, 0.524458, 0.531159, 0.537854, 0.544542, 0.551224, 0.557899, 0.564567, 0.571227,
0.57788, 0.584524, 0.591161, 0.597788, 0.604406, 0.611015 },

{0, 0.006855, 0.013711, 0.020566, 0.027422, 0.034277, 0.041132, 0.047987, 0.054841, 0.061695,
0.068549, 0.075403, 0.082256, 0.089109, 0.095962, 0.102814, 0.109665, 0.116516, 0.123366,
0.130216, 0.137065, 0.143913, 0.150761, 0.157608, 0.164454, 0.171299, 0.178143, 0.184986,
0.191828, 0.19867, 0.20551, 0.212349, 0.219187, 0.226023, 0.232859, 0.239693, 0.246525,
0.253357, 0.260186, 0.267015, 0.273841, 0.280666, 0.287489, 0.294311, 0.30113, 0.307948,
0.314764, 0.321577, 0.328389, 0.335198, 0.342005, 0.34881, 0.355612, 0.362411, 0.369208,
0.376003, 0.382794, 0.389583, 0.396368, 0.40315, 0.40993, 0.416705, 0.423478, 0.430246,
0.437011, 0.443773, 0.45053, 0.457283, 0.464032, 0.470776, 0.477515, 0.48425, 0.49098,
0.497705, 0.504425, 0.511139, 0.517847, 0.524549, 0.531245, 0.537935, 0.544618, 0.551294,
0.557962, 0.564624, 0.571277, 0.577923, 0.584559, 0.591188, 0.597807, 0.604416, 0.611015 },

{0, 0.006859, 0.013718, 0.020577, 0.027436, 0.034294, 0.041153, 0.048011, 0.054869, 0.061727,
0.068584, 0.075441, 0.082298, 0.089154, 0.09601, 0.102865, 0.10972, 0.116574, 0.123427,
0.13028, 0.137132, 0.143984, 0.150835, 0.157684, 0.164533, 0.171381, 0.178229, 0.185075,
0.19192, 0.198764, 0.205607, 0.212448, 0.219289, 0.226128, 0.232966, 0.239802, 0.246637,
0.25347, 0.260302, 0.267132, 0.273961, 0.280788, 0.287613, 0.294436, 0.301257, 0.308076,
0.314893, 0.321708, 0.328521, 0.335331, 0.342139, 0.348944, 0.355747, 0.362547, 0.369344,
0.376139, 0.38293, 0.389719, 0.396504, 0.403286, 0.410065, 0.41684, 0.423611, 0.430379,
0.437143, 0.443902, 0.450658, 0.457409, 0.464155, 0.470897, 0.477634, 0.484366, 0.491093,
0.497814, 0.50453, 0.51124, 0.517944, 0.524642, 0.531333, 0.538018, 0.544695, 0.551365,
0.558028, 0.564682, 0.571329, 0.577967, 0.584596, 0.591215, 0.597826, 0.604426, 0.611015 },

{0, 0.006863, 0.013725, 0.020588, 0.02745, 0.034312, 0.041174, 0.048036, 0.054898, 0.061759,
0.06862, 0.07548, 0.08234, 0.0892, 0.096059, 0.102918, 0.109776, 0.116633, 0.12349, 0.130346,
0.137202, 0.144056, 0.15091, 0.157763, 0.164615, 0.171466, 0.178316, 0.185165, 0.192013,
0.19886, 0.205706, 0.21255, 0.219393, 0.226235, 0.233075, 0.239914, 0.246751, 0.253587,
0.260421, 0.267253, 0.274084, 0.280912, 0.287739, 0.294564, 0.301387, 0.308207, 0.315026,
0.321842, 0.328656, 0.335467, 0.342276, 0.349082, 0.355886, 0.362686, 0.369484, 0.376279,
0.38307, 0.389859, 0.396644, 0.403425, 0.410203, 0.416978, 0.423748, 0.430515, 0.437277,
0.444035, 0.450789, 0.457538, 0.464282, 0.471022, 0.477756, 0.484485, 0.491209, 0.497927,
0.504639, 0.511345, 0.518044, 0.524737, 0.531423, 0.538102, 0.544774, 0.551438, 0.558094,
0.564742, 0.571381, 0.578012, 0.584633, 0.591244, 0.597845, 0.604436, 0.611015 },

{0, 0.006866, 0.013732, 0.020599, 0.027465, 0.034331, 0.041196, 0.048062, 0.054927, 0.061792,
0.068656, 0.07552, 0.082384, 0.089247, 0.09611, 0.102972, 0.109834, 0.116695, 0.123555,
0.130414, 0.137273, 0.144131, 0.150988, 0.157844, 0.164699, 0.171554, 0.178407, 0.185259,
0.19211, 0.198959, 0.205808, 0.212655, 0.2195, 0.226345, 0.233187, 0.240029, 0.246868,
0.253706, 0.260543, 0.267377, 0.27421, 0.28104, 0.287869, 0.294696, 0.30152, 0.308342,
0.315162, 0.32198, 0.328795, 0.335607, 0.342417, 0.349224, 0.356028, 0.362829, 0.369627,
0.376422, 0.383214, 0.390002, 0.396787, 0.403568, 0.410345, 0.417119, 0.423888, 0.430654,
0.437415, 0.444171, 0.450923, 0.45767, 0.464412, 0.471149, 0.477881, 0.484607, 0.491327,
0.498041, 0.50475, 0.511451, 0.518147, 0.524835, 0.531516, 0.538189, 0.544855, 0.551513,
0.558163, 0.564804, 0.571435, 0.578058, 0.584671, 0.591273, 0.597865, 0.604446, 0.611015 },

{0, 0.00687, 0.01374, 0.02061, 0.02748, 0.034349, 0.041219, 0.048088, 0.054957, 0.061826,
0.068694, 0.075562, 0.082429, 0.089296, 0.096162, 0.103028, 0.109893, 0.116757, 0.123621,
0.130484, 0.137346, 0.144207, 0.151068, 0.157927, 0.164786, 0.171643, 0.178499, 0.185354,
0.192208, 0.199061, 0.205912, 0.212762, 0.21961, 0.226457, 0.233303, 0.240147, 0.246989,
0.253829, 0.260668, 0.267504, 0.274339, 0.281172, 0.288002, 0.29483, 0.301657, 0.30848,
0.315302, 0.32212, 0.328937, 0.33575, 0.342561, 0.349369, 0.356174, 0.362975, 0.369774,
0.376569, 0.383361, 0.390149, 0.396934, 0.403714, 0.410491, 0.417264, 0.424032, 0.430796,
0.437556, 0.444311, 0.451061, 0.457806, 0.464546, 0.47128, 0.478009, 0.484732, 0.491448,
0.498159, 0.504863, 0.511561, 0.518251, 0.524935, 0.53161, 0.538278, 0.544938, 0.55159,
0.558233, 0.564866, 0.571491, 0.578105, 0.584709, 0.591303, 0.597885, 0.604456, 0.611015 },

{0, 0.006874, 0.013748, 0.020622, 0.027495, 0.034369, 0.041242, 0.048115, 0.054988, 0.06186,
0.068732, 0.075604, 0.082475, 0.089345, 0.096215, 0.103085, 0.109954, 0.116822, 0.123689,
0.130555, 0.137421, 0.144286, 0.151149, 0.158012, 0.164874, 0.171734, 0.178594, 0.185452,
0.192309, 0.199165, 0.206019, 0.212872, 0.219723, 0.226573, 0.233421, 0.240267, 0.247112,
0.253955, 0.260796, 0.267634, 0.274471, 0.281306, 0.288138, 0.294969, 0.301797, 0.308622,
0.315445, 0.322265, 0.329082, 0.335897, 0.342709, 0.349517, 0.356323, 0.363125, 0.369924,
0.37672, 0.383511, 0.3903, 0.397084, 0.403864, 0.41064, 0.417412, 0.42418, 0.430942, 0.4377,
0.444454, 0.451202, 0.457945, 0.464682, 0.471414, 0.478139, 0.484859, 0.491573, 0.49828,
0.50498, 0.511673, 0.518359, 0.525037, 0.531707, 0.53837, 0.545023, 0.551668, 0.558304,
0.564931, 0.571547, 0.578153, 0.584749, 0.591333, 0.597906, 0.604467, 0.611015 },

{0, 0.006878, 0.013756, 0.020634, 0.027511, 0.034389, 0.041266, 0.048143, 0.055019, 0.061896,
0.068772, 0.075647, 0.082522, 0.089396, 0.09627, 0.103143, 0.110016, 0.116887, 0.123758,
0.130628, 0.137498, 0.144366, 0.151233, 0.158099, 0.164964, 0.171828, 0.178691, 0.185552,
0.192413, 0.199271, 0.206129, 0.212984, 0.219839, 0.226691, 0.233542, 0.240391, 0.247238,
0.254083, 0.260927, 0.267768, 0.274607, 0.281444, 0.288278, 0.29511, 0.30194, 0.308767,
0.315591, 0.322413, 0.329232, 0.336047, 0.34286, 0.34967, 0.356476, 0.363279, 0.370078,
0.376874, 0.383666, 0.390454, 0.397238, 0.404017, 0.410793, 0.417564, 0.42433, 0.431092,
0.437848, 0.4446, 0.451346, 0.458087, 0.464822, 0.471551, 0.478273, 0.48499, 0.4917, 0.498403,
0.505099, 0.511787, 0.518468, 0.525142, 0.531806, 0.538463, 0.54511, 0.551749, 0.558377,
0.564996, 0.571605, 0.578203, 0.584789, 0.591365, 0.597928, 0.604478, 0.611015 },

{0, 0.006882, 0.013764, 0.020646, 0.027527, 0.034409, 0.04129, 0.048171, 0.055052, 0.061932,
0.068812, 0.075691, 0.08257, 0.089448, 0.096326, 0.103203, 0.110079, 0.116955, 0.123829,
0.130703, 0.137576, 0.144448, 0.151319, 0.158188, 0.165057, 0.171924, 0.17879, 0.185655,
0.192519, 0.19938, 0.206241, 0.2131, 0.219957, 0.226812, 0.233666, 0.240518, 0.247367,
0.254215, 0.261061, 0.267904, 0.274746, 0.281585, 0.288421, 0.295255, 0.302087, 0.308915,
0.315741, 0.322564, 0.329384, 0.336201, 0.343015, 0.349825, 0.356632, 0.363436, 0.370236,
0.377031, 0.383823, 0.390611, 0.397395, 0.404174, 0.410949, 0.417719, 0.424485, 0.431245,
0.438, 0.444749, 0.451494, 0.458232, 0.464964, 0.471691, 0.47841, 0.485123, 0.49183, 0.498529,
0.50522, 0.511905, 0.518581, 0.525248, 0.531908, 0.538558, 0.545199, 0.551831, 0.558452,
0.565063, 0.571664, 0.578253, 0.584831, 0.591396, 0.597949, 0.604489, 0.611015 },

{0, 0.006886, 0.013772, 0.020658, 0.027544, 0.03443, 0.041315, 0.0482, 0.055085, 0.061969,
0.068853, 0.075737, 0.082619, 0.089502, 0.096383, 0.103264, 0.110144, 0.117024, 0.123902,
0.13078, 0.137656, 0.144532, 0.151406, 0.15828, 0.165152, 0.172023, 0.178892, 0.18576,
0.192627, 0.199492, 0.206356, 0.213218, 0.220078, 0.226936, 0.233793, 0.240647, 0.2475,
0.25435, 0.261198, 0.268044, 0.274888, 0.281729, 0.288567, 0.295403, 0.302237, 0.309067,
0.315895, 0.322719, 0.329541, 0.336359, 0.343173, 0.349985, 0.356792, 0.363596, 0.370397,
0.377193, 0.383985, 0.390773, 0.397556, 0.404335, 0.411109, 0.417878, 0.424642, 0.431401,
0.438155, 0.444902, 0.451644, 0.458381, 0.46511, 0.471834, 0.47855, 0.48526, 0.491962,
0.498658, 0.505345, 0.512024, 0.518695, 0.525358, 0.532011, 0.538655, 0.54529, 0.551914,
0.558529, 0.565132, 0.571724, 0.578305, 0.584873, 0.591429, 0.597972, 0.604501, 0.611015 },

{0, 0.00689, 0.013781, 0.020671, 0.027561, 0.034451, 0.041341, 0.04823, 0.055119, 0.062007,
0.068895, 0.075783, 0.08267, 0.089556, 0.096442, 0.103327, 0.110211, 0.117094, 0.123977,
0.130858, 0.137739, 0.144618, 0.151496, 0.158373, 0.165249, 0.172123, 0.178996, 0.185868,
0.192738, 0.199606, 0.206473, 0.213338, 0.220202, 0.227063, 0.233922, 0.24078, 0.247635,
0.254488, 0.261339, 0.268187, 0.275033, 0.281876, 0.288717, 0.295555, 0.30239, 0.309222,
0.316052, 0.322878, 0.3297, 0.33652, 0.343335, 0.350148, 0.356956, 0.363761, 0.370561,
0.377358, 0.38415, 0.390937, 0.397721, 0.404499, 0.411272, 0.41804, 0.424803, 0.431561,
0.438313, 0.445059, 0.451799, 0.458532, 0.465259, 0.47198, 0.478693, 0.485399, 0.492098,
0.498789, 0.505472, 0.512146, 0.518812, 0.525469, 0.532117, 0.538755, 0.545383, 0.552,
0.558607, 0.565202, 0.571786, 0.578357, 0.584916, 0.591462, 0.597994, 0.604512, 0.611015 },

{0, 0.006895, 0.013789, 0.020684, 0.027578, 0.034473, 0.041367, 0.04826, 0.055153, 0.062046,
0.068939, 0.07583, 0.082722, 0.089612, 0.096502, 0.103391, 0.110279, 0.117167, 0.124053,
0.130938, 0.137823, 0.144706, 0.151588, 0.158469, 0.165348, 0.172226, 0.179103, 0.185978,
0.192851, 0.199723, 0.206593, 0.213462, 0.220328, 0.227192, 0.234055, 0.240915, 0.247773,
0.254629, 0.261482, 0.268333, 0.275181, 0.282027, 0.28887, 0.29571, 0.302547, 0.309381,
0.316212, 0.323039, 0.329864, 0.336684, 0.343501, 0.350314, 0.357123, 0.363929, 0.37073,
0.377526, 0.384318, 0.391106, 0.397889, 0.404666, 0.411439, 0.418206, 0.424968, 0.431724,
0.438474, 0.445218, 0.451956, 0.458687, 0.465412, 0.472129, 0.478839, 0.485542, 0.492237,
0.498923, 0.505602, 0.512271, 0.518932, 0.525583, 0.532225, 0.538856, 0.545477, 0.552087,
0.558686, 0.565274, 0.571849, 0.578411, 0.58496, 0.591496, 0.598017, 0.604524, 0.611015 },

{0, 0.006899, 0.013798, 0.020697, 0.027596, 0.034495, 0.041393, 0.048291, 0.055189, 0.062086,
0.068983, 0.075879, 0.082774, 0.089669, 0.096563, 0.103457, 0.110349, 0.11724, 0.124131,
0.13102, 0.137909, 0.144796, 0.151682, 0.158566, 0.16545, 0.172331, 0.179212, 0.18609,
0.192967, 0.199843, 0.206716, 0.213588, 0.220457, 0.227325, 0.23419, 0.241054, 0.247915,
0.254773, 0.261629, 0.268483, 0.275333, 0.282181, 0.289026, 0.295868, 0.302707, 0.309543,
0.316376, 0.323205, 0.33003, 0.336852, 0.34367, 0.350484, 0.357294, 0.3641, 0.370902, 0.377698,
0.384491, 0.391278, 0.39806, 0.404838, 0.411609, 0.418376, 0.425136, 0.431891, 0.438639,
0.445382, 0.452117, 0.458846, 0.465567, 0.472282, 0.478988, 0.485687, 0.492378, 0.49906,
0.505734, 0.512399, 0.519054, 0.525699, 0.532335, 0.53896, 0.545574, 0.552176, 0.558767,
0.565346, 0.571913, 0.578466, 0.585005, 0.591531, 0.598041, 0.604536, 0.611015 },

{0, 0.006904, 0.013807, 0.020711, 0.027614, 0.034518, 0.041421, 0.048323, 0.055225, 0.062127,
0.069028, 0.075929, 0.082828, 0.089728, 0.096626, 0.103524, 0.11042, 0.117316, 0.124211,
0.131104, 0.137997, 0.144888, 0.151778, 0.158666, 0.165553, 0.172439, 0.179323, 0.186205,
0.193086, 0.199965, 0.206842, 0.213717, 0.22059, 0.22746, 0.234329, 0.241195, 0.248059,
0.25492, 0.261779, 0.268635, 0.275488, 0.282339, 0.289186, 0.29603, 0.302871, 0.309709,
0.316543, 0.323374, 0.330201, 0.337024, 0.343843, 0.350658, 0.357469, 0.364275, 0.371077,
0.377874, 0.384667, 0.391454, 0.398236, 0.405012, 0.411783, 0.418549, 0.425308, 0.432061,
0.438808, 0.445548, 0.452281, 0.459007, 0.465726, 0.472437, 0.479141, 0.485836, 0.492522,
0.4992, 0.505869, 0.512529, 0.519178, 0.525818, 0.532447, 0.539065, 0.545672, 0.552267,
0.55885, 0.565421, 0.571978, 0.578522, 0.585051, 0.591566, 0.598065, 0.604549, 0.611015 },

{0, 0.006908, 0.013817, 0.020725, 0.027633, 0.034541, 0.041448, 0.048355, 0.055262, 0.062168,
0.069074, 0.075979, 0.082884, 0.089787, 0.09669, 0.103592, 0.110493, 0.117393, 0.124292,
0.13119, 0.138086, 0.144982, 0.151876, 0.158768, 0.165659, 0.172549, 0.179437, 0.186323,
0.193207, 0.200089, 0.20697, 0.213848, 0.220725, 0.227599, 0.23447, 0.24134, 0.248206,
0.255071, 0.261932, 0.268791, 0.275647, 0.282499, 0.289349, 0.296196, 0.303039, 0.309878,
0.316714, 0.323546, 0.330375, 0.337199, 0.34402, 0.350836, 0.357647, 0.364454, 0.371256,
0.378054, 0.384846, 0.391633, 0.398415, 0.405191, 0.411961, 0.418725, 0.425483, 0.432235,
0.43898, 0.445718, 0.452449, 0.459172, 0.465888, 0.472596, 0.479296, 0.485987, 0.49267,
0.499343, 0.506007, 0.512661, 0.519305, 0.525939, 0.532561, 0.539173, 0.545772, 0.55236,
0.558935, 0.565496, 0.572044, 0.578578, 0.585098, 0.591602, 0.59809, 0.604561, 0.611015 },

{0, 0.006913, 0.013826, 0.020739, 0.027652, 0.034565, 0.041477, 0.048389, 0.0553, 0.062211,
0.069121, 0.076031, 0.08294, 0.089848, 0.096755, 0.103662, 0.110567, 0.117472, 0.124375,
0.131277, 0.138178, 0.145078, 0.151976, 0.158872, 0.165767, 0.172661, 0.179553, 0.186443,
0.193331, 0.200217, 0.207101, 0.213983, 0.220862, 0.22774, 0.234615, 0.241487, 0.248357,
0.255224, 0.262089, 0.26895, 0.275808, 0.282664, 0.289516, 0.296364, 0.303209, 0.310051,
0.316889, 0.323723, 0.330552, 0.337378, 0.3442, 0.351017, 0.357829, 0.364637, 0.371439,
0.378237, 0.385029, 0.391816, 0.398597, 0.405373, 0.412142, 0.418905, 0.425662, 0.432412,
0.439155, 0.445891, 0.452619, 0.45934, 0.466053, 0.472758, 0.479454, 0.486141, 0.49282,
0.499488, 0.506147, 0.512796, 0.519435, 0.526062, 0.532678, 0.539282, 0.545875, 0.552454,
0.559021, 0.565574, 0.572112, 0.578636, 0.585145, 0.591638, 0.598115, 0.604574, 0.611015 },

{0, 0.006918, 0.013836, 0.020754, 0.027671, 0.034589, 0.041506, 0.048422, 0.055339, 0.062254,
0.069169, 0.076084, 0.082997, 0.08991, 0.096822, 0.103733, 0.110643, 0.117552, 0.12446,
0.131366, 0.138272, 0.145175, 0.152078, 0.158979, 0.165878, 0.172775, 0.179671, 0.186565,
0.193457, 0.200347, 0.207234, 0.21412, 0.221003, 0.227884, 0.234762, 0.241638, 0.248511,
0.255381, 0.262248, 0.269112, 0.275973, 0.282831, 0.289685, 0.296536, 0.303384, 0.310227,
0.317067, 0.323902, 0.330734, 0.337561, 0.344383, 0.351201, 0.358015, 0.364823, 0.371626,
0.378424, 0.385216, 0.392003, 0.398784, 0.405558, 0.412327, 0.419089, 0.425844, 0.432593,
0.439334, 0.446068, 0.452794, 0.459512, 0.466222, 0.472923, 0.479615, 0.486299, 0.492973,
0.499637, 0.506291, 0.512934, 0.519566, 0.526188, 0.532797, 0.539394, 0.545979, 0.55255,
0.559108, 0.565652, 0.572181, 0.578695, 0.585193, 0.591675, 0.59814, 0.604587, 0.611015 },

{0, 0.006923, 0.013846, 0.020769, 0.027691, 0.034613, 0.041535, 0.048457, 0.055378, 0.062299,
0.069218, 0.076138, 0.083056, 0.089974, 0.09689, 0.103806, 0.110721, 0.117634, 0.124546,
0.131457, 0.138367, 0.145275, 0.152182, 0.159087, 0.165991, 0.172892, 0.179792, 0.18669,
0.193586, 0.200479, 0.207371, 0.21426, 0.221147, 0.228031, 0.234913, 0.241792, 0.248668,
0.255541, 0.262411, 0.269278, 0.276142, 0.283002, 0.289859, 0.296712, 0.303561, 0.310407,
0.317248, 0.324086, 0.330918, 0.337747, 0.344571, 0.35139, 0.358204, 0.365013, 0.371816,
0.378614, 0.385407, 0.392193, 0.398974, 0.405748, 0.412515, 0.419276, 0.42603, 0.432777,
0.439516, 0.446248, 0.452971, 0.459686, 0.466393, 0.473091, 0.47978, 0.486459, 0.493128,
0.499788, 0.506436, 0.513074, 0.519701, 0.526315, 0.532918, 0.539508, 0.546085, 0.552648,
0.559197, 0.565732, 0.572252, 0.578755, 0.585243, 0.591713, 0.598166, 0.6046, 0.611015 },

{0, 0.006928, 0.013856, 0.020784, 0.027711, 0.034639, 0.041566, 0.048492, 0.055418, 0.062344,
0.069268, 0.076193, 0.083116, 0.090038, 0.09696, 0.10388, 0.1108, 0.117718, 0.124635, 0.13155,
0.138465, 0.145377, 0.152288, 0.159198, 0.166106, 0.173011, 0.179915, 0.186817, 0.193717,
0.200615, 0.20751, 0.214403, 0.221293, 0.228181, 0.235066, 0.241948, 0.248828, 0.255704,
0.262577, 0.269447, 0.276313, 0.283176, 0.290036, 0.296891, 0.303743, 0.31059, 0.317433,
0.324272, 0.331107, 0.337937, 0.344762, 0.351582, 0.358397, 0.365206, 0.37201, 0.378808,
0.385601, 0.392387, 0.399167, 0.405941, 0.412707, 0.419467, 0.426219, 0.432964, 0.439702,
0.446431, 0.453152, 0.459864, 0.466568, 0.473262, 0.479947, 0.486622, 0.493287, 0.499941,
0.506585, 0.513217, 0.519837, 0.526446, 0.533041, 0.539624, 0.546193, 0.552748, 0.559288,
0.565813, 0.572323, 0.578816, 0.585293, 0.591751, 0.598192, 0.604614, 0.611015 },

{0, 0.006933, 0.013866, 0.020799, 0.027732, 0.034664, 0.041596, 0.048528, 0.055459, 0.06239,
0.06932, 0.076249, 0.083177, 0.090104, 0.097031, 0.103956, 0.11088, 0.117803, 0.124725,
0.131645, 0.138564, 0.145481, 0.152397, 0.159311, 0.166223, 0.173133, 0.180041, 0.186947,
0.193851, 0.200753, 0.207652, 0.214548, 0.221443, 0.228334, 0.235222, 0.242108, 0.248991,
0.25587, 0.262746, 0.269619, 0.276488, 0.283354, 0.290216, 0.297074, 0.303927, 0.310777,
0.317622, 0.324463, 0.331299, 0.33813, 0.344956, 0.351777, 0.358593, 0.365403, 0.372208,
0.379006, 0.385799, 0.392585, 0.399364, 0.406137, 0.412903, 0.419661, 0.426412, 0.433156,
0.439891, 0.446618, 0.453336, 0.460046, 0.466746, 0.473437, 0.480118, 0.486788, 0.493449,
0.500098, 0.506736, 0.513362, 0.519976, 0.526578, 0.533167, 0.539742, 0.546303, 0.552849,
0.55938, 0.565896, 0.572396, 0.578878, 0.585344, 0.591791, 0.598219, 0.604627, 0.611015 },

{0, 0.006938, 0.013877, 0.020815, 0.027753, 0.034691, 0.041628, 0.048565, 0.055501, 0.062437,
0.069372, 0.076306, 0.083239, 0.090172, 0.097103, 0.104033, 0.110962, 0.11789, 0.124817,
0.131742, 0.138665, 0.145587, 0.152507, 0.159426, 0.166342, 0.173257, 0.180169, 0.18708,
0.193988, 0.200893, 0.207796, 0.214697, 0.221595, 0.22849, 0.235382, 0.242271, 0.249157,
0.25604, 0.262919, 0.269795, 0.276667, 0.283535, 0.290399, 0.29726, 0.304116, 0.310967,
0.317815, 0.324657, 0.331495, 0.338327, 0.345155, 0.351977, 0.358793, 0.365604, 0.372409,
0.379208, 0.386, 0.392786, 0.399565, 0.406337, 0.413102, 0.419859, 0.426609, 0.43335, 0.440083,
0.446808, 0.453524, 0.46023, 0.466927, 0.473614, 0.480291, 0.486958, 0.493613, 0.500257,
0.50689, 0.51351, 0.520118, 0.526713, 0.533294, 0.539861, 0.546414, 0.552952, 0.559474,
0.56598, 0.57247, 0.578942, 0.585395, 0.59183, 0.598246, 0.604641, 0.611015 },

{0, 0.006944, 0.013888, 0.020831, 0.027774, 0.034717, 0.04166, 0.048602, 0.055544, 0.062485,
0.069425, 0.076364, 0.083303, 0.09024, 0.097177, 0.104112, 0.111046, 0.117979, 0.12491,
0.13184, 0.138769, 0.145695, 0.15262, 0.159543, 0.166464, 0.173383, 0.1803, 0.187215, 0.194127,
0.201037, 0.207944, 0.214848, 0.22175, 0.228649, 0.235545, 0.242437, 0.249326, 0.256212,
0.263095, 0.269974, 0.276849, 0.28372, 0.290587, 0.297449, 0.304308, 0.311161, 0.318011,
0.324855, 0.331694, 0.338528, 0.345357, 0.35218, 0.358998, 0.365809, 0.372614, 0.379413,
0.386206, 0.392991, 0.39977, 0.406541, 0.413305, 0.420061, 0.426809, 0.433548, 0.440279,
0.447002, 0.453715, 0.460418, 0.467112, 0.473795, 0.480468, 0.48713, 0.49378, 0.500419,
0.507046, 0.513661, 0.520262, 0.52685, 0.533424, 0.539983, 0.546528, 0.553057, 0.55957,
0.566066, 0.572545, 0.579006, 0.585448, 0.591871, 0.598274, 0.604655, 0.611015 },

{0, 0.006949, 0.013898, 0.020847, 0.027796, 0.034745, 0.041693, 0.04864, 0.055587, 0.062533,
0.069479, 0.076424, 0.083367, 0.09031, 0.097252, 0.104192, 0.111132, 0.118069, 0.125006,
0.131941, 0.138874, 0.145805, 0.152735, 0.159663, 0.166588, 0.173512, 0.180433, 0.187352,
0.194269, 0.201183, 0.208094, 0.215002, 0.221908, 0.228811, 0.23571, 0.242606, 0.249499,
0.256388, 0.263274, 0.270156, 0.277034, 0.283908, 0.290777, 0.297642, 0.304503, 0.311359,
0.31821, 0.325056, 0.331897, 0.338733, 0.345563, 0.352387, 0.359205, 0.366017, 0.372823,
0.379622, 0.386415, 0.3932, 0.399978, 0.406749, 0.413511, 0.420266, 0.427012, 0.43375,
0.440479, 0.447199, 0.453909, 0.460609, 0.467299, 0.473979, 0.480648, 0.487305, 0.493951,
0.500584, 0.507205, 0.513814, 0.520408, 0.526989, 0.533556, 0.540107, 0.546643, 0.553163,
0.559667, 0.566153, 0.572621, 0.579071, 0.585501, 0.591912, 0.598302, 0.60467, 0.611015 },

{0, 0.006955, 0.01391, 0.020864, 0.027818, 0.034772, 0.041726, 0.048679, 0.055631, 0.062583,
0.069534, 0.076484, 0.083433, 0.090381, 0.097328, 0.104274, 0.111219, 0.118162, 0.125103,
0.132043, 0.138981, 0.145918, 0.152852, 0.159785, 0.166715, 0.173643, 0.180569, 0.187492,
0.194413, 0.201332, 0.208247, 0.21516, 0.222069, 0.228976, 0.235879, 0.242779, 0.249675,
0.256568, 0.263457, 0.270341, 0.277222, 0.284099, 0.290971, 0.297839, 0.304702, 0.31156,
0.318414, 0.325262, 0.332104, 0.338941, 0.345772, 0.352598, 0.359417, 0.36623, 0.373036,
0.379835, 0.386627, 0.393412, 0.40019, 0.40696, 0.413721, 0.420475, 0.427219, 0.433955,
0.440682, 0.447399, 0.454106, 0.460804, 0.46749, 0.474166, 0.48083, 0.487483, 0.494124,
0.500752, 0.507367, 0.513969, 0.520557, 0.527131, 0.53369, 0.540233, 0.546761, 0.553272,
0.559765, 0.566241, 0.572699, 0.579137, 0.585556, 0.591954, 0.59833, 0.604684, 0.611015 },

{0, 0.00696, 0.013921, 0.020881, 0.027841, 0.034801, 0.04176, 0.048719, 0.055677, 0.062634,
0.06959, 0.076546, 0.083501, 0.090454, 0.097406, 0.104358, 0.111307, 0.118255, 0.125202,
0.132147, 0.13909, 0.146032, 0.152971, 0.159909, 0.166844, 0.173777, 0.180707, 0.187635,
0.194561, 0.201483, 0.208403, 0.21532, 0.222233, 0.229144, 0.236051, 0.242954, 0.249854,
0.25675, 0.263642, 0.270531, 0.277414, 0.284294, 0.291169, 0.298039, 0.304905, 0.311765,
0.31862, 0.32547, 0.332315, 0.339153, 0.345986, 0.352812, 0.359632, 0.366446, 0.373252,
0.380052, 0.386844, 0.393629, 0.400406, 0.407175, 0.413935, 0.420687, 0.42743, 0.434164,
0.440888, 0.447603, 0.454307, 0.461001, 0.467684, 0.474356, 0.481016, 0.487664, 0.4943,
0.500922, 0.507532, 0.514127, 0.520709, 0.527275, 0.533826, 0.540361, 0.54688, 0.553382,
0.559865, 0.566331, 0.572778, 0.579204, 0.585611, 0.591996, 0.598359, 0.604699, 0.611015 },

{0, 0.006966, 0.013932, 0.020898, 0.027864, 0.03483, 0.041794, 0.048759, 0.055723, 0.062685,
0.069648, 0.076609, 0.083569, 0.090528, 0.097486, 0.104442, 0.111397, 0.118351, 0.125303,
0.132253, 0.139202, 0.146148, 0.153093, 0.160035, 0.166975, 0.173913, 0.180848, 0.187781,
0.19471, 0.201637, 0.208562, 0.215483, 0.2224, 0.229315, 0.236226, 0.243133, 0.250036,
0.256936, 0.263832, 0.270723, 0.27761, 0.284492, 0.29137, 0.298243, 0.305111, 0.311974,
0.318831, 0.325683, 0.332529, 0.339369, 0.346203, 0.35303, 0.359851, 0.366665, 0.373472,
0.380272, 0.387064, 0.393849, 0.400625, 0.407393, 0.414153, 0.420903, 0.427645, 0.434376,
0.441098, 0.44781, 0.454512, 0.461202, 0.467882, 0.474549, 0.481205, 0.487848, 0.494479,
0.501096, 0.507699, 0.514288, 0.520862, 0.527421, 0.533964, 0.540491, 0.547001, 0.553493,
0.559967, 0.566422, 0.572858, 0.579273, 0.585667, 0.592039, 0.598388, 0.604714, 0.611015 },

{0, 0.006972, 0.013944, 0.020916, 0.027888, 0.034859, 0.04183, 0.0488, 0.055769, 0.062738,
0.069706, 0.076673, 0.083639, 0.090603, 0.097567, 0.104529, 0.111489, 0.118448, 0.125406,
0.132361, 0.139315, 0.146267, 0.153216, 0.160164, 0.167109, 0.174051, 0.180991, 0.187929,
0.194863, 0.201795, 0.208723, 0.215648, 0.22257, 0.229489, 0.236404, 0.243315, 0.250222,
0.257125, 0.264024, 0.270919, 0.277809, 0.284694, 0.291575, 0.298451, 0.305321, 0.312186,
0.319045, 0.325899, 0.332747, 0.339588, 0.346424, 0.353252, 0.360074, 0.366889, 0.373696,
0.380496, 0.387288, 0.394072, 0.400848, 0.407615, 0.414374, 0.421123, 0.427862, 0.434592,
0.441312, 0.448021, 0.45472, 0.461407, 0.468082, 0.474746, 0.481397, 0.488035, 0.49466,
0.501272, 0.507869, 0.514451, 0.521018, 0.52757, 0.534105, 0.540623, 0.547124, 0.553607,
0.56007, 0.566515, 0.572939, 0.579342, 0.585723, 0.592082, 0.598418, 0.604729, 0.611015 },

{0, 0.006978, 0.013956, 0.020934, 0.027912, 0.034889, 0.041865, 0.048842, 0.055817, 0.062792,
0.069765, 0.076738, 0.08371, 0.09068, 0.097649, 0.104617, 0.111583, 0.118548, 0.12551,
0.132471, 0.13943, 0.146387, 0.153342, 0.160295, 0.167245, 0.174192, 0.181137, 0.188079,
0.195018, 0.201955, 0.208887, 0.215817, 0.222743, 0.229666, 0.236585, 0.2435, 0.250411,
0.257318, 0.26422, 0.271118, 0.278011, 0.2849, 0.291783, 0.298662, 0.305535, 0.312402,
0.319264, 0.326119, 0.332969, 0.339812, 0.346648, 0.353478, 0.360301, 0.367116, 0.373924,
0.380724, 0.387516, 0.3943, 0.401075, 0.407841, 0.414599, 0.421346, 0.428084, 0.434812,
0.441529, 0.448235, 0.454931, 0.461614, 0.468286, 0.474945, 0.481592, 0.488225, 0.494845,
0.501451, 0.508041, 0.514617, 0.521177, 0.527721, 0.534248, 0.540757, 0.547249, 0.553722,
0.560175, 0.566609, 0.573021, 0.579412, 0.585781, 0.592127, 0.598448, 0.604745, 0.611015 },

{0, 0.006984, 0.013968, 0.020952, 0.027936, 0.034919, 0.041902, 0.048884, 0.055865, 0.062846,
0.069826, 0.076804, 0.083782, 0.090758, 0.097733, 0.104706, 0.111678, 0.118648, 0.125617,
0.132583, 0.139548, 0.14651, 0.15347, 0.160428, 0.167383, 0.174336, 0.181286, 0.188233,
0.195176, 0.202117, 0.209055, 0.215989, 0.222919, 0.229846, 0.236769, 0.243688, 0.250603,
0.257514, 0.26442, 0.271321, 0.278217, 0.285109, 0.291995, 0.298876, 0.305752, 0.312622,
0.319485, 0.326343, 0.333194, 0.340039, 0.346877, 0.353708, 0.360531, 0.367347, 0.374156,
0.380956, 0.387748, 0.394531, 0.401306, 0.408071, 0.414827, 0.421573, 0.428309, 0.435035,
0.44175, 0.448453, 0.455145, 0.461825, 0.468493, 0.475148, 0.48179, 0.488418, 0.495033,
0.501632, 0.508217, 0.514785, 0.521338, 0.527874, 0.534393, 0.540893, 0.547376, 0.553838,
0.560281, 0.566704, 0.573105, 0.579484, 0.585839, 0.592171, 0.598479, 0.60476, 0.611015 },

{0, 0.00699, 0.013981, 0.020971, 0.027961, 0.03495, 0.041939, 0.048927, 0.055915, 0.062901,
0.069887, 0.076872, 0.083855, 0.090837, 0.097818, 0.104797, 0.111775, 0.118751, 0.125725,
0.132697, 0.139667, 0.146635, 0.153601, 0.160564, 0.167524, 0.174482, 0.181437, 0.188389,
0.195337, 0.202283, 0.209225, 0.216164, 0.223099, 0.23003, 0.236957, 0.24388, 0.250799,
0.257713, 0.264622, 0.271527, 0.278427, 0.285322, 0.292211, 0.299095, 0.305973, 0.312845,
0.319711, 0.32657, 0.333424, 0.34027, 0.347109, 0.353941, 0.360766, 0.367582, 0.374391,
0.381191, 0.387983, 0.394766, 0.40154, 0.408305, 0.415059, 0.421804, 0.428538, 0.435261,
0.441974, 0.448674, 0.455363, 0.46204, 0.468704, 0.475354, 0.481991, 0.488614, 0.495223,
0.501816, 0.508394, 0.514956, 0.521502, 0.52803, 0.53454, 0.541031, 0.547504, 0.553957,
0.560389, 0.5668, 0.57319, 0.579556, 0.585899, 0.592217, 0.59851, 0.604776, 0.611015 },

{0, 0.006997, 0.013993, 0.02099, 0.027986, 0.034982, 0.041977, 0.048971, 0.055965, 0.062958,
0.06995, 0.07694, 0.08393, 0.090918, 0.097905, 0.10489, 0.111874, 0.118856, 0.125835, 0.132813,
0.139789, 0.146762, 0.153733, 0.160702, 0.167667, 0.17463, 0.18159, 0.188547, 0.195501,
0.202451, 0.209398, 0.216341, 0.223281, 0.230216, 0.237148, 0.244075, 0.250997, 0.257915,
0.264829, 0.271737, 0.27864, 0.285538, 0.29243, 0.299317, 0.306197, 0.313072, 0.31994,
0.326802, 0.333657, 0.340505, 0.347345, 0.354178, 0.361004, 0.367821, 0.37463, 0.381431,
0.388223, 0.395005, 0.401778, 0.408542, 0.415295, 0.422038, 0.42877, 0.435492, 0.442201,
0.448899, 0.455585, 0.462257, 0.468917, 0.475563, 0.482196, 0.488813, 0.495416, 0.502004,
0.508575, 0.51513, 0.521667, 0.528187, 0.534689, 0.541172, 0.547635, 0.554077, 0.560499,
0.566898, 0.573276, 0.579629, 0.585959, 0.592263, 0.598541, 0.604792, 0.611015 },

{0, 0.007003, 0.014006, 0.021009, 0.028012, 0.035014, 0.042015, 0.049016, 0.056016, 0.063015,
0.070013, 0.07701, 0.084006, 0.091, 0.097993, 0.104985, 0.111974, 0.118962, 0.125947, 0.132931,
0.139912, 0.146891, 0.153868, 0.160842, 0.167813, 0.174781, 0.181747, 0.188709, 0.195667,
0.202623, 0.209574, 0.216522, 0.223466, 0.230406, 0.237342, 0.244273, 0.251199, 0.258121,
0.265038, 0.27195, 0.278857, 0.285758, 0.292653, 0.299542, 0.306426, 0.313303, 0.320173,
0.327037, 0.333894, 0.340743, 0.347585, 0.354419, 0.361246, 0.368064, 0.374873, 0.381674,
0.388466, 0.395248, 0.40202, 0.408783, 0.415535, 0.422276, 0.429006, 0.435725, 0.442432,
0.449127, 0.455809, 0.462478, 0.469134, 0.475776, 0.482403, 0.489015, 0.495612, 0.502194,
0.508758, 0.515306, 0.521836, 0.528347, 0.53484, 0.541314, 0.547767, 0.554199, 0.56061,
0.566998, 0.573363, 0.579704, 0.58602, 0.59231, 0.598573, 0.604809, 0.611015 },

{0, 0.00701, 0.014019, 0.021029, 0.028038, 0.035046, 0.042054, 0.049062, 0.056068, 0.063074,
0.070078, 0.077081, 0.084083, 0.091084, 0.098083, 0.10508, 0.112076, 0.11907, 0.126061,
0.133051, 0.140038, 0.147023, 0.154005, 0.160985, 0.167961, 0.174935, 0.181905, 0.188873,
0.195837, 0.202797, 0.209753, 0.216706, 0.223655, 0.230599, 0.237539, 0.244474, 0.251405,
0.258331, 0.265251, 0.272167, 0.279077, 0.285981, 0.292879, 0.299772, 0.306658, 0.313537,
0.32041, 0.327276, 0.334134, 0.340986, 0.347829, 0.354664, 0.361492, 0.36831, 0.37512,
0.381921, 0.388713, 0.395494, 0.402266, 0.409028, 0.415778, 0.422518, 0.429246, 0.435963,
0.442667, 0.449359, 0.456037, 0.462703, 0.469354, 0.475991, 0.482614, 0.48922, 0.495812,
0.502386, 0.508944, 0.515484, 0.522006, 0.52851, 0.534994, 0.541458, 0.547901, 0.554323,
0.560722, 0.567099, 0.573451, 0.579779, 0.586081, 0.592357, 0.598605, 0.604825, 0.611015 },

{0, 0.007016, 0.014033, 0.021049, 0.028064, 0.035079, 0.042094, 0.049108, 0.056121, 0.063133,
0.070144, 0.077154, 0.084162, 0.091169, 0.098174, 0.105178, 0.11218, 0.11918, 0.126177,
0.133173, 0.140166, 0.147157, 0.154145, 0.16113, 0.168112, 0.175091, 0.182067, 0.18904,
0.196009, 0.202974, 0.209935, 0.216893, 0.223846, 0.230795, 0.237739, 0.244679, 0.251614,
0.258544, 0.265468, 0.272387, 0.279301, 0.286208, 0.29311, 0.300005, 0.306894, 0.313776,
0.320651, 0.327519, 0.334379, 0.341232, 0.348077, 0.354913, 0.361741, 0.368561, 0.375371,
0.382172, 0.388963, 0.395745, 0.402516, 0.409276, 0.416025, 0.422763, 0.42949, 0.436204,
0.442905, 0.449594, 0.456269, 0.46293, 0.469578, 0.47621, 0.482827, 0.489428, 0.496013,
0.502582, 0.509132, 0.515665, 0.522179, 0.528674, 0.535149, 0.541604, 0.548037, 0.554448,
0.560836, 0.567201, 0.573541, 0.579855, 0.586144, 0.592405, 0.598638, 0.604842, 0.611015 },

{0, 0.007023, 0.014046, 0.021069, 0.028091, 0.035113, 0.042134, 0.049155, 0.056175, 0.063193,
0.070211, 0.077227, 0.084242, 0.091255, 0.098267, 0.105277, 0.112285, 0.119291, 0.126295,
0.133297, 0.140296, 0.147293, 0.154286, 0.161277, 0.168265, 0.17525, 0.182231, 0.189209,
0.196183, 0.203154, 0.21012, 0.217083, 0.224041, 0.230994, 0.237943, 0.244887, 0.251826,
0.25876, 0.265688, 0.272611, 0.279528, 0.286439, 0.293344, 0.300242, 0.307133, 0.314018,
0.320895, 0.327765, 0.334628, 0.341482, 0.348328, 0.355166, 0.361995, 0.368815, 0.375626,
0.382427, 0.389218, 0.395999, 0.402769, 0.409528, 0.416276, 0.423012, 0.429737, 0.436448,
0.443147, 0.449832, 0.456504, 0.463162, 0.469804, 0.476432, 0.483044, 0.489639, 0.496218,
0.50278, 0.509324, 0.515849, 0.522355, 0.528841, 0.535307, 0.541752, 0.548175, 0.554575,
0.560952, 0.567304, 0.573631, 0.579933, 0.586207, 0.592454, 0.598671, 0.604859, 0.611015 },

{0, 0.00703, 0.01406, 0.021089, 0.028119, 0.035147, 0.042176, 0.049203, 0.056229, 0.063255,
0.070279, 0.077302, 0.084323, 0.091343, 0.098362, 0.105378, 0.112393, 0.119405, 0.126415,
0.133423, 0.140428, 0.147431, 0.154431, 0.161427, 0.168421, 0.175411, 0.182398, 0.189382,
0.196361, 0.203337, 0.210308, 0.217276, 0.224239, 0.231197, 0.23815, 0.245099, 0.252042,
0.25898, 0.265912, 0.272839, 0.279759, 0.286673, 0.293581, 0.300482, 0.307377, 0.314264,
0.321144, 0.328016, 0.33488, 0.341736, 0.348584, 0.355423, 0.362253, 0.369074, 0.375885,
0.382686, 0.389477, 0.396257, 0.403026, 0.409785, 0.416531, 0.423265, 0.429987, 0.436696,
0.443392, 0.450075, 0.456743, 0.463396, 0.470034, 0.476657, 0.483263, 0.489853, 0.496426,
0.502981, 0.509518, 0.516035, 0.522533, 0.529011, 0.535467, 0.541902, 0.548314, 0.554703,
0.561069, 0.567409, 0.573723, 0.580011, 0.586271, 0.592503, 0.598705, 0.604876, 0.611015 },

{0, 0.007037, 0.014074, 0.02111, 0.028147, 0.035182, 0.042217, 0.049251, 0.056285, 0.063317,
0.070348, 0.077378, 0.084406, 0.091433, 0.098458, 0.105481, 0.112502, 0.11952, 0.126537,
0.133551, 0.140562, 0.147571, 0.154577, 0.16158, 0.168579, 0.175575, 0.182568, 0.189557,
0.196542, 0.203523, 0.2105, 0.217472, 0.22444, 0.231403, 0.238361, 0.245314, 0.252261,
0.259203, 0.266139, 0.27307, 0.279994, 0.286911, 0.293823, 0.300727, 0.307624, 0.314514,
0.321396, 0.32827, 0.335136, 0.341994, 0.348843, 0.355684, 0.362514, 0.369336, 0.376147,
0.382948, 0.389739, 0.396519, 0.403288, 0.410044, 0.416789, 0.423522, 0.430242, 0.436948,
0.443641, 0.45032, 0.456984, 0.463634, 0.470267, 0.476885, 0.483486, 0.49007, 0.496637,
0.503185, 0.509714, 0.516224, 0.522713, 0.529182, 0.535629, 0.542054, 0.548456, 0.554834,
0.561187, 0.567515, 0.573816, 0.58009, 0.586336, 0.592552, 0.598739, 0.604893, 0.611015 },

{0, 0.007044, 0.014088, 0.021132, 0.028175, 0.035218, 0.04226, 0.049301, 0.056341, 0.06338,
0.070418, 0.077455, 0.08449, 0.091523, 0.098555, 0.105585, 0.112612, 0.119638, 0.126661,
0.133681, 0.140699, 0.147714, 0.154726, 0.161735, 0.16874, 0.175742, 0.18274, 0.189735,
0.196725, 0.203712, 0.210694, 0.217671, 0.224644, 0.231612, 0.238574, 0.245532, 0.252484,
0.25943, 0.26637, 0.273304, 0.280232, 0.287153, 0.294068, 0.300975, 0.307875, 0.314767,
0.321652, 0.328529, 0.335397, 0.342256, 0.349107, 0.355948, 0.36278, 0.369602, 0.376414,
0.383215, 0.390006, 0.396785, 0.403552, 0.410308, 0.417052, 0.423782, 0.4305, 0.437204,
0.443894, 0.450569, 0.45723, 0.463875, 0.470504, 0.477117, 0.483712, 0.49029, 0.49685,
0.503391, 0.509913, 0.516415, 0.522896, 0.529356, 0.535793, 0.542208, 0.548599, 0.554966,
0.561307, 0.567622, 0.57391, 0.580171, 0.586402, 0.592603, 0.598773, 0.604911, 0.611015 },

{0, 0.007051, 0.014102, 0.021153, 0.028204, 0.035254, 0.042303, 0.049351, 0.056399, 0.063445,
0.07049, 0.077533, 0.084575, 0.091616, 0.098654, 0.105691, 0.112725, 0.119757, 0.126786,
0.133813, 0.140838, 0.147859, 0.154877, 0.161892, 0.168903, 0.175911, 0.182915, 0.189916,
0.196912, 0.203904, 0.210891, 0.217874, 0.224851, 0.231824, 0.238792, 0.245754, 0.25271,
0.25966, 0.266605, 0.273543, 0.280474, 0.287399, 0.294317, 0.301227, 0.30813, 0.315025,
0.321912, 0.328791, 0.335661, 0.342522, 0.349374, 0.356217, 0.363049, 0.369872, 0.376684,
0.383486, 0.390276, 0.397055, 0.403821, 0.410576, 0.417318, 0.424046, 0.430762, 0.437463,
0.44415, 0.450822, 0.457479, 0.464119, 0.470744, 0.477351, 0.483941, 0.490513, 0.497067,
0.503601, 0.510115, 0.516609, 0.523081, 0.529532, 0.53596, 0.542364, 0.548744, 0.555099,
0.561429, 0.567731, 0.574006, 0.580252, 0.586468, 0.592654, 0.598808, 0.604929, 0.611015 },

{0, 0.007059, 0.014117, 0.021175, 0.028233, 0.03529, 0.042347, 0.049402, 0.056457, 0.06351,
0.070562, 0.077613, 0.084662, 0.091709, 0.098755, 0.105798, 0.112839, 0.119878, 0.126914,
0.133948, 0.140978, 0.148006, 0.155031, 0.162052, 0.169069, 0.176083, 0.183093, 0.190099,
0.197101, 0.204098, 0.211091, 0.218079, 0.225062, 0.23204, 0.239012, 0.245979, 0.25294,
0.259894, 0.266843, 0.273785, 0.28072, 0.287648, 0.294569, 0.301483, 0.308389, 0.315287,
0.322176, 0.329057, 0.335929, 0.342792, 0.349646, 0.356489, 0.363323, 0.370146, 0.376959,
0.38376, 0.39055, 0.397328, 0.404094, 0.410847, 0.417588, 0.424314, 0.431027, 0.437726,
0.44441, 0.451078, 0.457731, 0.464367, 0.470987, 0.477589, 0.484173, 0.490739, 0.497286,
0.503813, 0.51032, 0.516805, 0.523269, 0.52971, 0.536128, 0.542522, 0.548891, 0.555235,
0.561552, 0.567841, 0.574102, 0.580334, 0.586535, 0.592705, 0.598843, 0.604947, 0.611015 },

{0, 0.007066, 0.014132, 0.021198, 0.028263, 0.035327, 0.042391, 0.049454, 0.056516, 0.063577,
0.070636, 0.077694, 0.08475, 0.091805, 0.098857, 0.105907, 0.112955, 0.120001, 0.127044,
0.134084, 0.141122, 0.148156, 0.155187, 0.162214, 0.169238, 0.176258, 0.183274, 0.190286,
0.197293, 0.204296, 0.211295, 0.218288, 0.225276, 0.232259, 0.239236, 0.246207, 0.253173,
0.260132, 0.267085, 0.274031, 0.28097, 0.287901, 0.294826, 0.301743, 0.308651, 0.315552,
0.322444, 0.329327, 0.336201, 0.343066, 0.349921, 0.356766, 0.363601, 0.370424, 0.377237,
0.384039, 0.390828, 0.397606, 0.404371, 0.411123, 0.417861, 0.424586, 0.431296, 0.437992,
0.444673, 0.451338, 0.457986, 0.464618, 0.471233, 0.47783, 0.484409, 0.490968, 0.497508,
0.504028, 0.510527, 0.517004, 0.523459, 0.529891, 0.536299, 0.542682, 0.54904, 0.555372,
0.561676, 0.567953, 0.5742, 0.580417, 0.586603, 0.592757, 0.598878, 0.604965, 0.611015 },

{0, 0.007074, 0.014147, 0.02122, 0.028293, 0.035365, 0.042436, 0.049507, 0.056576, 0.063644,
0.070711, 0.077776, 0.08484, 0.091901, 0.098961, 0.106018, 0.113073, 0.120126, 0.127176,
0.134223, 0.141267, 0.148308, 0.155345, 0.162379, 0.169409, 0.176435, 0.183458, 0.190475,
0.197489, 0.204497, 0.211501, 0.2185, 0.225493, 0.232481, 0.239463, 0.246439, 0.253409,
0.260373, 0.26733, 0.27428, 0.281223, 0.288158, 0.295086, 0.302006, 0.308918, 0.315821,
0.322716, 0.329601, 0.336477, 0.343344, 0.3502, 0.357047, 0.363882, 0.370707, 0.37752,
0.384321, 0.39111, 0.397887, 0.404651, 0.411402, 0.418139, 0.424861, 0.431569, 0.438262,
0.44494, 0.451601, 0.458246, 0.464873, 0.471483, 0.478074, 0.484647, 0.4912, 0.497733,
0.504246, 0.510737, 0.517205, 0.523651, 0.530073, 0.536471, 0.542844, 0.549191, 0.55551,
0.561802, 0.568065, 0.574299, 0.580501, 0.586672, 0.59281, 0.598914, 0.604983, 0.611015 },

{0, 0.007081, 0.014162, 0.021243, 0.028324, 0.035403, 0.042482, 0.04956, 0.056637, 0.063713,
0.070787, 0.07786, 0.084931, 0.092, 0.099066, 0.106131, 0.113193, 0.120253, 0.12731, 0.134364,
0.141414, 0.148462, 0.155506, 0.162546, 0.169583, 0.176616, 0.183644, 0.190668, 0.197687,
0.204701, 0.211711, 0.218715, 0.225714, 0.232707, 0.239694, 0.246675, 0.25365, 0.260618,
0.267579, 0.274533, 0.28148, 0.288419, 0.295351, 0.302274, 0.309189, 0.316095, 0.322992,
0.32988, 0.336758, 0.343626, 0.350484, 0.357331, 0.364168, 0.370993, 0.377806, 0.384608,
0.391397, 0.398173, 0.404936, 0.411685, 0.41842, 0.425141, 0.431846, 0.438536, 0.44521,
0.451868, 0.458508, 0.465131, 0.471736, 0.478322, 0.484889, 0.491435, 0.497961, 0.504466,
0.510949, 0.517409, 0.523846, 0.530258, 0.536646, 0.543008, 0.549343, 0.555651, 0.56193,
0.568179, 0.574399, 0.580586, 0.586742, 0.592863, 0.59895, 0.605002, 0.611015 },

{0, 0.007089, 0.014178, 0.021267, 0.028355, 0.035442, 0.042529, 0.049615, 0.056699, 0.063783,
0.070864, 0.077944, 0.085023, 0.092099, 0.099174, 0.106245, 0.113315, 0.120382, 0.127446,
0.134507, 0.141564, 0.148619, 0.155669, 0.162716, 0.16976, 0.176798, 0.183833, 0.190863,
0.197888, 0.204909, 0.211924, 0.218934, 0.225938, 0.232936, 0.239928, 0.246914, 0.253894,
0.260866, 0.267832, 0.27479, 0.281741, 0.288684, 0.295619, 0.302545, 0.309463, 0.316372,
0.323272, 0.330162, 0.337042, 0.343912, 0.350771, 0.35762, 0.364457, 0.371283, 0.378097,
0.384898, 0.391687, 0.398462, 0.405224, 0.411972, 0.418705, 0.425424, 0.432127, 0.438814,
0.445484, 0.452138, 0.458774, 0.465393, 0.471992, 0.478573, 0.485133, 0.491673, 0.498192,
0.504689, 0.511164, 0.517616, 0.524043, 0.530446, 0.536823, 0.543174, 0.549497, 0.555792,
0.562059, 0.568295, 0.5745, 0.580672, 0.586812, 0.592917, 0.598987, 0.60502, 0.611015 },

{0, 0.007097, 0.014194, 0.02129, 0.028386, 0.035482, 0.042576, 0.04967, 0.056762, 0.063853,
0.070943, 0.078031, 0.085117, 0.092201, 0.099282, 0.106362, 0.113438, 0.120513, 0.127584,
0.134652, 0.141716, 0.148778, 0.155835, 0.162889, 0.169939, 0.176984, 0.184025, 0.191061,
0.198093, 0.205119, 0.21214, 0.219155, 0.226165, 0.233169, 0.240166, 0.247157, 0.254141,
0.261118, 0.268088, 0.275051, 0.282006, 0.288952, 0.295891, 0.302821, 0.309742, 0.316653,
0.323556, 0.330448, 0.33733, 0.344202, 0.351063, 0.357913, 0.364751, 0.371577, 0.378391,
0.385193, 0.391981, 0.398756, 0.405516, 0.412263, 0.418994, 0.42571, 0.432411, 0.439095,
0.445762, 0.452412, 0.459044, 0.465657, 0.472252, 0.478826, 0.485381, 0.491914, 0.498426,
0.504915, 0.511382, 0.517825, 0.524243, 0.530635, 0.537002, 0.543341, 0.549653, 0.555936,
0.562189, 0.568411, 0.574602, 0.580759, 0.586883, 0.592972, 0.599024, 0.605039, 0.611015 },

{0, 0.007105, 0.01421, 0.021315, 0.028419, 0.035522, 0.042624, 0.049726, 0.056826, 0.063925,
0.071022, 0.078118, 0.085212, 0.092303, 0.099393, 0.10648, 0.113564, 0.120645, 0.127724,
0.134799, 0.141871, 0.148939, 0.156004, 0.163064, 0.170121, 0.177173, 0.18422, 0.191263,
0.1983, 0.205332, 0.212359, 0.21938, 0.226396, 0.233405, 0.240407, 0.247403, 0.254392,
0.261374, 0.268349, 0.275315, 0.282274, 0.289225, 0.296167, 0.3031, 0.310024, 0.316939,
0.323844, 0.330738, 0.337623, 0.344496, 0.351359, 0.35821, 0.365049, 0.371876, 0.37869,
0.385491, 0.392279, 0.399053, 0.405813, 0.412558, 0.419287, 0.426001, 0.432699, 0.43938,
0.446044, 0.452689, 0.459317, 0.465926, 0.472515, 0.479084, 0.485632, 0.492158, 0.498663,
0.505144, 0.511602, 0.518036, 0.524445, 0.530827, 0.537183, 0.543511, 0.549811, 0.556081,
0.562321, 0.568529, 0.574705, 0.580847, 0.586955, 0.593027, 0.599062, 0.605058, 0.611015 },

{0, 0.007113, 0.014226, 0.021339, 0.028451, 0.035563, 0.042673, 0.049783, 0.056891, 0.063998,
0.071103, 0.078207, 0.085308, 0.092408, 0.099505, 0.106599, 0.113691, 0.12078, 0.127866,
0.134949, 0.142028, 0.149103, 0.156175, 0.163242, 0.170305, 0.177364, 0.184418, 0.191467,
0.198511, 0.205549, 0.212582, 0.219609, 0.22663, 0.233644, 0.240652, 0.247653, 0.254647,
0.261634, 0.268613, 0.275584, 0.282547, 0.289501, 0.296447, 0.303383, 0.310311, 0.317228,
0.324136, 0.331033, 0.337919, 0.344795, 0.351659, 0.358511, 0.365351, 0.372178, 0.378993,
0.385794, 0.392581, 0.399355, 0.406113, 0.412856, 0.419584, 0.426296, 0.432991, 0.439668,
0.446329, 0.45297, 0.459594, 0.466197, 0.472781, 0.479344, 0.485886, 0.492405, 0.498902,
0.505376, 0.511825, 0.51825, 0.524649, 0.531021, 0.537366, 0.543683, 0.54997, 0.556228,
0.562454, 0.568648, 0.574809, 0.580936, 0.587028, 0.593083, 0.5991, 0.605078, 0.611015 },

{0, 0.007122, 0.014243, 0.021364, 0.028484, 0.035604, 0.042723, 0.049841, 0.056957, 0.064072,
0.071185, 0.078297, 0.085406, 0.092514, 0.099619, 0.106721, 0.11382, 0.120917, 0.12801, 0.1351,
0.142187, 0.14927, 0.156348, 0.163423, 0.170493, 0.177558, 0.184619, 0.191674, 0.198724,
0.205769, 0.212808, 0.21984, 0.226867, 0.233887, 0.2409, 0.247907, 0.254906, 0.261897,
0.268881, 0.275856, 0.282823, 0.289781, 0.296731, 0.303671, 0.310601, 0.317522, 0.324432,
0.331331, 0.33822, 0.345097, 0.351963, 0.358816, 0.365657, 0.372485, 0.3793, 0.386101,
0.392888, 0.39966, 0.406417, 0.413159, 0.419885, 0.426594, 0.433286, 0.439961, 0.446617,
0.453255, 0.459874, 0.466472, 0.47305, 0.479607, 0.486143, 0.492655, 0.499145, 0.50561,
0.512051, 0.518466, 0.524856, 0.531218, 0.537551, 0.543857, 0.550132, 0.556376, 0.562589,
0.568769, 0.574915, 0.581026, 0.587101, 0.593139, 0.599138, 0.605097, 0.611015 },

{0, 0.00713, 0.01426, 0.021389, 0.028518, 0.035646, 0.042773, 0.049899, 0.057024, 0.064147,
0.071269, 0.078388, 0.085506, 0.092621, 0.099734, 0.106844, 0.113952, 0.121056, 0.128157,
0.135254, 0.142348, 0.149438, 0.156524, 0.163606, 0.170683, 0.177755, 0.184822, 0.191884,
0.198941, 0.205992, 0.213037, 0.220076, 0.227108, 0.234134, 0.241152, 0.248164, 0.255168,
0.262164, 0.269152, 0.276132, 0.283103, 0.290066, 0.297019, 0.303962, 0.310896, 0.317819,
0.324732, 0.331634, 0.338525, 0.345404, 0.352271, 0.359125, 0.365967, 0.372796, 0.379611,
0.386412, 0.393198, 0.39997, 0.406726, 0.413466, 0.420189, 0.426896, 0.433586, 0.440257,
0.44691, 0.453543, 0.460157, 0.466751, 0.473323, 0.479874, 0.486403, 0.492908, 0.49939,
0.505847, 0.51228, 0.518686, 0.525065, 0.531416, 0.537739, 0.544032, 0.550295, 0.556526,
0.562725, 0.568891, 0.575022, 0.581117, 0.587175, 0.593195, 0.599176, 0.605117, 0.611015 },

{0, 0.007138, 0.014277, 0.021415, 0.028552, 0.035689, 0.042824, 0.049959, 0.057092, 0.064223,
0.071353, 0.078481, 0.085607, 0.09273, 0.099851, 0.10697, 0.114085, 0.121197, 0.128306,
0.135411, 0.142512, 0.14961, 0.156703, 0.163792, 0.170876, 0.177955, 0.185029, 0.192098,
0.199161, 0.206218, 0.213269, 0.220314, 0.227352, 0.234384, 0.241408, 0.248425, 0.255434,
0.262435, 0.269428, 0.276412, 0.283388, 0.290354, 0.297311, 0.304258, 0.311195, 0.318121,
0.325037, 0.331941, 0.338834, 0.345715, 0.352583, 0.359439, 0.366282, 0.373111, 0.379926,
0.386727, 0.393513, 0.400283, 0.407038, 0.413776, 0.420498, 0.427202, 0.433889, 0.440557,
0.447206, 0.453835, 0.460444, 0.467033, 0.473599, 0.480144, 0.486666, 0.493164, 0.499638,
0.506087, 0.512511, 0.518907, 0.525276, 0.531617, 0.537928, 0.54421, 0.55046, 0.556678,
0.562863, 0.569014, 0.575129, 0.581208, 0.58725, 0.593253, 0.599215, 0.605137, 0.611015 },

{0, 0.007147, 0.014294, 0.021441, 0.028587, 0.035732, 0.042876, 0.050019, 0.057161, 0.064301,
0.071439, 0.078575, 0.085709, 0.092841, 0.09997, 0.107097, 0.11422, 0.12134, 0.128456,
0.135569, 0.142678, 0.149783, 0.156884, 0.16398, 0.171071, 0.178158, 0.185239, 0.192314,
0.199384, 0.206448, 0.213505, 0.220556, 0.2276, 0.234637, 0.241667, 0.248689, 0.255704,
0.26271, 0.269707, 0.276696, 0.283676, 0.290646, 0.297607, 0.304557, 0.311498, 0.318427,
0.325345, 0.332252, 0.339147, 0.34603, 0.3529, 0.359757, 0.3666, 0.37343, 0.380245, 0.387046,
0.393831, 0.400601, 0.407354, 0.414091, 0.420811, 0.427512, 0.434196, 0.44086, 0.447505,
0.454131, 0.460735, 0.467318, 0.473879, 0.480417, 0.486932, 0.493423, 0.49989, 0.50633,
0.512744, 0.519131, 0.52549, 0.53182, 0.53812, 0.544389, 0.550626, 0.556831, 0.563002,
0.569138, 0.575238, 0.581301, 0.587326, 0.593311, 0.599255, 0.605157, 0.611015 },

{0, 0.007156, 0.014312, 0.021467, 0.028622, 0.035776, 0.042929, 0.05008, 0.057231, 0.064379,
0.071526, 0.078671, 0.085813, 0.092954, 0.100091, 0.107225, 0.114357, 0.121485, 0.12861,
0.13573, 0.142847, 0.14996, 0.157068, 0.164171, 0.17127, 0.178363, 0.185451, 0.192534, 0.19961,
0.20668, 0.213744, 0.220801, 0.227852, 0.234894, 0.24193, 0.248958, 0.255977, 0.262988,
0.269991, 0.276984, 0.283968, 0.290943, 0.297907, 0.304861, 0.311805, 0.318737, 0.325658,
0.332567, 0.339464, 0.346349, 0.35322, 0.360079, 0.366923, 0.373753, 0.380569, 0.387369,
0.394154, 0.400923, 0.407675, 0.41441, 0.421127, 0.427826, 0.434507, 0.441168, 0.447809,
0.45443, 0.461029, 0.467607, 0.474162, 0.480694, 0.487202, 0.493685, 0.500144, 0.506576,
0.51298, 0.519358, 0.525706, 0.532025, 0.538313, 0.54457, 0.550795, 0.556986, 0.563143,
0.569264, 0.575348, 0.581395, 0.587402, 0.593369, 0.599295, 0.605177, 0.611015 },

{0, 0.007165, 0.01433, 0.021494, 0.028657, 0.03582, 0.042982, 0.050142, 0.057302, 0.064459,
0.071614, 0.078768, 0.085919, 0.093068, 0.100213, 0.107356, 0.114496, 0.121632, 0.128765,
0.135894, 0.143018, 0.150139, 0.157254, 0.164365, 0.171471, 0.178572, 0.185667, 0.192756,
0.19984, 0.206916, 0.213987, 0.22105, 0.228106, 0.235155, 0.242196, 0.24923, 0.256254,
0.263271, 0.270278, 0.277276, 0.284264, 0.291243, 0.298211, 0.305169, 0.312116, 0.319051,
0.325975, 0.332887, 0.339786, 0.346672, 0.353545, 0.360405, 0.36725, 0.374081, 0.380897,
0.387697, 0.394481, 0.401249, 0.407999, 0.414732, 0.421448, 0.428144, 0.434821, 0.441479,
0.448116, 0.454732, 0.461327, 0.467899, 0.474448, 0.480974, 0.487475, 0.493951, 0.500401,
0.506824, 0.513219, 0.519587, 0.525925, 0.532232, 0.538509, 0.544754, 0.550965, 0.557142,
0.563285, 0.569391, 0.575459, 0.581489, 0.587479, 0.593428, 0.599335, 0.605198, 0.611015 },

{0, 0.007174, 0.014348, 0.021521, 0.028694, 0.035865, 0.043036, 0.050206, 0.057374, 0.06454,
0.071704, 0.078866, 0.086026, 0.093183, 0.100338, 0.107489, 0.114637, 0.121782, 0.128922,
0.136059, 0.143192, 0.15032, 0.157444, 0.164562, 0.171676, 0.178784, 0.185886, 0.192982,
0.200072, 0.207156, 0.214233, 0.221303, 0.228365, 0.23542, 0.242467, 0.249505, 0.256536,
0.263557, 0.270569, 0.277572, 0.284565, 0.291547, 0.29852, 0.305481, 0.312431, 0.31937,
0.326296, 0.33321, 0.340112, 0.347, 0.353875, 0.360735, 0.367581, 0.374413, 0.381228, 0.388028,
0.394812, 0.401579, 0.408328, 0.415059, 0.421772, 0.428466, 0.43514, 0.441794, 0.448427,
0.455038, 0.461628, 0.468194, 0.474738, 0.481256, 0.48775, 0.494219, 0.50066, 0.507075,
0.513461, 0.519818, 0.526146, 0.532442, 0.538707, 0.544939, 0.551137, 0.5573, 0.563428,
0.569519, 0.575571, 0.581584, 0.587557, 0.593488, 0.599375, 0.605218, 0.611015 },

{0, 0.007183, 0.014366, 0.021548, 0.02873, 0.035911, 0.043091, 0.05027, 0.057447, 0.064622,
0.071795, 0.078966, 0.086135, 0.093301, 0.100464, 0.107623, 0.11478, 0.121933, 0.129082,
0.136227, 0.143368, 0.150504, 0.157636, 0.164762, 0.171883, 0.178998, 0.186108, 0.193211,
0.200308, 0.207399, 0.214482, 0.221558, 0.228627, 0.235688, 0.242741, 0.249785, 0.256821,
0.263847, 0.270864, 0.277872, 0.284869, 0.291856, 0.298832, 0.305797, 0.312751, 0.319692,
0.326622, 0.333538, 0.340442, 0.347332, 0.354208, 0.36107, 0.367917, 0.374749, 0.381565,
0.388364, 0.395147, 0.401913, 0.40866, 0.41539, 0.4221, 0.428791, 0.435462, 0.442112, 0.448741,
0.455348, 0.461933, 0.468494, 0.47503, 0.481543, 0.488029, 0.49449, 0.500923, 0.507329,
0.513705, 0.520052, 0.526369, 0.532654, 0.538907, 0.545126, 0.551311, 0.55746, 0.563573,
0.569648, 0.575684, 0.58168, 0.587635, 0.593548, 0.599416, 0.605239, 0.611015 },

{0, 0.007192, 0.014385, 0.021576, 0.028767, 0.035958, 0.043147, 0.050334, 0.057521, 0.064705,
0.071887, 0.079067, 0.086245, 0.09342, 0.100591, 0.10776, 0.114925, 0.122087, 0.129244,
0.136398, 0.143547, 0.150691, 0.15783, 0.164964, 0.172093, 0.179216, 0.186333, 0.193443,
0.200548, 0.207645, 0.214735, 0.221818, 0.228893, 0.23596, 0.243019, 0.250069, 0.25711,
0.264141, 0.271164, 0.278176, 0.285178, 0.292169, 0.299149, 0.306118, 0.313075, 0.320019,
0.326952, 0.333871, 0.340777, 0.347669, 0.354546, 0.361409, 0.368257, 0.375089, 0.381905,
0.388704, 0.395486, 0.402251, 0.408997, 0.415725, 0.422433, 0.429121, 0.435789, 0.442435,
0.44906, 0.455662, 0.462241, 0.468796, 0.475327, 0.481832, 0.488311, 0.494764, 0.501189,
0.507585, 0.513952, 0.520289, 0.526594, 0.532868, 0.539108, 0.545315, 0.551486, 0.557621,
0.563719, 0.569779, 0.575798, 0.581778, 0.587715, 0.593608, 0.599457, 0.60526, 0.611015 },

{0, 0.007202, 0.014404, 0.021605, 0.028805, 0.036005, 0.043203, 0.0504, 0.057596, 0.064789,
0.071981, 0.07917, 0.086356, 0.09354, 0.100721, 0.107898, 0.115072, 0.122242, 0.129409,
0.13657, 0.143728, 0.15088, 0.158027, 0.16517, 0.172306, 0.179437, 0.186561, 0.193679, 0.20079,
0.207895, 0.214991, 0.222081, 0.229162, 0.236235, 0.2433, 0.250356, 0.257403, 0.26444,
0.271467, 0.278484, 0.28549, 0.292486, 0.29947, 0.306442, 0.313403, 0.320351, 0.327286,
0.334207, 0.341115, 0.348009, 0.354888, 0.361753, 0.368601, 0.375434, 0.38225, 0.389049,
0.39583, 0.402593, 0.409338, 0.416064, 0.422769, 0.429454, 0.436119, 0.442761, 0.449382,
0.455979, 0.462553, 0.469102, 0.475626, 0.482125, 0.488597, 0.495041, 0.501457, 0.507844,
0.514201, 0.520528, 0.526822, 0.533084, 0.539312, 0.545506, 0.551663, 0.557784, 0.563867,
0.56991, 0.575914, 0.581875, 0.587794, 0.593669, 0.599499, 0.605281, 0.611015 },

{0, 0.007211, 0.014423, 0.021633, 0.028844, 0.036053, 0.043261, 0.050467, 0.057672, 0.064875,
0.072076, 0.079274, 0.08647, 0.093663, 0.100852, 0.108039, 0.115222, 0.122401, 0.129575,
0.136746, 0.143911, 0.151072, 0.158228, 0.165378, 0.172522, 0.17966, 0.186792, 0.193918,
0.201036, 0.208148, 0.215251, 0.222347, 0.229435, 0.236515, 0.243586, 0.250647, 0.257699,
0.264742, 0.271774, 0.278796, 0.285807, 0.292807, 0.299795, 0.306771, 0.313735, 0.320686,
0.327624, 0.334548, 0.341459, 0.348354, 0.355235, 0.3621, 0.36895, 0.375783, 0.382599,
0.389397, 0.396178, 0.40294, 0.409683, 0.416406, 0.42311, 0.429792, 0.436453, 0.443091,
0.449707, 0.4563, 0.462868, 0.469412, 0.475929, 0.482421, 0.488885, 0.495321, 0.501729,
0.508106, 0.514454, 0.520769, 0.527053, 0.533303, 0.539518, 0.545698, 0.551842, 0.557948,
0.564016, 0.570043, 0.57603, 0.581974, 0.587875, 0.593731, 0.599541, 0.605303, 0.611015 },

{0, 0.007221, 0.014442, 0.021663, 0.028882, 0.036101, 0.043319, 0.050535, 0.057749, 0.064962,
0.072172, 0.07938, 0.086585, 0.093787, 0.100986, 0.108181, 0.115373, 0.122561, 0.129744,
0.136923, 0.144097, 0.151267, 0.15843, 0.165589, 0.172741, 0.179887, 0.187027, 0.19416,
0.201286, 0.208404, 0.215515, 0.222618, 0.229712, 0.236798, 0.243875, 0.250942, 0.258,
0.265048, 0.272086, 0.279112, 0.286128, 0.293132, 0.300125, 0.307105, 0.314072, 0.321026,
0.327967, 0.334894, 0.341806, 0.348704, 0.355586, 0.362452, 0.369303, 0.376136, 0.382952,
0.38975, 0.39653, 0.403291, 0.410032, 0.416754, 0.423454, 0.430133, 0.436791, 0.443425,
0.450037, 0.456624, 0.463187, 0.469724, 0.476236, 0.48272, 0.489176, 0.495604, 0.502003,
0.508371, 0.514708, 0.521013, 0.527285, 0.533523, 0.539726, 0.545893, 0.552023, 0.558114,
0.564166, 0.570178, 0.576147, 0.582074, 0.587956, 0.593793, 0.599583, 0.605324, 0.611015 },

{0, 0.007231, 0.014462, 0.021692, 0.028922, 0.03615, 0.043378, 0.050603, 0.057828, 0.06505,
0.072269, 0.079487, 0.086701, 0.093913, 0.101121, 0.108326, 0.115526, 0.122723, 0.129916,
0.137103, 0.144286, 0.151464, 0.158636, 0.165803, 0.172963, 0.180117, 0.187265, 0.194405,
0.201538, 0.208664, 0.215782, 0.222892, 0.229993, 0.237085, 0.244168, 0.251241, 0.258305,
0.265358, 0.272401, 0.279433, 0.286453, 0.293462, 0.300458, 0.307442, 0.314413, 0.321371,
0.328314, 0.335244, 0.342158, 0.349058, 0.355941, 0.362809, 0.36966, 0.376494, 0.38331,
0.390107, 0.396886, 0.403646, 0.410386, 0.417105, 0.423803, 0.430479, 0.437133, 0.443763,
0.45037, 0.456952, 0.46351, 0.470041, 0.476545, 0.483022, 0.489471, 0.495891, 0.50228,
0.508639, 0.514966, 0.52126, 0.52752, 0.533746, 0.539936, 0.54609, 0.552205, 0.558282,
0.564318, 0.570313, 0.576266, 0.582175, 0.588039, 0.593856, 0.599625, 0.605346, 0.611015 },

{0, 0.007241, 0.014482, 0.021722, 0.028962, 0.0362, 0.043437, 0.050673, 0.057907, 0.065139,
0.072368, 0.079595, 0.086819, 0.09404, 0.101258, 0.108472, 0.115682, 0.122888, 0.130089,
0.137286, 0.144478, 0.151664, 0.158845, 0.16602, 0.173188, 0.18035, 0.187506, 0.194654,
0.201795, 0.208928, 0.216053, 0.223169, 0.230277, 0.237376, 0.244465, 0.251545, 0.258614,
0.265673, 0.272721, 0.279758, 0.286783, 0.293796, 0.300796, 0.307784, 0.314759, 0.321719,
0.328666, 0.335598, 0.342515, 0.349416, 0.356301, 0.36317, 0.370022, 0.376856, 0.383672,
0.390469, 0.397247, 0.404005, 0.410743, 0.41746, 0.424155, 0.430828, 0.437478, 0.444105,
0.450707, 0.457284, 0.463836, 0.470361, 0.476858, 0.483328, 0.489769, 0.49618, 0.50256,
0.508909, 0.515226, 0.521509, 0.527758, 0.533971, 0.540148, 0.546288, 0.552389, 0.558451,
0.564471, 0.57045, 0.576385, 0.582276, 0.588121, 0.593919, 0.599668, 0.605368, 0.611015 },

{0, 0.007251, 0.014502, 0.021753, 0.029002, 0.036251, 0.043498, 0.050744, 0.057988, 0.065229,
0.072469, 0.079705, 0.086939, 0.09417, 0.101397, 0.10862, 0.11584, 0.123055, 0.130266,
0.137471, 0.144672, 0.151867, 0.159056, 0.166239, 0.173416, 0.180587, 0.18775, 0.194906,
0.202054, 0.209195, 0.216327, 0.22345, 0.230565, 0.23767, 0.244766, 0.251852, 0.258927,
0.265991, 0.273045, 0.280087, 0.287117, 0.294134, 0.301139, 0.308131, 0.315109, 0.322073,
0.329022, 0.335957, 0.342876, 0.349779, 0.356665, 0.363535, 0.370388, 0.377222, 0.384038,
0.390835, 0.397612, 0.404369, 0.411105, 0.417819, 0.424512, 0.431182, 0.437828, 0.44445,
0.451048, 0.45762, 0.464165, 0.470684, 0.477175, 0.483637, 0.49007, 0.496472, 0.502843,
0.509182, 0.515488, 0.52176, 0.527997, 0.534198, 0.540362, 0.546488, 0.552575, 0.558621,
0.564626, 0.570588, 0.576506, 0.582379, 0.588205, 0.593983, 0.599712, 0.60539, 0.611015 },

{0, 0.007261, 0.014523, 0.021783, 0.029043, 0.036302, 0.043559, 0.050815, 0.058069, 0.065321,
0.07257, 0.079817, 0.087061, 0.094301, 0.101538, 0.108771, 0.116, 0.123224, 0.130444, 0.137659,
0.144868, 0.152072, 0.15927, 0.166462, 0.173648, 0.180826, 0.187997, 0.195161, 0.202317,
0.209465, 0.216605, 0.223736, 0.230857, 0.237969, 0.245071, 0.252163, 0.259244, 0.266314,
0.273373, 0.28042, 0.287455, 0.294477, 0.301486, 0.308481, 0.315463, 0.32243, 0.329383,
0.33632, 0.343241, 0.350146, 0.357034, 0.363905, 0.370758, 0.377593, 0.384409, 0.391205,
0.397981, 0.404737, 0.411471, 0.418183, 0.424873, 0.431539, 0.438182, 0.4448, 0.451392,
0.457959, 0.464499, 0.471011, 0.477495, 0.483949, 0.490374, 0.496767, 0.503129, 0.509458,
0.515753, 0.522014, 0.528239, 0.534428, 0.540578, 0.54669, 0.552762, 0.558793, 0.564782,
0.570727, 0.576627, 0.582482, 0.588289, 0.594047, 0.599755, 0.605412, 0.611015 },

{0, 0.007272, 0.014544, 0.021815, 0.029085, 0.036354, 0.043622, 0.050888, 0.058152, 0.065414,
0.072673, 0.07993, 0.087184, 0.094434, 0.101681, 0.108923, 0.116162, 0.123396, 0.130625,
0.137849, 0.145068, 0.152281, 0.159488, 0.166688, 0.173882, 0.181069, 0.188248, 0.19542,
0.202584, 0.20974, 0.216887, 0.224024, 0.231153, 0.238272, 0.24538, 0.252478, 0.259565,
0.266641, 0.273705, 0.280757, 0.287797, 0.294824, 0.301837, 0.308837, 0.315822, 0.322792,
0.329748, 0.336687, 0.343611, 0.350518, 0.357407, 0.364279, 0.371133, 0.377968, 0.384784,
0.39158, 0.398355, 0.405109, 0.411841, 0.418551, 0.425238, 0.431901, 0.438539, 0.445153,
0.451741, 0.458302, 0.464836, 0.471341, 0.477818, 0.484265, 0.490681, 0.497065, 0.503418,
0.509737, 0.516021, 0.52227, 0.528483, 0.534659, 0.540796, 0.546894, 0.552951, 0.558967,
0.564939, 0.570867, 0.57675, 0.582586, 0.588374, 0.594112, 0.599799, 0.605434, 0.611015 },

{0, 0.007282, 0.014565, 0.021846, 0.029127, 0.036407, 0.043685, 0.050961, 0.058236, 0.065508,
0.072778, 0.080045, 0.087309, 0.094569, 0.101826, 0.109078, 0.116326, 0.12357, 0.130809,
0.138042, 0.14527, 0.152492, 0.159708, 0.166917, 0.17412, 0.181315, 0.188503, 0.195683,
0.202854, 0.210018, 0.217172, 0.224317, 0.231453, 0.238578, 0.245693, 0.252798, 0.259891,
0.266972, 0.274042, 0.281099, 0.288144, 0.295175, 0.302193, 0.309196, 0.316185, 0.323159,
0.330117, 0.33706, 0.343985, 0.350894, 0.357785, 0.364658, 0.371513, 0.378348, 0.385163,
0.391959, 0.398733, 0.405485, 0.412215, 0.418923, 0.425607, 0.432266, 0.438901, 0.44551,
0.452093, 0.458648, 0.465176, 0.471675, 0.478144, 0.484583, 0.490991, 0.497367, 0.503709,
0.510018, 0.516292, 0.522529, 0.52873, 0.534893, 0.541016, 0.5471, 0.553142, 0.559142,
0.565098, 0.571009, 0.576873, 0.582691, 0.588459, 0.594177, 0.599844, 0.605457, 0.611015 },

{0, 0.007293, 0.014586, 0.021878, 0.02917, 0.03646, 0.043749, 0.051036, 0.058321, 0.065604,
0.072884, 0.080161, 0.087435, 0.094706, 0.101972, 0.109235, 0.116493, 0.123746, 0.130995,
0.138238, 0.145475, 0.152706, 0.159931, 0.167149, 0.17436, 0.181564, 0.18876, 0.195949,
0.203128, 0.210299, 0.217461, 0.224614, 0.231756, 0.238889, 0.24601, 0.253121, 0.26022,
0.267308, 0.274383, 0.281446, 0.288495, 0.295531, 0.302553, 0.30956, 0.316553, 0.32353,
0.330491, 0.337436, 0.344364, 0.351275, 0.358168, 0.365042, 0.371897, 0.378732, 0.385548,
0.392342, 0.399115, 0.405866, 0.412594, 0.419299, 0.42598, 0.432636, 0.439267, 0.445871,
0.452449, 0.458999, 0.46552, 0.472012, 0.478474, 0.484905, 0.491305, 0.497671, 0.504004,
0.510302, 0.516565, 0.522791, 0.528979, 0.535129, 0.541238, 0.547308, 0.553334, 0.559318,
0.565258, 0.571151, 0.576998, 0.582796, 0.588545, 0.594243, 0.599888, 0.60548, 0.611015 },

{0, 0.007304, 0.014608, 0.021911, 0.029213, 0.036514, 0.043814, 0.051112, 0.058407, 0.065701,
0.072991, 0.080279, 0.087563, 0.094844, 0.102121, 0.109394, 0.116662, 0.123925, 0.131183,
0.138436, 0.145682, 0.152923, 0.160157, 0.167384, 0.174604, 0.181817, 0.189021, 0.196218,
0.203406, 0.210585, 0.217754, 0.224914, 0.232064, 0.239203, 0.246332, 0.253449, 0.260554,
0.267648, 0.274728, 0.281796, 0.288851, 0.295891, 0.302918, 0.309929, 0.316925, 0.323906,
0.33087, 0.337818, 0.344748, 0.35166, 0.358555, 0.36543, 0.372285, 0.379121, 0.385936, 0.39273,
0.399502, 0.406251, 0.412977, 0.419679, 0.426357, 0.43301, 0.439636, 0.446236, 0.452809,
0.459353, 0.465868, 0.472353, 0.478808, 0.485231, 0.491621, 0.497978, 0.504301, 0.510589,
0.51684, 0.523054, 0.52923, 0.535367, 0.541463, 0.547517, 0.553529, 0.559496, 0.565419,
0.571295, 0.577124, 0.582903, 0.588632, 0.594309, 0.599933, 0.605502, 0.611015 },

{0, 0.007315, 0.01463, 0.021944, 0.029257, 0.036569, 0.04388, 0.051188, 0.058495, 0.065799,
0.0731, 0.080399, 0.087693, 0.094985, 0.102272, 0.109555, 0.116833, 0.124106, 0.131374,
0.138636, 0.145893, 0.153143, 0.160386, 0.167622, 0.174851, 0.182073, 0.189286, 0.196491,
0.203687, 0.210874, 0.218051, 0.225218, 0.232375, 0.239522, 0.246657, 0.253781, 0.260892,
0.267992, 0.275078, 0.282151, 0.289211, 0.296256, 0.303287, 0.310303, 0.317302, 0.324286,
0.331254, 0.338204, 0.345136, 0.352051, 0.358946, 0.365822, 0.372679, 0.379514, 0.386329,
0.393122, 0.399893, 0.40664, 0.413364, 0.420064, 0.426739, 0.433388, 0.44001, 0.446605,
0.453172, 0.45971, 0.466219, 0.472697, 0.479144, 0.485559, 0.491941, 0.498289, 0.504601,
0.510878, 0.517118, 0.52332, 0.529484, 0.535607, 0.541689, 0.547728, 0.553724, 0.559676,
0.565582, 0.57144, 0.57725, 0.58301, 0.588719, 0.594376, 0.599978, 0.605525, 0.611015 },

{0, 0.007326, 0.014652, 0.021977, 0.029302, 0.036625, 0.043946, 0.051266, 0.058584, 0.065899,
0.073211, 0.08052, 0.087825, 0.095127, 0.102425, 0.109718, 0.117006, 0.12429, 0.131568,
0.13884, 0.146106, 0.153365, 0.160618, 0.167864, 0.175102, 0.182332, 0.189554, 0.196767,
0.203972, 0.211167, 0.218352, 0.225527, 0.232691, 0.239845, 0.246987, 0.254117, 0.261235,
0.26834, 0.275432, 0.282511, 0.289576, 0.296626, 0.303661, 0.31068, 0.317684, 0.324671,
0.331642, 0.338594, 0.345529, 0.352445, 0.359342, 0.366219, 0.373076, 0.379912, 0.386727,
0.393519, 0.400288, 0.407034, 0.413756, 0.420453, 0.427124, 0.433769, 0.440387, 0.446978,
0.45354, 0.460072, 0.466574, 0.473045, 0.479484, 0.485891, 0.492264, 0.498602, 0.504905,
0.511171, 0.517399, 0.523589, 0.529739, 0.535849, 0.541917, 0.547941, 0.553922, 0.559857,
0.565746, 0.571586, 0.577378, 0.583118, 0.588807, 0.594443, 0.600024, 0.605549, 0.611015 },

{0, 0.007338, 0.014675, 0.022011, 0.029347, 0.036681, 0.044014, 0.051345, 0.058673, 0.065999,
0.073323, 0.080642, 0.087959, 0.095271, 0.10258, 0.109883, 0.117182, 0.124476, 0.131764,
0.139046, 0.146322, 0.153591, 0.160853, 0.168108, 0.175356, 0.182595, 0.189826, 0.197047,
0.20426, 0.211463, 0.218656, 0.225839, 0.233011, 0.240171, 0.24732, 0.254457, 0.261582,
0.268693, 0.275791, 0.282875, 0.289945, 0.297, 0.304039, 0.311063, 0.31807, 0.325061, 0.332034,
0.33899, 0.345927, 0.352845, 0.359743, 0.366621, 0.373479, 0.380315, 0.387129, 0.39392,
0.400688, 0.407432, 0.414152, 0.420846, 0.427514, 0.434155, 0.440769, 0.447355, 0.453911,
0.460437, 0.466933, 0.473397, 0.479828, 0.486226, 0.49259, 0.498918, 0.505211, 0.511466,
0.517683, 0.52386, 0.529997, 0.536093, 0.542147, 0.548156, 0.554121, 0.56004, 0.565911,
0.571733, 0.577506, 0.583227, 0.588896, 0.594511, 0.60007, 0.605572, 0.611015 },

{0, 0.007349, 0.014698, 0.022046, 0.029393, 0.036738, 0.044083, 0.051425, 0.058764, 0.066102,
0.073436, 0.080767, 0.088094, 0.095418, 0.102737, 0.110051, 0.11736, 0.124664, 0.131963,
0.139255, 0.146541, 0.15382, 0.161092, 0.168356, 0.175613, 0.182861, 0.190101, 0.197331,
0.204552, 0.211764, 0.218965, 0.226155, 0.233335, 0.240502, 0.247658, 0.254802, 0.261933,
0.26905, 0.276154, 0.283244, 0.290318, 0.297378, 0.304422, 0.31145, 0.318461, 0.325455,
0.332432, 0.33939, 0.346329, 0.353249, 0.360149, 0.367028, 0.373886, 0.380722, 0.387535,
0.394326, 0.401093, 0.407835, 0.414552, 0.421244, 0.427908, 0.434546, 0.441155, 0.447735,
0.454286, 0.460806, 0.467295, 0.473751, 0.480175, 0.486564, 0.492919, 0.499238, 0.505519,
0.511763, 0.517968, 0.524134, 0.530258, 0.53634, 0.542379, 0.548373, 0.554322, 0.560224,
0.566077, 0.571882, 0.577636, 0.583337, 0.588986, 0.594579, 0.600116, 0.605595, 0.611015 },

{0, 0.007361, 0.014721, 0.02208, 0.029439, 0.036796, 0.044152, 0.051506, 0.058857, 0.066205,
0.073551, 0.080893, 0.088231, 0.095566, 0.102896, 0.110221, 0.117541, 0.124855, 0.132164,
0.139467, 0.146763, 0.154052, 0.161333, 0.168607, 0.175873, 0.183131, 0.190379, 0.197619,
0.204848, 0.212068, 0.219277, 0.226476, 0.233662, 0.240838, 0.248001, 0.255151, 0.262288,
0.269412, 0.276522, 0.283617, 0.290697, 0.297761, 0.30481, 0.311842, 0.318857, 0.325855,
0.332834, 0.339795, 0.346736, 0.353658, 0.360559, 0.367439, 0.374297, 0.381133, 0.387947,
0.394736, 0.401502, 0.408242, 0.414957, 0.421645, 0.428306, 0.43494, 0.441545, 0.44812,
0.454665, 0.461179, 0.467661, 0.47411, 0.480525, 0.486906, 0.493251, 0.49956, 0.505831,
0.512064, 0.518257, 0.52441, 0.53052, 0.536588, 0.542612, 0.548591, 0.554524, 0.560409,
0.566245, 0.572031, 0.577766, 0.583448, 0.589076, 0.594648, 0.600163, 0.605619, 0.611015 },

{0, 0.007372, 0.014744, 0.022116, 0.029486, 0.036855, 0.044222, 0.051588, 0.05895, 0.06631,
0.073667, 0.081021, 0.08837, 0.095716, 0.103057, 0.110393, 0.117724, 0.125049, 0.132368,
0.139681, 0.146987, 0.154286, 0.161578, 0.168862, 0.176137, 0.183404, 0.190662, 0.19791,
0.205148, 0.212376, 0.219594, 0.2268, 0.233995, 0.241177, 0.248347, 0.255504, 0.262648,
0.269778, 0.276894, 0.283994, 0.29108, 0.298149, 0.305202, 0.312239, 0.319258, 0.326259,
0.333241, 0.340204, 0.347148, 0.354071, 0.360974, 0.367855, 0.374714, 0.38155, 0.388363,
0.395151, 0.401915, 0.408654, 0.415366, 0.422051, 0.428709, 0.435338, 0.441938, 0.448508,
0.455048, 0.461555, 0.46803, 0.474472, 0.480879, 0.487251, 0.493587, 0.499885, 0.506146,
0.512367, 0.518548, 0.524688, 0.530785, 0.536839, 0.542848, 0.548812, 0.554728, 0.560596,
0.566414, 0.572182, 0.577897, 0.583559, 0.589166, 0.594717, 0.60021, 0.605643, 0.611015 },

{0, 0.007384, 0.014768, 0.022152, 0.029534, 0.036915, 0.044294, 0.051671, 0.059045, 0.066417,
0.073785, 0.08115, 0.088511, 0.095868, 0.10322, 0.110567, 0.117909, 0.125245, 0.132575,
0.139898, 0.147215, 0.154524, 0.161826, 0.169119, 0.176404, 0.183681, 0.190948, 0.198205,
0.205452, 0.212689, 0.219914, 0.227128, 0.234331, 0.241521, 0.248698, 0.255862, 0.263013,
0.270149, 0.27727, 0.284377, 0.291467, 0.298542, 0.3056, 0.31264, 0.319663, 0.326667, 0.333653,
0.340619, 0.347564, 0.35449, 0.361393, 0.368275, 0.375135, 0.381971, 0.388783, 0.395571,
0.402333, 0.40907, 0.415779, 0.422462, 0.429116, 0.435741, 0.442336, 0.448901, 0.455434,
0.461935, 0.468403, 0.474837, 0.481236, 0.487599, 0.493925, 0.500214, 0.506463, 0.512673,
0.518842, 0.524969, 0.531052, 0.537092, 0.543086, 0.549034, 0.554934, 0.560784, 0.566585,
0.572334, 0.57803, 0.583672, 0.589258, 0.594786, 0.600257, 0.605667, 0.611015 },

{0, 0.007396, 0.014792, 0.022188, 0.029582, 0.036975, 0.044366, 0.051755, 0.059141, 0.066525,
0.073905, 0.081281, 0.088654, 0.096022, 0.103386, 0.110744, 0.118097, 0.125444, 0.132784,
0.140119, 0.147446, 0.154765, 0.162077, 0.16938, 0.176675, 0.183961, 0.191237, 0.198504,
0.20576, 0.213005, 0.220239, 0.227461, 0.234671, 0.241869, 0.249054, 0.256225, 0.263382,
0.270524, 0.277652, 0.284764, 0.29186, 0.298939, 0.306002, 0.313046, 0.320073, 0.327081,
0.334069, 0.341038, 0.347986, 0.354913, 0.361818, 0.368701, 0.37556, 0.382397, 0.389208,
0.395995, 0.402756, 0.40949, 0.416197, 0.422876, 0.429527, 0.436148, 0.442738, 0.449298,
0.455825, 0.462319, 0.46878, 0.475206, 0.481597, 0.487951, 0.494267, 0.500545, 0.506784,
0.512982, 0.519138, 0.525252, 0.531322, 0.537347, 0.543326, 0.549258, 0.555141, 0.560974,
0.566757, 0.572487, 0.578163, 0.583785, 0.589349, 0.594856, 0.600304, 0.605691, 0.611015 },

{0, 0.007409, 0.014817, 0.022225, 0.029631, 0.037036, 0.044439, 0.05184, 0.059238, 0.066634,
0.074026, 0.081414, 0.088798, 0.096178, 0.103553, 0.110923, 0.118287, 0.125645, 0.132997,
0.140342, 0.147679, 0.155009, 0.162331, 0.169645, 0.176949, 0.184245, 0.191531, 0.198806,
0.206071, 0.213325, 0.220568, 0.227798, 0.235016, 0.242221, 0.249413, 0.256592, 0.263755,
0.270904, 0.278038, 0.285156, 0.292257, 0.299341, 0.306408, 0.313457, 0.320488, 0.327499,
0.334491, 0.341462, 0.348412, 0.355341, 0.362247, 0.369131, 0.375991, 0.382827, 0.389638,
0.396424, 0.403183, 0.409915, 0.41662, 0.423295, 0.429942, 0.436559, 0.443144, 0.449698,
0.456219, 0.462707, 0.469161, 0.475579, 0.481961, 0.488305, 0.494612, 0.50088, 0.507107,
0.513293, 0.519437, 0.525537, 0.531593, 0.537604, 0.543567, 0.549483, 0.55535, 0.561165,
0.56693, 0.572641, 0.578297, 0.583898, 0.589442, 0.594927, 0.600352, 0.605715, 0.611015 },

{0, 0.007421, 0.014842, 0.022262, 0.029681, 0.037098, 0.044513, 0.051927, 0.059337, 0.066745,
0.074149, 0.081549, 0.088945, 0.096337, 0.103723, 0.111104, 0.11848, 0.125849, 0.133212,
0.140567, 0.147916, 0.155256, 0.162589, 0.169913, 0.177227, 0.184532, 0.191828, 0.199113,
0.206387, 0.213649, 0.2209, 0.228139, 0.235365, 0.242578, 0.249778, 0.256963, 0.264133,
0.271289, 0.278429, 0.285552, 0.292659, 0.299748, 0.30682, 0.313873, 0.320908, 0.327922,
0.334917, 0.341891, 0.348843, 0.355774, 0.362681, 0.369566, 0.376426, 0.383262, 0.390073,
0.396857, 0.403615, 0.410345, 0.417046, 0.423719, 0.430362, 0.436974, 0.443554, 0.450103,
0.456618, 0.463099, 0.469545, 0.475955, 0.482328, 0.488663, 0.49496, 0.501217, 0.507433,
0.513607, 0.519738, 0.525825, 0.531867, 0.537863, 0.543811, 0.54971, 0.55556, 0.561358,
0.567104, 0.572796, 0.578433, 0.584013, 0.589535, 0.594998, 0.6004, 0.60574, 0.611015 },

{0, 0.007434, 0.014867, 0.022299, 0.029731, 0.037161, 0.044589, 0.052014, 0.059437, 0.066857,
0.074273, 0.081685, 0.089093, 0.096497, 0.103895, 0.111288, 0.118675, 0.126056, 0.13343,
0.140796, 0.148156, 0.155507, 0.16285, 0.170184, 0.177509, 0.184824, 0.192129, 0.199423,
0.206706, 0.213978, 0.221237, 0.228485, 0.235719, 0.24294, 0.250146, 0.257339, 0.264516,
0.271678, 0.278824, 0.285953, 0.293066, 0.30016, 0.307237, 0.314294, 0.321332, 0.328351,
0.335348, 0.342325, 0.349279, 0.356212, 0.363121, 0.370006, 0.376867, 0.383702, 0.390512,
0.397295, 0.404051, 0.410779, 0.417478, 0.424147, 0.430786, 0.437393, 0.443969, 0.450511,
0.45702, 0.463494, 0.469932, 0.476334, 0.482699, 0.489025, 0.495311, 0.501557, 0.507762,
0.513924, 0.520042, 0.526116, 0.532143, 0.538124, 0.544057, 0.54994, 0.555772, 0.561552,
0.567279, 0.572952, 0.578569, 0.584128, 0.589629, 0.595069, 0.600448, 0.605764, 0.611015 },

{0, 0.007446, 0.014892, 0.022338, 0.029782, 0.037224, 0.044665, 0.052103, 0.059538, 0.06697,
0.074399, 0.081824, 0.089244, 0.096659, 0.10407, 0.111474, 0.118873, 0.126265, 0.13365,
0.141028, 0.148398, 0.155761, 0.163114, 0.170459, 0.177794, 0.185119, 0.192433, 0.199737,
0.20703, 0.21431, 0.221579, 0.228834, 0.236077, 0.243305, 0.25052, 0.257719, 0.264904,
0.272072, 0.279224, 0.28636, 0.293477, 0.300577, 0.307658, 0.31472, 0.321762, 0.328784,
0.335785, 0.342764, 0.34972, 0.356654, 0.363565, 0.370451, 0.377312, 0.384147, 0.390956,
0.397738, 0.404492, 0.411217, 0.417913, 0.424579, 0.431214, 0.437817, 0.444387, 0.450924,
0.457426, 0.463893, 0.470324, 0.476718, 0.483073, 0.489389, 0.495666, 0.501901, 0.508094,
0.514243, 0.520349, 0.526409, 0.532422, 0.538387, 0.544304, 0.55017, 0.555985, 0.561748,
0.567456, 0.573109, 0.578706, 0.584244, 0.589723, 0.595141, 0.600497, 0.605789, 0.611015 },

{0, 0.007459, 0.014918, 0.022376, 0.029833, 0.037289, 0.044742, 0.052193, 0.059641, 0.067085,
0.074527, 0.081964, 0.089396, 0.096824, 0.104246, 0.111663, 0.119073, 0.126477, 0.133874,
0.141263, 0.148644, 0.156018, 0.163382, 0.170737, 0.178082, 0.185417, 0.192742, 0.200055,
0.207357, 0.214647, 0.221924, 0.229188, 0.236439, 0.243676, 0.250898, 0.258105, 0.265296,
0.272471, 0.279629, 0.286771, 0.293894, 0.300999, 0.308085, 0.315151, 0.322197, 0.329222,
0.336226, 0.343207, 0.350166, 0.357102, 0.364013, 0.3709, 0.377761, 0.384597, 0.391405,
0.398185, 0.404937, 0.41166, 0.418353, 0.425016, 0.431646, 0.438245, 0.44481, 0.45134,
0.457836, 0.464296, 0.470719, 0.477104, 0.483451, 0.489757, 0.496023, 0.502247, 0.508428,
0.514565, 0.520658, 0.526704, 0.532702, 0.538653, 0.544553, 0.550403, 0.556201, 0.561945,
0.567634, 0.573268, 0.578844, 0.584361, 0.589818, 0.595213, 0.600546, 0.605814, 0.611015 },

{0, 0.007472, 0.014944, 0.022416, 0.029886, 0.037354, 0.04482, 0.052284, 0.059745, 0.067202,
0.074656, 0.082106, 0.089551, 0.096991, 0.104425, 0.111854, 0.119276, 0.126692, 0.1341,
0.141501, 0.148894, 0.156278, 0.163653, 0.171019, 0.178374, 0.18572, 0.193054, 0.200378,
0.207689, 0.214988, 0.222274, 0.229547, 0.236806, 0.24405, 0.25128, 0.258494, 0.265693,
0.272875, 0.280039, 0.287186, 0.294315, 0.301425, 0.308516, 0.315587, 0.322637, 0.329665,
0.336672, 0.343656, 0.350618, 0.357555, 0.364467, 0.371355, 0.378216, 0.385051, 0.391858,
0.398638, 0.405388, 0.412108, 0.418798, 0.425457, 0.432083, 0.438677, 0.445236, 0.451761,
0.45825, 0.464703, 0.471118, 0.477495, 0.483832, 0.490128, 0.496384, 0.502597, 0.508766,
0.51489, 0.520969, 0.527001, 0.532985, 0.53892, 0.544804, 0.550637, 0.556417, 0.562143,
0.567813, 0.573427, 0.578982, 0.584478, 0.589913, 0.595286, 0.600595, 0.605839, 0.611015 },

{0, 0.007486, 0.014971, 0.022455, 0.029939, 0.03742, 0.044899, 0.052376, 0.05985, 0.06732,
0.074787, 0.082249, 0.089707, 0.097159, 0.104606, 0.112047, 0.119482, 0.126909, 0.134329,
0.141742, 0.149146, 0.156541, 0.163928, 0.171304, 0.17867, 0.186026, 0.193371, 0.200704,
0.208025, 0.215333, 0.222628, 0.22991, 0.237177, 0.24443, 0.251667, 0.258889, 0.266095,
0.273283, 0.280454, 0.287607, 0.294742, 0.301857, 0.308952, 0.316027, 0.323081, 0.330114,
0.337123, 0.34411, 0.351074, 0.358012, 0.364926, 0.371814, 0.378676, 0.38551, 0.392317,
0.399095, 0.405843, 0.412561, 0.419247, 0.425902, 0.432525, 0.439113, 0.445667, 0.452186,
0.458668, 0.465113, 0.47152, 0.477888, 0.484216, 0.490503, 0.496747, 0.502949, 0.509106,
0.515218, 0.521283, 0.527301, 0.53327, 0.539189, 0.545058, 0.550873, 0.556635, 0.562343,
0.567994, 0.573587, 0.579122, 0.584597, 0.59001, 0.595359, 0.600645, 0.605864, 0.611015 },

{0, 0.007499, 0.014998, 0.022496, 0.029992, 0.037487, 0.04498, 0.05247, 0.059957, 0.06744,
0.07492, 0.082395, 0.089865, 0.09733, 0.10479, 0.112243, 0.11969, 0.12713, 0.134562, 0.141986,
0.149402, 0.156808, 0.164206, 0.171593, 0.17897, 0.186336, 0.193691, 0.201034, 0.208365,
0.215682, 0.222987, 0.230277, 0.237553, 0.244814, 0.252059, 0.259289, 0.266501, 0.273696,
0.280874, 0.288033, 0.295173, 0.302294, 0.309394, 0.316473, 0.323531, 0.330567, 0.33758,
0.344569, 0.351535, 0.358475, 0.36539, 0.372279, 0.379141, 0.385975, 0.39278, 0.399556,
0.406302, 0.413018, 0.419701, 0.426352, 0.43297, 0.439554, 0.446102, 0.452615, 0.45909,
0.465528, 0.471927, 0.478286, 0.484604, 0.490881, 0.497114, 0.503304, 0.509449, 0.515548,
0.5216, 0.527603, 0.533557, 0.539461, 0.545312, 0.551111, 0.556855, 0.562544, 0.568175,
0.573749, 0.579263, 0.584716, 0.590106, 0.595433, 0.600694, 0.605889, 0.611015 },

{0, 0.007513, 0.015025, 0.022536, 0.030047, 0.037555, 0.045061, 0.052564, 0.060065, 0.067561,
0.075054, 0.082542, 0.090026, 0.097504, 0.104976, 0.112442, 0.119901, 0.127353, 0.134797,
0.142233, 0.14966, 0.157079, 0.164487, 0.171886, 0.179274, 0.18665, 0.194016, 0.201369,
0.208709, 0.216036, 0.22335, 0.230649, 0.237934, 0.245203, 0.252456, 0.259693, 0.266913,
0.274115, 0.281299, 0.288464, 0.29561, 0.302735, 0.309841, 0.316924, 0.323986, 0.331026,
0.338042, 0.345034, 0.352001, 0.358943, 0.365859, 0.372749, 0.37961, 0.386444, 0.393248,
0.400023, 0.406767, 0.413479, 0.42016, 0.426807, 0.43342, 0.439999, 0.446541, 0.453047,
0.459516, 0.465946, 0.472337, 0.478687, 0.484995, 0.491262, 0.497484, 0.503663, 0.509795,
0.515881, 0.521919, 0.527908, 0.533847, 0.539734, 0.545569, 0.55135, 0.557076, 0.562746,
0.568358, 0.573911, 0.579404, 0.584835, 0.590203, 0.595507, 0.600744, 0.605914, 0.611015 },

{0, 0.007527, 0.015053, 0.022578, 0.030102, 0.037624, 0.045143, 0.05266, 0.060174, 0.067684,
0.07519, 0.082692, 0.090188, 0.097679, 0.105164, 0.112643, 0.120115, 0.127579, 0.135035,
0.142483, 0.149923, 0.157352, 0.164772, 0.172182, 0.179581, 0.186968, 0.194344, 0.201707,
0.209058, 0.216394, 0.223717, 0.231025, 0.238319, 0.245596, 0.252857, 0.260102, 0.267329,
0.274538, 0.281729, 0.2889, 0.296051, 0.303182, 0.310292, 0.317381, 0.324446, 0.331489,
0.338508, 0.345503, 0.352473, 0.359416, 0.366333, 0.373223, 0.380085, 0.386918, 0.393721,
0.400494, 0.407236, 0.413946, 0.420623, 0.427266, 0.433875, 0.440448, 0.446985, 0.453484,
0.459946, 0.466368, 0.47275, 0.479091, 0.48539, 0.491646, 0.497858, 0.504024, 0.510144,
0.516217, 0.522241, 0.528215, 0.534138, 0.54001, 0.545828, 0.551591, 0.557299, 0.56295,
0.568542, 0.574075, 0.579547, 0.584956, 0.590301, 0.595581, 0.600795, 0.60594, 0.611015 },

{0, 0.00754, 0.015081, 0.02262, 0.030157, 0.037693, 0.045227, 0.052757, 0.060285, 0.067809,
0.075328, 0.082843, 0.090353, 0.097857, 0.105355, 0.112847, 0.120331, 0.127808, 0.135277,
0.142737, 0.150188, 0.15763, 0.165061, 0.172482, 0.179892, 0.18729, 0.194677, 0.20205, 0.20941,
0.216757, 0.224089, 0.231407, 0.238708, 0.245994, 0.253264, 0.260516, 0.26775, 0.274966,
0.282163, 0.289341, 0.296498, 0.303635, 0.310749, 0.317842, 0.324912, 0.331958, 0.33898,
0.345978, 0.352949, 0.359894, 0.366813, 0.373703, 0.380565, 0.387397, 0.394199, 0.400971,
0.40771, 0.414417, 0.42109, 0.42773, 0.434334, 0.440902, 0.447432, 0.453925, 0.46038, 0.466794,
0.473168, 0.479499, 0.485788, 0.492034, 0.498234, 0.504388, 0.510496, 0.516555, 0.522565,
0.528524, 0.534432, 0.540287, 0.546088, 0.551834, 0.557524, 0.563155, 0.568728, 0.57424,
0.57969, 0.585077, 0.590399, 0.595656, 0.600845, 0.605966, 0.611015 },

{0, 0.007555, 0.015109, 0.022662, 0.030214, 0.037764, 0.045311, 0.052856, 0.060397, 0.067935,
0.075468, 0.082997, 0.09052, 0.098037, 0.105548, 0.113053, 0.12055, 0.12804, 0.135521,
0.142994, 0.150457, 0.15791, 0.165354, 0.172786, 0.180207, 0.187617, 0.195013, 0.202397,
0.209768, 0.217124, 0.224466, 0.231792, 0.239103, 0.246397, 0.253675, 0.260935, 0.268177,
0.2754, 0.282603, 0.289787, 0.29695, 0.304092, 0.311212, 0.318309, 0.325383, 0.332432,
0.339458, 0.346457, 0.353431, 0.360378, 0.367297, 0.374188, 0.381049, 0.387881, 0.394682,
0.401452, 0.408189, 0.414893, 0.421563, 0.428198, 0.434797, 0.441359, 0.447884, 0.454371,
0.460817, 0.467224, 0.473589, 0.479911, 0.48619, 0.492425, 0.498613, 0.504756, 0.51085,
0.516896, 0.522891, 0.528836, 0.534728, 0.540567, 0.546351, 0.552079, 0.557749, 0.563362,
0.568914, 0.574405, 0.579834, 0.585199, 0.590498, 0.595731, 0.600896, 0.605991, 0.611015 },

{0, 0.007569, 0.015137, 0.022705, 0.030271, 0.037835, 0.045397, 0.052956, 0.060511, 0.068063,
0.07561, 0.083152, 0.090689, 0.09822, 0.105744, 0.113262, 0.120772, 0.128275, 0.135769,
0.143254, 0.150729, 0.158195, 0.16565, 0.173094, 0.180526, 0.187947, 0.195354, 0.202749,
0.210129, 0.217496, 0.224847, 0.232183, 0.239502, 0.246805, 0.254091, 0.261359, 0.268608,
0.275838, 0.283049, 0.290238, 0.297407, 0.304554, 0.311679, 0.318781, 0.325859, 0.332912,
0.33994, 0.346942, 0.353918, 0.360866, 0.367787, 0.374678, 0.381539, 0.38837, 0.39517,
0.401938, 0.408672, 0.415373, 0.42204, 0.42867, 0.435265, 0.441822, 0.44834, 0.45482, 0.461259,
0.467657, 0.474013, 0.480326, 0.486595, 0.492819, 0.498996, 0.505126, 0.511207, 0.517239,
0.523221, 0.52915, 0.535026, 0.540848, 0.546615, 0.552325, 0.557977, 0.563569, 0.569101,
0.574572, 0.579979, 0.585321, 0.590598, 0.595807, 0.600947, 0.606017, 0.611015 },

{0, 0.007584, 0.015167, 0.022749, 0.030329, 0.037908, 0.045484, 0.053057, 0.060626, 0.068192,
0.075753, 0.083309, 0.09086, 0.098404, 0.105943, 0.113474, 0.120997, 0.128512, 0.136019,
0.143517, 0.151005, 0.158483, 0.16595, 0.173405, 0.180849, 0.188281, 0.195699, 0.203104,
0.210495, 0.217872, 0.225233, 0.232578, 0.239907, 0.247218, 0.254512, 0.261788, 0.269045,
0.276282, 0.283499, 0.290695, 0.29787, 0.305022, 0.312152, 0.319258, 0.32634, 0.333397,
0.340428, 0.347433, 0.354411, 0.36136, 0.368281, 0.375173, 0.382034, 0.388865, 0.395663,
0.402429, 0.409161, 0.415859, 0.422521, 0.429148, 0.435737, 0.442288, 0.448801, 0.455273,
0.461705, 0.468095, 0.474442, 0.480745, 0.487004, 0.493216, 0.499382, 0.505499, 0.511568,
0.517586, 0.523552, 0.529466, 0.535326, 0.541132, 0.546881, 0.552572, 0.558205, 0.563778,
0.56929, 0.574739, 0.580125, 0.585444, 0.590698, 0.595883, 0.600998, 0.606043, 0.611015 },

{0, 0.007598, 0.015196, 0.022793, 0.030388, 0.037981, 0.045572, 0.053159, 0.060743, 0.068323,
0.075898, 0.083469, 0.091033, 0.098592, 0.106143, 0.113688, 0.121225, 0.128753, 0.136273,
0.143784, 0.151284, 0.158774, 0.166253, 0.173721, 0.181176, 0.188619, 0.196049, 0.203465,
0.210866, 0.218252, 0.225623, 0.232978, 0.240316, 0.247636, 0.254938, 0.262222, 0.269486,
0.276731, 0.283955, 0.291157, 0.298338, 0.305496, 0.31263, 0.319741, 0.326827, 0.333887,
0.340921, 0.347929, 0.354908, 0.361859, 0.368781, 0.375673, 0.382534, 0.389364, 0.396161,
0.402925, 0.409654, 0.416349, 0.423008, 0.429629, 0.436214, 0.442759, 0.449265, 0.455731,
0.462155, 0.468536, 0.474874, 0.481168, 0.487416, 0.493617, 0.499771, 0.505875, 0.51193,
0.517934, 0.523886, 0.529785, 0.535629, 0.541417, 0.547149, 0.552822, 0.558436, 0.563989,
0.56948, 0.574908, 0.580271, 0.585568, 0.590798, 0.595959, 0.60105, 0.606069, 0.611015 },

{0, 0.007613, 0.015226, 0.022837, 0.030447, 0.038055, 0.045661, 0.053263, 0.060861, 0.068456,
0.076045, 0.08363, 0.091209, 0.098781, 0.106347, 0.113905, 0.121455, 0.128997, 0.13653,
0.144054, 0.151567, 0.159069, 0.166561, 0.17404, 0.181508, 0.188962, 0.196403, 0.203829,
0.211241, 0.218638, 0.226018, 0.233383, 0.24073, 0.248059, 0.25537, 0.262661, 0.269933,
0.277185, 0.284415, 0.291624, 0.298811, 0.305974, 0.313114, 0.320229, 0.327319, 0.334383,
0.34142, 0.34843, 0.355411, 0.362364, 0.369287, 0.376179, 0.38304, 0.389868, 0.396664,
0.403426, 0.410153, 0.416844, 0.423499, 0.430116, 0.436695, 0.443235, 0.449734, 0.456192,
0.462608, 0.468981, 0.47531, 0.481594, 0.487831, 0.494021, 0.500163, 0.506255, 0.512296,
0.518286, 0.524223, 0.530106, 0.535933, 0.541705, 0.547418, 0.553073, 0.558667, 0.564201,
0.569671, 0.575077, 0.580418, 0.585693, 0.590899, 0.596036, 0.601102, 0.606096, 0.611015 },

{0, 0.007628, 0.015256, 0.022883, 0.030508, 0.038131, 0.045751, 0.053368, 0.060981, 0.06859,
0.076195, 0.083793, 0.091387, 0.098973, 0.106553, 0.114125, 0.121689, 0.129244, 0.136791,
0.144327, 0.151853, 0.159368, 0.166872, 0.174364, 0.181843, 0.189309, 0.196761, 0.204198,
0.211621, 0.219028, 0.226418, 0.233792, 0.241148, 0.248487, 0.255806, 0.263106, 0.270385,
0.277644, 0.284882, 0.292097, 0.299289, 0.306458, 0.313603, 0.320723, 0.327816, 0.334884,
0.341924, 0.348936, 0.35592, 0.362874, 0.369797, 0.37669, 0.38355, 0.390378, 0.397172,
0.403932, 0.410656, 0.417344, 0.423994, 0.430607, 0.437181, 0.443714, 0.450207, 0.456658,
0.463066, 0.46943, 0.47575, 0.482023, 0.48825, 0.494428, 0.500558, 0.506637, 0.512665, 0.51864,
0.524562, 0.530429, 0.53624, 0.541994, 0.54769, 0.553326, 0.558901, 0.564414, 0.569863,
0.575248, 0.580567, 0.585818, 0.591001, 0.596113, 0.601154, 0.606122, 0.611015 },

{0, 0.007644, 0.015286, 0.022928, 0.030569, 0.038207, 0.045842, 0.053474, 0.061103, 0.068726,
0.076345, 0.083959, 0.091567, 0.099168, 0.106761, 0.114348, 0.121925, 0.129495, 0.137054,
0.144604, 0.152143, 0.159671, 0.167187, 0.174691, 0.182182, 0.18966, 0.197123, 0.204572,
0.212005, 0.219423, 0.226823, 0.234207, 0.241572, 0.248919, 0.256247, 0.263555, 0.270843,
0.278109, 0.285353, 0.292575, 0.299773, 0.306948, 0.314097, 0.321222, 0.32832, 0.33539,
0.342434, 0.349448, 0.356434, 0.363389, 0.370313, 0.377206, 0.384066, 0.390893, 0.397685,
0.404443, 0.411164, 0.417848, 0.424495, 0.431103, 0.437671, 0.444199, 0.450685, 0.457128,
0.463528, 0.469883, 0.476193, 0.482456, 0.488672, 0.494839, 0.500956, 0.507022, 0.513036,
0.518997, 0.524903, 0.530754, 0.536549, 0.542285, 0.547963, 0.55358, 0.559135, 0.564628,
0.570056, 0.575419, 0.580716, 0.585944, 0.591103, 0.596191, 0.601206, 0.606148, 0.611015 },

{0, 0.007659, 0.015317, 0.022975, 0.03063, 0.038284, 0.045935, 0.053582, 0.061225, 0.068864,
0.076498, 0.084127, 0.091749, 0.099365, 0.106973, 0.114573, 0.122165, 0.129748, 0.137321,
0.144884, 0.152437, 0.159978, 0.167506, 0.175023, 0.182526, 0.190015, 0.19749, 0.20495,
0.212394, 0.219822, 0.227233, 0.234626, 0.242001, 0.249358, 0.256694, 0.26401, 0.271306,
0.278579, 0.28583, 0.293059, 0.300263, 0.307443, 0.314598, 0.321726, 0.328828, 0.335903,
0.342949, 0.349966, 0.356953, 0.36391, 0.370835, 0.377728, 0.384587, 0.391413, 0.398204,
0.404959, 0.411677, 0.418358, 0.425, 0.431603, 0.438166, 0.444687, 0.451166, 0.457602,
0.463994, 0.47034, 0.47664, 0.482893, 0.489098, 0.495253, 0.501357, 0.50741, 0.51341, 0.519356,
0.525247, 0.531082, 0.53686, 0.542579, 0.548238, 0.553836, 0.559371, 0.564843, 0.570251,
0.575592, 0.580865, 0.58607, 0.591205, 0.596268, 0.601259, 0.606175, 0.611015 },

{0, 0.007675, 0.015349, 0.023022, 0.030693, 0.038362, 0.046028, 0.053691, 0.06135, 0.069004,
0.076653, 0.084297, 0.091934, 0.099564, 0.107187, 0.114801, 0.122408, 0.130004, 0.137592,
0.145168, 0.152734, 0.160288, 0.16783, 0.175358, 0.182874, 0.190375, 0.197862, 0.205333,
0.212788, 0.220227, 0.227648, 0.235051, 0.242436, 0.249801, 0.257146, 0.264471, 0.271774,
0.279055, 0.286313, 0.293548, 0.300758, 0.307944, 0.315103, 0.322237, 0.329342, 0.33642,
0.343469, 0.350489, 0.357478, 0.364436, 0.371362, 0.378254, 0.385114, 0.391938, 0.398727,
0.40548, 0.412195, 0.418872, 0.42551, 0.432108, 0.438665, 0.44518, 0.451652, 0.45808, 0.464464,
0.470801, 0.477091, 0.483334, 0.489527, 0.49567, 0.501762, 0.507801, 0.513787, 0.519718,
0.525594, 0.531412, 0.537173, 0.542874, 0.548514, 0.554093, 0.559609, 0.56506, 0.570446,
0.575765, 0.581016, 0.586198, 0.591308, 0.596347, 0.601312, 0.606202, 0.611015 },

{0, 0.007691, 0.015381, 0.023069, 0.030757, 0.038441, 0.046123, 0.053802, 0.061476, 0.069146,
0.07681, 0.084469, 0.092121, 0.099766, 0.107403, 0.115033, 0.122653, 0.130264, 0.137865,
0.145456, 0.153035, 0.160602, 0.168157, 0.175698, 0.183226, 0.190739, 0.198238, 0.20572,
0.213187, 0.220636, 0.228068, 0.235481, 0.242875, 0.250249, 0.257603, 0.264936, 0.272247,
0.279536, 0.286801, 0.294042, 0.301259, 0.30845, 0.315615, 0.322752, 0.329862, 0.336944,
0.343996, 0.351018, 0.358008, 0.364967, 0.371894, 0.378787, 0.385645, 0.392468, 0.399256,
0.406006, 0.412718, 0.419391, 0.426025, 0.432618, 0.439169, 0.445678, 0.452143, 0.458563,
0.464938, 0.471266, 0.477546, 0.483778, 0.489959, 0.49609, 0.502169, 0.508195, 0.514167,
0.520083, 0.525943, 0.531745, 0.537488, 0.543171, 0.548793, 0.554352, 0.559848, 0.565278,
0.570643, 0.575939, 0.581167, 0.586325, 0.591412, 0.596425, 0.601365, 0.606228, 0.611015 },

{0, 0.007707, 0.015413, 0.023118, 0.030821, 0.038522, 0.046219, 0.053914, 0.061604, 0.069289,
0.076969, 0.084643, 0.09231, 0.099971, 0.107623, 0.115267, 0.122902, 0.130527, 0.138143,
0.145747, 0.15334, 0.16092, 0.168488, 0.176042, 0.183583, 0.191108, 0.198618, 0.206113,
0.21359, 0.22105, 0.228492, 0.235916, 0.243319, 0.250703, 0.258066, 0.265407, 0.272726,
0.280022, 0.287295, 0.294543, 0.301765, 0.308962, 0.316132, 0.323274, 0.330388, 0.337473,
0.344528, 0.351552, 0.358544, 0.365505, 0.372432, 0.379324, 0.386182, 0.393004, 0.399789,
0.406537, 0.413246, 0.419916, 0.426545, 0.433132, 0.439678, 0.44618, 0.452637, 0.45905,
0.465416, 0.471734, 0.478004, 0.484225, 0.490395, 0.496514, 0.50258, 0.508592, 0.514549,
0.52045, 0.526294, 0.532079, 0.537805, 0.54347, 0.549073, 0.554613, 0.560088, 0.565498,
0.57084, 0.576115, 0.58132, 0.586454, 0.591516, 0.596504, 0.601418, 0.606255, 0.611015 },

{0, 0.007723, 0.015445, 0.023167, 0.030886, 0.038603, 0.046317, 0.054027, 0.061733, 0.069434,
0.07713, 0.084819, 0.092502, 0.100178, 0.107845, 0.115504, 0.123154, 0.130794, 0.138423,
0.146042, 0.153648, 0.161242, 0.168823, 0.176391, 0.183944, 0.191482, 0.199004, 0.20651,
0.213998, 0.221469, 0.228922, 0.236356, 0.243769, 0.251162, 0.258534, 0.265884, 0.273211,
0.280515, 0.287794, 0.295049, 0.302277, 0.309479, 0.316654, 0.323801, 0.330919, 0.338008,
0.345065, 0.352092, 0.359086, 0.366047, 0.372975, 0.379868, 0.386725, 0.393545, 0.400329,
0.407073, 0.413779, 0.420445, 0.427069, 0.433651, 0.440191, 0.446686, 0.453136, 0.45954,
0.465898, 0.472207, 0.478467, 0.484676, 0.490835, 0.496941, 0.502994, 0.508992, 0.514934,
0.52082, 0.526647, 0.532416, 0.538124, 0.543771, 0.549355, 0.554875, 0.56033, 0.565718,
0.571039, 0.576291, 0.581472, 0.586583, 0.59162, 0.596583, 0.601471, 0.606282, 0.611015 },

{0, 0.00774, 0.015478, 0.023216, 0.030952, 0.038685, 0.046415, 0.054142, 0.061864, 0.069581,
0.077293, 0.084998, 0.092697, 0.100388, 0.10807, 0.115744, 0.123409, 0.131064, 0.138708,
0.14634, 0.15396, 0.161568, 0.169163, 0.176743, 0.184309, 0.191859, 0.199394, 0.206911,
0.214412, 0.221894, 0.229357, 0.236801, 0.244224, 0.251627, 0.259008, 0.266366, 0.273701,
0.281013, 0.288299, 0.29556, 0.302795, 0.310003, 0.317183, 0.324334, 0.331456, 0.338548,
0.345609, 0.352637, 0.359633, 0.366596, 0.373524, 0.380416, 0.387273, 0.394092, 0.400873,
0.407615, 0.414317, 0.420979, 0.427598, 0.434175, 0.440708, 0.447197, 0.453639, 0.460035,
0.466384, 0.472683, 0.478932, 0.485131, 0.491278, 0.497371, 0.50341, 0.509394, 0.515322,
0.521192, 0.527003, 0.532755, 0.538445, 0.544074, 0.549638, 0.555138, 0.560573, 0.56594,
0.571239, 0.576468, 0.581626, 0.586712, 0.591725, 0.596663, 0.601525, 0.60631, 0.611015 },

{0, 0.007756, 0.015512, 0.023266, 0.031019, 0.038769, 0.046515, 0.054258, 0.061997, 0.06973,
0.077458, 0.085179, 0.092893, 0.1006, 0.108298, 0.115988, 0.123667, 0.131337, 0.138995,
0.146642, 0.154277, 0.161898, 0.169506, 0.1771, 0.184679, 0.192242, 0.199789, 0.207318,
0.21483, 0.222323, 0.229797, 0.237251, 0.244685, 0.252097, 0.259487, 0.266854, 0.274197,
0.281516, 0.28881, 0.296078, 0.303319, 0.310532, 0.317717, 0.324873, 0.331999, 0.339094,
0.346158, 0.353189, 0.360186, 0.36715, 0.374078, 0.380971, 0.387826, 0.394644, 0.401423,
0.408162, 0.414861, 0.421518, 0.428133, 0.434704, 0.441231, 0.447712, 0.454147, 0.460535,
0.466874, 0.473163, 0.479402, 0.485589, 0.491724, 0.497805, 0.50383, 0.5098, 0.515713,
0.521567, 0.527362, 0.533096, 0.538769, 0.544378, 0.549924, 0.555404, 0.560817, 0.566163,
0.571439, 0.576646, 0.58178, 0.586842, 0.59183, 0.596743, 0.601579, 0.606337, 0.611015 },

{0, 0.007773, 0.015546, 0.023317, 0.031086, 0.038853, 0.046617, 0.054376, 0.062131, 0.069881,
0.077625, 0.085363, 0.093093, 0.100815, 0.108529, 0.116234, 0.123929, 0.131614, 0.139287,
0.146948, 0.154597, 0.162233, 0.169854, 0.177462, 0.185053, 0.192629, 0.200188, 0.20773,
0.215253, 0.222758, 0.230243, 0.237707, 0.245151, 0.252572, 0.259972, 0.267347, 0.274699,
0.282025, 0.289326, 0.296601, 0.303848, 0.311067, 0.318257, 0.325418, 0.332548, 0.339646,
0.346713, 0.353746, 0.360745, 0.36771, 0.374638, 0.38153, 0.388385, 0.395201, 0.401978,
0.408714, 0.415409, 0.422062, 0.428672, 0.435237, 0.441758, 0.448232, 0.454659, 0.461038,
0.467368, 0.473647, 0.479875, 0.486051, 0.492174, 0.498241, 0.504253, 0.510209, 0.516106,
0.521945, 0.527723, 0.53344, 0.539094, 0.544685, 0.550211, 0.55567, 0.561063, 0.566387,
0.571641, 0.576824, 0.581936, 0.586973, 0.591936, 0.596823, 0.601633, 0.606364, 0.611015 },

{0, 0.00779, 0.01558, 0.023369, 0.031155, 0.038939, 0.046719, 0.054496, 0.062267, 0.070034,
0.077794, 0.085548, 0.093295, 0.101033, 0.108763, 0.116484, 0.124194, 0.131894, 0.139582,
0.147258, 0.154921, 0.162571, 0.170207, 0.177827, 0.185432, 0.193021, 0.200593, 0.208146,
0.215682, 0.223198, 0.230694, 0.238169, 0.245622, 0.253054, 0.260462, 0.267846, 0.275206,
0.282541, 0.289849, 0.29713, 0.304383, 0.311608, 0.318804, 0.325969, 0.333103, 0.340205,
0.347274, 0.354309, 0.36131, 0.368275, 0.375204, 0.382096, 0.388949, 0.395764, 0.402538,
0.409271, 0.415963, 0.422611, 0.429216, 0.435776, 0.442289, 0.448756, 0.455176, 0.461546,
0.467866, 0.474135, 0.480353, 0.486517, 0.492627, 0.498681, 0.504679, 0.51062, 0.516502,
0.522325, 0.528086, 0.533785, 0.539421, 0.544993, 0.550499, 0.555939, 0.56131, 0.566612,
0.571844, 0.577004, 0.582091, 0.587105, 0.592043, 0.596904, 0.601687, 0.606392, 0.611015 },

{0, 0.007808, 0.015615, 0.023421, 0.031224, 0.039025, 0.046823, 0.054616, 0.062405, 0.070189,
0.077966, 0.085736, 0.093499, 0.101254, 0.109, 0.116736, 0.124462, 0.132177, 0.139881,
0.147572, 0.15525, 0.162914, 0.170563, 0.178198, 0.185816, 0.193418, 0.201002, 0.208568,
0.216115, 0.223643, 0.23115, 0.238635, 0.246099, 0.25354, 0.260958, 0.268351, 0.275719,
0.283062, 0.290377, 0.297665, 0.304925, 0.312155, 0.319356, 0.326525, 0.333663, 0.340768,
0.34784, 0.354878, 0.36188, 0.368846, 0.375776, 0.382667, 0.389519, 0.396332, 0.403104,
0.409834, 0.416521, 0.423165, 0.429765, 0.436319, 0.442826, 0.449285, 0.455696, 0.462058,
0.468368, 0.474627, 0.480834, 0.486986, 0.493083, 0.499125, 0.505109, 0.511035, 0.516901,
0.522707, 0.528452, 0.534133, 0.539751, 0.545303, 0.55079, 0.556208, 0.561558, 0.566839,
0.572048, 0.577185, 0.582248, 0.587237, 0.592149, 0.596985, 0.601742, 0.606419, 0.611015 },

{0, 0.007825, 0.01565, 0.023473, 0.031295, 0.039113, 0.046928, 0.054739, 0.062545, 0.070345,
0.07814, 0.085927, 0.093706, 0.101478, 0.10924, 0.116992, 0.124734, 0.132465, 0.140183,
0.147889, 0.155582, 0.163261, 0.170924, 0.178573, 0.186205, 0.193819, 0.201416, 0.208995,
0.216554, 0.224093, 0.231611, 0.239108, 0.246582, 0.254033, 0.26146, 0.268862, 0.276238,
0.283589, 0.290911, 0.298206, 0.305472, 0.312708, 0.319914, 0.327088, 0.33423, 0.341338,
0.348413, 0.355453, 0.362456, 0.369423, 0.376353, 0.383243, 0.390095, 0.396905, 0.403675,
0.410402, 0.417085, 0.423725, 0.430319, 0.436866, 0.443367, 0.449819, 0.456222, 0.462574,
0.468875, 0.475123, 0.481318, 0.487459, 0.493543, 0.499571, 0.505541, 0.511452, 0.517303,
0.523092, 0.528819, 0.534483, 0.540082, 0.545615, 0.551082, 0.55648, 0.561808, 0.567066,
0.572253, 0.577366, 0.582405, 0.587369, 0.592256, 0.597066, 0.601796, 0.606447, 0.611015 },

{0, 0.007843, 0.015686, 0.023527, 0.031366, 0.039202, 0.047035, 0.054863, 0.062686, 0.070504,
0.078315, 0.08612, 0.093916, 0.101704, 0.109483, 0.117251, 0.125009, 0.132755, 0.14049,
0.148211, 0.155919, 0.163612, 0.17129, 0.178952, 0.186598, 0.194226, 0.201836, 0.209427,
0.216998, 0.224549, 0.232078, 0.239586, 0.24707, 0.254531, 0.261967, 0.269379, 0.276763,
0.284121, 0.291452, 0.298753, 0.306026, 0.313267, 0.320478, 0.327657, 0.334802, 0.341914,
0.348992, 0.356033, 0.363038, 0.370006, 0.376936, 0.383826, 0.390676, 0.397485, 0.404251,
0.410975, 0.417655, 0.424289, 0.430878, 0.437419, 0.443913, 0.450357, 0.456751, 0.463094,
0.469385, 0.475623, 0.481807, 0.487935, 0.494007, 0.500021, 0.505976, 0.511872, 0.517707,
0.52348, 0.52919, 0.534835, 0.540416, 0.545929, 0.551375, 0.556752, 0.562059, 0.567295,
0.572458, 0.577548, 0.582563, 0.587502, 0.592364, 0.597147, 0.601851, 0.606474, 0.611015 },

{0, 0.007861, 0.015722, 0.023581, 0.031438, 0.039292, 0.047143, 0.054989, 0.06283, 0.070665,
0.078494, 0.086315, 0.094129, 0.101933, 0.109728, 0.117514, 0.125288, 0.13305, 0.1408,
0.148537, 0.156259, 0.163968, 0.17166, 0.179336, 0.186996, 0.194637, 0.20226, 0.209864,
0.217448, 0.22501, 0.232551, 0.240069, 0.247564, 0.255035, 0.262481, 0.269901, 0.277294,
0.28466, 0.291998, 0.299307, 0.306585, 0.313833, 0.321048, 0.328232, 0.335381, 0.342496,
0.349576, 0.35662, 0.363627, 0.370595, 0.377524, 0.384414, 0.391263, 0.398069, 0.404833,
0.411554, 0.418229, 0.424859, 0.431441, 0.437977, 0.444463, 0.4509, 0.457285, 0.463619, 0.4699,
0.476127, 0.482299, 0.488415, 0.494473, 0.500474, 0.506415, 0.512295, 0.518114, 0.52387,
0.529562, 0.53519, 0.540751, 0.546245, 0.55167, 0.557026, 0.562312, 0.567525, 0.572665,
0.577731, 0.582722, 0.587636, 0.592472, 0.597229, 0.601906, 0.606502, 0.611015 },

{0, 0.00788, 0.015759, 0.023636, 0.031511, 0.039383, 0.047252, 0.055116, 0.062975, 0.070828,
0.078674, 0.086513, 0.094344, 0.102165, 0.109978, 0.117779, 0.12557, 0.133348, 0.141114,
0.148866, 0.156604, 0.164328, 0.172035, 0.179725, 0.187399, 0.195054, 0.20269, 0.210306,
0.217902, 0.225477, 0.233029, 0.240559, 0.248064, 0.255545, 0.263, 0.27043, 0.277832, 0.285206,
0.292551, 0.299866, 0.307151, 0.314404, 0.321625, 0.328813, 0.335966, 0.343085, 0.350167,
0.357213, 0.364221, 0.37119, 0.378119, 0.385008, 0.391855, 0.39866, 0.405421, 0.412137,
0.418809, 0.425433, 0.43201, 0.438539, 0.445018, 0.451447, 0.457824, 0.464148, 0.470419,
0.476635, 0.482795, 0.488898, 0.494944, 0.50093, 0.506856, 0.512721, 0.518524, 0.524263,
0.529937, 0.535546, 0.541088, 0.546562, 0.551967, 0.557302, 0.562565, 0.567756, 0.572873,
0.577915, 0.582881, 0.58777, 0.59258, 0.597311, 0.601962, 0.60653, 0.611015 },

{0, 0.007898, 0.015796, 0.023691, 0.031585, 0.039476, 0.047363, 0.055245, 0.063122, 0.070993,
0.078857, 0.086713, 0.094562, 0.102401, 0.11023, 0.118048, 0.125855, 0.13365, 0.141432, 0.1492,
0.156954, 0.164692, 0.172414, 0.180119, 0.187807, 0.195475, 0.203125, 0.210754, 0.218363,
0.225949, 0.233513, 0.241054, 0.24857, 0.256061, 0.263526, 0.270964, 0.278375, 0.285757,
0.293109, 0.300432, 0.307723, 0.314982, 0.322208, 0.3294, 0.336557, 0.343679, 0.350764,
0.357812, 0.364821, 0.37179, 0.37872, 0.385608, 0.392453, 0.399256, 0.406014, 0.412727,
0.419394, 0.426013, 0.432584, 0.439106, 0.445578, 0.451999, 0.458367, 0.464681, 0.470942,
0.477146, 0.483295, 0.489385, 0.495417, 0.501389, 0.507301, 0.51315, 0.518936, 0.524658,
0.530315, 0.535905, 0.541428, 0.546882, 0.552266, 0.557579, 0.56282, 0.567988, 0.573082,
0.5781, 0.583041, 0.587905, 0.592689, 0.597394, 0.602017, 0.606558, 0.611015 },

{0, 0.007917, 0.015833, 0.023748, 0.03166, 0.039569, 0.047475, 0.055375, 0.063271, 0.07116,
0.079042, 0.086916, 0.094782, 0.102639, 0.110485, 0.118321, 0.126145, 0.133956, 0.141754,
0.149538, 0.157307, 0.165061, 0.172798, 0.180518, 0.188219, 0.195902, 0.203565, 0.211207,
0.218828, 0.226427, 0.234003, 0.241554, 0.249081, 0.256583, 0.264057, 0.271505, 0.278924,
0.286314, 0.293674, 0.301003, 0.308301, 0.315566, 0.322797, 0.329993, 0.337155, 0.34428,
0.351367, 0.358417, 0.365427, 0.372397, 0.379326, 0.386213, 0.393057, 0.399857, 0.406612,
0.413322, 0.419984, 0.426598, 0.433163, 0.439678, 0.446143, 0.452555, 0.458914, 0.465219,
0.471469, 0.477662, 0.483798, 0.489876, 0.495894, 0.501852, 0.507748, 0.513581, 0.519351,
0.525056, 0.530694, 0.536266, 0.541769, 0.547203, 0.552566, 0.557857, 0.563076, 0.568221,
0.573291, 0.578285, 0.583202, 0.58804, 0.592798, 0.597476, 0.602073, 0.606586, 0.611015 },

{0, 0.007936, 0.015871, 0.023805, 0.031736, 0.039664, 0.047588, 0.055508, 0.063422, 0.071329,
0.079229, 0.087122, 0.095006, 0.10288, 0.110744, 0.118597, 0.126438, 0.134266, 0.14208,
0.149881, 0.157666, 0.165435, 0.173187, 0.180921, 0.188637, 0.196334, 0.204011, 0.211666,
0.2193, 0.226911, 0.234498, 0.242061, 0.249599, 0.257111, 0.264595, 0.272052, 0.27948,
0.286878, 0.294246, 0.301582, 0.308885, 0.316156, 0.323392, 0.330593, 0.337758, 0.344886,
0.351977, 0.359028, 0.366039, 0.37301, 0.379939, 0.386825, 0.393667, 0.400465, 0.407217,
0.413922, 0.420579, 0.427188, 0.433747, 0.440256, 0.446712, 0.453116, 0.459466, 0.465761,
0.472, 0.478182, 0.484306, 0.49037, 0.496375, 0.502318, 0.508199, 0.514016, 0.519769, 0.525456,
0.531076, 0.536628, 0.542112, 0.547525, 0.552867, 0.558137, 0.563334, 0.568456, 0.573502,
0.578471, 0.583363, 0.588176, 0.592908, 0.597559, 0.602129, 0.606614, 0.611015 },

{0, 0.007955, 0.01591, 0.023863, 0.031813, 0.03976, 0.047703, 0.055642, 0.063574, 0.0715,
0.079419, 0.08733, 0.095232, 0.103124, 0.111006, 0.118876, 0.126734, 0.134579, 0.142411,
0.150227, 0.158028, 0.165813, 0.17358, 0.18133, 0.18906, 0.196771, 0.204461, 0.21213, 0.219777,
0.2274, 0.235, 0.242574, 0.250123, 0.257645, 0.265139, 0.272605, 0.280042, 0.287448, 0.294823,
0.302166, 0.309476, 0.316753, 0.323994, 0.3312, 0.338368, 0.3455, 0.352592, 0.359645, 0.366658,
0.373629, 0.380557, 0.387442, 0.394283, 0.401078, 0.407826, 0.414528, 0.42118, 0.427784,
0.434336, 0.440838, 0.447286, 0.453681, 0.460022, 0.466307, 0.472535, 0.478705, 0.484817,
0.490868, 0.496859, 0.502787, 0.508652, 0.514453, 0.520189, 0.525858, 0.53146, 0.536993,
0.542457, 0.54785, 0.553171, 0.558418, 0.563592, 0.568691, 0.573713, 0.578658, 0.583525,
0.588312, 0.593018, 0.597643, 0.602185, 0.606642, 0.611015 },

{0, 0.007975, 0.015949, 0.023921, 0.031891, 0.039857, 0.04782, 0.055777, 0.063729, 0.071674,
0.079612, 0.087541, 0.095461, 0.103372, 0.111271, 0.119159, 0.127035, 0.134897, 0.142745,
0.150578, 0.158395, 0.166196, 0.173979, 0.181743, 0.189488, 0.197214, 0.204918, 0.2126,
0.22026, 0.227895, 0.235507, 0.243093, 0.250652, 0.258185, 0.265689, 0.273164, 0.28061,
0.288024, 0.295407, 0.302757, 0.310074, 0.317356, 0.324602, 0.331812, 0.338985, 0.346119,
0.353214, 0.360269, 0.367282, 0.374253, 0.381181, 0.388065, 0.394904, 0.401696, 0.408442,
0.415139, 0.421787, 0.428384, 0.434931, 0.441425, 0.447865, 0.454252, 0.460583, 0.466857,
0.473074, 0.479233, 0.485331, 0.491369, 0.497346, 0.503259, 0.509109, 0.514893, 0.520612,
0.526263, 0.531847, 0.53736, 0.542804, 0.548176, 0.553475, 0.558701, 0.563852, 0.568927,
0.573926, 0.578846, 0.583687, 0.588448, 0.593128, 0.597726, 0.602241, 0.606671, 0.611015 },

{0, 0.007995, 0.015988, 0.02398, 0.03197, 0.039956, 0.047938, 0.055915, 0.063886, 0.07185,
0.079807, 0.087755, 0.095694, 0.103622, 0.11154, 0.119446, 0.127339, 0.135218, 0.143083,
0.150933, 0.158767, 0.166583, 0.174382, 0.182162, 0.189922, 0.197662, 0.20538, 0.213076,
0.220748, 0.228397, 0.23602, 0.243618, 0.251188, 0.258731, 0.266246, 0.27373, 0.281185,
0.288607, 0.295998, 0.303355, 0.310678, 0.317965, 0.325217, 0.332431, 0.339608, 0.346745,
0.353842, 0.360899, 0.367913, 0.374885, 0.381812, 0.388695, 0.395531, 0.402321, 0.409063,
0.415755, 0.422398, 0.42899, 0.43553, 0.442017, 0.448449, 0.454827, 0.461148, 0.467412,
0.473618, 0.479764, 0.48585, 0.491874, 0.497836, 0.503735, 0.509568, 0.515336, 0.521038,
0.526671, 0.532235, 0.53773, 0.543153, 0.548504, 0.553782, 0.558985, 0.564113, 0.569165,
0.574139, 0.579034, 0.58385, 0.588586, 0.593239, 0.59781, 0.602297, 0.606699, 0.611015 },

{0, 0.008015, 0.016028, 0.02404, 0.03205, 0.040056, 0.048057, 0.056054, 0.064044, 0.072028,
0.080004, 0.087971, 0.095929, 0.103876, 0.111812, 0.119736, 0.127647, 0.135544, 0.143426,
0.151293, 0.159143, 0.166976, 0.17479, 0.182586, 0.190361, 0.198115, 0.205847, 0.213557,
0.221242, 0.228904, 0.236539, 0.244149, 0.25173, 0.259284, 0.266808, 0.274303, 0.281766,
0.289197, 0.296595, 0.303959, 0.311288, 0.318582, 0.325838, 0.333057, 0.340237, 0.347377,
0.354477, 0.361535, 0.36855, 0.375522, 0.382449, 0.38933, 0.396164, 0.402951, 0.409689,
0.416378, 0.423015, 0.429601, 0.436134, 0.442613, 0.449038, 0.455406, 0.461717, 0.467971,
0.474165, 0.480299, 0.486372, 0.492383, 0.49833, 0.504213, 0.510031, 0.515782, 0.521466,
0.527081, 0.532626, 0.538101, 0.543504, 0.548833, 0.554089, 0.55927, 0.564375, 0.569403,
0.574353, 0.579224, 0.584014, 0.588723, 0.59335, 0.597894, 0.602353, 0.606728, 0.611015 },

{0, 0.008035, 0.016069, 0.024101, 0.032131, 0.040157, 0.048179, 0.056195, 0.064205, 0.072208,
0.080204, 0.08819, 0.096167, 0.104133, 0.112088, 0.12003, 0.127959, 0.135874, 0.143773,
0.151657, 0.159524, 0.167373, 0.175204, 0.183014, 0.190805, 0.198574, 0.20632, 0.214044,
0.221743, 0.229417, 0.237065, 0.244686, 0.252279, 0.259843, 0.267378, 0.274881, 0.282353,
0.289793, 0.297199, 0.30457, 0.311905, 0.319205, 0.326466, 0.333689, 0.340873, 0.348016,
0.355118, 0.362178, 0.369194, 0.376165, 0.383092, 0.389971, 0.396804, 0.403588, 0.410322,
0.417006, 0.423638, 0.430218, 0.436744, 0.443215, 0.449631, 0.45599, 0.462292, 0.468534,
0.474717, 0.480839, 0.486898, 0.492895, 0.498828, 0.504695, 0.510497, 0.516231, 0.521897,
0.527493, 0.533019, 0.538474, 0.543856, 0.549165, 0.554399, 0.559557, 0.564639, 0.569643,
0.574568, 0.579414, 0.584178, 0.588861, 0.593462, 0.597978, 0.60241, 0.606756, 0.611015 },

{0, 0.008055, 0.01611, 0.024163, 0.032213, 0.040259, 0.048301, 0.056338, 0.064368, 0.072391,
0.080406, 0.088412, 0.096408, 0.104393, 0.112367, 0.120328, 0.128275, 0.136208, 0.144125,
0.152026, 0.15991, 0.167775, 0.175622, 0.183449, 0.191254, 0.199038, 0.206799, 0.214536,
0.222249, 0.229936, 0.237596, 0.245229, 0.252834, 0.260409, 0.267954, 0.275467, 0.282948,
0.290396, 0.297809, 0.305187, 0.312529, 0.319834, 0.327101, 0.334328, 0.341516, 0.348662,
0.355766, 0.362827, 0.369844, 0.376815, 0.383741, 0.390619, 0.397449, 0.40423, 0.41096,
0.417639, 0.424266, 0.43084, 0.437359, 0.443822, 0.450229, 0.456579, 0.46287, 0.469102,
0.475273, 0.481382, 0.487428, 0.493411, 0.499328, 0.50518, 0.510965, 0.516682, 0.52233,
0.527908, 0.533415, 0.538849, 0.544211, 0.549498, 0.55471, 0.559845, 0.564903, 0.569883,
0.574784, 0.579604, 0.584343, 0.589, 0.593574, 0.598063, 0.602467, 0.606785, 0.611015 },

{0, 0.008076, 0.016152, 0.024225, 0.032296, 0.040363, 0.048426, 0.056483, 0.064533, 0.072576,
0.080611, 0.088637, 0.096652, 0.104657, 0.112649, 0.120629, 0.128595, 0.136546, 0.144481,
0.152399, 0.1603, 0.168183, 0.176046, 0.183888, 0.191709, 0.199508, 0.207284, 0.215035,
0.222761, 0.230461, 0.238134, 0.245779, 0.253395, 0.260981, 0.268536, 0.276059, 0.283549,
0.291005, 0.298426, 0.305811, 0.31316, 0.320471, 0.327742, 0.334974, 0.342165, 0.349314,
0.35642, 0.363483, 0.3705, 0.377471, 0.384396, 0.391272, 0.3981, 0.404878, 0.411604, 0.418278,
0.4249, 0.431467, 0.437979, 0.444434, 0.450833, 0.457173, 0.463453, 0.469674, 0.475833,
0.481929, 0.487962, 0.49393, 0.499833, 0.505669, 0.511437, 0.517136, 0.522766, 0.528325,
0.533812, 0.539226, 0.544567, 0.549832, 0.555022, 0.560134, 0.565169, 0.570125, 0.575001,
0.579796, 0.584509, 0.589139, 0.593686, 0.598148, 0.602524, 0.606813, 0.611015 },

{0, 0.008097, 0.016194, 0.024288, 0.03238, 0.040468, 0.048552, 0.056629, 0.0647, 0.072764,
0.080819, 0.088865, 0.0969, 0.104924, 0.112936, 0.120934, 0.128919, 0.136888, 0.144841,
0.152777, 0.160696, 0.168595, 0.176475, 0.184333, 0.19217, 0.199984, 0.207774, 0.21554,
0.22328, 0.230993, 0.238679, 0.246336, 0.253963, 0.26156, 0.269125, 0.276658, 0.284157,
0.291621, 0.29905, 0.306443, 0.313797, 0.321114, 0.32839, 0.335626, 0.342821, 0.349973,
0.357081, 0.364145, 0.371163, 0.378134, 0.385058, 0.391932, 0.398757, 0.405531, 0.412254,
0.418923, 0.425539, 0.432099, 0.438604, 0.445051, 0.451441, 0.457771, 0.464041, 0.47025,
0.476397, 0.48248, 0.488499, 0.494453, 0.50034, 0.50616, 0.511911, 0.517593, 0.523205,
0.528745, 0.534212, 0.539606, 0.544925, 0.550168, 0.555336, 0.560425, 0.565436, 0.570367,
0.575218, 0.579988, 0.584675, 0.589279, 0.593798, 0.598232, 0.602581, 0.606842, 0.611015 },

{0, 0.008119, 0.016237, 0.024352, 0.032466, 0.040575, 0.048679, 0.056778, 0.06487, 0.072954,
0.081029, 0.089095, 0.097151, 0.105194, 0.113226, 0.121243, 0.129247, 0.137235, 0.145206,
0.15316, 0.161096, 0.169013, 0.176909, 0.184784, 0.192636, 0.200466, 0.208271, 0.216051,
0.223805, 0.231531, 0.239229, 0.246899, 0.254538, 0.262145, 0.269721, 0.277263, 0.284771,
0.292244, 0.299681, 0.307081, 0.314442, 0.321764, 0.329045, 0.336286, 0.343484, 0.350638,
0.357749, 0.364814, 0.371832, 0.378803, 0.385725, 0.392598, 0.399421, 0.406191, 0.412909,
0.419574, 0.426183, 0.432737, 0.439234, 0.445673, 0.452054, 0.458374, 0.464633, 0.470831,
0.476965, 0.483035, 0.48904, 0.494979, 0.500851, 0.506654, 0.512389, 0.518053, 0.523646,
0.529166, 0.534614, 0.539987, 0.545285, 0.550506, 0.555651, 0.560717, 0.565704, 0.570611,
0.575437, 0.580181, 0.584841, 0.589419, 0.593911, 0.598318, 0.602638, 0.606871, 0.611015 },

{0, 0.00814, 0.01628, 0.024417, 0.032552, 0.040683, 0.048808, 0.056928, 0.065041, 0.073146,
0.081242, 0.089329, 0.097404, 0.105468, 0.113519, 0.121557, 0.129579, 0.137586, 0.145576,
0.153548, 0.161502, 0.169435, 0.177348, 0.18524, 0.193108, 0.200953, 0.208773, 0.216568,
0.224336, 0.232076, 0.239787, 0.247468, 0.255119, 0.262738, 0.270324, 0.277876, 0.285393,
0.292874, 0.300319, 0.307725, 0.315093, 0.322421, 0.329707, 0.336952, 0.344153, 0.351311,
0.358423, 0.365489, 0.372508, 0.379478, 0.3864, 0.393271, 0.40009, 0.406857, 0.413571, 0.42023,
0.426833, 0.43338, 0.43987, 0.4463, 0.452671, 0.458981, 0.46523, 0.471415, 0.477537, 0.483594,
0.489585, 0.495509, 0.501365, 0.507152, 0.512869, 0.518515, 0.52409, 0.529591, 0.535018,
0.54037, 0.545646, 0.550846, 0.555967, 0.56101, 0.565973, 0.570855, 0.575656, 0.580374,
0.585009, 0.589559, 0.594024, 0.598403, 0.602695, 0.6069, 0.611015 },

{0, 0.008162, 0.016324, 0.024483, 0.032639, 0.040792, 0.048939, 0.05708, 0.065215, 0.073341,
0.081458, 0.089565, 0.097662, 0.105746, 0.113817, 0.121874, 0.129916, 0.137941, 0.14595,
0.153941, 0.161912, 0.169863, 0.177793, 0.185701, 0.193586, 0.201447, 0.209282, 0.217091,
0.224873, 0.232626, 0.24035, 0.248044, 0.255707, 0.263337, 0.270933, 0.278495, 0.286022,
0.293511, 0.300964, 0.308377, 0.315751, 0.323085, 0.330376, 0.337625, 0.34483, 0.35199,
0.359104, 0.366171, 0.37319, 0.38016, 0.38708, 0.393949, 0.400766, 0.407529, 0.414238,
0.420892, 0.427489, 0.434029, 0.440511, 0.446933, 0.453294, 0.459594, 0.465831, 0.472005,
0.478114, 0.484157, 0.490134, 0.496042, 0.501883, 0.507653, 0.513353, 0.518981, 0.524536,
0.530017, 0.535424, 0.540755, 0.54601, 0.551187, 0.556285, 0.561304, 0.566243, 0.571101,
0.575876, 0.580568, 0.585176, 0.5897, 0.594137, 0.598489, 0.602753, 0.606929, 0.611015 },

{0, 0.008185, 0.016368, 0.02455, 0.032728, 0.040903, 0.049072, 0.057235, 0.065391, 0.073538,
0.081677, 0.089805, 0.097922, 0.106027, 0.114118, 0.122195, 0.130256, 0.138301, 0.146329,
0.154338, 0.162328, 0.170297, 0.178244, 0.186169, 0.19407, 0.201946, 0.209797, 0.217621,
0.225417, 0.233184, 0.240921, 0.248627, 0.256301, 0.263943, 0.27155, 0.279121, 0.286657,
0.294156, 0.301616, 0.309037, 0.316417, 0.323756, 0.331052, 0.338305, 0.345514, 0.352676,
0.359792, 0.36686, 0.37388, 0.380849, 0.387767, 0.394634, 0.401448, 0.408207, 0.414911,
0.42156, 0.428151, 0.434683, 0.441157, 0.44757, 0.453922, 0.460211, 0.466437, 0.472598,
0.478694, 0.484724, 0.490686, 0.496579, 0.502403, 0.508157, 0.513839, 0.519448, 0.524984,
0.530446, 0.535832, 0.541142, 0.546375, 0.551529, 0.556605, 0.5616, 0.566514, 0.571347,
0.576097, 0.580763, 0.585344, 0.589841, 0.594251, 0.598575, 0.60281, 0.606957, 0.611015 },

{0, 0.008207, 0.016413, 0.024617, 0.032818, 0.041015, 0.049206, 0.057391, 0.065569, 0.073738,
0.081898, 0.090048, 0.098186, 0.106311, 0.114423, 0.12252, 0.130602, 0.138666, 0.146713,
0.154741, 0.162749, 0.170735, 0.1787, 0.186642, 0.19456, 0.202452, 0.210318, 0.218157,
0.225967, 0.233748, 0.241498, 0.249217, 0.256903, 0.264555, 0.272173, 0.279755, 0.2873,
0.294807, 0.302275, 0.309703, 0.31709, 0.324434, 0.331735, 0.338992, 0.346204, 0.353369,
0.360487, 0.367556, 0.374575, 0.381544, 0.388461, 0.395325, 0.402136, 0.408891, 0.415591,
0.422233, 0.428818, 0.435343, 0.441808, 0.448212, 0.454554, 0.460833, 0.467047, 0.473196,
0.479279, 0.485295, 0.491242, 0.49712, 0.502927, 0.508664, 0.514328, 0.519919, 0.525436,
0.530877, 0.536243, 0.541531, 0.546742, 0.551874, 0.556926, 0.561897, 0.566787, 0.571594,
0.576318, 0.580958, 0.585513, 0.589982, 0.594365, 0.598661, 0.602868, 0.606986, 0.611015 },

{0, 0.00823, 0.016459, 0.024686, 0.032909, 0.041128, 0.049342, 0.05755, 0.06575, 0.073941,
0.082123, 0.090294, 0.098453, 0.1066, 0.114732, 0.12285, 0.130951, 0.139035, 0.147101,
0.155148, 0.163175, 0.17118, 0.179162, 0.187121, 0.195055, 0.202964, 0.210845, 0.218699,
0.226524, 0.234319, 0.242082, 0.249814, 0.257512, 0.265175, 0.272804, 0.280396, 0.28795,
0.295465, 0.302941, 0.310376, 0.317769, 0.32512, 0.332426, 0.339687, 0.346902, 0.354069,
0.361189, 0.368258, 0.375278, 0.382246, 0.389161, 0.396023, 0.40283, 0.409581, 0.416276,
0.422912, 0.42949, 0.436008, 0.442465, 0.44886, 0.455191, 0.461459, 0.467662, 0.473798,
0.479868, 0.485869, 0.491802, 0.497664, 0.503455, 0.509174, 0.51482, 0.520392, 0.525889,
0.531311, 0.536655, 0.541922, 0.547111, 0.552219, 0.557248, 0.562195, 0.56706, 0.571842,
0.57654, 0.581154, 0.585682, 0.590124, 0.594479, 0.598747, 0.602926, 0.607016, 0.611015 },

{0, 0.008253, 0.016505, 0.024755, 0.033001, 0.041243, 0.04948, 0.05771, 0.065933, 0.074146,
0.08235, 0.090543, 0.098724, 0.106892, 0.115045, 0.123183, 0.131305, 0.139409, 0.147495,
0.155561, 0.163606, 0.171629, 0.17963, 0.187606, 0.195557, 0.203482, 0.211379, 0.219248,
0.227087, 0.234896, 0.242673, 0.250417, 0.258127, 0.265803, 0.273442, 0.281044, 0.288607,
0.296131, 0.303615, 0.311057, 0.318457, 0.325812, 0.333123, 0.340388, 0.347606, 0.354776,
0.361897, 0.368968, 0.375987, 0.382954, 0.389868, 0.396727, 0.403531, 0.410278, 0.416967,
0.423598, 0.430168, 0.436679, 0.443127, 0.449512, 0.455834, 0.46209, 0.468281, 0.474405,
0.480461, 0.486448, 0.492365, 0.498211, 0.503986, 0.509687, 0.515315, 0.520868, 0.526346,
0.531747, 0.53707, 0.542315, 0.547481, 0.552567, 0.557571, 0.562494, 0.567334, 0.572091,
0.576763, 0.581351, 0.585852, 0.590267, 0.594594, 0.598833, 0.602984, 0.607045, 0.611015 },

{0, 0.008276, 0.016552, 0.024825, 0.033095, 0.04136, 0.04962, 0.057873, 0.066118, 0.074354,
0.08258, 0.090796, 0.098998, 0.107188, 0.115362, 0.123521, 0.131664, 0.139788, 0.147894,
0.155979, 0.164043, 0.172085, 0.180103, 0.188097, 0.196065, 0.204006, 0.211919, 0.219804,
0.227658, 0.23548, 0.243271, 0.251028, 0.25875, 0.266437, 0.274087, 0.281699, 0.289272,
0.296804, 0.304296, 0.311745, 0.319151, 0.326512, 0.333828, 0.341097, 0.348318, 0.355491,
0.362613, 0.369684, 0.376703, 0.383669, 0.390581, 0.397438, 0.404238, 0.41098, 0.417664,
0.424289, 0.430852, 0.437355, 0.443794, 0.45017, 0.456481, 0.462726, 0.468905, 0.475016,
0.481058, 0.487031, 0.492932, 0.498762, 0.50452, 0.510204, 0.515813, 0.521347, 0.526804,
0.532185, 0.537487, 0.54271, 0.547853, 0.552915, 0.557896, 0.562795, 0.56761, 0.572341,
0.576987, 0.581548, 0.586022, 0.590409, 0.594709, 0.59892, 0.603042, 0.607074, 0.611015 },

{0, 0.0083, 0.016599, 0.024896, 0.03319, 0.041478, 0.049761, 0.058038, 0.066306, 0.074565,
0.082814, 0.091051, 0.099276, 0.107487, 0.115683, 0.123864, 0.132027, 0.140172, 0.148297,
0.156402, 0.164486, 0.172546, 0.180582, 0.188594, 0.196579, 0.204537, 0.212466, 0.220366,
0.228235, 0.236072, 0.243876, 0.251646, 0.25938, 0.267079, 0.274739, 0.282361, 0.289944,
0.297485, 0.304985, 0.312441, 0.319853, 0.32722, 0.33454, 0.341813, 0.349038, 0.356212,
0.363336, 0.370408, 0.377427, 0.384391, 0.391301, 0.398155, 0.404951, 0.411689, 0.418367,
0.424985, 0.431542, 0.438036, 0.444467, 0.450833, 0.457133, 0.463367, 0.469534, 0.475631,
0.481659, 0.487617, 0.493503, 0.499317, 0.505057, 0.510723, 0.516314, 0.521828, 0.527265,
0.532625, 0.537905, 0.543106, 0.548227, 0.553266, 0.558222, 0.563096, 0.567886, 0.572591,
0.577211, 0.581745, 0.586193, 0.590552, 0.594824, 0.599007, 0.6031, 0.607103, 0.611015 },

{0, 0.008324, 0.016647, 0.024968, 0.033285, 0.041598, 0.049905, 0.058205, 0.066496, 0.074778,
0.08305, 0.09131, 0.099557, 0.107791, 0.116009, 0.124211, 0.132395, 0.14056, 0.148706,
0.156831, 0.164934, 0.173013, 0.181068, 0.189097, 0.1971, 0.205074, 0.21302, 0.220935,
0.228819, 0.23667, 0.244488, 0.252271, 0.260018, 0.267728, 0.275399, 0.283031, 0.290623,
0.298173, 0.305681, 0.313144, 0.320563, 0.327935, 0.33526, 0.342537, 0.349764, 0.356941,
0.364066, 0.371138, 0.378157, 0.38512, 0.392028, 0.398878, 0.405671, 0.412404, 0.419077,
0.425688, 0.432238, 0.438723, 0.445145, 0.451501, 0.457791, 0.464013, 0.470167, 0.476251,
0.482265, 0.488207, 0.494078, 0.499875, 0.505598, 0.511245, 0.516817, 0.522312, 0.527729,
0.533067, 0.538326, 0.543505, 0.548602, 0.553617, 0.55855, 0.563399, 0.568163, 0.572843,
0.577436, 0.581944, 0.586364, 0.590696, 0.594939, 0.599093, 0.603158, 0.607132, 0.611015 },

{0, 0.008349, 0.016696, 0.025041, 0.033383, 0.041719, 0.05005, 0.058374, 0.066689, 0.074995,
0.08329, 0.091573, 0.099843, 0.108098, 0.116338, 0.124562, 0.132767, 0.140954, 0.14912,
0.157265, 0.165387, 0.173486, 0.181559, 0.189606, 0.197627, 0.205618, 0.21358, 0.221511,
0.22941, 0.237276, 0.245107, 0.252903, 0.260663, 0.268384, 0.276067, 0.283709, 0.29131,
0.298869, 0.306384, 0.313855, 0.32128, 0.328657, 0.335987, 0.343268, 0.350498, 0.357677,
0.364803, 0.371876, 0.378894, 0.385856, 0.392761, 0.399609, 0.406397, 0.413125, 0.419792,
0.426397, 0.432939, 0.439416, 0.445828, 0.452174, 0.458453, 0.464663, 0.470804, 0.476875,
0.482874, 0.488802, 0.494656, 0.500436, 0.506141, 0.511771, 0.517323, 0.522798, 0.528195,
0.533512, 0.538749, 0.543905, 0.548979, 0.55397, 0.558879, 0.563703, 0.568442, 0.573095,
0.577662, 0.582142, 0.586535, 0.590839, 0.595055, 0.599181, 0.603216, 0.607161, 0.611015 },

{0, 0.008373, 0.016745, 0.025115, 0.033481, 0.041842, 0.050197, 0.058545, 0.066884, 0.075214,
0.083532, 0.091839, 0.100131, 0.10841, 0.116672, 0.124918, 0.133145, 0.141352, 0.149539,
0.157705, 0.165847, 0.173964, 0.182057, 0.190122, 0.19816, 0.206169, 0.214147, 0.222094,
0.230008, 0.237889, 0.245734, 0.253543, 0.261315, 0.269048, 0.276742, 0.284395, 0.292005,
0.299573, 0.307096, 0.314573, 0.322004, 0.329388, 0.336722, 0.344006, 0.351239, 0.35842,
0.365547, 0.37262, 0.379638, 0.386598, 0.393501, 0.400345, 0.407129, 0.413853, 0.420514,
0.427112, 0.433646, 0.440115, 0.446517, 0.452853, 0.45912, 0.465318, 0.471446, 0.477503,
0.483488, 0.4894, 0.495238, 0.501001, 0.506689, 0.512299, 0.517833, 0.523288, 0.528663,
0.533959, 0.539174, 0.544307, 0.549358, 0.554325, 0.559209, 0.564007, 0.568721, 0.573348,
0.577889, 0.582342, 0.586707, 0.590983, 0.59517, 0.599268, 0.603275, 0.607191, 0.611015 },

{0, 0.008398, 0.016796, 0.02519, 0.033581, 0.041967, 0.050347, 0.058719, 0.067082, 0.075436,
0.083778, 0.092108, 0.100424, 0.108725, 0.11701, 0.125278, 0.133527, 0.141756, 0.149964,
0.15815, 0.166312, 0.174449, 0.18256, 0.190644, 0.1987, 0.206726, 0.214721, 0.222684, 0.230613,
0.238509, 0.246368, 0.25419, 0.261975, 0.26972, 0.277425, 0.285088, 0.292708, 0.300284,
0.307815, 0.3153, 0.322737, 0.330125, 0.337464, 0.344752, 0.351988, 0.359171, 0.366299,
0.373372, 0.380389, 0.387348, 0.394248, 0.401089, 0.407869, 0.414587, 0.421242, 0.427833,
0.434359, 0.440819, 0.447211, 0.453536, 0.459792, 0.465978, 0.472093, 0.478136, 0.484106,
0.490002, 0.495824, 0.50157, 0.507239, 0.512831, 0.518345, 0.523779, 0.529134, 0.534408,
0.5396, 0.544711, 0.549738, 0.554681, 0.55954, 0.564313, 0.569001, 0.573602, 0.578116,
0.582542, 0.586879, 0.591128, 0.595287, 0.599355, 0.603333, 0.60722, 0.611015 },

{0, 0.008424, 0.016846, 0.025266, 0.033682, 0.042093, 0.050498, 0.058895, 0.067283, 0.075661,
0.084027, 0.092381, 0.100721, 0.109045, 0.117353, 0.125643, 0.133914, 0.142165, 0.150394,
0.158601, 0.166783, 0.17494, 0.183071, 0.191173, 0.199247, 0.20729, 0.215302, 0.223281,
0.231226, 0.239136, 0.24701, 0.254845, 0.262642, 0.270399, 0.278115, 0.285788, 0.293418,
0.301003, 0.308542, 0.316034, 0.323477, 0.330871, 0.338214, 0.345506, 0.352744, 0.359929,
0.367058, 0.374132, 0.381147, 0.388104, 0.395002, 0.401839, 0.408614, 0.415327, 0.421976,
0.428559, 0.435077, 0.441528, 0.447911, 0.454225, 0.460469, 0.466643, 0.472744, 0.478773,
0.484728, 0.490608, 0.496413, 0.502141, 0.507792, 0.513365, 0.518859, 0.524274, 0.529607,
0.534859, 0.540029, 0.545116, 0.55012, 0.555038, 0.559872, 0.56462, 0.569282, 0.573857,
0.578344, 0.582742, 0.587052, 0.591272, 0.595403, 0.599443, 0.603392, 0.60725, 0.611015 },

{0, 0.008449, 0.016898, 0.025343, 0.033785, 0.042221, 0.050651, 0.059073, 0.067486, 0.075889,
0.08428, 0.092657, 0.101021, 0.109369, 0.1177, 0.126013, 0.134306, 0.142579, 0.15083, 0.159057,
0.16726, 0.175437, 0.183587, 0.191709, 0.1998, 0.207861, 0.21589, 0.223885, 0.231846, 0.239771,
0.247659, 0.255508, 0.263318, 0.271087, 0.278814, 0.286497, 0.294137, 0.30173, 0.309277,
0.316776, 0.324225, 0.331624, 0.338972, 0.346267, 0.353508, 0.360695, 0.367825, 0.374898,
0.381913, 0.388868, 0.395763, 0.402596, 0.409367, 0.416074, 0.422716, 0.429292, 0.435802,
0.442243, 0.448616, 0.454919, 0.461152, 0.467312, 0.4734, 0.479414, 0.485354, 0.491218,
0.497006, 0.502717, 0.508349, 0.513903, 0.519377, 0.52477, 0.530083, 0.535313, 0.54046,
0.545523, 0.550503, 0.555397, 0.560206, 0.564928, 0.569564, 0.574112, 0.578572, 0.582943,
0.587225, 0.591417, 0.595519, 0.59953, 0.60345, 0.607279, 0.611015 },

{0, 0.008475, 0.01695, 0.025421, 0.033889, 0.042351, 0.050806, 0.059254, 0.067692, 0.07612,
0.084535, 0.092938, 0.101325, 0.109697, 0.118052, 0.126388, 0.134704, 0.142999, 0.151271,
0.15952, 0.167743, 0.175941, 0.18411, 0.192251, 0.200361, 0.208439, 0.216485, 0.224497,
0.232474, 0.240414, 0.248316, 0.256178, 0.264001, 0.271782, 0.27952, 0.287214, 0.294863,
0.302465, 0.31002, 0.317526, 0.324981, 0.332386, 0.339738, 0.347036, 0.35428, 0.361468,
0.368599, 0.375672, 0.382685, 0.389639, 0.396531, 0.40336, 0.410126, 0.416827, 0.423462,
0.430031, 0.436532, 0.442964, 0.449327, 0.455619, 0.461839, 0.467986, 0.47406, 0.48006,
0.485984, 0.491832, 0.497603, 0.503295, 0.508909, 0.514443, 0.519897, 0.52527, 0.53056,
0.535768, 0.540892, 0.545932, 0.550888, 0.555757, 0.560541, 0.565238, 0.569847, 0.574368,
0.578801, 0.583144, 0.587398, 0.591562, 0.595636, 0.599618, 0.603509, 0.607308, 0.611015 },

{0, 0.008502, 0.017002, 0.0255, 0.033994, 0.042482, 0.050964, 0.059437, 0.067901, 0.076354,
0.084794, 0.093221, 0.101634, 0.11003, 0.118408, 0.126767, 0.135106, 0.143424, 0.151718,
0.159988, 0.168233, 0.17645, 0.18464, 0.192799, 0.200928, 0.209025, 0.217088, 0.225116,
0.233109, 0.241064, 0.24898, 0.256857, 0.264692, 0.272485, 0.280235, 0.287939, 0.295597,
0.303208, 0.310771, 0.318284, 0.325746, 0.333155, 0.340512, 0.347813, 0.35506, 0.362249,
0.369381, 0.376453, 0.383465, 0.390417, 0.397305, 0.40413, 0.410891, 0.417586, 0.424215,
0.430776, 0.437268, 0.443691, 0.450043, 0.456323, 0.462531, 0.468665, 0.474725, 0.48071,
0.486618, 0.492449, 0.498203, 0.503877, 0.509472, 0.514987, 0.52042, 0.525772, 0.53104,
0.536226, 0.541327, 0.546343, 0.551274, 0.556119, 0.560877, 0.565548, 0.570131, 0.574625,
0.57903, 0.583346, 0.587572, 0.591708, 0.595753, 0.599706, 0.603568, 0.607338, 0.611015 },

{0, 0.008529, 0.017056, 0.02558, 0.034101, 0.042615, 0.051123, 0.059623, 0.068112, 0.076591,
0.085057, 0.093509, 0.101946, 0.110366, 0.118769, 0.127152, 0.135514, 0.143854, 0.152171,
0.160463, 0.168728, 0.176966, 0.185176, 0.193355, 0.201503, 0.209617, 0.217698, 0.225743,
0.233752, 0.241722, 0.249653, 0.257543, 0.265391, 0.273196, 0.280957, 0.288672, 0.29634,
0.30396, 0.31153, 0.31905, 0.326518, 0.333933, 0.341293, 0.348598, 0.355847, 0.363038, 0.37017,
0.377242, 0.384253, 0.391202, 0.398087, 0.404908, 0.411663, 0.418352, 0.424974, 0.431527,
0.43801, 0.444423, 0.450764, 0.457033, 0.463228, 0.469349, 0.475395, 0.481364, 0.487256,
0.493071, 0.498807, 0.504463, 0.510039, 0.515533, 0.520946, 0.526276, 0.531523, 0.536685,
0.541763, 0.546756, 0.551662, 0.556482, 0.561214, 0.565859, 0.570415, 0.574882, 0.579261,
0.583549, 0.587747, 0.591854, 0.59587, 0.599794, 0.603627, 0.607367, 0.611015 },

{0, 0.008556, 0.01711, 0.025662, 0.034209, 0.04275, 0.051285, 0.059811, 0.068327, 0.076831,
0.085323, 0.093801, 0.102263, 0.110708, 0.119134, 0.127541, 0.135927, 0.14429, 0.152629,
0.160943, 0.16923, 0.177489, 0.185719, 0.193918, 0.202084, 0.210217, 0.218315, 0.226378,
0.234402, 0.242388, 0.250333, 0.258237, 0.266099, 0.273916, 0.281688, 0.289413, 0.297091,
0.30472, 0.312298, 0.319824, 0.327298, 0.334718, 0.342083, 0.349391, 0.356642, 0.363834,
0.370967, 0.378038, 0.385048, 0.391994, 0.398876, 0.405692, 0.412442, 0.419125, 0.425739,
0.432284, 0.438758, 0.445161, 0.451491, 0.457748, 0.46393, 0.470038, 0.476069, 0.482023,
0.487899, 0.493696, 0.499414, 0.505052, 0.510608, 0.516082, 0.521474, 0.526783, 0.532007,
0.537147, 0.542201, 0.54717, 0.552051, 0.556846, 0.561552, 0.566171, 0.5707, 0.575141,
0.579491, 0.583751, 0.587921, 0.592, 0.595987, 0.599882, 0.603686, 0.607397, 0.611015 },

{0, 0.008583, 0.017165, 0.025744, 0.034318, 0.042887, 0.051448, 0.060001, 0.068544, 0.077075,
0.085593, 0.094096, 0.102583, 0.111054, 0.119505, 0.127936, 0.136345, 0.144732, 0.153094,
0.16143, 0.169739, 0.178019, 0.186269, 0.194487, 0.202673, 0.210825, 0.218941, 0.22702,
0.23506, 0.243062, 0.251022, 0.25894, 0.266814, 0.274644, 0.282427, 0.290163, 0.29785,
0.305488, 0.313074, 0.320607, 0.328087, 0.335512, 0.342881, 0.350192, 0.357445, 0.364639,
0.371771, 0.378842, 0.38585, 0.392793, 0.399672, 0.406483, 0.413228, 0.419904, 0.426511,
0.433047, 0.439512, 0.445904, 0.452223, 0.458468, 0.464638, 0.470731, 0.476747, 0.482686,
0.488545, 0.494325, 0.500025, 0.505644, 0.511181, 0.516635, 0.522005, 0.527292, 0.532494,
0.537611, 0.542641, 0.547585, 0.552442, 0.557211, 0.561892, 0.566484, 0.570987, 0.5754,
0.579722, 0.583955, 0.588096, 0.592146, 0.596104, 0.599971, 0.603745, 0.607426, 0.611015 },

{0, 0.008611, 0.017221, 0.025827, 0.034429, 0.043026, 0.051615, 0.060194, 0.068764, 0.077322,
0.085866, 0.094395, 0.102909, 0.111404, 0.11988, 0.128336, 0.136769, 0.145179, 0.153564,
0.161923, 0.170254, 0.178555, 0.186826, 0.195064, 0.203269, 0.211439, 0.219573, 0.22767,
0.235727, 0.243744, 0.251719, 0.259651, 0.267538, 0.27538, 0.283175, 0.290921, 0.298618,
0.306264, 0.313858, 0.321398, 0.328884, 0.336314, 0.343687, 0.351001, 0.358257, 0.365451,
0.372584, 0.379654, 0.386659, 0.3936, 0.400475, 0.407282, 0.414021, 0.42069, 0.427289,
0.433817, 0.440272, 0.446654, 0.452961, 0.459194, 0.46535, 0.471429, 0.47743, 0.483353,
0.489196, 0.494958, 0.50064, 0.506239, 0.511756, 0.51719, 0.522539, 0.527804, 0.532983,
0.538076, 0.543083, 0.548003, 0.552834, 0.557578, 0.562232, 0.566798, 0.571274, 0.575659,
0.579954, 0.584158, 0.588271, 0.592292, 0.596222, 0.600059, 0.603804, 0.607456, 0.611015 },

{0, 0.008639, 0.017277, 0.025912, 0.034542, 0.043166, 0.051783, 0.06039, 0.068987, 0.077572,
0.086143, 0.094699, 0.103238, 0.111759, 0.120261, 0.128741, 0.137199, 0.145633, 0.154041,
0.162422, 0.170775, 0.179098, 0.18739, 0.195648, 0.203873, 0.212062, 0.220214, 0.228327,
0.236401, 0.244434, 0.252424, 0.26037, 0.268271, 0.276125, 0.283931, 0.291688, 0.299395,
0.307049, 0.314651, 0.322198, 0.32969, 0.337124, 0.344501, 0.351819, 0.359076, 0.366271,
0.373404, 0.380473, 0.387477, 0.394414, 0.401285, 0.408087, 0.41482, 0.421482, 0.428073,
0.434592, 0.441038, 0.447409, 0.453705, 0.459924, 0.466067, 0.472132, 0.478118, 0.484024,
0.48985, 0.495595, 0.501258, 0.506838, 0.512335, 0.517748, 0.523076, 0.528318, 0.533474,
0.538544, 0.543527, 0.548422, 0.553228, 0.557946, 0.562574, 0.567113, 0.571561, 0.575919,
0.580186, 0.584362, 0.588447, 0.592439, 0.596339, 0.600147, 0.603863, 0.607486, 0.611015 },

{0, 0.008668, 0.017334, 0.025998, 0.034656, 0.043309, 0.051953, 0.060589, 0.069213, 0.077825,
0.086423, 0.095006, 0.103572, 0.112119, 0.120646, 0.129152, 0.137634, 0.146092, 0.154524,
0.162928, 0.171303, 0.179648, 0.187961, 0.19624, 0.204484, 0.212692, 0.220862, 0.228993,
0.237084, 0.245132, 0.253137, 0.261097, 0.269012, 0.276878, 0.284696, 0.292463, 0.30018,
0.307843, 0.315452, 0.323006, 0.330504, 0.337943, 0.345324, 0.352644, 0.359903, 0.3671,
0.374232, 0.3813, 0.388301, 0.395236, 0.402102, 0.408899, 0.415626, 0.422281, 0.428864,
0.435374, 0.441809, 0.44817, 0.454454, 0.460661, 0.466789, 0.47284, 0.47881, 0.4847, 0.490509,
0.496236, 0.50188, 0.507441, 0.512917, 0.518309, 0.523615, 0.528835, 0.533968, 0.539014,
0.543972, 0.548842, 0.553623, 0.558315, 0.562917, 0.567428, 0.57185, 0.57618, 0.580419,
0.584567, 0.588622, 0.592586, 0.596457, 0.600236, 0.603922, 0.607515, 0.611015 },

{0, 0.008697, 0.017392, 0.026085, 0.034772, 0.043453, 0.052126, 0.06079, 0.069442, 0.078082,
0.086708, 0.095318, 0.10391, 0.112484, 0.121037, 0.129568, 0.138075, 0.146557, 0.155013,
0.163441, 0.171838, 0.180205, 0.188539, 0.196839, 0.205103, 0.21333, 0.221519, 0.229668,
0.237775, 0.245839, 0.253859, 0.261834, 0.269761, 0.27764, 0.285469, 0.293248, 0.300973,
0.308645, 0.316263, 0.323823, 0.331326, 0.338771, 0.346155, 0.353478, 0.360739, 0.367936,
0.375068, 0.382135, 0.389134, 0.396065, 0.402927, 0.409719, 0.416439, 0.423087, 0.429662,
0.436162, 0.442587, 0.448936, 0.455208, 0.461402, 0.467517, 0.473552, 0.479507, 0.48538,
0.491172, 0.49688, 0.502505, 0.508046, 0.513502, 0.518872, 0.524156, 0.529354, 0.534464,
0.539486, 0.544419, 0.549264, 0.554019, 0.558685, 0.56326, 0.567745, 0.572139, 0.576441,
0.580652, 0.584771, 0.588798, 0.592733, 0.596575, 0.600325, 0.603981, 0.607545, 0.611015 },

{0, 0.008726, 0.017451, 0.026173, 0.034889, 0.043599, 0.052301, 0.060994, 0.069675, 0.078343,
0.086996, 0.095633, 0.104253, 0.112853, 0.121432, 0.129989, 0.138522, 0.147029, 0.155509,
0.16396, 0.17238, 0.180769, 0.189125, 0.197446, 0.20573, 0.213976, 0.222184, 0.23035, 0.238474,
0.246554, 0.25459, 0.262579, 0.270519, 0.278411, 0.286252, 0.294041, 0.301776, 0.309457,
0.317081, 0.324649, 0.332158, 0.339607, 0.346995, 0.354321, 0.361583, 0.36878, 0.375912,
0.382977, 0.389974, 0.396902, 0.403759, 0.410545, 0.417259, 0.423899, 0.430466, 0.436956,
0.443371, 0.449709, 0.455968, 0.462149, 0.468249, 0.474269, 0.480208, 0.486065, 0.491838,
0.497529, 0.503134, 0.508655, 0.51409, 0.519439, 0.5247, 0.529875, 0.534961, 0.539959,
0.544868, 0.549688, 0.554417, 0.559056, 0.563605, 0.568063, 0.572429, 0.576703, 0.580886,
0.584977, 0.588975, 0.59288, 0.596693, 0.600413, 0.60404, 0.607574, 0.611015 }

};



} //ns Marble

#endif
