//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    /// <remarks>
    ///  @class TabBar plasma/widgets/tabbar.h <Plasma/Widgets/TabBar>
    ///  Provides a Tab bar for use in a tabbed interface where each page is a QGraphicsLayoutItem.
    ///  Only one of them is displayed at a given time. It is possible to add and remove tabs
    ///  or modify their text label or their icon.
    ///   See <see cref="ITabBarSignals"></see> for signals emitted by TabBar
    /// </remarks>        <short> A tab bar widget, to be used for tabbed interfaces. </short>
    [SmokeClass("Plasma::TabBar")]
    public class TabBar : QGraphicsWidget, IDisposable {
        protected TabBar(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(TabBar), this);
        }
        [Q_PROPERTY("KTabBar*", "nativeWidget")]
        public KTabBar NativeWidget {
            get { return (KTabBar) interceptor.Invoke("nativeWidget", "nativeWidget()", typeof(KTabBar)); }
        }
        [Q_PROPERTY("int", "currentIndex")]
        public int CurrentIndex {
            get { return (int) interceptor.Invoke("currentIndex", "currentIndex()", typeof(int)); }
            set { interceptor.Invoke("setCurrentIndex$", "setCurrentIndex(int)", typeof(void), typeof(int), value); }
        }
        [Q_PROPERTY("int", "count")]
        public int Count {
            get { return (int) interceptor.Invoke("count", "count()", typeof(int)); }
        }
        [Q_PROPERTY("QString", "styleSheet")]
        public string StyleSheet {
            get { return (string) interceptor.Invoke("styleSheet", "styleSheet()", typeof(string)); }
            set { interceptor.Invoke("setStyleSheet$", "setStyleSheet(QString)", typeof(void), typeof(string), value); }
        }
        /// <remarks>
        ///  Constructs a new TabBar
        ///  @arg parent the parent of this widget
        ///      </remarks>        <short>    Constructs a new TabBar </short>
        public TabBar(QGraphicsWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("TabBar#", "TabBar(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), parent);
        }
        public TabBar() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("TabBar", "TabBar()", typeof(void));
        }
        /// <remarks>
        ///  Adds a new tab in the desired position
        ///  @arg index the position where to insert the new tab,
        ///             if index <=0 will be the first position,
        ///             if index >= count() will be the last
        ///  @arg icon  the icon for this tab
        ///  @arg label the text label of the tab
        ///  @arg content the page content that will be shown by this tab
        /// </remarks>        <return> the index of the inserted tab
        ///      </return>
        ///         <short>    Adds a new tab in the desired position </short>
        public int InsertTab(int index, QIcon icon, string label, IQGraphicsLayoutItem content) {
            return (int) interceptor.Invoke("insertTab$#$#", "insertTab(int, const QIcon&, const QString&, QGraphicsLayoutItem*)", typeof(int), typeof(int), index, typeof(QIcon), icon, typeof(string), label, typeof(IQGraphicsLayoutItem), content);
        }
        public int InsertTab(int index, QIcon icon, string label) {
            return (int) interceptor.Invoke("insertTab$#$", "insertTab(int, const QIcon&, const QString&)", typeof(int), typeof(int), index, typeof(QIcon), icon, typeof(string), label);
        }
        /// <remarks>
        ///  Adds a new tab in the desired position
        ///  This is an overloaded member provided for convenience
        ///  equivalent to insertTab(index, QIcon(), label);
        ///  @arg index the position where to insert the new tab,
        ///             if index <=0 will be the first position,
        ///             if index >= count() will be the last
        ///  @arg label the text label of the tab
        ///  @arg content the page content that will be shown by this tab
        /// </remarks>        <return> the index of the inserted tab
        ///      </return>
        ///         <short>    Adds a new tab in the desired position  This is an overloaded member provided for convenience  equivalent to insertTab(index, QIcon(), label); </short>
        public int InsertTab(int index, string label, IQGraphicsLayoutItem content) {
            return (int) interceptor.Invoke("insertTab$$#", "insertTab(int, const QString&, QGraphicsLayoutItem*)", typeof(int), typeof(int), index, typeof(string), label, typeof(IQGraphicsLayoutItem), content);
        }
        public int InsertTab(int index, string label) {
            return (int) interceptor.Invoke("insertTab$$", "insertTab(int, const QString&)", typeof(int), typeof(int), index, typeof(string), label);
        }
        /// <remarks>
        ///  Adds a new tab in the last position
        ///  @arg icon  the icon for this tab
        ///  @arg label the text label of the tab
        ///  @arg content the page content that will be shown by this tab
        /// </remarks>        <return> the index of the inserted tab
        ///      </return>
        ///         <short>    Adds a new tab in the last position </short>
        public int AddTab(QIcon icon, string label, IQGraphicsLayoutItem content) {
            return (int) interceptor.Invoke("addTab#$#", "addTab(const QIcon&, const QString&, QGraphicsLayoutItem*)", typeof(int), typeof(QIcon), icon, typeof(string), label, typeof(IQGraphicsLayoutItem), content);
        }
        public int AddTab(QIcon icon, string label) {
            return (int) interceptor.Invoke("addTab#$", "addTab(const QIcon&, const QString&)", typeof(int), typeof(QIcon), icon, typeof(string), label);
        }
        /// <remarks>
        ///  Adds a new tab in the last position
        ///  This is an overloaded member provided for convenience
        ///  equivalent to addTab(QIcon(), label, page)
        ///  @arg label the text label of the tab
        ///  @arg content the page content that will be shown by this tab
        /// </remarks>        <return> the index of the inserted tab
        ///      </return>
        ///         <short>    Adds a new tab in the last position  This is an overloaded member provided for convenience  equivalent to addTab(QIcon(), label, page) </short>
        public int AddTab(string label, IQGraphicsLayoutItem content) {
            return (int) interceptor.Invoke("addTab$#", "addTab(const QString&, QGraphicsLayoutItem*)", typeof(int), typeof(string), label, typeof(IQGraphicsLayoutItem), content);
        }
        public int AddTab(string label) {
            return (int) interceptor.Invoke("addTab$", "addTab(const QString&)", typeof(int), typeof(string), label);
        }
        /// <remarks>
        ///  Removes a tab
        ///  @arg index the index of the tab to remove
        ///      </remarks>        <short>    Removes a tab </short>
        public void RemoveTab(int index) {
            interceptor.Invoke("removeTab$", "removeTab(int)", typeof(void), typeof(int), index);
        }
        /// <remarks>
        ///  Sets the text label of the given tab
        ///  @arg index the index of the tab to modify
        ///  @arg label the new text label of the given tab
        ///      </remarks>        <short>    Sets the text label of the given tab </short>
        public void SetTabText(int index, string label) {
            interceptor.Invoke("setTabText$$", "setTabText(int, const QString&)", typeof(void), typeof(int), index, typeof(string), label);
        }
        /// <remarks>
        ///  @arg index the index of the tab we want to know its label
        ///      </remarks>        <return> the text label of the given tab
        /// </return>
        ///         <short>   </short>
        public string TabText(int index) {
            return (string) interceptor.Invoke("tabText$", "tabText(int) const", typeof(string), typeof(int), index);
        }
        /// <remarks>
        ///  Sets an icon for a given tab
        ///  @arg index the index of the tab to modify
        ///  @arg icon the new icon for the given tab
        ///      </remarks>        <short>    Sets an icon for a given tab </short>
        public void SetTabIcon(int index, QIcon icon) {
            interceptor.Invoke("setTabIcon$#", "setTabIcon(int, const QIcon&)", typeof(void), typeof(int), index, typeof(QIcon), icon);
        }
        /// <remarks>
        ///  @arg index the index of the tab we want to know its icon
        ///      </remarks>        <return> the current icon for a given tab
        /// </return>
        ///         <short>   </short>
        public QIcon TabIcon(int index) {
            return (QIcon) interceptor.Invoke("tabIcon$", "tabIcon(int) const", typeof(QIcon), typeof(int), index);
        }
        /// <remarks>
        ///  Activate a given tab
        ///  @arg index the index of the tab to activate
        ///      </remarks>        <short>    Activate a given tab </short>
        [Q_SLOT("void setCurrentIndex(int)")]
        public void SetCurrentIndex(int index) {
            interceptor.Invoke("setCurrentIndex$", "setCurrentIndex(int)", typeof(void), typeof(int), index);
        }
        [SmokeMethod("wheelEvent(QGraphicsSceneWheelEvent*)")]
        protected override void WheelEvent(QGraphicsSceneWheelEvent arg1) {
            interceptor.Invoke("wheelEvent#", "wheelEvent(QGraphicsSceneWheelEvent*)", typeof(void), typeof(QGraphicsSceneWheelEvent), arg1);
        }
        [SmokeMethod("resizeEvent(QGraphicsSceneResizeEvent*)")]
        protected override void ResizeEvent(QGraphicsSceneResizeEvent arg1) {
            interceptor.Invoke("resizeEvent#", "resizeEvent(QGraphicsSceneResizeEvent*)", typeof(void), typeof(QGraphicsSceneResizeEvent), arg1);
        }
        ~TabBar() {
            interceptor.Invoke("~TabBar", "~TabBar()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~TabBar", "~TabBar()", typeof(void));
        }
        protected new ITabBarSignals Emit {
            get { return (ITabBarSignals) Q_EMIT; }
        }
    }

    public interface ITabBarSignals : IQGraphicsWidgetSignals {
        /// <remarks>
        ///  Emitted when the active tab changes
        ///  @arg index the newly activated tab
        ///      </remarks>        <short>    Emitted when the active tab changes </short>
        [Q_SIGNAL("void currentChanged(int)")]
        void CurrentChanged(int index);
    }
}
