/* This file is part of the KDE project
 * Copyright (C) 2009 Fredy Yanardi <fyanardi@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef SEARCHSUGGESTION_H
#define SEARCHSUGGESTION_H

#include <QtCore/QObject>
#include <kio/jobclasses.h>

class SuggestionEngine;

/**
 * This class acts as a proxy between the SearchBar plugin and the individual suggestion engine.
 * This class has a map of all available engines, and route the suggestion request to the correct engine
 */
class SearchSuggestion : public QObject
{
    Q_OBJECT

public:
    /**
     * Constructor
     */
    explicit SearchSuggestion(QObject *parent = 0);

    /**
     * Check whether a search suggestion engine is available for the given search provider
     * @param searchProvider the queried search provider
     */
    bool isEngineAvailable(const QString &searchProvider);

public slots:
    /**
     * Ask the specific suggestion engine to request for suggestion for the search text
     * @param searchProvider the search provider that provides the suggestion service
     * @param searchText the text to be queried to the suggestion service
     */
    void requestSuggestion(const QString &searchProvider, const QString &searchText);

private slots:
    void jobFinished(KJob *job);
    void dataReceived(KIO::Job *job, const QByteArray &data);

signals:
    void suggestionReceived(const QStringList &suggestion);

private:
    // QString substitutueSearchText(const QString &searchText, const QString &requestURL) const;
    QByteArray m_jobData;
    QMap<QString, SuggestionEngine*> m_enginesMap;
    SuggestionEngine *m_activeEngine;
};

#endif // SEARCHSUGGESTION_H

