//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano {
    using Soprano;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Parser parser.h Soprano/Parser
    ///  \brief Soprano.Parser defines the interface for a Soprano RDF parser plugin.
    ///  Each parser plugin may support multiple RDF serializations (supportedSerializations()).
    ///  \section Usage
    ///  Using a Parser is straightforward. One starts by getting a plugin that supports the requested
    ///  RDF data serialization:
    ///  <pre>
    ///  Soprano.Parser p = Soprano.PluginManager.Instance().DiscoverParserForSerialization( Soprano.SerializationRdfXml );
    ///  </pre>
    ///  Then parsing RDF data is done in a single method call resulting in a StatementIterator over
    ///  the resulting graph (since parsers may support multiple serializations one always needs to
    ///  provide the serialization type unless a parser plugin support autodetection).
    ///  <pre>
    ///  Soprano.StatementIterator it = p.ParseFile( "myrdffile.rdf", Soprano.SerializationRdfXml );
    ///  </pre>
    ///  \sa \ref soprano_writing_plugins
    ///  \author Daniele Galdi <daniele.galdi@gmail.com><br>Sebastian Trueg <trueg@kde.org>
    ///      </remarks>        <short>    \class Parser parser.</short>
    [SmokeClass("Soprano::Parser")]
    public abstract class Parser : Soprano.Plugin, Soprano.Error.IErrorCache {
        protected Parser(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Parser), this);
        }
        // Error lastError(); >>>> NOT CONVERTED
        // void setError(const Error& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  The serialiazation types supported by this parser.
        ///  \return A combination of Soprano.RdfSerialization types. If
        ///  the list contains Soprano.SerializationUser the parser 
        ///  supports additional RDF serialiazations not
        ///  officially supported by %Soprano.
        ///          </remarks>        <short>    The serialiazation types supported by this parser.</short>
        [SmokeMethod("supportedSerializations() const")]
        public abstract uint SupportedSerializations();
        /// <remarks>
        ///  A parser can support additional RDF serializations that are not defined in Soprano.RdfSerialization.
        ///  In that case supportedSerializations() has to include Soprano.SerializationUser.
        ///  The default implementation returns an empty list.
        ///  \return A list of supported user RDF serializations.
        ///          </remarks>        <short>    A parser can support additional RDF serializations that are not defined in Soprano.RdfSerialization.</short>
        [SmokeMethod("supportedUserSerializations() const")]
        public virtual List<string> SupportedUserSerializations() {
            return (List<string>) interceptor.Invoke("supportedUserSerializations", "supportedUserSerializations() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Check if a plugin supports a specific serialization.
        ///  \param s The requested serialization.
        ///  \param userSerialization If serialization is set to Soprano.SerializationUser this parameter specifies the
        ///        requested serialization. It allows the extension of the %Soprano Parser interface with new
        ///        RDF serializations that are not officially supported by %Soprano.
        ///  \return <pre>true</pre> if the parser is able to parse RDF data encoded
        ///  in serialization s, <pre>false</pre> otherwise.
        ///          </remarks>        <short>    Check if a plugin supports a specific serialization.</short>
        public bool SupportsSerialization(Soprano.RdfSerialization s, string userSerialization) {
            return (bool) interceptor.Invoke("supportsSerialization$$", "supportsSerialization(Soprano::RdfSerialization, const QString&) const", typeof(bool), typeof(Soprano.RdfSerialization), s, typeof(string), userSerialization);
        }
        public bool SupportsSerialization(Soprano.RdfSerialization s) {
            return (bool) interceptor.Invoke("supportsSerialization$", "supportsSerialization(Soprano::RdfSerialization) const", typeof(bool), typeof(Soprano.RdfSerialization), s);
        }
        /// <remarks>
        ///  Parse an RDF model which has been serialized in a file,
        ///  using the supplied baseURI to resolve any relative URI references.
        ///  The default implementation simply calls parseStream() on an opened
        ///  QFile instance.
        ///  \param filename The name (path) of the file to parse
        ///  \param baseUri The base URI to be used for relative references.
        ///  \param serialization The serialization used in the file.
        ///  \param userSerialization If serialization is set to Soprano.SerializationUser this parameter specifies the
        ///        serialization to use. It allows the extension of the %Soprano Parser interface with new
        ///        RDF serializations that are not officially supported by %Soprano.
        ///  \return An iterator that iterates over the result statements.
        ///          </remarks>        <short>    Parse an RDF model which has been serialized in a file,  using the supplied baseURI to resolve any relative URI references.</short>
        [SmokeMethod("parseFile(const QString&, const QUrl&, Soprano::RdfSerialization, const QString&) const")]
        public virtual Soprano.StatementIterator ParseFile(string filename, QUrl baseUri, Soprano.RdfSerialization serialization, string userSerialization) {
            return (Soprano.StatementIterator) interceptor.Invoke("parseFile$#$$", "parseFile(const QString&, const QUrl&, Soprano::RdfSerialization, const QString&) const", typeof(Soprano.StatementIterator), typeof(string), filename, typeof(QUrl), baseUri, typeof(Soprano.RdfSerialization), serialization, typeof(string), userSerialization);
        }
        [SmokeMethod("parseFile(const QString&, const QUrl&, Soprano::RdfSerialization) const")]
        public virtual Soprano.StatementIterator ParseFile(string filename, QUrl baseUri, Soprano.RdfSerialization serialization) {
            return (Soprano.StatementIterator) interceptor.Invoke("parseFile$#$", "parseFile(const QString&, const QUrl&, Soprano::RdfSerialization) const", typeof(Soprano.StatementIterator), typeof(string), filename, typeof(QUrl), baseUri, typeof(Soprano.RdfSerialization), serialization);
        }
        /// <remarks>
        ///  Parse an RDF model which has been serialized into a string,
        ///  using the supplied baseURI to resolve any relative URI references.
        ///  The default implementation simply calls parseStream().
        ///  \param data The serialized RDF string.
        ///  \param baseUri The base URI to be used for relative references.
        ///  \param serialization The serialization used for the string data.
        ///  \param userSerialization If serialization is set to Soprano.SerializationUser this parameter specifies the
        ///        serialization to use. It allows the extension of the %Soprano Parser interface with new
        ///        RDF serializations that are not officially supported by %Soprano.
        ///  \return An iterator that iterates over the result statements.
        ///          </remarks>        <short>    Parse an RDF model which has been serialized into a string,  using the supplied baseURI to resolve any relative URI references.</short>
        [SmokeMethod("parseString(const QString&, const QUrl&, Soprano::RdfSerialization, const QString&) const")]
        public virtual Soprano.StatementIterator ParseString(string data, QUrl baseUri, Soprano.RdfSerialization serialization, string userSerialization) {
            return (Soprano.StatementIterator) interceptor.Invoke("parseString$#$$", "parseString(const QString&, const QUrl&, Soprano::RdfSerialization, const QString&) const", typeof(Soprano.StatementIterator), typeof(string), data, typeof(QUrl), baseUri, typeof(Soprano.RdfSerialization), serialization, typeof(string), userSerialization);
        }
        [SmokeMethod("parseString(const QString&, const QUrl&, Soprano::RdfSerialization) const")]
        public virtual Soprano.StatementIterator ParseString(string data, QUrl baseUri, Soprano.RdfSerialization serialization) {
            return (Soprano.StatementIterator) interceptor.Invoke("parseString$#$", "parseString(const QString&, const QUrl&, Soprano::RdfSerialization) const", typeof(Soprano.StatementIterator), typeof(string), data, typeof(QUrl), baseUri, typeof(Soprano.RdfSerialization), serialization);
        }
        /// <remarks>
        ///  Read a serialized RDF model from a test stream,
        ///  using the supplied baseURI to resolve any relative URI references.
        ///  \param stream The text stream to read the serialized RDF data from.
        ///  \param baseUri The base URI to be used for relative references.
        ///  \param serialization The serialization used for the string data from the stream.
        ///  \param userSerialization If serialization is set to Soprano.SerializationUser this parameter specifies the
        ///        serialization to use. It allows the extension of the %Soprano Parser interface with new
        ///        RDF serializations that are not officially supported by %Soprano.
        ///  \return An iterator that iterates over the result statements.
        ///          </remarks>        <short>    Read a serialized RDF model from a test stream,  using the supplied baseURI to resolve any relative URI references.</short>
        [SmokeMethod("parseStream(QTextStream&, const QUrl&, Soprano::RdfSerialization, const QString&) const")]
        public abstract Soprano.StatementIterator ParseStream(QTextStream stream, QUrl baseUri, Soprano.RdfSerialization serialization, string userSerialization);
        public Parser(string name) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Parser$", "Parser(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Get the last error that occured in the current thread.
        ///              </remarks>        <short>    Get the last error that occured in the current thread.</short>
        /// <remarks>
        ///  Reset the error for the current thread to no error.
        ///              </remarks>        <short>    Reset the error for the current thread to no error.</short>
        protected void ClearError() {
            interceptor.Invoke("clearError", "clearError() const", typeof(void));
        }
        /// <remarks>
        ///  Set the last occured error. This method is const to allow setting
        ///  of errors in all types of methods. The last error is as such a 
        ///  mutable property.
        ///              </remarks>        <short>    Set the last occured error.</short>
        /// <remarks>
        ///  Convenience method to set simple string error messages with a default
        ///  error code ErrorUnknown.
        ///              </remarks>        <short>    Convenience method to set simple string error messages with a default  error code ErrorUnknown.</short>
        protected void SetError(string errorMessage, int code) {
            interceptor.Invoke("setError$$", "setError(const QString&, int) const", typeof(void), typeof(string), errorMessage, typeof(int), code);
        }
        protected void SetError(string errorMessage) {
            interceptor.Invoke("setError$", "setError(const QString&) const", typeof(void), typeof(string), errorMessage);
        }
    }
}
