//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @brief Encapsulates a KCModule for embedding.
    ///  KCModuleProxy is a wrapper for KCModule intended for cases where
    ///  modules are to be displayed. It ensures layout is consistent
    ///  and in general takes care of the details
    ///  needed for making a module available in an interface. A KCModuleProxy
    ///  can be treated as a QWidget, without worrying about the details specific
    ///  for modules such as library loading. KCModuleProxy is not a sub class of KCModule
    ///  but its API closely resembles KCModule's.\n
    ///  Usually, an instance is created by passing one of the constructors a KService.Ptr,
    ///  KCModuleInfo or simply the name of the module and then added to the layout as any
    ///  other widget. \n
    ///  When the user has changed the module, changed(bool) as well as changed(KCModuleProxy )
    ///  is emitted. KCModuleProxy does not take care of prompting for saving - if the object is deleted while
    ///  changes is not saved the changes will be lost. changed() returns true if changes are unsaved. \n
    ///  \n
    ///  KCModuleProxy does not take care of authorization of KCModules. \n
    ///  KCModuleProxy implements lazy loading, meaning the library will not be loaded or
    ///  any other initialization done before its show() function is called. This means
    ///  modules will only be loaded when they are actually needed as well as it is possible to
    ///  load many KCModuleProxy without any speed penalty.
    ///  KCModuleProxy should be used in all cases where modules are embedded in order to
    ///  promote code efficiency and usability consistency.
    ///   See <see cref="IKCModuleProxySignals"></see> for signals emitted by KCModuleProxy
    /// </remarks>        <author> Matthias Kretz <kretz@kde.org>
    /// </author>
    ///         <short>   </short>
    [SmokeClass("KCModuleProxy")]
    public class KCModuleProxy : QWidget, IDisposable {
        protected KCModuleProxy(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KCModuleProxy), this);
        }
        /// <remarks>
        ///  Constructs a KCModuleProxy from a KCModuleInfo class.
        /// <param> name="info" The KCModuleInfo to construct the module from.
        /// </param><param> name="parent" the parent QWidget.
        /// </param><param> name="args" This is used in the implementation and is internal.
        ///  Use the default.
        /// 	 </param></remarks>        <short>    Constructs a KCModuleProxy from a KCModuleInfo class.</short>
        public KCModuleProxy(KCModuleInfo info, QWidget parent, List<string> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy##?", "KCModuleProxy(const KCModuleInfo&, QWidget*, const QStringList&)", typeof(void), typeof(KCModuleInfo), info, typeof(QWidget), parent, typeof(List<string>), args);
        }
        public KCModuleProxy(KCModuleInfo info, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy##", "KCModuleProxy(const KCModuleInfo&, QWidget*)", typeof(void), typeof(KCModuleInfo), info, typeof(QWidget), parent);
        }
        public KCModuleProxy(KCModuleInfo info) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy#", "KCModuleProxy(const KCModuleInfo&)", typeof(void), typeof(KCModuleInfo), info);
        }
        /// <remarks>
        ///  Constructs a KCModuleProxy from a module's service name, which is
        ///  equivalent to the desktop file for the kcm without the ".desktop" part.
        ///  Otherwise equal to the one above.
        /// <param> name="serviceName" The module's service name to construct from.
        /// </param><param> name="parent" the parent QWidget.
        /// </param><param> name="args" This is used in the implementation and is internal.
        ///  Use the default.
        /// 	 </param></remarks>        <short>    Constructs a KCModuleProxy from a module's service name, which is  equivalent to the desktop file for the kcm without the ".</short>
        public KCModuleProxy(string serviceName, QWidget parent, List<string> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy$#?", "KCModuleProxy(const QString&, QWidget*, const QStringList&)", typeof(void), typeof(string), serviceName, typeof(QWidget), parent, typeof(List<string>), args);
        }
        public KCModuleProxy(string serviceName, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy$#", "KCModuleProxy(const QString&, QWidget*)", typeof(void), typeof(string), serviceName, typeof(QWidget), parent);
        }
        public KCModuleProxy(string serviceName) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy$", "KCModuleProxy(const QString&)", typeof(void), typeof(string), serviceName);
        }
        /// <remarks>
        ///  Constructs a KCModuleProxy from KService. Otherwise equal to the one above.
        /// <param> name="service" The KService to construct from.
        /// </param><param> name="parent" the parent QWidget.
        /// </param><param> name="args" This is used in the implementation and is internal.
        ///  Use the default.
        /// 	 </param></remarks>        <short>    Constructs a KCModuleProxy from KService.</short>
        public KCModuleProxy(KService service, QWidget parent, List<string> args) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy?#?", "KCModuleProxy(const KSharedPtr<KService>&, QWidget*, const QStringList&)", typeof(void), typeof(KService), service, typeof(QWidget), parent, typeof(List<string>), args);
        }
        public KCModuleProxy(KService service, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy?#", "KCModuleProxy(const KSharedPtr<KService>&, QWidget*)", typeof(void), typeof(KService), service, typeof(QWidget), parent);
        }
        public KCModuleProxy(KService service) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KCModuleProxy?", "KCModuleProxy(const KSharedPtr<KService>&)", typeof(void), typeof(KService), service);
        }
        /// <remarks>
        ///  Calling it will cause the contained module to
        ///  run its load() routine.
        /// 	 </remarks>        <short>    Calling it will cause the contained module to  run its load() routine.</short>
        public void Load() {
            interceptor.Invoke("load", "load()", typeof(void));
        }
        /// <remarks>
        ///  Calling it will cause the contained module to
        ///  run its save() routine.
        ///  If the module was not modified, it will not be asked
        ///  to save.
        /// 	 </remarks>        <short>    Calling it will cause the contained module to  run its save() routine.</short>
        public void Save() {
            interceptor.Invoke("save", "save()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> the module's quickHelp();
        /// 	 </return>
        ///         <short>   </short>
        public string QuickHelp() {
            return (string) interceptor.Invoke("quickHelp", "quickHelp() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> the module's aboutData()
        /// 	 </return>
        ///         <short>   </short>
        public KAboutData AboutData() {
            return (KAboutData) interceptor.Invoke("aboutData", "aboutData() const", typeof(KAboutData));
        }
        /// <remarks>
        /// </remarks>        <return> what buttons the module
        ///  needs
        /// 	 </return>
        ///         <short>   </short>
        public uint Buttons() {
            return (uint) interceptor.Invoke("buttons", "buttons() const", typeof(uint));
        }
        /// <remarks>
        /// </remarks>        <return> true if the module is modified
        ///  and needs to be saved.
        /// 	 </return>
        ///         <short>   </short>
        public bool Changed() {
            return (bool) interceptor.Invoke("changed", "changed() const", typeof(bool));
        }
        /// <remarks>
        ///  Access to the actual module. However, if the module is
        ///  running in root mode, see rootMode(), this function returns
        ///  a NULL pointer, since the module is in another process. It may also
        ///  return NULL if anything goes wrong.
        /// </remarks>        <return> the encapsulated module.
        /// 	 </return>
        ///         <short>    Access to the actual module.</short>
        public KCModule RealModule() {
            return (KCModule) interceptor.Invoke("realModule", "realModule() const", typeof(KCModule));
        }
        /// <remarks>
        /// </remarks>        <return> a KCModuleInfo for the encapsulated
        ///  module
        /// 	 </return>
        ///         <short>   </short>
        public KCModuleInfo ModuleInfo() {
            return (KCModuleInfo) interceptor.Invoke("moduleInfo", "moduleInfo() const", typeof(KCModuleInfo));
        }
        /// <remarks>
        ///  Returns the DBUS Service name
        /// 	 </remarks>        <short>    Returns the DBUS Service name 	 </short>
        public string DbusService() {
            return (string) interceptor.Invoke("dbusService", "dbusService() const", typeof(string));
        }
        /// <remarks>
        ///  Returns the DBUS Path
        ///      </remarks>        <short>    Returns the DBUS Path      </short>
        public string DbusPath() {
            return (string) interceptor.Invoke("dbusPath", "dbusPath() const", typeof(string));
        }
        [SmokeMethod("minimumSizeHint() const")]
        public override QSize MinimumSizeHint() {
            return (QSize) interceptor.Invoke("minimumSizeHint", "minimumSizeHint() const", typeof(QSize));
        }
        /// <remarks>
        ///  Calling it will cause the contained module to
        ///  load its default values.
        /// 	 </remarks>        <short>    Calling it will cause the contained module to  load its default values.</short>
        [Q_SLOT("void defaults()")]
        public void Defaults() {
            interceptor.Invoke("defaults", "defaults()", typeof(void));
        }
        /// <remarks>
        ///  Calling this, results in deleting the contained
        ///  module, and unregistering from DCOP. A similar result is achieved
        ///  by deleting the KCModuleProxy itself.
        /// 	 </remarks>        <short>    Calling this, results in deleting the contained  module, and unregistering from DCOP.</short>
        [Q_SLOT("void deleteClient()")]
        public void DeleteClient() {
            interceptor.Invoke("deleteClient", "deleteClient()", typeof(void));
        }
        /// <remarks>
        ///  Reimplemented for internal purposes. Makes sure the encapsulated
        ///  module is loaded before the show event is taken care of.
        /// 	 </remarks>        <short>    Reimplemented for internal purposes.</short>
        [SmokeMethod("showEvent(QShowEvent*)")]
        protected override void ShowEvent(QShowEvent arg1) {
            interceptor.Invoke("showEvent#", "showEvent(QShowEvent*)", typeof(void), typeof(QShowEvent), arg1);
        }
        ~KCModuleProxy() {
            interceptor.Invoke("~KCModuleProxy", "~KCModuleProxy()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KCModuleProxy", "~KCModuleProxy()", typeof(void));
        }
        protected new IKCModuleProxySignals Emit {
            get { return (IKCModuleProxySignals) Q_EMIT; }
        }
    }

    public interface IKCModuleProxySignals : IQWidgetSignals {
        [Q_SIGNAL("void changed(bool)")]
        void Changed(bool state);
        /// <remarks>
        ///  This is emitted in the same situations as in the one above. Practical
        ///  when several KCModuleProxys are loaded.
        /// 	 </remarks>        <short>    This is emitted in the same situations as in the one above.</short>
        [Q_SIGNAL("void changed(KCModuleProxy*)")]
        void Changed(KCModuleProxy mod);
        /// <remarks>
        ///  When a module running with root privileges and exits, returns to normal mode, the
        ///  childClosed() signal is emitted.
        /// 	 </remarks>        <short>    When a module running with root privileges and exits, returns to normal mode, the  childClosed() signal is emitted.</short>
        [Q_SIGNAL("void childClosed()")]
        void ChildClosed();
        [Q_SIGNAL("void quickHelpChanged()")]
        void QuickHelpChanged();
    }
}
