//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    /// <remarks>
    ///  @class AuthorizationRule plasma/authorizationrule.h <Plasma/AuthorizationRule>
    ///  Rules allow you to have control over which computers are allowed to access which
    ///  services. Every time a message get's in, AuthorizationManager validates it's sender, and then
    ///  checks it's list of rules for rules matching the sender and/or the service. If no rules match,
    ///  or all matching rules have the value Unspecified, AuthorizationManager will create a new rule
    ///  for this message, and invoke authorize on your shells implementation of AuthorizationInterface.
    ///  Here, you can change that rule to either allow or deny that request.
    ///  This class can be used to specify different types of rules:
    ///  - Rules matching only a user
    ///  - Rules matching only a service
    ///  - Rules matching both a service, and a user.
    ///  A more specific rule always takes precedence over a more global rule: so if for example you have
    ///  a rule for "myAwesomeService" specifying Deny, and a rule for "myAwesomeService" in combination
    ///  with "130.42.120.146" as caller specifying Allow, only 130.42.120.146 can access
    ///  myAwesomeService.
    ///  By setting the PinRequired flag in setRules in an AuthorizationInterface implementation, you
    ///  trigger Pin pairing (user will be asked to enter the same password on both machines).
    /// </remarks>        <short> Defines a rule indicating whether or not a certain service can be accessed by a certain  machine. </short>
    [SmokeClass("Plasma::AuthorizationRule")]
    public class AuthorizationRule : QObject {
        protected AuthorizationRule(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(AuthorizationRule), this);
        }
        public enum Policy {
            Deny = 0,
            Allow = 1,
            PinRequired = 2,
        }
        public enum Persistence {
            Transient = 0,
            Persistent = 1,
        }
        public enum Target {
            Default = 0,
            AllUsers = 1,
            AllServices = 2,
        }
        /// <remarks>
        /// </remarks>        <return> a friendly and i18n'd description of the current rule, useful for creating a
        ///  GUI to allow editing rules, or asking permission for an access attempt.
        ///          </return>
        ///         <short>   </short>
        public string Description() {
            return (string) interceptor.Invoke("description", "description() const", typeof(string));
        }
        /// <remarks>
        /// <param> name="rules" the flags describing this rule.
        ///          </param></remarks>        <short>   </short>
        public void SetPolicy(Plasma.AuthorizationRule.Policy policy) {
            interceptor.Invoke("setPolicy$", "setPolicy(Plasma::AuthorizationRule::Policy)", typeof(void), typeof(Plasma.AuthorizationRule.Policy), policy);
        }
        /// <remarks>
        /// </remarks>        <return> the flags describing this rule.
        ///          </return>
        ///         <short>   </short>
        public Plasma.AuthorizationRule.Policy policy() {
            return (Plasma.AuthorizationRule.Policy) interceptor.Invoke("policy", "policy()", typeof(Plasma.AuthorizationRule.Policy));
        }
        /// <remarks>
        /// <param> name="rules" the flags describing this rule.
        ///          </param></remarks>        <short>   </short>
        public void SetPersistence(Plasma.AuthorizationRule.Persistence persistence) {
            interceptor.Invoke("setPersistence$", "setPersistence(Plasma::AuthorizationRule::Persistence)", typeof(void), typeof(Plasma.AuthorizationRule.Persistence), persistence);
        }
        /// <remarks>
        /// </remarks>        <return> the flags describing this rule.
        ///          </return>
        ///         <short>   </short>
        public Plasma.AuthorizationRule.Persistence persistence() {
            return (Plasma.AuthorizationRule.Persistence) interceptor.Invoke("persistence", "persistence()", typeof(Plasma.AuthorizationRule.Persistence));
        }
        /// <remarks>
        /// <param> name="rules" the flags describing this rule.
        ///          </param></remarks>        <short>   </short>
        public void SetTargets(uint targets) {
            interceptor.Invoke("setTargets$", "setTargets(Plasma::AuthorizationRule::Targets)", typeof(void), typeof(uint), targets);
        }
        /// <remarks>
        /// </remarks>        <return> the flags describing this rule.
        ///          </return>
        ///         <short>   </short>
        public uint Targets() {
            return (uint) interceptor.Invoke("targets", "targets()", typeof(uint));
        }
        /// <remarks>
        /// <param> name="pin" set pin for pin pairing. You'll need to call this bevore setting the rule.
        ///          </param></remarks>        <short>   </short>
        public void SetPin(string pin) {
            interceptor.Invoke("setPin$", "setPin(const QString&)", typeof(void), typeof(string), pin);
        }
        /// <remarks>
        /// </remarks>        <return> the pin for pin pairing.
        ///          </return>
        ///         <short>   </short>
        public string Pin() {
            return (string) interceptor.Invoke("pin", "pin() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> the identity of the caller.
        ///          </return>
        ///         <short>   </short>
        // public Plasma.Credentials Credentials() {
        //     return (Plasma.Credentials) interceptor.Invoke("credentials", "credentials() const", typeof(Plasma.Credentials));
        // }
        /// <remarks>
        /// </remarks>        <return> the name of the service this rule applies to.
        ///          </return>
        ///         <short>   </short>
        public string ServiceName() {
            return (string) interceptor.Invoke("serviceName", "serviceName() const", typeof(string));
        }
        protected new IAuthorizationRuleSignals Emit {
            get { return (IAuthorizationRuleSignals) Q_EMIT; }
        }
    }

    public interface IAuthorizationRuleSignals : IQObjectSignals {
    }
}
