//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano {
    using Soprano;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \class Node node.h Soprano/Node
    ///  \brief A Node represents one RDF resource.
    ///  Nodes are the cornerstone of RDF data in %Soprano. Four Nodes form one Statement and a Model
    ///  is essentially a set of Statements.
    ///  A Node can have one of four types: EmptyNode, ResourceNode, LiteralNode, and BlankNode.
    ///  Resource nodes are identified through their URI (uri()), literal nodes have a LiteralValue (literal())
    ///  and an optional language string (language()), and blank nodes have a string identifier.
    ///  Empty nodes can be used as wildcards in methods such as Model.ListStatements.
    ///  \warning Be aware that string literals in %Soprano always have type
    ///  xsd:string. There is no direct support for rdfs:Literal. Backend implementations
    ///  should honour this restriction.
    ///  \author Daniele Galdi <daniele.galdi@gmail.com><br>Sebastian Trueg <trueg@kde.org>
    ///      </remarks>        <short>    \class Node node.</short>
    [SmokeClass("Soprano::Node")]
    public class Node : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected Node(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Node), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Node() {
            staticInterceptor = new SmokeInvocation(typeof(Node), null);
        }
        public enum TypeOf {
            EmptyNode = 0,
            ResourceNode = 1,
            LiteralNode = 2,
            BlankNode = 3,
        }
        /// <remarks>
        ///  Default costructor.
        ///  Creates an empty node.
        ///  \sa createEmptyNode()
        ///          </remarks>        <short>    Default costructor.</short>
        public Node() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Node", "Node()", typeof(void));
        }
        /// <remarks>
        ///  Creates a resource node.
        ///  \param uri The URI of the node. If empty the type will be ignored
        ///             and an empty node will be created.
        ///  \sa createResourceNode()
        ///          </remarks>        <short>    Creates a resource node.</short>
        public Node(QUrl uri) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Node#", "Node(const QUrl&)", typeof(void), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  Creates a blank node.
        ///  \param id An identifier for the blank node.
        ///  \sa createBlankNode()
        ///          </remarks>        <short>    Creates a blank node.</short>
        public Node(string id) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Node$", "Node(const QString&)", typeof(void), typeof(string), id);
        }
        /// <remarks>
        ///  Creates a literal node.
        ///  \param value The value of a node. If empty the node will become
        ///               an empty node.
        ///  \param language The language of the literal value.
        ///  \sa createLiteralNode()
        ///          </remarks>        <short>    Creates a literal node.</short>
        public Node(Soprano.LiteralValue value, string language) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Node#$", "Node(const Soprano::LiteralValue&, const QString&)", typeof(void), typeof(Soprano.LiteralValue), value, typeof(string), language);
        }
        public Node(Soprano.LiteralValue value) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Node#", "Node(const Soprano::LiteralValue&)", typeof(void), typeof(Soprano.LiteralValue), value);
        }
        public Node(Soprano.Node other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Node#", "Node(const Soprano::Node&)", typeof(void), typeof(Soprano.Node), other);
        }
        public override bool Equals(object o) {
            if (!(o is Node)) { return false; }
            return this == (Node) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Match this node against other. The only difference
        ///  to operator== is that empty nodes are matched as wildcards,
        ///  i.e. they match any other node.
        ///  \return true if this node matches other, false if not.
        ///          </remarks>        <short>    Match this node against other.</short>
        public bool Matches(Soprano.Node other) {
            return (bool) interceptor.Invoke("matches#", "matches(const Soprano::Node&) const", typeof(bool), typeof(Soprano.Node), other);
        }
        /// <remarks>
        ///  \return The Node type.
        ///          </remarks>        <short>    \return The Node type.</short>
        public Soprano.Node.TypeOf type() {
            return (Soprano.Node.TypeOf) interceptor.Invoke("type", "type() const", typeof(Soprano.Node.TypeOf));
        }
        /// <remarks>
        ///  \return true if the Node is empty.
        ///          </remarks>        <short>    \return true if the Node is empty.</short>
        public bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        /// <remarks>
        ///  \return true if the Node is a Resource,Literal or Blank.
        ///          </remarks>        <short>    \return true if the Node is a Resource,Literal or Blank.</short>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  \return true if the Node is a Literal.
        ///          </remarks>        <short>    \return true if the Node is a Literal.</short>
        public bool IsLiteral() {
            return (bool) interceptor.Invoke("isLiteral", "isLiteral() const", typeof(bool));
        }
        /// <remarks>
        ///  \return true if the Node is a Resource.
        ///          </remarks>        <short>    \return true if the Node is a Resource.</short>
        public bool IsResource() {
            return (bool) interceptor.Invoke("isResource", "isResource() const", typeof(bool));
        }
        /// <remarks>
        ///  \return true if the Node is a Blank node (anonymous).
        ///          </remarks>        <short>    \return true if the Node is a Blank node (anonymous).</short>
        public bool IsBlank() {
            return (bool) interceptor.Invoke("isBlank", "isBlank() const", typeof(bool));
        }
        /// <remarks>
        ///  \return The URI if the node is a Resource node.
        ///          An null QUrl otherwise.
        ///          </remarks>        <short>    \return The URI if the node is a Resource node.</short>
        public QUrl Uri() {
            return (QUrl) interceptor.Invoke("uri", "uri() const", typeof(QUrl));
        }
        /// <remarks>
        ///  Retrieve a blank node's identifier.
        ///  \return The node's identifier if it is a blank node, a null
        ///  string otherwise.
        ///          </remarks>        <short>    Retrieve a blank node's identifier.</short>
        public string Identifier() {
            return (string) interceptor.Invoke("identifier", "identifier() const", typeof(string));
        }
        /// <remarks>
        ///  \return The Literal value if the node is a Literal node.
        ///          An null string otherwise.
        ///          </remarks>        <short>    \return The Literal value if the node is a Literal node.</short>
        public Soprano.LiteralValue Literal() {
            return (Soprano.LiteralValue) interceptor.Invoke("literal", "literal() const", typeof(Soprano.LiteralValue));
        }
        /// <remarks>
        ///  \return The datatype URI of a literal node, i.e. the XML schema type
        ///          or an empty value if the node is not a literal.
        ///  \sa LiteralValue.DataTypeUri
        ///          </remarks>        <short>    \return The datatype URI of a literal node, i.</short>
        public QUrl DataType() {
            return (QUrl) interceptor.Invoke("dataType", "dataType() const", typeof(QUrl));
        }
        /// <remarks>
        ///  Each literal value can have an associated language, thus each property
        ///  can be stored for different languages. An empty language refers to the
        ///  default language.
        ///  \return A string representing the language of the literal value
        ///          or an empty string if the node is not a literal.
        ///          </remarks>        <short>    Each literal value can have an associated language, thus each property  can be stored for different languages.</short>
        public string Language() {
            return (string) interceptor.Invoke("language", "language() const", typeof(string));
        }
        /// <remarks>
        ///  Converts the Node to a string.
        ///  \return A String representation of the Node, suitable for storage,
        ///  not really suitable for user readable strings.
        ///  \sa LiteralValue.ToString(), QUrl.ToString(), toN3()
        ///          </remarks>        <short>    Converts the Node to a string.</short>
        public new string ToString() {
            return (string) interceptor.Invoke("toString", "toString() const", typeof(string));
        }
        /// <remarks>
        ///  Convert a Node into N3 notation to be used in SPARQL graph patterns.
        ///  \return A string representing the node in N3 encoding or an empty
        ///  string for invalid nodes.
        ///  \sa toString()
        ///  \since 2.2
        ///          </remarks>        <short>    Convert a Node into N3 notation to be used in SPARQL graph patterns.</short>
        public string ToN3() {
            return (string) interceptor.Invoke("toN3", "toN3() const", typeof(string));
        }
        ~Node() {
            interceptor.Invoke("~Node", "~Node()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Node", "~Node()", typeof(void));
        }
        public static bool operator==(Node lhs, Soprano.Node other) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const Soprano::Node&) const", typeof(bool), typeof(Node), lhs, typeof(Soprano.Node), other);
        }
        public static bool operator!=(Node lhs, Soprano.Node other) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const Soprano::Node&) const", typeof(bool), typeof(Node), lhs, typeof(Soprano.Node), other);
        }
        public static bool operator==(Node lhs, QUrl other) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const QUrl&) const", typeof(bool), typeof(Node), lhs, typeof(QUrl), other);
        }
        public static bool operator!=(Node lhs, QUrl other) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const QUrl&) const", typeof(bool), typeof(Node), lhs, typeof(QUrl), other);
        }
        public static bool operator==(Node lhs, Soprano.LiteralValue other) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const Soprano::LiteralValue&) const", typeof(bool), typeof(Node), lhs, typeof(Soprano.LiteralValue), other);
        }
        public static bool operator!=(Node lhs, Soprano.LiteralValue other) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const Soprano::LiteralValue&) const", typeof(bool), typeof(Node), lhs, typeof(Soprano.LiteralValue), other);
        }
        /// <remarks>
        ///  Convenience method to create an empty node.
        ///  Using this method instead of the default constructor
        ///  may result in better readable code.
        ///  \return An empty Node.
        ///          </remarks>        <short>    Convenience method to create an empty node.</short>
        public static Soprano.Node CreateEmptyNode() {
            return (Soprano.Node) staticInterceptor.Invoke("createEmptyNode", "createEmptyNode()", typeof(Soprano.Node));
        }
        /// <remarks>
        ///  Convenience method to create a resource node.
        ///  Using this method instead of the constructor
        ///  may result in better readable code.
        ///  \param uri The URI of the node. If empty the type will be ignored
        ///             and an empty node will be created.
        ///  \return A resource Node or an empty Node if the specified URI is empty.
        ///          </remarks>        <short>    Convenience method to create a resource node.</short>
        public static Soprano.Node CreateResourceNode(QUrl uri) {
            return (Soprano.Node) staticInterceptor.Invoke("createResourceNode#", "createResourceNode(const QUrl&)", typeof(Soprano.Node), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  Convenience method to create a blank node.
        ///  Using this method instead of the constructor
        ///  may result in better readable code.
        ///  If you need to create a new blank node which is not
        ///  used in the model yet and, thus, has a unique identifier
        ///  see Model.CreateBlankNode().
        ///  \param id An identifier for the blank node.
        ///  \return A blank node or an empty Node if the specified
        ///  identifier was empty.
        ///          </remarks>        <short>    Convenience method to create a blank node.</short>
        public static Soprano.Node CreateBlankNode(string id) {
            return (Soprano.Node) staticInterceptor.Invoke("createBlankNode$", "createBlankNode(const QString&)", typeof(Soprano.Node), typeof(string), id);
        }
        /// <remarks>
        ///  Convenience method to create a literal node.
        ///  Using this method instead of the constructor
        ///  may result in better readable code.
        ///  \param value The value of a node. If empty the node will become
        ///               an empty node.
        ///  \param language The language of the literal value.
        ///  \return A literal node or an empty node if the specified value
        ///  was empty.
        ///          </remarks>        <short>    Convenience method to create a literal node.</short>
        public static Soprano.Node CreateLiteralNode(Soprano.LiteralValue value, string language) {
            return (Soprano.Node) staticInterceptor.Invoke("createLiteralNode#$", "createLiteralNode(const Soprano::LiteralValue&, const QString&)", typeof(Soprano.Node), typeof(Soprano.LiteralValue), value, typeof(string), language);
        }
    }
}
