//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  \brief A text widget with KXMLGUIClient that represents a Document.
    ///  Topics:
    ///   - \ref view_intro
    ///   - \ref view_hook_into_gui
    ///   - \ref view_selection
    ///   - \ref view_cursors
    ///   - \ref view_mouse_tracking
    ///   - \ref view_modes
    ///   - \ref view_extensions
    ///  \section view_intro Introduction
    ///  The View class represents a single view of a KTextEditor.Document,
    ///  get the document on which the view operates with document().
    ///  A view provides both the graphical representation of the text and the
    ///  KXMLGUIClient for the actions. The view itself does not provide
    ///  text manipulation, use the methods from the Document instead. The only
    ///  method to insert text is insertText(), which inserts the given text
    ///  at the current cursor position and emits the signal textInserted().
    ///  Usually a view is created by using Document.CreateView().
    ///  Furthermore a view can have a context menu. Set it with setContextMenu()
    ///  and get it with contextMenu().
    ///  \section view_hook_into_gui Merging the View's GUI
    ///  A View is derived from the class KXMLGUIClient, so its GUI elements (like
    ///  menu entries and toolbar items) can be merged into the application's GUI
    ///  (or into a KXMLGUIFactory) by calling
    ///  <pre>
    ///  // view is of type KTextEditor.View
    ///  mainWindow().GuiFactory().AddClient( view );
    ///  </pre>
    ///  You can add only one view as client, so if you have several views, you first
    ///  have to remove the current view, and then add the new one, like this
    ///  <pre>
    ///  mainWindow().GuiFactory().RemoveClient( currentView );
    ///  mainWindow().GuiFactory().AddClient( newView );
    ///  </pre>
    ///  \section view_selection Text Selection
    ///  As the view is a graphical text editor it provides \e normal and \e block
    ///  text selection. You can check with selection() whether a selection exists.
    ///  removeSelection() will remove the selection without removing the text,
    ///  whereas removeSelectionText() also removes both, the selection and the
    ///  selected text. Use selectionText() to get the selected text and
    ///  setSelection() to specify the selected textrange. The signal
    ///  selectionChanged() is emitted whenever the selecteion changed.
    ///  \section view_cursors Cursor Positions
    ///  A view has one Cursor which represents a line/column tuple. Two different
    ///  kinds of cursor positions are supported: first is the \e real cursor
    ///  position where a \e tab character only counts one character. Second is the
    ///  \e cursor position, where a \e tab character counts as many
    ///  spaces as defined. Get the real position with cursorPosition() and the
    ///  position with cursorPositionVirtual(). Set the real cursor
    ///  position with setCursorPosition(). You can even get the screen coordinates
    ///  of the current cursor position in pixel by using
    ///  cursorPositionCoordinates(). The signal cursorPositionChanged() is emitted
    ///  whenever the cursor position changed.
    ///  \section view_mouse_tracking Mouse Tracking
    ///  It is possible to get notified via the signal mousePositionChanged() for
    ///  mouse move events, if mouseTrackingEnabled() returns \e true. Mouse tracking
    ///  can be turned on/off by calling setMouseTrackingEnabled(). If an editor
    ///  implementation does not support mouse tracking, mouseTrackingEnabled() will
    ///  always return \e false.
    ///  \section view_modes Edit Modes
    ///  A view supports several edit modes (EditMode). Common edit modes are
    ///  \e insert-mode (INS) and \e overwrite-mode (OVR). Which edit modes the
    ///  editor supports depends on the implementation, another well-known mode is
    ///  the \e command-mode for example in vim and yzis. The getter viewMode()
    ///  returns a string like <pre>INS</pre> or <pre>OVR</pre> and is represented in the user
    ///  interface for example in the status bar. Further you can get the edit
    ///  mode as enum by using viewEditMode(). Whenever the edit mode changed the
    ///  signals viewModeChanged() and viewEditModeChanged() are emitted.
    ///  \section view_extensions View Extension Interfaces
    ///  A simple view represents the text of a Document and provides a text cursor,
    ///  text selection, edit modes etc.
    ///  Advanced concepts like code completion and text hints are defined in the
    ///  extension interfaces. An KTextEditor implementation does not need to
    ///  support all the extensions. To implement the interfaces multiple
    ///  inheritance is used.
    ///  More information about interfaces for the view can be found in
    ///  \ref kte_group_view_extensions.
    ///  \see KTextEditor.Document, KTextEditor.TemplateInterface,
    ///       KTextEditor.CodeCompletionInterface,
    ///       KTextEditor.SessionConfigInterface, KTextEditor.TemplateInterface,
    ///       KXMLGUIClient
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///   See <see cref="IViewSignals"></see> for signals emitted by View
    /// </remarks>        <short>    \brief A text widget with KXMLGUIClient that represents a Document.</short>
    [SmokeClass("KTextEditor::View")]
    public class View : QWidget, IKXMLGUIClient, IDisposable {
        protected View(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(View), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static View() {
            staticInterceptor = new SmokeInvocation(typeof(View), null);
        }
        /// <remarks>
        ///  Possible edit modes.
        ///  These correspond to various modes the text editor might be in.
        ///      </remarks>        <short>    Possible edit modes.</short>
        public enum EditMode {
            EditInsert = 0,
            EditOverwrite = 1,
        }
        // enum EditMode viewEditMode(); >>>> NOT CONVERTED
        // KXMLGUIClient::StateChange getActionsToChangeForState(const QString& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Constructor.
        ///  Create a view attached to the widget <pre>parent</pre>.
        ///  \param parent parent widget
        ///  \see Document.CreateView()
        ///      </remarks>        <short>    Constructor.</short>
        public View(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("View#", "View(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Get the view's \e document, that means the view is a view of the
        ///  returned document.
        ///  \return the view's document
        ///      </remarks>        <short>    Get the view's \e document, that means the view is a view of the  returned document.</short>
        [SmokeMethod("document() const")]
        public virtual KTextEditor.Document Document() {
            return (KTextEditor.Document) interceptor.Invoke("document", "document() const", typeof(KTextEditor.Document));
        }
        /// <remarks>
        ///  Check whether this view is the document's active view.
        ///  This is equal to the code:
        ///  <pre>
        ///  document().ActiveView() == view
        ///  </pre>
        ///      </remarks>        <short>    Check whether this view is the document's active view.</short>
        public bool IsActiveView() {
            return (bool) interceptor.Invoke("isActiveView", "isActiveView() const", typeof(bool));
        }
        /// <remarks>
        ///  Get the current view mode/state.
        ///  This can be used to visually indicate the view's current mode, for
        ///  example \e INSERT mode, \e OVERWRITE mode or \e COMMAND mode - or
        ///  whatever other edit modes are supported. The string should be
        ///  translated (i18n), as this is a user aimed representation of the view
        ///  state, which should be shown in the GUI, for example in the status bar.
        ///  \return
        ///  \see viewModeChanged()
        ///      </remarks>        <short>    Get the current view mode/state.</short>
        [SmokeMethod("viewMode() const")]
        public virtual string ViewMode() {
            return (string) interceptor.Invoke("viewMode", "viewMode() const", typeof(string));
        }
        /// <remarks>
        ///  Get the view's current edit mode.
        ///  The current mode can be \e insert mode, \e replace mode or any other
        ///  the editor supports, e.g. a vim like \e command mode. If in doubt
        ///  return EditInsert.
        ///  \return the current edit mode of this view
        ///  \see viewEditModeChanged()
        ///      </remarks>        <short>    Get the view's current edit mode.</short>
        /// <remarks>
        ///  Set a context menu for this view to <pre>menu</pre>.
        ///  <b>Note:<> any previously assigned menu is not deleted.  If you are finished
        ///        with the previous menu, you may delete it.
        ///  \param menu new context menu object for this view
        ///  \see contextMenu()
        ///      </remarks>        <short>    Set a context menu for this view to \p menu.</short>
        [SmokeMethod("setContextMenu(QMenu*)")]
        public virtual void SetContextMenu(QMenu menu) {
            interceptor.Invoke("setContextMenu#", "setContextMenu(QMenu*)", typeof(void), typeof(QMenu), menu);
        }
        /// <remarks>
        ///  Get the context menu for this view. The return value can be NULL
        ///  if no context menu object was set.
        ///  \return context menu object
        ///  \see setContextMenu()
        ///      </remarks>        <short>    Get the context menu for this view.</short>
        [SmokeMethod("contextMenu() const")]
        public virtual QMenu ContextMenu() {
            return (QMenu) interceptor.Invoke("contextMenu", "contextMenu() const", typeof(QMenu));
        }
        /// <remarks>
        ///  Populate \a menu with default text editor actions.  If \a menu is
        ///  null, a menu will be created with the view as its parent.
        ///  <b>Note:<> to use this menu, you will next need to call setContextMenu(),
        ///        as this does not assign the new context menu.
        ///  \param menu the menu to be populated, or null to create a new menu
        ///  \return the menu, whether created or passed initially
        ///      </remarks>        <short>    Populate \a menu with default text editor actions.</short>
        [SmokeMethod("defaultContextMenu(QMenu*) const")]
        public virtual QMenu DefaultContextMenu(QMenu menu) {
            return (QMenu) interceptor.Invoke("defaultContextMenu#", "defaultContextMenu(QMenu*) const", typeof(QMenu), typeof(QMenu), menu);
        }
        [SmokeMethod("defaultContextMenu() const")]
        public virtual QMenu DefaultContextMenu() {
            return (QMenu) interceptor.Invoke("defaultContextMenu", "defaultContextMenu() const", typeof(QMenu));
        }
        /// <remarks>
        ///  Set the view's new cursor to <pre>position</pre>. A \e TAB character
        ///  is handeled as only on character.
        ///  \param position new cursor position
        ///  \return \e true on success, otherwise \e false
        ///  \see cursorPosition()
        ///      </remarks>        <short>    Set the view's new cursor to \p position.</short>
        [SmokeMethod("setCursorPosition(KTextEditor::Cursor)")]
        public virtual bool SetCursorPosition(KTextEditor.Cursor position) {
            return (bool) interceptor.Invoke("setCursorPosition#", "setCursorPosition(KTextEditor::Cursor)", typeof(bool), typeof(KTextEditor.Cursor), position);
        }
        /// <remarks>
        ///  Get the view's current cursor position. A \e TAB character is
        ///  handeled as only one character.
        ///  \return current cursor position
        ///  \see setCursorPosition()
        ///      </remarks>        <short>    Get the view's current cursor position.</short>
        [SmokeMethod("cursorPosition() const")]
        public virtual KTextEditor.Cursor CursorPosition() {
            return (KTextEditor.Cursor) interceptor.Invoke("cursorPosition", "cursorPosition() const", typeof(KTextEditor.Cursor));
        }
        /// <remarks>
        ///  Get the current \e cursor position, \e means the
        ///  tabulator character (TAB) counts \e multiple characters, as configured
        ///  by the user (e.g. one TAB is 8 spaces). The cursor
        ///  position provides access to the user visible values of the current
        ///  cursor position.
        ///  \return cursor position
        ///  \see cursorPosition()
        ///      </remarks>        <short>    Get the current \e virtual cursor position, \e virtual means the  tabulator character (TAB) counts \e multiple characters, as configured  by the user (e.</short>
        [SmokeMethod("cursorPositionVirtual() const")]
        public virtual KTextEditor.Cursor CursorPositionVirtual() {
            return (KTextEditor.Cursor) interceptor.Invoke("cursorPositionVirtual", "cursorPositionVirtual() const", typeof(KTextEditor.Cursor));
        }
        /// <remarks>
        ///  Get the screen coordinates (x, y) of the supplied \a cursor relative
        ///  to the view widget in pixels. Thus, 0,0 represents the top left hand of
        ///  the view widget.
        ///  \param cursor cursor to determine coordinate for.
        ///  \return cursor screen coordinates relative to the view widget
        ///      </remarks>        <short>    Get the screen coordinates (x, y) of the supplied \a cursor relative  to the view widget in pixels.</short>
        [SmokeMethod("cursorToCoordinate(const KTextEditor::Cursor&) const")]
        public virtual QPoint CursorToCoordinate(KTextEditor.Cursor cursor) {
            return (QPoint) interceptor.Invoke("cursorToCoordinate#", "cursorToCoordinate(const KTextEditor::Cursor&) const", typeof(QPoint), typeof(KTextEditor.Cursor), cursor);
        }
        /// <remarks>
        ///  Get the screen coordinates (x/y) of the cursor position in pixels.
        ///  \return cursor screen coordinates
        ///      </remarks>        <short>    Get the screen coordinates (x/y) of the cursor position in pixels.</short>
        [SmokeMethod("cursorPositionCoordinates() const")]
        public virtual QPoint CursorPositionCoordinates() {
            return (QPoint) interceptor.Invoke("cursorPositionCoordinates", "cursorPositionCoordinates() const", typeof(QPoint));
        }
        /// <remarks>
        ///  Check, whether mouse tracking is enabled.
        ///  Mouse tracking is required to have the signal mousePositionChanged()
        ///  emitted.
        ///  \return \e true, if mouse tracking is enabled, otherwise \e false
        ///  \see setMouseTrackingEnabled(), mousePositionChanged()
        ///      </remarks>        <short>    Check, whether mouse tracking is enabled.</short>
        [SmokeMethod("mouseTrackingEnabled() const")]
        public virtual bool MouseTrackingEnabled() {
            return (bool) interceptor.Invoke("mouseTrackingEnabled", "mouseTrackingEnabled() const", typeof(bool));
        }
        /// <remarks>
        ///  Try to enable or disable mouse tracking according to <pre>enable</pre>.
        ///  The return value contains the state of mouse tracking \e after the
        ///  request. Mouse tracking is required to have the mousePositionChanged()
        ///  signal emitted.
        ///  <b>Note:<> Implementation Notes: An implementation is not forced to support
        ///        this, and should always return \e false if it does not have
        ///        support.
        ///  \param enable if \e true, try to enable mouse tracking, otherwise disable
        ///         it.
        ///  \return the current state of mouse tracking
        ///  \see mouseTrackingEnabled(), mousePositionChanged()
        ///      </remarks>        <short>    Try to enable or disable mouse tracking according to \p enable.</short>
        [SmokeMethod("setMouseTrackingEnabled(bool)")]
        public virtual bool SetMouseTrackingEnabled(bool enable) {
            return (bool) interceptor.Invoke("setMouseTrackingEnabled$", "setMouseTrackingEnabled(bool)", typeof(bool), typeof(bool), enable);
        }
        /// <remarks>
        ///  Set the view's selection to the range <pre>selection</pre>.
        ///  The old selection will be discarded.
        ///  \param range the range of the new selection
        ///  \return \e true on success, otherwise \e false (e.g. when the cursor
        ///          range is invalid)
        ///  \see selectionRange(), selection()
        ///      </remarks>        <short>    Set the view's selection to the range \p selection.</short>
        [SmokeMethod("setSelection(const KTextEditor::Range&)")]
        public virtual bool SetSelection(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("setSelection#", "setSelection(const KTextEditor::Range&)", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  This is an overloaded member function, provided for convenience, it
        ///  differs from the above function only in what argument(s) it accepts.
        ///  An existing old selection will be discarded. If possible you should
        ///  reimplement the default implementation with a more efficient one.
        ///  \param position start or end position of the selection, depending
        ///         on the <pre>length</pre> parameter
        ///  \param length if >0 <pre>position</pre> defines the start of the selection,
        ///         if <0 <pre>position</pre> specifies the end
        ///  \param wrap if \e false the selection does not wrap lines and reaches
        ///         only to start/end of the cursors line. Default: \e true
        ///  \see selectionRange(), selection()
        ///  \todo rodda - is this really needed? it can now be accomplished with
        ///        SmartCursor.Advance()
        ///      </remarks>        <short>    This is an overloaded member function, provided for convenience, it  differs from the above function only in what argument(s) it accepts.</short>
        [SmokeMethod("setSelection(const KTextEditor::Cursor&, int, bool)")]
        public virtual bool SetSelection(KTextEditor.Cursor position, int length, bool wrap) {
            return (bool) interceptor.Invoke("setSelection#$$", "setSelection(const KTextEditor::Cursor&, int, bool)", typeof(bool), typeof(KTextEditor.Cursor), position, typeof(int), length, typeof(bool), wrap);
        }
        [SmokeMethod("setSelection(const KTextEditor::Cursor&, int)")]
        public virtual bool SetSelection(KTextEditor.Cursor position, int length) {
            return (bool) interceptor.Invoke("setSelection#$", "setSelection(const KTextEditor::Cursor&, int)", typeof(bool), typeof(KTextEditor.Cursor), position, typeof(int), length);
        }
        /// <remarks>
        ///  Query the view whether it has selected text, i.e. whether a selection
        ///  exists.
        ///  \return \e true if a text selection exists, otherwise \e false
        ///  \see setSelection(), selectionRange()
        ///      </remarks>        <short>    Query the view whether it has selected text, i.</short>
        [SmokeMethod("selection() const")]
        public virtual bool Selection() {
            return (bool) interceptor.Invoke("selection", "selection() const", typeof(bool));
        }
        /// <remarks>
        ///  Get the range occupied by the current selection.
        ///  \return selection range, valid only if a selection currently exists.
        ///  \see setSelection()
        ///      </remarks>        <short>    Get the range occupied by the current selection.</short>
        [SmokeMethod("selectionRange() const")]
        public virtual KTextEditor.Range SelectionRange() {
            return (KTextEditor.Range) interceptor.Invoke("selectionRange", "selectionRange() const", typeof(KTextEditor.Range));
        }
        /// <remarks>
        ///  Get the view's selected text.
        ///  \return the selected text
        ///  \see setSelection()
        ///      </remarks>        <short>    Get the view's selected text.</short>
        [SmokeMethod("selectionText() const")]
        public virtual string SelectionText() {
            return (string) interceptor.Invoke("selectionText", "selectionText() const", typeof(string));
        }
        /// <remarks>
        ///  Remove the view's current selection, \e without deleting the selected
        ///  text.
        ///  \return \e true on success, otherwise \e false
        ///  \see removeSelectionText()
        ///      </remarks>        <short>    Remove the view's current selection, \e without deleting the selected  text.</short>
        [SmokeMethod("removeSelection()")]
        public virtual bool RemoveSelection() {
            return (bool) interceptor.Invoke("removeSelection", "removeSelection()", typeof(bool));
        }
        /// <remarks>
        ///  Remove the view's current selection \e including the selected text.
        ///  \return \e true on success, otherwise \e false
        ///  \see removeSelection()
        ///      </remarks>        <short>    Remove the view's current selection \e including the selected text.</short>
        [SmokeMethod("removeSelectionText()")]
        public virtual bool RemoveSelectionText() {
            return (bool) interceptor.Invoke("removeSelectionText", "removeSelectionText()", typeof(bool));
        }
        /// <remarks>
        ///  Set block selection mode to state <pre>on</pre>.
        ///  \param on if \e true, block selection mode is turned on, otherwise off
        ///  \return \e true on success, otherwise \e false
        ///  \see blockSelection()
        ///     </remarks>        <short>    Set block selection mode to state \p on.</short>
        [SmokeMethod("setBlockSelection(bool)")]
        public virtual bool SetBlockSelection(bool on) {
            return (bool) interceptor.Invoke("setBlockSelection$", "setBlockSelection(bool)", typeof(bool), typeof(bool), on);
        }
        /// <remarks>
        ///  Get the status of the selection mode. \e true indicates that block
        ///  selection mode is on. If this is \e true, selections applied via the
        ///  SelectionInterface are handled as block selections and the Copy&Paste
        ///  functions work on rectangular blocks of text rather than normal.
        ///  \return \e true, if block selection mode is enabled, otherwise \e false
        ///  \see setBlockSelection()
        ///     </remarks>        <short>    Get the status of the selection mode.</short>
        [SmokeMethod("blockSelection() const")]
        public virtual bool BlockSelection() {
            return (bool) interceptor.Invoke("blockSelection", "blockSelection() const", typeof(bool));
        }
        /// <remarks>
        ///  This is a convenience function which inserts <pre>text</pre> at the view's
        ///  current cursor position. You do not necessarily need to reimplement
        ///  it, except you want to do some special things.
        ///  \param text Text to be inserted
        ///  \return \e true on success of insertion, otherwise \e false
        ///  \see textInserted()
        ///      </remarks>        <short>    This is a convenience function which inserts \p text at the view's  current cursor position.</short>
        [SmokeMethod("insertText(const QString&)")]
        public virtual bool InsertText(string text) {
            return (bool) interceptor.Invoke("insertText$", "insertText(const QString&)", typeof(bool), typeof(string), text);
        }
        ~View() {
            interceptor.Invoke("~View", "~View()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~View", "~View()", typeof(void));
        }
        /// <remarks>
        ///  Retrieves an action of the client by name.  If not found, it looks in its child clients.
        ///  This method is provided for convenience, as it uses actionCollection()
        ///  to get the action object.
        ///    </remarks>        <short>    Retrieves an action of the client by name.</short>
        public QAction Action(string name) {
            return (QAction) interceptor.Invoke("action$", "action(const char*) const", typeof(QAction), typeof(string), name);
        }
        /// <remarks>
        ///  Retrieves an action for a given QDomElement. The default
        ///  implementation uses the "name" attribute to query the action
        ///  object via the other action() method.
        ///    </remarks>        <short>    Retrieves an action for a given QDomElement.</short>
        [SmokeMethod("action(const QDomElement&) const")]
        public virtual QAction Action(QDomElement element) {
            return (QAction) interceptor.Invoke("action#", "action(const QDomElement&) const", typeof(QAction), typeof(QDomElement), element);
        }
        /// <remarks>
        ///  Retrieves the entire action collection for the GUI client.
        ///    </remarks>        <short>    Retrieves the entire action collection for the GUI client.</short>
        [SmokeMethod("actionCollection() const")]
        public virtual KActionCollection ActionCollection() {
            return (KActionCollection) interceptor.Invoke("actionCollection", "actionCollection() const", typeof(KActionCollection));
        }
        /// <remarks>
        /// </remarks>        <return> The componentData ( KComponentData ) for this GUI client.
        ///    </return>
        ///         <short>   </short>
        [SmokeMethod("componentData() const")]
        public virtual KComponentData ComponentData() {
            return (KComponentData) interceptor.Invoke("componentData", "componentData() const", typeof(KComponentData));
        }
        /// <remarks>
        /// </remarks>        <return> The parsed XML in a QDomDocument, set by
        ///  setXMLFile() or setXML().
        ///  This document describes the layout of the GUI.
        ///    </return>
        ///         <short>   </short>
        [SmokeMethod("domDocument() const")]
        public virtual QDomDocument DomDocument() {
            return (QDomDocument) interceptor.Invoke("domDocument", "domDocument() const", typeof(QDomDocument));
        }
        /// <remarks>
        ///  This will return the name of the XML file as set by setXMLFile().
        ///  If setXML() is used directly, then this will return NULL.
        ///  The filename that this returns is obvious for components as each
        ///  component has exactly one XML file.  In non-components, however,
        ///  there are usually two: the global file and the local file.  This
        ///  function doesn't really care about that, though.  It will always
        ///  return the last XML file set.  This, in almost all cases, will
        ///  be the local XML file.
        /// </remarks>        <return> The name of the XML file or string()
        ///    </return>
        ///         <short>    This will return the name of the XML file as set by setXMLFile().</short>
        [SmokeMethod("xmlFile() const")]
        public virtual string XmlFile() {
            return (string) interceptor.Invoke("xmlFile", "xmlFile() const", typeof(string));
        }
        [SmokeMethod("localXMLFile() const")]
        public virtual string LocalXMLFile() {
            return (string) interceptor.Invoke("localXMLFile", "localXMLFile() const", typeof(string));
        }
        /// <remarks>
        ///    </remarks>        <short>   </short>
        public void SetXMLGUIBuildDocument(QDomDocument doc) {
            interceptor.Invoke("setXMLGUIBuildDocument#", "setXMLGUIBuildDocument(const QDomDocument&)", typeof(void), typeof(QDomDocument), doc);
        }
        /// <remarks>
        ///    </remarks>        <short>   </short>
        public QDomDocument XmlguiBuildDocument() {
            return (QDomDocument) interceptor.Invoke("xmlguiBuildDocument", "xmlguiBuildDocument() const", typeof(QDomDocument));
        }
        /// <remarks>
        ///  This method is called by the KXMLGUIFactory as soon as the client
        ///  is added to the KXMLGUIFactory's GUI.
        ///    </remarks>        <short>    This method is called by the KXMLGUIFactory as soon as the client  is added to the KXMLGUIFactory's GUI.</short>
        public void SetFactory(KXMLGUIFactory factory) {
            interceptor.Invoke("setFactory#", "setFactory(KXMLGUIFactory*)", typeof(void), typeof(KXMLGUIFactory), factory);
        }
        /// <remarks>
        ///  Retrieves a pointer to the KXMLGUIFactory this client is
        ///  associated with (will return 0 if the client's GUI has not been built
        ///  by a KXMLGUIFactory.
        ///    </remarks>        <short>    Retrieves a pointer to the KXMLGUIFactory this client is  associated with (will return 0 if the client's GUI has not been built  by a KXMLGUIFactory.</short>
        public KXMLGUIFactory Factory() {
            return (KXMLGUIFactory) interceptor.Invoke("factory", "factory() const", typeof(KXMLGUIFactory));
        }
        /// <remarks>
        ///  KXMLGUIClients can form a simple child/parent object tree. This
        ///  method returns a pointer to the parent client or 0 if it has no
        ///  parent client assigned.
        ///    </remarks>        <short>    KXMLGUIClients can form a simple child/parent object tree.</short>
        public IKXMLGUIClient ParentClient() {
            return (IKXMLGUIClient) interceptor.Invoke("parentClient", "parentClient() const", typeof(IKXMLGUIClient));
        }
        /// <remarks>
        ///  Use this method to make a client a child client of another client.
        ///  Usually you don't need to call this method, as it is called
        ///  automatically when using the second constructor, which takes a
        ///  parent argument.
        ///    </remarks>        <short>    Use this method to make a client a child client of another client.</short>
        public void InsertChildClient(IKXMLGUIClient child) {
            interceptor.Invoke("insertChildClient#", "insertChildClient(KXMLGUIClient*)", typeof(void), typeof(IKXMLGUIClient), child);
        }
        /// <remarks>
        ///  Removes the given <code>child</code> from the client's children list.
        ///    </remarks>        <short>    Removes the given <code>child</code> from the client's children list.</short>
        public void RemoveChildClient(IKXMLGUIClient child) {
            interceptor.Invoke("removeChildClient#", "removeChildClient(KXMLGUIClient*)", typeof(void), typeof(IKXMLGUIClient), child);
        }
        /// <remarks>
        ///  Retrieves a list of all child clients.
        ///    </remarks>        <short>    Retrieves a list of all child clients.</short>
        public List<KXMLGUIClient> ChildClients() {
            return (List<KXMLGUIClient>) interceptor.Invoke("childClients", "childClients()", typeof(List<KXMLGUIClient>));
        }
        /// <remarks>
        ///  A client can have an own KXMLGUIBuilder.
        ///  Use this method to assign your builder instance to the client (so that the
        ///  KXMLGUIFactory can use it when building the client's GUI)
        ///  Client specific guibuilders are useful if you want to create
        ///  custom container widgets for your GUI.
        ///    </remarks>        <short>    A client can have an own KXMLGUIBuilder.</short>
        public void SetClientBuilder(IKXMLGUIBuilder builder) {
            interceptor.Invoke("setClientBuilder#", "setClientBuilder(KXMLGUIBuilder*)", typeof(void), typeof(IKXMLGUIBuilder), builder);
        }
        /// <remarks>
        ///  Retrieves the client's GUI builder or 0 if no client specific
        ///  builder has been assigned via setClientBuilder()
        ///    </remarks>        <short>    Retrieves the client's GUI builder or 0 if no client specific  builder has been assigned via setClientBuilder()    </short>
        public IKXMLGUIBuilder ClientBuilder() {
            return (IKXMLGUIBuilder) interceptor.Invoke("clientBuilder", "clientBuilder() const", typeof(IKXMLGUIBuilder));
        }
        /// <remarks>
        ///  Forces this client to re-read its XML resource file.  This is
        ///  intended to be used when you know that the resource file has
        ///  changed and you will soon be rebuilding the GUI.  It has no
        ///  useful effect with non-KParts GUIs, so don't bother using it
        ///  unless your app is component based.
        ///    </remarks>        <short>    Forces this client to re-read its XML resource file.</short>
        public void ReloadXML() {
            interceptor.Invoke("reloadXML", "reloadXML()", typeof(void));
        }
        /// <remarks>
        ///  ActionLists are a way for XMLGUI to support dynamic lists of
        ///  actions.  E.g. if you are writing a file manager, and there is a
        ///  menu file whose contents depend on the mimetype of the file that
        ///  is selected, then you can achieve this using ActionLists. It
        ///  works as follows:
        ///  In your xxxui.rc file ( the one that you set in setXMLFile() / pass to setupGUI()
        ///  ), you put a tag <tt>\<ActionList name="xxx"\></tt>.
        ///  Example:
        ///  <pre>
        ///  <kpartgui name="xxx_part" version="1">
        ///  <MenuBar>
        ///    <Menu name="file">
        ///      ...  <!-- some useful actions-->
        ///      <ActionList name="xxx_file_actionlist" />
        ///      ...  <!-- even more useful actions-->
        ///    </Menu>
        ///    ...
        ///  </MenuBar>
        ///  </kpartgui>
        ///  </pre>
        ///  This tag will get expanded to a list of actions.  In the example
        ///  above ( a file manager with a dynamic file menu ), you would call
        ///  <pre>
        ///  QList<QAction> file_actions;
        ///  for( ... )
        ///    if( ... )
        ///      file_actions.append( cool_action );
        ///  unplugActionList( "xxx_file_actionlist" );
        ///  plugActionList( "xxx_file_actionlist", file_actions );
        ///  </pre>
        ///  every time a file is selected, unselected or ...
        ///  <b>Note:<> You should not call createGUI() after calling this
        ///        function.  In fact, that would remove the newly added
        ///        actionlists again...
        ///  <b>Note:<> Forgetting to call unplugActionList() before
        ///        plugActionList() would leave the previous actions in the
        ///        menu too..
        ///  \see unplugActionList()
        ///    </remarks>        <short>    ActionLists are a way for XMLGUI to support dynamic lists of  actions.</short>
        public void PlugActionList(string name, List<QAction> actionList) {
            interceptor.Invoke("plugActionList$?", "plugActionList(const QString&, const QList<QAction*>&)", typeof(void), typeof(string), name, typeof(List<QAction>), actionList);
        }
        /// <remarks>
        ///  Unplugs the action list <pre>name</pre> from the XMLGUI.
        ///  Calling this removes the specified action list, i.e. this is the
        ///  complement to plugActionList(). See plugActionList() for a more
        ///  detailed example.
        ///  \see plugActionList()
        ///    </remarks>        <short>    Unplugs the action list \p name from the XMLGUI.</short>
        public void UnplugActionList(string name) {
            interceptor.Invoke("unplugActionList$", "unplugActionList(const QString&)", typeof(void), typeof(string), name);
        }
        public void AddStateActionEnabled(string state, string action) {
            interceptor.Invoke("addStateActionEnabled$$", "addStateActionEnabled(const QString&, const QString&)", typeof(void), typeof(string), state, typeof(string), action);
        }
        public void AddStateActionDisabled(string state, string action) {
            interceptor.Invoke("addStateActionDisabled$$", "addStateActionDisabled(const QString&, const QString&)", typeof(void), typeof(string), state, typeof(string), action);
        }
        public void BeginXMLPlug(QWidget arg1) {
            interceptor.Invoke("beginXMLPlug#", "beginXMLPlug(QWidget*)", typeof(void), typeof(QWidget), arg1);
        }
        public void EndXMLPlug() {
            interceptor.Invoke("endXMLPlug", "endXMLPlug()", typeof(void));
        }
        public void PrepareXMLUnplug(QWidget arg1) {
            interceptor.Invoke("prepareXMLUnplug#", "prepareXMLUnplug(QWidget*)", typeof(void), typeof(QWidget), arg1);
        }
        /// <remarks>
        ///  Sets the componentData ( KComponentData) for this part.
        ///  Call this first in the inherited class constructor.
        ///  (At least before setXMLFile().)
        ///    </remarks>        <short>    Sets the componentData ( KComponentData) for this part.</short>
        [SmokeMethod("setComponentData(const KComponentData&)")]
        protected virtual void SetComponentData(KComponentData componentData) {
            interceptor.Invoke("setComponentData#", "setComponentData(const KComponentData&)", typeof(void), typeof(KComponentData), componentData);
        }
        /// <remarks>
        ///  Sets the name of the rc file containing the XML for the part.
        ///  Call this in the Part-inherited class constructor.
        ///  If you're writing usual application, use KXmlGuiWindow.SetupGUI() with non-default arguments
        /// <param> name="file" Either an absolute path for the file, or simply the
        ///              filename, which will then be assumed to be installed
        ///              in the "data" resource, under a directory named like
        ///              the componentData.
        /// </param><param> name="merge" Whether to merge with the global document.
        /// </param><param> name="setXMLDoc" Specify whether to call setXML. Default is true.
        ///                and the DOM document at once.
        /// </param></remarks>        <short>    Sets the name of the rc file containing the XML for the part.</short>
        [SmokeMethod("setXMLFile(const QString&, bool, bool)")]
        protected virtual void SetXMLFile(string file, bool merge, bool setXMLDoc) {
            interceptor.Invoke("setXMLFile$$$", "setXMLFile(const QString&, bool, bool)", typeof(void), typeof(string), file, typeof(bool), merge, typeof(bool), setXMLDoc);
        }
        [SmokeMethod("setXMLFile(const QString&, bool)")]
        protected virtual void SetXMLFile(string file, bool merge) {
            interceptor.Invoke("setXMLFile$$", "setXMLFile(const QString&, bool)", typeof(void), typeof(string), file, typeof(bool), merge);
        }
        [SmokeMethod("setXMLFile(const QString&)")]
        protected virtual void SetXMLFile(string file) {
            interceptor.Invoke("setXMLFile$", "setXMLFile(const QString&)", typeof(void), typeof(string), file);
        }
        [SmokeMethod("setLocalXMLFile(const QString&)")]
        protected virtual void SetLocalXMLFile(string file) {
            interceptor.Invoke("setLocalXMLFile$", "setLocalXMLFile(const QString&)", typeof(void), typeof(string), file);
        }
        /// <remarks>
        ///  Sets the XML for the part.
        ///  Call this in the Part-inherited class constructor if you
        ///   don't call setXMLFile().
        /// </remarks>        <short>    Sets the XML for the part.</short>
        [SmokeMethod("setXML(const QString&, bool)")]
        protected virtual void SetXML(string document, bool merge) {
            interceptor.Invoke("setXML$$", "setXML(const QString&, bool)", typeof(void), typeof(string), document, typeof(bool), merge);
        }
        [SmokeMethod("setXML(const QString&)")]
        protected virtual void SetXML(string document) {
            interceptor.Invoke("setXML$", "setXML(const QString&)", typeof(void), typeof(string), document);
        }
        /// <remarks>
        ///  Sets the Document for the part, describing the layout of the GUI.
        ///  Call this in the Part-inherited class constructor if you don't call
        ///  setXMLFile or setXML .
        ///    </remarks>        <short>    Sets the Document for the part, describing the layout of the GUI.</short>
        [SmokeMethod("setDOMDocument(const QDomDocument&, bool)")]
        protected virtual void SetDOMDocument(QDomDocument document, bool merge) {
            interceptor.Invoke("setDOMDocument#$", "setDOMDocument(const QDomDocument&, bool)", typeof(void), typeof(QDomDocument), document, typeof(bool), merge);
        }
        [SmokeMethod("setDOMDocument(const QDomDocument&)")]
        protected virtual void SetDOMDocument(QDomDocument document) {
            interceptor.Invoke("setDOMDocument#", "setDOMDocument(const QDomDocument&)", typeof(void), typeof(QDomDocument), document);
        }
        /// <remarks>
        ///  Actions can collectively be assigned a "State". To accomplish this
        ///  the respective actions are tagged as \<enable\> or \<disable\> in
        ///  a \<State\> \</State\> group of the XMLfile. During program execution the
        ///  programmer can call stateChanged() to set actions to a defined state.
        /// <param> name="newstate" Name of a State in the XMLfile.
        /// </param><param> name="reverse" If the flag reverse is set to StateReverse, the State is reversed.
        ///  (actions to be enabled will be disabled and action to be disabled will be enabled)
        ///  Default is reverse=false.
        ///    </param></remarks>        <short>    Actions can collectively be assigned a "State".</short>
        [SmokeMethod("stateChanged(const QString&, KXMLGUIClient::ReverseStateChange)")]
        protected virtual void StateChanged(string newstate, KXMLGUIClient.ReverseStateChange reverse) {
            interceptor.Invoke("stateChanged$$", "stateChanged(const QString&, KXMLGUIClient::ReverseStateChange)", typeof(void), typeof(string), newstate, typeof(KXMLGUIClient.ReverseStateChange), reverse);
        }
        [SmokeMethod("stateChanged(const QString&)")]
        protected virtual void StateChanged(string newstate) {
            interceptor.Invoke("stateChanged$", "stateChanged(const QString&)", typeof(void), typeof(string), newstate);
        }
        public static string FindMostRecentXMLFile(List<string> files, StringBuilder doc) {
            return (string) staticInterceptor.Invoke("findMostRecentXMLFile?$", "findMostRecentXMLFile(const QStringList&, QString&)", typeof(string), typeof(List<string>), files, typeof(StringBuilder), doc);
        }
        protected new IViewSignals Emit {
            get { return (IViewSignals) Q_EMIT; }
        }
    }

    public interface IViewSignals : IQWidgetSignals {
        /// <remarks>
        ///  This signal is emitted whenever the <pre>view</pre> gets the focus.
        ///  \param view view which gets focus
        ///  \see focusOut()
        ///      </remarks>        <short>    This signal is emitted whenever the \p view gets the focus.</short>
        [Q_SIGNAL("void focusIn(KTextEditor::View*)")]
        void FocusIn(KTextEditor.View view);
        /// <remarks>
        ///  This signal is emitted whenever the <pre>view</pre> looses the focus.
        ///  \param view view which looses focus
        ///  \see focusIn()
        ///      </remarks>        <short>    This signal is emitted whenever the \p view looses the focus.</short>
        [Q_SIGNAL("void focusOut(KTextEditor::View*)")]
        void FocusOut(KTextEditor.View view);
        /// <remarks>
        ///  This signal is emitted whenever the view mode of <pre>view</pre> changes.
        ///  \param view the view which changed its mode
        ///  \see viewMode()
        ///      </remarks>        <short>    This signal is emitted whenever the view mode of \p view changes.</short>
        [Q_SIGNAL("void viewModeChanged(KTextEditor::View*)")]
        void ViewModeChanged(KTextEditor.View view);
        // void viewEditModeChanged(KTextEditor::View* arg1,KTextEditor::View::EditMode arg2); >>>> NOT CONVERTED
        /// <remarks>
        ///  This signal is emitted whenever the <pre>view</pre> wants to display a
        ///  information <pre>message</pre>. The <pre>message</pre> can be displayed in the status bar
        ///  for example.
        ///  \param view view which sends out information
        ///  \param message information message
        ///      </remarks>        <short>    This signal is emitted whenever the \p view wants to display a  information \p message.</short>
        [Q_SIGNAL("void informationMessage(KTextEditor::View*, QString)")]
        void InformationMessage(KTextEditor.View view, string message);
        /// <remarks>
        ///  This signal is emitted from <pre>view</pre> whenever the users inserts <pre>text</pre>
        ///  at <pre>position</pre>, that means the user typed/pasted text.
        ///  \param view view in which the text was inserted
        ///  \param position position where the text was inserted
        ///  \param text the text the user has typed into the editor
        ///  \see insertText()
        ///      </remarks>        <short>    This signal is emitted from \p view whenever the users inserts \p text  at \p position, that means the user typed/pasted text.</short>
        [Q_SIGNAL("void textInserted(KTextEditor::View*, KTextEditor::Cursor, QString)")]
        void TextInserted(KTextEditor.View view, KTextEditor.Cursor position, string text);
        /// <remarks>
        ///  Signal which is emitted immediately prior to showing the current
        ///  context \a menu.
        ///      </remarks>        <short>    Signal which is emitted immediately prior to showing the current  context \a menu.</short>
        [Q_SIGNAL("void contextMenuAboutToShow(KTextEditor::View*, QMenu*)")]
        void ContextMenuAboutToShow(KTextEditor.View view, QMenu menu);
        /// <remarks>
        ///  This signal is emitted whenever the <pre>view</pre>'s cursor position changed.
        ///  \param view view which emitted the signal
        ///  \param newPosition new position of the cursor (Kate will pass the real
        ///         cursor potition, not the virtual)
        ///  \see cursorPosition(), cursorPositionVirtual()
        ///      </remarks>        <short>    This signal is emitted whenever the \p view's cursor position changed.</short>
        [Q_SIGNAL("void cursorPositionChanged(KTextEditor::View*, KTextEditor::Cursor)")]
        void CursorPositionChanged(KTextEditor.View view, KTextEditor.Cursor newPosition);
        /// <remarks>
        ///  This signal should be emitted whenever the <pre>view</pre> is scrolled vertically.
        ///  \param view view which emitted the signal
        ///      </remarks>        <short>    This signal should be emitted whenever the \p view is scrolled vertically.</short>
        [Q_SIGNAL("void verticalScrollPositionChanged(KTextEditor::View*, KTextEditor::Cursor)")]
        void VerticalScrollPositionChanged(KTextEditor.View view, KTextEditor.Cursor newPos);
        /// <remarks>
        ///  This signal should be emitted whenever the <pre>view</pre> is scrolled horizontally.
        ///  \param view view which emitted the signal
        ///      </remarks>        <short>    This signal should be emitted whenever the \p view is scrolled horizontally.</short>
        [Q_SIGNAL("void horizontalScrollPositionChanged(KTextEditor::View*)")]
        void HorizontalScrollPositionChanged(KTextEditor.View view);
        /// <remarks>
        ///  This signal is emitted whenever the position of the mouse changes over
        ///  this \a view. If the mouse moves off the view, an invalid cursor position
        ///  should be emitted, i.e. Cursor.Invalid().
        ///  <b>Note:<> If mouseTrackingEnabled() returns \e false, this signal is never
        ///        emitted.
        ///  \param view view which emitted the signal
        ///  \param newPosition new position of the mouse or Cursor.Invalid(), if the
        ///         mouse moved out of the <pre>view</pre>.
        ///  \see mouseTrackingEnabled()
        ///      </remarks>        <short>    This signal is emitted whenever the position of the mouse changes over  this \a view.</short>
        [Q_SIGNAL("void mousePositionChanged(KTextEditor::View*, KTextEditor::Cursor)")]
        void MousePositionChanged(KTextEditor.View view, KTextEditor.Cursor newPosition);
        /// <remarks>
        ///  This signal is emitted whenever the <pre>view</pre>'s selection changes.
        ///  <b>Note:<> If the mode switches from block selection to normal selection
        ///        or vice versa this signal should also be emitted.
        ///  \param view view in which the selection changed
        ///  \see selection(), selectionRange(), selectionText()
        ///      </remarks>        <short>    This signal is emitted whenever the \p view's selection changes.</short>
        [Q_SIGNAL("void selectionChanged(KTextEditor::View*)")]
        void SelectionChanged(KTextEditor.View view);
    }
}
