/*
    This file is part of the Okteta Core library, made within the KDE community.

    Copyright 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ABSTRACTBYTEARRAYIFTEST_H
#define ABSTRACTBYTEARRAYIFTEST_H

// lib
#include <addressrange.h>
// Qt
#include <QtCore/QObject>

class QSignalSpy;


namespace Okteta
{
class AbstractByteArrayModel;


class AbstractByteArrayModelIfTest : public QObject
{
  Q_OBJECT

  protected:
    AbstractByteArrayModelIfTest();

  protected: // our API
    virtual AbstractByteArrayModel* createByteArrayModel() = 0;
    virtual void deleteByteArrayModel( AbstractByteArrayModel* byteArrayModel ) = 0;

  protected:
    void checkContentsReplaced( Address Position, Size removedLength, int insertedLength );
    void checkContentsReplaced( const AddressRange& removeSection, int insertedLength );
    void checkContentsSwapped( Address firstStart, Address secondStart, Size secondLength );
    void checkContentsSwapped( Address firstStart, const AddressRange& secondSection );
    void clearSignalSpys();

    struct KTestData* prepareTestInsert();

  private Q_SLOTS: // test functions
    void init();
    void cleanup();

    void testModified();
    void testSetReadOnly();
    void testCopyTo();
    void testFill();
    void testSetGet();

    void testRemove();
    void testInsertAtBegin();
    void testInsertAtMid();
    void testInsertAtEnd();
    //void testReplace();
    void testSwap();
    void testReplaceEqual();
    void testReplaceLess();
    void testReplaceMore();

  private: // used in all tests
    /** pointer to the model to test */
    AbstractByteArrayModel* mByteArrayModel;

    QSignalSpy* ContentsChangeListSpy;
};

inline AbstractByteArrayModelIfTest::AbstractByteArrayModelIfTest()  : mByteArrayModel( 0 ) {}

}

#endif
