//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  While KFontChooser as an ordinary widget can be embedded in
    ///  custom dialogs and therefore is very flexible, in most cases
    ///  it is preferable to use the convenience functions in
    ///  KFontDialog.
    ///  See <see cref="IKFontChooserSignals"></see> for signals emitted by KFontChooser
    /// </remarks>        <author> Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>
    ///  </author>
    ///         <short> A font selection widget. </short>
    ///         <see> KFontRequester</see>
    [SmokeClass("KFontChooser")]
    public class KFontChooser : QWidget, IDisposable {
        protected KFontChooser(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KFontChooser), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KFontChooser() {
            staticInterceptor = new SmokeInvocation(typeof(KFontChooser), null);
        }
        /// <remarks>
        /// 
        /// <li>
        /// <code>FamilyList</code> - Identifies the family (leftmost) list.
        /// </li>
        /// 
        /// <li>
        /// <code>StyleList</code> -  Identifies the style (center) list.
        /// </li>
        /// 
        /// <li>
        /// <code>SizeList</code> -   Identifies the size (rightmost) list.
        ///      
        /// </li></remarks>        <short>   </short>
        public enum FontColumn {
            FamilyList = 0x01,
            StyleList = 0x02,
            SizeList = 0x04,
        }
        /// <remarks>
        /// 
        /// <li>
        /// <code>FontDiffFamily</code> - Identifies a requested change in the font family.
        /// </li>
        /// 
        /// <li>
        /// <code>FontDiffStyle</code> -  Identifies a requested change in the font style.
        /// </li>
        /// 
        /// <li>
        /// <code>FontDiffSize</code> -   Identifies a requested change in the font size.
        ///      
        /// </li></remarks>        <short>   </short>
        public enum FontDiff {
            NoFontDiffFlags = 0,
            FontDiffFamily = 1,
            FontDiffStyle = 2,
            FontDiffSize = 4,
            AllFontDiffs = FontDiffFamily|FontDiffStyle|FontDiffSize,
        }
        /// <remarks>
        /// 
        /// <li>
        /// <code>FixedFontsOnly</code> only show fixed fonts, excluding proportional fonts
        /// </li>
        /// 
        /// <li>
        /// <code>DisplayFrame</code> show a visual frame around the chooser
        /// </li>
        /// 
        /// <li>
        /// <code>ShowDifferences</code> display the font differences interfaces
        ///      
        /// </li></remarks>        <short>   </short>
        public enum DisplayFlag {
            NoDisplayFlags = 0,
            FixedFontsOnly = 1,
            DisplayFrame = 2,
            ShowDifferences = 4,
        }
        /// <remarks>
        ///  The selection criteria for the font families shown in the dialog.
        /// 
        /// <li>
        /// <code>FixedWidthFont</code> when included only fixed-width fonts are returned.
        ///         The fonts where the width of every character is equal.
        /// </li>
        /// 
        /// <li>
        /// <code>ScalableFont</code> when included only scalable fonts are returned;
        ///         certain configurations allow bitmap fonts to remain unscaled and
        ///         thus these fonts have limited number of sizes.
        /// </li>
        /// 
        /// <li>
        /// <code>SmoothScalableFont</code> when included only return smooth scalable fonts.
        ///         this will return only non-bitmap fonts which are scalable to any size requested.
        ///         Setting this option to true will mean the "scalable" flag is irrelavant.
        ///    
        /// </li></remarks>        <short>    The selection criteria for the font families shown in the dialog.</short>
        public enum FontListCriteria {
            FixedWidthFonts = 0x01,
            ScalableFonts = 0x02,
            SmoothScalableFonts = 0x04,
        }
        [Q_PROPERTY("QFont", "font")]
        public new QFont Font {
            get { return (QFont) interceptor.Invoke("font", "font()", typeof(QFont)); }
            set { interceptor.Invoke("setFont#", "setFont(QFont)", typeof(void), typeof(QFont), value); }
        }
        /// <remarks>
        ///  Constructs a font picker widget.
        ///  It normally comes up with all font families present on the system; the
        ///  getFont method below does allow some more fine-tuning of the selection of fonts
        ///  that will be displayed in the dialog.
        ///  <p>Consider the following code snippet;
        ///  <pre>
        ///     List<string> list;
        ///     KFontChooser.GetFontList(list, KFontChooser.SmoothScalableFonts);
        ///     KFontChooser chooseFont = new KFontChooser(0, false, list);
        ///  </pre>
        ///  <p>
        ///  The above creates a font chooser dialog with only SmoothScaleble fonts.
        /// <param> name="parent" The parent widget.
        /// </param><param> name="flags" Defines how the font chooser is displayed. @see DisplayFlags
        /// </param><param> name="fontList" A list of fonts to display, in XLFD format.  If
        ///         no list is formatted, the internal KDE font list is used.
        ///         If that has not been created, X is queried, and all fonts
        ///         available on the system are displayed.
        /// </param><param> name="visibleListSize" The minimum number of visible entries in the
        ///         fontlists.
        /// </param><param> name="sizeIsRelativeState" If not zero the widget will show a
        ///         checkbox where the user may choose whether the font size
        ///         is to be interpreted as relative size.
        ///         Initial state of this checkbox will be set according to
        ///         sizeIsRelativeState, user choice may be retrieved by
        ///         calling sizeIsRelative().
        ///    </param></remarks>        <short>    Constructs a font picker widget.</short>
        public KFontChooser(QWidget parent, uint flags, List<string> fontList, int visibleListSize, Qt.CheckState sizeIsRelativeState) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontChooser#$?$$", "KFontChooser(QWidget*, const KFontChooser::DisplayFlags&, const QStringList&, int, Qt::CheckState*)", typeof(void), typeof(QWidget), parent, typeof(uint), flags, typeof(List<string>), fontList, typeof(int), visibleListSize, typeof(Qt.CheckState), sizeIsRelativeState);
        }
        public KFontChooser(QWidget parent, uint flags, List<string> fontList, int visibleListSize) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontChooser#$?$", "KFontChooser(QWidget*, const KFontChooser::DisplayFlags&, const QStringList&, int)", typeof(void), typeof(QWidget), parent, typeof(uint), flags, typeof(List<string>), fontList, typeof(int), visibleListSize);
        }
        public KFontChooser(QWidget parent, uint flags, List<string> fontList) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontChooser#$?", "KFontChooser(QWidget*, const KFontChooser::DisplayFlags&, const QStringList&)", typeof(void), typeof(QWidget), parent, typeof(uint), flags, typeof(List<string>), fontList);
        }
        public KFontChooser(QWidget parent, uint flags) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontChooser#$", "KFontChooser(QWidget*, const KFontChooser::DisplayFlags&)", typeof(void), typeof(QWidget), parent, typeof(uint), flags);
        }
        public KFontChooser(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontChooser#", "KFontChooser(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KFontChooser() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KFontChooser", "KFontChooser()", typeof(void));
        }
        /// <remarks>
        ///  Enables or disable a font column in the chooser.
        ///  Use this
        ///  function if your application does not need or supports all font
        ///  properties.
        /// <param> name="column" Specify the columns. An or'ed combination of
        ///         <code>FamilyList</code>, <code>StyleList</code> and <code>SizeList</code> is possible.
        /// </param><param> name="state" If <code>false</code> the columns are disabled.
        ///    </param></remarks>        <short>    Enables or disable a font column in the chooser.</short>
        public void EnableColumn(int column, bool state) {
            interceptor.Invoke("enableColumn$$", "enableColumn(int, bool)", typeof(void), typeof(int), column, typeof(bool), state);
        }
        /// <remarks>
        ///  Sets the currently selected font in the chooser.
        /// <param> name="font" The font to select.
        /// </param><param> name="onlyFixed" Readjust the font list to display only fixed
        ///         width fonts if <code>true</code>, or vice-versa.
        ///    </param></remarks>        <short>    Sets the currently selected font in the chooser.</short>
        public void SetFont(QFont font, bool onlyFixed) {
            interceptor.Invoke("setFont#$", "setFont(const QFont&, bool)", typeof(void), typeof(QFont), font, typeof(bool), onlyFixed);
        }
        public void SetFont(QFont font) {
            interceptor.Invoke("setFont#", "setFont(const QFont&)", typeof(void), typeof(QFont), font);
        }
        /// <remarks>
        /// </remarks>        <return> The bitmask corresponding to the attributes the user
        ///          wishes to change.
        ///    </return>
        ///         <short>   </short>
        public uint FontDiffFlags() {
            return (uint) interceptor.Invoke("fontDiffFlags", "fontDiffFlags() const", typeof(uint));
        }
        /// <remarks>
        ///  Sets the color to use in the preview.
        ///    </remarks>        <short>    Sets the color to use in the preview.</short>
        public void SetColor(QColor col) {
            interceptor.Invoke("setColor#", "setColor(const QColor&)", typeof(void), typeof(QColor), col);
        }
        /// <remarks>
        /// </remarks>        <return> The color currently used in the preview (default: the text
        ///          color of the active color group)
        ///    </return>
        ///         <short>   </short>
        public QColor Color() {
            return (QColor) interceptor.Invoke("color", "color() const", typeof(QColor));
        }
        /// <remarks>
        ///  Sets the background color to use in the preview.
        ///    </remarks>        <short>    Sets the background color to use in the preview.</short>
        public void SetBackgroundColor(QColor col) {
            interceptor.Invoke("setBackgroundColor#", "setBackgroundColor(const QColor&)", typeof(void), typeof(QColor), col);
        }
        /// <remarks>
        /// </remarks>        <return> The background color currently used in the preview (default:
        ///          the base color of the active colorgroup)
        ///    </return>
        ///         <short>   </short>
        public QColor BackgroundColor() {
            return (QColor) interceptor.Invoke("backgroundColor", "backgroundColor() const", typeof(QColor));
        }
        /// <remarks>
        ///  Sets the state of the checkbox indicating whether the font size
        ///  is to be interpreted as relative size.
        ///  NOTE: If parameter sizeIsRelative was not set in the constructor
        ///        of the widget this setting will be ignored.
        ///    </remarks>        <short>    Sets the state of the checkbox indicating whether the font size  is to be interpreted as relative size.</short>
        public void SetSizeIsRelative(Qt.CheckState relative) {
            interceptor.Invoke("setSizeIsRelative$", "setSizeIsRelative(Qt::CheckState)", typeof(void), typeof(Qt.CheckState), relative);
        }
        /// <remarks>
        /// </remarks>        <return> Whether the font size is to be interpreted as relative size
        ///          (default: QButton:Off)
        ///    </return>
        ///         <short>   </short>
        public Qt.CheckState SizeIsRelative() {
            return (Qt.CheckState) interceptor.Invoke("sizeIsRelative", "sizeIsRelative() const", typeof(Qt.CheckState));
        }
        /// <remarks>
        /// </remarks>        <return> The current text in the sample text input area.
        ///    </return>
        ///         <short>   </short>
        public string SampleText() {
            return (string) interceptor.Invoke("sampleText", "sampleText() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the sample text.
        ///  Normally you should not change this
        ///  text, but it can be better to do this if the default text is
        ///  too large for the edit area when using the default font of your
        ///  application.
        /// <param> name="text" The new sample text. The current will be removed.
        ///    </param></remarks>        <short>    Sets the sample text.</short>
        public void SetSampleText(string text) {
            interceptor.Invoke("setSampleText$", "setSampleText(const QString&)", typeof(void), typeof(string), text);
        }
        /// <remarks>
        ///  Shows or hides the sample text box.
        /// <param> name="visible" Set it to true to show the box, to false to hide it.
        ///    </param></remarks>        <short>    Shows or hides the sample text box.</short>
        public void SetSampleBoxVisible(bool visible) {
            interceptor.Invoke("setSampleBoxVisible$", "setSampleBoxVisible(bool)", typeof(void), typeof(bool), visible);
        }
        /// <remarks>
        ///  Reimplemented for internal reasons.
        ///    </remarks>        <short>    Reimplemented for internal reasons.</short>
        [SmokeMethod("sizeHint() const")]
        public override QSize SizeHint() {
            return (QSize) interceptor.Invoke("sizeHint", "sizeHint() const", typeof(QSize));
        }
        ~KFontChooser() {
            interceptor.Invoke("~KFontChooser", "~KFontChooser()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KFontChooser", "~KFontChooser()", typeof(void));
        }
        /// <remarks>
        ///  Creates a list of font strings.
        /// <param> name="list" The list is returned here.
        /// </param><param> name="fontListCriteria" should contain all the restrictions for font selection as OR-ed values
        /// </param></remarks>        <short>    Creates a list of font strings.</short>
        ///         <see> KFontChooser.FontListCriteria</see>
        ///         <see> for</see>
        ///         <see> the</see>
        ///         <see> individual</see>
        ///         <see> values</see>
        public static void GetFontList(List<string> list, uint fontListCriteria) {
            staticInterceptor.Invoke("getFontList?$", "getFontList(QStringList&, uint)", typeof(void), typeof(List<string>), list, typeof(uint), fontListCriteria);
        }
        protected new IKFontChooserSignals Emit {
            get { return (IKFontChooserSignals) Q_EMIT; }
        }
    }

    public interface IKFontChooserSignals : IQWidgetSignals {
        /// <remarks>
        ///  Emitted whenever the selected font changes.
        ///    </remarks>        <short>    Emitted whenever the selected font changes.</short>
        [Q_SIGNAL("void fontSelected(QFont)")]
        void FontSelected(QFont font);
    }
}
