//Auto-generated by kalyptus. DO NOT EDIT.
namespace KIO {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///   The file-job is an asynchronious version of normal file handling.
    ///   It allows block-wise reading and writing, and allows seeking. Results are returned through signals.
    ///   Should always be created using KIO.Open(KUrl&)
    ///   See <see cref="IFileJobSignals"></see> for signals emitted by FileJob
    /// </remarks>        <short>     The file-job is an asynchronious version of normal file handling.</short>
    [SmokeClass("KIO::FileJob")]
    public class FileJob : KIO.SimpleJob, IDisposable {
        protected FileJob(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(FileJob), this);
        }
        // KIO::FileJob* FileJob(KIO::FileJobPrivate& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Read block
        ///  The slave emits the data through data().
        /// <param> name="size" the requested amount of data
        ///      </param></remarks>        <short>    Read block </short>
        public void Read(long size) {
            interceptor.Invoke("read$", "read(KIO::filesize_t)", typeof(void), typeof(long), size);
        }
        /// <remarks>
        ///  Write block
        /// <param> name="data" the data to write
        ///      </param></remarks>        <short>    Write block </short>
        public void Write(QByteArray data) {
            interceptor.Invoke("write#", "write(const QByteArray&)", typeof(void), typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Close
        ///  Closes the file-slave
        ///      </remarks>        <short>    Close </short>
        public void Close() {
            interceptor.Invoke("close", "close()", typeof(void));
        }
        /// <remarks>
        ///  Seek
        ///  The slave emits position()
        /// <param> name="offset" the position from start to go to
        ///      </param></remarks>        <short>    Seek </short>
        public void Seek(long offset) {
            interceptor.Invoke("seek$", "seek(KIO::filesize_t)", typeof(void), typeof(long), offset);
        }
        /// <remarks>
        ///  Size
        /// </remarks>        <return> the file size
        ///      </return>
        ///         <short>    Size </short>
        public long Size() {
            return (long) interceptor.Invoke("size", "size()", typeof(long));
        }
        ~FileJob() {
            interceptor.Invoke("~FileJob", "~FileJob()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~FileJob", "~FileJob()", typeof(void));
        }
        protected new IFileJobSignals Emit {
            get { return (IFileJobSignals) Q_EMIT; }
        }
    }

    public interface IFileJobSignals : KIO.ISimpleJobSignals {
        /// <remarks>
        ///  Data from the slave has arrived.
        /// <param> name="job" the job that emitted this signal
        /// </param><param> name="data" data received from the slave.
        ///      </param></remarks>        <short>    Data from the slave has arrived.</short>
        [Q_SIGNAL("void data(KIO::Job*, QByteArray)")]
        void Data(KIO.Job job, QByteArray data);
        /// <remarks>
        ///  Signals the file is a redirection.
        ///  Follow this url manually to reach data
        /// <param> name="job" the job that emitted this signal
        /// </param><param> name="url" the new URL
        ///      </param></remarks>        <short>    Signals the file is a redirection.</short>
        [Q_SIGNAL("void redirection(KIO::Job*, KUrl)")]
        void Redirection(KIO.Job job, KUrl url);
        /// <remarks>
        ///  Mimetype determined.
        /// <param> name="job" the job that emitted this signal
        /// </param><param> name="type" the mime type
        ///      </param></remarks>        <short>    Mimetype determined.</short>
        [Q_SIGNAL("void mimetype(KIO::Job*, QString)")]
        void Mimetype(KIO.Job job, string type);
        /// <remarks>
        ///  File is open, metadata has been determined and the
        ///  file-slave is ready to receive commands.
        /// <param> name="job" the job that emitted this signal
        ///      </param></remarks>        <short>    File is open, metadata has been determined and the  file-slave is ready to receive commands.</short>
        [Q_SIGNAL("void open(KIO::Job*)")]
        void Open(KIO.Job job);
        /// <remarks>
        ///  Bytes written to the file.
        /// <param> name="job" the job that emitted this signal
        /// </param><param> name="written" bytes written.
        ///      </param></remarks>        <short>    Bytes written to the file.</short>
        [Q_SIGNAL("void written(KIO::Job*, KIO::filesize_t)")]
        void Written(KIO.Job job, long written);
        /// <remarks>
        ///  File is closed and will accept no more commands
        /// <param> name="job" the job that emitted this signal
        ///      </param></remarks>        <short>    File is closed and will accept no more commands </short>
        [Q_SIGNAL("void close(KIO::Job*)")]
        void Close(KIO.Job job);
        /// <remarks>
        ///  The file has reached this position. Emitted after seek.
        /// <param> name="job" the job that emitted this signal
        /// </param><param> name="offset" the new position
        ///      </param></remarks>        <short>    The file has reached this position.</short>
        [Q_SIGNAL("void position(KIO::Job*, KIO::filesize_t)")]
        void Position(KIO.Job job, long offset);
    }
}
