/*
  This file is part of the KDE project.

  Copyright (c) 2011 Lionel Chauvin <megabigbug@yahoo.fr>
  Copyright (c) 2011,2012 Cédric Bellegarde <gnumdk@gmail.com>

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files (the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.
*/

#ifndef MENUBUTTON__H
#define MENUBUTTON__H

#include <Plasma/ToolButton>
#include <QToolButton>

class MenuButton : public Plasma::ToolButton
{
Q_OBJECT
public:
    MenuButton(QGraphicsWidget *parent):
    Plasma::ToolButton(parent),
    m_enterEvent(false),
    m_menu(0)
    {}

    void setMenu(QMenu *menu) { m_menu = menu; }
    QMenu *menu() { return m_menu; }
    void setHovered(bool hovered);

    QSizeF sizeHint(Qt::SizeHint which, const QSizeF& constraint) const
    {
        QSizeF sh = Plasma::ToolButton::sizeHint(which, constraint);
        if (which == Qt::MinimumSize || which == Qt::PreferredSize) {
            sh.setHeight(nativeWidget()->fontMetrics().height());
        }
        return sh;
    }

protected:
    void hoverEnterEvent(QGraphicsSceneHoverEvent *);
    void hoverLeaveEvent(QGraphicsSceneHoverEvent *);
private:
    bool m_enterEvent;
    QMenu *m_menu;
};
#endif
