/*
  Copyright (c) 2015-2018 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "resourcereadconfigfile.h"

#include <KConfig>

using namespace MailCommon;

class MailCommon::ResourceReadConfigFilePrivate
{
public:
    ResourceReadConfigFilePrivate()
        : mConfig(nullptr)
    {
    }

    ~ResourceReadConfigFilePrivate()
    {
        delete mConfig;
    }

    KConfig *mConfig = nullptr;
};

ResourceReadConfigFile::ResourceReadConfigFile(const QString &resourceName)
    : d(new MailCommon::ResourceReadConfigFilePrivate)
{
    d->mConfig = new KConfig(resourceName + QStringLiteral("rc"));
}

ResourceReadConfigFile::~ResourceReadConfigFile()
{
    delete d;
}

KConfigGroup ResourceReadConfigFile::group(const QString &name) const
{
    if (d->mConfig) {
        return d->mConfig->group(name);
    }
    return KConfigGroup();
}
