/*
 *  Copyright 2013-2015  Andreas Cord-Landwehr <cordlandwehr@kde.org>
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License or (at your option) version 3 or any later version
 *  accepted by the membership of KDE e.V. (or its successor approved
 *  by the membership of KDE e.V.), which shall act as a proxy
 *  defined in Section 14 of version 3 of the license.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "application.h"

#include "core/iresourcerepository.h"
#include "core/ieditablerepository.h"
#include "core/ilanguage.h"
#include "core/language.h"
#include "core/contributorrepository.h"
#include "core/drawertrainingactions.h"
#include "core/trainingaction.h"
#include "core/editorsession.h"
#include "core/phoneme.h"
#include "core/phonemegroup.h"
#include "core/phrase.h"
#include "core/player.h"
#include "core/recorder.h"
#include "core/trainingsession.h"
#include "core/unit.h"
#include "core/resources/editablecourseresource.h"
#include "core/resources/skeletonresource.h"
#include "models/coursefiltermodel.h"
#include "models/coursemodel.h"
#include "models/languagemodel.h"
#include "models/languageresourcemodel.h"
#include "models/learningprogressmodel.h"
#include "models/phonemegroupmodel.h"
#include "models/phonememodel.h"
#include "models/phonemeunitmodel.h"
#include "models/phrasefiltermodel.h"
#include "models/phraselistmodel.h"
#include "models/phrasemodel.h"
#include "models/profilemodel.h"
#include "models/skeletonmodel.h"
#include "models/unitfiltermodel.h"
#include "models/unitmodel.h"
#include "qmlcontrols/iconitem.h"

#include "liblearnerprofile/src/learner.h"
#include "liblearnerprofile/src/profilemanager.h"
#include "liblearnerprofile/src/learninggoal.h"
#include "liblearnerprofile/src/models/learninggoalmodel.h"

#include <QObject>
#include <QQmlComponent>
#include <QQmlContext>
#include <QQmlEngine>

Application::Application(int& argc, char** argv)
    : QApplication(argc, argv)
{
    registerQmlTypes();
}

IResourceRepository * Application::resourceRepository() const
{
    return m_resourceRepository;
}

IEditableRepository * Application::editableRepository() const
{
    return qobject_cast<IEditableRepository*>(m_resourceRepository);
}

void Application::installResourceRepository(IResourceRepository *resourceRepository)
{
    m_resourceRepository = resourceRepository;
}

void Application::registerQmlTypes()
{
    qmlRegisterUncreatableType<TrainingSession>(
        "artikulate", 1, 0,
        "TrainingSession",
        QStringLiteral("TrainingSession is unique object provided by the backend"));
    qmlRegisterUncreatableType<EditorSession>(
        "artikulate", 1, 0,
        "EditorSession",
        QStringLiteral("EditorSession is unique object provided by the backend"));
    qmlRegisterUncreatableType<ContributorRepository>(
        "artikulate", 1, 0,
        "ContributorRepository",
        QStringLiteral("ContributorRepository is unique object provided by the backend"));
    qmlRegisterUncreatableType<LearnerProfile::ProfileManager>(
        "artikulate", 1, 0,
        "ProfileManager",
        QStringLiteral("ProfileManager is unique object provided by the backend"));
    qmlRegisterUncreatableType<EditableCourseResource>(
        "artikulate", 1, 0,
        "EditableCourseResource",
        QStringLiteral("EditableCourseResource objects are backend objects"));
    qmlRegisterUncreatableType<SkeletonResource>(
        "artikulate", 1, 0,
        "SkeletonResource",
        QStringLiteral("SkeletonResource objects are backend objects"));

    // interfaces
    qmlRegisterInterface<IResourceRepository>("IResourceRepository");
    qmlRegisterInterface<IResourceRepository>("IEditableRepository");
    qmlRegisterInterface<ICourse>("ICourse");
    qmlRegisterInterface<IEditableCourse>("IEditableCourse");
    qmlRegisterInterface<ICourse>("ILanguage");

    // concrete instantiable types
    qmlRegisterType<LearnerProfile::Learner>("artikulate", 1, 0, "Learner");
    qmlRegisterType<LearnerProfile::LearningGoal>("artikulate", 1, 0, "LearningGoal");
    qmlRegisterType<Unit>("artikulate", 1, 0, "Unit");
    qmlRegisterType<Language>("artikulate", 1, 0, "Language");
    qmlRegisterType<Phrase>("artikulate", 1, 0, "Phrase");
    qmlRegisterType<Phoneme>("artikulate", 1, 0, "Phoneme");
    qmlRegisterType<PhonemeGroup>("artikulate", 1, 0, "PhonemeGroup");
    qmlRegisterType<Player>("artikulate", 1, 0, "Player");
    qmlRegisterType<Recorder>("artikulate", 1, 0, "Recorder");
    qmlRegisterType<IconItem>("artikulate", 1, 0, "Icon");
    qmlRegisterType<DrawerTrainingActions>("artikulate", 1, 0, "DrawerTrainingActions");
    qmlRegisterType<TrainingAction>("artikulate", 1, 0, "TrainingAction");

    // models
    qmlRegisterType<CourseModel>("artikulate", 1, 0, "CourseModel");
    qmlRegisterType<CourseFilterModel>("artikulate", 1, 0, "CourseFilterModel");
    qmlRegisterType<LanguageModel>("artikulate", 1, 0, "LanguageModel");
    qmlRegisterType<LanguageResourceModel>("artikulate", 1, 0, "LanguageResourceModel");
//     qmlRegisterType<LearningProgressModel>("artikulate", 1, 0, "LearningProgressModel");//TODO must be ported to new trainingsession
    qmlRegisterType<UnitModel>("artikulate", 1, 0, "UnitModel");
    qmlRegisterType<UnitFilterModel>("artikulate", 1, 0, "UnitFilterModel");
    qmlRegisterType<PhraseModel>("artikulate", 1, 0, "PhraseModel");
    qmlRegisterType<PhraseListModel>("artikulate", 1, 0, "PhraseListModel");
    qmlRegisterType<PhraseFilterModel>("artikulate", 1, 0, "PhraseFilterModel");
    qmlRegisterType<PhonemeModel>("artikulate", 1, 0, "PhonemeModel");
    qmlRegisterType<PhonemeGroupModel>("artikulate", 1, 0, "PhonemeGroupModel");
    qmlRegisterType<PhonemeUnitModel>("artikulate", 1, 0, "PhonemeUnitModel");
    qmlRegisterType<ProfileModel>("artikulate", 1, 0, "ProfileModel");
    qmlRegisterType<SkeletonModel>("artikulate", 1, 0, "SkeletonModel");
    qmlRegisterType<LearnerProfile::LearningGoalModel>("artikulate", 1, 0, "LearningGoalModel");
}
