/* The main-function for the addressbook application 
 *
 * the Configuration Database library
 * copyright:  (C) Mirko Sucker, 1998
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@hamburg.netsurf.de>
 *                          <mirko.sucker@unibw-hamburg.de>
 * requires:   C++-compiler, STL, string class, Qt > 1.33,
 *             NANA (for debugging)
 * $Revision: 1.6 $
 */

#include <qimage.h>
#include "toplevelwidget.h"
#include <kapp.h>
#include "jpeg.h"
#include "debug.h"

int main(int argc, char** argv)
{
  ID(bool GUARD=true);
  LG(GUARD, "addressbook main: starting.\n");
  // ########################################################  
  KApplication app(argc, argv, "kab");
#ifdef HAVE_LIBJPEG
  QImageIO::defineIOHandler("JFIF","^\377\330\377\340", 
			    0, read_jpeg_jfif, NULL);
  LG(GUARD, "addressbook main: registered JPEG reader.\n");
#else
  L("addressbook main: the JPEG reader has not been "
    "included in this executable.\n");   
  CHECK(false);
#endif
  ABTLWidget db;
  app.setMainWidget(&db);
  db.show();
  LG(GUARD, "addressbook main: executing X application.\n");
  return app.exec();
  // ########################################################
}


