/***************************************************************************
                          filter.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <stdlib.h>
#include "filter.h"
#include <kapp.h>
#include <qpushbt.h>
#include <qlined.h>
#include <kmsgbox.h>

#define warnMissing(x) { \
KMsgBox::message(this,x,"a widget is missing",KMsgBox::STOP,"Abort"); \
kapp->quit();\
}


filter::filter(QWidget *parent, const char *name, bool modal)
	: filterdlg(parent,name,modal)
{
	if (name)
		setCaption(name);
	ismodal=modal;
	bt=(QPushButton *)ktl->findWidget("ok");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(closeDialog()));
	else	warnMissing("ok");
	bt=(QPushButton *)ktl->findWidget("help");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(launchHelp()));
	else	warnMissing("help");
	le1=(QLineEdit *)ktl->findWidget("le1");
	if (!le1) warnMissing("le1");
	le1->clear();
	le1->setFocus();
	connect(le1,SIGNAL(returnPressed()),this,SLOT(closeDialog()));
	rb2=(QRadioButton *)ktl->findWidget("rb2");
	if (!rb2) warnMissing("rb2");
}

void filter::closeDialog()
{
	if (ismodal)
		done(0);
	else	emit dialogClosed(this,true);
}

void filter::launchHelp()
{
	kapp->invokeHTMLHelp("","filter");
}

void filter::closeEvent(QCloseEvent *)
{
	if (ismodal) done(0);
}

void filter::setText(const char *t)
{
	le1->setText(t);
}

void filter::setExclude(bool f)
{
	rb2->setChecked(f);
}

const char *filter::text()
{
	return(le1->text());
}

bool filter::isExcludeSelected()
{
	return(rb2->isChecked());
}

#include "filter.moc"
