/***************************************************************************
                          option.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <stdlib.h>
#include "option.h"
#include <kapp.h>
#include <qpushbt.h>
#include <qlined.h>
#include <kmsgbox.h>

#define warnMissing(x) { \
KMsgBox::message(this,x,"a widget is missing",KMsgBox::STOP,"Abort"); \
kapp->quit();\
}


option::option(QWidget *parent, const char *name, bool modal)
	: optiondlg(parent,name,modal)
{
	if (name)
		setCaption(name);
	ismodal=modal;
	bt=(QPushButton *)ktl->findWidget("ok");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(closeDialog()));
	else	warnMissing("ok");
	bt=(QPushButton *)ktl->findWidget("help");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(launchHelp()));
	else	warnMissing("help");
	com1=(QComboBox *)ktl->findWidget("com1");
	if (!com1) warnMissing("com1");
	com1->clear();
	com1->insertItem(i18n("nothing"));
	com1->insertItem(i18n("raise"));
	com1->insertItem(i18n("deiconify"));
	com1->insertItem(i18n("deiconify and raise"));
	com1->insertItem(i18n("beep"));

	le1=(QLineEdit *)ktl->findWidget("maxlines");
	if (!le1) warnMissing("maxlines");
	le1->clear();
	le1->setFocus();
	connect(le1,SIGNAL(returnPressed()),this,SLOT(closeDialog()));
}

void option::closeDialog()
{
	if (ismodal)
		done(0);
	else	emit dialogClosed(this,true);
}

void option::launchHelp()
{
	kapp->invokeHTMLHelp("","option");
}

void option::closeEvent(QCloseEvent *)
{
	if (ismodal) done(0);
	else	emit dialogClosed(this,false);
}

void option::setMaxL(int m)
{
char help[64];

	sprintf(help,"%d",m);
	le1->setText(help);
}

void option::setActionCode(int n)
{
	com1->setCurrentItem(n);
}

int option::getMaxL()
{
	return(atoi(le1->text()));
}

int option::actionCode()
{
	return(com1->currentItem());
}

#include "option.moc"



