#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>

#include "fakebuttons.h"

FakeButton::FakeButton(QWidget *parent, char *Name)
{
  frame = new QFrame(parent);
  frame->setLineWidth(2);
  frame->setFrameStyle(QFrame::WinPanel|QFrame::Raised);
  label = new QLabel(parent,Name);
  label->setAlignment(AlignCenter);
}

void FakeButton::setGeometry(int x, int y, int w, int h)
{
  frame->setGeometry(x,y,w,h);
  frame->setFrameStyle(QFrame::WinPanel|QFrame::Raised);
  label->setGeometry(x+5,y+2,w-10,h-4);
}

void FakeButton::setText(const char *text)
{
  label->setText(text);
}

void FakeButton::move(int x, int y)
{
  frame->move(x,y);
  label->move(x+5,y+2);
}

int FakeButton::x()
{
  return frame->x();
}

int FakeButton::y()
{
  return frame->y();
}
