//**************************************************************************
//                        mixedsettingswidget.cpp  -  description
//                           -------------------
//  begin                : Sat Sep 30 2000
//  copyright            : (C) 2000 by Bjrn Sahlstrm
//  email                : bjorn@kbear.org
//**************************************************************************/

//**************************************************************************
//                                                                         *
//   This program is free software; you can redistribute it and/or modify  *
//   it under the terms of the GNU General Public License as published by  *
//   the Free Software Foundation; either version 2 of the License, or     *
//   (at your option) any later version.                                   *
//                                                                         *
//**************************************************************************/
#include "mixedsettingswidget.h"

//-----------------------------------------------
MixedSettingsWidget::MixedSettingsWidget(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	QWhatsThis::add(p_autoResumeCheckBox,i18n("Check this if you want autoresume to be turned on"));
	QWhatsThis::add(p_startPageLineEdit,i18n("Enter the webpage you want to be the defult page when entering Konqueror from KBear."));
	QWhatsThis::add(p_confirmExitCheckBox,i18n("Check this option if you want the application\nto check if there are acitve transfers,\nand if so, ask for confirmation before exiting."));
	QWhatsThis::add(p_queueTransferCheckBox,i18n("Check this option if you want to queue the transfers.\n\nThis means that there will be only one active transfer at a time, and the next will not start until the first is done."));
	QWhatsThis::add(p_emailLineEdit, i18n("Enter the email adress you want to use as password on anonymous servers."));
}
//-----------------------------------------------
MixedSettingsWidget::~MixedSettingsWidget(){
}
//-----------------------------------------------
QString MixedSettingsWidget::defaultWebPage(){
	return p_startPageLineEdit->text();
}
//-----------------------------------------------
QString MixedSettingsWidget::defaultEmail(){
	return p_emailLineEdit->text();
}
//-----------------------------------------------
void MixedSettingsWidget::setDefaultWebPage( const QString& page ){
	p_startPageLineEdit->setText( page );
}
//-----------------------------------------------
void MixedSettingsWidget::setDefaultEmail( const QString& email ){
	p_emailLineEdit->setText( email );
}
//-----------------------------------------------
