var negativeZero = Math.atan2(-1, Infinity); // ### any nicer way?

function isNegativeZero(n)
{
  return n == 0 && 1 / n < 0;
}

// self tests
shouldBeTrue("isNegativeZero(negativeZero)");
shouldBeFalse("isNegativeZero(0)");

// Constants
shouldBe("String()+Math.E", "'2.718281828459045'");
shouldBe("String()+Math.LN2", "'0.6931471805599453'");
shouldBe("String()+Math.LN10", "'2.302585092994046'");
shouldBe("String()+Math.LOG2E", "'1.4426950408889634'");
shouldBe("String()+Math.LOG10E", "'0.43429448190325176'");
shouldBe("String()+Math.PI", "'3.141592653589793'");
shouldBe("String()+Math.SQRT1_2", "'0.7071067811865476'");
shouldBe("String()+Math.SQRT2", "'1.4142135623730951'");

shouldBe("String()+Number.NaN", "'NaN'");
shouldBe("String()+Number.NEGATIVE_INFINITY", "'-Infinity'");
shouldBe("String()+Number.POSITIVE_INFINITY", "'Infinity'");

// Functions
shouldBe("Math.abs(-5)", "5");
shouldBe("Math.acos(0)", "Math.PI/2");
shouldBe("Math.acos(1)", "0");
shouldBe("Math.ceil(1.1)", "2");
shouldBe("String()+Math.sqrt(2)", "String()+Math.SQRT2");
shouldBe("Math.ceil(1.6)", "2");
shouldBe("Math.round(0)", "0");
shouldBeFalse("isNegativeZero(Math.round(0))");
shouldBeTrue("isNegativeZero(Math.round(negativeZero))");
shouldBe("Math.round(0.2)", "0");
shouldBeTrue("isNegativeZero(Math.round(-0.2))");
shouldBeTrue("isNegativeZero(Math.round(-0.5))");
shouldBe("Math.round(1.1)", "1");
shouldBe("Math.round(1.6)", "2");
shouldBe("Math.round(-3.5)", "-3");
shouldBe("Math.round(-3.6)", "-4");
shouldBeTrue("isNaN(Math.round())");
shouldBeTrue("isNaN(Math.round(NaN))");
shouldBe("Math.round(-Infinity)", "-Infinity");
shouldBe("Math.round(Infinity)", "Infinity");
shouldBe("Math.round(99999999999999999999.99)", "100000000000000000000");
shouldBe("Math.round(-99999999999999999999.99)", "-100000000000000000000");

// Math.log()
shouldBe("Math.log(Math.E*Math.E)", "2");
shouldBeTrue("isNaN(Math.log(NaN))");
shouldBeTrue("isNaN(Math.log(-1))");
shouldBeFalse("isFinite(Math.log(0))");
shouldBe("Math.log(1)", "0");
shouldBeFalse("isFinite(Math.log(Infinity))");

// Math.min()
shouldBeTrue("Math.min() > 0");
shouldBe("Math.min(1)", "1");
shouldBe("Math.min(2, 1)", "1");
shouldBe("Math.min(3, 2, 1)", "1");
shouldBeTrue("isNaN(Math.min(1,NaN,3))");
shouldBeTrue("isNegativeZero(Math.min(negativeZero))");
shouldBeTrue("isNegativeZero(Math.min(negativeZero, 0))");

// Math.max()
shouldBeFalse("isFinite(Math.max())");
shouldBeTrue("Math.max() < 0");
shouldBe("Math.max(1)", "1"); // NS 4.x and IE 5.x seem to know about 2 arg version only
shouldBe("Math.max(1, 2, 3)", "3"); // NS 4.x and IE 5.x seem to know about 2 arg version only
shouldBeTrue("isNaN(Math.max(1,NaN,3))");
shouldBeTrue("isNegativeZero(Math.max(negativeZero))");
shouldBeTrue("!isNegativeZero(Math.max(negativeZero, 0))");


list=""
for ( var i in Math ) { list += i + ','; }
shouldBe("list","''");

var my = new Object;
my.v = 1;

// Deleting/assigning
shouldBe("delete my.v", "true")
shouldBeUndefined("my.v");
shouldBe("delete Math.PI", "false")
function myfunc( num ) { return num+1; }
shouldBe("my = myfunc, myfunc(4)", "5");

// Conversions
shouldBe("Boolean(Math)", "true");
shouldBeTrue("isNaN(Number(Math));");

// Unicity
shouldBe("Math.abs===Math.abs", "true")
shouldBe("Math.abs===Math.round", "false")

// Iteration
obj = new Object;
obj.a = 1;
obj.b = 2;
list=""
for ( var i in obj ) { list += i + ','; }
shouldBe("list","'a,b,'");

// (check that Math's properties and functions are not enumerable)
list=""
for ( var i in Math ) { list += i + ','; }
shouldBe("list","''");

Math.myprop=true; // adding a custom property to the math object (why not?)
list=""
for ( var i in Math ) { list += i + ','; }
shouldBe("list","'myprop,'");

