/*
  This file is part of the kcalutils library.

  SPDX-FileCopyrightText: 1998 Preston Brown <pbrown@kde.org>
  SPDX-FileCopyrightText: 2001-2003 Cornelius Schumacher <schumacher@kde.org>

  SPDX-License-Identifier: LGPL-2.0-or-later
*/
#ifndef KCALUTILS_ICALDRAG_H
#define KCALUTILS_ICALDRAG_H

#include "kcalutils_export.h"

#include <KCalendarCore/MemoryCalendar>

class QMimeData;

namespace KCalUtils {
/**
  iCalendar drag&drop class.
*/
namespace ICalDrag {
/**
  Mime-type of iCalendar
*/
Q_REQUIRED_RESULT KCALUTILS_EXPORT QString mimeType();

/**
  Sets the iCalendar representation as data of the drag object
*/
Q_REQUIRED_RESULT KCALUTILS_EXPORT bool populateMimeData(QMimeData *e, const KCalendarCore::MemoryCalendar::Ptr &cal);

/**
  Return, if drag&drop object can be decode to iCalendar.
*/
Q_REQUIRED_RESULT KCALUTILS_EXPORT bool canDecode(const QMimeData *);

/**
  Decode drag&drop object to iCalendar component \a cal.
*/
Q_REQUIRED_RESULT KCALUTILS_EXPORT bool fromMimeData(const QMimeData *e, const KCalendarCore::MemoryCalendar::Ptr &cal);
}
}

#endif
